/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.attributes.X501Attribute;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.io.Serializable;
import java.util.Vector;

public class SubjectDirectoryAttributes
extends X509V3Extension
implements Cloneable,
Serializable,
CertExtension {
    private Vector a = new Vector();
    ASN1Template b;

    public SubjectDirectoryAttributes() {
        this.extensionTypeFlag = 9;
        this.criticality = false;
        this.setStandardOID(9);
        this.extensionTypeString = "SubjectDirectoryAttributes";
    }

    public SubjectDirectoryAttributes(X501Attribute x501Attribute, boolean bl2) {
        this.extensionTypeFlag = 9;
        this.criticality = bl2;
        this.setStandardOID(9);
        if (x501Attribute != null) {
            this.a.addElement(x501Attribute);
        }
        this.extensionTypeString = "SubjectDirectoryAttributes";
    }

    public void addAttribute(X501Attribute x501Attribute) {
        if (x501Attribute != null) {
            this.a.addElement(x501Attribute);
        }
    }

    public X501Attribute getAttributes(int n2) throws CertificateException {
        if (n2 < this.a.size()) {
            return (X501Attribute)this.a.elementAt(n2);
        }
        throw new CertificateException("Invalid Index");
    }

    public int getAttributesCount() {
        return this.a.size();
    }

    public void decodeValue(byte[] byArray, int n2) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            OfContainer ofContainer = new OfContainer(0, 12288, new EncodedContainer(12288));
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
            int n3 = ofContainer.getContainerCount();
            if (n3 > 0) {
                this.a = new Vector();
            }
            for (int i2 = 0; i2 < n3; ++i2) {
                ASN1Container aSN1Container = ofContainer.containerAt(i2);
                X501Attribute x501Attribute = X501Attribute.getInstance(aSN1Container.data, aSN1Container.dataOffset, 0);
                this.a.addElement(x501Attribute);
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Could not decode SubjectDirectoryAttributes extension.");
        }
        catch (AttributeException attributeException) {
            throw new CertificateException("Could not decode SubjectDirectoryAttributes extension.");
        }
    }

    public int derEncodeValueInit() {
        try {
            OfContainer ofContainer = new OfContainer(0, true, 0, 12288, new EncodedContainer(12288));
            int n2 = 0;
            if (this.a != null) {
                n2 = this.a.size();
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                X501Attribute x501Attribute = (X501Attribute)this.a.elementAt(i2);
                int n3 = x501Attribute.getDERLen(0);
                byte[] byArray = new byte[n3];
                n3 = x501Attribute.getDEREncoding(byArray, 0, 0);
                EncodedContainer encodedContainer = new EncodedContainer(12288, true, 0, byArray, 0, n3);
                ofContainer.addContainer(encodedContainer);
            }
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            this.b = new ASN1Template(aSN1ContainerArray);
            return this.b.derEncodeInit();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] byArray, int n2) {
        if (byArray == null) {
            return 0;
        }
        if (this.b == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int n3 = this.b.derEncode(byArray, n2);
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SubjectDirectoryAttributes subjectDirectoryAttributes = new SubjectDirectoryAttributes();
        subjectDirectoryAttributes.a = (Vector)this.a.clone();
        if (this.b != null) {
            subjectDirectoryAttributes.derEncodeValueInit();
        }
        super.copyValues(subjectDirectoryAttributes);
        return subjectDirectoryAttributes;
    }

    protected void reset() {
        super.reset();
        this.a = new Vector();
    }
}

