/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.validator;

import com.adobe.air.validator.ApplicationDescriptorValidator;
import com.adobe.air.validator.ApplicationDescriptorValidator153;
import com.adobe.air.validator.DescriptorValidator;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationDescriptorValidator20
extends ApplicationDescriptorValidator153 {
    private Set<String> _validAspectRatios = new HashSet<String>();
    private Set<String> _validProfiles = new HashSet<String>();
    private Set<String> _validRenderModes = new HashSet<String>();
    private String _infoAdditions;
    private boolean _fullScreen;
    private String _aspectRatio;
    private String _renderMode = "auto";
    private Boolean _autoOrients;
    private Set<String> _supportedProfiles = this._validProfiles;

    public ApplicationDescriptorValidator20() {
        this._validProfiles.add("desktop");
        this._validProfiles.add("extendedDesktop");
        this._validProfiles.add("mobileDevice");
        this._validProfiles.add("extendedMobileDevice");
        this._validAspectRatios.add("portrait");
        this._validAspectRatios.add("landscape");
        this._validRenderModes.add("auto");
        this._validRenderModes.add("cpu");
        this._validRenderModes.add("gpu");
        this._validRenderModes.add("direct");
    }

    @Override
    protected DescriptorValidator.ElementInfo createElementInfoTree() {
        DescriptorValidator.ElementInfo root = super.createElementInfoTree();
        root.addChild(new DescriptorValidator.ElementInfo("supportedProfiles", 0, 1));
        DescriptorValidator.ElementInfo temp = root.getChild("supportedProfiles");
        temp.contentTypeMixed = true;
        temp.addChild(new DescriptorValidator.ElementInfo("text", 0, -1));
        temp = temp.getChild("text");
        temp.addAttribute(new DescriptorValidator.AttributeInfo("xml:lang", true));
        temp = root.getChild("initialWindow");
        temp.addChild(new DescriptorValidator.ElementInfo("aspectRatio", 0, 1));
        temp.addChild(new DescriptorValidator.ElementInfo("autoOrients", 0, 1));
        temp.addChild(new DescriptorValidator.ElementInfo("fullScreen", 0, 1));
        temp.addChild(new DescriptorValidator.ElementInfo("renderMode", 0, 1));
        temp = root.getChild("fileTypes").getChild("fileType").getChild("icon");
        temp.addChild(new DescriptorValidator.ElementInfo("image29x29", 0, 1));
        temp.addChild(new DescriptorValidator.ElementInfo("image512x512", 0, 1));
        temp = root.getChild("icon");
        temp.addChild(new DescriptorValidator.ElementInfo("image29x29", 0, 1));
        temp.addChild(new DescriptorValidator.ElementInfo("image57x57", 0, 1));
        temp.addChild(new DescriptorValidator.ElementInfo("image72x72", 0, 1));
        temp.addChild(new DescriptorValidator.ElementInfo("image512x512", 0, 1));
        root.addChild(new DescriptorValidator.ElementInfo("iPhone", 0, 1));
        temp = root.getChild("iPhone");
        temp.addChild(new DescriptorValidator.ElementInfo("InfoAdditions", 0, 1));
        return root;
    }

    @Override
    protected boolean validateElement(String elementPath, String value) {
        boolean valid = super.validateElement(elementPath, value);
        if (elementPath.equals("application.initialWindow.fullScreen")) {
            valid = ApplicationDescriptorValidator.validateBooleanType(value);
            this._fullScreen = ApplicationDescriptorValidator20.evaluateBooleanType(value);
        }
        if (elementPath.equals("application.initialWindow.aspectRatio")) {
            valid = this._validAspectRatios.contains(value);
            this._aspectRatio = value;
        }
        if (elementPath.equals("application.initialWindow.autoOrients")) {
            valid = ApplicationDescriptorValidator.validateBooleanType(value);
            this._autoOrients = ApplicationDescriptorValidator20.evaluateBooleanType(value);
        }
        if (elementPath.equals("application.initialWindow.renderMode")) {
            valid = this._validRenderModes.contains(value);
            this._renderMode = value;
        }
        if (elementPath.equals("application.supportedProfiles")) {
            this._supportedProfiles = new HashSet<String>();
            String[] list = value.split("\\s+");
            valid = list.length > 0;
            for (int i2 = 0; i2 < list.length; ++i2) {
                if (this._supportedProfiles.contains(list[i2]) || !this._validProfiles.contains(list[i2])) {
                    valid = false;
                    break;
                }
                this._supportedProfiles.add(list[i2]);
            }
        }
        if (elementPath.equals("application.icon.image29x29") || elementPath.equals("application.icon.image57x57") || elementPath.equals("application.icon.image72x72") || elementPath.equals("application.icon.image512x512")) {
            int size = this.getIntFromIconSize(elementPath);
            String imageUri = this.validateImageUri(value, size, size);
            valid = imageUri != null;
            this._appIcons.put(this.getIntFromIconSize(elementPath), imageUri);
        }
        if (elementPath.equals("application.fileTypes.fileType.icon.image29x29") || elementPath.equals("application.fileTypes.fileType.icon.image512x512")) {
            int size = this.getIntFromIconSize(elementPath);
            String imageUri = this.validateImageUri(value, size, size);
            boolean bl2 = valid = imageUri != null;
        }
        if (elementPath.equals("application.iPhone.InfoAdditions")) {
            String infoAdditionsPList = "<plist><dict>" + value + "</dict></plist>";
            valid = this.validatePListString(infoAdditionsPList);
            this._infoAdditions = value;
        }
        return valid;
    }

    @Override
    protected String getNamespace() {
        return "http://ns.adobe.com/air/application/2.0";
    }

    protected Set<String> getValidProfiles() {
        return this._validProfiles;
    }

    public String infoAdditions() {
        return this._infoAdditions;
    }

    public boolean fullScreen() {
        return this._fullScreen;
    }

    public String aspectRatio() {
        return this._aspectRatio;
    }

    public String renderMode() {
        return this._renderMode;
    }

    public Boolean autoOrients() {
        return this._autoOrients;
    }

    public Set<String> supportedProfiles() {
        return this._supportedProfiles;
    }
}

