/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.nai;

import com.adobe.air.ApplicationDescriptor;
import com.adobe.air.Plist;
import com.adobe.air.SDKDamagedException;
import com.adobe.air.Utils;
import com.adobe.air.nai.MacPackager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;

public class AppBundlePackager
extends MacPackager {
    private static final String BUNDLE_DOCUMENT_TYPES = "CFBundleDocumentTypes";
    private static final String BUNDLE_TYPE_EXTENSIONS = "CFBundleTypeExtensions";

    protected ApplicationDescriptor.ValidationParams getValidationParams(ApplicationDescriptor appDescriptor) {
        return BUNDLE_VALIDATION_PARAMS;
    }

    protected void assembleInternalFiles() throws IOException, SDKDamagedException {
        File captiveAppEntry = new File(this.getNAISDKLibDir(), "CaptiveAppEntry");
        if (!captiveAppEntry.exists()) {
            throw new SDKDamagedException(captiveAppEntry.getPath());
        }
        File appEntry = new File(this.m_conversionOutput, "Contents/MacOS/" + this.m_appName);
        Utils.deleteAll(appEntry);
        this.copyWithPermissions(captiveAppEntry, appEntry);
        File captiveRuntime = new File(Utils.getSDKRuntimesDir(), "air-captive/mac/Adobe AIR.framework");
        File appFrameworks = new File(this.m_conversionOutput, "Contents/Frameworks");
        appFrameworks.mkdirs();
        this.copyWithPermissions(captiveRuntime, appFrameworks);
        File infoPlistFile = new File(this.m_conversionOutput, "Contents/Info.plist");
        Plist plist = Plist.newFromFile(infoPlistFile);
        Plist.DictionaryNode dict = plist.getRootDictionary();
        boolean removedDummyFiletype = false;
        Plist.PlistNode documentTypesNode = dict.getNode(BUNDLE_DOCUMENT_TYPES);
        if (documentTypesNode != null && documentTypesNode instanceof Plist.ArrayNode) {
            Plist.ArrayNode documentTypesArray = (Plist.ArrayNode)documentTypesNode;
            for (int i2 = 0; i2 < documentTypesArray.nodeCount(); ++i2) {
                Plist.ArrayNode typeExtensionsArray;
                Plist.DictionaryNode documentTypesDict;
                Plist.PlistNode typeExtensionsNode;
                if (!(documentTypesArray.getNode(i2) instanceof Plist.DictionaryNode) || (typeExtensionsNode = (documentTypesDict = (Plist.DictionaryNode)documentTypesArray.getNode(i2)).getNode(BUNDLE_TYPE_EXTENSIONS)) == null || !(typeExtensionsNode instanceof Plist.ArrayNode) || (typeExtensionsArray = (Plist.ArrayNode)typeExtensionsNode).nodeCount() != 1 || !typeExtensionsArray.getNode(0).equals(new Plist.StringNode("airapplication"))) continue;
                documentTypesArray.removeNode(i2);
                removedDummyFiletype = true;
                break;
            }
            if (documentTypesArray.nodeCount() == 0) {
                dict.removeNode(BUNDLE_DOCUMENT_TYPES);
            }
        }
        if (!removedDummyFiletype) {
            throw new IllegalStateException("Got an invalid plist back from naip");
        }
        Utils.writeOut(new ByteArrayInputStream(plist.getXMLString().getBytes("UTF-8")), infoPlistFile);
    }

    protected void signInternalFiles() throws IOException, SDKDamagedException, GeneralSecurityException {
    }

    protected void createFinalPackage() throws IOException, SDKDamagedException {
    }

    protected void signFinalPackage() throws IOException, SDKDamagedException, GeneralSecurityException {
    }

    protected void finalizePackage() throws IOException {
        if (this.getOutput().exists()) {
            Utils.deleteAll(this.getOutput());
        }
        this.m_conversionOutput.renameTo(this.getOutput());
    }
}

