/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.ipa;

import adobe.abc.APIVersions;
import adobe.abc.LLVMEmitter;
import adobe.abc.LLVMEmitterOptions;
import com.adobe.air.InvalidInputException;
import com.adobe.air.Listener;
import com.adobe.air.SDKDamagedException;
import com.adobe.air.Utils;
import com.adobe.air.ipa.AOTCompilerOptions;
import com.adobe.air.ipa.ProcessError;
import com.adobe.ucf.Utils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Vector;
import llvm.Function;
import llvm.FunctionPassManager;
import llvm.Function_vector;
import llvm.GlobalValue;
import llvm.GlobalValue_vector;
import llvm.GlobalVariable;
import llvm.GlobalVariable_vector;
import llvm.JNIStringRef;
import llvm.LLVM;
import llvm.LLVMContext;
import llvm.Level;
import llvm.Linker;
import llvm.MemoryBuffer;
import llvm.Module;
import llvm.Pass;
import llvm.PassManager;
import llvm.StringRef;
import llvm.Target;
import llvm.TargetData;
import llvm.TargetMachine;
import llvm.TargetRegistry;
import llvm.Twine;
import llvm.formatted_raw_ostream;
import llvm.raw_fd_ostream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AOTCompiler {
    private AOTCompilerOptions m_opts = null;
    private File m_strippedRootSWFFile = null;
    private Vector<File> m_asmFiles = new Vector();
    private Vector<File> m_macOFiles = new Vector();
    private File m_macExe = null;
    private String m_baseName = "AOTBuildOutput";
    private String m_targetArch = "arm";
    private String m_targetRuntime = "air";
    private boolean m_verbose = false;
    private boolean m_debugSDK = false;
    private boolean m_useCaptiveSdk = false;
    private boolean m_useNewTools = false;
    private int m_numstublibs = 10;
    private File m_tempFolder = null;
    private File m_outputFolder = null;
    private String m_captiveSdkRoot = null;
    private String m_platformSdkRoot = null;
    private Module m_module = null;
    private LLVMContext m_ctx = null;
    private File m_abcDir = null;
    private int m_apiVersion = APIVersions.kApiVersion_VM_INTERNAL;
    private int m_currStep;
    private int m_totalSteps;
    private Listener m_listener;
    private HashMap<String, String> m_tools = new HashMap();
    public Vector<File> m_abcFiles = new Vector();
    private static final String LIB_DIR = "/lib";
    private static final String BIN_DIR = "/bin";
    private static final String STUB_DIR = "/stub";
    private static final String DEFAULT_FRAMEWORK_DIR = "/System/Library/Frameworks/";
    private static final int WRITE_MODULE_BUFFER_SIZE = 262144;
    private static final int MAX_HEAP_MULTIPLIER = 8;
    private static final String MAP_FUNC_POINTER = "g_com_adobe_air_fre_fmap";

    private static ArrayList<String> createArgs(String ... args) {
        return new ArrayList<String>(Arrays.asList(args));
    }

    private static void appendArgs(ArrayList<String> args, String ... moreargs) {
        args.addAll(Arrays.asList(moreargs));
    }

    public void setListener(Listener listener) {
        this.m_listener = listener;
    }

    private static void checkAndReportMissingGPLComponent(String path) throws SDKDamagedException {
        if (!new File(path).exists()) {
            throw new SDKDamagedException(path, false, true);
        }
    }

    public AOTCompiler(AOTCompilerOptions options) throws IOException {
        this.m_opts = options;
        this.m_verbose = this.m_opts.verbosity > 0;
        this.m_outputFolder = new File(this.m_opts.outputPath);
        this.m_captiveSdkRoot = this.m_opts.airIosSdkRoot;
        try {
            int delim = this.m_opts.target.lastIndexOf(45);
            this.m_targetArch = this.m_opts.target.substring(0, delim);
            this.m_targetRuntime = this.m_opts.target.substring(delim + 1, this.m_opts.target.length());
        }
        catch (Exception e2) {
            throw new UnsupportedOperationException("Invalid target '" + this.m_opts.target + "'");
        }
        if (!(this.m_targetArch.equals("arm") || this.m_targetArch.equals("x86") || this.m_targetArch.equals("x86-simulator"))) {
            throw new UnsupportedOperationException("Unknown architechture '" + this.m_targetArch + "'");
        }
        if (!this.m_targetRuntime.equals("air") && !this.m_targetRuntime.equals("shell")) {
            throw new UnsupportedOperationException("Unknown runtime type '" + this.m_targetRuntime + "'");
        }
        if (this.m_opts.platformSdkRoot != null) {
            this.m_platformSdkRoot = this.m_opts.platformSdkRoot;
        } else if (this.m_targetArch.equals("arm")) {
            this.m_useCaptiveSdk = true;
        } else if (this.m_targetArch.equals("x86-simulator")) {
            this.m_platformSdkRoot = "${env.AIR_PATH_TO_SIMULATOR_SDK}";
        } else if (this.m_targetArch.equals("x86")) {
            this.m_platformSdkRoot = "/Developer/SDKs/MacOSX10.5.sdk";
        }
        if (this.m_opts.baseName != null) {
            this.m_baseName = this.m_opts.baseName;
        } else if (!this.m_opts.interpreter && this.m_targetRuntime.equals("shell")) {
            this.m_baseName = this.m_opts.shellAbcs.get(this.m_opts.shellAbcs.size() - 1).getName();
            this.m_baseName = this.m_baseName.substring(0, this.m_baseName.lastIndexOf(46));
        }
        this.m_opts.baseName = this.m_baseName;
        if (this.m_opts.tempFolder != null) {
            this.m_tempFolder = new File(this.m_opts.tempFolder);
        } else if (!this.m_opts.interpreter && this.m_targetRuntime.equals("shell")) {
            this.m_tempFolder = new File(this.m_outputFolder, this.m_baseName + ".tmp");
            this.m_tempFolder.mkdirs();
            for (File abcFile : this.m_opts.shellAbcs) {
                File f2 = new File(this.m_tempFolder, abcFile.getName());
                Utils.copyTo(abcFile, f2);
                this.m_abcFiles.add(f2);
            }
        } else {
            this.m_tempFolder = File.createTempFile(this.m_baseName, null, this.m_outputFolder);
            this.m_tempFolder.delete();
            this.m_tempFolder.mkdirs();
        }
        this.m_opts.tempFolder = this.m_tempFolder.getPath();
        this.m_abcDir = new File(this.m_tempFolder, "ABCFiles");
        this.m_abcDir.mkdir();
        String osName = System.getProperty("os.name");
        String exeSuffix = "";
        if (osName.contains("Windows")) {
            exeSuffix = ".exe";
        } else if (!osName.contains("Mac")) {
            throw new UnsupportedOperationException("Functionality not supported on : " + osName);
        }
        this.m_debugSDK = new File(this.m_opts.airIosSdkRoot + LIB_DIR + "/libavmplus." + this.m_opts.target + ".a").exists();
        this.m_tools.put("as", this.m_opts.airIosSdkRoot + BIN_DIR + "/as/" + (this.m_targetArch.equals("arm") ? "arm" : "i686") + "-apple-darwin9-as" + exeSuffix);
        boolean bl2 = this.m_useNewTools = !this.m_useCaptiveSdk && this.m_targetArch.equals("arm") && System.getProperty("os.name").contains("Mac") && !System.getProperty("os.version").contains("10.5");
        if (this.m_useNewTools) {
            this.m_tools.put("ld64", this.m_opts.airIosSdkRoot + BIN_DIR + "/ld64/i686-apple-darwin10-ld64");
            this.m_tools.put("strip", this.m_opts.airIosSdkRoot + BIN_DIR + "/strip/i686-apple-darwin10-strip");
        } else {
            this.m_tools.put("ld64", this.m_opts.airIosSdkRoot + BIN_DIR + "/ld64/i686-apple-darwin9-ld64" + exeSuffix);
            this.m_tools.put("strip", this.m_opts.airIosSdkRoot + BIN_DIR + "/strip/strip" + exeSuffix);
        }
        this.m_tools.put("builtin", this.m_opts.airIosSdkRoot + LIB_DIR + "/builtin.abc");
        this.m_tools.put("avmglue", this.m_opts.airIosSdkRoot + LIB_DIR + "/avmglue.abc");
        this.m_tools.put("bitcode.api", this.m_opts.airIosSdkRoot + LIB_DIR + "/bitcode.api." + this.m_opts.target + ".txt");
        this.m_tools.put("aotcompiler", this.m_opts.airIosSdkRoot + LIB_DIR + "/AOTCompiler." + this.m_opts.target + ".bc");
        for (int i2 = 0; i2 < this.m_numstublibs; ++i2) {
            this.m_tools.put("libaot" + i2, this.m_opts.airIosSdkRoot + LIB_DIR + "/libAOTCompiler" + String.format("%02d", i2) + "." + this.m_opts.target + ".bc.a");
        }
        this.m_tools.put("libavmplus", this.m_opts.airIosSdkRoot + LIB_DIR + "/libavmplus." + this.m_opts.target + (this.m_debugSDK ? ".a" : ".bc.a"));
        this.m_tools.put("libmmgc", this.m_opts.airIosSdkRoot + LIB_DIR + "/libMMgc." + this.m_opts.target + (this.m_debugSDK ? ".a" : ".bc.a"));
        AOTCompiler.checkAndReportMissingGPLComponent(this.m_tools.get("as"));
        AOTCompiler.checkAndReportMissingGPLComponent(this.m_opts.airIosSdkRoot + LIB_DIR + "/gcc/libgcc.a");
        if (this.m_targetRuntime.equals("air")) {
            this.m_tools.put("libruntimeaot", this.m_opts.airIosSdkRoot + LIB_DIR + "/libRuntimeAOT." + this.m_opts.target + ".a");
            this.m_tools.put("libdebugger1", this.m_opts.airIosSdkRoot + LIB_DIR + "/libDebugger1." + this.m_opts.target + ".a");
            this.m_tools.put("libnodebugger1", this.m_opts.airIosSdkRoot + LIB_DIR + "/libNoDebugger1." + this.m_opts.target + ".a");
            this.m_tools.put("libdebugger2", this.m_opts.airIosSdkRoot + LIB_DIR + "/libDebugger2." + this.m_opts.target + ".a");
            this.m_tools.put("libnodebugger2", this.m_opts.airIosSdkRoot + LIB_DIR + "/libNoDebugger2." + this.m_opts.target + ".a");
        }
        if (this.m_targetRuntime.equals("shell")) {
            this.m_tools.put("toplevel", this.m_opts.airIosSdkRoot + LIB_DIR + "/shell_toplevel.abc");
        }
        if (this.m_opts.interpreter) {
            this.m_tools.put("interpreter", this.m_opts.airIosSdkRoot + LIB_DIR + "/libRuntimeInterpreter." + this.m_opts.target + ".a");
        }
    }

    public void launchProcess(List<String> argv, String name, String msg, boolean displayProcessErrors) throws ProcessError, IOException {
        int retcode = this.launchProcess(argv, displayProcessErrors, true);
        if (retcode != 0) {
            throw new ProcessError(name, msg, retcode);
        }
    }

    public void launchProcess(List<String> argv, String name, String msg, boolean displayProcessErrors, boolean quoteArgs) throws ProcessError, IOException {
        int retcode = this.launchProcess(argv, displayProcessErrors, quoteArgs);
        if (retcode != 0) {
            throw new ProcessError(name, msg, retcode);
        }
    }

    private int launchProcess(List<String> argv, boolean displayProcessErrors, boolean quoteArgs) throws IOException {
        if (this.m_verbose) {
            for (String arg : argv) {
                System.out.print(arg + " ");
            }
            System.out.println("");
        }
        if (this.m_opts.dryRun) {
            return 0;
        }
        int retCode = 1;
        try {
            Process rProcess = Utils.execSafely(this.m_tempFolder, argv, quoteArgs);
            Utils.OutputEater consumeInput = new Utils.OutputEater(rProcess.getInputStream());
            Utils.OutputEater consumeErr = new Utils.OutputEater(rProcess.getErrorStream(), this.m_verbose || displayProcessErrors ? System.out : null);
            consumeInput.start();
            consumeErr.start();
            retCode = rProcess.waitFor();
            consumeInput.join();
            consumeErr.join();
        }
        catch (InterruptedException e2) {
            retCode = 0;
        }
        return retCode;
    }

    public File getNewTempFile(String path) throws IOException {
        File rFile = new File(this.m_tempFolder, path);
        if (rFile.exists()) {
            rFile.delete();
        }
        rFile.createNewFile();
        return rFile;
    }

    protected void dumpBitcode(String name) throws IOException {
        this.dumpBitcode(name, this.m_module);
    }

    protected void dumpBitcode(String name, Module m2) throws IOException {
        if (this.m_opts.verbosity > 3) {
            System.out.println("# Verifying bitcode...");
            LLVM.verifyModule(m2);
            this.writeBitcode(name, m2);
        }
    }

    protected File writeBitcode(String name, Module m2) throws IOException {
        File generatedBitcode = this.getNewTempFile(name);
        if (this.m_opts.verbosity > 0) {
            System.out.println("# Writing bitcode: " + generatedBitcode.getCanonicalPath());
        }
        LLVM.WriteModuleToFile(generatedBitcode.getCanonicalPath(), m2, 262144L);
        return generatedBitcode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Module readBitcode(File f2) throws IOException {
        MemoryBuffer buff = null;
        try {
            buff = MemoryBuffer.getFile(new JNIStringRef(f2.getCanonicalPath()));
            assert (buff != null);
            Module module = LLVM.ParseBitcodeFile(buff, this.m_ctx);
            return module;
        }
        finally {
            buff.delete();
        }
    }

    protected void moveAbcsToSubDir() throws IOException {
        for (File f2 : this.m_abcFiles) {
            if (f2.renameTo(new File(this.m_abcDir, f2.getName()))) continue;
            throw new IOException("Couldn't move " + f2.getName());
        }
    }

    protected void convertRootSwfToAbc() throws InvalidInputException, IOException, ProcessError {
        if (this.m_targetRuntime.equals("shell")) {
            return;
        }
        this.m_strippedRootSWFFile = this.getNewTempFile(this.m_baseName + "-stripped.swf");
        File serFile = this.getNewTempFile("SWFSplitter_opts.ser");
        ArrayList<String> args = AOTCompiler.createArgs("com.adobe.air.ipa.SWFSplitter", AOTCompiler.writeObject(this.m_opts, serFile), this.m_strippedRootSWFFile.toString(), this.m_abcDir.getPath());
        this.invokeADT(256, 1024, null, args.toArray(new String[0]));
        serFile.delete();
    }

    protected void convertAbcToLlvmBitcode() throws IOException, ProcessError {
        this.moveAbcsToSubDir();
        File serFile = this.getNewTempFile("BitcodeGenerator_opts.ser");
        ArrayList<String> args = AOTCompiler.createArgs("com.adobe.air.ipa.BitcodeGenerator", AOTCompiler.writeObject(this.m_opts, serFile), this.m_abcDir.getPath());
        this.invokeADT(256, 1024, this.m_opts.stackSize, args.toArray(new String[0]));
        serFile.delete();
        LLVMEmitter.loadJNI();
        this.m_ctx = new LLVMContext();
        this.m_module = this.readBitcode(new File(this.m_tempFolder, this.m_baseName + ".bc"));
        this.LogTiming("readBitcode");
    }

    protected void convertAbcToLlvmBitcodeImpl() throws IOException, ProcessError {
        System.gc();
        if (this.m_verbose) {
            System.out.println("# Generating bitcode...");
        }
        LLVMEmitterOptions opts = new LLVMEmitterOptions();
        opts.useARMCallingConvention = this.m_targetArch.equals("arm");
        opts.debugger = this.m_opts.debugger;
        opts.runtimeDebugging = this.m_opts.debugRuntime;
        opts.debugBuiltins = this.m_opts.debugBuiltins;
        opts.optLevel = this.m_opts.optLevel;
        opts.disableLazyEval = !this.m_useCaptiveSdk;
        opts.apiVersion = this.m_apiVersion;
        opts.runtimeBitcode = new File(this.m_tools.get("aotcompiler"));
        opts.logPerf = this.shouldLogPerf();
        opts.builtInABCs.add(this.m_tools.get("builtin"));
        opts.builtInABCs.add(this.m_targetRuntime.equals("shell") ? this.m_tools.get("toplevel") : this.m_tools.get("avmglue"));
        long abcFileSize = 0L;
        for (File abcFile : this.m_abcFiles) {
            opts.appABCs.add(abcFile.getPath());
            if (!this.shouldLogPerf()) continue;
            abcFileSize += abcFile.length();
        }
        this.LogPerfMsg("numABCFiles " + this.m_abcFiles.size());
        this.LogPerfMsg("ABCFileSize " + abcFileSize);
        if (this.m_opts.extensionAbcs != null) {
            for (File extAbc : this.m_opts.extensionAbcs) {
                opts.appABCs.add(extAbc.getAbsolutePath());
            }
        }
        this.m_module = LLVMEmitter.generateBitcode(opts, false);
        this.m_ctx = this.m_module.getContext();
        if (this.m_opts.verbosity > 2) {
            System.out.println("# Generating stub stats...");
            HashMap<String, Integer> stats = new HashMap<String, Integer>();
            Function_vector funcs = LLVM.toVector(this.m_module.getFunctionList());
            int size = (int)funcs.size();
            for (int i2 = 0; i2 < size; ++i2) {
                Function fn = funcs.get(i2);
                String fname = fn.getName().data();
                if (fname.indexOf("abcOP_") < 0) continue;
                stats.put(fname, (int)fn.getNumUses());
            }
            try {
                File file = this.getNewTempFile(this.m_baseName + ".stats.txt");
                BufferedWriter writer = new BufferedWriter(new FileWriter(file));
                for (String k2 : stats.keySet()) {
                    writer.write(k2 + " | " + stats.get(k2) + "\n");
                }
                writer.flush();
                writer.close();
            }
            catch (IOException e2) {
                System.out.println("# Generating stub stats... FAILED");
            }
        }
        this.LogTiming("Generating_Bitcode");
        this.writeBitcode(this.m_baseName + ".bc", this.m_module);
        this.LogTiming("Write_Bitcode");
    }

    protected void generateExtensionsGlue() throws IOException, ProcessError {
        Module module = null;
        if (this.m_opts.exportedSymbols != null) {
            if (this.m_verbose) {
                System.out.println("# Generating extensions glue...");
            }
            if ((module = LLVMEmitter.generateSymbolToFunctionPtrMap(MAP_FUNC_POINTER, this.m_targetArch.equals("arm"), this.m_opts.exportedSymbols)) == null) {
                throw new IOException("Failed to generate extensions glue");
            }
            this.compileBitcode(module, "extensionglue");
        }
    }

    protected void linkBitcodeFiles() throws IOException, ProcessError {
        System.gc();
        if (this.m_verbose) {
            System.out.println("# Linking bitcode libraries...");
        }
        Linker lnk = new Linker((StringRef)new JNIStringRef("jni-llvm-ld"), this.m_module, this.m_verbose ? 1L : 0L);
        for (int i2 = 0; i2 < this.m_numstublibs; ++i2) {
            lnk.LinkInArchive(this.m_tools.get("libaot" + i2));
        }
        if (!this.m_debugSDK) {
            lnk.LinkInFile(this.m_tools.get("libavmplus"));
            lnk.LinkInFile(this.m_tools.get("libmmgc"));
        }
        this.m_module = lnk.releaseModule();
        lnk.delete();
        Function f2 = this.m_module.getFunction(new JNIStringRef("_ZNK7avmplus10PoolObject9getStringEi"));
        if (f2 == null && this.m_verbose) {
            System.out.println("Failed to find PoolObject->getString()...");
        } else {
            f2.setOnlyReadsMemory(true);
        }
        this.dumpBitcode(this.m_baseName + "-01-linked.bc");
    }

    protected void extractGlobals(Module m2, String name, GlobalValue_vector gvs) throws IOException {
        System.gc();
        if (this.m_verbose) {
            System.out.println("# extracting " + gvs.size() + " globals");
        }
        PassManager pm = new PassManager();
        TargetData td = new TargetData(m2);
        pm.add(td);
        pm.add(LLVM.createGVExtractionPass(gvs, false, false));
        pm.add(LLVM.createGlobalDCEPass());
        pm.add(LLVM.createDeadTypeEliminationPass());
        pm.add(LLVM.createStripDeadPrototypesPass());
        pm.run(m2);
        pm.delete();
        GlobalVariable gv = m2.getGlobalVariable(new JNIStringRef("llvm.used1"));
        if (gv != null) {
            gv.eraseFromParent();
        }
        int i2 = 0;
        while ((long)i2 < gvs.size()) {
            GlobalValue gval = gvs.get(i2);
            if (gval.hasInternalLinkage()) {
                gval.setLinkage(GlobalValue.LinkageTypes.ExternalLinkage);
            }
            ++i2;
        }
        GlobalVariable_vector globals = LLVM.toVector(m2.getGlobalList());
        int i3 = 0;
        while ((long)i3 < globals.size()) {
            GlobalVariable global = globals.get(i3);
            if (global.hasInternalLinkage()) {
                global.setLinkage(GlobalValue.LinkageTypes.ExternalLinkage);
                global.setInitializer(null);
            }
            ++i3;
        }
        globals.delete();
        this.dumpBitcode(this.m_baseName + name + ".bc", m2);
    }

    protected void splitBitcode() throws IOException, ProcessError {
        int i2;
        if (this.m_opts.moduleSplitLimit < 0) {
            if (this.m_verbose) {
                System.out.println("Not splitting the bitcode");
            }
            this.compileBitcode(this.m_module, this.m_baseName + "-0");
            return;
        }
        if (this.m_verbose) {
            System.out.println("# splitting Bitcode, split size = " + this.m_opts.moduleSplitLimit);
        }
        GlobalVariable_vector globals = LLVM.toVector(this.m_module.getGlobalList());
        int unnamedCount = 0;
        int i3 = 0;
        while ((long)i3 < globals.size()) {
            GlobalVariable gv = globals.get(i3);
            if (!gv.hasName()) {
                gv.setName(new Twine(new JNIStringRef("unnamedglobal_" + unnamedCount++)));
            }
            if (gv.hasInternalLinkage() || gv.hasPrivateLinkage()) {
                gv.setLinkage(GlobalValue.LinkageTypes.ExternalLinkage);
            }
            ++i3;
        }
        globals.delete();
        Function_vector funcs = LLVM.toVector(this.m_module.getFunctionList());
        int size = (int)funcs.size();
        assert (this.m_opts.moduleSplitLimit >= 0);
        int moduleFunctionLimit = this.m_opts.moduleSplitLimit == 0 ? 10000 : this.m_opts.moduleSplitLimit;
        for (int i4 = 0; i4 < size; ++i4) {
            Function f2 = funcs.get(i4);
            String fName = f2.getName().data();
            if (fName.startsWith("_Unwind_SjLj")) {
                f2.deleteBody();
                continue;
            }
            if (this.m_debugSDK && (fName.startsWith("_ZNK7avmplus8ListImpl") || fName.startsWith("_ZNK7avmplus18MultinameHashtableI"))) {
                f2.deleteBody();
                continue;
            }
            if (!f2.hasInternalLinkage()) continue;
            f2.setLinkage(GlobalValue.LinkageTypes.ExternalLinkage);
        }
        File baseBitcode = this.writeBitcode(this.m_baseName + "-all.bc", this.m_module);
        this.LogTiming("WriteAllBitcode");
        Function_vector funcsToExternalise = new Function_vector();
        for (i2 = 0; i2 < size; ++i2) {
            Function f3 = funcs.get(i2);
            if (!f3.getName().data().startsWith("abcMethod")) continue;
            funcsToExternalise.add(f3);
        }
        i2 = 0;
        while ((long)i2 < funcsToExternalise.size()) {
            funcsToExternalise.get(i2).deleteBody();
            ++i2;
        }
        funcs.delete();
        funcsToExternalise.delete();
        this.dumpBitcode(this.m_baseName + "-split-0.bc", this.m_module);
        this.compileBitcode(this.m_module, this.m_baseName + "-0");
        this.LogTiming("CompileAndAssembleBitcode-0");
        this.m_module.dropAllReferences();
        this.m_module.delete();
        this.m_ctx.delete();
        int moduleCount = 1;
        for (int n2 = 0; n2 < size; n2 += moduleFunctionLimit) {
            File asmFile = this.getNewTempFile(this.m_baseName + "-" + moduleCount + ".asm");
            File macOFile = this.getNewTempFile(this.m_baseName + "-" + moduleCount + ".o");
            File serFile = this.getNewTempFile("ASMGenerator_" + moduleCount + "_opts.ser");
            String[] args = new String[]{"com.adobe.air.ipa.ASMGenerator", AOTCompiler.writeObject(this.m_opts, serFile), baseBitcode.toString(), Integer.toString(moduleCount), Integer.toString(n2), Integer.toString(moduleFunctionLimit), asmFile.getPath(), macOFile.getPath()};
            this.invokeADT(32, 32, null, args);
            serFile.delete();
            this.LogTiming("CompileAndAssembleBitcode-" + moduleCount);
            if (macOFile.length() > 0L) {
                this.m_macOFiles.add(macOFile);
            }
            ++moduleCount;
        }
        if (this.m_verbose) {
            System.out.println("# splitBitcode done ");
        }
    }

    protected void trimAndCompileBitcode(File bitcode, int moduleCount, int startpos, int splitSize, File asmFile, File macOFile) throws IOException, ProcessError {
        this.m_ctx = new LLVMContext();
        if (this.m_verbose) {
            System.out.println("# Reading base bitcode...");
        }
        Module m2 = this.readBitcode(bitcode);
        this.LogTiming("readBitcode");
        if (this.m_verbose) {
            System.out.println("# Finished reading base bitcode...");
        }
        Function_vector fns = LLVM.toVector(m2.getFunctionList());
        GlobalValue_vector gvs = new GlobalValue_vector();
        int i2 = startpos;
        while ((long)i2 < Math.min(fns.size(), (long)(startpos + splitSize))) {
            Function f2 = fns.get(i2);
            if (f2.getName().data().startsWith("abcMethod")) {
                gvs.add(f2);
            }
            ++i2;
        }
        if (gvs.size() > 0L) {
            this.extractGlobals(m2, "-split-" + startpos, gvs);
            this.compileBitcode(m2, asmFile, macOFile);
        }
        fns.delete();
        gvs.delete();
        m2.dropAllReferences();
        m2.delete();
        this.m_ctx.delete();
    }

    protected void optimizeBitcode() throws IOException, ProcessError {
        System.gc();
        PassManager pm = new PassManager();
        TargetData td = new TargetData(this.m_module);
        pm.add(td);
        pm.add(LLVM.createInternalizePass(this.m_tools.get("bitcode.api")));
        pm.add(LLVM.createGlobalDCEPass());
        pm.add(LLVM.createAggressiveDCEPass());
        if (this.m_opts.optLevel > 0) {
            if (this.m_verbose) {
                System.out.println("# Optimizing functions...");
            }
            FunctionPassManager fpm = FunctionPassManager.create(this.m_module);
            fpm.add(new TargetData(td));
            LLVM.createStandardFunctionPasses(fpm, this.m_opts.optLevel);
            Pass inliningPass = LLVM.createFunctionInliningPass(this.m_opts.optLevel > 2 ? 250 : 200);
            LLVM.createStandardModulePasses(pm, this.m_opts.optLevel, false, true, this.m_opts.optLevel > 1, true, true, inliningPass);
            fpm.doInitialization();
            Function_vector funcs = LLVM.toVector(this.m_module.getFunctionList());
            int size = (int)funcs.size();
            for (int i2 = 0; i2 < size; ++i2) {
                if (this.m_verbose && i2 % (size / 10) == 0) {
                    System.out.println("# -- function " + i2 + "/" + size + "...");
                }
                fpm.run(funcs.get(i2));
            }
            fpm.doFinalization();
            fpm.delete();
        }
        pm.add(LLVM.createLowerInvokePass(null, true));
        if (this.m_verbose) {
            System.out.println("# Optimizing module...");
        }
        pm.run(this.m_module);
        pm.delete();
        System.gc();
        this.dumpBitcode(this.m_baseName + "-opt.bc");
    }

    protected void compileBitcode(Module module, String name) throws IOException, ProcessError {
        File asmFile = this.getNewTempFile(name + ".asm");
        File macOFile = this.getNewTempFile(name + ".o");
        this.compileBitcode(module, asmFile, macOFile);
    }

    protected void compileBitcode(Module module, File asmFile, File macOFile) throws IOException, ProcessError {
        PriorityQueue<Timing> compileTimes = new PriorityQueue<Timing>();
        if (this.m_verbose) {
            System.out.println("# Generating asm... " + asmFile.toString());
            System.out.println("SSC optimization is " + this.m_opts.enableSSC);
        }
        LLVM.InitializeAllTargets();
        LLVM.InitializeAllAsmPrinters();
        LLVM.setNoFramePointerElim(true);
        LLVM.setDisableSSCOpt(!this.m_opts.enableSSC);
        Target thetarget = TargetRegistry.lookupTarget(module.getTargetTriple());
        TargetMachine themachine = thetarget.createTargetMachine(module.getTargetTriple(), this.m_targetArch.equals("arm") ? ",+v6,+vfp2" : "");
        FunctionPassManager fpm = FunctionPassManager.create(module);
        raw_fd_ostream rfdos = raw_fd_ostream.create(asmFile.getCanonicalPath());
        formatted_raw_ostream os = new formatted_raw_ostream(rfdos);
        if (this.m_opts.optLevel == 0) {
            LLVM.setEnableFastISel(true);
        }
        fpm.add(new TargetData(themachine.getTargetData()));
        themachine.addPassesToEmitFile(fpm, os, TargetMachine.CodeGenFileType.CGFT_AssemblyFile, this.m_opts.optLevel == 0 ? Level.None : Level.Aggressive, true);
        long startTime = System.currentTimeMillis();
        fpm.doInitialization();
        Function_vector funcs = LLVM.toVector(module.getFunctionList());
        int size = (int)funcs.size();
        for (int i2 = 0; i2 < size; ++i2) {
            if (this.m_verbose) {
                if (size >= 10 && i2 % (size / 10) == 0) {
                    System.out.println("# -- function " + i2 + "/" + size + "...");
                }
                long fstartTime = System.currentTimeMillis();
                fpm.run(funcs.get(i2));
                compileTimes.add(new Timing(System.currentTimeMillis() - fstartTime, funcs.get(i2).getName().data()));
                continue;
            }
            fpm.run(funcs.get(i2));
        }
        fpm.doFinalization();
        fpm.delete();
        themachine.delete();
        os.flush();
        rfdos.flush();
        rfdos.close();
        os.delete();
        rfdos.delete();
        if (this.m_verbose) {
            double llcTime = System.currentTimeMillis() - startTime;
            System.out.println("# llc took " + llcTime / 1000.0 + "s");
            long nonabctime = 0L;
            for (Timing t2 : compileTimes) {
                if (t2.name.startsWith("abcMethod")) continue;
                nonabctime += t2.timeMS;
            }
            System.out.println("# non-abcMethod functions took " + (double)nonabctime / 1000.0 + "s");
            if (llcTime > 0.0) {
                for (int i3 = 0; i3 < 10; ++i3) {
                    Timing t2;
                    t2 = (Timing)compileTimes.poll();
                    if (t2 == null) continue;
                    System.out.println("# " + (double)t2.timeMS / 1000.0 + "s (" + (double)t2.timeMS / llcTime * 100.0 + "%) for " + t2.name);
                }
            }
        }
        this.LogTiming("compileBitCode");
        String[] stringArray = new String[6];
        stringArray[0] = this.m_tools.get("as");
        stringArray[1] = "-arch";
        stringArray[2] = this.m_targetArch.equals("arm") ? (this.m_useCaptiveSdk ? "armv6" : "armv7") : "i686";
        stringArray[3] = "-o";
        stringArray[4] = macOFile.getName();
        stringArray[5] = asmFile.getName();
        this.launchProcess(AOTCompiler.createArgs(stringArray), "as", "Assembler failed", false);
        this.m_asmFiles.add(asmFile);
        this.m_macOFiles.add(macOFile);
        this.LogTiming("assembleAsm");
    }

    protected void linkMachO() throws IOException, ProcessError {
        block25: {
            this.m_macExe = this.m_targetRuntime.equals("shell") ? new File(this.m_outputFolder, this.m_baseName) : File.createTempFile("aot", null, this.m_outputFolder);
            ArrayList<String> args = AOTCompiler.createArgs(this.m_tools.get("ld64"), "-ObjC", "-dead_strip", "-Z");
            String[] stringArray = new String[2];
            stringArray[0] = "-arch";
            stringArray[1] = this.m_targetArch.equals("arm") ? (this.m_useCaptiveSdk ? "arm" : "armv7") : "i386";
            AOTCompiler.appendArgs(args, stringArray);
            String frameworkDir = null;
            if (this.m_useCaptiveSdk) {
                AOTCompiler.appendArgs(args, "-L" + Utils.quote(this.m_captiveSdkRoot + STUB_DIR));
                AOTCompiler.appendArgs(args, "-L" + Utils.quote(this.m_captiveSdkRoot + LIB_DIR + "/gcc"), "-lgcc");
                frameworkDir = this.m_captiveSdkRoot + STUB_DIR;
            } else {
                AOTCompiler.appendArgs(args, "-syslibroot", Utils.quote(this.m_platformSdkRoot), "-L/usr/lib");
                if (!this.m_targetArch.equals("arm")) {
                    AOTCompiler.appendArgs(args, "-L/usr/lib/gcc/i686-apple-darwin9/4.2.1", "-L/usr/lib/gcc/i686-apple-darwin10/4.2.1");
                }
                frameworkDir = DEFAULT_FRAMEWORK_DIR;
            }
            AOTCompiler.appendArgs(args, "-F" + Utils.quote(frameworkDir));
            AOTCompiler.appendArgs(args, "-L" + Utils.quote(this.m_captiveSdkRoot + LIB_DIR));
            AOTCompiler.appendArgs(args, "-o", Utils.quote("../" + this.m_macExe.getName()));
            if (this.m_opts.extLibDir != null) {
                AOTCompiler.appendArgs(args, "-L" + Utils.quote(this.m_opts.extLibDir));
            }
            AOTCompiler.appendArgs(args, "-exported_symbol", "_main");
            if (this.m_opts.exportedSymbols != null) {
                for (String symbol : this.m_opts.exportedSymbols) {
                    AOTCompiler.appendArgs(args, "-exported_symbol", "_" + symbol);
                }
            }
            for (File f2 : this.m_macOFiles) {
                AOTCompiler.appendArgs(args, Utils.quote(f2.getName()));
            }
            if (this.m_opts.linkerOptions != null) {
                args.addAll(this.m_opts.linkerOptions);
            }
            if (this.m_opts.interpreter) {
                AOTCompiler.appendArgs(args, "-lRuntimeInterpreter." + this.m_opts.target);
            } else {
                if (this.m_targetRuntime.equals("air")) {
                    AOTCompiler.appendArgs(args, "-sectcreate", "__TEXT", "__ic", Utils.quote(this.m_strippedRootSWFFile.getName()), Utils.quote(this.m_tools.get(this.m_opts.debugger ? "libdebugger1" : "libnodebugger1")), Utils.quote(this.m_tools.get(this.m_opts.debugger ? "libdebugger2" : "libnodebugger2")), Utils.quote(this.m_tools.get("libruntimeaot")));
                }
                if (this.m_debugSDK) {
                    AOTCompiler.appendArgs(args, Utils.quote(this.m_tools.get("libavmplus")), Utils.quote(this.m_tools.get("libmmgc")));
                }
            }
            if (this.m_targetArch.equals("x86")) {
                AOTCompiler.appendArgs(args, "-lstdc++.6", "-lcrt3.o", "-lcrt1.10.5.o", "-lgcc_s.10.5", "-lSystem.B_debug", "-lz", "-macosx_version_min", "10.5.6", "-framework", "CoreServices");
            } else {
                if (this.m_targetArch.equals("arm")) {
                    AOTCompiler.appendArgs(args, "-lgcc_s.1");
                } else {
                    AOTCompiler.appendArgs(args, "-lgcc_s.10.5");
                }
                AOTCompiler.appendArgs(args, "-lstdc++.6", "-lcrt1.o", "-lSystem.B", "-lz", "-lobjc", "-framework", "CoreFoundation", "-framework", "UIKit", "-framework", "MobileCoreServices", "-framework", "CoreGraphics", "-framework", "Foundation", "-framework", "SystemConfiguration", "-framework", "AudioToolbox", "-framework", "CFNetwork", "-framework", "QuartzCore", "-framework", "OpenGLES", "-framework", "CoreLocation", "-framework", "CoreMedia", "-framework", "CoreVideo", "-framework", "AVFoundation", "-framework", "Security");
                if (this.m_opts.linkAllFrameworks && this.m_opts.extensionLibs != null && this.m_opts.extensionLibs.size() > 0) {
                    AOTCompiler.appendArgs(args, "-framework", "Accelerate", "-framework", "AddressBook", "-framework", "AddressBookUI", "-framework", "AssetsLibrary", "-framework", "CoreAudio", "-framework", "CoreData", "-framework", "CoreMotion", "-framework", "CoreTelephony", "-framework", "CoreText", "-framework", "EventKit", "-framework", "EventKitUI", "-framework", "ExternalAccessory", "-framework", "GameKit", "-framework", "IOKit", "-framework", "ImageIO", "-framework", "MapKit", "-framework", "MediaPlayer", "-framework", "MessageUI", "-framework", "OpenAL", "-framework", "QuickLook", "-framework", "StoreKit", "-framework", "iAd");
                }
            }
            if (this.m_opts.extensionLibs != null) {
                for (String lib : this.m_opts.extensionLibs) {
                    AOTCompiler.appendArgs(args, "-l" + lib);
                }
            }
            if (!this.m_verbose && !this.m_useNewTools) {
                AOTCompiler.appendArgs(args, "-no_symbol_version_warnings");
            }
            if (this.m_verbose) {
                System.out.println("# Generating executable...");
            }
            this.launchProcess(args, "ld64", "Unable to generate executable", true, false);
            if (System.getProperty("os.name").contains("Mac") && this.m_opts.extensionLibs != null && this.m_opts.extensionLibs.size() > 0) {
                if (this.m_verbose) {
                    System.out.println("# Extracting DWARF info...");
                }
                try {
                    args = AOTCompiler.createArgs("dsymutil", "-o", this.m_opts.outputPath + "/" + this.m_opts.filename + ".app.dSYM", this.m_macExe.getCanonicalPath());
                    this.launchProcess(args, "dsymutil", "failed to extract DWARF info", this.m_verbose);
                }
                catch (ProcessError pe) {
                    if (!this.m_verbose) break block25;
                    System.out.println("Warning: " + pe.getMessage());
                }
            }
        }
    }

    protected void stripExeSymbols() throws IOException, ProcessError {
        this.launchProcess(AOTCompiler.createArgs(this.m_tools.get("strip"), "-x", "-r", this.m_macExe.getCanonicalPath()), "strip", "Unable to strip symbols from executable", false);
    }

    public void validateIosSDK() throws SDKDamagedException {
        if (!this.m_opts.target.equals("arm-air") || this.m_opts.interpreter) {
            return;
        }
        for (String filePath : this.m_tools.values()) {
            if (filePath.indexOf(this.m_captiveSdkRoot) < 0 || new File(filePath).exists()) continue;
            throw new SDKDamagedException(filePath);
        }
    }

    public void generateMachineBinaries() throws IOException, InvalidInputException, SDKDamagedException {
        boolean success = false;
        try {
            this.LogTiming("Step_0:Start");
            this.m_totalSteps = this.m_opts.interpreter ? (this.m_opts.noStrip ? 2 : 3) : (this.m_opts.noStrip ? 7 : 8);
            this.m_currStep = 0;
            this.generateExtensionsGlue();
            this.reportProgress("generateExtensionsGlue");
            if (!this.m_opts.interpreter) {
                this.validateIosSDK();
                this.convertRootSwfToAbc();
                this.reportProgress("convertRootSwfToAbc");
                this.convertAbcToLlvmBitcode();
                this.reportProgress("convertAbcToLlvmBitcode");
                this.linkBitcodeFiles();
                this.reportProgress("linkBitcodeFiles");
                this.optimizeBitcode();
                this.reportProgress("optimizeBitcode");
                this.splitBitcode();
                this.reportProgress("splitBitcode");
            }
            this.linkMachO();
            this.reportProgress("linkMachO");
            if (!this.m_opts.noStrip) {
                this.stripExeSymbols();
                this.reportProgress("stripExeSymbols");
            }
            if (System.getProperty("os.name").contains("Mac")) {
                Runtime.getRuntime().exec("chmod a+x " + this.m_macExe.getAbsolutePath());
            }
            success = true;
        }
        catch (ProcessError e2) {
            if (this.m_verbose) {
                e2.printStackTrace();
            }
            throw new InvalidInputException("Compilation failed while executing : " + e2.getProcessName());
        }
        catch (SDKDamagedException e3) {
            throw e3;
        }
        catch (Exception e4) {
            if (this.m_verbose) {
                e4.printStackTrace();
            }
            throw new InvalidInputException("Compilation failed...");
        }
        finally {
            if (!this.m_verbose) {
                Utils.deleteAll(this.m_tempFolder);
                if (!success && this.m_macExe != null && this.m_macExe.exists()) {
                    this.m_macExe.delete();
                }
            }
        }
    }

    private void reportProgress(String msg) {
        this.LogTiming("Step_" + (this.m_currStep + 1) + ":" + msg);
        int percentDone = (int)((float)(++this.m_currStep) / ((float)this.m_totalSteps + 1.0f) * 100.0f);
        if (this.m_listener != null) {
            this.m_listener.progress(percentDone, 100);
        }
    }

    private void invokeADT(int minHeap, int maxHeap, String xss, String[] args) throws IOException, ProcessError {
        String javaVersion;
        ArrayList<String> newArgs = new ArrayList<String>();
        newArgs.add("java");
        if (this.m_opts.verbosity > 1) {
            newArgs.add("-ea");
        }
        boolean is64BitJVM = System.getProperty("java.vm.name").contains("64");
        boolean need32BitFlag = false;
        if (this.m_opts.force32Bit) {
            if (is64BitJVM) {
                assert (false);
                return;
            }
            if (System.getProperty("os.name").indexOf("Mac") != -1) {
                need32BitFlag = true;
            }
        }
        if (need32BitFlag) {
            newArgs.add("-d32");
        }
        if ((javaVersion = System.getProperty("java.version")) != null) {
            String[] versionInfo = javaVersion.split("\\.");
            try {
                if (Integer.parseInt(versionInfo[0]) > 1 || Integer.parseInt(versionInfo[1]) >= 7) {
                    newArgs.add("-Djava.util.Arrays.useLegacyMergeSort=true");
                }
            }
            catch (NumberFormatException e2) {
                System.err.println("Unable to retrieve the java version correctly.");
            }
        }
        if (is64BitJVM && !need32BitFlag) {
            maxHeap *= 8;
        }
        if (xss != null) {
            newArgs.add("-Xss" + xss);
        }
        newArgs.addAll(Arrays.asList("-Xms" + minHeap + "m", "-Xmx" + maxHeap + "m", "-cp"));
        try {
            String jarFile = Utils.getJarFile().getAbsolutePath();
            if (!jarFile.endsWith("jar")) {
                String errorText = "Unable to locate ADT.jar";
                System.err.println(errorText);
                return;
            }
            newArgs.add(jarFile);
        }
        catch (IOException e3) {
            System.err.println("Error while reinvoking");
            e3.printStackTrace();
            return;
        }
        newArgs.addAll(Arrays.asList(args));
        try {
            Process child = Utils.execSafely(null, newArgs);
            new Utils.OutputEater(child.getInputStream(), System.out).start();
            new Utils.OutputEater(child.getErrorStream(), System.err).start();
            try {
                child.waitFor();
            }
            catch (InterruptedException e4) {
                System.err.println("Error while reinvoking");
                e4.printStackTrace();
                return;
            }
            if (child.exitValue() != 0) {
                String msg = "failed to invoke ADT with the following args: ";
                for (String s2 : args) {
                    msg = msg + s2 + " ";
                }
                throw new ProcessError("ADT", msg, child.exitValue());
            }
        }
        catch (IOException e5) {
            System.err.println("Error while reinvoking");
            e5.printStackTrace();
            return;
        }
    }

    public File getExecutable() {
        return this.m_macExe;
    }

    public static Object readObject(File serFile) throws IOException, ClassNotFoundException {
        Object retval = null;
        FileInputStream fis = new FileInputStream(serFile);
        ObjectInputStream in = new ObjectInputStream(fis);
        retval = in.readObject();
        in.close();
        return retval;
    }

    public static String writeObject(Object obj, File serFile) throws IOException {
        String retval = null;
        retval = serFile.getPath();
        FileOutputStream fos = new FileOutputStream(serFile);
        ObjectOutputStream out = new ObjectOutputStream(fos);
        out.writeObject(obj);
        out.close();
        return retval;
    }

    private void LogPerfMsg(String msg) {
        if (this.shouldLogPerf()) {
            System.out.println("#PerfLog: " + msg);
        }
    }

    private void LogTiming(String msg) {
        if (this.shouldLogPerf()) {
            System.out.println("#PerfLog:Timing: " + msg + " " + System.currentTimeMillis());
        }
    }

    private boolean shouldLogPerf() {
        return this.m_opts.logPerf || this.m_opts.verbosity > 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Timing
    implements Comparable<Timing> {
        public long timeMS;
        public String name;

        public Timing(long timeMS, String name) {
            this.timeMS = timeMS;
            this.name = name;
        }

        @Override
        public int compareTo(Timing t2) {
            return (int)(t2.timeMS - this.timeMS);
        }
    }
}

