/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.Binding;
import adobe.abc.BuiltinDomain;
import adobe.abc.GlobalOptimizer;
import adobe.abc.Method;
import adobe.abc.Name;
import adobe.abc.Namespace;
import adobe.abc.OptimizerConstants;
import adobe.abc.Symtab;
import adobe.abc.Typeref;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Type {
    Name name;
    public Type base;
    Type[] interfaces = OptimizerConstants.notypes;
    Symtab<Binding> defs;
    Method init;
    Type itype;
    int flags;
    Namespace protectedNs;
    Typeref[] scopes = OptimizerConstants.notyperefs;
    boolean[] withScopes = OptimizerConstants.nowithscopes;
    boolean numeric;
    boolean primitive;
    boolean atom;
    Object defaultValue;
    public Typeref ref;
    private boolean m_resolved;
    int slotCount;
    int dispIdCount;
    private final Type[] m_params;

    private Type(Type[] paramTypes) {
        this.m_params = paramTypes;
        this.ref = new Typeref(this, true);
        BuiltinDomain.instance().assignNullDefaultValue(this);
        this.m_resolved = false;
    }

    Type(Name name, Type base, Type[] paramTypes) {
        this(paramTypes);
        this.name = name;
        this.base = base;
        this.defs = new Symtab();
    }

    private Type() {
        this(null);
    }

    Type(Name name, Type base) {
        this(name, base, null);
    }

    public static Type newActivationType() {
        return new Type();
    }

    boolean emitAsAny() {
        return this.base == null && this != BuiltinDomain.instance().VOID() && this.defs.size() == 0 && !BuiltinDomain.instance().builtinTypes.contains(this) && !BuiltinDomain.instance().baseTypes.contains(this);
    }

    boolean isBuiltinType() {
        return BuiltinDomain.instance().builtinTypes.contains(this);
    }

    public boolean isFinal() {
        return (this.flags & 2) != 0;
    }

    public boolean isInterface() {
        return (this.flags & 4) != 0;
    }

    void setFinal() {
        this.flags |= 2;
    }

    void clearFinal() {
        this.flags &= 0xFFFFFFFD;
    }

    Binding find(Name n2) {
        Type t2 = this;
        while (t2 != null) {
            Binding b3 = t2.defs.get(n2);
            if (b3 != null) {
                return b3;
            }
            t2 = t2.base;
        }
        return null;
    }

    Binding findOverride(Name n2) {
        boolean protNs = n2.nsset.nsset[0].isProtected();
        Type t2 = this;
        while (t2 != null) {
            Name n0 = protNs ? new Name(n2.kind, t2.protectedNs, n2.name) : n2;
            Binding b3 = t2.defs.get(n0);
            if (b3 != null) {
                return b3;
            }
            t2 = t2.base;
        }
        return null;
    }

    public static void setNeedsArgumentsUptoRoot(Type start, Name n2) {
        if (start == null || n2 == null) {
            return;
        }
        Type.setNeedsArgumentsUpInterfaceHierarchy(start, n2);
        Type.setNeedsArgumentsUpInheritanceHierarchy(start, n2);
    }

    private static void setNeedsArgumentsUpInterfaceHierarchy(Type start, Name n2) {
        if (!n2.nsset.nsset[0].isPublic()) {
            return;
        }
        ArrayList<Type> interfaces = start.getInterfaces();
        for (Type t2 : interfaces) {
            Name n0 = n2;
            if (t2.defs.values().size() > 0) {
                Binding fstBinding = (Binding)t2.defs.values().toArray()[0];
                assert (fstBinding != null);
                n0 = new Name(n2.kind, n2.name, fstBinding.getName().nsset);
            }
            Binding b3 = t2.defs.get(n0);
            Type.setNeedsArgument(b3);
        }
    }

    private static void setNeedsArgumentsUpInheritanceHierarchy(Type start, Name n2) {
        boolean protNs = n2.nsset.nsset[0].isProtected();
        Type t2 = start;
        while (t2 != null) {
            Name n0 = protNs ? new Name(n2.kind, t2.protectedNs, n2.name) : n2;
            Binding b3 = t2.defs.get(n0);
            Type.setNeedsArgument(b3);
            t2 = t2.base;
        }
    }

    private static void setNeedsArgument(Binding b3) {
        if (b3 != null) {
            assert (b3.isMethod() || b3.isGetter() || b3.isSetter());
            assert (b3.method != null);
            if (!b3.method.needsArguments()) {
                b3.method.setNeedsArguments();
            }
        }
    }

    public static void checkNeedsArgumentsAndUpdatePath(Type start, Method startMethod, Name n2) {
        if (start == null || startMethod == null || n2 == null) {
            return;
        }
        Type.checkNeedsArgumentsForInterfaceHierarchy(start, startMethod, n2);
        Type.checkNeedsArgumentsForInheritanceHierarchy(start, startMethod, n2);
    }

    private static void checkNeedsArgumentsForInterfaceHierarchy(Type start, Method startMethod, Name n2) {
        if (!n2.nsset.nsset[0].isPublic()) {
            return;
        }
        ArrayList<Type> interfaces = start.getInterfaces();
        boolean needsArgument = false;
        for (Type t2 : interfaces) {
            Binding b3;
            Name n0 = n2;
            if (t2.defs.values().size() > 0) {
                Binding fstBinding = (Binding)t2.defs.values().toArray()[0];
                assert (fstBinding != null);
                n0 = new Name(n2.kind, n2.name, fstBinding.getName().nsset);
            }
            if ((b3 = t2.defs.get(n0)) == null) continue;
            assert (b3.isMethod() || b3.isGetter() || b3.isSetter());
            assert (b3.method != null);
            if (!b3.method.needsArguments()) continue;
            needsArgument = true;
            break;
        }
        if (needsArgument) {
            startMethod.setNeedsArguments();
        }
    }

    private static void checkNeedsArgumentsForInheritanceHierarchy(Type start, Method startMethod, Name n2) {
        boolean needsArguments = false;
        boolean protNs = n2.nsset.nsset[0].isProtected();
        ArrayList<Method> path = new ArrayList<Method>();
        path.add(startMethod);
        Type t2 = start.base;
        while (t2 != null) {
            Name n0 = protNs ? new Name(n2.kind, t2.protectedNs, n2.name) : n2;
            Binding b3 = t2.defs.get(n0);
            if (b3 != null) {
                assert (b3.isMethod() || b3.isGetter() || b3.isSetter());
                assert (b3.method != null);
                if (b3.method.needsArguments()) {
                    needsArguments = true;
                    break;
                }
                path.add(b3.method);
            }
            t2 = t2.base;
        }
        if (needsArguments) {
            for (int i2 = 0; i2 < path.size(); ++i2) {
                Method m2 = (Method)path.get(i2);
                m2.setNeedsArguments();
            }
        }
        path.clear();
    }

    Binding findMethod(int dispId) {
        Type t2 = this;
        while (t2 != null) {
            for (Binding b3 : t2.defs.values()) {
                if (GlobalOptimizer.isSlot(b3) || b3.slot != dispId) continue;
                return b3;
            }
            t2 = t2.base;
        }
        return null;
    }

    Binding findGet(Name n2) {
        Binding first = this.find(n2);
        if (first != null && GlobalOptimizer.isSetter(first)) {
            Binding second;
            if (first.peer != null) {
                return first.peer;
            }
            if (this.base != null && GlobalOptimizer.isGetter(second = this.base.findGet(n2))) {
                return second;
            }
        }
        return first;
    }

    Binding findSet(Name n2) {
        Binding first = this.find(n2);
        if (first != null && GlobalOptimizer.isGetter(first)) {
            Binding second;
            if (first.peer != null) {
                return first.peer;
            }
            if (this.base != null && GlobalOptimizer.isSetter(second = this.base.findSet(n2))) {
                return second;
            }
        }
        return first;
    }

    Binding findGetOnInterface(Name n2) {
        assert (this.isInterface());
        Binding b3 = this.findGet(n2);
        if (b3 != null) {
            return b3;
        }
        for (Type t2 : this.interfaces) {
            b3 = t2.findGetOnInterface(n2);
            if (b3 == null) continue;
            return b3;
        }
        return null;
    }

    Binding findSetOnInterface(Name n2) {
        assert (this.isInterface());
        Binding b3 = this.findSet(n2);
        if (b3 != null) {
            return b3;
        }
        for (Type t2 : this.interfaces) {
            b3 = t2.findSetOnInterface(n2);
            if (b3 == null) continue;
            return b3;
        }
        return null;
    }

    public Typeref getSlotType(int slot) {
        Binding b3 = this.findSlot(slot);
        if (b3 != null) {
            return b3.type;
        }
        return BuiltinDomain.instance().ANY().ref.nullable();
    }

    public Binding findSlot(int slot) {
        if (slot > this.slotCount) {
            throw new Error("Type " + this.getName().format() + " does not have slot id " + String.valueOf(slot) + ".");
        }
        Type t2 = this;
        while (t2.base != null && t2.base.slotCount >= slot) {
            t2 = t2.base;
        }
        for (Binding b3 : t2.defs.values()) {
            if (!GlobalOptimizer.isSlot(b3) || b3.slot != slot) continue;
            return b3;
        }
        return null;
    }

    public Collection<Binding> getLocalSlots() {
        ArrayList<Binding> result = new ArrayList<Binding>();
        for (Binding b3 : this.defs.values()) {
            if (!GlobalOptimizer.isSlot(b3)) continue;
            result.add(b3);
        }
        return result;
    }

    public ArrayList<Type> getInterfaces() {
        ArrayList<Type> result = new ArrayList<Type>();
        this.getInterfaces(this, result);
        return result;
    }

    private void getInterfaces(Type t2, ArrayList<Type> interfaces) {
        if (t2 == null) {
            return;
        }
        this.getInterfaces(t2.base, interfaces);
        for (Type i2 : t2.interfaces) {
            if (!interfaces.contains(i2)) {
                interfaces.add(i2);
            }
            this.getInterfaces(i2, interfaces);
        }
    }

    public boolean isLocalBinding(Name n2) {
        Binding b3 = this.defs.get(n2);
        return b3 != null;
    }

    public boolean hasProtectedNs() {
        return (this.flags & 8) != 0;
    }

    boolean isMachineCompatible(Type t2) {
        boolean result = this.equals(t2);
        result |= this.equals(BuiltinDomain.instance().NULL()) && !t2.isMachineType();
        result |= t2.equals(BuiltinDomain.instance().NULL()) && !this.isMachineType();
        return result |= !this.isMachineType() && !t2.isMachineType() && !this.equals(BuiltinDomain.instance().ANY()) && !t2.equals(BuiltinDomain.instance().ANY());
    }

    private boolean isMachineType() {
        return this.equals(BuiltinDomain.instance().OBJECT()) || this.equals(BuiltinDomain.instance().VOID()) || this.equals(BuiltinDomain.instance().INT()) || this.equals(BuiltinDomain.instance().UINT()) || this.equals(BuiltinDomain.instance().BOOLEAN()) || this.equals(BuiltinDomain.instance().ARRAY()) || this.equals(BuiltinDomain.instance().NUMBER());
    }

    public boolean isAtom() {
        return this.atom;
    }

    public Name getName() {
        return this.name;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public boolean extendsOrIsBase(Type c2) {
        return this == c2 || this.extendsBase(c2);
    }

    public boolean extendsBase(Type c2) {
        Type t2 = this.base;
        while (t2 != null) {
            if (t2 == c2) {
                return true;
            }
            t2 = t2.base;
        }
        return false;
    }

    public boolean implementsInterface(Type i2) {
        for (Type x2 : this.interfaces) {
            if (x2 != i2) continue;
            return true;
        }
        return false;
    }

    public boolean isDerivedFrom(Type x2) {
        return this.extendsBase(x2) || this.implementsInterface(x2);
    }

    public boolean isParameterizedTypeInstance() {
        return this.m_params != null;
    }

    public Type parameterizedType() {
        assert (this.isParameterizedTypeInstance());
        return this.base;
    }

    public Type[] typeParameters() {
        assert (this.isParameterizedTypeInstance());
        return this.m_params;
    }

    public boolean resolved() {
        return this.m_resolved;
    }

    public void markResolved() {
        this.m_resolved = true;
    }

    public void sealOptimistically() {
        for (Binding b3 : this.defs.values()) {
            if (!b3.isMethod()) continue;
            b3.setLocallyFinal();
        }
    }

    public void clearInvalidBaseSealings() {
        for (Binding b3 : this.defs.values()) {
            if (!b3.isMethod()) continue;
            Type t2 = this.base;
            while (t2 != null) {
                Binding b02 = t2.findOverride(b3.getName());
                if (b02 != null) {
                    b02.clearLocallyFinal();
                }
                t2 = t2.base;
            }
        }
    }

    public int countFinal() {
        int result = 0;
        for (Binding b3 : this.defs.values()) {
            if (!b3.isFinal()) continue;
            ++result;
        }
        return result;
    }

    public String toString() {
        return this.name.format();
    }

    public static class StringValueIsName
    extends Type {
        StringValueIsName(Name name, Type base) {
            super(name, base);
        }

        public String toString() {
            return this.name.toString();
        }
    }
}

