/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.APIVersions;
import adobe.abc.Algorithms;
import adobe.abc.Binding;
import adobe.abc.Block;
import adobe.abc.BuiltinDomain;
import adobe.abc.Domain;
import adobe.abc.Edge;
import adobe.abc.Expr;
import adobe.abc.GlobalOptimizer;
import adobe.abc.Handler;
import adobe.abc.LLVMEmitterOptions;
import adobe.abc.LLVMStubFunctions;
import adobe.abc.LLVMStubTypes;
import adobe.abc.LLVMTamarinSlotLayout;
import adobe.abc.LLVMTamarinSlotLayoutCache;
import adobe.abc.LLVMTypeExtractor;
import adobe.abc.Method;
import adobe.abc.Name;
import adobe.abc.Namespace;
import adobe.abc.OptimizerConstants;
import adobe.abc.Pair;
import adobe.abc.TamarinSlotLayout;
import adobe.abc.TwineRef;
import adobe.abc.Type;
import adobe.abc.Typeref;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import llvm.APFloat;
import llvm.APInt;
import llvm.AllocaInst;
import llvm.Argument;
import llvm.Argument_vector;
import llvm.ArrayType;
import llvm.BitCastInst;
import llvm.BranchInst;
import llvm.CallInst;
import llvm.CallingConv;
import llvm.CmpInst;
import llvm.CompositeType;
import llvm.Constant;
import llvm.ConstantArray;
import llvm.ConstantExpr;
import llvm.ConstantFP;
import llvm.ConstantInt;
import llvm.ConstantPointerNull;
import llvm.ConstantStruct;
import llvm.Constant_vector;
import llvm.DerivedType;
import llvm.FunctionType;
import llvm.Function_vector;
import llvm.GetElementPtrInst;
import llvm.GlobalValue;
import llvm.GlobalVariable;
import llvm.GlobalVariable_vector;
import llvm.ICmpInst;
import llvm.Instruction;
import llvm.IntegerType;
import llvm.InvokeInst;
import llvm.JNIStringRef;
import llvm.LLVM;
import llvm.LLVMContext;
import llvm.LoadInst;
import llvm.MemoryBuffer;
import llvm.Module;
import llvm.OpaqueType;
import llvm.PHINode;
import llvm.PointerType;
import llvm.PtrToIntInst;
import llvm.ReturnInst;
import llvm.SequentialType;
import llvm.StoreInst;
import llvm.StringRef;
import llvm.StructType;
import llvm.SwitchInst;
import llvm.TerminatorInst;
import llvm.TruncInst;
import llvm.Twine;
import llvm.Type_vector;
import llvm.UndefValue;
import llvm.UnreachableInst;
import llvm.UnwindInst;
import llvm.User;
import llvm.Value;
import llvm.Value_vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LLVMEmitter {
    private static final boolean useJNILLVM = true;
    private boolean runtimeDebugging = false;
    private boolean debugMessages = false;
    private boolean debugBuiltins = false;
    private LLVMContext m_ctx = null;
    private boolean useARMCallingConvention = false;
    private static final boolean verifyBitcode = false;
    private static final boolean traceBlockPos = false;
    private static final boolean traceMethod = false;
    private static final boolean optStaticMultinames = true;
    private static final boolean optRuntimeMultinames = true;
    private static boolean optLazyEvals = true;
    private static final boolean optVectorStubSpecialization = false;
    private static final boolean optOptimisticDoubleAtom = false;
    private static final String EXT_MODULE_ID = "extensions glue";
    private static final String ARM_TARGET_TRIPLE = "armv7-apple-darwin10";
    private static final String x86_TARGET_TRIPLE = "i386-apple-darwin9";
    private static final int WRITE_MODULE_BUFFER_SIZE = 262144;
    private int m_numCall = 0;
    private int m_numCallMethod = 0;
    private int m_numCallSuperMethod = 0;
    private int m_numCallProp = 0;
    private int m_numCallStaticNative = 0;
    private int m_numCallMethodEnvFromIndex = 0;
    private int m_numCallSuper = 0;
    private int m_numCallDirect = 0;
    private int m_numInterface = 0;
    private int m_numCallInterface = 0;
    private int m_numFindProp = 0;
    private int m_numGetProp = 0;
    private int m_numSetProp = 0;
    private int m_numGetSlot = 0;
    private int m_numSetSlot = 0;
    private int m_numfinddef = 0;
    private int m_numcachedfinddef = 0;
    private int m_numpushstring = 0;
    private List<LazyEval> lazyEvals;
    private final Map<GlobalOptimizer.InputAbc, Map<Method, Map<Expr, Typeref>>> m_methodTypeInfo;
    private final Map<GlobalOptimizer.InputAbc, Map<Method, Algorithms.EdgeMap<Expr>>> m_methodUseInfo;
    private final Map<Type, Constant> m_TypeIds;
    private final Set<Type> m_visitedTypes;
    private final Map<Expr, Integer> m_scopeDepths;
    private final Map<Method, Function> m_abcMethodToLLVMFunction = new HashMap<Method, Function>();
    private LLVMTamarinSlotLayoutCache m_slotLayoutCache;
    private final Map<String, Pair<PointerType, llvm.Type>> m_glueClassNameToLLVMTypes;
    private Module m_module;
    private final Set<String> m_directCalls;
    private final Map<Method, String> m_referencedMethods;
    private boolean m_debugger = false;
    private boolean m_logPerf = false;

    private static void usage(String err) {
        System.err.println(err);
        LLVMEmitter.usage();
    }

    private static void usage() {
        System.err.println("usage: LLVMEmitter [-verbose] -ouput outfile runtimeBitCode builtin.abc [imports] -- appRootABC [appChildAbc ...]");
        System.exit(-1);
    }

    public static void main(String[] args) throws IOException {
        LLVMEmitterOptions opts = new LLVMEmitterOptions();
        Boolean doneBuiltins = false;
        for (int i2 = 0; i2 < args.length; ++i2) {
            if (args[i2].equals("-verbose")) {
                opts.verbose = true;
                continue;
            }
            if (args[i2].equals("-arm")) {
                opts.useARMCallingConvention = true;
                continue;
            }
            if (args[i2].equals("-debugger")) {
                opts.debugger = true;
                continue;
            }
            if (args[i2].equals("-debug")) {
                opts.debugMessages = true;
                continue;
            }
            if (args[i2].equals("-debugruntime")) {
                opts.runtimeDebugging = true;
                continue;
            }
            if (args[i2].equals("-debugbuiltins")) {
                opts.debugBuiltins = true;
                continue;
            }
            if (args[i2].equals("-output")) {
                opts.output = new File(args[++i2]);
                continue;
            }
            if (opts.runtimeBitcode == null) {
                opts.runtimeBitcode = new File(args[i2]);
                continue;
            }
            if (args[i2].equals("--")) {
                doneBuiltins = true;
                continue;
            }
            if (doneBuiltins.booleanValue()) {
                opts.appABCs.add(args[i2]);
                continue;
            }
            opts.builtInABCs.add(args[i2]);
        }
        LLVMEmitter.generateBitcode(opts, true);
    }

    private static void syncMethodInformation(List<GlobalOptimizer.InputAbc> builtInABCs, List<GlobalOptimizer.InputAbc> appABCs) {
        for (GlobalOptimizer.InputAbc iabc : builtInABCs) {
            iabc.propagateMethodFlagsDown();
        }
        for (GlobalOptimizer.InputAbc iabc : appABCs) {
            iabc.propagateMethodFlagsDown();
        }
    }

    public static llvm.Module generateSymbolToFunctionPtrMap(String mapName, Boolean useARMCallingConvention, ArrayList<String> symbols) throws IOException {
        if (symbols == null) {
            LLVMEmitter.usage("Null symbol list");
        }
        JNIStringRef moduleId = new JNIStringRef(EXT_MODULE_ID);
        llvm.Module module = new llvm.Module(moduleId, new LLVMContext());
        moduleId.delete();
        JNIStringRef targetTriple = useARMCallingConvention != false ? new JNIStringRef(ARM_TARGET_TRIPLE) : new JNIStringRef(x86_TARGET_TRIPLE);
        module.setTargetTriple(targetTriple);
        targetTriple.delete();
        PointerType voidPtrTy = PointerType.get(IntegerType.get(module.getContext(), 8L), 0L);
        ConstantInt zero = LLVMEmitter.constantInt(module.getContext(), 32L, 0L);
        Type_vector memberTypeVector = new Type_vector();
        memberTypeVector.add(voidPtrTy);
        memberTypeVector.add(voidPtrTy);
        StructType structTy = StructType.get(module.getContext(), memberTypeVector, false);
        memberTypeVector.delete();
        memberTypeVector = new Type_vector();
        FunctionType fType = FunctionType.get(voidPtrTy, memberTypeVector, false);
        memberTypeVector.delete();
        Constant_vector arrayInitializer = new Constant_vector();
        for (String symbol : symbols) {
            JNIStringRef jniSymbol = new JNIStringRef(symbol);
            Constant fnameInitializer = ConstantArray.get(module.getContext(), jniSymbol);
            GlobalVariable fnameArray = GlobalVariable.Create(module, fnameInitializer.getType(), true, GlobalValue.LinkageTypes.ExternalLinkage, fnameInitializer, symbol + "_name", null);
            Constant_vector indexesVector = new Constant_vector();
            indexesVector.add(zero);
            indexesVector.add(zero);
            Constant fn = ConstantExpr.getGetElementPtr(fnameArray, indexesVector);
            indexesVector.delete();
            Constant f2 = module.getOrInsertFunction((StringRef)jniSymbol, fType);
            Constant fp = ConstantExpr.getCast(Instruction.CastOps.BitCast.swigValue(), f2, voidPtrTy);
            Constant pair = Module.getConstantStruct(structTy, fn, fp);
            jniSymbol.delete();
            arrayInitializer.add(pair);
        }
        Constant nullVal = Constant.getNullValue(voidPtrTy);
        Constant pair = Module.getConstantStruct(structTy, nullVal, nullVal);
        arrayInitializer.add(pair);
        ArrayType arrType = ArrayType.get(structTy, BigInteger.valueOf(arrayInitializer.size()));
        Constant pairArray = ConstantArray.get(arrType, arrayInitializer);
        arrayInitializer.delete();
        GlobalVariable.Create(module, pairArray.getType(), true, GlobalValue.LinkageTypes.ExternalLinkage, pairArray, mapName, null);
        return module;
    }

    public static llvm.Module generateBitcode(LLVMEmitterOptions opts, Boolean writeOutput) throws IOException {
        GlobalOptimizer.InputAbc ia;
        if (opts.builtInABCs.size() < 1) {
            LLVMEmitter.usage("No builtin abcs specified");
        }
        if (opts.appABCs.size() < 1) {
            LLVMEmitter.usage("No application abcs specified");
        }
        if (writeOutput.booleanValue() && opts.output == null) {
            LLVMEmitter.usage("No output file specified");
        }
        if (opts.runtimeBitcode == null) {
            LLVMEmitter.usage("No runtime bitcode specified");
        }
        if (!opts.runtimeBitcode.canRead()) {
            LLVMEmitter.usage("Can't access runtime bitcode: " + opts.runtimeBitcode.getAbsolutePath());
        }
        GlobalOptimizer go = new GlobalOptimizer();
        go.legacy_verifier = true;
        go.verbose_mode = opts.verbose;
        go.m_llvmEmitter = new LLVMEmitter();
        go.m_llvmEmitter.useARMCallingConvention = opts.useARMCallingConvention;
        go.m_llvmEmitter.m_debugger = opts.debugger;
        go.m_llvmEmitter.debugMessages = opts.debugMessages;
        go.m_llvmEmitter.runtimeDebugging = opts.runtimeDebugging;
        LLVMEmitter cfr_ignored_0 = go.m_llvmEmitter;
        optLazyEvals = opts.optLevel > 0 && opts.disableLazyEval == false;
        go.m_llvmEmitter.debugBuiltins = opts.debugBuiltins;
        go.m_llvmEmitter.setBitcodeFiles(opts.runtimeBitcode);
        go.m_llvmEmitter.m_logPerf = opts.logPerf;
        ArrayList<GlobalOptimizer.InputAbc> builtInABCs = new ArrayList<GlobalOptimizer.InputAbc>();
        ArrayList<GlobalOptimizer.InputAbc> appABCs = new ArrayList<GlobalOptimizer.InputAbc>();
        Domain d2 = BuiltinDomain.instance();
        BuiltinDomain.instance().enabledFailedLookupExceptions();
        GlobalOptimizer.IIDManager iidMgr = go.new GlobalOptimizer.IIDManager();
        int abcid = 0;
        for (String abcfile : opts.builtInABCs) {
            GlobalOptimizer globalOptimizer = go;
            globalOptimizer.getClass();
            ia = globalOptimizer.new GlobalOptimizer.InputAbc(d2, abcid++, iidMgr);
            ia.readAbc(abcfile);
            ia.src_filename = abcfile;
            builtInABCs.add(ia);
        }
        d2 = new Domain(d2, true, APIVersions.kApiVersion_VM_INTERNAL);
        for (String abcfile : opts.appABCs) {
            GlobalOptimizer globalOptimizer = go;
            globalOptimizer.getClass();
            ia = globalOptimizer.new GlobalOptimizer.InputAbc(d2, abcid++, iidMgr);
            ia.readAbc(abcfile);
            ia.src_filename = abcfile;
            appABCs.add(ia);
        }
        for (GlobalOptimizer.InputAbc iabc : builtInABCs) {
            iabc.readBodies();
            iabc.resolveTypes();
        }
        for (GlobalOptimizer.InputAbc iabc : appABCs) {
            iabc.readBodies();
            iabc.resolveTypes();
        }
        LLVMEmitter.syncMethodInformation(builtInABCs, appABCs);
        HashMap<GlobalOptimizer.InputAbc, Pair<GlobalOptimizer.Abc, byte[]>> iabcToAbc = new HashMap<GlobalOptimizer.InputAbc, Pair<GlobalOptimizer.Abc, byte[]>>();
        LLVMEmitter.optimizeABCs(go, builtInABCs, iabcToAbc, true);
        LLVMEmitter.optimizeABCs(go, appABCs, iabcToAbc, true);
        go.m_llvmEmitter.LogTiming("GlobalOptimizer");
        go.m_llvmEmitter.processABCs(builtInABCs, appABCs, iabcToAbc);
        if (writeOutput.booleanValue()) {
            go.m_llvmEmitter.m_module.write(opts.output);
        }
        BuiltinDomain.removeInstance();
        return go.m_llvmEmitter.m_module.m_module;
    }

    private GlobalVariable createAbcEnvGlobal(GlobalOptimizer.InputAbc iabc) {
        ConstantPointerNull abcEnvPtr = ConstantPointerNull.get(this.m_module.types.AbcEnvPtrTy);
        GlobalVariable abcEnvPtrGlobal = this.m_module.createGlobal("abcEnvPtr_" + iabc.id, false, abcEnvPtr);
        return abcEnvPtrGlobal;
    }

    public void processABCs(List<GlobalOptimizer.InputAbc> builtInABCs, List<GlobalOptimizer.InputAbc> appABCs, Map<GlobalOptimizer.InputAbc, Pair<GlobalOptimizer.Abc, byte[]>> iabcToAbc) throws IOException {
        boolean cacheddebugMessages = this.debugMessages;
        if (!this.debugBuiltins) {
            this.debugMessages = false;
        }
        HashMap<GlobalOptimizer.InputAbc, GlobalVariable> iabcToAbcEnv = new HashMap<GlobalOptimizer.InputAbc, GlobalVariable>();
        for (GlobalOptimizer.InputAbc iabc : builtInABCs) {
            iabcToAbcEnv.put(iabc, this.createAbcEnvGlobal(iabc));
        }
        for (GlobalOptimizer.InputAbc iabc : appABCs) {
            iabcToAbcEnv.put(iabc, this.createAbcEnvGlobal(iabc));
        }
        this.makeTypeIdsForParameterizedTypesInstances(BuiltinDomain.instance().parameterizedTypesInstances());
        for (GlobalOptimizer.InputAbc builtinABC : builtInABCs) {
            Pair<GlobalOptimizer.Abc, byte[]> abc = iabcToAbc.get(builtinABC);
            String builtinScriptName = builtinABC.scriptBaseName();
            String builtinABCInfoGlobalName = builtinScriptName.toLowerCase() + "_aotInfo";
            String glueClassTypesGlobal = "aotABCTypes_" + builtinScriptName.toLowerCase();
            this.m_glueClassNameToLLVMTypes.putAll(LLVMTypeExtractor.extractToMap(this.m_module, glueClassTypesGlobal));
            Constant abcInfoConstant = this.emit(builtinABC, (GlobalOptimizer.Abc)abc.fst, (byte[])abc.snd, iabcToAbcEnv, builtinScriptName);
            this.m_module.setGlobal(true, abcInfoConstant, builtinABCInfoGlobalName, false);
        }
        if (!this.debugBuiltins) {
            this.debugMessages = cacheddebugMessages;
        }
        ArrayList<Constant> abcInfos = new ArrayList<Constant>();
        for (GlobalOptimizer.InputAbc appABC : appABCs) {
            Pair<GlobalOptimizer.Abc, byte[]> abc = iabcToAbc.get(appABC);
            Constant abcInfoConstant = this.emit(appABC, (GlobalOptimizer.Abc)abc.fst, (byte[])abc.snd, iabcToAbcEnv, appABC.scriptBaseName());
            abcInfos.add(abcInfoConstant);
        }
        Constant abcInfosConstant = this.m_module.getConstantArray(abcInfos);
        this.m_module.setGlobal(true, abcInfosConstant, "aotInfos", true);
        this.m_module.setGlobal(true, this.constantInt(32L, abcInfos.size()), "nAOTInfos", false);
        if (this.debugMessages) {
            System.out.println("Call stats:");
            System.out.println("call                  : " + this.m_numCall);
            System.out.println("callprop              : " + this.m_numCallProp);
            System.out.println("call/get/set interface: " + this.m_numInterface);
            System.out.println("callinterface         : " + this.m_numCallInterface);
            System.out.println("callstatic(native)    : " + this.m_numCallStaticNative);
            System.out.println("callstatic(user)      : " + this.m_numCallMethodEnvFromIndex);
            System.out.println("callmethod            : " + this.m_numCallMethod);
            System.out.println("callsupermethod       : " + this.m_numCallSuperMethod);
            System.out.println("callsuper             : " + this.m_numCallSuper);
            System.out.println("calldirect            : " + this.m_numCallDirect);
            System.out.println("\nProperty stats:");
            System.out.println("findprop              : " + this.m_numFindProp);
            System.out.println("getprop               : " + this.m_numGetProp);
            System.out.println("setprop               : " + this.m_numSetProp);
            System.out.println("getslot               : " + this.m_numGetSlot);
            System.out.println("setslot               : " + this.m_numSetSlot);
            System.out.println("\nOther stats:");
            System.out.println("finddef               : " + this.m_numfinddef);
            System.out.println("cached finddef        : " + this.m_numcachedfinddef);
            System.out.println("pushstring            : " + this.m_numpushstring);
        }
    }

    private void printMsg(String s2) {
        if (this.debugMessages) {
            System.out.println(s2);
        }
    }

    private void printErr(String s2) {
        if (this.debugMessages) {
            System.err.println(s2);
        }
    }

    private static Comparator<Type> makeTypeComparator(Type[] items) {
        final HashMap<Type, Integer> result = new HashMap<Type, Integer>();
        int id = 0;
        for (Type t2 : items) {
            result.put(t2, id);
            ++id;
        }
        return new Comparator<Type>(){

            @Override
            public int compare(Type t0, Type t1) {
                return (Integer)result.get(t0) - (Integer)result.get(t1);
            }
        };
    }

    private static <T> Comparator<T> makePreservingComparator(T[] arr) {
        final HashMap<T, Integer> idMap = new HashMap<T, Integer>();
        for (int i2 = 1; i2 < arr.length; ++i2) {
            idMap.put(arr[i2], i2);
        }
        return new Comparator<T>(){

            @Override
            public int compare(T a, T b3) {
                Integer idA = (Integer)idMap.get(a);
                if (idA == null) {
                    return 1;
                }
                Integer idB = (Integer)idMap.get(b3);
                if (idB == null) {
                    return -1;
                }
                return idA - idB;
            }
        };
    }

    private static void optimizeABCs(GlobalOptimizer go, Iterable<GlobalOptimizer.InputAbc> abcs, Map<GlobalOptimizer.InputAbc, Pair<GlobalOptimizer.Abc, byte[]>> iabcToAbc, boolean preserveIds) throws IOException {
        for (GlobalOptimizer.InputAbc iabc : abcs) {
            GlobalOptimizer.Abc abc = null;
            if (preserveIds) {
                int i2;
                Comparator<String> stringPoolComparator = LLVMEmitter.makePreservingComparator(iabc.strings);
                Comparator<Name> namePoolComparator = LLVMEmitter.makePreservingComparator(iabc.names);
                Comparator<Method> compareMethods = new Comparator<Method>(){

                    @Override
                    public int compare(Method m0, Method m1) {
                        return m0.compareTo(m1);
                    }
                };
                Comparator<Type> compareScripts = LLVMEmitter.makeTypeComparator(iabc.scripts);
                Comparator<Type> compareClasses = LLVMEmitter.makeTypeComparator(iabc.classes);
                GlobalOptimizer globalOptimizer = go;
                globalOptimizer.getClass();
                abc = globalOptimizer.new GlobalOptimizer.Abc(iabc, stringPoolComparator, namePoolComparator, compareMethods, compareScripts, compareClasses);
                for (i2 = 1; i2 < iabc.strings.length; ++i2) {
                    if (iabc.strings[i2] == null) continue;
                    abc.stringPool.add(iabc.strings[i2]);
                }
                for (i2 = 1; i2 < iabc.names.length; ++i2) {
                    if (iabc.names[i2] == null) continue;
                    abc.addName(iabc.names[i2]);
                }
            } else {
                GlobalOptimizer globalOptimizer = go;
                globalOptimizer.getClass();
                abc = globalOptimizer.new GlobalOptimizer.Abc(iabc);
            }
            go.optimize(iabc, true);
            byte[] abcBytes = go.emit(abc, iabc, false);
            iabcToAbc.put(iabc, new Pair<GlobalOptimizer.Abc, byte[]>(abc, abcBytes));
        }
    }

    private static String jniMapOSName(String name) {
        if (name.equals("Mac OS X")) {
            return "Darwin";
        }
        return "win32";
    }

    public static void loadJNI() {
        block7: {
            URL urlToClass = LLVMEmitter.class.getProtectionDomain().getCodeSource().getLocation();
            try {
                File dirToSearch;
                File classLocation = new File(urlToClass.toURI());
                String osName = LLVMEmitter.jniMapOSName(System.getProperty("os.name"));
                File parentDir = classLocation.getParentFile();
                String libDir = "/aot/lib";
                if (System.getProperty("java.vm.name").contains("64")) {
                    libDir = "/aot/lib/x64";
                }
                File[] dirsToSearch = new File[]{new File(classLocation, osName), new File(parentDir, libDir), classLocation, parentDir};
                String errorStr = "Unable to find llvm JNI lib in:\n";
                File shLibFile = null;
                String libBase = "llvm";
                String libraryName = System.mapLibraryName(libBase);
                File[] arr$ = dirsToSearch;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && !(shLibFile = new File(dirToSearch = arr$[i$], libraryName)).exists(); ++i$) {
                    errorStr = errorStr + dirToSearch.getAbsolutePath() + "\n";
                    shLibFile = null;
                }
                if (shLibFile == null) {
                    try {
                        System.loadLibrary(libBase);
                        break block7;
                    }
                    catch (UnsatisfiedLinkError e2) {
                        throw new Error(errorStr);
                    }
                }
                System.load(shLibFile.getAbsolutePath());
            }
            catch (URISyntaxException e3) {
                throw new Error("Unable to get URI:" + urlToClass.toString());
            }
        }
    }

    private static <T> T[] arr(T ... t2) {
        return t2;
    }

    private static <T> T[] concat(T[] ... arrays) {
        ArrayList<T> resultList = new ArrayList<T>();
        T[][] arr$ = arrays;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            T[] a;
            for (T t2 : a = arr$[i$]) {
                resultList.add(t2);
            }
        }
        Object[] emptyArray = (Object[])Array.newInstance(arrays[0].getClass().getComponentType(), 0);
        return resultList.toArray(emptyArray);
    }

    private FunctionType getMethodFunctionType(Method m2) {
        ArrayList<llvm.Type> paramLLVMTypes = new ArrayList<llvm.Type>();
        for (Typeref p2 : m2.params) {
            paramLLVMTypes.add(this.m_module.llvmType(p2.getType()));
        }
        if (m2.needsRest() || m2.needsArguments()) {
            paramLLVMTypes.add(this.m_module.types.AtomTy);
            paramLLVMTypes.add(this.m_module.types.intTy);
            paramLLVMTypes.add(this.m_module.types.ArrayObjectPtrTy);
        }
        paramLLVMTypes.add(this.m_module.types.MethodEnvPtrTy);
        llvm.Type resultType = this.m_module.llvmType(m2.getReturnType().getType());
        llvm.Type[] paramTypes = paramLLVMTypes.toArray(new llvm.Type[0]);
        return Module.getFunctionType(resultType, paramTypes, false);
    }

    private void setTypeId(Type t2, Constant typeId) {
        assert (this.m_TypeIds.get(t2) == null);
        this.m_TypeIds.put(t2, typeId);
    }

    private Constant getTypeId(Type t2) {
        Constant result;
        Constant existingId = this.m_TypeIds.get(t2);
        if (existingId != null) {
            llvm.Type existingIdType = existingId.getType();
            assert (LLVMStubTypes.compareTypes(existingIdType, this.m_module.types.TraitsIdTy));
            return existingId;
        }
        if (t2 != BuiltinDomain.instance().ANY()) {
            String traitsGlobalVarName = t2.name == null ? "" : "abcTraits_" + t2.name;
            result = this.m_module.createGlobal(traitsGlobalVarName, false, ConstantPointerNull.get(this.m_module.types.TraitsPtrTy));
        } else {
            result = ConstantPointerNull.get(this.m_module.types.TraitsIdTy);
        }
        this.setTypeId(t2, result);
        llvm.Type resultType = ((Value)result).getType();
        assert (LLVMStubTypes.compareTypes(resultType, this.m_module.types.TraitsIdTy));
        return result;
    }

    private void referenceMethods(Type t2) {
        for (Binding b3 : t2.defs.values()) {
            if (!b3.isGetter() && !b3.isSetter() && !b3.isMethod()) continue;
            this.referenceMethod(b3.method, t2.name.toString());
        }
    }

    private void referenceMethod(Method m2, String reference) {
        if (this.m_referencedMethods.get(m2) != null) {
            String errorStr = "Method " + String.valueOf(m2.id) + " is referenced more than once.";
            throw new Error(errorStr);
        }
        this.m_referencedMethods.put(m2, reference);
    }

    final void recordScopeDepth(Expr e2, int depth) {
        assert (e2.op == 48 || e2.op == 28 || e2.op == 29);
        this.m_scopeDepths.put(e2, depth);
    }

    private final int getScopeDepth(Expr e2) {
        this.printErr("getScopeDepth: " + e2.toString());
        assert (e2.op == 48 || e2.op == 28 || e2.op == 29);
        assert (this.m_scopeDepths.containsKey(e2));
        return this.m_scopeDepths.get(e2);
    }

    private final Method createEmptyInitMethod(GlobalOptimizer.InputAbc abc, Type thisType) {
        Method initMethod = new Method(-1, abc);
        initMethod.hasExceptions = false;
        initMethod.params = new Typeref[]{thisType.ref.nonnull()};
        initMethod.values = new Object[]{null};
        initMethod.optional_count = 0;
        initMethod.returns = BuiltinDomain.instance().VOID().ref;
        initMethod.debugName = thisType.name.toString() + "_generated_init";
        initMethod.name = abc.domain().createNameWithPublicNamespace(initMethod.debugName);
        initMethod.paramNames = null;
        initMethod.flags = 0;
        initMethod.cx = thisType;
        initMethod.kind = Method.Kind.GENERATED_INIT;
        initMethod.max_stack = 2;
        initMethod.max_scope = 1;
        initMethod.local_count = 1;
        initMethod.code_len = 0;
        initMethod.entry = new Edge(initMethod, null, 0);
        initMethod.entry.to = new Block(initMethod, -3);
        Expr returnExpr = new Expr(initMethod, 71);
        returnExpr.succ = OptimizerConstants.noedges;
        initMethod.entry.to.add(returnExpr);
        return initMethod;
    }

    final void recordType(GlobalOptimizer.InputAbc abc, Type t2) {
        assert (!this.m_visitedTypes.contains(t2));
        this.m_visitedTypes.add(t2);
        this.genInitMethod(abc, t2);
    }

    final void recordMethod(Method m2) {
        if (m2.needActivation()) {
            assert (m2.activation.getType().init == null);
            this.genInitMethod(m2.abc, m2.activation.getType());
        }
    }

    private void genInitMethod(GlobalOptimizer.InputAbc abc, Type t2) {
        Method init;
        Method method = init = t2.init != null ? t2.init : this.createEmptyInitMethod(abc, t2);
        assert (init != null);
        if (t2.isInterface()) {
            assert (t2.getLocalSlots().size() == 0);
            return;
        }
        assert (init.entry != null);
        assert (init.entry.to != null);
        Block oldInitEntryBlock = init.entry.to;
        assert (oldInitEntryBlock != null);
        Block newInitEntryBlock = new Block(init, -2);
        Expr thisArg = new Expr(init, 256, -1, 0);
        newInitEntryBlock.add(thisArg);
        Collection<Binding> slots = t2.getLocalSlots();
        for (Binding s2 : slots) {
            Object defaultValue = s2.value();
            int opCode = 0;
            if (defaultValue instanceof Integer) {
                opCode = 45;
                Integer defValueInt = (Integer)defaultValue;
                if (defValueInt == 0 && s2.type.getType() == BuiltinDomain.instance().INT()) {
                    defaultValue = null;
                    opCode = 0;
                }
            } else if (defaultValue instanceof Long) {
                opCode = 46;
                Long defValueLong = (Long)defaultValue;
                if (defValueLong == 0L && s2.type.getType() == BuiltinDomain.instance().UINT()) {
                    defaultValue = null;
                    opCode = 0;
                }
            } else if (defaultValue instanceof Double) {
                opCode = 47;
                Double defValueDouble = (Double)defaultValue;
                if (Double.doubleToLongBits(defValueDouble) == 0L && s2.type.getType() == BuiltinDomain.instance().NUMBER()) {
                    defaultValue = null;
                    opCode = 0;
                }
            } else if (defaultValue instanceof String) {
                opCode = 44;
            } else if (defaultValue instanceof Namespace) {
                opCode = 49;
            } else if (defaultValue == Boolean.TRUE) {
                opCode = 38;
            } else if (defaultValue == Boolean.FALSE) {
                opCode = 39;
                Boolean defValueBoolean = (Boolean)defaultValue;
                if (!defValueBoolean.booleanValue() && s2.type.getType() == BuiltinDomain.instance().BOOLEAN()) {
                    defaultValue = null;
                    opCode = 0;
                }
            } else if (defaultValue == OptimizerConstants.UNDEFINED) {
                opCode = 33;
                defaultValue = null;
            } else if (defaultValue == BuiltinDomain.instance().NULL() && s2.type.getType().isAtom()) {
                opCode = 32;
            }
            if (opCode == 0) continue;
            Expr defaultValueExpr = new Expr(init, opCode);
            defaultValueExpr.value = defaultValue;
            newInitEntryBlock.add(defaultValueExpr);
            assert (s2.slot > 0);
            Expr setSlotExpr = new Expr(init, 109, -1, s2.slot);
            setSlotExpr.args = new Expr[]{thisArg, defaultValueExpr};
            newInitEntryBlock.add(setSlotExpr);
            s2.setValue(s2.type.t.defaultValue);
            assert (!s2.defaultValueChanged());
            init.entry.to = newInitEntryBlock;
        }
        if (init.entry.to == newInitEntryBlock) {
            for (Expr e2 : oldInitEntryBlock) {
                newInitEntryBlock.add(e2);
            }
            for (Edge e3 : oldInitEntryBlock.succ()) {
                assert (e3.from == oldInitEntryBlock);
                e3.from = newInitEntryBlock;
            }
            for (Edge e4 : oldInitEntryBlock.xsucc) {
                assert (e4.from == oldInitEntryBlock);
                e4.from = newInitEntryBlock;
            }
            t2.init = init;
        }
    }

    final void recordMethodTypes(Method m2, Map<Expr, Typeref> types) {
        assert (!this.m_methodTypeInfo.containsKey(m2.abc) || !this.m_methodTypeInfo.get(m2.abc).containsKey(m2));
        Map<Method, Map<Expr, Typeref>> typesForAbc = this.m_methodTypeInfo.get(m2.abc);
        if (typesForAbc == null) {
            typesForAbc = new HashMap<Method, Map<Expr, Typeref>>();
            this.m_methodTypeInfo.put(m2.abc, typesForAbc);
        }
        typesForAbc.put(m2, types);
    }

    final void recordMethodUses(Method m2, Algorithms.EdgeMap<Expr> uses) {
        assert (!this.m_methodUseInfo.containsKey(m2.abc) || !this.m_methodUseInfo.get(m2.abc).containsKey(m2));
        Map<Method, Algorithms.EdgeMap<Expr>> usesForAbc = this.m_methodUseInfo.get(m2.abc);
        if (usesForAbc == null) {
            usesForAbc = new HashMap<Method, Algorithms.EdgeMap<Expr>>();
            this.m_methodUseInfo.put(m2.abc, usesForAbc);
        }
        usesForAbc.put(m2, uses);
    }

    static Map<String, Field> publicFieldsMap(Class<?> c2) {
        HashMap<String, Field> fields = new HashMap<String, Field>();
        for (Field f2 : LLVMStubTypes.class.getDeclaredFields()) {
            if (!Modifier.isPublic(f2.getModifiers())) continue;
            fields.put(f2.getName(), f2);
        }
        return fields;
    }

    private LLVMEmitter() {
        this.m_ctx = new LLVMContext();
        this.m_methodTypeInfo = new HashMap<GlobalOptimizer.InputAbc, Map<Method, Map<Expr, Typeref>>>();
        this.m_methodUseInfo = new HashMap<GlobalOptimizer.InputAbc, Map<Method, Algorithms.EdgeMap<Expr>>>();
        this.m_TypeIds = new HashMap<Type, Constant>();
        this.m_visitedTypes = new HashSet<Type>();
        this.m_scopeDepths = new HashMap<Expr, Integer>();
        this.m_referencedMethods = new HashMap<Method, String>();
        this.m_glueClassNameToLLVMTypes = new HashMap<String, Pair<PointerType, llvm.Type>>();
        this.m_directCalls = new HashSet<String>();
        this.addMathFunction(this.m_directCalls);
        this.addStringFunction(this.m_directCalls);
    }

    private void addMathFunction(Set<String> functions) {
        String domain = "Math_";
        functions.add("Math_random");
        functions.add("Math_abs");
        functions.add("Math_acos");
        functions.add("Math_asin");
        functions.add("Math_atan");
        functions.add("Math_ceil");
        functions.add("Math_cos");
        functions.add("Math_exp");
        functions.add("Math_floor");
        functions.add("Math_log");
        functions.add("Math_round");
        functions.add("Math_sin");
        functions.add("Math_sqrt");
        functions.add("Math_tan");
        functions.add("Math_pow");
        functions.add("Math_atan2");
    }

    private void addStringFunction(Set<String> functions) {
        String domain = "String_";
        functions.add("String_toLowerCase");
        functions.add("String_toUpperCase");
        functions.add("String_toLocaleLowerCase");
        functions.add("String_toLocaleUpperCase");
        functions.add("String_charAt");
        functions.add("String_charCodeAt");
        functions.add("String_match");
        functions.add("String_search");
        functions.add("String_indexOf");
        functions.add("String_lastIndexOf");
        functions.add("String_replace");
        functions.add("String_slice");
        functions.add("String_split");
        functions.add("String_substring");
        functions.add("String_substr");
    }

    private void setBitcodeFiles(File runtimeBCFile) throws IOException {
        this.m_module = Module.load(this.m_ctx, runtimeBCFile, this.useARMCallingConvention);
        this.m_slotLayoutCache = new LLVMTamarinSlotLayoutCache(this.m_module.types);
    }

    private final Type[] sortedScripts(final GlobalOptimizer.Abc abc) {
        Type[] sortedScripts = new Type[abc.scripts.size()];
        sortedScripts = abc.scripts.toArray(sortedScripts);
        Arrays.sort(sortedScripts, new Comparator<Type>(){

            @Override
            public int compare(Type t0, Type t1) {
                return abc.scriptId(t0) - abc.scriptId(t1);
            }
        });
        return sortedScripts;
    }

    private final void emitInterfaceBindings(GlobalOptimizer.Abc abc, GlobalOptimizer.InputAbc inputABC, ArrayList<Constant> methodValues) {
        for (int classItr = 0; classItr < abc.classes.size(); ++classItr) {
            Type classType = abc.classes.get(classItr);
            Type currentClass = classType.itype;
            Constant ifunc = null;
            if (!currentClass.isInterface()) {
                ArrayList<Integer> iidArray = new ArrayList<Integer>();
                ArrayList<Integer> dispidArray = new ArrayList<Integer>();
                ArrayList<Type> interfaces = currentClass.getInterfaces();
                for (Type itype : interfaces) {
                    for (Binding ibind : itype.defs.values()) {
                        Name publicName = new Name(inputABC.domain().PUBLIC_PACKAGE(), ibind.getName().toString());
                        Binding classBinding = null;
                        switch (ibind.kind()) {
                            case 1: 
                            case 2: {
                                classBinding = currentClass.findGet(publicName);
                                break;
                            }
                            case 3: {
                                classBinding = currentClass.findSet(publicName);
                            }
                        }
                        if (classBinding == null) continue;
                        int iid = ibind.method.iid;
                        int dispid = classBinding.slot;
                        assert (!iidArray.contains(iid));
                        iidArray.add(iid);
                        dispidArray.add(dispid);
                    }
                }
                if (iidArray.size() > 0) {
                    String functionName = "InterfaceSwitch_" + inputABC.id + "_" + classItr + "_" + currentClass.name.format();
                    Function function = this.createInterfaceSwitchFunction(functionName, iidArray, dispidArray);
                    ifunc = ConstantExpr.getCast(Instruction.CastOps.BitCast.swigValue(), function.function(), this.m_module.types.InterfaceBindingFunctionPtrTy);
                }
            }
            if (ifunc == null) {
                methodValues.add(Constant.getNullValue(this.m_module.types.InterfaceBindingFunctionPtrTy));
                continue;
            }
            methodValues.add(ifunc);
        }
    }

    private final Function createInterfaceSwitchFunction(String inFunctionName, ArrayList<Integer> inIIDs, ArrayList<Integer> inFunctions) {
        llvm.Type[] typesArray = new llvm.Type[]{this.m_module.types.intTy};
        FunctionType functionType = Module.getFunctionType(this.m_module.types.intTy, typesArray, false);
        Function function = this.m_module.getOrCreateFunction(inFunctionName, functionType, this.useARMCallingConvention);
        BasicBlock entryBlock = function.addBlock("entry");
        BasicBlock returnBlock = function.addBlock("defaultBlock");
        returnBlock.addInstruction(ReturnInst.class, this.m_module.m_module.getContext(), this.constantInt(32L, -1L));
        Argument val = function.arg(0);
        SwitchInst sw = SwitchInst.Create((Value)val, returnBlock.m_origBlock, (long)(inIIDs.size() + 1), entryBlock.m_block);
        for (int i2 = 0; i2 < inIIDs.size(); ++i2) {
            BasicBlock newBlock = function.addBlock(inFunctionName + "_block_" + inIIDs.get(i2));
            newBlock.addInstruction(ReturnInst.class, this.m_module.m_module.getContext(), this.constantInt(32L, inFunctions.get(i2).intValue()));
            sw.addCase(LLVMEmitter.constantInt(this.m_module.m_module.getContext(), 32L, inIIDs.get(i2).intValue()), newBlock.m_origBlock);
        }
        return function;
    }

    private final Constant emit(GlobalOptimizer.InputAbc iabc, final GlobalOptimizer.Abc abc, byte[] abcBytes, Map<GlobalOptimizer.InputAbc, GlobalVariable> iabcToAbcEnv, String abcScriptName) {
        Constant lazyEvalInfoArrayPtr;
        Constant lazyEvalValArrayPtr;
        Constant lazyEvalPtrArrayPtr;
        Constant methodDebugInfoArrayPtr;
        Constant interfaceBindingFunctionsArrayPtr;
        this.lazyEvals = new ArrayList<LazyEval>();
        Constant abcBytesConstant = this.m_module.getConstantByteArray(abcBytes);
        GlobalVariable abcBytesGlobal = this.m_module.createGlobal("abcBytes_" + abcScriptName, true, abcBytesConstant);
        JNIStringRef sectname = new JNIStringRef("__DATA, __abc");
        abcBytesGlobal.setSection(sectname);
        sectname.delete();
        Constant abcenvPtrPtr = this.m_module.getGetElementPtrConstantExpression((Constant)iabcToAbcEnv.get(iabc), 0);
        Constant abcBytesPtr = ConstantExpr.getCast(Instruction.CastOps.BitCast.swigValue(), this.m_module.getGetElementPtrConstantExpression((Constant)abcBytesGlobal, 0, 0), this.m_module.types.charPtrTy);
        ConstantInt abcBytesLengthConstant = this.constantInt(32L, abcBytes.length);
        ScriptArrays scriptArrays = new ScriptArrays(abc, abcScriptName);
        TreeMap<Name, GlobalVariable> nameToMultiname = new TreeMap<Name, GlobalVariable>();
        assert (abc.nativeMethodPool.size() == abc.nativeMethodPool.countFrom || abc.nativeMethodPool == abc.nonNativeMethodPool);
        List<Method> methods = abc.nonNativeMethodPool.values();
        TreeSet<Method> sortedMethods = new TreeSet<Method>(new Comparator<Method>(){

            @Override
            public int compare(Method m0, Method m1) {
                return abc.methodId(m0) - abc.methodId(m1);
            }
        });
        for (Method m2 : methods) {
            sortedMethods.add(m2);
        }
        MethodArrays methodArrays = new MethodArrays(abc, abcScriptName, sortedMethods);
        this.emitMethods(abc, sortedMethods, iabcToAbcEnv, nameToMultiname);
        ArrayList<Constant> methodValues = new ArrayList<Constant>(methods.size());
        for (Method m3 : sortedMethods) {
            Constant castedFunction;
            if (!m3.isNative() && m3.entry != null) {
                Function f2 = this.m_abcMethodToLLVMFunction.get(m3);
                assert (f2 != null);
                castedFunction = this.m_module.functionToCompiledHandler(f2);
            } else {
                castedFunction = Constant.getNullValue(this.m_module.types.CompiledHandlerPtrTy);
            }
            methodValues.add(castedFunction);
        }
        ArrayList<Constant> interfaceBindingFunctions = new ArrayList<Constant>();
        this.emitInterfaceBindings(abc, iabc, interfaceBindingFunctions);
        if (interfaceBindingFunctions.size() > 0) {
            Constant interfaceBindingFunctionsConstant = this.m_module.getConstantArray(interfaceBindingFunctions);
            GlobalVariable interfaceBindingFunctionsGlobal = this.m_module.createGlobal("", true, interfaceBindingFunctionsConstant);
            interfaceBindingFunctionsArrayPtr = this.m_module.getGetElementPtrConstantExpression((Constant)interfaceBindingFunctionsGlobal, 0, 0);
        } else {
            interfaceBindingFunctionsArrayPtr = Constant.getNullValue(PointerType.get(this.m_module.types.InterfaceBindingFunctionPtrTy, 0L));
        }
        ConstantInt interfaceBindingFunctionsSizeConstant = this.constantInt(32L, interfaceBindingFunctions.size());
        Constant abcMethodsConstant = this.m_module.getConstantArray(methodValues);
        GlobalVariable abcMethodsGlobal = this.m_module.createGlobal("", true, abcMethodsConstant);
        Constant abcMethodsArrayPtr = this.m_module.getGetElementPtrConstantExpression((Constant)abcMethodsGlobal, 0, 0);
        if (this.m_debugger) {
            ArrayList<Constant> methodDebugInfoValues = new ArrayList<Constant>(methods.size());
            for (Method m1 : sortedMethods) {
                Constant linesArrayPtr;
                Constant local_namesArrayPtr;
                int file_name = 0;
                int num_local_names = m1.local_count + m1.max_scope;
                ArrayList<Constant> local_names = new ArrayList<Constant>(num_local_names);
                for (int i2 = 0; i2 < num_local_names; ++i2) {
                    local_names.add(this.constantInt(32L, 0L));
                }
                ArrayList<Constant> lines = new ArrayList<Constant>();
                if (m1.entry != null) {
                    Algorithms.Deque<Block> blocks = m1.depthFirstCfg();
                    for (Block b3 : blocks) {
                        for (Expr e2 : b3.exprs) {
                            switch (e2.op) {
                                case 241: {
                                    file_name = abc.stringPool.id((String)e2.value);
                                    break;
                                }
                                case 240: {
                                    lines.add(this.constantInt(32L, e2.imm[0]));
                                    break;
                                }
                                case 239: {
                                    if (e2.imm[0] != 1) break;
                                    int n2 = e2.imm[2];
                                    while (local_names.size() <= n2) {
                                        local_names.add(this.constantInt(32L, 0L));
                                    }
                                    local_names.set(n2, this.constantInt(32L, abc.stringPool.id((String)e2.value)));
                                }
                            }
                        }
                    }
                }
                if (local_names.size() != 0) {
                    Constant local_namesConstant = this.m_module.getConstantArray(local_names);
                    GlobalVariable local_namesGlobal = this.m_module.createGlobal("", true, local_namesConstant);
                    local_namesArrayPtr = this.m_module.getGetElementPtrConstantExpression((Constant)local_namesGlobal, 0, 0);
                } else {
                    local_namesArrayPtr = Constant.getNullValue(this.m_module.types.intPtrTy);
                }
                if (lines.size() != 0) {
                    Constant linesConstant = this.m_module.getConstantArray(lines);
                    GlobalVariable linesGlobal = this.m_module.createGlobal("", true, linesConstant);
                    linesArrayPtr = this.m_module.getGetElementPtrConstantExpression((Constant)linesGlobal, 0, 0);
                } else {
                    linesArrayPtr = Constant.getNullValue(this.m_module.types.intPtrTy);
                }
                methodDebugInfoValues.add(Module.getConstantStruct(this.m_module.types.MethodDebugInfoTy, this.constantInt(32L, m1.local_count), this.constantInt(32L, m1.max_scope), this.constantInt(32L, file_name), local_namesArrayPtr, this.constantInt(32L, lines.size()), linesArrayPtr));
            }
            Constant methodDebugInfoConstant = this.m_module.getConstantArray(methodDebugInfoValues);
            GlobalVariable methodDebugInfoGlobal = this.m_module.createGlobal("", true, methodDebugInfoConstant);
            methodDebugInfoArrayPtr = this.m_module.getGetElementPtrConstantExpression((Constant)methodDebugInfoGlobal, 0, 0);
        } else {
            methodDebugInfoArrayPtr = Constant.getNullValue(PointerType.get(this.m_module.types.MethodDebugInfoTy, 0L));
        }
        ArrayList<Constant> multinameValues = new ArrayList<Constant>(nameToMultiname.size() + 1);
        ArrayList<Constant> multinameIndexValues = new ArrayList<Constant>(nameToMultiname.size() + 1);
        for (Name name : nameToMultiname.keySet()) {
            multinameIndexValues.add(this.constantInt(32L, abc.namePool.id(name)));
            multinameValues.add((Constant)nameToMultiname.get(name));
        }
        multinameIndexValues.add(this.constantInt(32L, -1L));
        multinameValues.add(Constant.getNullValue(this.m_module.types.MultinamePtrTy));
        Constant multinameArray = this.m_module.getConstantArray(multinameValues);
        Constant multinameIndexArray = this.m_module.getConstantArray(multinameIndexValues);
        GlobalVariable multinameGlobal = this.m_module.createGlobal("", true, multinameArray);
        GlobalVariable multinameIndexGlobal = this.m_module.createGlobal("", true, multinameIndexArray);
        Constant multinames = this.m_module.getGetElementPtrConstantExpression((Constant)multinameGlobal, 0, 0);
        Constant multinameIndices = this.m_module.getGetElementPtrConstantExpression((Constant)multinameIndexGlobal, 0, 0);
        assert (iabc.sha1.length == 20);
        ArrayList<Constant> sha1Values = new ArrayList<Constant>(20);
        for (byte b4 : iabc.sha1) {
            sha1Values.add(this.constantInt(8L, b4));
        }
        Constant origABCSHA1 = this.m_module.getConstantArray(sha1Values);
        if (this.lazyEvals.size() > 0) {
            ArrayList<Constant> lazyEvalPtrConstants = new ArrayList<Constant>();
            ArrayList<Constant> lazyEvalValConstants = new ArrayList<Constant>();
            for (LazyEval info : this.lazyEvals) {
                lazyEvalPtrConstants.add(UndefValue.get(this.m_module.types.uintPtrTy));
                lazyEvalValConstants.add(UndefValue.get(this.m_module.types.uintTy));
            }
            GlobalVariable lazyEvalPtrArray = this.m_module.createGlobal("lazyEvalPtrs", false, this.m_module.getConstantArray(lazyEvalPtrConstants));
            lazyEvalPtrArrayPtr = this.m_module.getGetElementPtrConstantExpression((Constant)lazyEvalPtrArray, 0, 0);
            GlobalVariable lazyEvalValArray = this.m_module.createGlobal("lazyEvalVals", false, this.m_module.getConstantArray(lazyEvalValConstants));
            lazyEvalValArrayPtr = this.m_module.getGetElementPtrConstantExpression((Constant)lazyEvalValArray, 0, 0);
            int i3 = 0;
            ArrayList<Constant> lazyEvalInfoConstants = new ArrayList<Constant>();
            for (LazyEval info : this.lazyEvals) {
                Constant ptn = this.m_module.getGetElementPtrConstantExpression((Constant)lazyEvalPtrArray, 0, i3);
                info.ptrLoad.setOperand(0L, ptn);
                int methodId = abc.methodId(info.method);
                Constant constant = Module.getConstantStruct(this.m_module.types.AOTLazyEvalInfoTy, this.constantInt(32L, methodId), info.evaluator, info.evaluatorData);
                lazyEvalInfoConstants.add(constant);
                ++i3;
            }
            Constant lazyEvalInfoArrayInit = this.m_module.getConstantArray(lazyEvalInfoConstants);
            GlobalVariable lazyEvalInfoArray = this.m_module.createGlobal("lazyEvalInfos", true, lazyEvalInfoArrayInit);
            lazyEvalInfoArrayPtr = this.m_module.getGetElementPtrConstantExpression((Constant)lazyEvalInfoArray, 0, 0);
        } else {
            lazyEvalInfoArrayPtr = Constant.getNullValue(PointerType.get(this.m_module.types.AOTLazyEvalInfoTy, 0L));
            lazyEvalPtrArrayPtr = Constant.getNullValue(PointerType.get(this.m_module.types.uintPtrTy, 0L));
            lazyEvalValArrayPtr = Constant.getNullValue(this.m_module.types.uintPtrTy);
        }
        Constant abcInfoStruct = Module.getConstantStruct(this.m_module.types.AOTInfoTy, origABCSHA1, abcBytesPtr, abcBytesLengthConstant, methodDebugInfoArrayPtr, abcMethodsArrayPtr, this.constantInt(32L, sortedMethods.size()), scriptArrays.scriptTraitsArrayPtr, interfaceBindingFunctionsArrayPtr, interfaceBindingFunctionsSizeConstant, methodArrays.activationTraitsArrayPtr, methodArrays.activationTraitsInfoPtr, this.constantInt(32L, methodArrays.nActivationraits), lazyEvalInfoArrayPtr, lazyEvalPtrArrayPtr, lazyEvalValArrayPtr, this.constantInt(32L, this.lazyEvals.size()), abcenvPtrPtr, multinames, multinameIndices);
        return abcInfoStruct;
    }

    private void emitMethods(GlobalOptimizer.Abc abc, Collection<Method> sortedMethods, Map<GlobalOptimizer.InputAbc, GlobalVariable> iabcToAbcEnv, Map<Name, GlobalVariable> nameToMultiname) {
        for (Method m2 : sortedMethods) {
            if (m2.isNative() || m2.entry == null) continue;
            this.printMsg("emitting method dname:\"" + m2.debugName + "\" name:\"" + m2.name.toString() + "\"");
            MethodEmitter emitter = new MethodEmitter(abc, m2, this.m_methodTypeInfo.get(m2.abc).get(m2), this.m_methodUseInfo.get(m2.abc).get(m2), iabcToAbcEnv, nameToMultiname, this.m_debugger);
            Function f2 = emitter.emit();
            assert (this.m_abcMethodToLLVMFunction.get(m2) == f2);
        }
    }

    final boolean outputMethodBody(Method m2) {
        boolean result;
        Map<Method, Map<Expr, Typeref>> methodTypeInfoForAbc = this.m_methodTypeInfo.get(m2.abc);
        boolean bl2 = result = methodTypeInfoForAbc == null || !methodTypeInfoForAbc.containsKey(m2);
        assert (!result);
        if (m2.needActivation()) {
            return true;
        }
        return result;
    }

    private ConstantInt constantInt(long numBits, long val) {
        return LLVMEmitter.constantInt(this.m_ctx, numBits, val);
    }

    private static ConstantInt constantInt(LLVMContext ctx, long numBits, long val) {
        JNIStringRef sv = new JNIStringRef(String.valueOf(val));
        APInt i2 = new APInt(numBits, sv, 10);
        ConstantInt result = ConstantInt.get(ctx, i2);
        i2.delete();
        sv.delete();
        return result;
    }

    private void makeTypeIdsForParameterizedTypesInstances(Map<Type, Set<Type>> parameterizedTypesInstances) {
        Type[] instancesArray;
        GlobalVariable globalForParameterizedType;
        ArrayList<Pair<GlobalVariable, Type[]>> globalsForParameterizedTypes = new ArrayList<Pair<GlobalVariable, Type[]>>();
        HashMap<GlobalVariable, StructType> globalToStructType = new HashMap<GlobalVariable, StructType>();
        for (Map.Entry<Type, Set<Type>> entry : parameterizedTypesInstances.entrySet()) {
            Type parameterizedType = entry.getKey();
            Set<Type> parameterizedTypeInstances = entry.getValue();
            assert (!parameterizedType.isParameterizedTypeInstance());
            String parameterizedTypeName = parameterizedType.getName().toString();
            String globalArrayNameForParameterizedType = "abc" + parameterizedTypeName + "Instances";
            GlobalVariable globalArrayForParameterizedType = this.m_module.getGlobal(globalArrayNameForParameterizedType, true);
            if (globalArrayForParameterizedType == null) {
                throw new Error("Unable to find global " + globalArrayNameForParameterizedType + ".");
            }
            PointerType globalType = PointerType.dyn_cast(SequentialType.dyn_cast(CompositeType.dyn_cast(DerivedType.dyn_cast(((Value)globalArrayForParameterizedType).getType()))));
            ArrayType globalArrayType = ArrayType.dyn_cast(SequentialType.dyn_cast(CompositeType.dyn_cast(DerivedType.dyn_cast(globalType.getElementType()))));
            StructType parameterizedStructType = StructType.dyn_cast(CompositeType.dyn_cast(DerivedType.dyn_cast(globalArrayType.getElementType())));
            ArrayType newGlobalArrayType = ArrayType.get(parameterizedStructType, BigInteger.valueOf(parameterizedTypeInstances.size()));
            GlobalVariable newGlobalArray = this.m_module.setGlobalType(newGlobalArrayType, false, globalArrayNameForParameterizedType);
            Type[] instancesArray2 = parameterizedTypeInstances.toArray(new Type[0]);
            globalsForParameterizedTypes.add(new Pair<GlobalVariable, Type[]>(newGlobalArray, instancesArray2));
            globalToStructType.put(newGlobalArray, parameterizedStructType);
            String globalArrayLengthNameForParameterizedType = "abcN" + parameterizedTypeName + "Instances";
            this.m_module.setGlobal(true, this.constantInt(32L, instancesArray2.length), globalArrayLengthNameForParameterizedType, false);
        }
        for (Pair pair : globalsForParameterizedTypes) {
            globalForParameterizedType = (GlobalVariable)pair.fst;
            instancesArray = (Type[])pair.snd;
            for (int i2 = 0; i2 < instancesArray.length; ++i2) {
                Constant traitsId = this.m_module.getGetElementPtrConstantExpression((Constant)globalForParameterizedType, 0, i2, 0);
                this.setTypeId(instancesArray[i2], traitsId);
                assert (LLVMStubTypes.compareTypes(this.getTypeId(instancesArray[i2]).getType(), this.m_module.types.TraitsIdTy));
            }
        }
        for (Pair pair : globalsForParameterizedTypes) {
            globalForParameterizedType = (GlobalVariable)pair.fst;
            instancesArray = (Type[])pair.snd;
            StructType structTypeForParameterizedTypeInstance = (StructType)globalToStructType.get(globalForParameterizedType);
            int nStructMembers = (int)structTypeForParameterizedTypeInstance.getNumElements();
            ArrayList<Constant> structsForParameterizedTypeInstances = new ArrayList<Constant>();
            for (int i3 = 0; i3 < instancesArray.length; ++i3) {
                Type parameterizedTypeInstance = instancesArray[i3];
                if (parameterizedTypeInstance.typeParameters().length != nStructMembers - 1) {
                    throw new Error("Incorrect number of struct members for parameterized type instance!!");
                }
                ArrayList<Constant> valuesForParameterizedTypeInstance = new ArrayList<Constant>();
                valuesForParameterizedTypeInstance.add(Constant.getNullValue(this.m_module.types.TraitsPtrTy));
                for (Type paramType : parameterizedTypeInstance.typeParameters()) {
                    valuesForParameterizedTypeInstance.add(this.getTypeId(paramType));
                }
                assert (valuesForParameterizedTypeInstance.size() == nStructMembers);
                Constant structValueForParameterizedTypeInstance = Module.getConstantStruct(structTypeForParameterizedTypeInstance, valuesForParameterizedTypeInstance);
                structsForParameterizedTypeInstances.add(structValueForParameterizedTypeInstance);
            }
            Constant initialValuesForParameterizedType = this.m_module.getConstantArray(structsForParameterizedTypeInstances);
            globalForParameterizedType.setInitializer(initialValuesForParameterizedType);
        }
        for (Pair pair : globalsForParameterizedTypes) {
            Type[] instancesArray3 = (Type[])pair.snd;
            for (int i4 = 0; i4 < instancesArray3.length; ++i4) {
                assert (LLVMStubTypes.compareTypes(this.getTypeId(instancesArray3[i4]).getType(), this.m_module.types.TraitsIdTy));
            }
        }
    }

    private final Function getOrCreateFunctionForMethod(Method m2) {
        return this.getOrCreateFunctionForMethod(m2, null);
    }

    private final Function getOrCreateFunctionForMethod(Method m2, String symbolName) {
        Function result = this.m_abcMethodToLLVMFunction.get(m2);
        if (result == null) {
            FunctionType functionTy = this.getMethodFunctionType(m2);
            String tempSymbolName = symbolName != null ? symbolName : "abcMethod_TempName" + String.valueOf(this.m_abcMethodToLLVMFunction.size());
            result = this.m_module.createInternalFunction(tempSymbolName, functionTy, this.useARMCallingConvention);
            this.m_abcMethodToLLVMFunction.put(m2, result);
        } else if (symbolName != null) {
            TwineRef sn = new TwineRef(symbolName);
            result.function().setName(sn.t);
            sn.delete();
        }
        return result;
    }

    private void LogTiming(String msg) {
        if (this.m_logPerf) {
            System.out.println("#PerfLog:Timing: " + msg + " " + System.currentTimeMillis());
        }
    }

    static {
        LLVMEmitter.loadJNI();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MethodArrays {
        final Constant activationTraitsArrayPtr;
        final Constant activationTraitsInfoPtr;
        final int nActivationraits;

        MethodArrays(GlobalOptimizer.Abc abc, String abcScriptName, SortedSet<Method> methods) {
            Constant activationTraitsNullValues = LLVMEmitter.this.m_module.getConstantArrayOfZeros(((LLVMEmitter)LLVMEmitter.this).m_module.types.TraitsPtrTy, methods.size());
            GlobalVariable activationTraitsArray = LLVMEmitter.this.m_module.createGlobal("abcActivationTraits_" + abcScriptName, false, activationTraitsNullValues);
            this.activationTraitsArrayPtr = LLVMEmitter.this.m_module.getGetElementPtrConstantExpression((Constant)activationTraitsArray, 0, 0);
            ArrayList<Constant> activationInfoArrayInitializerList = new ArrayList<Constant>();
            activationInfoArrayInitializerList.ensureCapacity(methods.size());
            Constant nullActivationInfo = Module.getConstantStruct(((LLVMEmitter)LLVMEmitter.this).m_module.types.AOTActivationInfoTy, LLVMEmitter.this.constantInt(32L, -1L), ConstantPointerNull.get(((LLVMEmitter)LLVMEmitter.this).m_module.types.CompiledHandlerPtrTy));
            int methodIndex = 0;
            for (Method m2 : methods) {
                assert (abc.methodId(m2) == methodIndex);
                assert (m2.abc.oabc == abc);
                Constant activationInfo = nullActivationInfo;
                if (m2.needActivation()) {
                    assert (m2.activation != null);
                    Constant activationTraitsId = LLVMEmitter.this.m_module.getGetElementPtrConstantExpression((Constant)activationTraitsArray, 0, methodIndex);
                    LLVMEmitter.this.setTypeId(m2.activation.getType(), activationTraitsId);
                    if (m2.activation.getType().init != null) {
                        Function f2 = LLVMEmitter.this.getOrCreateFunctionForMethod(m2.activation.getType().init);
                        activationInfo = Module.getConstantStruct(((LLVMEmitter)LLVMEmitter.this).m_module.types.AOTActivationInfoTy, LLVMEmitter.this.constantInt(32L, abc.methodId(m2.activation.getType().init)), LLVMEmitter.this.m_module.functionToCompiledHandler(f2));
                    }
                }
                assert (activationInfoArrayInitializerList.size() == methodIndex);
                activationInfoArrayInitializerList.add(activationInfo);
                ++methodIndex;
            }
            Constant activationInfoArrayInitializer = LLVMEmitter.this.m_module.getConstantArray(activationInfoArrayInitializerList);
            GlobalVariable activationTraitsInfo = LLVMEmitter.this.m_module.createGlobal("abcActivationTraitsInfo_" + abcScriptName, true, activationInfoArrayInitializer);
            this.activationTraitsInfoPtr = LLVMEmitter.this.m_module.getGetElementPtrConstantExpression((Constant)activationTraitsInfo, 0, 0);
            this.nActivationraits = methodIndex;
        }
    }

    private final class ScriptArrays {
        final Constant scriptTraitsArrayPtr;

        ScriptArrays(GlobalOptimizer.Abc abc, String abcScriptName) {
            Type[] sortedScripts = LLVMEmitter.this.sortedScripts(abc);
            Constant scriptTraitsNullValues = LLVMEmitter.this.m_module.getConstantArrayOfZeros(((LLVMEmitter)LLVMEmitter.this).m_module.types.TraitsPtrTy, sortedScripts.length);
            GlobalVariable scriptTraitsArray = LLVMEmitter.this.m_module.createGlobal("abcScriptTraits_" + abcScriptName, false, scriptTraitsNullValues);
            for (int scriptIndex = 0; scriptIndex < sortedScripts.length; ++scriptIndex) {
                Type script = sortedScripts[scriptIndex];
                assert (script.init.cx == script);
                Constant scriptTraitsId = LLVMEmitter.this.m_module.getGetElementPtrConstantExpression((Constant)scriptTraitsArray, 0, scriptIndex);
                LLVMEmitter.this.setTypeId(script, scriptTraitsId);
            }
            this.scriptTraitsArrayPtr = LLVMEmitter.this.m_module.getGetElementPtrConstantExpression((Constant)scriptTraitsArray, 0, 0);
        }
    }

    private static class LazyEval {
        public final Method method;
        public final LoadInst ptrLoad;
        public final llvm.Function evaluator;
        public final Constant evaluatorData;

        public LazyEval(Method _method, LoadInst _ptrLoad, llvm.Function _evaluator, Constant _evaluatorData) {
            this.method = _method;
            this.ptrLoad = _ptrLoad;
            this.evaluator = _evaluator;
            this.evaluatorData = _evaluatorData;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MethodEmitter {
        private final GlobalOptimizer.Abc m_abc;
        private final Method m_method;
        private final Map<Expr, Typeref> m_exprTypes;
        private final Algorithms.EdgeMap<Expr> m_exprUses;
        private final Function m_function;
        private final Map<Expr, Value> m_exprToLLVMValue;
        private final Map<Expr, Value> m_exprToNonOptimisticLLVMValue;
        private Map<Expr, Value> m_exprToDebugValue;
        private final Map<Block, BasicBlock> m_abcBlockToBasicBlock;
        private final Map<GlobalOptimizer.InputAbc, GlobalVariable> m_iabcToAbcEnv;
        private final Map<Name, GlobalVariable> m_nameToMultiname;
        private final boolean m_debugger;
        private final Value m_exceptFilterVar;
        private final int m_debugVarCount;
        private final Value m_debugVars;
        private final Value m_exceptionFrame;
        private final BasicBlock m_handleByRethrowBlock;
        private final BasicBlock m_rethrowBlock;
        private final BasicBlock m_throwAbortBlock;
        private final Map<BasicBlock, Edge[]> m_bbToXsuccs;
        private final Map<Edge[], BasicBlock> m_xsuccsToXbb;
        private final Map<Edge[], Constant> m_xsuccsToExceptFilter;
        private final Value m_methodFrame;
        private final Value m_methodEnvPtrValue;
        private final Value m_scopesValue;
        private final BasicBlock m_returnBlock;
        private final PHINode m_returnBlockPhi;
        private final LLVMTamarinSlotLayoutCache.ITypeProvider m_builtinClassesTypeProvider;
        private int kVOID = 0;
        private int kOBJECT = 1;
        private int kCLASS = 2;
        private int kFUNCTION = 3;
        private int kARRAY = 4;
        private int kSTRING = 5;
        private int kNUMBER = 6;
        private int kINT = 7;
        private int kUINT = 8;
        private int kBOOLEAN = 9;
        private int kANY = 10;
        private int kNAMESPACE = 11;
        private int kVECTORINT = 12;
        private int kVECTORUINT = 13;
        private int kVECTOROBJ = 15;
        private Map<Edge, BasicBlock> m_exceptEdges = new TreeMap<Edge, BasicBlock>();

        private LLVMTamarinSlotLayoutCache.ITypeProvider makeBuiltinClassesTypeProvider() {
            return new LLVMTamarinSlotLayoutCache.ITypeProvider(){
                private static final String s_ScriptObject = "ScriptObject";
                private static final String s_ClassClosure = "ClassClosure";

                private String getGlueClassName(Type t2) {
                    boolean isInstance = t2.itype == null;
                    Name className = isInstance ? t2.getName() : t2.itype.getName();
                    GlobalOptimizer.Metadata[] metaDatas = MethodEmitter.this.m_method.domain().getClassMetadata(className);
                    if (metaDatas != null) {
                        for (GlobalOptimizer.Metadata md : metaDatas) {
                            String result;
                            if (!md.name.equals("native")) continue;
                            String classGlueClass = null;
                            String instanceGlueClass = null;
                            for (GlobalOptimizer.Attr a : md.attrs) {
                                if (a.name().equals("cls")) {
                                    classGlueClass = a.value();
                                    continue;
                                }
                                if (!a.name().equals("instance")) continue;
                                instanceGlueClass = a.value();
                            }
                            if (classGlueClass == null && instanceGlueClass == null) continue;
                            if (classGlueClass == null) {
                                classGlueClass = s_ClassClosure;
                            }
                            if (instanceGlueClass == null) {
                                instanceGlueClass = s_ScriptObject;
                            }
                            String string = result = isInstance ? instanceGlueClass : classGlueClass;
                            if (t2.slotCount > 0) {
                                Type rootAS3Class;
                                String rootNativeClass = isInstance ? s_ScriptObject : s_ClassClosure;
                                Type type = rootAS3Class = isInstance ? BuiltinDomain.instance().OBJECT() : BuiltinDomain.instance().CLASS();
                                if (instanceGlueClass.equals(rootNativeClass)) {
                                    if (t2.base == null || t2.base.extendsBase(rootAS3Class)) {
                                        String errorStr = "Native metadata for " + className.format() + " specifies " + rootNativeClass + " as the native class, but does not subclass " + rootAS3Class.getName().format() + ".";
                                        throw new Error(errorStr);
                                    }
                                    result = null;
                                }
                            }
                            return result;
                        }
                    }
                    return null;
                }

                private Pair<PointerType, llvm.Type> getGlueClassTypes(Type t2) {
                    String glueClassName = this.getGlueClassName(t2);
                    if (glueClassName == null) {
                        return null;
                    }
                    Pair result = (Pair)LLVMEmitter.this.m_glueClassNameToLLVMTypes.get(glueClassName);
                    if (result == null) {
                        throw new Error("Unable get glueClassTypes for " + glueClassName);
                    }
                    return result;
                }

                @Override
                public Pair<StructType, PointerType> builtinTypeStructType(Type t2) {
                    if (t2 == BuiltinDomain.instance().ANY()) {
                        return this.builtinTypeStructType(BuiltinDomain.instance().OBJECT());
                    }
                    Pair<PointerType, llvm.Type> glueClassTypes = this.getGlueClassTypes(t2);
                    if (glueClassTypes == null) {
                        return null;
                    }
                    StructType structType = StructType.dyn_cast(CompositeType.dyn_cast(DerivedType.dyn_cast((llvm.Type)glueClassTypes.snd)));
                    if (structType == null) {
                        throw new Error("Unable to cast " + this.getGlueClassName(t2) + " to a StructType");
                    }
                    Pair<StructType, PointerType> result = new Pair<StructType, PointerType>(structType, (PointerType)glueClassTypes.fst);
                    return result;
                }
            };
        }

        public MethodEmitter(GlobalOptimizer.Abc abc, Method m2, Map<Expr, Typeref> types, Algorithms.EdgeMap<Expr> uses, Map<GlobalOptimizer.InputAbc, GlobalVariable> iabcToAbcEnv, Map<Name, GlobalVariable> nameToMultiname, boolean debugger) {
            assert (!m2.isNative());
            this.m_abc = abc;
            this.m_method = m2;
            this.m_exprTypes = types;
            this.m_exprUses = uses;
            this.m_debugger = debugger;
            LLVMEmitter.this.printMsg("METHODEMITTER: '" + m2.debugName + "' '" + this.symbolName(m2).toString() + "'");
            this.m_function = LLVMEmitter.this.getOrCreateFunctionForMethod(m2, this.symbolName(m2));
            this.m_exprToLLVMValue = new HashMap<Expr, Value>();
            this.m_exprToNonOptimisticLLVMValue = new HashMap<Expr, Value>();
            this.m_exprToDebugValue = new HashMap<Expr, Value>();
            this.m_abcBlockToBasicBlock = new HashMap<Block, BasicBlock>();
            BasicBlock entryBlock = this.m_function.addBlock("entry");
            ConstantInt nScopes = LLVMEmitter.this.constantInt(32L, m2.max_scope > 0 ? (long)m2.max_scope : 1L);
            this.m_methodEnvPtrValue = this.m_function.arg(this.m_function.argCount() - 1);
            this.m_iabcToAbcEnv = iabcToAbcEnv;
            this.m_nameToMultiname = nameToMultiname;
            this.m_methodFrame = entryBlock.addInstruction(AllocaInst.class, ((LLVMEmitter)LLVMEmitter.this).m_module.types.AOTMethodFrameTy, LLVMEmitter.this.constantInt(32L, 1L));
            this.callFunction("enterMethodFrame", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(this.m_methodFrame)}), entryBlock);
            this.m_scopesValue = entryBlock.addInstruction(AllocaInst.class, ((LLVMEmitter)LLVMEmitter.this).m_module.types.AtomTy, nScopes);
            this.m_returnBlock = this.m_function.addBlock("unifiedReturn");
            this.m_returnBlockPhi = this.m_returnBlock.addInstruction(PHINode.class, LLVMEmitter.this.m_module.llvmType(this.m_method.returns.getType()));
            this.m_builtinClassesTypeProvider = this.makeBuiltinClassesTypeProvider();
            this.runtimeMessage("executing method '" + m2.debugName + "' symbolname '" + this.symbolName(m2).toString() + "'\n", entryBlock);
            this.runtimeMessage("returning from method '" + m2.debugName + "' symbolname '" + this.symbolName(m2).toString() + "'\n", this.m_returnBlock);
            if (this.m_debugger) {
                int i2;
                this.m_debugVarCount = this.m_method.local_count + this.m_method.max_scope;
                int argCount = this.m_method.params.length + (this.m_method.needsRest() || this.m_method.needsArguments() ? 1 : 0);
                AllocaInst callStackNode = entryBlock.addInstruction(AllocaInst.class, ((LLVMEmitter)LLVMEmitter.this).m_module.types.CallStackNodeTy, LLVMEmitter.this.constantInt(32L, 1L));
                this.m_exceptFilterVar = entryBlock.addInstruction(AllocaInst.class, ((LLVMEmitter)LLVMEmitter.this).m_module.types.intTy, LLVMEmitter.this.constantInt(32L, 1L));
                this.m_debugVars = entryBlock.addInstruction(AllocaInst.class, ((LLVMEmitter)LLVMEmitter.this).m_module.types.AtomTy, LLVMEmitter.this.constantInt(32L, this.m_debugVarCount));
                Value undef = this.callFunction("loadundefined", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.AtomTy).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue)}), entryBlock, false);
                ArrayList<Value> debugValues = new ArrayList<Value>();
                for (i2 = 0; i2 < this.m_method.params.length; ++i2) {
                    debugValues.add(this.emitValueBoxing(entryBlock, this.getVWT(this.m_function.arg(i2))));
                }
                if (this.m_method.needsRest() || this.m_method.needsArguments()) {
                    debugValues.add(this.emitValueBoxing(entryBlock, this.getVWT(this.m_function.arg(this.m_method.params.length + 2))));
                }
                for (i2 = 0; i2 < this.m_debugVarCount - argCount; ++i2) {
                    debugValues.add(undef);
                }
                assert (debugValues.size() == this.m_debugVarCount);
                for (i2 = 0; i2 < this.m_debugVarCount; ++i2) {
                    GetElementPtrInst gep = entryBlock.addGetElementPtr(this.m_debugVars, (Value[])LLVMEmitter.arr(new ConstantInt[]{LLVMEmitter.this.constantInt(32L, i2)}));
                    entryBlock.addVolatileStore((Value)debugValues.get(i2), gep);
                }
                this.callFunction("debugEnter", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(callStackNode), this.getVWT(this.m_debugVars), this.getVWT(this.m_exceptFilterVar)}), entryBlock);
                this.callFunction("debugExit", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(callStackNode)}), this.m_returnBlock);
            } else {
                this.m_exceptFilterVar = null;
                this.m_debugVarCount = 0;
                this.m_debugVars = null;
            }
            if (m2.hasExceptions) {
                AllocaInst exceptionFrame = entryBlock.addInstruction(AllocaInst.class, ((LLVMEmitter)LLVMEmitter.this).m_module.types.ExceptionFrameTy, LLVMEmitter.this.constantInt(32L, 1L));
                this.callFunction("beginTry", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(exceptionFrame)}), entryBlock);
                this.callFunction("endTry", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(exceptionFrame)}), this.m_returnBlock);
                this.m_throwAbortBlock = this.m_function.addBlock("throwAbort");
                this.abort("throw failed", this.m_throwAbortBlock, LLVMEmitter.this.m_module.m_module.getContext());
                BasicBlock handleByRethrowBlock = this.m_function.addBlock("handleByRethrow");
                ValueWithTyperef[] beginCatchArgs = (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(exceptionFrame)});
                handleByRethrowBlock.addInvoke(LLVMEmitter.this.m_module.m_module.getContext(), this.getFunction("beginCatch", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), beginCatchArgs, handleByRethrowBlock), this.m_throwAbortBlock, ValueWithTyperef.getValueArray(beginCatchArgs), LLVMEmitter.this.useARMCallingConvention);
                BasicBlock rethrowBlock = this.m_function.addBlock("rethrow");
                this.callFunction("rethrow", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(exceptionFrame)}), rethrowBlock);
                rethrowBlock.addInstruction(UnreachableInst.class, LLVMEmitter.this.m_module.m_module.getContext());
                handleByRethrowBlock.addBranch(rethrowBlock);
                this.m_handleByRethrowBlock = handleByRethrowBlock;
                this.m_rethrowBlock = rethrowBlock;
                this.m_exceptionFrame = exceptionFrame;
                this.m_bbToXsuccs = new HashMap<BasicBlock, Edge[]>();
                this.m_xsuccsToXbb = new HashMap<Edge[], BasicBlock>();
                this.m_xsuccsToExceptFilter = this.m_exceptFilterVar != null ? new HashMap<Edge[], Constant>() : null;
            } else {
                this.m_throwAbortBlock = null;
                this.m_handleByRethrowBlock = null;
                this.m_rethrowBlock = null;
                this.m_exceptionFrame = null;
                this.m_bbToXsuccs = null;
                this.m_xsuccsToXbb = null;
                this.m_xsuccsToExceptFilter = null;
            }
            this.callFunction("exitMethodFrame", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(this.m_methodFrame)}), this.m_returnBlock, false);
        }

        private BasicBlock basicBlock(Block b3) {
            BasicBlock result = this.m_abcBlockToBasicBlock.get(b3);
            if (result == null) {
                String name = "abcPos_" + Integer.toString(b3.pos);
                result = this.m_function.addBlock(name);
                this.m_abcBlockToBasicBlock.put(b3, result);
            }
            return result;
        }

        private Value value(Expr e2) {
            Value result = null;
            if (this.m_debugger && null != this.m_exprToDebugValue && null != (result = this.m_exprToDebugValue.get(e2))) {
                return result;
            }
            result = this.m_exprToLLVMValue.get(e2);
            return result;
        }

        private Typeref typeref(Expr e2) {
            Typeref result = this.m_exprTypes.get(e2);
            return result;
        }

        private llvm.Type llvmType(Expr e2) {
            Typeref tr = this.typeref(e2);
            if (tr == null) {
                LLVMEmitter.this.printErr("Should typeref be null?...");
                return ((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy;
            }
            return LLVMEmitter.this.m_module.llvmType(tr.t);
        }

        public Function emit() {
            DebugState debugState = new DebugState();
            debugState.locals = new LinkedList<Pair<Expr, Expr>>();
            debugState.restore = new LinkedList<Pair<Expr, Expr>>();
            Block firstBlock = this.m_method.entry.to;
            BasicBlock entryBlock = this.m_function.entryBlock();
            BasicBlock firstBasicBlock = this.basicBlock(firstBlock);
            Algorithms.Deque<Block> blocks = this.m_method.depthFirstCfg();
            Algorithms.SetMap<Block, Edge> preds = Algorithms.preds(blocks);
            ArrayList<Block> newblocks = new ArrayList<Block>();
            for (Block b3 : blocks) {
                for (Edge edge : b3.succ()) {
                    if (edge.to.first().op != 257) continue;
                    Edge newedge = GlobalOptimizer.split(edge, this.m_method, preds);
                    newblocks.add(newedge.from);
                }
            }
            for (Block b3 : newblocks) {
                blocks.add(b3);
            }
            block24: for (Block b3 : blocks) {
                this.m_exprToDebugValue.clear();
                this.emitBlock(b3, debugState);
                Expr last = b3.last();
                BasicBlock bb2 = this.basicBlock(b3);
                this.runtimeMessage("--- " + last.opName() + " " + last.toString() + "\n", bb2);
                switch (last.op) {
                    case 72: {
                        assert (this.typeref(last.args[0]).getType() == this.m_method.returns.getType());
                        this.m_exprToLLVMValue.put(last, this.value(last.args[0]));
                        bb2.addBranch(this.m_returnBlock);
                        continue block24;
                    }
                    case 71: {
                        assert (false);
                        continue block24;
                    }
                    case 3: {
                        this.callFunction("throw", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(this.emitValueBoxing(bb2, last.args[0])).setTempl()}), bb2);
                        bb2.addInstruction(UnreachableInst.class, LLVMEmitter.this.m_module.m_module.getContext());
                        continue block24;
                    }
                    case 17: {
                        this.emitBranch(bb2, this.emitTest(bb2, "true", last.args[0]), last.succ[1], last.succ[0]);
                        continue block24;
                    }
                    case 18: {
                        this.emitBranch(bb2, this.emitTest(bb2, "true", last.args[0]), last.succ[0], last.succ[1]);
                        continue block24;
                    }
                    case 12: {
                        this.emitBranch(bb2, this.emitCond(bb2, "lessthan", last.args[0], last.args[1]), last.succ[0], last.succ[1]);
                        continue block24;
                    }
                    case 13: {
                        this.emitBranch(bb2, this.emitCond(bb2, "lessequals", last.args[0], last.args[1]), last.succ[0], last.succ[1]);
                        continue block24;
                    }
                    case 14: {
                        this.emitBranch(bb2, this.emitCond(bb2, "greaterthan", last.args[0], last.args[1]), last.succ[0], last.succ[1]);
                        continue block24;
                    }
                    case 15: {
                        this.emitBranch(bb2, this.emitCond(bb2, "greaterequals", last.args[0], last.args[1]), last.succ[0], last.succ[1]);
                        continue block24;
                    }
                    case 21: {
                        this.emitBranch(bb2, this.emitCond(bb2, "lessthan", last.args[0], last.args[1]), last.succ[1], last.succ[0]);
                        continue block24;
                    }
                    case 22: {
                        this.emitBranch(bb2, this.emitCond(bb2, "lessequals", last.args[0], last.args[1]), last.succ[1], last.succ[0]);
                        continue block24;
                    }
                    case 23: {
                        this.emitBranch(bb2, this.emitCond(bb2, "greaterthan", last.args[0], last.args[1]), last.succ[1], last.succ[0]);
                        continue block24;
                    }
                    case 24: {
                        this.emitBranch(bb2, this.emitCond(bb2, "greaterequals", last.args[0], last.args[1]), last.succ[1], last.succ[0]);
                        continue block24;
                    }
                    case 19: {
                        this.emitBranch(bb2, this.emitCond(bb2, "equals", last.args[0], last.args[1]), last.succ[1], last.succ[0]);
                        continue block24;
                    }
                    case 20: {
                        this.emitBranch(bb2, this.emitCond(bb2, "equals", last.args[0], last.args[1]), last.succ[0], last.succ[1]);
                        continue block24;
                    }
                    case 25: {
                        this.emitBranch(bb2, this.emitCond(bb2, "strictequals", last.args[0], last.args[1]), last.succ[1], last.succ[0]);
                        continue block24;
                    }
                    case 26: {
                        this.emitBranch(bb2, this.emitCond(bb2, "strictequals", last.args[0], last.args[1]), last.succ[0], last.succ[1]);
                        continue block24;
                    }
                    case 16: {
                        this.emitBranch(bb2, last.succ[0]);
                        continue block24;
                    }
                    case 27: {
                        int nCases = last.succ.length - 1;
                        BasicBlock basicBlock = this.basicBlock(last.succ[nCases].to);
                        BasicBlock[] dests = new BasicBlock[nCases];
                        for (int i2 = 0; i2 < nCases; ++i2) {
                            dests[i2] = this.basicBlock(last.succ[i2].to);
                        }
                        Expr e3 = last.args[0];
                        Value value = this.value(e3);
                        if (this.llvmType(e3) == ((LLVMEmitter)LLVMEmitter.this).m_module.types.NumberTy) {
                            value = bb2.addInstruction(TruncInst.class, value);
                        }
                        bb2.addDenseSwitch(LLVMEmitter.this.m_ctx, value, basicBlock, dests);
                        continue block24;
                    }
                }
                assert (false);
            }
            this.m_exprToDebugValue.clear();
            int blockCount = 0;
            for (Block b4 : blocks) {
                int phiCount = 0;
                for (Expr expr : b4.exprs) {
                    if (expr.op != 257) break;
                    PHINode llvmPHI = PHINode.dyn_cast(Instruction.dyn_cast(User.dyn_cast(this.value(expr))));
                    assert (llvmPHI != null);
                    assert (expr.pred.length == expr.args.length);
                    String phitype = this.getMangleableType(this.getVWT(expr)).mangle();
                    LLVMEmitter.this.printErr("Fixing phi with " + expr.args.length + " incoming nodes and type " + phitype);
                    for (int i3 = 0; i3 < expr.pred.length; ++i3) {
                        Expr fromExpr;
                        Value fromValue;
                        BasicBlock fromBB;
                        Edge pred = expr.pred[i3];
                        assert (pred.to == b4);
                        if (pred.handler != null) {
                            fromBB = this.m_exceptEdges.get(pred);
                            assert (fromBB != null);
                        } else {
                            fromBB = this.basicBlock(pred.from);
                        }
                        Value value = fromValue = this.m_exprToNonOptimisticLLVMValue.containsKey(fromExpr = expr.args[i3]) ? this.m_exprToNonOptimisticLLVMValue.get(fromExpr) : this.value(fromExpr);
                        if (LLVMEmitter.this.debugMessages) {
                            if (fromValue == null) {
                                LLVMEmitter.this.printErr("-- null incoming value...");
                            } else if (phitype.compareTo(this.getMangleableType(this.getVWT(expr.args[i3])).mangle()) != 0) {
                                LLVMEmitter.this.printErr("-- incoming type: " + this.getMangleableType(this.getVWT(expr.args[i3])).mangle() + " does not match phi type: " + phitype);
                                LLVMEmitter.this.printErr("-- incoming expr was: ");
                                this.value(expr.args[i3]).dump();
                                this.m_function.m_function.dump();
                            } else {
                                LLVMEmitter.this.printErr("-- incoming type: " + this.getMangleableType(this.getVWT(expr.args[i3])).mangle());
                            }
                        }
                        fromBB.setPHIIncoming(llvmPHI, fromValue);
                    }
                    ++phiCount;
                }
                Expr lastExpr = b4.last();
                if (lastExpr.op == 72) {
                    BasicBlock basicBlock = this.basicBlock(b4);
                    Value returnValue = this.value(lastExpr);
                    LLVMEmitter.this.printErr("return phi: " + blockCount + " returnValueId" + returnValue.getValueID());
                    basicBlock.setPHIIncoming(this.m_returnBlockPhi, returnValue);
                }
                ++blockCount;
            }
            if (this.m_returnBlockPhi.getNumIncomingValues() == 0L) {
                assert (this.m_returnBlock.hasNUses(0L));
                this.m_returnBlock.eraseFromParent();
            } else {
                PHINode returnValue = this.m_returnBlockPhi;
                this.m_returnBlock.addInstruction(ReturnInst.class, LLVMEmitter.this.m_module.m_module.getContext(), returnValue);
            }
            entryBlock.addBranch(firstBasicBlock);
            return this.m_function;
        }

        private void emitBranch(BasicBlock bb2, Value condition, Edge e1, Edge e2) {
            BasicBlock target1 = this.basicBlock(e1.to);
            BasicBlock target2 = this.basicBlock(e2.to);
            bb2.addBranch(condition, target1, target2);
        }

        private void emitBranch(BasicBlock bb2, Edge e2) {
            bb2.addBranch(this.basicBlock(e2.to));
        }

        private Value emitCond(BasicBlock bb2, String cond, Expr arg1, Expr arg2) {
            Value conditionResultAsBool = this.callFunction(cond, this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.BooleanTy).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(arg1).setTempl(), this.getVWT(arg2).setTempl()}), bb2);
            Value conditionResultAsInt = this.callFunction("true", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.intTy).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(conditionResultAsBool).setTempl()}), bb2);
            return bb2.addInstruction(ICmpInst.class, CmpInst.Predicate.ICMP_NE, conditionResultAsInt, LLVMEmitter.this.constantInt(32L, 0L));
        }

        private Value emitTest(BasicBlock bb2, String test, Expr arg) {
            Value testResultAsInt = this.callFunction(test, this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.intTy).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(arg).setTempl()}), bb2);
            return bb2.addInstruction(ICmpInst.class, CmpInst.Predicate.ICMP_NE, testResultAsInt, LLVMEmitter.this.constantInt(32L, 0L));
        }

        private LLVMStubFunctions.Gcc3mang.Mangleable getMangleableType(Typeref tr) {
            BuiltinDomain tc = BuiltinDomain.instance();
            if (tr.t.atom || tr.t == tc.ANY()) {
                return LLVMStubFunctions.AtomTy;
            }
            if (tr.t == tc.ARRAY()) {
                return LLVMStubFunctions.ArrayObjectPtrTy;
            }
            if (tr.t == tc.BOOLEAN()) {
                return LLVMStubFunctions.BoolTy;
            }
            if (tr.t == tc.CLASS()) {
                return LLVMStubFunctions.ScriptObjectPtrTy;
            }
            if (tr.t == tc.FUNCTION()) {
                return LLVMStubFunctions.ScriptObjectPtrTy;
            }
            if (tr.t == tc.INT()) {
                return LLVMStubFunctions.Gcc3mang.SimpleType.intTy;
            }
            if (tr.t == tc.NAMESPACE()) {
                return LLVMStubFunctions.NamespacePtrTy;
            }
            if (tr.t == tc.NUMBER()) {
                return LLVMStubFunctions.Gcc3mang.SimpleType.doubleTy;
            }
            if (tr.t == tc.OBJECT()) {
                return LLVMStubFunctions.ScriptObjectPtrTy;
            }
            if (tr.t == tc.QNAME()) {
                return LLVMStubFunctions.QNameObjectPtrTy;
            }
            if (tr.t == tc.STRING()) {
                return LLVMStubFunctions.StringPtrTy;
            }
            if (tr.t == tc.UINT()) {
                return LLVMStubFunctions.Gcc3mang.SimpleType.unsignedTy;
            }
            if (tr.t == tc.VOID()) {
                return LLVMStubFunctions.Gcc3mang.SimpleType.voidTy;
            }
            if (tr.t == tc.XML()) {
                return LLVMStubFunctions.ScriptObjectPtrTy;
            }
            if (tr.t == tc.XMLLIST()) {
                return LLVMStubFunctions.ScriptObjectPtrTy;
            }
            if (tr.t.isDerivedFrom(tc.OBJECT())) {
                return LLVMStubFunctions.ScriptObjectPtrTy;
            }
            LLVMEmitter.this.printErr("Warning: failed to match typeref.t: " + tr.t.toString());
            return LLVMStubFunctions.ScriptObjectPtrTy;
        }

        private LLVMStubFunctions.Gcc3mang.Mangleable getMangleableType(llvm.Type t2) {
            LLVMStubFunctions.Gcc3mang.Mangleable m2 = null;
            assert (t2 != null);
            if (LLVMStubTypes.compareTypes(t2, ((LLVMEmitter)LLVMEmitter.this).m_module.types.AtomTy)) {
                m2 = LLVMStubFunctions.AtomTy;
            } else if (LLVMStubTypes.compareTypes(t2, ((LLVMEmitter)LLVMEmitter.this).m_module.types.BooleanTy)) {
                m2 = LLVMStubFunctions.BoolTy;
            } else if (LLVMStubTypes.compareTypes(t2, ((LLVMEmitter)LLVMEmitter.this).m_module.types.intTy)) {
                m2 = LLVMStubFunctions.Gcc3mang.SimpleType.intTy;
            } else if (LLVMStubTypes.compareTypes(t2, ((LLVMEmitter)LLVMEmitter.this).m_module.types.uintTy)) {
                m2 = LLVMStubFunctions.Gcc3mang.SimpleType.unsignedTy;
            } else if (LLVMStubTypes.compareTypes(t2, ((LLVMEmitter)LLVMEmitter.this).m_module.types.NumberTy)) {
                m2 = LLVMStubFunctions.Gcc3mang.SimpleType.doubleTy;
            } else if (LLVMStubTypes.compareTypes(t2, ((LLVMEmitter)LLVMEmitter.this).m_module.types.NumberPtrTy)) {
                m2 = new LLVMStubFunctions.Gcc3mang.Pointer(LLVMStubFunctions.Gcc3mang.SimpleType.doubleTy);
            } else if (LLVMStubTypes.compareTypes(t2, ((LLVMEmitter)LLVMEmitter.this).m_module.types.ExceptionFramePtrTy)) {
                m2 = LLVMStubFunctions.ExceptionFramePtrTy;
            } else if (LLVMStubTypes.compareTypes(t2, ((LLVMEmitter)LLVMEmitter.this).m_module.types.CallStackNodePtrTy)) {
                m2 = LLVMStubFunctions.CallStackNodePtrTy;
            } else if (LLVMStubTypes.compareTypes(t2, ((LLVMEmitter)LLVMEmitter.this).m_module.types.MethodEnvPtrTy)) {
                m2 = LLVMStubFunctions.MethodEnvPtrTy;
            } else if (LLVMStubTypes.compareTypes(t2, ((LLVMEmitter)LLVMEmitter.this).m_module.types.AbcEnvPtrTy)) {
                m2 = LLVMStubFunctions.AbcEnvPtrTy;
            } else if (LLVMStubTypes.compareTypes(t2, ((LLVMEmitter)LLVMEmitter.this).m_module.types.QNameObjectPtrTy)) {
                m2 = LLVMStubFunctions.QNameObjectPtrTy;
            } else if (LLVMStubTypes.compareTypes(t2, ((LLVMEmitter)LLVMEmitter.this).m_module.types.NamespacePtrTy)) {
                m2 = LLVMStubFunctions.NamespacePtrTy;
            } else if (LLVMStubTypes.compareTypes(t2, ((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy)) {
                m2 = LLVMStubFunctions.Gcc3mang.SimpleType.voidTy;
            } else if (LLVMStubTypes.compareTypes(t2, ((LLVMEmitter)LLVMEmitter.this).m_module.types.StringPtrTy)) {
                m2 = LLVMStubFunctions.StringPtrTy;
            } else if (LLVMStubTypes.compareTypes(t2, ((LLVMEmitter)LLVMEmitter.this).m_module.types.ScriptObjectPtrTy)) {
                m2 = LLVMStubFunctions.ScriptObjectPtrTy;
            } else if (LLVMStubTypes.compareTypes(t2, ((LLVMEmitter)LLVMEmitter.this).m_module.types.ArrayObjectPtrTy)) {
                m2 = LLVMStubFunctions.ArrayObjectPtrTy;
            } else if (LLVMStubTypes.compareTypes(t2, ((LLVMEmitter)LLVMEmitter.this).m_module.types.DoubleVectorObjectPtrTy)) {
                m2 = LLVMStubFunctions.DoubleVectorObjectPtrTy;
            } else if (LLVMStubTypes.compareTypes(t2, ((LLVMEmitter)LLVMEmitter.this).m_module.types.IntVectorObjectPtrTy)) {
                m2 = LLVMStubFunctions.IntVectorObjectPtrTy;
            } else if (LLVMStubTypes.compareTypes(t2, ((LLVMEmitter)LLVMEmitter.this).m_module.types.UIntVectorObjectPtrTy)) {
                m2 = LLVMStubFunctions.UIntVectorObjectPtrTy;
            } else if (LLVMStubTypes.compareTypes(t2, ((LLVMEmitter)LLVMEmitter.this).m_module.types.ObjectVectorObjectPtrTy)) {
                m2 = LLVMStubFunctions.ObjectVectorObjectPtrTy;
            } else if (LLVMStubTypes.compareTypes(t2, ((LLVMEmitter)LLVMEmitter.this).m_module.types.AOTMethodFramePtrTy)) {
                m2 = LLVMStubFunctions.AOTMethodFramePtrTy;
            } else if (LLVMStubTypes.compareTypes(t2, ((LLVMEmitter)LLVMEmitter.this).m_module.types.NamespaceIdTy)) {
                m2 = new LLVMStubFunctions.Gcc3mang.Pointer(LLVMStubFunctions.NamespacePtrTy);
            } else if (LLVMStubTypes.compareTypes(t2, ((LLVMEmitter)LLVMEmitter.this).m_module.types.intPtrTy)) {
                m2 = new LLVMStubFunctions.Gcc3mang.Pointer(LLVMStubFunctions.Gcc3mang.SimpleType.intTy);
            } else if (LLVMStubTypes.compareTypes(t2, ((LLVMEmitter)LLVMEmitter.this).m_module.types.AtomPtrTy)) {
                m2 = new LLVMStubFunctions.Gcc3mang.Pointer(LLVMStubFunctions.AtomTy);
            } else if (LLVMStubTypes.compareTypes(t2, ((LLVMEmitter)LLVMEmitter.this).m_module.types.charPtrTy)) {
                m2 = new LLVMStubFunctions.Gcc3mang.Pointer(LLVMStubFunctions.Gcc3mang.SimpleType.charTy);
            } else if (LLVMStubTypes.compareTypes(t2, ((LLVMEmitter)LLVMEmitter.this).m_module.types.TraitsIdTy)) {
                m2 = LLVMStubFunctions.TraitsPtrPtrTy;
            } else if (LLVMStubTypes.compareTypes(t2, ((LLVMEmitter)LLVMEmitter.this).m_module.types.TraitsIdPtrTy)) {
                m2 = new LLVMStubFunctions.Gcc3mang.Pointer(LLVMStubFunctions.TraitsPtrPtrTy);
            } else if (LLVMStubTypes.compareTypes(t2, ((LLVMEmitter)LLVMEmitter.this).m_module.types.UnsedParamTy)) {
                m2 = LLVMStubFunctions.UnsedParamTy;
            } else if (LLVMStubTypes.compareTypes(t2, ((LLVMEmitter)LLVMEmitter.this).m_module.types.MultinameIndexTy)) {
                m2 = LLVMStubFunctions.MultiNameIndexTy;
            } else if (LLVMStubTypes.compareTypes(t2, ((LLVMEmitter)LLVMEmitter.this).m_module.types.MultinameIndexMaybeIntTy)) {
                m2 = LLVMStubFunctions.MultinameIndexMaybeIntTy;
            } else if (LLVMStubTypes.compareTypes(t2, ((LLVMEmitter)LLVMEmitter.this).m_module.types.MultinamePtrTy)) {
                m2 = LLVMStubFunctions.MultinamePtrTy;
            } else if (LLVMStubTypes.compareTypes(t2, ((LLVMEmitter)LLVMEmitter.this).m_module.types.MultinamePtrMaybeIntTy)) {
                m2 = LLVMStubFunctions.MultinamePtrMaybeIntTy;
            } else {
                LLVMEmitter.this.printErr("ERROR: Failed to mangle llvm.Type: " + LLVMEmitter.this.m_module.getTypeName(t2));
                throw new Error("ERROR: Failed to mangle llvm.Type: " + LLVMEmitter.this.m_module.getTypeName(t2));
            }
            return m2;
        }

        private LLVMStubFunctions.Gcc3mang.Mangleable getMangleableType(ValueWithTyperef vwt) {
            llvm.Type t2 = vwt.getType();
            Typeref tr = vwt.getTyperef();
            LLVMStubFunctions.Gcc3mang.Mangleable m2 = null;
            if (tr != null) {
                m2 = this.getMangleableType(tr);
            }
            if (m2 == null && (m2 = this.getMangleableType(t2)) == null) {
                m2 = this.getMangleableType(vwt.getValue().getType());
            }
            assert (m2 != null);
            if (vwt.isTempl()) {
                return new LLVMStubFunctions.Gcc3mang.TemplateParam(m2);
            }
            return m2;
        }

        private Function getFunctionMaybeVA(int numBaseArgs, String base, ValueWithTyperef retType, ValueWithTyperef[] args, BasicBlock bb2) {
            int actualArgs;
            Function f2;
            int typedArgs;
            String fname = "abcOP_" + base;
            String argtypedesc = "";
            String templatetypedesc = "";
            LLVMStubFunctions.Gcc3mang.Mangleable retTypeM = this.getMangleableType(retType);
            LLVMStubFunctions.Gcc3mang.Mangleable[] argTypes = null;
            int n2 = typedArgs = numBaseArgs >= 0 ? numBaseArgs : args.length;
            if (args != null) {
                argTypes = new LLVMStubFunctions.Gcc3mang.Mangleable[typedArgs];
                for (int i2 = 0; i2 < typedArgs; ++i2) {
                    argTypes[i2] = this.getMangleableType(args[i2]);
                    argtypedesc = argtypedesc + argTypes[i2].mangle() + ", ";
                }
            }
            ArrayList<LLVMStubFunctions.Gcc3mang.TemplateParam> templateTypeList = new ArrayList<LLVMStubFunctions.Gcc3mang.TemplateParam>();
            if (retType.isTempl()) {
                templateTypeList.add((LLVMStubFunctions.Gcc3mang.TemplateParam)retTypeM);
                templatetypedesc = templatetypedesc + retTypeM.mangle() + ", ";
            }
            if (args != null) {
                for (int i3 = 0; i3 < typedArgs; ++i3) {
                    if (!args[i3].isTempl()) continue;
                    templateTypeList.add((LLVMStubFunctions.Gcc3mang.TemplateParam)argTypes[i3]);
                    templatetypedesc = templatetypedesc + argTypes[i3].mangle() + ", ";
                }
            }
            LLVMStubFunctions.Gcc3mang.TemplateParam[] templateTypes = null;
            if (templateTypeList.size() > 0) {
                templateTypes = new LLVMStubFunctions.Gcc3mang.TemplateParam[templateTypeList.size()];
                for (int i4 = 0; i4 < templateTypeList.size(); ++i4) {
                    templateTypes[i4] = (LLVMStubFunctions.Gcc3mang.TemplateParam)templateTypeList.get(i4);
                }
            }
            String mname = new LLVMStubFunctions.Gcc3mang.Function(templateTypes, retTypeM, new LLVMStubFunctions.Gcc3mang.Name(fname), argTypes, numBaseArgs >= 0).mangle();
            if (bb2 != null && base != "printf") {
                this.runtimeMessage("getFunction: " + mname + "\n", bb2);
            }
            if ((f2 = ((LLVMEmitter)LLVMEmitter.this).m_module.functions.getFunction(mname)) != null) {
                return f2;
            }
            int n3 = actualArgs = numBaseArgs >= 0 ? numBaseArgs : args.length;
            assert (actualArgs <= args.length);
            llvm.Type[] argts = new llvm.Type[actualArgs];
            for (int i5 = 0; i5 < actualArgs; ++i5) {
                argts[i5] = args[i5].getEffectiveLLVMType(LLVMEmitter.this.m_module);
                assert (argts[i5] != null);
            }
            FunctionType ft = Module.getFunctionType(retType.getEffectiveLLVMType(LLVMEmitter.this.m_module), argts, numBaseArgs >= 0);
            f2 = LLVMEmitter.this.m_module.getOrCreateFunction(mname, ft, LLVMEmitter.this.useARMCallingConvention);
            return f2;
        }

        private Function getFunctionVA(int numBaseArgs, String base, ValueWithTyperef retType, ValueWithTyperef[] args, BasicBlock bb2) {
            assert (numBaseArgs >= 0);
            return this.getFunctionMaybeVA(numBaseArgs, base, retType, args, bb2);
        }

        private Function getFunction(String base, ValueWithTyperef retType, ValueWithTyperef[] args, BasicBlock bb2) {
            return this.getFunctionMaybeVA(-1, base, retType, args, bb2);
        }

        private void runtimeMessage(String msg, BasicBlock bb2) {
            LLVMEmitter.this.printMsg(msg);
            if (LLVMEmitter.this.runtimeDebugging) {
                this.callFunction("printf", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWTString(msg)}), bb2);
            }
        }

        private void abort(String msg, BasicBlock bb2, LLVMContext ctx) {
            this.callFunction("abort", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWTString(msg)}), bb2);
            bb2.addInstruction(UnreachableInst.class, ctx);
        }

        private BasicBlock getExceptBlock(BasicBlock bb2) {
            Edge[] xsuccs;
            if (this.m_bbToXsuccs != null && this.m_bbToXsuccs.containsKey(bb2) && this.m_xsuccsToXbb.containsKey(xsuccs = this.m_bbToXsuccs.get(bb2))) {
                return this.m_xsuccsToXbb.get(xsuccs);
            }
            return this.m_handleByRethrowBlock;
        }

        private Constant getExceptFilter(BasicBlock bb2) {
            Edge[] xsuccs;
            if (this.m_bbToXsuccs != null && this.m_bbToXsuccs.containsKey(bb2) && this.m_xsuccsToExceptFilter.containsKey(xsuccs = this.m_bbToXsuccs.get(bb2))) {
                return this.m_xsuccsToExceptFilter.get(xsuccs);
            }
            return LLVMEmitter.this.constantInt(32L, 0L);
        }

        private Value callOrInvokeFunction(Value fv, BasicBlock bb2, Value[] args, boolean unwinds) {
            BasicBlock exceptBlock = this.getExceptBlock(bb2);
            Instruction i2 = unwinds && exceptBlock != null ? bb2.addInvoke(LLVMEmitter.this.m_module.m_module.getContext(), fv, exceptBlock, Arrays.asList(args), LLVMEmitter.this.useARMCallingConvention) : Function.call(bb2, fv, Arrays.asList(args), LLVMEmitter.this.useARMCallingConvention);
            return i2;
        }

        private Value callOrInvokeFunction(Function f2, BasicBlock bb2, Value[] args, boolean unwinds) {
            BasicBlock exceptBlock = this.getExceptBlock(bb2);
            Instruction i2 = unwinds && exceptBlock != null ? bb2.addInvoke(LLVMEmitter.this.m_module.m_module.getContext(), f2, exceptBlock, args, LLVMEmitter.this.useARMCallingConvention) : f2.call(bb2, args, LLVMEmitter.this.useARMCallingConvention);
            return i2;
        }

        private void setCallAttrs(Value v2, boolean doesNotThrow, boolean onlyReadsMemory, boolean doesNotAccessMemory) {
            assert (!onlyReadsMemory || !doesNotAccessMemory);
            CallInst ci = CallInst.dyn_cast(Instruction.dyn_cast(User.dyn_cast(v2)));
            if (ci != null) {
                ci.setDoesNotThrow(doesNotThrow);
                if (doesNotThrow) {
                    ci.setOnlyReadsMemory(onlyReadsMemory);
                    ci.setDoesNotAccessMemory(doesNotAccessMemory);
                }
                return;
            }
            InvokeInst ii = InvokeInst.dyn_cast(TerminatorInst.dyn_cast(Instruction.dyn_cast(User.dyn_cast(v2))));
            if (ii != null) {
                ii.setDoesNotThrow(doesNotThrow);
                if (doesNotThrow) {
                    ii.setOnlyReadsMemory(onlyReadsMemory);
                    ii.setDoesNotAccessMemory(doesNotAccessMemory);
                }
                return;
            }
        }

        private void applyExprAttrs(Value v2, Expr e2) {
            if (e2.hasEffect()) {
                this.setCallAttrs(v2, !e2.isPx(), false, false);
            } else {
                this.setCallAttrs(v2, !e2.isPx(), false, e2.isOper());
            }
        }

        private void callFunction(String base, ValueWithTyperef retType, ValueWithTyperef[] args, BasicBlock bb2, Expr e2) {
            Value i2 = this.callOrInvokeFunction(this.getFunction(base, retType, args, bb2), bb2, ValueWithTyperef.getValueArray(args), e2.isPx());
            this.applyExprAttrs(i2, e2);
            this.m_exprToLLVMValue.put(e2, i2);
        }

        private void callFunctionVA(int baseArgCount, String base, ValueWithTyperef retType, ValueWithTyperef[] args, BasicBlock bb2, Expr e2) {
            Value i2 = this.callOrInvokeFunction(this.getFunctionVA(baseArgCount, base, retType, args, bb2), bb2, ValueWithTyperef.getValueArray(args), e2.isPx());
            this.applyExprAttrs(i2, e2);
            this.m_exprToLLVMValue.put(e2, i2);
        }

        private Value callFunction(String base, ValueWithTyperef retType, ValueWithTyperef[] args, BasicBlock bb2, boolean unwinds) {
            return this.callOrInvokeFunction(this.getFunction(base, retType, args, bb2), bb2, ValueWithTyperef.getValueArray(args), unwinds);
        }

        private Value callFunction(String base, ValueWithTyperef retType, ValueWithTyperef[] args, BasicBlock bb2) {
            return this.callFunction(base, retType, args, bb2, true);
        }

        private Value emitStaticLoad(BasicBlock bb2, Expr e2, String name) {
            String base = name.replace("push", "load");
            Value result = this.callFunction(base, this.getVWT(e2).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue)}), bb2, false);
            this.applyExprAttrs(result, e2);
            this.m_exprToLLVMValue.put(e2, result);
            return result;
        }

        private Value getSlotAddress(BasicBlock bb2, Typeref baseType, int slotId, Value baseValue) {
            if (baseType.getType().slotCount < slotId) {
                String errorStr = "In function " + this.m_method.debugName + ", type " + baseType.getType().getName().format() + " does not have slot id " + String.valueOf(slotId);
                throw new Error(errorStr);
            }
            LLVMTamarinSlotLayout slotLayout = LLVMEmitter.this.m_slotLayoutCache.slotLayout(LLVMEmitter.this.m_module.m_module.getContext(), baseType.getType(), this.m_builtinClassesTypeProvider);
            Pair<List<Value>, TamarinSlotLayout.SlotStorageType> indexesAndSST = slotLayout.getGEPIndexes(LLVMEmitter.this.m_module.m_module.getContext(), slotId);
            assert (!baseType.getType().isAtom());
            BitCastInst castedBaseValue = bb2.addInstruction(BitCastInst.class, baseValue, slotLayout.structPointerType());
            GetElementPtrInst slotAddr = bb2.addGetElementPtr((Value)castedBaseValue, (List)indexesAndSST.fst);
            BitCastInst castedSlotAddr = bb2.addInstruction(BitCastInst.class, slotAddr, ((LLVMEmitter)LLVMEmitter.this).m_module.types.charPtrTy);
            return castedSlotAddr;
        }

        private boolean needsNullCheck(Expr e2) {
            return e2.isNullCheck() && this.typeref((Expr)e2.args[0]).nullable;
        }

        private void emitGetSlot(BasicBlock bb2, Expr e2) {
            if (!this.needsNullCheck(e2)) {
                e2.clearPx();
            }
            this.emitGetSlot(bb2, e2, e2.isPx());
        }

        private void emitGetSlot(BasicBlock bb2, Expr e2, boolean nullcheck) {
            Expr base = e2.args[0];
            Typeref baseType = this.typeref(base);
            int slotId = e2.imm[0];
            Value slotAddr = this.getSlotAddress(bb2, baseType, slotId, this.value(base));
            String stubSuffix = nullcheck ? "" : "_nonc";
            this.callFunction("getslot" + stubSuffix, this.getVWT(e2).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(slotAddr), this.getVWT(base).setTempl()}), bb2, e2);
        }

        private void emitSetSlot(BasicBlock bb2, Expr e2) {
            String stubSuffix;
            Expr base = e2.args[0];
            Typeref baseType = this.typeref(base);
            int slotId = e2.imm[0];
            Value slotAddr = this.getSlotAddress(bb2, baseType, slotId, this.value(base));
            if (!this.needsNullCheck(e2)) {
                e2.clearPx();
            }
            String string = stubSuffix = e2.isPx() ? "" : "_nonc";
            assert (baseType.getType().getSlotType(slotId).getType() == this.typeref(e2.args[1]).getType());
            this.callFunction(e2.opName() + stubSuffix, this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(slotAddr), this.getVWT(base).setTempl(), this.getVWT(e2.args[1]).setTempl()}), bb2, e2);
        }

        private ValueWithTyperef[] getVWTs(Expr[] e2, boolean isTempl) {
            ValueWithTyperef[] vwts = new ValueWithTyperef[e2.length];
            for (int i2 = 0; i2 < e2.length; ++i2) {
                vwts[i2] = isTempl ? this.getVWT(e2[i2]).setTempl() : this.getVWT(e2[i2]);
            }
            return vwts;
        }

        private ValueWithTyperef getVWT(Expr e2) {
            return new ValueWithTyperef(this.value(e2), this.llvmType(e2), this.typeref(e2));
        }

        private ValueWithTyperef getVWT(llvm.Type t2) {
            return new ValueWithTyperef(t2);
        }

        private ValueWithTyperef getVWT(Value v2) {
            return new ValueWithTyperef(v2);
        }

        private ValueWithTyperef getVWTInt(int v2) {
            return new ValueWithTyperef(LLVMEmitter.this.constantInt(32L, v2), new Typeref(BuiltinDomain.instance().INT(), false));
        }

        private ValueWithTyperef getVWTNull(llvm.Type t2) {
            Constant val = Constant.getNullValue(t2);
            return this.getVWT(val);
        }

        private ValueWithTyperef getVWTString(byte[] bytes, boolean nullTerm) {
            ArrayList<Constant> constantBytes = new ArrayList<Constant>(bytes.length);
            for (byte b3 : bytes) {
                ConstantInt byteConstant = LLVMEmitter.this.constantInt(8L, b3);
                constantBytes.add(byteConstant);
            }
            if (nullTerm) {
                constantBytes.add(LLVMEmitter.this.constantInt(8L, 0L));
            }
            Constant byteArray = LLVMEmitter.this.m_module.getConstantArray(constantBytes);
            GlobalVariable gvar = LLVMEmitter.this.m_module.createGlobal(".str", true, byteArray);
            Constant pchar = ConstantExpr.getCast(Instruction.CastOps.BitCast.swigValue(), gvar, ((LLVMEmitter)LLVMEmitter.this).m_module.types.charPtrTy);
            return new ValueWithTyperef(pchar);
        }

        private ValueWithTyperef getVWTString(String s2) {
            byte[] bytes;
            try {
                bytes = s2.getBytes("UTF8");
            }
            catch (UnsupportedEncodingException e2) {
                bytes = s2.getBytes();
            }
            return this.getVWTString(bytes, true);
        }

        private ValueWithTyperef getVWT(Typeref tr) {
            return new ValueWithTyperef(null, null, tr);
        }

        private ValueWithTyperef getVWTUint(long v2) {
            return new ValueWithTyperef(LLVMEmitter.this.constantInt(32L, v2), new Typeref(BuiltinDomain.instance().UINT(), false));
        }

        private ValueWithTyperef getVWTName(Name n2, boolean maybeInt) {
            llvm.Type t2 = maybeInt ? ((LLVMEmitter)LLVMEmitter.this).m_module.types.MultinameIndexMaybeIntTy : ((LLVMEmitter)LLVMEmitter.this).m_module.types.MultinameIndexTy;
            return this.getVWT(Module.castIntToPointer(LLVMEmitter.this.constantInt(32L, this.nameId(n2)), t2)).setTempl();
        }

        private int cdeclType(Typeref tr) {
            if (this.boxed(tr)) {
                return this.kANY;
            }
            BuiltinDomain abcTypes = BuiltinDomain.instance();
            if (tr.t == abcTypes.ARRAY()) {
                return this.kARRAY;
            }
            if (tr.t == abcTypes.BOOLEAN()) {
                return this.kBOOLEAN;
            }
            if (tr.t == abcTypes.CLASS()) {
                return this.kCLASS;
            }
            if (tr.t == abcTypes.FUNCTION()) {
                return this.kFUNCTION;
            }
            if (tr.t == abcTypes.INT()) {
                return this.kINT;
            }
            if (tr.t == abcTypes.NAMESPACE()) {
                return this.kNAMESPACE;
            }
            if (tr.t == abcTypes.NUMBER()) {
                return this.kNUMBER;
            }
            if (tr.t == abcTypes.STRING()) {
                return this.kSTRING;
            }
            if (tr.t == abcTypes.UINT()) {
                return this.kUINT;
            }
            return this.kOBJECT;
        }

        private ValueWithTyperef cdeclTypesArg(int[] types) {
            if (types.length <= 8) {
                long l2 = 0L;
                for (int type : types) {
                    l2 = l2 << 4 | (long)type;
                }
                return this.getVWTUint(l2 <<= 4 * (8 - types.length));
            }
            LinkedList<Byte> byteList = new LinkedList<Byte>();
            byte curByte = 0;
            for (int i2 = 0; i2 < types.length; ++i2) {
                if ((i2 & 1) == 1) {
                    curByte = (byte)(curByte | types[i2]);
                    byteList.add(curByte);
                    continue;
                }
                curByte = (byte)(types[i2] << 4);
                if (i2 != types.length - 1) continue;
                byteList.add(curByte);
            }
            byte[] bytes = new byte[byteList.size()];
            int i3 = 0;
            Iterator i$ = byteList.iterator();
            while (i$.hasNext()) {
                byte b3 = (Byte)i$.next();
                bytes[i3++] = b3;
            }
            return this.getVWTString(bytes, (types.length & 1) == 0);
        }

        private ValueWithTyperef[] cdeclArgs(Expr[] e2, boolean nullFirstArg) {
            int i2;
            ValueWithTyperef[] result = new ValueWithTyperef[e2.length + 1];
            int[] types = new int[e2.length];
            for (i2 = 0; i2 < e2.length; ++i2) {
                types[i2] = this.cdeclType(this.typeref(e2[i2]));
            }
            result[0] = this.cdeclTypesArg(types).setTempl();
            int n2 = i2 = nullFirstArg ? 1 : 0;
            while (i2 < e2.length) {
                result[i2 + 1] = this.getVWT(e2[i2]);
                ++i2;
            }
            if (nullFirstArg) {
                types[0] = this.kOBJECT;
                result[1] = this.getVWTNull(((LLVMEmitter)LLVMEmitter.this).m_module.types.ScriptObjectPtrTy);
            }
            return result;
        }

        private ValueWithTyperef[] args(Expr[] e2, boolean nullFirstArg) {
            int i2;
            ValueWithTyperef[] result = new ValueWithTyperef[e2.length];
            int n2 = i2 = nullFirstArg ? 1 : 0;
            while (i2 < e2.length) {
                result[i2] = this.getVWT(e2[i2]);
                ++i2;
            }
            if (nullFirstArg) {
                result[0] = this.getVWTNull(((LLVMEmitter)LLVMEmitter.this).m_module.types.ScriptObjectPtrTy);
            }
            return result;
        }

        private int nsId(Namespace ns) {
            int id = this.m_abc.nsPool.id(ns);
            if (id < 0) {
                throw new Error("Unable to get index for Namespace.");
            }
            return id;
        }

        private int nameId(Name n2) {
            int id = this.m_abc.namePool.id(n2);
            if (id < 0) {
                throw new Error("Unable to get index for Name.");
            }
            return id;
        }

        private int stringId(String s2) {
            int id = this.m_abc.stringPool.id(s2);
            if (id < 0) {
                throw new Error("Unable to get index for String.");
            }
            return id;
        }

        private void maybeBuildExceptBlock(Edge[] xsucc) {
            if (!this.m_xsuccsToXbb.containsKey(xsucc) && xsucc.length > 0) {
                BasicBlock origXbb;
                BasicBlock xbb = origXbb = this.m_function.addBlock("catch");
                ValueWithTyperef[] args = (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(this.m_exceptionFrame)});
                xbb.addInvoke(LLVMEmitter.this.m_module.m_module.getContext(), this.getFunction("beginCatch", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), args, xbb), this.m_throwAbortBlock, ValueWithTyperef.getValueArray(args), LLVMEmitter.this.useARMCallingConvention);
                InvokeInst xarg = xbb.addInvoke(LLVMEmitter.this.m_module.m_module.getContext(), this.getFunction("xarg", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.AtomTy).setTempl(), args, xbb), this.m_throwAbortBlock, ValueWithTyperef.getValueArray(args), LLVMEmitter.this.useARMCallingConvention);
                boolean catchAny = false;
                LinkedList<Constant> catchTypeIds = new LinkedList<Constant>();
                for (Edge e2 : xsucc) {
                    for (Handler h2 : this.m_method.handlers) {
                        User isType;
                        if (e2.to != h2.entry) continue;
                        LLVMEmitter.this.printErr("except: " + h2.type.t.name.toString());
                        if (h2.type.t == BuiltinDomain.instance().ANY()) {
                            isType = LLVMEmitter.this.constantInt(32L, 1L);
                            catchAny = true;
                        } else {
                            Constant typeId = LLVMEmitter.this.getTypeId(h2.type.t);
                            catchTypeIds.add(typeId);
                            ValueWithTyperef[] isTypeArgs = (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(typeId), this.getVWT(xarg).setTempl()});
                            isType = xbb.addInvoke(LLVMEmitter.this.m_module.m_module.getContext(), this.getFunction("istype", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.BooleanTy).setTempl(), isTypeArgs, xbb), this.m_throwAbortBlock, ValueWithTyperef.getValueArray(isTypeArgs), LLVMEmitter.this.useARMCallingConvention);
                            isType = xbb.addInstruction(PtrToIntInst.class, isType, ((LLVMEmitter)LLVMEmitter.this).m_module.types.intTy);
                        }
                        ICmpInst cond = xbb.addInstruction(ICmpInst.class, CmpInst.Predicate.ICMP_NE, isType, LLVMEmitter.this.constantInt(32L, 0L));
                        BasicBlock newBb = this.m_function.addBlock("not_" + h2.type.t);
                        BasicBlock handlerBlock = this.m_function.addBlock("handler_" + h2.type.t);
                        assert (!this.m_exceptEdges.containsKey(e2));
                        this.m_exceptEdges.put(e2, handlerBlock);
                        handlerBlock.addInvoke(LLVMEmitter.this.m_module.m_module.getContext(), this.getFunction("beginTry", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), args, xbb), this.m_throwAbortBlock, ValueWithTyperef.getValueArray(args), LLVMEmitter.this.useARMCallingConvention);
                        handlerBlock.addBranch(this.basicBlock(e2.to));
                        xbb.addBranch(cond, handlerBlock, newBb);
                        xbb = newBb;
                    }
                }
                xbb.addBranch(this.m_rethrowBlock);
                this.m_xsuccsToXbb.put(xsucc, origXbb);
                if (this.m_xsuccsToExceptFilter != null) {
                    Constant exceptFilt;
                    if (catchAny) {
                        exceptFilt = LLVMEmitter.this.constantInt(32L, -1L);
                    } else if (catchTypeIds.size() == 0) {
                        exceptFilt = LLVMEmitter.this.constantInt(32L, 0L);
                    } else {
                        Constant nullTypeId = Constant.getNullValue(((LLVMEmitter)LLVMEmitter.this).m_module.types.TraitsIdTy);
                        catchTypeIds.add(nullTypeId);
                        Constant at2 = LLVMEmitter.this.m_module.getConstantArray(catchTypeIds);
                        GlobalVariable gt = LLVMEmitter.this.m_module.createGlobal(".exfilt", true, at2);
                        exceptFilt = ConstantExpr.getPtrToInt(gt, ((LLVMEmitter)LLVMEmitter.this).m_module.types.intTy);
                    }
                    this.m_xsuccsToExceptFilter.put(xsucc, exceptFilt);
                }
            }
        }

        private boolean directCall(Expr e2, BasicBlock bb2) {
            Typeref tr;
            boolean found = false;
            if (e2.args.length > 1 && e2.ref != null && (tr = this.typeref(e2.args[0])) != null) {
                String publicPrefix = "public::";
                String type = tr.toString();
                if (type.length() > 0 && type.startsWith("public::")) {
                    char lastChar = type.charAt(type.length() - 1);
                    boolean isClass = lastChar == '$';
                    type = lastChar == '$' || lastChar == '?' ? type.substring("public::".length(), type.length() - 1) : type.substring("public::".length());
                    String opName = type + "_" + e2.ref.toString();
                    if (LLVMEmitter.this.m_directCalls.contains(opName)) {
                        if (this.getVWT(e2).setTempl().getType().equals(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy)) {
                            return false;
                        }
                        found = true;
                        LLVMEmitter.this.m_numCallDirect++;
                        if (opName.equals("String_fromCharCode")) {
                            Expr[] fromCharCodeArgs = new Expr[e2.args.length - 1];
                            System.arraycopy(e2.args, 1, fromCharCodeArgs, 0, e2.args.length - 1);
                            this.callFunction(opName, this.getVWT(e2).setTempl(), (ValueWithTyperef[])LLVMEmitter.concat(new ValueWithTyperef[][]{(ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue)}), this.args(fromCharCodeArgs, false)}), bb2, e2);
                        } else if (opName.equals("String_concat")) {
                            Expr[] concatArgs = new Expr[e2.args.length - 1];
                            System.arraycopy(e2.args, 1, concatArgs, 0, e2.args.length - 1);
                            this.callFunction(opName, this.getVWT(e2).setTempl(), (ValueWithTyperef[])LLVMEmitter.concat(new ValueWithTyperef[][]{(ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(e2.args[0]).setTempl()}), this.args(concatArgs, false)}), bb2, e2);
                        } else {
                            Integer extraParameter = isClass || type.equals("Math") ? 0 : 1;
                            this.runtimeMessage(type + "." + opName + " : " + " (arg count: " + e2.args.length + ") <<<<\n", bb2);
                            ValueWithTyperef[] argsArray = new ValueWithTyperef[e2.args.length + extraParameter];
                            argsArray[0] = this.getVWT(this.m_methodEnvPtrValue);
                            Integer i2 = 1 - extraParameter;
                            while (i2 < e2.args.length) {
                                argsArray[i2.intValue() + extraParameter.intValue()] = this.getVWT(e2.args[i2]).setTempl();
                                i2 = i2 + 1;
                            }
                            this.callFunction(opName, this.getVWT(e2).setTempl(), argsArray, bb2, e2);
                            this.runtimeMessage(e2.toString() + " >>>>\n", bb2);
                        }
                    }
                }
            }
            return found;
        }

        private Value emitDoubleAlloca() {
            BasicBlock entryBlock = this.m_function.entryBlock();
            AllocaInst doubleAllocaInst = entryBlock.addInstruction(AllocaInst.class, ((LLVMEmitter)LLVMEmitter.this).m_module.types.NumberTy, LLVMEmitter.this.constantInt(32L, 1L));
            doubleAllocaInst.setAlignment(16L);
            return doubleAllocaInst;
        }

        /*
         * Could not resolve type clashes
         */
        private void emitBlock(Block b3, DebugState debugState) {
            boolean dielater = false;
            HashMap<Expr, Pair<AllocaInst, AllocaInst>> hasnext2AllocaMap = new HashMap<Expr, Pair<AllocaInst, AllocaInst>>();
            BasicBlock bb2 = this.basicBlock(b3);
            if (this.m_bbToXsuccs != null) {
                this.maybeBuildExceptBlock(b3.xsucc);
                this.m_bbToXsuccs.put(bb2, b3.xsucc);
            }
            boolean needToStoreExceptFilter = this.m_exceptFilterVar != null;
            boolean tracedBlockPos = false;
            for (Expr e2 : b3) {
                Value val;
                if (e2.op != 257 && needToStoreExceptFilter) {
                    needToStoreExceptFilter = false;
                    bb2.addVolatileStore(this.getExceptFilter(bb2), this.m_exceptFilterVar);
                }
                if (e2.op != 257 && debugState.locals.size() > 0) {
                    this.emitStoreDebugInfo(bb2, debugState);
                }
                if (e2.succ != null) break;
                if (LLVMEmitter.this.debugMessages) {
                    Typeref tr = this.typeref(e2);
                    String msg = "opcode: " + e2.opName() + " (" + e2.op + ") " + (tr != null ? tr.toString() : "");
                    if (e2.imm != null && e2.imm.length > 0) {
                        msg = msg + ", imm: ";
                        for (int imm : e2.imm) {
                            msg = msg + String.valueOf(imm) + ", ";
                        }
                    }
                    if (e2.args.length > 0) {
                        msg = msg + ", args: ";
                        for (int a : (int[])e2.args) {
                            tr = this.typeref((Expr)a);
                            msg = msg + a.opName() + " " + (tr != null ? tr.toString() : "") + ", ";
                        }
                    }
                    if (e2.ref != null) {
                        msg = msg + ", ref: " + e2.ref.toString();
                    }
                    LLVMEmitter.this.printMsg(msg);
                }
                if (e2.op != 257 && e2.op != 256) {
                    this.runtimeMessage("--- " + e2.opName() + " " + e2.toString() + "\n", bb2);
                    if (!tracedBlockPos) {
                        // empty if block
                    }
                }
                switch (e2.op) {
                    case 257: {
                        Typeref resultType = this.typeref(e2);
                        llvm.Type resultLLVMType = LLVMEmitter.this.m_module.llvmType(resultType.t);
                        assert (e2.pred.length == e2.args.length);
                        PHINode phi = bb2.addInstruction(PHINode.class, resultLLVMType);
                        this.m_exprToLLVMValue.put(e2, phi);
                        break;
                    }
                    case 256: {
                        Value arg = e2.imm[0] >= this.m_method.params.length ? ((this.m_method.needsRest() || this.m_method.needsArguments()) && e2.imm[0] == this.m_method.params.length ? this.m_function.arg(this.m_function.argCount() - 2) : this.callFunction("loadundefined", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.AtomTy).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue)}), bb2, false)) : this.m_function.arg(e2.imm[0]);
                        this.m_exprToLLVMValue.put(e2, arg);
                        break;
                    }
                    case 134: {
                        this.callFunction(e2.opName(), this.getVWT(e2).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWTName(e2.ref, false), this.getVWT(e2.args[0]).setTempl()}), bb2, e2);
                        break;
                    }
                    case 83: {
                        Expr[] typeArgs = new Expr[e2.args.length - 1];
                        System.arraycopy(e2.args, 1, typeArgs, 0, typeArgs.length);
                        this.callFunctionVA(3, e2.opName(), this.getVWT(e2).setTempl(), (ValueWithTyperef[])LLVMEmitter.concat(new ValueWithTyperef[][]{(ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(e2.args[0]).setTempl()}), this.cdeclArgs(typeArgs, false)}), bb2, e2);
                        break;
                    }
                    case 65: {
                        this.runtimeMessage(e2.opName() + "<<<<\n", bb2);
                        Expr[] callArgs = new Expr[e2.args.length - 1];
                        System.arraycopy(e2.args, 1, callArgs, 0, e2.args.length - 1);
                        llvm.Type objLLVMType = this.llvmType(e2.args[0]);
                        if (LLVMStubTypes.compareTypes(objLLVMType, ((LLVMEmitter)LLVMEmitter.this).m_module.types.ArrayObjectPtrTy) || LLVMStubTypes.compareTypes(objLLVMType, ((LLVMEmitter)LLVMEmitter.this).m_module.types.ScriptObjectPtrTy) || LLVMStubTypes.compareTypes(objLLVMType, ((LLVMEmitter)LLVMEmitter.this).m_module.types.AtomTy)) {
                            this.callFunctionVA(3, e2.opName(), this.getVWT(e2).setTempl(), (ValueWithTyperef[])LLVMEmitter.concat(new ValueWithTyperef[][]{(ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(e2.args[0]).setTempl()}), this.cdeclArgs(callArgs, false)}), bb2, e2);
                            this.runtimeMessage(e2.toString() + " >>>>\n", bb2);
                        } else {
                            LLVMEmitter.this.printMsg("Warning: op_call on an invalid type (" + e2.args[0].toString() + ")\n");
                            this.callFunction("throwCallOfNonFunctionError", this.getVWT(e2).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue)}), bb2, e2);
                        }
                        LLVMEmitter.this.m_numCall++;
                        break;
                    }
                    case 70: {
                        if (this.typeref((Expr)e2.args[0]).t.isInterface() && e2.ref.iid != -1) {
                            LLVMEmitter.this.m_numInterface++;
                        }
                    }
                    case 76: 
                    case 79: {
                        if (this.directCall(e2, bb2)) break;
                        this.runtimeMessage(e2.opName() + " : " + e2.ref.toString() + " (arg count: " + e2.args.length + ") <<<<\n", bb2);
                        Pair<Expr[], ValueWithTyperef[]> argsPair = this.extractRuntimeNameArgs(e2, 1, false);
                        this.callFunctionVA(6, "callproperty", e2.op == 79 ? this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy).setTempl() : this.getVWT(e2).setTempl(), (ValueWithTyperef[])LLVMEmitter.concat(new ValueWithTyperef[][]{(ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue)}), (ValueWithTyperef[])argsPair.snd, (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(((Expr[])argsPair.fst)[0]).setTempl()}), this.cdeclArgs((Expr[])argsPair.fst, e2.op == 76)}), bb2, e2);
                        this.runtimeMessage(e2.toString() + " >>>>\n", bb2);
                        LLVMEmitter.this.m_numCallProp++;
                        break;
                    }
                    case 67: 
                    case 68: 
                    case 77: {
                        this.runtimeMessage(e2.opName() + " : " + e2.m.toString() + "<<<<\n", bb2);
                        if (this.needsNullCheck(e2)) {
                            this.callFunction("nullcheck", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(e2.args[0]).setTempl()}), bb2);
                        }
                        if (!this.directCall(e2, bb2)) {
                            User fv = null;
                            Value env = null;
                            if (e2.op == 68) {
                                LoadInst abcenv = bb2.addLoad(this.m_iabcToAbcEnv.get(e2.m.abc));
                                env = this.callFunction("methodEnvFromIndex", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.MethodEnvPtrTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(abcenv), this.getVWTInt(e2.m.abc.oabc.methodId(e2.m))}), bb2);
                                if (!e2.m.isNative()) {
                                    fv = LLVMEmitter.this.getOrCreateFunctionForMethod(e2.m).function();
                                    LLVMEmitter.this.m_numCallMethodEnvFromIndex++;
                                } else {
                                    LLVMEmitter.this.m_numCallStaticNative++;
                                }
                            } else if (e2.op == 77) {
                                env = this.callFunction("methodEnvFromInterface", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.MethodEnvPtrTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWTInt(e2.m.iid), this.getVWT(e2.args[0])}), bb2);
                                LLVMEmitter.this.m_numCallInterface++;
                            } else if (e2.op == 67) {
                                env = this.callFunction("methodEnvFromDispId", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.MethodEnvPtrTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(e2.args[0]).setTempl(), this.getVWTInt(e2.imm[0])}), bb2);
                                LLVMEmitter.this.m_numCallMethod++;
                            } else assert (false);
                            if (fv == null) {
                                Value rawFun = this.callFunction("handlerFromMethodEnv", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.intPtrTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(env), this.getVWT(e2.args[0]).setTempl()}), bb2);
                                FunctionType rawFunType = LLVMEmitter.this.getMethodFunctionType(e2.m);
                                assert (rawFunType.getNumParams() == (long)(e2.args.length + 1));
                                PointerType funType = PointerType.get(rawFunType, 0L);
                                fv = bb2.addInstruction(BitCastInst.class, rawFun, funType);
                            }
                            this.setCallAttrs(env, true, true, false);
                            Value[] args = new Value[e2.args.length + 1];
                            args[args.length - 1] = env;
                            for (int i2 = 0; i2 < e2.args.length; ++i2) {
                                args[i2] = this.value(e2.args[i2]);
                            }
                            Value result = this.callOrInvokeFunction(fv, bb2, args, e2.isPx());
                            this.m_exprToLLVMValue.put(e2, result);
                        }
                        this.runtimeMessage(e2.toString() + " >>>>\n", bb2);
                        break;
                    }
                    case 69: 
                    case 78: {
                        Pair<Expr[], ValueWithTyperef[]> argsPair = this.extractRuntimeNameArgs(e2, 1, false);
                        this.callFunctionVA(5, "callsuper", e2.op == 78 ? this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy).setTempl() : this.getVWT(e2).setTempl(), (ValueWithTyperef[])LLVMEmitter.concat(new ValueWithTyperef[][]{(ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue)}), (ValueWithTyperef[])argsPair.snd, this.cdeclArgs((Expr[])argsPair.fst, false)}), bb2, e2);
                        LLVMEmitter.this.m_numCallSuper++;
                        break;
                    }
                    case 128: {
                        this.m_exprToLLVMValue.put(e2, this.emitCoerceIfNecessary(this.typeref(e2), e2.args[0], bb2));
                        break;
                    }
                    case 130: 
                    case 137: {
                        this.callFunction(e2.opName(), this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.AtomTy).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(e2.args[0]).setTempl()}), bb2, e2);
                        break;
                    }
                    case 261: {
                        assert (e2.castType.getType() == this.typeref(e2).getType());
                        assert (e2.isLegalUpCast(this.typeref(e2.args[0])));
                        if (e2.castType.getType() == this.typeref(e2.args[0]).getType()) {
                            this.m_exprToLLVMValue.put(e2, this.value(e2.args[0]));
                            break;
                        }
                        this.callFunction(e2.opName(), this.getVWT(e2.castType).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(e2.args[0]).setTempl()}), bb2, e2);
                        break;
                    }
                    case 178: {
                        this.callFunction(e2.opName(), this.getVWT(e2).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(LLVMEmitter.this.getTypeId(this.m_method.abc.domain().getNamedType(e2.ref, true))), this.getVWT(e2.args[0]).setTempl()}), bb2, e2);
                        break;
                    }
                    case 263: 
                    case 264: {
                        this.callFunction(e2.opName(), this.getVWT(e2), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(e2.args[0])}), bb2, e2);
                        break;
                    }
                    case 8: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 133: 
                    case 144: 
                    case 145: 
                    case 147: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 192: 
                    case 193: 
                    case 196: {
                        this.callFunction(e2.opName(), this.getVWT(e2).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(e2.args[0]).setTempl()}), bb2, e2);
                        break;
                    }
                    case 74: {
                        if (e2.m != null) {
                            ValueWithTyperef ewt = this.getVWT(e2);
                            Expr a02 = e2.args[0];
                            if (a02.op == 261) {
                                e2.args[0] = a02.args[0];
                            }
                            this.emitGetSlot(bb2, e2, true);
                            e2.args[0] = a02;
                            LLVMEmitter.this.m_numGetSlot++;
                            Value classClosure = this.value(e2);
                            Value classClosureA = this.emitValueBoxing(bb2, this.getVWT(classClosure));
                            Value instanceSO = this.callFunction("newInstance", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.ScriptObjectPtrTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(classClosureA)}), bb2);
                            Value instanceA = this.emitValueBoxing(bb2, this.getVWT(instanceSO));
                            User fv = null;
                            LoadInst abcenv = bb2.addLoad(this.m_iabcToAbcEnv.get(e2.m.abc));
                            Value env = this.callFunction("methodEnvFromIndex", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.MethodEnvPtrTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(abcenv), this.getVWTInt(e2.m.abc.oabc.methodId(e2.m))}), bb2);
                            if (!e2.m.isNative()) {
                                fv = LLVMEmitter.this.getOrCreateFunctionForMethod(e2.m).function();
                            } else {
                                Value rawFun = this.callFunction("handlerFromMethodEnv", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.intPtrTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(env), this.getVWT(e2.args[0]).setTempl()}), bb2);
                                FunctionType rawFunType = LLVMEmitter.this.getMethodFunctionType(e2.m);
                                assert (rawFunType.getNumParams() == (long)(e2.args.length + 1));
                                PointerType funType = PointerType.get(rawFunType, 0L);
                                fv = bb2.addInstruction(BitCastInst.class, rawFun, funType);
                            }
                            this.setCallAttrs(env, true, true, false);
                            Value[] args = new Value[e2.args.length + 1];
                            args[args.length - 1] = env;
                            args[0] = e2.m.params[0].t.emitAsAny() ? instanceA : bb2.addInstruction(BitCastInst.class, instanceSO, LLVMEmitter.this.m_module.llvmType(e2.m.params[0].t));
                            for (int i3 = 1; i3 < e2.args.length; ++i3) {
                                args[i3] = this.value(e2.args[i3]);
                            }
                            this.callOrInvokeFunction(fv, bb2, args, e2.isPx());
                            this.m_exprToLLVMValue.put(e2, ewt.getTyperef().t.emitAsAny() ? instanceA : bb2.addInstruction(BitCastInst.class, instanceSO, ewt.getType()));
                            break;
                        }
                        Pair<Expr[], ValueWithTyperef[]> argsPair = this.extractRuntimeNameArgs(e2, 1, false);
                        this.callFunctionVA(5, e2.opName(), this.getVWT(e2).setTempl(), (ValueWithTyperef[])LLVMEmitter.concat(new ValueWithTyperef[][]{(ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue)}), (ValueWithTyperef[])argsPair.snd, this.cdeclArgs((Expr[])argsPair.fst, false)}), bb2, e2);
                        break;
                    }
                    case 66: {
                        Expr[] typeArgs = new Expr[e2.args.length];
                        System.arraycopy(e2.args, 0, typeArgs, 0, typeArgs.length);
                        this.callFunctionVA(3, e2.opName(), this.getVWT(e2).setTempl(), (ValueWithTyperef[])LLVMEmitter.concat(new ValueWithTyperef[][]{(ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(e2.args[0]).setTempl()}), this.cdeclArgs(typeArgs, true)}), bb2, e2);
                        break;
                    }
                    case 73: {
                        Pair<Value, Value> atomArgs = this.emitAtomArgsArray(bb2, e2.args, false);
                        this.callFunction(e2.opName(), this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT((Value)atomArgs.fst), this.getVWT((Value)atomArgs.snd)}), bb2, e2);
                        break;
                    }
                    case 239: {
                        if (!this.m_debugger) break;
                        debugState.locals.clear();
                        debugState.restore.clear();
                        if (e2.imm[0] == 1) {
                            this.callFunction(e2.opName(), this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWTUint(e2.imm[0]), this.getVWTUint(this.stringId((String)e2.value)), this.getVWTUint(e2.imm[2]), this.getVWTUint(e2.imm[3])}), bb2);
                            break;
                        }
                        assert (false);
                        this.callFunction(e2.opName(), this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWTUint(e2.imm[0]), this.getVWTUint(e2.imm[1]), this.getVWTUint(e2.imm[2]), this.getVWTUint(e2.imm[3])}), bb2);
                        break;
                    }
                    case 241: {
                        String str;
                        debugState.fileName = str = (String)e2.value;
                        if (!this.m_debugger) break;
                        this.callFunction(e2.opName(), this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWTUint(this.stringId(str))}), bb2);
                        break;
                    }
                    case 240: {
                        int lineNo;
                        debugState.lineNo = lineNo = e2.imm[0];
                        if (this.m_debugger) {
                            Value called = this.callFunction(e2.opName(), this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWTUint(lineNo)}), bb2);
                            this.emitRestoreDebugInfo(bb2, debugState);
                        }
                        this.runtimeMessage("After Debug Line - " + debugState.fileName + " : " + String.valueOf(lineNo) + "\n", bb2);
                        break;
                    }
                    case 6: {
                        assert (this.m_methodFrame != null);
                        this.callFunction(e2.opName(), this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(this.m_methodFrame), this.getVWTUint(this.stringId((String)e2.value))}), bb2, e2);
                        break;
                    }
                    case 7: {
                        assert (this.m_methodFrame != null);
                        this.callFunction(e2.opName(), this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(this.m_methodFrame), this.getVWT(e2.args[0]).setTempl()}), bb2, e2);
                        break;
                    }
                    case 95: {
                        if (!optLazyEvals || this.m_method.needActivation()) {
                            LLVMEmitter.this.m_numfinddef++;
                            this.callFunction(e2.opName(), this.getVWT(e2).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWTName(e2.ref, false)}), bb2, e2);
                            break;
                        }
                        LLVMEmitter.this.m_numcachedfinddef++;
                        this.addLazyEval(bb2, e2, "lazyEvalFinddef", LLVMEmitter.this.constantInt(32L, this.nameId(e2.ref)));
                        break;
                    }
                    case 93: 
                    case 94: {
                        LLVMEmitter.this.m_numFindProp++;
                        int withDepth = this.countWithScopes(e2.scopes);
                        Pair<Expr[], ValueWithTyperef[]> argsPair = this.extractRuntimeNameArgs(e2, 0, false);
                        this.callFunction(e2.opName(), this.getVWT(e2).setTempl(), (ValueWithTyperef[])LLVMEmitter.concat(new ValueWithTyperef[][]{(ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue)}), (ValueWithTyperef[])argsPair.snd, (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_scopesValue), this.getVWTInt(e2.scopes.length), this.getVWTInt(withDepth)})}), bb2, e2);
                        break;
                    }
                    case 89: {
                        Pair<Expr[], ValueWithTyperef[]> argsPair = this.extractRuntimeNameArgs(e2, 1, false);
                        this.callFunction(e2.opName(), this.getVWT(e2).setTempl(), (ValueWithTyperef[])LLVMEmitter.concat(new ValueWithTyperef[][]{(ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue)}), (ValueWithTyperef[])argsPair.snd, (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(e2.args[0]).setTempl()})}), bb2, e2);
                        break;
                    }
                    case 100: {
                        this.callFunction(e2.opName(), this.getVWT(e2).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue)}), bb2, e2);
                        break;
                    }
                    case 103: {
                        this.callFunction(e2.opName(), this.getVWT(e2).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWTUint(e2.imm[0])}), bb2, e2);
                        break;
                    }
                    case 108: {
                        this.emitGetSlot(bb2, e2);
                        LLVMEmitter.this.m_numGetSlot++;
                        break;
                    }
                    case 50: {
                        BasicBlock entryBlock = this.m_function.entryBlock();
                        AllocaInst indexAlloca = entryBlock.addInstruction(AllocaInst.class, ((LLVMEmitter)LLVMEmitter.this).m_module.types.intTy, LLVMEmitter.this.constantInt(32L, 1L));
                        AllocaInst objectAlloca = entryBlock.addInstruction(AllocaInst.class, ((LLVMEmitter)LLVMEmitter.this).m_module.types.AtomTy, LLVMEmitter.this.constantInt(32L, 1L));
                        hasnext2AllocaMap.put(e2, new Pair<AllocaInst, AllocaInst>(indexAlloca, objectAlloca));
                        Typeref objType = this.typeref(e2.locals[0]);
                        if (LLVMEmitter.this.debugMessages) {
                            this.value(e2.locals[0]).dump();
                            LLVMEmitter.this.printMsg(objType.getType().toString());
                        }
                        this.callFunction(e2.opName(), this.getVWT(e2).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(e2.locals[0]).setTempl(), this.getVWT(e2.locals[1]).setTempl(), this.getVWT(indexAlloca), this.getVWT(objectAlloca)}), bb2, e2);
                        break;
                    }
                    case 259: {
                        AllocaInst indexAlloca = (AllocaInst)((Pair)hasnext2AllocaMap.get((Object)e2.args[0])).fst;
                        LoadInst indexValue = bb2.addLoad(indexAlloca);
                        this.m_exprToLLVMValue.put(e2, indexValue);
                        break;
                    }
                    case 260: {
                        assert (this.typeref((Expr)e2).t.atom);
                        AllocaInst objectAlloca = (AllocaInst)((Pair)hasnext2AllocaMap.get((Object)e2.args[0])).snd;
                        LoadInst objectValue = bb2.addLoad(objectAlloca);
                        this.m_exprToLLVMValue.put(e2, objectValue);
                        break;
                    }
                    case 87: {
                        this.callFunction(e2.opName(), this.getVWT(e2).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue)}), bb2, e2);
                        break;
                    }
                    case 90: {
                        Handler handler = this.m_method.handlers[e2.imm[0]];
                        Name name = handler.name;
                        int name_id = name == null ? 0 : this.nameId(name);
                        int type_id = this.m_abc.typeRef(handler.type);
                        GlobalVariable u30TypeName = LLVMEmitter.this.m_module.createGlobal("newcatch_typeu30", false, this.u30ConstantArray(type_id));
                        Constant ptn = LLVMEmitter.this.m_module.getGetElementPtrConstantExpression((Constant)u30TypeName, 0, 0);
                        this.callFunction(e2.opName(), this.getVWT(e2).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWTInt(name_id), this.getVWT(ptn)}), bb2, e2);
                        break;
                    }
                    case 88: {
                        LLVMEmitter.this.referenceMethods(e2.c);
                        LLVMEmitter.this.referenceMethods(e2.c.itype);
                        int withScopes = this.countWithScopes(e2.scopes);
                        Constant cTraitsId = LLVMEmitter.this.getTypeId(e2.c);
                        Constant iTraitsId = LLVMEmitter.this.getTypeId(e2.c.itype);
                        Constant scopeTraitsValue = this.getTypeIdsConstantArrayFromExpr(Arrays.asList(e2.scopes));
                        GlobalVariable scopeTraitsGlobalValue = LLVMEmitter.this.m_module.createGlobal("abcClass_" + String.valueOf(this.m_abc.classId(e2.c)) + "_scopeTraits", true, scopeTraitsValue);
                        Constant castedScopeTraitsGlobalValue = LLVMEmitter.this.m_module.getGetElementPtrConstantExpression((Constant)scopeTraitsGlobalValue, 0, 0);
                        assert (LLVMStubTypes.compareTypes(castedScopeTraitsGlobalValue.getType(), ((LLVMEmitter)LLVMEmitter.this).m_module.types.TraitsIdPtrTy));
                        this.callFunction(e2.opName(), this.getVWT(e2).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(cTraitsId), this.getVWT(iTraitsId), this.getVWT(castedScopeTraitsGlobalValue), this.getVWTUint(e2.scopes.length), this.getVWTUint(withScopes), this.getVWT(this.m_scopesValue), this.getVWT(e2.args[0]), this.getVWTUint(this.m_abc.classId(e2.c))}), bb2, e2);
                        break;
                    }
                    case 64: {
                        assert (e2.m.cx != null);
                        LLVMEmitter.this.referenceMethod(e2.m, this.m_method.debugName);
                        int withScopes = this.countWithScopes(e2.scopes);
                        Constant idForDeclaringTraits = LLVMEmitter.this.getTypeId(e2.m.cx);
                        Constant castedScopeTraitsGlobalValue = null;
                        if (e2.scopes.length > 0) {
                            Constant scopeTraitsValue = this.getTypeIdsConstantArrayFromExpr(Arrays.asList(e2.scopes));
                            GlobalVariable scopeTraitsGlobalValue = LLVMEmitter.this.m_module.createGlobal("abcMethod_" + String.valueOf(this.m_abc.methodId(e2.m)) + "_scopeTraits", true, scopeTraitsValue);
                            castedScopeTraitsGlobalValue = LLVMEmitter.this.m_module.getGetElementPtrConstantExpression((Constant)scopeTraitsGlobalValue, 0, 0);
                        } else {
                            castedScopeTraitsGlobalValue = Constant.getNullValue(((LLVMEmitter)LLVMEmitter.this).m_module.types.TraitsIdPtrTy);
                        }
                        assert (LLVMStubTypes.compareTypes(castedScopeTraitsGlobalValue.getType(), ((LLVMEmitter)LLVMEmitter.this).m_module.types.TraitsIdPtrTy));
                        this.callFunction("newfunction", this.getVWT(e2).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(idForDeclaringTraits), this.getVWT(castedScopeTraitsGlobalValue), this.getVWTUint(e2.scopes.length), this.getVWTUint(withScopes), this.getVWT(this.m_scopesValue), this.getVWTUint(this.m_abc.methodId(e2.m))}), bb2, e2);
                        break;
                    }
                    case 85: 
                    case 86: {
                        this.callFunctionVA(2, e2.opName(), this.getVWT(e2).setTempl(), (ValueWithTyperef[])LLVMEmitter.concat(new ValueWithTyperef[][]{(ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue)}), this.cdeclArgs(e2.args, false)}), bb2, e2);
                        break;
                    }
                    case 32: 
                    case 33: 
                    case 38: 
                    case 39: 
                    case 40: {
                        this.emitStaticLoad(bb2, e2, e2.opName());
                        break;
                    }
                    case 258: {
                        this.callFunction(e2.opName(), this.getVWT(e2).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(this.m_exceptionFrame)}), bb2, e2);
                        break;
                    }
                    case 46: {
                        LLVMEmitter.this.printErr("Loading unsigned integer: " + (Long)e2.value);
                        assert (this.typeref(e2).getType() == BuiltinDomain.instance().UINT());
                        this.m_exprToLLVMValue.put(e2, LLVMEmitter.this.constantInt(32L, (Long)e2.value));
                        break;
                    }
                    case 36: 
                    case 37: 
                    case 45: {
                        LLVMEmitter.this.printErr("Loading integer: " + (Integer)e2.value);
                        assert (this.typeref(e2).getType() == BuiltinDomain.instance().INT());
                        this.m_exprToLLVMValue.put(e2, LLVMEmitter.this.constantInt(32L, ((Integer)e2.value).intValue()));
                        break;
                    }
                    case 47: {
                        LLVMEmitter.this.printErr("Loading double: " + (Double)e2.value);
                        assert (this.typeref(e2).getType() == BuiltinDomain.instance().NUMBER());
                        this.m_exprToLLVMValue.put(e2, bb2.constantDouble(LLVMEmitter.this.m_module.m_module.getContext(), (Double)e2.value));
                        break;
                    }
                    case 49: {
                        this.callFunction("loadnamespace", this.getVWT(e2).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWTUint(this.nsId((Namespace)e2.value))}), bb2, e2);
                        break;
                    }
                    case 28: 
                    case 48: {
                        this.callFunction(e2.opName(), this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(e2.args[0]).setTempl()}), bb2, e2);
                        Value scopeBoxedValue = this.emitValueBoxing(bb2, e2.args[0]);
                        int depth = LLVMEmitter.this.getScopeDepth(e2) - 1;
                        Value[] indexes = new Value[]{LLVMEmitter.this.constantInt(32L, depth)};
                        GetElementPtrInst scopesStackTopValue = bb2.addGetElementPtr(this.m_scopesValue, indexes);
                        bb2.addStore(scopeBoxedValue, scopesStackTopValue);
                        this.m_exprToLLVMValue.put(e2, this.value(e2.args[0]));
                        if (this.m_debugVars == null) break;
                        GetElementPtrInst gep = bb2.addGetElementPtr(this.m_debugVars, (Value[])LLVMEmitter.arr(new ConstantInt[]{LLVMEmitter.this.constantInt(32L, this.m_method.local_count + depth)}));
                        bb2.addVolatileStore(scopeBoxedValue, gep);
                        break;
                    }
                    case 29: {
                        if (this.m_debugVars == null) break;
                        int depth = LLVMEmitter.this.getScopeDepth(e2);
                        Value undef = this.callFunction("loadundefined", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.AtomTy).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue)}), bb2, false);
                        GetElementPtrInst gep = bb2.addGetElementPtr(this.m_debugVars, (Value[])LLVMEmitter.arr(new ConstantInt[]{LLVMEmitter.this.constantInt(32L, this.m_method.local_count + depth)}));
                        bb2.addVolatileStore(undef, gep);
                        break;
                    }
                    case 44: {
                        LLVMEmitter.this.m_numpushstring++;
                        if (optLazyEvals) {
                            this.addLazyEval(bb2, e2, "lazyEvalPushstring", LLVMEmitter.this.constantInt(32L, this.stringId((String)e2.value)));
                            break;
                        }
                        this.callFunction("loadstring", this.getVWT(e2).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWTUint(this.stringId((String)e2.value))}), bb2, e2);
                        break;
                    }
                    case 97: 
                    case 102: {
                        if (LLVMEmitter.this.debugMessages && this.typeref((Expr)e2.args[0]).t.isInterface() && e2.ref.iid != -1) {
                            LLVMEmitter.this.m_numInterface++;
                        }
                    }
                    case 4: 
                    case 5: 
                    case 104: 
                    case 106: {
                        boolean maybeInt = e2.op == 102 || e2.op == 97 || e2.op == 106;
                        Pair<Expr[], ValueWithTyperef[]> argsPair = this.extractRuntimeNameArgs(e2, 1, maybeInt);
                        boolean retVoid = e2.op == 97 || e2.op == 104 || e2.op == 5;
                        String suffix = (e2.op == 102 || e2.op == 97) && !this.needsNullCheck(e2) ? "_nonc" : "";
                        this.callFunction(e2.opName() + suffix, retVoid ? this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy) : this.getVWT(e2).setTempl(e2.op != 106), (ValueWithTyperef[])LLVMEmitter.concat(new ValueWithTyperef[][]{(ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue)}), (ValueWithTyperef[])argsPair.snd, this.getVWTs((Expr[])argsPair.fst, true)}), bb2, e2);
                        switch (e2.op) {
                            case 102: {
                                LLVMEmitter.this.m_numGetProp++;
                                break;
                            }
                            case 97: {
                                LLVMEmitter.this.m_numSetProp++;
                            }
                        }
                        break;
                    }
                    case 262: {
                        this.callFunction(e2.opName(), this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(e2.args[0]).setTempl(), this.getVWT(e2.args[1]).setTempl()}), bb2, e2);
                        break;
                    }
                    case 109: {
                        this.emitSetSlot(bb2, e2);
                        LLVMEmitter.this.m_numSetSlot++;
                        break;
                    }
                    case 30: 
                    case 31: 
                    case 35: 
                    case 135: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: 
                    case 165: 
                    case 166: 
                    case 167: 
                    case 168: 
                    case 169: 
                    case 170: 
                    case 171: 
                    case 172: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 177: 
                    case 179: 
                    case 180: 
                    case 197: 
                    case 198: 
                    case 199: {
                        this.callFunction(e2.opName(), this.getVWT(e2).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(e2.args[0]).setTempl(), this.getVWT(e2.args[1]).setTempl()}), bb2, e2);
                        break;
                    }
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: {
                        this.callFunction(e2.opName(), this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(e2.args[0]).setTempl(), this.getVWT(e2.args[1]).setTempl()}), bb2, e2);
                        break;
                    }
                    case 42: {
                        Expr l0 = e2.locals[0];
                        Value v0 = this.value(l0);
                        this.m_exprToLLVMValue.put(e2, v0);
                        break;
                    }
                    case 1: 
                    case 242: 
                    case 243: {
                        break;
                    }
                    default: {
                        LLVMEmitter.this.printErr("Failed to handle op: " + e2.opName());
                        dielater = true;
                    }
                }
                if (this.m_debugVars != null) {
                    Object uses = this.m_exprUses.get(e2);
                    Iterator i$ = uses.iterator();
                    while (i$.hasNext()) {
                        Expr use = (Expr)i$.next();
                        if (use.op != 239 || use.imm[0] != 1) continue;
                        debugState.locals.add(new Pair<Expr, Expr>(use, e2));
                    }
                    if (e2.op != 257) {
                        this.emitStoreDebugInfo(bb2, debugState);
                    }
                }
                if ((val = this.m_exprToLLVMValue.get(e2)) != null && !LLVMStubTypes.compareTypes(val.getType(), ((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy)) {
                    TwineRef n2 = new TwineRef(e2.toString());
                    val.setName(n2.t);
                    n2.delete();
                }
                if (val != null || e2.op == 240) continue;
                LLVMEmitter.this.printErr("No value stored for expr...");
            }
            if (debugState.locals.size() > 0) {
                this.emitStoreDebugInfo(bb2, debugState);
            }
            assert (!dielater);
        }

        private String getDebugName(DebugState debugState, String identifier) {
            String[] parts;
            String name = "dbg_";
            if (null != debugState.fileName && (parts = debugState.fileName.split("[;,/,\\\\]")).length > 0) {
                name = name + parts[parts.length - 1].replace('.', '_');
                name = name + "_";
                name = name + debugState.lineNo;
                name = name + "_";
            }
            name = name + identifier;
            return name;
        }

        private void emitStoreDebugInfo(BasicBlock bb2, DebugState debugState) {
            Map<Expr, Value> oldExprToDebugValue = this.m_exprToDebugValue;
            this.m_exprToDebugValue = null;
            for (Pair<Expr, Expr> p2 : debugState.locals) {
                int n2 = this.m_method.params.length + ((Expr)p2.fst).imm[2];
                if (n2 >= this.m_debugVarCount) continue;
                Expr e2 = (Expr)p2.snd;
                Value v2 = this.emitValueBoxing(bb2, e2);
                TwineRef t1 = new TwineRef(this.getDebugName(debugState, e2.toString()));
                v2.setName(t1.t);
                t1.delete();
                GetElementPtrInst gep = bb2.addGetElementPtr(this.m_debugVars, (Value[])LLVMEmitter.arr(new ConstantInt[]{LLVMEmitter.this.constantInt(32L, n2)}));
                TwineRef t2 = new TwineRef(this.getDebugName(debugState, "stored_" + e2.toString()));
                gep.setName(t2.t);
                t2.delete();
                bb2.addVolatileStore(v2, gep);
            }
            debugState.restore.clear();
            debugState.restore.addAll(debugState.locals);
            debugState.locals.clear();
            this.m_exprToDebugValue = oldExprToDebugValue;
        }

        private void emitRestoreDebugInfo(BasicBlock bb2, DebugState debugState) {
            Map<Expr, Value> oldExprToDebugValue = this.m_exprToDebugValue;
            this.m_exprToDebugValue = null;
            for (Pair<Expr, Expr> p2 : debugState.restore) {
                int n2 = this.m_method.params.length + ((Expr)p2.fst).imm[2];
                if (n2 >= this.m_debugVarCount) continue;
                Expr e2 = (Expr)p2.snd;
                GetElementPtrInst gep = bb2.addGetElementPtr(this.m_debugVars, (Value[])LLVMEmitter.arr(new ConstantInt[]{LLVMEmitter.this.constantInt(32L, n2)}));
                TwineRef t1 = new TwineRef(this.getDebugName(debugState, "stored_" + e2.toString()));
                gep.setName(t1.t);
                t1.delete();
                LoadInst loadInst = bb2.addLoad(gep);
                loadInst.setVolatile(true);
                TwineRef t2 = new TwineRef(this.getDebugName(debugState, e2.toString()));
                loadInst.setName(t2.t);
                t2.delete();
                ValueWithTyperef vwt = new ValueWithTyperef(loadInst, ((LLVMEmitter)LLVMEmitter.this).m_module.types.AtomTy, null);
                Value v2 = this.emitValueUnboxing(bb2, e2, vwt);
                TwineRef t3 = new TwineRef(e2.toString());
                v2.setName(t3.t);
                t3.delete();
                oldExprToDebugValue.put(e2, v2);
            }
            this.m_exprToDebugValue = oldExprToDebugValue;
            debugState.restore.clear();
        }

        private Value addLazyEval(BasicBlock bb2, Expr e2, ValueWithTyperef vwt, String evalFunction, ConstantInt evalData) {
            LoadInst gvLoad = bb2.addLoad(Constant.getNullValue(PointerType.get(((LLVMEmitter)LLVMEmitter.this).m_module.types.uintPtrTy, 0L)));
            Value result = null;
            if (e2 == null) {
                result = this.callFunction("load", vwt.setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(gvLoad)}), bb2);
            } else {
                this.callFunction("load", vwt.setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(gvLoad)}), bb2, e2);
            }
            llvm.Type[] paramTypes = new llvm.Type[]{((LLVMEmitter)LLVMEmitter.this).m_module.types.MethodEnvPtrTy, ((LLVMEmitter)LLVMEmitter.this).m_module.types.uintTy};
            FunctionType ft = Module.getFunctionType(((LLVMEmitter)LLVMEmitter.this).m_module.types.uintTy, paramTypes, false);
            llvm.Function evaluator = LLVMEmitter.this.m_module.getOrCreateFunction(evalFunction, ft, LLVMEmitter.this.useARMCallingConvention).function();
            LazyEval lazyEval = new LazyEval(this.m_method, gvLoad, evaluator, evalData);
            LLVMEmitter.this.lazyEvals.add(lazyEval);
            return result;
        }

        private void addLazyEval(BasicBlock bb2, Expr e2, String evalFunction, ConstantInt evalData) {
            this.addLazyEval(bb2, e2, this.getVWT(e2), evalFunction, evalData);
        }

        private Constant u30ConstantArray(int v2) {
            byte[] b3 = this.u30Bytes(v2);
            ArrayList<Constant> l2 = new ArrayList<Constant>(b3.length);
            for (int i2 = 0; i2 < b3.length; ++i2) {
                l2.add(LLVMEmitter.this.constantInt(8L, b3[i2]));
            }
            return LLVMEmitter.this.m_module.getConstantArray(l2);
        }

        private byte[] u30Bytes(int v2) {
            ArrayList<Byte> l2 = new ArrayList<Byte>();
            if (v2 < 128 && v2 >= 0) {
                l2.add((byte)v2);
            } else if (v2 < 16384 && v2 >= 0) {
                l2.add((byte)(v2 & 0x7F | 0x80));
                l2.add((byte)(v2 >> 7));
            } else if (v2 < 0x200000 && v2 >= 0) {
                l2.add((byte)(v2 & 0x7F | 0x80));
                l2.add((byte)(v2 >> 7 | 0x80));
                l2.add((byte)(v2 >> 14));
            } else if (v2 < 0x10000000 && v2 >= 0) {
                l2.add((byte)(v2 & 0x7F | 0x80));
                l2.add((byte)(v2 >> 7 | 0x80));
                l2.add((byte)(v2 >> 14 | 0x80));
                l2.add((byte)(v2 >> 21));
            } else {
                l2.add((byte)(v2 & 0x7F | 0x80));
                l2.add((byte)(v2 >> 7 | 0x80));
                l2.add((byte)(v2 >> 14 | 0x80));
                l2.add((byte)(v2 >> 21 | 0x80));
                l2.add((byte)(v2 >> 28));
            }
            byte[] result = new byte[l2.size()];
            int i2 = 0;
            for (Byte b3 : l2) {
                result[i2++] = b3;
            }
            return result;
        }

        private Value emitCoerceIfNecessary(Typeref toType, Expr e2, BasicBlock bb2) {
            Typeref valType = this.typeref(e2);
            LLVMEmitter.this.printErr("emitCoerceIfNecessary: " + valType.t.name + " -> " + toType.getType().name);
            Constant traitsId = LLVMEmitter.this.getTypeId(toType.t);
            assert (LLVMStubTypes.compareTypes(traitsId.getType(), ((LLVMEmitter)LLVMEmitter.this).m_module.types.TraitsIdTy));
            if (valType.t.isDerivedFrom(toType.t) && valType.t.isAtom() == toType.t.isAtom()) {
                return this.value(e2);
            }
            return this.callFunction("coerce", this.getVWT(toType).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(traitsId), this.getVWT(e2).setTempl()}), bb2);
        }

        private Pair<Expr[], ValueWithTyperef[]> extractRuntimeNameArgs(Expr e2, int offset, boolean maybeInt) throws Error {
            int num = (e2.ref.runtimeName() ? 1 : 0) + (e2.ref.runtimeNamespace() ? 1 : 0);
            boolean runtimeName = e2.ref.runtimeName();
            boolean runtimeNS = e2.ref.runtimeNamespace();
            Expr nsExpr = runtimeNS ? e2.args[offset] : null;
            Expr nameExpr = runtimeName ? e2.args[offset + num - 1] : null;
            boolean bl2 = maybeInt = maybeInt && runtimeName;
            if (maybeInt) {
                maybeInt = false;
                assert (offset > 0);
                Expr objExpr = e2.args[0];
                Type nameType = this.typeref(nameExpr).getType();
                llvm.Type objLLVMType = this.llvmType(objExpr);
                if (e2.ref.runtimeName() && !e2.ref.runtimeNamespace() && !e2.ref.isAttr() && (nameType.numeric || nameType.atom) && nameType != BuiltinDomain.instance().BOOLEAN() && e2.ref.containsPublic() && (LLVMStubTypes.compareTypes(objLLVMType, ((LLVMEmitter)LLVMEmitter.this).m_module.types.ArrayObjectPtrTy) || LLVMStubTypes.compareTypes(objLLVMType, ((LLVMEmitter)LLVMEmitter.this).m_module.types.ScriptObjectPtrTy) || LLVMStubTypes.compareTypes(objLLVMType, ((LLVMEmitter)LLVMEmitter.this).m_module.types.AtomTy))) {
                    maybeInt = true;
                }
            }
            ValueWithTyperef nameVWT = this.getVWTName(e2.ref, maybeInt);
            ValueWithTyperef unusedParam = this.getVWT(UndefValue.get(((LLVMEmitter)LLVMEmitter.this).m_module.types.UnsedParamTy)).setTempl();
            GlobalVariable multiname = this.m_nameToMultiname.get(e2.ref);
            if (multiname == null) {
                UndefValue multinameValue = UndefValue.get(((LLVMEmitter)LLVMEmitter.this).m_module.types.MultinamePtrTy.getElementType());
                multiname = LLVMEmitter.this.m_module.createGlobal("", false, multinameValue);
                this.m_nameToMultiname.put(e2.ref, multiname);
            }
            Constant mnv = maybeInt ? ConstantExpr.getCast(Instruction.CastOps.BitCast.swigValue(), multiname, ((LLVMEmitter)LLVMEmitter.this).m_module.types.MultinamePtrMaybeIntTy) : multiname;
            nameVWT = this.getVWT(mnv).setTempl();
            ValueWithTyperef[] vwts = new ValueWithTyperef[]{nameVWT, runtimeName ? this.getVWT(nameExpr).setTempl() : unusedParam, runtimeNS ? this.getVWT(nsExpr).setTempl() : unusedParam};
            Expr[] xs = new Expr[e2.args.length - num];
            int x2 = 0;
            for (int i2 = 0; i2 < e2.args.length; ++i2) {
                if (i2 >= offset && i2 < offset + num) continue;
                xs[x2++] = e2.args[i2];
            }
            return new Pair<Expr[], ValueWithTyperef[]>(xs, vwts);
        }

        private Pair<Value, Value> emitAtomArgsArray(BasicBlock bb2, Expr[] args, boolean nullFirstArg) throws Error {
            BasicBlock entryBlock = this.m_function.entryBlock();
            ConstantInt nArgsValue = LLVMEmitter.this.constantInt(32L, args.length);
            AllocaInst argsAllocA = entryBlock.addInstruction(AllocaInst.class, ((LLVMEmitter)LLVMEmitter.this).m_module.types.AtomTy, nArgsValue);
            for (int i2 = 0; i2 < args.length; ++i2) {
                GetElementPtrInst gep = bb2.addGetElementPtr((Value)argsAllocA, (Value[])LLVMEmitter.arr(new ConstantInt[]{LLVMEmitter.this.constantInt(32L, i2)}));
                Value v2 = null;
                v2 = i2 == 0 && nullFirstArg ? this.emitValueBoxing(bb2, this.getVWTNull(((LLVMEmitter)LLVMEmitter.this).m_module.types.ScriptObjectPtrTy)) : this.emitValueBoxing(bb2, args[i2]);
                bb2.addStore(v2, gep);
            }
            return new Pair<Value, Value>(argsAllocA, nArgsValue);
        }

        private final Value emitValueUnboxing(BasicBlock bb2, Expr e2, ValueWithTyperef vwt) {
            if (this.boxed(this.typeref(e2)) || LLVMStubTypes.compareTypes(((LLVMEmitter)LLVMEmitter.this).m_module.types.AtomTy, this.llvmType(e2))) {
                return vwt.getValue();
            }
            return this.callFunction("unbox", this.getVWT(e2).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), ((ValueWithTyperef)vwt.clone()).setTempl()}), bb2);
        }

        private final Value emitValueBoxing(BasicBlock bb2, ValueWithTyperef vwt) {
            if (LLVMStubTypes.compareTypes(((LLVMEmitter)LLVMEmitter.this).m_module.types.AtomTy, vwt.getType())) {
                return vwt.getValue();
            }
            return this.callFunction("box", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.AtomTy).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), ((ValueWithTyperef)vwt.clone()).setTempl()}), bb2, false);
        }

        private final Value emitValueBoxing(BasicBlock bb2, Expr e2) {
            if (this.boxed(this.typeref(e2))) {
                return this.value(e2);
            }
            return this.emitValueBoxing(bb2, this.getVWT(e2));
        }

        private final boolean boxed(Typeref t2) {
            if (t2.exact && t2.t == BuiltinDomain.instance().OBJECT()) {
                return false;
            }
            return t2.t.isAtom();
        }

        private Constant getTypeIdsConstantArrayFromExpr(Collection<Expr> exprs) {
            ArrayList<Constant> scopeTraits = new ArrayList<Constant>();
            for (Expr e2 : exprs) {
                scopeTraits.add(LLVMEmitter.this.getTypeId(this.typeref((Expr)e2).t));
            }
            return LLVMEmitter.this.m_module.getConstantArray(scopeTraits);
        }

        private final int uniqueOp(Expr e2) {
            if (e2.op != 257) {
                return e2.op;
            }
            int op = -1;
            HashSet<Expr> seen = new HashSet<Expr>();
            LinkedList<Expr> work = new LinkedList<Expr>();
            work.add(e2);
            while (work.size() > 0) {
                Expr ec = (Expr)work.removeLast();
                if (seen.contains(ec)) continue;
                seen.add(ec);
                if (ec.op == 257) {
                    work.addAll(Arrays.asList(ec.args));
                    continue;
                }
                if (op == -1) {
                    op = ec.op;
                    continue;
                }
                if (op == ec.op) continue;
                return -1;
            }
            return op;
        }

        private final int countWithScopes(Expr[] scopes) {
            int i2;
            int scopeDepth = scopes.length;
            for (i2 = 0; i2 < scopeDepth && this.uniqueOp(scopes[i2]) == 48; ++i2) {
            }
            assert (i2 == scopeDepth || this.uniqueOp(scopes[i2]) == 28);
            return scopeDepth - i2;
        }

        private String symbolName(Method m2) {
            String idsString = m2.id != -1 ? String.valueOf(this.m_abc.methodId(m2)) + "_" + m2.id + "_" : "";
            return "abcMethod_" + m2.abc.scriptBaseName() + "_" + idsString + m2.toString();
        }

        private class DebugState {
            public String fileName;
            public int lineNo;
            public List<Pair<Expr, Expr>> locals;
            public List<Pair<Expr, Expr>> restore;

            private DebugState() {
            }
        }
    }

    private static final class ValueWithTyperef
    implements Cloneable {
        private final Value _val;
        private final llvm.Type _t;
        private final Typeref _tref;
        private boolean _isTemplateParam;

        public ValueWithTyperef(Value v2) {
            this._val = v2;
            this._tref = null;
            this._t = v2.getType();
            this._isTemplateParam = false;
        }

        public ValueWithTyperef(llvm.Type t2) {
            this._val = null;
            this._tref = null;
            this._t = t2;
            this._isTemplateParam = false;
        }

        public ValueWithTyperef(Value v2, Typeref tr) {
            this._val = v2;
            this._tref = tr;
            this._t = null;
            this._isTemplateParam = false;
        }

        public ValueWithTyperef(Value v2, llvm.Type t2, Typeref tr) {
            this._val = v2;
            this._tref = tr;
            this._t = t2;
            this._isTemplateParam = false;
        }

        public Object clone() {
            ValueWithTyperef vwt = new ValueWithTyperef(this._val, this._t, this._tref);
            vwt._isTemplateParam = this._isTemplateParam;
            return vwt;
        }

        public ValueWithTyperef setTempl() {
            return this.setTempl(true);
        }

        public ValueWithTyperef setTempl(boolean v2) {
            this._isTemplateParam = v2;
            return this;
        }

        public boolean isTempl() {
            return this._isTemplateParam;
        }

        public Value getValue() {
            return this._val;
        }

        public Typeref getTyperef() {
            return this._tref;
        }

        public llvm.Type getType() {
            return this._t;
        }

        public llvm.Type getEffectiveLLVMType(Module m2) {
            if (this._t != null) {
                return this._t;
            }
            return m2.llvmType(this.getTyperef().getType());
        }

        public static Value[] getValueArray(ValueWithTyperef[] xs) {
            Value[] result = new Value[xs.length];
            for (int i2 = 0; i2 < xs.length; ++i2) {
                result[i2] = xs[i2].getValue();
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Module {
        private final llvm.Module m_module;
        private final boolean m_useARMCallingConvention;
        public final LLVMStubFunctions functions;
        public final LLVMStubTypes types;
        private Map<Type, llvm.Type> m_abcTypeToLLVMType;

        public Module(LLVMContext ctx, boolean useARMCallingConvention) {
            this(new llvm.Module(new JNIStringRef("empty module"), ctx), useARMCallingConvention);
        }

        private Module(llvm.Module m2, boolean useARMCallingConvention) {
            this.m_useARMCallingConvention = useARMCallingConvention;
            this.m_module = m2;
            this.functions = new LLVMStubFunctions(this);
            this.types = LLVMStubTypes.extract(this);
            assert (this.types != null);
            LLVMStubTypes.removeFromModule(this);
            this.m_abcTypeToLLVMType = null;
            this.createUnwindStub();
        }

        private void createUnwindStub() {
            FunctionType ft = Module.getFunctionType(this.types.voidTy, new llvm.Type[0], false);
            Function f2 = this.getOrCreateFunction("llvm_unwind", ft, this.m_useARMCallingConvention);
            f2.deleteBody();
            BasicBlock bb2 = f2.addBlock("entry");
            bb2.addInstruction(UnwindInst.class, this.m_module.getContext());
        }

        Function getOrCreateFunction(String functionName, FunctionType functionType, boolean useARMCallingConvention) {
            return Function.getOrInsertFunction(this.m_module, functionName, functionType, useARMCallingConvention);
        }

        Function createInternalFunction(String functionName, FunctionType functionType, boolean useARMCallingConvention) {
            return Function.getOrInsertFunction(this.m_module, functionName, functionType, useARMCallingConvention);
        }

        Function getFunction(String functionName) {
            JNIStringRef name = new JNIStringRef(functionName);
            llvm.Function f2 = this.m_module.getFunction(name);
            name.delete();
            return f2 != null ? new Function(f2) : null;
        }

        String getTypeName(llvm.Type t2) {
            return this.m_module.getTypeName(t2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static FunctionType getFunctionType(llvm.Type resultType, llvm.Type[] paramTypes, boolean varArg) {
            Type_vector tv = new Type_vector();
            try {
                for (llvm.Type t2 : paramTypes) {
                    tv.add(t2);
                }
                FunctionType functionType = FunctionType.get(resultType, tv, varArg);
                return functionType;
            }
            finally {
                tv.delete();
            }
        }

        public Constant getGetElementPtrConstantExpression(Constant base, Integer ... indexes) {
            Constant[] indexConstants = new Constant[indexes.length];
            for (int i2 = 0; i2 < indexes.length; ++i2) {
                indexConstants[i2] = LLVMEmitter.constantInt(this.m_module.getContext(), 32L, indexes[i2].intValue());
            }
            return this.getGetElementPtrConstantExpression(base, indexConstants);
        }

        private Constant getGetElementPtrConstantExpression(Constant base, Constant ... indexes) {
            return this.getGetElementPtrConstantExpression(base, Arrays.asList(indexes));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Constant getGetElementPtrConstantExpression(Constant base, Iterable<Constant> indexes) {
            Constant_vector indexesVector = new Constant_vector();
            try {
                for (Constant index : indexes) {
                    indexesVector.add(index);
                }
                Constant constant = ConstantExpr.getGetElementPtr(base, indexesVector);
                return constant;
            }
            finally {
                indexesVector.delete();
            }
        }

        public static Constant castIntToPointer(ConstantInt constInt, llvm.Type pointerType) {
            return ConstantExpr.getCast(Instruction.CastOps.IntToPtr.swigValue(), constInt, pointerType);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Module load(LLVMContext ctx, File f2, boolean useARMCallingConvention) throws IOException {
            MemoryBuffer buff = null;
            try {
                JNIStringRef path = new JNIStringRef(f2.getCanonicalPath());
                buff = MemoryBuffer.getFile(path);
                path.delete();
                assert (buff != null);
                Module module = new Module(LLVM.ParseBitcodeFile(buff, ctx), useARMCallingConvention);
                return module;
            }
            finally {
                buff.delete();
            }
        }

        public void write(File f2) throws IOException {
            LLVM.WriteModuleToFile(f2.getCanonicalPath(), this.m_module, 262144L);
        }

        public llvm.Type getVoidTy() {
            return llvm.Type.getVoidTy(this.m_module.getContext());
        }

        public OpaqueType getOpaqueType() {
            return OpaqueType.get(this.m_module.getContext());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public llvm.Function getLLVMFunction(String name) {
            JNIStringRef n2 = new JNIStringRef(name);
            try {
                llvm.Function function = this.m_module.getFunction(n2);
                return function;
            }
            finally {
                n2.delete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GlobalVariable getGlobal(String name, boolean allowInternal) {
            JNIStringRef n2 = new JNIStringRef(name);
            try {
                GlobalVariable globalVariable = this.m_module.getGlobalVariable(n2, allowInternal);
                return globalVariable;
            }
            finally {
                n2.delete();
            }
        }

        public GlobalVariable createGlobal(String name, boolean isConstant, llvm.Type t2) {
            return GlobalVariable.Create(this.m_module, t2, isConstant, GlobalValue.LinkageTypes.ExternalLinkage, null, name, null);
        }

        public GlobalVariable createGlobal(String name, boolean isConstant, Constant initializer) {
            return GlobalVariable.Create(this.m_module, initializer.getType(), isConstant, GlobalValue.LinkageTypes.ExternalLinkage, initializer, name, null);
        }

        public GlobalVariable setGlobal(boolean isConstant, Constant initializer, String name, boolean addBitCast) {
            GlobalVariable newGlobal;
            GlobalVariable existingGlobal = this.getGlobal(name, true);
            if (existingGlobal == null) {
                throw new Error("Unable to find global:" + name);
            }
            llvm.Type type = initializer.getType();
            Constant newGlobalAsConstant = newGlobal = GlobalVariable.Create(this.m_module, type, isConstant, GlobalValue.LinkageTypes.ExternalLinkage, initializer, "", null);
            if (addBitCast) {
                newGlobalAsConstant = ConstantExpr.getCast(Instruction.CastOps.BitCast.swigValue(), newGlobal, existingGlobal.getType());
            }
            existingGlobal.replaceAllUsesWith(newGlobalAsConstant);
            existingGlobal.eraseFromParent();
            TwineRef n2 = new TwineRef(name);
            newGlobal.setName(n2.t);
            n2.delete();
            return newGlobal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GlobalVariable setGlobalType(llvm.Type t2, boolean isConstant, String name) {
            GlobalVariable existingGlobal = this.getGlobal(name, true);
            if (existingGlobal == null) {
                throw new Error("Unable to find global:" + name);
            }
            GlobalVariable newGlobal = GlobalVariable.Create(this.m_module, t2, isConstant, GlobalValue.LinkageTypes.ExternalLinkage, null, "", null);
            Constant newGlobalAsConstant = ConstantExpr.getCast(Instruction.CastOps.BitCast.swigValue(), newGlobal, existingGlobal.getType());
            existingGlobal.replaceAllUsesWith(newGlobalAsConstant);
            existingGlobal.removeFromParent();
            try {
                Twine tn = new Twine(existingGlobal.getName());
                newGlobal.setName(tn);
                tn.delete();
                GlobalVariable globalVariable = newGlobal;
                return globalVariable;
            }
            finally {
                existingGlobal.delete();
            }
        }

        public Constant getConstantArrayOfZeros(llvm.Type t2, int length) {
            Constant zero = Constant.getNullValue(t2);
            ArrayList<Constant> zeroes = new ArrayList<Constant>();
            for (int i2 = 0; i2 < length; ++i2) {
                zeroes.add(zero);
            }
            return this.getConstantArray(zeroes);
        }

        private static int swap(int value) {
            int b12 = value >> 0 & 0xFF;
            int b22 = value >> 8 & 0xFF;
            int b3 = value >> 16 & 0xFF;
            int b4 = value >> 24 & 0xFF;
            return b12 << 24 | b22 << 16 | b3 << 8 | b4 << 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Constant getConstantByteArray(byte[] bytes) {
            boolean bigEndian;
            boolean bl2 = bigEndian = this.m_module.getEndianness() == Module.Endianness.BigEndian;
            assert (bigEndian || this.m_module.getEndianness() == Module.Endianness.LittleEndian);
            int nInts = (bytes.length + 3) / 4;
            assert (nInts * 4 >= bytes.length);
            int[] ints = new int[nInts];
            if (bytes.length % 4 != 0) {
                byte[] newBytes = new byte[nInts * 4];
                System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
                bytes = newBytes;
            }
            int accumulator = 0;
            int accumulatorCount = 0;
            for (byte b3 : bytes) {
                accumulator <<= 8;
                accumulator |= b3 & 0xFF;
                if (++accumulatorCount % 4 != 0) continue;
                ints[accumulatorCount / 4 - 1] = bigEndian ? accumulator : Module.swap(accumulator);
                accumulator = 0;
            }
            assert (accumulatorCount % 4 == 0);
            Constant_vector valuesVector = new Constant_vector();
            try {
                for (int i2 : ints) {
                    valuesVector.add(LLVMEmitter.constantInt(this.m_module.getContext(), 32L, i2));
                }
                ArrayType arrType = ArrayType.get(llvm.Type.getInt32Ty(this.m_module.getContext()), BigInteger.valueOf(nInts));
                Constant constant = ConstantArray.get(arrType, valuesVector);
                return constant;
            }
            finally {
                valuesVector.delete();
            }
        }

        public Constant getConstantArray(Collection<Constant> values) {
            ArrayType arrType = ArrayType.get(values.isEmpty() ? llvm.Type.getInt8Ty(this.m_module.getContext()) : values.iterator().next().getType(), BigInteger.valueOf(values.size()));
            return Module.getConstantArray(arrType, values);
        }

        private static Constant_vector makeConstantVector(Iterable<Constant> values) {
            Constant_vector valuesVector = new Constant_vector();
            try {
                for (Constant c2 : values) {
                    valuesVector.add(c2);
                }
            }
            catch (Error e2) {
                valuesVector.delete();
                throw e2;
            }
            return valuesVector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Constant getConstantArray(ArrayType type, Collection<Constant> values) {
            Constant_vector valuesVector = Module.makeConstantVector(values);
            try {
                Constant constant = ConstantArray.get(type, valuesVector);
                return constant;
            }
            finally {
                valuesVector.delete();
            }
        }

        public static Constant getConstantStruct(StructType t2, Constant ... memberValues) {
            return Module.getConstantStruct(t2, Arrays.asList(memberValues));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Constant getConstantStruct(StructType t2, Collection<Constant> memberValues) {
            Constant_vector valuesVector = Module.makeConstantVector(memberValues);
            try {
                Constant constant = ConstantStruct.get(t2, valuesVector);
                return constant;
            }
            finally {
                valuesVector.delete();
            }
        }

        public llvm.Type llvmType(Type t2) {
            llvm.Type result;
            if (t2.isAtom()) {
                return this.types.AtomTy;
            }
            if (this.m_abcTypeToLLVMType == null) {
                this.m_abcTypeToLLVMType = new HashMap<Type, llvm.Type>();
                BuiltinDomain abcTypes = BuiltinDomain.instance();
                this.m_abcTypeToLLVMType.put(abcTypes.ARRAY(), this.types.ArrayObjectPtrTy);
                this.m_abcTypeToLLVMType.put(abcTypes.BOOLEAN(), this.types.BooleanTy);
                this.m_abcTypeToLLVMType.put(abcTypes.CLASS(), this.types.ScriptObjectPtrTy);
                this.m_abcTypeToLLVMType.put(abcTypes.FUNCTION(), this.types.ScriptObjectPtrTy);
                this.m_abcTypeToLLVMType.put(abcTypes.INT(), this.types.intTy);
                this.m_abcTypeToLLVMType.put(abcTypes.NAMESPACE(), this.types.NamespacePtrTy);
                this.m_abcTypeToLLVMType.put(abcTypes.NUMBER(), this.types.NumberTy);
                this.m_abcTypeToLLVMType.put(abcTypes.QNAME(), this.types.QNameObjectPtrTy);
                this.m_abcTypeToLLVMType.put(abcTypes.STRING(), this.types.StringPtrTy);
                this.m_abcTypeToLLVMType.put(abcTypes.UINT(), this.types.uintTy);
                this.m_abcTypeToLLVMType.put(abcTypes.XML(), this.types.ScriptObjectPtrTy);
                this.m_abcTypeToLLVMType.put(abcTypes.XMLLIST(), this.types.ScriptObjectPtrTy);
                this.m_abcTypeToLLVMType.put(abcTypes.VOID(), this.types.voidTy);
            }
            if ((result = this.m_abcTypeToLLVMType.get(t2)) == null) {
                result = this.types.ScriptObjectPtrTy;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StructType structType(LLVMContext ctx, Iterable<llvm.Type> memberTypes, boolean isPacked) {
            Type_vector memberTypeVector = new Type_vector();
            try {
                for (llvm.Type memberType : memberTypes) {
                    memberTypeVector.add(memberType);
                }
                StructType structType = StructType.get(ctx, memberTypeVector, isPacked);
                return structType;
            }
            finally {
                memberTypeVector.delete();
            }
        }

        public llvm.Function[] getFunctions() {
            Function_vector fv = LLVM.toVector(this.m_module.getFunctionList());
            int size = (int)fv.size();
            llvm.Function[] a = new llvm.Function[size];
            for (int i2 = 0; i2 < size; ++i2) {
                a[i2] = fv.get(i2);
            }
            fv.delete();
            return a;
        }

        public GlobalVariable[] getGlobals() {
            GlobalVariable_vector gv = LLVM.toVector(this.m_module.getGlobalList());
            int size = (int)gv.size();
            GlobalVariable[] g2 = new GlobalVariable[size];
            for (int i2 = 0; i2 < size; ++i2) {
                g2[i2] = gv.get(i2);
            }
            gv.delete();
            return g2;
        }

        public Constant functionToCompiledHandler(Function f2) {
            return ConstantExpr.getCast(Instruction.CastOps.BitCast.swigValue(), f2.function(), this.types.CompiledHandlerPtrTy);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Function {
        private final llvm.Function m_function;

        public static Function getOrInsertFunction(llvm.Module module, String functionName, FunctionType functionType, boolean useARMCallingConvention) {
            JNIStringRef name = new JNIStringRef(functionName);
            llvm.Function f2 = llvm.Function.dyn_cast(GlobalValue.dyn_cast(module.getOrInsertFunction((StringRef)name, functionType)));
            name.delete();
            if (useARMCallingConvention) {
                f2.setCallingConv(CallingConv.ARM_APCS);
            }
            return new Function(f2);
        }

        public static Function createInternalFunction(String functionName, FunctionType functionType, boolean useARMCallingConvention) {
            TwineRef name = new TwineRef(functionName);
            llvm.Function f2 = llvm.Function.Create(functionType, GlobalValue.LinkageTypes.InternalLinkage, name.t);
            if (useARMCallingConvention) {
                f2.setCallingConv(CallingConv.ARM_APCS);
            }
            name.delete();
            return new Function(f2);
        }

        public static Function getFunction(Module m2, String name) {
            return new Function(m2.getLLVMFunction(name));
        }

        private Function(llvm.Function f2) {
            this.m_function = f2;
        }

        public BasicBlock addBlock() {
            return new BasicBlock(this.m_function, "");
        }

        public BasicBlock addBlock(String name) {
            return new BasicBlock(this.m_function, name);
        }

        public BasicBlock entryBlock() {
            return new BasicBlock(this.m_function.getEntryBlock());
        }

        public void deleteBody() {
            this.m_function.deleteBody();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Argument arg(int n2) {
            Argument_vector args = LLVM.toVector(this.m_function.getArgumentList());
            try {
                if ((long)n2 < args.size()) {
                    Argument argument = args.get(n2);
                    return argument;
                }
                Argument argument = null;
                return argument;
            }
            finally {
                args.delete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int argCount() {
            Argument_vector args = LLVM.toVector(this.m_function.getArgumentList());
            try {
                int n2 = (int)args.size();
                return n2;
            }
            finally {
                args.delete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static CallInst call(BasicBlock b3, Value fv, Iterable<Value> args, boolean useARMCallingConvention) {
            Value_vector argsVector = new Value_vector();
            try {
                for (Value arg : args) {
                    argsVector.add(arg);
                }
                CallInst ci = b3.addInstruction(CallInst.class, fv, argsVector);
                if (useARMCallingConvention) {
                    ci.setCallingConv(CallingConv.ARM_APCS);
                }
                CallInst callInst = ci;
                return callInst;
            }
            finally {
                argsVector.delete();
            }
        }

        public CallInst call(BasicBlock b3, Iterable<Value> args, boolean useARMCallingConvention) {
            return Function.call(b3, this.m_function, args, useARMCallingConvention);
        }

        public CallInst call(BasicBlock b3, Value[] args, boolean useARMCallingConvention) {
            return this.call(b3, Arrays.asList(args), useARMCallingConvention);
        }

        public llvm.Function function() {
            return this.m_function;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BasicBlock {
        private llvm.BasicBlock m_origBlock;
        private llvm.BasicBlock m_block;

        public BasicBlock(llvm.Function function, String name) {
            TwineRef tr = new TwineRef(name);
            this.m_origBlock = this.m_block = llvm.BasicBlock.Create(function.getContext(), tr.t, function);
            tr.delete();
        }

        public BasicBlock(llvm.BasicBlock b3) {
            this.m_origBlock = this.m_block = b3;
        }

        private static java.lang.reflect.Method findJavaMethod(java.lang.reflect.Method[] methods, String name, Class<?> resultClass, Class<?>[] args) {
            for (java.lang.reflect.Method m2 : methods) {
                Class<?>[] methodArgs;
                if (!name.equals(m2.getName()) || (methodArgs = m2.getParameterTypes()).length != args.length) continue;
                boolean allMatch = true;
                for (int i2 = 0; allMatch && i2 < args.length; ++i2) {
                    Class<?> methodArg = methodArgs[i2];
                    Class<?> arg = args[i2];
                    allMatch = methodArg.isAssignableFrom(arg);
                }
                if (!allMatch) continue;
                return m2;
            }
            return null;
        }

        private static <T extends Instruction> Constructor<T> findConstructor(Constructor<T>[] constructors, Class<?>[] args) {
            for (Constructor<T> c2 : constructors) {
                Class<?>[] constructorArgs = c2.getParameterTypes();
                if (constructorArgs.length != args.length) continue;
                boolean allMatch = true;
                for (int i2 = 0; allMatch && i2 < args.length; ++i2) {
                    Class<?> constructorArg = constructorArgs[i2];
                    Class<?> arg = args[i2];
                    allMatch = constructorArg.isAssignableFrom(arg);
                }
                if (!allMatch) continue;
                return c2;
            }
            return null;
        }

        public <T extends Instruction> T addInstruction(Class<T> theClass, Object ... args) {
            try {
                Instruction newInstruction;
                Class[] argTypes = new Class[args.length];
                for (int i2 = 0; i2 < args.length; ++i2) {
                    argTypes[i2] = args[i2].getClass();
                }
                java.lang.reflect.Method createMethod = BasicBlock.findJavaMethod(theClass.getDeclaredMethods(), "Create", theClass, argTypes);
                if (createMethod != null) {
                    newInstruction = (Instruction)createMethod.invoke(null, args);
                } else {
                    Constructor<?> constructor = BasicBlock.findConstructor(theClass.getConstructors(), argTypes);
                    newInstruction = (Instruction)constructor.newInstance(args);
                }
                assert (this.m_block.getTerminator() == null);
                this.m_block.insert(newInstruction);
                return (T)newInstruction;
            }
            catch (IllegalArgumentException e2) {
            }
            catch (IllegalAccessException e3) {
            }
            catch (InvocationTargetException e4) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GetElementPtrInst addGetElementPtr(Value aggValue, List<Value> indexes) {
            Value_vector indexesVector = new Value_vector();
            try {
                for (Value v2 : indexes) {
                    indexesVector.add(v2);
                }
                GetElementPtrInst getElementPtrInst = this.addInstruction(GetElementPtrInst.class, aggValue, indexesVector, "");
                return getElementPtrInst;
            }
            finally {
                indexesVector.delete();
            }
        }

        public GetElementPtrInst addGetElementPtr(Value aggValue, Value[] indexes) {
            return this.addGetElementPtr(aggValue, Arrays.asList(indexes));
        }

        public LoadInst addLoad(Value ptr) {
            return LoadInst.Create(ptr, "", this.m_block);
        }

        public StoreInst addStore(Value val, Value ptr) {
            return StoreInst.Create(val, ptr, this.m_block);
        }

        public StoreInst addVolatileStore(Value val, Value ptr) {
            StoreInst result = this.addStore(val, ptr);
            result.setVolatile(true);
            return result;
        }

        public void addBranch(Value condition, BasicBlock target1, BasicBlock target2) {
            BranchInst.Create(target1.m_origBlock, target2.m_origBlock, condition, this.m_block);
        }

        public void addBranch(BasicBlock target) {
            BranchInst br2 = BranchInst.Create(target.m_origBlock);
            assert (this.m_block.getTerminator() == null);
            this.m_block.insert(br2);
        }

        public void addDenseSwitch(LLVMContext ctx, Value val, BasicBlock defaultTarget, BasicBlock[] targets) {
            SwitchInst sw = SwitchInst.Create(val, defaultTarget.m_origBlock, (long)(targets.length + 1), this.m_block);
            for (int i2 = 0; i2 < targets.length; ++i2) {
                sw.addCase(LLVMEmitter.constantInt(ctx, 32L, i2), targets[i2].m_origBlock);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ConstantFP constantDouble(LLVMContext ctx, double val) {
            APFloat apf = new APFloat(val);
            try {
                ConstantFP constantFP = ConstantFP.get(ctx, apf);
                return constantFP;
            }
            finally {
                apf.delete();
            }
        }

        public void setPHIIncoming(PHINode phi, Value v2) {
            phi.addIncoming(v2, this.m_block);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InvokeInst addInvoke(LLVMContext ctx, Value fv, BasicBlock except, Iterable<Value> args, boolean useARMCallingConvention) {
            Value_vector argsVector = new Value_vector();
            try {
                for (Value arg : args) {
                    argsVector.add(arg);
                }
                TwineRef invoke_norm = new TwineRef("invoke_norm");
                llvm.BasicBlock normal = llvm.BasicBlock.Create(ctx, invoke_norm.t, this.m_block.getParent());
                invoke_norm.delete();
                InvokeInst i2 = this.addInstruction(InvokeInst.class, fv, normal, except.m_origBlock, argsVector);
                if (useARMCallingConvention) {
                    i2.setCallingConv(CallingConv.ARM_APCS);
                }
                this.m_block = normal;
                InvokeInst invokeInst = i2;
                return invokeInst;
            }
            finally {
                argsVector.delete();
            }
        }

        public InvokeInst addInvoke(LLVMContext ctx, Function f2, BasicBlock except, Iterable<Value> args, boolean useARMCallingConvention) {
            return this.addInvoke(ctx, f2.function(), except, args, useARMCallingConvention);
        }

        public InvokeInst addInvoke(LLVMContext ctx, Function f2, BasicBlock except, Value[] args, boolean useARMCallingConvention) {
            return this.addInvoke(ctx, f2, except, Arrays.asList(args), useARMCallingConvention);
        }

        public boolean hasNUses(long n2) {
            return this.m_origBlock.hasNUses(n2);
        }

        public void eraseFromParent() {
            this.m_origBlock.eraseFromParent();
            this.m_origBlock = null;
        }
    }
}

