/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.Algorithms;
import adobe.abc.Edge;
import adobe.abc.Expr;
import adobe.abc.Method;
import adobe.abc.OptimizerConstants;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Block
implements Iterable<Expr>,
Comparable<Block> {
    public Algorithms.Deque<Expr> exprs = new Algorithms.ArrayDeque<Expr>();
    private Set<Expr> live_out = new HashSet<Expr>();
    public int id;
    public int postorder;
    public Edge[] xsucc = OptimizerConstants.noedges;
    boolean must_isolate_block = false;
    boolean is_backwards_branch_target = false;
    int pos;

    public Block(Method m2, int pos) {
        this.id = m2.getNextBlockId();
        this.pos = pos;
    }

    public boolean hasExpr(Expr e2) {
        return this.exprs.contains(e2);
    }

    public void appendExpr(Expr e2) {
        if (this.exprs.size() > 0 && this.exprs.peekLast().succ != null) {
            Expr last = this.exprs.removeLast();
            this.exprs.add(e2);
            this.exprs.add(last);
        } else {
            this.exprs.add(e2);
        }
    }

    public void insertExprs(Expr before, Iterable<Expr> i2) {
        assert (this.exprs.indexOf(before) != -1);
        if (this.exprs.peekLast() == before) {
            this.exprs.removeLast();
            assert (this.exprs.size() == 0 || this.exprs.peekLast().succ == null);
            for (Expr e2 : i2) {
                this.appendExpr(e2);
            }
            this.exprs.add(before);
        } else {
            Algorithms.ArrayDeque<Expr> newExprs = new Algorithms.ArrayDeque<Expr>();
            for (Expr te : this.exprs) {
                if (te == before) {
                    assert (i2 != null);
                    for (Expr e3 : i2) {
                        newExprs.add(e3);
                    }
                    i2 = null;
                }
                newExprs.add(te);
            }
            assert (i2 == null);
            this.exprs = newExprs;
        }
    }

    public void insertExpr(Expr before, Expr e2) {
        assert (this.exprs.indexOf(before) != -1);
        if (this.exprs.peekLast() == before) {
            this.exprs.removeLast();
            assert (this.exprs.size() == 0 || this.exprs.peekLast().succ == null);
            this.appendExpr(e2);
            this.exprs.add(before);
        } else {
            Algorithms.ArrayDeque<Expr> newExprs = new Algorithms.ArrayDeque<Expr>();
            for (Expr te : this.exprs) {
                if (te == before) {
                    assert (e2 != null);
                    newExprs.add(e2);
                    e2 = null;
                }
                newExprs.add(te);
            }
            assert (e2 == null);
            this.exprs = newExprs;
        }
    }

    public void insertExprAfter(Expr after, Expr e2) {
        Algorithms.ArrayDeque<Expr> newExprs = new Algorithms.ArrayDeque<Expr>();
        int lastOp = 257;
        assert (e2 != null);
        for (Expr te : this.exprs) {
            if (te.op == 257 && lastOp != 257) {
                Expr last = (Expr)newExprs.removeLast();
                newExprs.add(te);
                newExprs.add(last);
            } else {
                newExprs.add(te);
                lastOp = te.op;
            }
            if (te != after) continue;
            assert (e2 != null);
            newExprs.add(e2);
            lastOp = e2.op;
            e2 = null;
        }
        assert (e2 == null);
        this.exprs = newExprs;
    }

    public void killRegister(Method m2, int regnum) {
        this.appendExpr(new Expr(m2, 8, -1, regnum));
    }

    public String toString() {
        return 'B' + String.valueOf(this.id);
    }

    public Expr first() {
        return this.exprs.peekFirst();
    }

    public Expr firstNonPhi() {
        for (Expr e2 : this) {
            if (e2.op == 257) continue;
            return e2;
        }
        return null;
    }

    public Expr last() {
        return this.exprs.peekLast();
    }

    public Edge[] succ() {
        if (this.last().succ != null) {
            return this.last().succ;
        }
        return OptimizerConstants.noedges;
    }

    @Override
    public Iterator<Expr> iterator() {
        return this.exprs.iterator();
    }

    public void add(Expr e2) {
        this.exprs.add(e2);
    }

    void addAll(Block b3) {
        this.exprs.addAll(b3.exprs);
    }

    public boolean isEmpty() {
        return this.exprs.isEmpty();
    }

    public int size() {
        return this.exprs.size();
    }

    public void remove(Expr e2) {
        this.exprs.remove(e2);
    }

    @Override
    public int compareTo(Block b3) {
        return this.id - b3.id;
    }

    public void addLiveOut(Expr e2) {
        assert (this.exprs.contains(e2));
        this.live_out.add(e2);
    }

    public Set<Expr> getLiveOut() {
        return this.live_out;
    }
}

