/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.util;

import com.adobe.internal.util.ByteSequence;
import com.adobe.internal.util.ByteString;
import java.io.Serializable;

public class ByteStringBuffer
implements ByteSequence,
Comparable,
Serializable {
    private byte[] value;
    private int length;
    private static final long serialVersionUID = -5059151845327279132L;

    public ByteStringBuffer() {
        this(16);
    }

    public ByteStringBuffer(int n) {
        this.value = new byte[n];
    }

    public byte byteAt(int n) {
        if (n < 0 || n >= this.length) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return this.value[n];
    }

    public int length() {
        return this.length;
    }

    public ByteSequence subSequence(int n, int n2) {
        return null;
    }

    public ByteString substring(int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.length) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        return new ByteString(this.value, n, n2 - n);
    }

    public void getBytes(int n, int n2, byte[] byArray, int n3) {
        try {
            System.arraycopy(this.value, n, byArray, n3, n2 - n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            StringIndexOutOfBoundsException stringIndexOutOfBoundsException = new StringIndexOutOfBoundsException();
            stringIndexOutOfBoundsException.initCause(indexOutOfBoundsException);
            throw stringIndexOutOfBoundsException;
        }
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.length];
        System.arraycopy(this.value, 0, byArray, 0, this.length);
        return byArray;
    }

    public void setByteAt(int n, byte by) {
        if (n < 0 || n >= this.length) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.value[n] = by;
    }

    public ByteStringBuffer append(byte by) {
        int n = this.length + 1;
        if (n > this.value.length) {
            this.expandCapacity(n);
        }
        this.value[this.length++] = by;
        return this;
    }

    public ByteStringBuffer append(byte[] byArray) {
        return this.append(byArray, 0, byArray.length);
    }

    public ByteStringBuffer append(byte[] byArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException("Byte array index out of bounds.");
        }
        int n3 = this.length + n2;
        if (n3 > this.value.length) {
            this.expandCapacity(n3);
        }
        System.arraycopy(this.value, this.length, byArray, n, n2);
        this.length += n2;
        return this;
    }

    public void ensureCapacity(int n) {
        if (n > this.value.length) {
            this.expandCapacity(n);
        }
    }

    private void expandCapacity(int n) {
        int n2 = (this.value.length + 1) * 2;
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        } else if (n > n2) {
            n2 = n;
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.value, 0, byArray, 0, this.length);
        this.value = byArray;
    }

    public int compareTo(Object object) {
        return this.compareTo((ByteStringBuffer)object);
    }

    public int compareTo(ByteStringBuffer byteStringBuffer) {
        int n = Math.min(this.length, byteStringBuffer.length);
        for (int i = 0; i < n; ++i) {
            byte by = this.value[i];
            byte by2 = byteStringBuffer.value[i];
            if (by == by2) continue;
            return by - by2;
        }
        return this.length - byteStringBuffer.length;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ByteStringBuffer) {
            return this.compareTo(object) == 0;
        }
        return false;
    }
}

