/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.mac.resource;

import com.adobe.internal.io.CountingInputStream;
import com.adobe.internal.io.ExtendedDataInputStream;
import com.adobe.internal.io.RangedInputStream;
import com.adobe.internal.mac.resource.ScriptUtility;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class ResourceParser {
    private static final boolean DEBUG = false;
    private URL url;
    private List resourceTypes;
    private List resources;
    private List resourceNames;
    private Map resourceHandlers = new HashMap();

    public void setURL(URL uRL) {
        this.url = uRL;
    }

    public void addHandler(ResourceHandler resourceHandler) {
        this.resourceHandlers.put(new ResouceHandlerKey(resourceHandler.getResourceType()), resourceHandler);
    }

    private void init() {
        this.resourceTypes = new ArrayList();
        this.resources = new LinkedList();
        this.resourceNames = new LinkedList();
    }

    public void parse() throws IOException {
        Object object;
        int n;
        int n2;
        Object object2;
        int n3;
        this.init();
        InputStream inputStream = this.url.openStream();
        CountingInputStream countingInputStream = new CountingInputStream(inputStream);
        ExtendedDataInputStream extendedDataInputStream = new ExtendedDataInputStream(countingInputStream);
        long l = extendedDataInputStream.readUnsignedInt();
        long l2 = extendedDataInputStream.readUnsignedInt();
        long l3 = extendedDataInputStream.readUnsignedInt();
        long l4 = extendedDataInputStream.readUnsignedInt();
        long l5 = l2 - 16L + 22L;
        extendedDataInputStream.skipFully(l5);
        int n4 = extendedDataInputStream.readUnsignedShort();
        int n5 = extendedDataInputStream.readUnsignedShort();
        int n6 = extendedDataInputStream.readUnsignedShort();
        int n7 = extendedDataInputStream.readUnsignedShort();
        for (n3 = 0; n3 <= n7; ++n3) {
            object2 = new byte[4];
            extendedDataInputStream.readFully((byte[])object2);
            n2 = extendedDataInputStream.readUnsignedShort();
            n = extendedDataInputStream.readShort();
            object = new ResourceTypeEntry((byte[])object2, n2, n);
            this.insertIntoList(this.resourceTypes, object, new OrderInt(){

                public int getOrderInt(Object object) {
                    return ((ResourceTypeEntry)object).getOffset();
                }
            });
        }
        for (n3 = 0; n3 <= n7; ++n3) {
            object2 = (ResourceTypeEntry)this.resourceTypes.get(n3);
            for (n2 = 0; n2 <= ((ResourceTypeEntry)object2).getNumberOfEntries(); ++n2) {
                n = extendedDataInputStream.readUnsignedShort();
                short s = extendedDataInputStream.readShort();
                byte by = extendedDataInputStream.readByte();
                int n8 = extendedDataInputStream.readUnsigned3ByteInt();
                extendedDataInputStream.readInt();
                ResourceEntry resourceEntry = new ResourceEntry(((ResourceTypeEntry)object2).getResourceType(), n, by, n8, s);
                ((ResourceTypeEntry)object2).addResource(resourceEntry);
                this.insertIntoList(this.resources, resourceEntry, new OrderInt(){

                    public int getOrderInt(Object object) {
                        return ((ResourceEntry)object).getDataOffset();
                    }
                });
                this.insertIntoList(this.resourceNames, resourceEntry, new OrderInt(){

                    public int getOrderInt(Object object) {
                        return ((ResourceEntry)object).getNameOffset();
                    }
                });
            }
        }
        for (n3 = 0; n3 < this.resourceNames.size(); ++n3) {
            object2 = (ResourceEntry)this.resourceNames.get(n3);
            n2 = extendedDataInputStream.readUnsignedByte();
            byte[] byArray = new byte[n2];
            extendedDataInputStream.readFully(byArray);
            ((ResourceEntry)object2).setNameBytes(byArray);
        }
        extendedDataInputStream.close();
        extendedDataInputStream = null;
        countingInputStream.close();
        countingInputStream = null;
        inputStream.close();
        inputStream = null;
        InputStream inputStream2 = this.url.openStream();
        object2 = new CountingInputStream(inputStream2);
        ExtendedDataInputStream extendedDataInputStream2 = new ExtendedDataInputStream((InputStream)object2);
        extendedDataInputStream2.skipFully(l);
        for (int i = 0; i < this.resources.size(); ++i) {
            object = (ResourceEntry)this.resources.get(i);
            long l6 = (long)((ResourceEntry)object).getDataOffset() + l - ((CountingInputStream)object2).getOffset();
            extendedDataInputStream2.skipFully(l6);
            long l7 = extendedDataInputStream2.readUnsignedInt();
            RangedInputStream rangedInputStream = new RangedInputStream(extendedDataInputStream2, l7);
            ResourceHandler resourceHandler = (ResourceHandler)this.resourceHandlers.get(new ResouceHandlerKey(((ResourceEntry)object).getType()));
            if (resourceHandler == null) continue;
            resourceHandler.handleResource((ResourceEntry)object, l7, rangedInputStream);
        }
    }

    private void dumpResourceList() {
        ListIterator listIterator = this.resources.listIterator();
        System.out.println("Resources");
        System.out.println("===============");
        while (listIterator.hasNext()) {
            ResourceEntry resourceEntry = (ResourceEntry)listIterator.next();
            System.out.println(resourceEntry);
            System.out.println("---------------");
        }
    }

    private void dumpResourceTypeList() {
        ListIterator listIterator = this.resourceTypes.listIterator();
        System.out.println("Resource Types");
        System.out.println("===============");
        while (listIterator.hasNext()) {
            ResourceTypeEntry resourceTypeEntry = (ResourceTypeEntry)listIterator.next();
            System.out.println(resourceTypeEntry);
            System.out.println("---------------");
        }
    }

    void insertIntoList(List list, Object object, OrderInt orderInt) {
        if (orderInt.getOrderInt(object) == -1) {
            return;
        }
        if (list.isEmpty()) {
            list.add(object);
        } else {
            boolean bl = false;
            ListIterator<Object> listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                Object e = listIterator.next();
                if (orderInt.getOrderInt(object) >= orderInt.getOrderInt(e)) continue;
                listIterator.previous();
                listIterator.add(object);
                bl = true;
                break;
            }
            if (!bl) {
                list.add(object);
            }
        }
    }

    static interface OrderInt {
        public int getOrderInt(Object var1);
    }

    private static final class ResouceHandlerKey {
        private final byte[] type;

        public ResouceHandlerKey(byte[] byArray) {
            this.type = byArray;
        }

        public int hashCode() {
            int n = 1;
            for (int i = 0; i < this.type.length; ++i) {
                n = 31 * n + this.type[i];
            }
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof ResouceHandlerKey)) {
                return false;
            }
            ResouceHandlerKey resouceHandlerKey = (ResouceHandlerKey)object;
            return Arrays.equals(this.type, resouceHandlerKey.type);
        }
    }

    public static interface ResourceHandler {
        public void handleResource(ResourceEntry var1, long var2, InputStream var4);

        public byte[] getResourceType();
    }

    public static class ResourceEntry {
        private byte[] type;
        private int id;
        private byte attributes;
        private int dataOffset;
        private int nameOffset;
        private String name;
        private byte[] nameBytes;
        private int script;

        protected ResourceEntry(byte[] byArray, int n, byte by, int n2, int n3) {
            this.type = byArray;
            this.id = n;
            this.attributes = by;
            this.dataOffset = n2;
            this.nameOffset = n3;
        }

        public int getDataOffset() {
            return this.dataOffset;
        }

        public int getNameOffset() {
            return this.nameOffset;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("type = " + new String(this.type) + "\n");
            stringBuffer.append("id = " + this.id + "\n");
            stringBuffer.append("attributes = " + this.attributes + "\n");
            stringBuffer.append("data offset = " + this.dataOffset + "\n");
            stringBuffer.append("name offset = " + this.nameOffset + "\n");
            stringBuffer.append("name = " + this.name);
            return stringBuffer.toString();
        }

        protected void setNameBytes(byte[] byArray) {
            this.nameBytes = byArray;
            this.generateName();
        }

        private void generateName() {
            this.script = ScriptUtility.scriptCodeFromRsrcID(this.id);
            try {
                this.name = new String(this.nameBytes, ScriptUtility.scriptCodeToCharset(this.script));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }

        public byte[] getType() {
            return this.type;
        }

        public byte getAttributes() {
            return this.attributes;
        }

        public byte[] getNameBytes() {
            return this.nameBytes;
        }

        public String getName() {
            return this.name;
        }

        public int getScriptCode() {
            return this.script;
        }

        public int getID() {
            return this.id;
        }
    }

    private static class ResourceTypeEntry {
        private byte[] type;
        private int numberOfEntries;
        private List resources;
        private int offset;

        public ResourceTypeEntry(byte[] byArray, int n, int n2) {
            this.type = byArray;
            this.numberOfEntries = n;
            this.resources = new ArrayList(this.numberOfEntries + 1);
            this.offset = n2;
        }

        public int getNumberOfEntries() {
            return this.numberOfEntries;
        }

        public byte[] getResourceType() {
            return this.type;
        }

        public int getOffset() {
            return this.offset;
        }

        public void addResource(ResourceEntry resourceEntry) {
            this.resources.add(resourceEntry);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("type = " + new String(this.type) + "\n");
            stringBuffer.append("number of entries = " + this.numberOfEntries + "\n");
            stringBuffer.append("offset = " + this.offset + "\n");
            return stringBuffer.toString();
        }
    }
}

