/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class TagSearchingOutputStream
extends FilterOutputStream {
    protected byte[] tag;
    protected Callback callback;
    protected boolean lookForTag = true;
    protected int outputTag = 0;
    protected int inTagPosition = 0;

    public TagSearchingOutputStream(OutputStream outputStream, byte[] byArray, Callback callback) throws IOException {
        super(outputStream);
        if (byArray == null || callback == null) {
            throw new IOException("Invalid parameters to the constructor.");
        }
        this.tag = (byte[])byArray.clone();
        this.callback = callback;
    }

    public boolean searchForTag(boolean bl) throws IOException {
        if (bl == this.lookForTag) {
            return this.lookForTag;
        }
        this.writeTagBytes(true);
        this.lookForTag = bl;
        return !this.lookForTag;
    }

    public boolean searchForTag() throws IOException {
        return this.lookForTag;
    }

    public int outputTag(int n) throws IOException {
        int n2 = this.outputTag;
        this.outputTag = n;
        return n2;
    }

    public int outputTag() throws IOException {
        return this.outputTag;
    }

    public void write(int n) throws IOException {
        if (!this.checkForTag((byte)n)) {
            if (this.inTagPosition != 0) {
                this.writeTagBytes(true);
            }
            if (!this.checkForTag((byte)n)) {
                super.write(n);
            }
        }
    }

    public void close() throws IOException {
        this.writeTagBytes(true);
        super.close();
    }

    private boolean checkForTag(byte by) throws IOException {
        if (!this.lookForTag) {
            return false;
        }
        if (by == this.tag[this.inTagPosition]) {
            ++this.inTagPosition;
            if (this.inTagPosition >= this.tag.length) {
                int n = this.outputTag;
                if (n < 0) {
                    this.writeTagBytes(true);
                }
                this.tagFound();
                if (n == 0) {
                    this.writeTagBytes(false);
                }
                if (n > 0) {
                    this.writeTagBytes(true);
                }
            }
            return true;
        }
        return false;
    }

    private void writeTagBytes(boolean bl) throws IOException {
        if (bl && this.inTagPosition != 0) {
            this.writeBytes(this.tag, this.inTagPosition);
        }
        this.inTagPosition = 0;
    }

    private void writeBytes(byte[] byArray, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            super.write(byArray[i]);
        }
    }

    private void tagFound() throws IOException {
        this.lookForTag = this.callback.tagFound(this);
    }

    public static interface Callback {
        public boolean tagFound(TagSearchingOutputStream var1) throws IOException;
    }
}

