/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3;

import flex2.compiler.Source;
import flex2.compiler.util.LineNumberMap;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import macromedia.asc.embedding.avmplus.ActionBlockEmitter;
import macromedia.asc.semantics.MetaData;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.ByteList;
import macromedia.asc.util.Context;
import macromedia.asc.util.IntList;
import macromedia.asc.util.StringPrintWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BytecodeEmitter
extends ActionBlockEmitter {
    private LineNumberMap map;
    private Source source;
    private String currentFileName;
    private Context cx;
    private boolean keepEmbed;
    private Set<Line> lines;
    private Line key;

    public BytecodeEmitter(Context cx, Source source, boolean debug, boolean codeHints) {
        this(cx, source, debug, codeHints, false, null);
    }

    public BytecodeEmitter(Context cx, Source source, boolean debug, boolean codeHints, boolean keepEmbed, LineNumberMap map) {
        super(cx, source != null ? source.getName() : null, new StringPrintWriter(), new StringPrintWriter(), false, false, false, debug, codeHints);
        this.map = map;
        this.source = source;
        this.cx = cx;
        this.keepEmbed = keepEmbed;
        if (debug) {
            this.lines = new HashSet<Line>();
            this.key = new Line();
        }
    }

    @Override
    protected IntList addMetadata(ArrayList<MetaData> metadata) {
        if (this.keepEmbed) {
            return super.addMetadata(metadata);
        }
        IntList metaDataIndices = null;
        if (metadata != null && metadata.size() > 0) {
            metaDataIndices = new IntList(metadata.size());
            for (MetaData metaData : metadata) {
                String id = metaData.id;
                if (id.equals("Embed")) continue;
                Value[] values = metaData.values;
                int metaDataIndex = this.addMetadataInfo(id, values);
                metaDataIndices.add(metaDataIndex);
            }
        }
        return metaDataIndices;
    }

    @Override
    protected void DebugSlot(String name, int slot, int line) {
        int newLine;
        if (this.source.isDebuggable() && (newLine = this.calculateLineNumber(line)) != -1) {
            super.DebugSlot(name, slot, newLine);
        }
    }

    @Override
    protected void DebugFile(String name) {
        this.currentFileName = name;
        if (!this.source.isDebuggable()) {
            return;
        }
        if (this.map != null && this.map.getNewName().equals(name)) {
            name = this.map.getOldName();
        }
        if (this.source.isSourcePathOwner() || this.source.isSourceListOwner() || this.source.isResourceContainerOwner() || this.source.isRoot()) {
            String relativePath = this.source.getRelativePath().replace('/', File.separatorChar);
            if (relativePath.length() == 0) {
                int index = name.lastIndexOf(File.separatorChar);
                if (index != -1) {
                    name = name.substring(0, index) + ";;" + name.substring(index + 1);
                }
            } else {
                int index;
                int separatorIndex = name.lastIndexOf(File.separatorChar);
                int n = index = separatorIndex > -1 ? name.lastIndexOf(relativePath, separatorIndex) : name.lastIndexOf(relativePath);
                if (index > 0) {
                    name = name.substring(0, index - 1) + ";" + relativePath + ";" + name.substring(index + relativePath.length() + 1);
                }
            }
        }
        super.DebugFile(name);
    }

    @Override
    protected void DebugLine(ByteList code, int lineNumber) {
        int newLineNumber;
        if (!this.source.isDebuggable()) {
            return;
        }
        if (this.lines != null) {
            this.key.fileName = this.currentFileName;
            this.key.lineNumber = lineNumber;
            if (!this.lines.contains(this.key)) {
                this.lines.add(new Line(this.currentFileName, lineNumber));
                this.source.lineCount = this.lines.size();
            }
        }
        if ((newLineNumber = this.calculateLineNumber(lineNumber)) > 0) {
            super.DebugLine(code, newLineNumber);
        }
    }

    private int calculateLineNumber(int lineNumber) {
        if (this.map == null || !this.source.getName().equals(this.currentFileName)) {
            return lineNumber;
        }
        int newLineNumber = this.map.get(lineNumber);
        if (newLineNumber > 0) {
            return newLineNumber;
        }
        return -1;
    }

    private static class Line {
        public String fileName;
        public int lineNumber;

        Line() {
        }

        Line(String fileName, int lineNumber) {
            this.fileName = fileName;
            this.lineNumber = lineNumber;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Line) {
                Line line = (Line)o;
                if (this.fileName != null && line.fileName != null) {
                    return this.fileName.equals(line.fileName) && this.lineNumber == line.lineNumber;
                }
                if (this.fileName != null && line.fileName == null || this.fileName == null && line.fileName != null) {
                    return false;
                }
                return this.lineNumber == line.lineNumber;
            }
            return false;
        }

        public int hashCode() {
            int result = this.fileName != null ? this.fileName.hashCode() ^ this.lineNumber : this.lineNumber;
            return result;
        }
    }
}

