/*
 * Decompiled with CFR 0.152.
 */
package flash.fonts;

import com.adobe.fontengine.FontEngineException;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.InvalidGlyphException;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.Permission;
import com.adobe.fontengine.font.SWFFontDescription;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.fontmanagement.FontLoader;
import flash.fonts.CachedFontFace;
import flash.fonts.CachedFontManager;
import flash.fonts.FSType;
import flash.fonts.FontFace;
import flash.fonts.FontManager;
import flash.fonts.FontSet;
import flash.fonts.JREFontManager;
import flash.swf.builder.types.ShapeBuilder;
import flash.swf.builder.types.ShapeIterator;
import flash.swf.types.GlyphEntry;
import flash.swf.types.Shape;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;

public class AFEFontManager
extends CachedFontManager {
    FontLoader loader = new FontLoader();
    private JREFontManager jreManager;
    private Map initializeMap;

    public static URL processLocation(Object object) {
        if (object != null) {
            if (object instanceof URL) {
                return (URL)object;
            }
            File file = new File(object.toString());
            if (file.exists()) {
                try {
                    return file.toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public void initialize(Map map) {
        super.initialize(map);
        this.initializeMap = map;
    }

    public FontFace getEntryFromSystem(String string, int n, boolean bl) {
        FontManager fontManager = this.parent;
        if (fontManager == null) {
            if (this.jreManager == null) {
                this.jreManager = new JREFontManager();
                this.jreManager.initialize(this.initializeMap);
            }
            fontManager = this.jreManager;
        }
        return fontManager.getEntryFromSystem(string, n, bl);
    }

    protected FontSet createSetForSystemFont(String string, int n, boolean bl) {
        FontManager fontManager = this.parent;
        if (fontManager == null || !(fontManager instanceof CachedFontManager)) {
            if (this.jreManager == null) {
                this.jreManager = new JREFontManager();
            }
            fontManager = this.jreManager;
        }
        return ((CachedFontManager)fontManager).createSetForSystemFont(string, n, bl);
    }

    public FontFace getEntryFromLocation(URL uRL, int n, boolean bl) {
        FontFace fontFace = null;
        String string = uRL != null ? uRL.toExternalForm() : null;
        Object object = this.getFontFileCache().get(string);
        if (object == null) {
            object = this.createFontFromLocation(uRL, n, bl);
        }
        if (object != null) {
            String string2 = object.toString();
            FontSet fontSet = (FontSet)this.getFontCache().get(string2);
            if (fontSet != null) {
                fontFace = fontSet.get(n);
            }
            if (string != null && !string.toLowerCase().endsWith(".ttc") && !string.toLowerCase().endsWith(".dfont")) {
                this.getFontFileCache().put(string, string2);
            }
        } else if (this.parent != null) {
            return this.parent.getEntryFromLocation(uRL, n, bl);
        }
        return fontFace;
    }

    protected String createFontFromLocation(Object object, int n, boolean bl) {
        String string;
        block8: {
            string = null;
            URL uRL = AFEFontManager.processLocation(object);
            if (uRL != null) {
                try {
                    Font[] fontArray = this.loader.load(uRL);
                    if (fontArray == null) break block8;
                    SWFFontDescription sWFFontDescription = null;
                    for (int i = 0; i < fontArray.length; ++i) {
                        boolean bl2;
                        int n2;
                        String string2;
                        Font font = fontArray[i];
                        SWFFontDescription sWFFontDescription2 = font.getSWFFontDescription();
                        int n3 = AFEFontFace.getStyle(sWFFontDescription2);
                        if (n3 == n) {
                            string = this.createAFEFontFace(uRL, n, sWFFontDescription2, bl);
                            break;
                        }
                        if (sWFFontDescription == null && (string2 = sWFFontDescription2.getSubFamily()) != null && (n2 = CachedFontFace.guessStyleFromSubFamilyName(string2)) == n) {
                            sWFFontDescription = sWFFontDescription2;
                        }
                        if (string == null && sWFFontDescription != null) {
                            string = this.createAFEFontFace(uRL, n, sWFFontDescription, bl);
                            break;
                        }
                        boolean bl3 = bl2 = i == fontArray.length - 1;
                        if (!bl2 || string != null || sWFFontDescription != null || this.majorCompatibilityVersion <= 3) continue;
                        sWFFontDescription = fontArray[0].getSWFFontDescription();
                        string = this.createAFEFontFace(uRL, n, sWFFontDescription, bl);
                    }
                }
                catch (AFEFMFontException aFEFMFontException) {
                    throw aFEFMFontException;
                }
                catch (Throwable throwable) {
                    throw new RuntimeException("Unexpected exception encountered while reading font file '" + uRL + "'", throwable);
                }
            }
        }
        return string;
    }

    private String createAFEFontFace(URL uRL, int n, SWFFontDescription sWFFontDescription, boolean bl) {
        AFEFontFace aFEFontFace = AFEFontFace.newInstance(this.maxGlyphsPerFace, sWFFontDescription, uRL, bl);
        aFEFontFace.style = n;
        String string = aFEFontFace.getFamily();
        FontSet fontSet = (FontSet)this.getFontCache().get(string);
        if (fontSet == null) {
            fontSet = new FontSet(this.maxFacesPerFont);
            this.getFontCache().put(string, fontSet);
        }
        fontSet.put(aFEFontFace.style, aFEFontFace);
        return string;
    }

    public static class AFEFMFontException
    extends RuntimeException {
        static final long serialVersionUID = -1L;

        public AFEFMFontException(URL uRL, Exception exception) {
            super("The font " + uRL + " is not usable.", exception);
        }
    }

    public static class BatikFailsException
    extends RuntimeException {
        static final long serialVersionUID = -1L;

        public BatikFailsException(double d) {
            super("Font fails with batik: " + d);
        }
    }

    static class AFE2SWFOutlineAdaptor
    implements OutlineConsumer,
    ShapeIterator {
        private Matrix scale;
        private Matrix initialMatrix;
        private ArrayList segments = new ArrayList();
        private int index = 0;
        private double scaledStartX;
        private double scaledStartY;
        private boolean shapeStarted = false;
        private double x1;
        private double y1;
        private boolean variableQuadApproximation;
        private final boolean throwWhenBatikFails;

        AFE2SWFOutlineAdaptor(char c, SWFFontDescription sWFFontDescription, int n, boolean bl, boolean bl2, boolean bl3) throws UnsupportedFontException, InvalidFontException {
            this.throwWhenBatikFails = bl3;
            this.initialMatrix = new Matrix(n, 0.0, 0.0, -n, 0.0, 0.0);
            this.variableQuadApproximation = bl2;
            sWFFontDescription.getOutline(c, this);
            if (bl) {
                this.segments = AFE2SWFOutlineAdaptor.reversePoints(this.segments);
            }
        }

        private static ArrayList reversePoints(ArrayList arrayList) {
            int n;
            if (arrayList.size() == 0) {
                return arrayList;
            }
            ArrayList<double[]> arrayList2 = new ArrayList<double[]>(arrayList.size());
            ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
            int n2 = 0;
            for (n = 0; n < arrayList.size(); ++n) {
                double[] dArray = (double[])arrayList.get(n);
                double[] dArray2 = new double[dArray.length];
                System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
                if (dArray[0] == 0.0) {
                    arrayList2.add(dArray2);
                    n2 = n + 1;
                    if (n <= 0) continue;
                    arrayList3.add(new Integer(n - 1));
                    continue;
                }
                arrayList2.add(n2, dArray2);
            }
            arrayList3.add(new Integer(n - 1));
            int n3 = 0;
            int n4 = 1;
            n = 0;
            double[] dArray = (double[])arrayList.get(n);
            n2 = 0;
            while (n < arrayList.size() - 1) {
                if (dArray[0] == 0.0) {
                    n2 = (Integer)arrayList3.get(n3);
                    ++n3;
                }
                double[] dArray3 = (double[])arrayList2.get(n2);
                int n5 = dArray3.length - 2;
                while (n5 > 0) {
                    dArray3[n5] = dArray[n4];
                    dArray3[n5 + 1] = dArray[n4 + 1];
                    if (n4 == dArray.length - 2) {
                        if (n < arrayList.size() - 1) {
                            dArray = (double[])arrayList.get(++n);
                        }
                        n4 = -1;
                    }
                    n5 -= 2;
                    n4 += 2;
                }
                --n2;
            }
            return arrayList2;
        }

        private void addSegment(double d, double d2, int n) {
            double[] dArray = new double[]{n, d, d2};
            this.segments.add(dArray);
        }

        private void addQuadratic(double d, double d2, double d3, double d4) {
            double[] dArray = new double[]{2.0, d, d2, d3, d4};
            this.segments.add(dArray);
        }

        private void close() {
            this.addSegment(this.scaledStartX, this.scaledStartY, 1);
            this.shapeStarted = false;
        }

        private void approximateCubicBezierATM(double d, double d2, double d3, double d4, double d5, double d6) {
            double d7 = -this.x1 + 3.0 * d - 3.0 * d3 + d5;
            double d8 = -this.y1 + 3.0 * d2 - 3.0 * d4 + d6;
            double d9 = 3.0 * this.x1 - 6.0 * d + 3.0 * d3;
            double d10 = 3.0 * this.y1 - 6.0 * d2 + 3.0 * d4;
            double d11 = -3.0 * this.x1 + 3.0 * d;
            double d12 = -3.0 * this.y1 + 3.0 * d2;
            double d13 = this.x1;
            double d14 = this.y1;
            double d15 = Math.ceil(Math.max(Math.abs(d7), Math.abs(d8)));
            int n = 0;
            while (d15 > (double)(10 * n * n * n)) {
                ++n;
            }
            double d16 = 1.0 / (double)n;
            double d17 = d11;
            double d18 = d12;
            for (int i = 1; i <= n; ++i) {
                double d19 = (double)i * d16;
                double d20 = ((d7 * d19 + d9) * d19 + d11) * d19 + d13;
                double d21 = ((d8 * d19 + d10) * d19 + d12) * d19 + d14;
                double d22 = (3.0 * d7 * d19 + 2.0 * d9) * d19 + d11;
                double d23 = (3.0 * d8 * d19 + 2.0 * d10) * d19 + d12;
                this.addQuadratic((this.x1 + d20) / 2.0 + (d17 - d22) / (double)(4 * n), (this.y1 + d21) / 2.0 + (d18 - d23) / (double)(4 * n), d20, d21);
                this.x1 = d20;
                this.y1 = d21;
                d17 = d22;
                d18 = d23;
            }
        }

        private void approximateCubicBezierFlex(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
            double d9 = AFE2SWFOutlineAdaptor.getPointOnSegment(d, d3, 0.75);
            double d10 = AFE2SWFOutlineAdaptor.getPointOnSegment(d2, d4, 0.75);
            double d11 = AFE2SWFOutlineAdaptor.getPointOnSegment(d7, d5, 0.75);
            double d12 = AFE2SWFOutlineAdaptor.getPointOnSegment(d8, d6, 0.75);
            double d13 = (d7 - d) / 16.0;
            double d14 = (d8 - d2) / 16.0;
            double d15 = AFE2SWFOutlineAdaptor.getPointOnSegment(d, d3, 0.375);
            double d16 = AFE2SWFOutlineAdaptor.getPointOnSegment(d2, d4, 0.375);
            double d17 = AFE2SWFOutlineAdaptor.getPointOnSegment(d9, d11, 0.375);
            double d18 = AFE2SWFOutlineAdaptor.getPointOnSegment(d10, d12, 0.375);
            d17 -= d13;
            d18 -= d14;
            double d19 = AFE2SWFOutlineAdaptor.getPointOnSegment(d11, d9, 0.375);
            double d20 = AFE2SWFOutlineAdaptor.getPointOnSegment(d12, d10, 0.375);
            d19 += d13;
            d20 += d14;
            double d21 = AFE2SWFOutlineAdaptor.getPointOnSegment(d7, d5, 0.375);
            double d22 = AFE2SWFOutlineAdaptor.getPointOnSegment(d8, d6, 0.375);
            double d23 = (d15 + d17) / 2.0;
            double d24 = (d16 + d18) / 2.0;
            double d25 = (d9 + d11) / 2.0;
            double d26 = (d10 + d12) / 2.0;
            double d27 = (d19 + d21) / 2.0;
            double d28 = (d20 + d22) / 2.0;
            this.addQuadratic(d15, d16, d23, d24);
            this.addQuadratic(d17, d18, d25, d26);
            this.addQuadratic(d19, d20, d27, d28);
            this.addQuadratic(d21, d22, d7, d8);
            this.x1 = d7;
            this.y1 = d8;
        }

        private static double getPointOnSegment(double d, double d2, double d3) {
            return d + (d2 - d) * d3;
        }

        public void curveto(double d, double d2, double d3, double d4, double d5, double d6) {
            if (!this.shapeStarted) {
                this.addSegment(this.scaledStartX, this.scaledStartY, 0);
                this.shapeStarted = true;
            }
            double d7 = this.scale.applyToXYGetX(d, d2);
            double d8 = this.scale.applyToXYGetY(d, d2);
            double d9 = this.scale.applyToXYGetX(d3, d4);
            double d10 = this.scale.applyToXYGetY(d3, d4);
            double d11 = this.scale.applyToXYGetX(d5, d6);
            double d12 = this.scale.applyToXYGetY(d5, d6);
            if (this.variableQuadApproximation) {
                this.approximateCubicBezierATM(d7, d8, d9, d10, d11, d12);
            } else {
                this.approximateCubicBezierFlex(this.x1, this.y1, d7, d8, d9, d10, d11, d12);
            }
        }

        public void curveto(double d, double d2, double d3, double d4) {
            if (!this.shapeStarted) {
                this.addSegment(this.scaledStartX, this.scaledStartY, 0);
                this.shapeStarted = true;
            }
            this.checkRange(d, d2);
            this.checkRange(d3, d4);
            double d5 = this.scale.applyToXYGetX(d, d2);
            double d6 = this.scale.applyToXYGetY(d, d2);
            double d7 = this.scale.applyToXYGetX(d3, d4);
            double d8 = this.scale.applyToXYGetY(d3, d4);
            this.addQuadratic(d5, d6, d7, d8);
        }

        public void endchar() {
        }

        private void checkRange(double d, double d2) {
            if (this.throwWhenBatikFails) {
                if (Math.abs(d) > 32767.0) {
                    throw new BatikFailsException(d);
                }
                if (Math.abs(d2) > 32767.0) {
                    throw new BatikFailsException(d2);
                }
            }
        }

        public void lineto(double d, double d2) {
            if (!this.shapeStarted) {
                this.addSegment(this.scaledStartX, this.scaledStartY, 0);
                this.shapeStarted = true;
            }
            this.checkRange(d, d2);
            double d3 = this.scale.applyToXYGetX(d, d2);
            double d4 = this.scale.applyToXYGetY(d, d2);
            this.addSegment(d3, d4, 1);
            this.x1 = d3;
            this.y1 = d4;
        }

        public void moveto(double d, double d2) {
            if (this.shapeStarted) {
                this.close();
            }
            this.checkRange(d, d2);
            double d3 = this.scale.applyToXYGetX(d, d2);
            double d4 = this.scale.applyToXYGetY(d, d2);
            this.scaledStartX = d3;
            this.scaledStartY = d4;
            this.x1 = d3;
            this.y1 = d4;
        }

        public void setMatrix(Matrix matrix) {
            this.scale = matrix.multiply(this.initialMatrix);
        }

        public short currentSegment(double[] dArray) {
            double[] dArray2 = (double[])this.segments.get(this.index);
            dArray[0] = dArray2[1];
            dArray[1] = dArray2[2];
            switch ((int)dArray2[0]) {
                case 2: {
                    dArray[2] = dArray2[3];
                    dArray[3] = dArray2[4];
                    break;
                }
                case 3: {
                    dArray[2] = dArray2[3];
                    dArray[3] = dArray2[4];
                    dArray[4] = dArray2[5];
                    dArray[5] = dArray2[6];
                }
            }
            return (short)dArray2[0];
        }

        public boolean isDone() {
            return this.index >= this.segments.size();
        }

        public void next() {
            ++this.index;
        }
    }

    public static class AFEFontFace
    extends CachedFontFace {
        private SWFFontDescription fontDescription;
        private URL fontPath;
        private short ascent;
        private short descent;
        private short lineGap;
        private double emScale;

        private AFEFontFace(short s, SWFFontDescription sWFFontDescription, URL uRL, boolean bl, String string, String string2) throws InvalidFontException, UnsupportedFontException {
            super(s, 0, AFEFontFace.toFSType(sWFFontDescription.getPermissions()), string2, string, bl);
            this.init(uRL, sWFFontDescription);
        }

        public static AFEFontFace newInstance(short s, SWFFontDescription sWFFontDescription, URL uRL, boolean bl) {
            try {
                String string;
                String string2 = sWFFontDescription.getTrademark();
                if (string2 == null) {
                    string2 = new String();
                }
                if ((string = sWFFontDescription.getCopyright()) == null) {
                    string = new String();
                }
                return new AFEFontFace(s, sWFFontDescription, uRL, bl, string2, string);
            }
            catch (FontEngineException fontEngineException) {
                throw new AFEFMFontException(uRL, fontEngineException);
            }
        }

        private static int getStyle(SWFFontDescription sWFFontDescription) throws InvalidFontException, UnsupportedFontException {
            int n = 0;
            if (sWFFontDescription.isBold()) {
                ++n;
            }
            if (sWFFontDescription.isItalic()) {
                n += 2;
            }
            return n;
        }

        private static FSType toFSType(Permission permission) {
            if (permission == Permission.EDITABLE) {
                return new FSType(0, "Editable embedding", false, true, false, false);
            }
            if (permission == Permission.INSTALLABLE) {
                return new FSType(0, "Installable embedding", true, false, false, false);
            }
            if (permission == Permission.PREVIEW_AND_PRINT) {
                return new FSType(0, "Preview and Print embedding", false, false, true, false);
            }
            return new FSType(0, "No embedding allowed", false, false, false, true);
        }

        private void init(URL uRL, SWFFontDescription sWFFontDescription) throws InvalidFontException, UnsupportedFontException {
            this.fontPath = uRL;
            this.fontDescription = sWFFontDescription;
            this.style = AFEFontFace.getStyle(sWFFontDescription);
            this.getScaledMetrics();
        }

        private void getScaledMetrics() throws InvalidFontException, UnsupportedFontException {
            this.emScale = 1024.0 / this.fontDescription.getEmScale();
            this.ascent = (short)Math.rint(this.fontDescription.getAscent() * this.emScale * (double)(this.useTwips ? 20 : 1));
            this.descent = (short)Math.rint(this.fontDescription.getDescent() * this.emScale * (double)(this.useTwips ? 20 : 1));
            this.lineGap = (short)Math.rint(this.fontDescription.getLineGap() * this.emScale * (double)(this.useTwips ? 20 : 1));
        }

        public boolean canDisplay(char c) {
            try {
                return this.fontDescription.canDisplay(c);
            }
            catch (FontEngineException fontEngineException) {
                throw new AFEFMFontException(this.fontPath, fontEngineException);
            }
        }

        public GlyphEntry getGlyphEntry(char c) {
            return (GlyphEntry)this.glyphCache.get(c);
        }

        protected GlyphEntry createGlyphEntry(char c) {
            return this.createGlyphEntry(c, c);
        }

        public GlyphEntry createGlyphEntry(char c, char c2) {
            try {
                return this.createGlyphEntry(c, c2, false, true, false);
            }
            catch (InvalidGlyphException invalidGlyphException) {
                throw new AFEFMFontException(this.fontPath, invalidGlyphException);
            }
        }

        public GlyphEntry createGlyphEntry(char c, char c2, boolean bl, boolean bl2, boolean bl3) throws InvalidGlyphException {
            try {
                AFE2SWFOutlineAdaptor aFE2SWFOutlineAdaptor = new AFE2SWFOutlineAdaptor(c2, this.fontDescription, 1024, bl, bl2, bl3);
                Shape shape = this.getShapeFromGlyph(aFE2SWFOutlineAdaptor);
                GlyphEntry glyphEntry = new GlyphEntry();
                glyphEntry.advance = (int)((double)this.getAdvance(c2) * this.emScale * (double)(this.useTwips ? 20 : 1));
                glyphEntry.character = c;
                glyphEntry.shape = shape;
                glyphEntry.bounds = null;
                return glyphEntry;
            }
            catch (InvalidGlyphException invalidGlyphException) {
                throw invalidGlyphException;
            }
            catch (FontEngineException fontEngineException) {
                throw new AFEFMFontException(this.fontPath, fontEngineException);
            }
        }

        private Shape getShapeFromGlyph(AFE2SWFOutlineAdaptor aFE2SWFOutlineAdaptor) {
            ShapeBuilder shapeBuilder = new ShapeBuilder(this.useTwips);
            shapeBuilder.setCurrentLineStyle(0);
            shapeBuilder.setCurrentFillStyle1(1);
            shapeBuilder.setUseFillStyle1(true);
            shapeBuilder.processShape(aFE2SWFOutlineAdaptor);
            return shapeBuilder.build();
        }

        public int getFirstChar() {
            try {
                return this.fontDescription.getFirstChar();
            }
            catch (FontEngineException fontEngineException) {
                throw new AFEFMFontException(this.fontPath, fontEngineException);
            }
        }

        public int getAscent() {
            return this.ascent;
        }

        public int getDescent() {
            return this.descent;
        }

        public String getFamily() {
            try {
                return this.fontDescription.getFamily();
            }
            catch (FontEngineException fontEngineException) {
                throw new AFEFMFontException(this.fontPath, fontEngineException);
            }
        }

        public int getLineGap() {
            return this.lineGap;
        }

        public int getNumGlyphs() {
            try {
                return this.fontDescription.getNumGlyphs();
            }
            catch (FontEngineException fontEngineException) {
                throw new AFEFMFontException(this.fontPath, fontEngineException);
            }
        }

        public double getEmScale() {
            return this.emScale;
        }

        public String getPostscriptName() {
            try {
                String string = this.fontDescription.getPostscriptName();
                if (string == null) {
                    string = new String();
                }
                return string;
            }
            catch (FontEngineException fontEngineException) {
                throw new AFEFMFontException(this.fontPath, fontEngineException);
            }
        }

        public int getAdvance(char c) {
            try {
                return (int)Math.rint(this.fontDescription.getHorizontalAdvance(c));
            }
            catch (FontEngineException fontEngineException) {
                throw new AFEFMFontException(this.fontPath, fontEngineException);
            }
        }

        public int getMissingGlyphCode() {
            return 0;
        }

        public double getPointSize() {
            return 1.0;
        }

        public SWFFontDescription getDescription() {
            return this.fontDescription;
        }
    }
}

