/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.swc.zip;

import java.io.IOException;

public class RandomAccessMemoryFile {
    private byte[] buffer;
    private int bufferPtr;

    public RandomAccessMemoryFile(byte[] byArray) {
        this.buffer = byArray;
        this.bufferPtr = 0;
    }

    public void close() throws IOException {
        this.buffer = null;
        this.bufferPtr = 0;
    }

    public void readFully(byte[] byArray) throws IOException {
        try {
            System.arraycopy(this.buffer, this.bufferPtr, byArray, 0, byArray.length);
            this.bufferPtr += byArray.length;
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            throw new IOException("NullPointerException");
        }
        catch (ArrayStoreException arrayStoreException) {
            arrayStoreException.printStackTrace();
            throw new IOException("ArrayStoreException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace();
            throw new IOException("IndexOutOfBoundsException");
        }
    }

    public int skipBytes(int n) throws IOException {
        try {
            if (n < 0) {
                return 0;
            }
            if (this.bufferPtr + n >= this.buffer.length) {
                int n2 = this.buffer.length - this.bufferPtr - 1;
                this.bufferPtr = this.buffer.length - 1;
                return n2;
            }
            this.bufferPtr += n;
            return n;
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            throw new IOException("NullPointerException");
        }
        catch (ArithmeticException arithmeticException) {
            arithmeticException.printStackTrace();
            throw new IOException("ArithmeticException");
        }
    }

    public long length() throws IOException {
        try {
            return this.buffer.length;
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            throw new IOException("NullPointerException");
        }
    }

    public int read() throws IOException {
        try {
            int n = 0xFF & this.buffer[this.bufferPtr++];
            return n;
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            throw new IOException("NullPointerException");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
            throw new IOException("ArrayIndexOutOfBoundsException");
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        try {
            System.arraycopy(this.buffer, this.bufferPtr, byArray, n, n2);
            this.bufferPtr += n2;
            return n2;
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            throw new IOException("NullPointerException");
        }
        catch (ArrayStoreException arrayStoreException) {
            arrayStoreException.printStackTrace();
            throw new IOException("ArrayStoreException");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
            throw new IOException("ArrayIndexOutOfBoundsException");
        }
    }

    public void seek(long l) throws IOException {
        try {
            this.bufferPtr = (int)l;
        }
        catch (ArithmeticException arithmeticException) {
            arithmeticException.printStackTrace();
            throw new IOException("ArithmeticException");
        }
    }
}

