/*
 * Decompiled with CFR 0.152.
 */
package adobe.asc.authoring;

import adobe.abc.authoring.ABCEvaluator;
import adobe.abc.authoring.ClassInfo;
import adobe.abc.authoring.MetadataAttributeInfo;
import adobe.abc.authoring.MetadataInfo;
import adobe.abc.authoring.Optimizer;
import adobe.asc.authoring.AuthCompilerHandler;
import adobe.asc.authoring.AuthCompilerPlug;
import adobe.asc.authoring.AuthIncludeInfo;
import adobe.asc.authoring.AuthLogger;
import adobe.asc.authoring.GlobalDependencies;
import adobe.asc.authoring.MainCompilerPlug;
import adobe.asc.authoring.MovieClipMaker;
import adobe.asc.authoring.PlugDependencyGraph;
import adobe.asc.authoring.UIActionsEvaluator;
import adobe.asc.authoring.Util;
import adobe.asc.authoring.actions.UIAction;
import adobe.asc.authoring.actions.UIActionComment;
import adobe.asc.authoring.actions.UIActionList;
import adobe.asc.authoring.flexInfo.FlexInfo;
import adobe.asc.authoring.rsl.RSLClassInfo;
import adobe.asc.authoring.rsl.RSLInfo;
import adobe.asc.authoring.rsl.RSLURLInfo;
import adobe.swf.authoring.AuthMovieEncoder;
import adobe.swf.authoring.AuthTagEncoder;
import flash.localization.ILocalizer;
import flash.localization.LocalizationManager;
import flash.localization.ResourceBundleLocalizer;
import flash.localization.XLRLocalizer;
import flash.swf.Tag;
import flash.swf.tags.DefineTag;
import flash.swf.tags.DoABC;
import flash.swf.tools.as3.EvaluatorAdapter;
import flash.util.FileUtils;
import flex2.compiler.AssetInfo;
import flex2.compiler.CompilationUnit;
import flex2.compiler.CompilerAPI;
import flex2.compiler.CompilerContext;
import flex2.compiler.Source;
import flex2.compiler.SourcePath;
import flex2.compiler.SymbolTable;
import flex2.compiler.abc.AbcClass;
import flex2.compiler.abc.MetaData;
import flex2.compiler.as3.EmbedExtension;
import flex2.compiler.as3.Extension;
import flex2.compiler.as3.StyleExtension;
import flex2.compiler.as3.SyntaxTreeEvaluator;
import flex2.compiler.as3.reflect.TypeTable;
import flex2.compiler.common.Configuration;
import flex2.compiler.common.ConfigurationPathResolver;
import flex2.compiler.config.ConfigurationBuffer;
import flex2.compiler.config.FileConfigurator;
import flex2.compiler.io.InMemoryFile;
import flex2.compiler.io.LocalFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.AuthSwc;
import flex2.compiler.swc.AuthSwcCache;
import flex2.compiler.swc.AuthSwcComponent;
import flex2.compiler.swc.AuthSwcDynamicArchive;
import flex2.compiler.swc.AuthSwcLibrary;
import flex2.compiler.swc.AuthSwcScript;
import flex2.compiler.swc.SwcComponent;
import flex2.compiler.swc.SwcDependencySet;
import flex2.compiler.swc.SwcGroup;
import flex2.compiler.swc.SwcScript;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.ConsoleLogger;
import flex2.compiler.util.MultiName;
import flex2.compiler.util.Name;
import flex2.compiler.util.QName;
import flex2.compiler.util.QNameList;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.tools.CommandLineConfiguration;
import flex2.tools.PreLink;
import flex2.tools.WebTierAPI;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.abc.AbcParser;
import macromedia.asc.embedding.CompilerHandler;
import macromedia.asc.embedding.ConfigVar;
import macromedia.asc.embedding.LintEvaluator;
import macromedia.asc.embedding.avmplus.ActionBlockEmitter;
import macromedia.asc.embedding.avmplus.ClassBuilder;
import macromedia.asc.embedding.avmplus.GlobalBuilder;
import macromedia.asc.parser.AttributeListNode;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.CommentNode;
import macromedia.asc.parser.ConfigNamespaceDefinitionNode;
import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.MetaDataEvaluator;
import macromedia.asc.parser.NamespaceDefinitionNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.PackageDefinitionNode;
import macromedia.asc.parser.Parser;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.parser.VariableBindingNode;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.semantics.Builder;
import macromedia.asc.semantics.CodeGenerator;
import macromedia.asc.semantics.ConfigurationEvaluator;
import macromedia.asc.semantics.ConstantEvaluator;
import macromedia.asc.semantics.Emitter;
import macromedia.asc.semantics.FlowAnalyzer;
import macromedia.asc.semantics.FlowGraphEmitter;
import macromedia.asc.semantics.NamespaceValue;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.util.Boxing;
import macromedia.asc.util.ByteList;
import macromedia.asc.util.Context;
import macromedia.asc.util.ContextStatics;
import macromedia.asc.util.Names;
import macromedia.asc.util.Namespaces;
import macromedia.asc.util.ObjectList;
import macromedia.asc.util.StringPrintWriter;
import macromedia.asc.util.graph.Algorithms;
import macromedia.asc.util.graph.Graph;
import macromedia.asc.util.graph.Vertex;
import macromedia.asc.util.graph.Visitor;

/*
 * This class specifies class file version 47.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthBatchCompiler {
    private static int plugProcessingStart;
    private static int plugProcessingEnd;
    private static ContextStatics contextStatics;
    private static MainCompilerPlug mainplug;
    private static ObjectList<AuthCompilerPlug> plugs;
    private static GlobalDependencies processedDependencies;
    private static GlobalDependencies unprocessedDependencies;
    private static Set<GlobalDependencies.Pair> INHERITANCE_processedDependCache;
    private static Set<GlobalDependencies.Pair> INHERITANCE_unprocessedDependCache;
    private static Set<GlobalDependencies.Pair> EXPRESSION_processedDependCache;
    private static Set<GlobalDependencies.Pair> EXPRESSION_unprocessedDependCache;
    private static Set<GlobalDependencies.Pair> SIGNATURE_processedDependCache;
    private static Set<GlobalDependencies.Pair> SIGNATURE_unprocessedDependCache;
    private static Set<GlobalDependencies.Pair> NAMESPACE_processedDependCache;
    private static Set<GlobalDependencies.Pair> NAMESPACE_unprocessedDependCache;
    private static PlugDependencyGraph inheritanceGraph;
    private static PlugDependencyGraph dependencyGraph;
    private static AuthSwc swcForExport;
    private static long swcLastModified;
    private static AuthSwcCache swcCache;
    private static SwcGroup hashSwcGroup;
    private static SwcGroup libPathSwcGroup;
    private static SwcGroup extLibPathSwcGroup;
    private static SwcGroup playerGlobalSwcGroup;
    private static Set<String> swcPackageNames;
    private static boolean showedSwcDefNotFoundError;
    private static ArrayList<ABCToParse> abcToParse;
    private static ArrayList<DoABC> doABCsToOptimize;
    private static ArrayList<DoABC> doABCsToOptimizeLoaderFrame;
    private static ArrayList<DoABC> doABCsToOptimizeRSLLoader;
    private static ArrayList<Extension> compilerExtensions;
    private static SourcePath sourcePath;
    private static SymbolTable symbolTable;
    private static TypeTable typeTable;
    private static AuthMovieEncoder authMovieEncoder;
    private static AuthTagEncoder authTagEncoder;
    private static Map<String, SwfTagBlockInfo> swfTagMap;
    private static List<SwfTagBlockInfo> swfTagList;
    private static Map<String, AuthCompilerPlug> findDefinitionCache;
    private static Map<String, AuthCompilerPlug> hasPackageCache;
    private static Set<String> mxPackageClassesNotFound;
    private static CommandLineConfiguration flexConfiguration;
    private static Set<String> flaLibraryLinkageClasses;
    private static boolean rslPreloadingRequired;
    private static boolean generatingRSLPreloaderPlugs;
    private static Map<String, RSLInfo> extLibPathSwcsUsed;
    private static Map<String, List<RSLClassInfo>> rslClassMap;
    private static AuthCompilerPlug contentSWFPlug;
    private static Set<String> missingLibrariesClasses;
    private static Boolean sCheckedForSWCCaching;
    private static Boolean sEnableSWCCaching;
    private static final String byteArraySubclassFormat = "package %s {\n\timport flash.utils.ByteArray;\n\tpublic class %s extends ByteArray {\n\t}\n}\n";
    private static final String addRSLInfoEntryFormat = "\t\t\tsi.addEntry(\"%s\", \"%s\");\n";
    private static final String addSWZInfoFormat = "\t\t\tsi = new SWZInfo(\"%s\");\n%s\t\t\t__rslPreloader.addRSLInfo(si);\n";
    private static final String addRSLInfoFormat = "\t\t\tsi = new RSLInfo();\n%s\t\t\t__rslPreloader.addRSLInfo(si);\n";
    private static final String wrappingSWFPreloaderFormat = "package %s {\n\timport flash.display.MovieClip;\n\timport fl.rsl.RSLPreloader;\n\timport fl.rsl.RSLInfo;\n\timport fl.rsl.SWZInfo;\n\tpublic class %s extends MovieClip {\n\t\tpublic var __rslPreloader:RSLPreloader;\n\t\tpublic function %s():void\n\t\t{\n\t\t    super()\n\t\t\taddFrameScript(0, frame1, 1, frame2);\n\t\t}\n\t\tpublic function frame1():void\n\t\t{\n\t\t\tstop();\n\t\t\t__rslPreloader = new RSLPreloader(this);\n\t\t\tvar si:RSLInfo;\n%s\t\t\t__rslPreloader.start(%s, \"%s\");\n\t\t}\n\t\tpublic function frame2():void\n\t\t{\n\t\t\tstop();\n\t\t\t__rslPreloader.loadContent();\n\t\t}\n\t}\n}\n";
    private static final String inClassSWFPreloaderFormat = "import fl.rsl.RSLPreloader;\nimport flash.events.Event;\nvar __rslPreloader:RSLPreloader;\n__rslPreloader = new RSLPreloader();\n__initRSLPreloader();\nfunction __initRSLPreloader() {\n\timport fl.rsl.RSLInfo;\n\timport fl.rsl.SWZInfo;\n\timport fl.events.RSLEvent;\n\timport fl.events.RSLErrorEvent;\n\tvar si:RSLInfo;\n%s\ttry {\n\t\tif (this.hasOwnProperty(\"setRSLPreloader\")) {\n\t\t\tvar fn:Function = this[\"setRSLPreloader\"] as Function;\n\t\t\tif (fn != null) {\n\t\t\t\tfn(__rslPreloader);\n\t\t\t}\n\t\t}\n\t} catch (e:Error) {\n\t}\n\t__rslPreloader.addEventListener(RSLEvent.RSL_LOAD_COMPLETE, __handleRSLEvent);\n\t__rslPreloader.addEventListener(RSLEvent.RSL_PROGRESS, __handleRSLEvent);\n\t__rslPreloader.addEventListener(RSLErrorEvent.RSL_LOAD_FAILED, __handleRSLEvent);\n\t__rslPreloader.start();\n}\nfunction __handleRSLEvent(e:Event) {\n\tdispatchEvent(e);\n}\n";
    private static File flashConfigDir;

    protected static ContextStatics getStatics() {
        return contextStatics;
    }

    private static boolean parseSimple(int n, int n2) throws Throwable {
        for (int i = n; i < n2; ++i) {
            AuthCompilerPlug authCompilerPlug = (AuthCompilerPlug)plugs.get(i);
            if (authCompilerPlug.isSwcPlug || (AuthBatchCompiler.mainplug.flags & 0x18) == 0) continue;
            authCompilerPlug.context.setEmitter((Emitter)authCompilerPlug.emitter);
            authCompilerPlug.context.setHandler((CompilerHandler)authCompilerPlug.handler);
            authCompilerPlug.context.setPath(authCompilerPlug.pathspec);
            if ((AuthBatchCompiler.mainplug.flags & 0x10) != 0) {
                authCompilerPlug.context.scriptAssistParsing = true;
            }
            if ((AuthBatchCompiler.mainplug.flags & 0x800) != 0) {
                authCompilerPlug.context.spaceOperators = true;
            }
            Parser parser = new Parser(authCompilerPlug.context, authCompilerPlug.in, authCompilerPlug.filename, authCompilerPlug.file_encoding, false, true);
            ProgramNode programNode = parser.parseProgram();
            if (authCompilerPlug.context.errorCount() == 0) {
                if ((AuthBatchCompiler.mainplug.flags & 0x10) == 0) continue;
                String string = AuthBatchCompiler.uiactionEvaluate(authCompilerPlug.context, programNode);
                ByteList byteList = new ByteList();
                byteList.addAll(string.getBytes("UTF-8"));
                authCompilerPlug.handler.writeBytes("", byteList, false, false);
                continue;
            }
            return false;
        }
        return true;
    }

    public static void doParse(MainCompilerPlug mainCompilerPlug, ObjectList<AuthCompilerPlug> objectList) throws Throwable {
        long l = System.currentTimeMillis();
        boolean bl = true;
        mainplug = mainCompilerPlug;
        plugs = objectList;
        AuthBatchCompiler.init();
        plugProcessingStart = 0;
        plugProcessingEnd = plugs.size();
        while (plugProcessingStart < plugProcessingEnd) {
            if (AuthBatchCompiler.parseSimple(plugProcessingStart, plugProcessingEnd)) {
                plugProcessingStart = plugProcessingEnd;
                if (plugProcessingStart >= (plugProcessingEnd = plugs.size())) continue;
                continue;
            }
            bl = false;
            break;
        }
        AuthBatchCompiler.clear();
        if (flashConfigDir != null) {
            System.err.println(new StringBuffer().append("Plugs: ").append(plugs.size()).append(" Time: ").append(System.currentTimeMillis() - l).append("ms").toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doCompile(MainCompilerPlug mainCompilerPlug, ObjectList<AuthCompilerPlug> objectList) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            if (!sCheckedForSWCCaching.booleanValue()) {
                sEnableSWCCaching = Boolean.getBoolean("ASC_enableSwcCache");
                if (sEnableSWCCaching.booleanValue()) {
                    System.out.println("SWC caching enabled");
                }
                sCheckedForSWCCaching = true;
            }
            mainplug = mainCompilerPlug;
            plugs = objectList;
            AuthBatchCompiler.init();
            AuthBatchCompiler.addCompilerExtensions();
            plugProcessingStart = 0;
            plugProcessingEnd = plugs.size();
            boolean bl = false;
            while (plugProcessingStart < plugProcessingEnd) {
                AuthBatchCompiler.parse(plugProcessingStart, plugProcessingEnd);
                AuthBatchCompiler.fa_part1(plugProcessingStart, plugProcessingEnd);
                AuthBatchCompiler.resolveInheritance(plugProcessingStart, plugProcessingEnd);
                AuthBatchCompiler.addGeneratedSources(plugProcessingStart, plugProcessingEnd);
                plugProcessingStart = plugProcessingEnd;
                plugProcessingEnd = plugs.size();
                if (plugProcessingStart < plugProcessingEnd) continue;
                AuthBatchCompiler.sortInheritance();
                AuthBatchCompiler.fa_part2();
                AuthBatchCompiler.resolveType();
                if ((AuthBatchCompiler.mainplug.flags & 2) != 0) {
                    AuthBatchCompiler.resolveImportStatements();
                }
                AuthBatchCompiler.resolveExpression();
                AuthBatchCompiler.addGeneratedSources(plugProcessingStart, plugProcessingEnd);
                plugProcessingStart = plugProcessingEnd;
                plugProcessingEnd = plugs.size();
                if (plugProcessingStart < plugProcessingEnd) continue;
                AuthBatchCompiler.inheritSlots("s");
                AuthBatchCompiler.inheritSlots("n");
                AuthBatchCompiler.inheritSlots("e");
                AuthBatchCompiler.ce_part1();
                AuthBatchCompiler.ce_part2();
                AuthBatchCompiler.addGeneratedSources(plugProcessingStart, plugProcessingEnd);
                plugProcessingStart = plugProcessingEnd;
                plugProcessingEnd = plugs.size();
                if (plugProcessingStart >= plugProcessingEnd && AuthBatchCompiler.contextStatics.errCount == 0 && rslPreloadingRequired && !generatingRSLPreloaderPlugs && (AuthBatchCompiler.mainplug.flags & 0x4000) == 0) {
                    AuthBatchCompiler.generateRSLPreloaderPlugs();
                    plugProcessingEnd = plugs.size();
                }
                if (plugProcessingStart < plugProcessingEnd || bl || swcForExport == null) continue;
                AuthBatchCompiler.postGenerateExtraSwcCode();
                bl = true;
                plugProcessingEnd = plugs.size();
            }
            if ((AuthBatchCompiler.mainplug.flags & 4) != 0) {
                AuthBatchCompiler.resolvePlayerglobal();
                AuthBatchCompiler.lintEvaluate();
            }
            AuthBatchCompiler.markLoaderFramePlugs();
            AuthBatchCompiler.codeGenerate();
            AuthBatchCompiler.checkBaseClasses();
            if (!missingLibrariesClasses.isEmpty()) {
                AuthBatchCompiler.generateMissingLibrariesWarningMessages();
            }
            if (!mxPackageClassesNotFound.isEmpty()) {
                ABCEvaluator.generateFlexSDKWarningMessages(mainplug, mxPackageClassesNotFound);
            }
            if (abcToParse != null) {
                ABCEvaluator.resetGlobals();
                for (ABCToParse aBCToParse : abcToParse) {
                    ProgramNode programNode;
                    Context context = aBCToParse.context;
                    if (aBCToParse.bytes != null) {
                        byte[] byArray = aBCToParse.bytes.toByteArray(false);
                        programNode = new AbcParser(context, byArray).parseAbc(true, true);
                    } else {
                        programNode = aBCToParse.pnode;
                    }
                    programNode.evaluate(context, (Evaluator)new ABCEvaluator(aBCToParse.isSwc));
                }
            }
            if ((AuthBatchCompiler.mainplug.flags & 0x100) != 0) {
                AuthBatchCompiler.writeOptimizedABC();
            }
        }
        catch (CircularInheritanceException circularInheritanceException) {
        }
        finally {
            AuthBatchCompiler.clear();
            if (flashConfigDir != null) {
                System.err.println(new StringBuffer().append("Plugs: ").append(plugs.size()).append(" Time: ").append(System.currentTimeMillis() - l).append("ms").toString());
            }
        }
        return AuthBatchCompiler.contextStatics.errCount == 0 && (generatingRSLPreloaderPlugs && (AuthBatchCompiler.mainplug.flags & 0x2000) != 0 || rslPreloadingRequired && (AuthBatchCompiler.mainplug.flags & 0x4000) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getInfoForClass(MainCompilerPlug mainCompilerPlug, String string) throws Throwable {
        String string2;
        try {
            Object object;
            String string3 = null;
            string2 = null;
            boolean bl = false;
            FlexInfo flexInfo = FlexInfo.getSingleton(mainCompilerPlug.flexInfoXMLPath);
            string3 = AuthBatchCompiler.getFlexOrSymbolMatchForName(string, flexInfo);
            if (string3 != null && !string3.equals("flex")) {
                string2 = mainCompilerPlug.playerGlobalSwcPath;
                bl = true;
            } else {
                mainplug = mainCompilerPlug;
                plugs = new ObjectList();
                AuthBatchCompiler.init();
                AuthBatchCompiler.contextStatics.handler = new ParseConfigVarHandler(AuthBatchCompiler.mainplug.handlerKey, null);
                object = AuthBatchCompiler.findClass(Util.dotClassnameToColonClassname(string), null);
                if (object == null) {
                    String string4 = "";
                    return string4;
                }
                ((AuthCompilerPlug)object).handler = new ParseConfigVarHandler(((AuthCompilerPlug)object).handlerKey, (AuthCompilerPlug)object);
                ((AuthCompilerPlug)object).context.handler = ((AuthCompilerPlug)object).handler;
                string2 = ((AuthCompilerPlug)object).filename;
                bl = ((AuthCompilerPlug)object).isSwcPlug;
                if (bl) {
                    try {
                        string2 = ((AuthSwcLibrary)((AuthCompilerPlug)object).swcScript.getLibrary()).getArchivePath();
                    }
                    catch (ClassCastException classCastException) {
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
                if (string3 == null) {
                    plugProcessingStart = 0;
                    plugProcessingEnd = plugs.size();
                    while (plugProcessingStart < plugProcessingEnd) {
                        for (int i = plugProcessingStart; i < plugProcessingEnd; ++i) {
                            AuthCompilerPlug authCompilerPlug = (AuthCompilerPlug)plugs.get(i);
                            authCompilerPlug.handler = new ParseConfigVarHandler(authCompilerPlug.handlerKey, authCompilerPlug);
                            if (authCompilerPlug.base_classname == null || authCompilerPlug.base_classname.length() <= 0) continue;
                            authCompilerPlug.noParse = true;
                            String string5 = Util.dotClassnameToColonClassname(authCompilerPlug.base_classname);
                            AuthCompilerPlug authCompilerPlug2 = AuthBatchCompiler.findClass(string5, null);
                            if (authCompilerPlug2 == null) continue;
                            try {
                                AuthBatchCompiler.addDependency(authCompilerPlug, authCompilerPlug2, "i", string5, INHERITANCE_processedDependCache, INHERITANCE_unprocessedDependCache);
                                continue;
                            }
                            catch (NullPointerException nullPointerException) {
                                // empty catch block
                            }
                        }
                        AuthBatchCompiler.parse(plugProcessingStart, plugProcessingEnd);
                        AuthBatchCompiler.fa_part1(plugProcessingStart, plugProcessingEnd);
                        AuthBatchCompiler.resolveInheritance(plugProcessingStart, plugProcessingEnd);
                        plugProcessingStart = plugProcessingEnd;
                        plugProcessingEnd = plugs.size();
                    }
                    AuthBatchCompiler.sortInheritance();
                    Vertex<AuthCompilerPlug> vertex = inheritanceGraph.addVertexForPlug((AuthCompilerPlug)object);
                    string3 = AuthBatchCompiler.checkInheritanceForFlexOrSymbolBaseMatch(vertex, flexInfo);
                    if (string3 == null) {
                        string3 = "object";
                    }
                }
            }
            object = new StringBuffer().append("<class-info-list><class-info classname=\"").append(string).append("\" filename=\"").append(string2).append("\" type=\"").append(string3).append("\" swcDefinition=\"").append(bl).append("\"/></class-info-list>").toString();
            return object;
        }
        catch (CircularInheritanceException circularInheritanceException) {
            string2 = "";
            return string2;
        }
        finally {
            AuthBatchCompiler.cleanup();
        }
    }

    private static String checkInheritanceForFlexOrSymbolBaseMatch(Vertex<AuthCompilerPlug> vertex2, FlexInfo flexInfo) {
        Set set = vertex2.getPredecessors();
        if (set != null) {
            for (Vertex vertex2 : set) {
                String string = AuthBatchCompiler.getFlexOrSymbolMatchForName(((AuthCompilerPlug)vertex2.getWeight()).classname, flexInfo);
                if (string == null) {
                    string = AuthBatchCompiler.checkInheritanceForFlexOrSymbolBaseMatch((Vertex<AuthCompilerPlug>)vertex2, flexInfo);
                }
                if (string == null) continue;
                return string;
            }
        }
        return null;
    }

    private static String getFlexOrSymbolMatchForName(String string, FlexInfo flexInfo) {
        if (flexInfo.isFlexComponentBaseClass(string)) {
            return "flex";
        }
        if (string.equals("flash.display.MovieClip") || string.equals("flash.display.Sprite") || string.equals("flash.text.Font") || string.equals("flash.display.SimpleButton") || string.equals("flash.display.BitmapData") || string.equals("flash.media.Sound")) {
            return string;
        }
        return null;
    }

    private static void addCompilerExtensions() {
        String string = null;
        if (flexConfiguration != null && flexConfiguration.getCompilerConfiguration().keepGeneratedActionScript()) {
            File file = new File(AuthBatchCompiler.mainplug.pathspec, "generated");
            if (file.exists()) {
                string = file.getPath();
            } else if (file.mkdir()) {
                string = file.getPath();
            }
        }
        compilerExtensions.add(new EmbedExtension(WebTierAPI.getTranscoders(flexConfiguration), string, true));
        compilerExtensions.add(new StyleExtension());
    }

    private static AuthCompilerPlug addRSLPreloaderPlug(String string, String string2, String string3) throws Throwable {
        AuthCompilerPlug authCompilerPlug = new AuthCompilerPlug();
        authCompilerPlug.script = string;
        authCompilerPlug.scriptname = authCompilerPlug.classname = string3;
        authCompilerPlug.pathspec = authCompilerPlug.filename = AuthBatchCompiler.mainplug.pathspec;
        authCompilerPlug.rslPreloaderPlug = (AuthBatchCompiler.mainplug.flags & 0x2000) != 0;
        authCompilerPlug.setHandlerKey(string3);
        plugs.add((Object)authCompilerPlug);
        AuthBatchCompiler.initPlug(authCompilerPlug);
        return authCompilerPlug;
    }

    private static String formatRSLAddEntries(StringBuffer stringBuffer) {
        Formatter formatter = new Formatter(new StringBuffer());
        for (RSLInfo rSLInfo : extLibPathSwcsUsed.values()) {
            if (rSLInfo == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(";;");
            }
            stringBuffer.append(rSLInfo.origSWCFilePath);
            Formatter formatter2 = new Formatter(new StringBuffer());
            for (int i = 0; i < rSLInfo.urls.length; ++i) {
                RSLURLInfo rSLURLInfo = rSLInfo.urls[i];
                String string = rSLURLInfo.rslURL.replace("\"", "\\\"").replaceAll("[\n\r]", "");
                String string2 = rSLURLInfo.policyFileURL.replace("\"", "\\\"").replaceAll("[\n\r]", "");
                formatter2.format(addRSLInfoEntryFormat, string, string2);
                while (string.indexOf("./") == 0 || string.indexOf(".\\") == 0) {
                    string = string.substring(2);
                }
                if (string.contains("/") || string.contains("\\")) continue;
                stringBuffer.append(';');
                stringBuffer.append(string);
            }
            if (rSLInfo.digest.length() > 0) {
                formatter.format(addSWZInfoFormat, rSLInfo.digest.replace("\"", "\\\"").replaceAll("[\n\r]", ""), formatter2.toString());
                continue;
            }
            formatter.format(addRSLInfoFormat, formatter2.toString());
        }
        return formatter.toString();
    }

    private static void generateRSLPreloaderPlugs() throws Throwable {
        String string;
        String string2;
        boolean bl;
        generatingRSLPreloaderPlugs = true;
        int n = plugs.indexOf((Object)AuthBatchCompiler.mainplug.docClassPlug);
        boolean bl2 = n >= 0;
        int n2 = AuthBatchCompiler.mainplug.docClassPlug.classname.lastIndexOf(46);
        if (n2 == -1) {
            bl = false;
            string2 = "";
            string = AuthBatchCompiler.mainplug.docClassPlug.classname;
        } else {
            bl = true;
            string2 = AuthBatchCompiler.mainplug.docClassPlug.classname.substring(0, n2);
            string = AuthBatchCompiler.mainplug.docClassPlug.classname.substring(n2 + 1);
            if (Character.isDigit(string2.charAt(0))) {
                string2 = new StringBuffer().append("_").append(string2).toString();
            }
            if (Character.isDigit(string.charAt(0))) {
                string = new StringBuffer().append("_").append(string).toString();
            }
        }
        if ((AuthBatchCompiler.mainplug.flags & 0x2000) != 0) {
            String string3 = new StringBuffer().append(string).append("__LoadingAnimation__").toString();
            String string4 = bl ? new StringBuffer().append(string2).append(".").append(string3).toString() : string3;
            Formatter formatter = new Formatter(new StringBuffer());
            formatter.format(byteArraySubclassFormat, string2, string3);
            AuthBatchCompiler.addRSLPreloaderPlug(formatter.toString(), string3, string4);
            String string5 = new StringBuffer().append(string).append("__Content__").toString();
            String string6 = bl ? new StringBuffer().append(string2).append(".").append(string5).toString() : string5;
            formatter = new Formatter(new StringBuffer());
            formatter.format(byteArraySubclassFormat, string2, string5);
            contentSWFPlug = AuthBatchCompiler.addRSLPreloaderPlug(formatter.toString(), string5, string6);
            StringBuffer stringBuffer = new StringBuffer();
            String string7 = AuthBatchCompiler.formatRSLAddEntries(stringBuffer);
            String string8 = new StringBuffer().append(string).append("__Preloader__").toString();
            String string9 = bl ? new StringBuffer().append(string2).append(".").append(string8).toString() : string8;
            formatter = new Formatter(new StringBuffer());
            formatter.format(wrappingSWFPreloaderFormat, string2, string8, string8, string7, string3, string6);
            AuthBatchCompiler.addRSLPreloaderPlug(formatter.toString(), string8, string9);
            AuthBatchCompiler.mainplug.handler.setRSLPreloaderClassNames(string4, string6, string9, stringBuffer.toString());
            if (bl2) {
                if (AuthBatchCompiler.mainplug.docClassPlug.instanceNameNames == null) {
                    AuthBatchCompiler.mainplug.docClassPlug.instanceNameNames = new ObjectList();
                    AuthBatchCompiler.mainplug.docClassPlug.instanceNameTypes = new ObjectList();
                }
                AuthBatchCompiler.mainplug.docClassPlug.instanceNameNames.add((Object)"__rslLoaders");
                AuthBatchCompiler.mainplug.docClassPlug.instanceNameTypes.add((Object)"Object");
            }
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            String string10 = AuthBatchCompiler.formatRSLAddEntries(stringBuffer);
            AuthBatchCompiler.mainplug.handler.setRSLPreloaderClassNames("", "", "", stringBuffer.toString());
            Formatter formatter = new Formatter(new StringBuffer());
            formatter.format(inClassSWFPreloaderFormat, string10);
            AuthIncludeInfo authIncludeInfo = null;
            if (AuthBatchCompiler.mainplug.docClassPlug.includes != null) {
                for (Object object : AuthBatchCompiler.mainplug.docClassPlug.includes) {
                    if (!((AuthIncludeInfo)object).name.equals(string)) continue;
                    authIncludeInfo = object;
                    break;
                }
            }
            if (authIncludeInfo == null) {
                authIncludeInfo = new AuthIncludeInfo();
                authIncludeInfo.name = string;
                authIncludeInfo.scriptBytes = formatter.toString().getBytes("UTF-8");
                if (AuthBatchCompiler.mainplug.docClassPlug.includes == null) {
                    AuthBatchCompiler.mainplug.docClassPlug.includes = new ObjectList(1);
                }
                AuthBatchCompiler.mainplug.docClassPlug.includes.add((Object)authIncludeInfo);
            } else if (authIncludeInfo.scriptBytes == null) {
                authIncludeInfo.scriptBytes = formatter.toString().getBytes("UTF-8");
            } else {
                Object object;
                Object object2 = formatter.toString().getBytes("UTF-8");
                object = new byte[authIncludeInfo.scriptBytes.length + ((Object)object2).length];
                System.arraycopy(authIncludeInfo.scriptBytes, 0, object, 0, authIncludeInfo.scriptBytes.length);
                System.arraycopy(object2, 0, object, authIncludeInfo.scriptBytes.length, ((Object)object2).length);
                authIncludeInfo.scriptBytes = (byte[])object;
            }
            bl2 = true;
        }
        if (bl2) {
            if (n < 0) {
                if (AuthBatchCompiler.mainplug.docClassPlug.linkedToLibrarySymbol && !AuthBatchCompiler.mainplug.docClassPlug.compiledClipSymbol) {
                    flaLibraryLinkageClasses.add(AuthBatchCompiler.mainplug.docClassPlug.classname);
                }
                AuthBatchCompiler.initPlug(AuthBatchCompiler.mainplug.docClassPlug);
                plugs.add((Object)AuthBatchCompiler.mainplug.docClassPlug);
            } else if (plugProcessingEnd > n) {
                AuthBatchCompiler.mainplug.docClassPlug.node = null;
                AuthBatchCompiler.mainplug.docClassPlug.source = null;
                AuthBatchCompiler.mainplug.docClassPlug.unit = null;
                AuthBatchCompiler.mainplug.docClassPlug.constEval = null;
                AuthBatchCompiler.removeDependencies("s", AuthBatchCompiler.mainplug.docClassPlug);
                AuthBatchCompiler.removeDependencies("n", AuthBatchCompiler.mainplug.docClassPlug);
                AuthBatchCompiler.removeDependencies("e", AuthBatchCompiler.mainplug.docClassPlug);
                AuthBatchCompiler.removeDependencies("i", AuthBatchCompiler.mainplug.docClassPlug);
                AuthBatchCompiler.initPlug(AuthBatchCompiler.mainplug.docClassPlug);
                plugs.remove(n);
                --plugProcessingStart;
                plugs.add((Object)AuthBatchCompiler.mainplug.docClassPlug);
            }
        }
    }

    private static void postGenerateExtraSwcCode() throws Throwable {
        HashSet<String> hashSet = new HashSet<String>();
        int n = plugs.size();
        for (int i = 0; i < n; ++i) {
            Set<String> set;
            AuthCompilerPlug authCompilerPlug = (AuthCompilerPlug)plugs.get(i);
            if (authCompilerPlug.isInternal || (set = authCompilerPlug.unit.getAccessibilityClasses()) == null) continue;
            hashSet.addAll(set);
        }
        if (hashSet.size() > 0) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                AuthCompilerPlug authCompilerPlug = AuthBatchCompiler.findDefinition(Util.dotClassnameToColonClassname((String)iterator.next()), false, null);
                authCompilerPlug.exportInFirstFrame = true;
            }
        }
    }

    public static void addComponentForExport(String string, String string2, String string3, String string4, String string5, String string6, String string7, int n) throws Exception {
        ClassInfo classInfo;
        String string8;
        String string9;
        if (string3.length() < 1) {
            string3 = null;
        }
        if (string.indexOf(58) < 0) {
            string9 = string;
            string8 = Util.dotClassnameToColonClassname(string);
        } else {
            string8 = string;
            string9 = Util.colonClassnameToDotClassname(string);
        }
        AuthSwcComponent authSwcComponent = new AuthSwcComponent(string8, string2, string3);
        if (string4 != null && string4.length() > 0) {
            authSwcComponent.setToolTip(string4);
        }
        if (string5 != null && string5.length() > 0) {
            authSwcComponent.setIcon(string5);
        }
        if (string6 != null && string6.length() > 0) {
            authSwcComponent.setPreview(string6);
        }
        if (string7 != null && string7.length() > 0) {
            authSwcComponent.setCustomUI(string7);
            authSwcComponent.setCustomUIDisplay(new Long(n));
        }
        if (ABCEvaluator.globalClassInfoMap != null && (classInfo = ABCEvaluator.globalClassInfoMap.get(string9)) != null && classInfo.metadata != null) {
            for (MetadataInfo metadataInfo : classInfo.metadata) {
                if (metadataInfo.name == null || !metadataInfo.name.equals("minimumPlayerVersion") || metadataInfo.attrs == null || metadataInfo.attrs.size() != 1) continue;
                MetadataAttributeInfo metadataAttributeInfo = metadataInfo.attrs.get(0);
                if (metadataAttributeInfo.name != null) continue;
                authSwcComponent.setMinimumPlayerVersion(metadataAttributeInfo.value);
                break;
            }
        }
        swcForExport.addComponent(authSwcComponent);
    }

    public static void exportSwc(String string) throws Exception {
        int n = plugs.size();
        for (int i = 0; i < n; ++i) {
            String string2;
            SwcComponent swcComponent;
            AuthCompilerPlug authCompilerPlug = (AuthCompilerPlug)plugs.get(i);
            String string3 = authCompilerPlug.unit.icon;
            if (string3 == null || (swcComponent = swcForExport.getComponent(Util.dotClassnameToColonClassname(authCompilerPlug.classname))) == null) continue;
            File file = new File(string3);
            if (file.isAbsolute()) {
                string2 = string3;
            } else {
                string2 = authCompilerPlug.pathspec;
                file = new File(string2 = new StringBuffer().append(string2).append(string3).toString());
                if (!file.exists()) {
                    string2 = AuthBatchCompiler.mainplug.pathspec;
                    string2 = new StringBuffer().append(string2).append(string3).toString();
                }
            }
            swcComponent.setIcon(string2);
        }
        swcForExport.buildLibrary(string, "library", (List)plugs);
        swcForExport.save();
    }

    public static String getFlashVersion() {
        return mainplug == null ? "" : AuthBatchCompiler.mainplug.flashVersion;
    }

    public static String getFlashBuild() {
        return mainplug == null ? "" : AuthBatchCompiler.mainplug.flashBuild;
    }

    public static String getFlashPlatform() {
        return mainplug == null ? "" : AuthBatchCompiler.mainplug.flashPlatform;
    }

    private static void parseABCBlocks() {
        Iterator<QName> iterator = hashSwcGroup.getQNames().iterator();
        while (iterator.hasNext()) {
            byte[] byArray;
            String string = iterator.next().toString();
            SwcScript swcScript = hashSwcGroup.getScriptMap().get(string);
            if (swcScript == null) {
                return;
            }
            if (swcScript.getLastModified() > swcLastModified) {
                swcLastModified = swcScript.getLastModified();
            }
            if ((byArray = swcScript.getABC()) == null) continue;
            Context context = new Context(contextStatics);
            ProgramNode programNode = new AbcParser(context, byArray).parseAbc(true, true);
            programNode.evaluate(context, (Evaluator)new ABCEvaluator(true));
        }
    }

    private static InputStream getInputStream(String string) throws Throwable {
        File file = string == null ? null : new File(string.trim());
        InputStream inputStream = null;
        if (file != null && file.exists()) {
            inputStream = new BufferedInputStream(new FileInputStream(file));
        } else {
            byte[] byArray = new byte[]{0};
            inputStream = new ByteArrayInputStream(byArray);
        }
        return inputStream;
    }

    public static void addCompilerPlug(AuthCompilerPlug authCompilerPlug) throws Throwable {
        plugs.add((Object)authCompilerPlug);
        AuthBatchCompiler.initPlug(authCompilerPlug);
    }

    public static void cleanup() throws Throwable {
        AuthBatchCompiler.clear();
        ThreadLocalToolkit.setLogger(null);
        findDefinitionCache = null;
        hasPackageCache = null;
        if (mainplug != null) {
            abcToParse = null;
            ABCEvaluator.resetGlobals();
        }
        mxPackageClassesNotFound = null;
        doABCsToOptimize = null;
        doABCsToOptimizeLoaderFrame = null;
        doABCsToOptimizeRSLLoader = null;
        showedSwcDefNotFoundError = false;
        AuthBatchCompiler.clearPlugsFromAuthSwcScripts(hashSwcGroup);
        hashSwcGroup = null;
        AuthBatchCompiler.clearPlugsFromAuthSwcScripts(libPathSwcGroup);
        libPathSwcGroup = null;
        AuthBatchCompiler.clearPlugsFromAuthSwcScripts(extLibPathSwcGroup);
        extLibPathSwcGroup = null;
        AuthBatchCompiler.clearPlugsFromAuthSwcScripts(playerGlobalSwcGroup);
        playerGlobalSwcGroup = null;
        swcPackageNames = null;
        swcForExport = null;
        if (!sEnableSWCCaching.booleanValue()) {
            swcCache = null;
        }
        rslPreloadingRequired = false;
        generatingRSLPreloaderPlugs = false;
        extLibPathSwcsUsed = null;
        rslClassMap = null;
        contentSWFPlug = null;
        missingLibrariesClasses = null;
        sourcePath = null;
        symbolTable = null;
        typeTable = null;
        CompilerAPI.removePathResolver();
        authMovieEncoder = null;
        authTagEncoder = null;
        swfTagMap = null;
        swfTagList = null;
        flaLibraryLinkageClasses = null;
        if (plugs != null) {
            for (AuthCompilerPlug authCompilerPlug : plugs) {
                if (authCompilerPlug == null) continue;
                authCompilerPlug.handler.plug = null;
                authCompilerPlug.handler = null;
                if (authCompilerPlug.in == null) continue;
                authCompilerPlug.in.close();
            }
        }
        mainplug = null;
        plugs = null;
        processedDependencies = null;
        unprocessedDependencies = null;
        INHERITANCE_processedDependCache = null;
        INHERITANCE_unprocessedDependCache = null;
        EXPRESSION_processedDependCache = null;
        EXPRESSION_unprocessedDependCache = null;
        SIGNATURE_processedDependCache = null;
        SIGNATURE_unprocessedDependCache = null;
        NAMESPACE_processedDependCache = null;
        NAMESPACE_unprocessedDependCache = null;
        inheritanceGraph = null;
        dependencyGraph = null;
        compilerExtensions = null;
        if (!sEnableSWCCaching.booleanValue()) {
            contextStatics = null;
        }
    }

    private static void initPlug(AuthCompilerPlug authCompilerPlug) throws Throwable {
        if (authCompilerPlug.isSwcPlug) {
            if (authCompilerPlug.includes != null && authCompilerPlug.includes.size() > 0) {
                authCompilerPlug.handler.authError(5002, authCompilerPlug.swcPlugSymbolName, authCompilerPlug.classname);
            }
            String string = Util.dotClassnameToColonClassname(authCompilerPlug.classname);
            AuthBatchCompiler.searchSwcGroup(string, false, authCompilerPlug, null);
        } else if (authCompilerPlug.class_provided) {
            authCompilerPlug.in = AuthBatchCompiler.getInputStream(authCompilerPlug.filename);
        } else {
            if (authCompilerPlug.script == null) {
                authCompilerPlug.script = "";
            }
            authCompilerPlug.in = new ByteArrayInputStream(authCompilerPlug.script.getBytes("UTF-8"));
        }
        if (swcForExport != null) {
            if (authCompilerPlug.linkedToLibrarySymbol && !authCompilerPlug.compiledClipSymbol || !authCompilerPlug.class_provided) {
                authCompilerPlug.lastModified = new GregorianCalendar().getTimeInMillis();
            } else if (!authCompilerPlug.isSwcPlug) {
                authCompilerPlug.lastModified = new File(authCompilerPlug.filename).lastModified();
            }
        }
        authCompilerPlug.context = new Context(contextStatics);
        authCompilerPlug.context.setHandler((CompilerHandler)authCompilerPlug.handler);
        authCompilerPlug.context.setPath(authCompilerPlug.pathspec);
        authCompilerPlug.context.config_vars = AuthBatchCompiler.mainplug.configs;
        authCompilerPlug.emitter = new ActionBlockEmitter(authCompilerPlug.context, authCompilerPlug.pathspec, (PrintWriter)new StringPrintWriter(), (PrintWriter)new StringPrintWriter(), false, false, false, (AuthBatchCompiler.mainplug.flags & 1) != 0);
        inheritanceGraph.addVertexForPlug(authCompilerPlug);
    }

    private static void init() throws Throwable {
        Object object3;
        Object object2;
        if (ThreadLocalToolkit.getLocalizationManager() == null) {
            object2 = new LocalizationManager();
            object2.addLocalizer((ILocalizer)new XLRLocalizer());
            object2.addLocalizer((ILocalizer)new ResourceBundleLocalizer());
            ThreadLocalToolkit.setLocalizationManager((LocalizationManager)object2);
        }
        if (mainplug == null) {
            ThreadLocalToolkit.setLogger(new ConsoleLogger(flashConfigDir != null, flashConfigDir != null, flashConfigDir != null, flashConfigDir != null));
        } else {
            ThreadLocalToolkit.setLogger(new AuthLogger(AuthBatchCompiler.mainplug.handler, flashConfigDir != null, flashConfigDir != null));
        }
        findDefinitionCache = new HashMap<String, AuthCompilerPlug>();
        hasPackageCache = new HashMap<String, AuthCompilerPlug>();
        if (mainplug != null && AuthBatchCompiler.mainplug.swcFileName != null && AuthBatchCompiler.mainplug.swcFileName.length() > 0) {
            swcForExport = new AuthSwc(new AuthSwcDynamicArchive(AuthBatchCompiler.mainplug.swcFileName));
            AuthBatchCompiler.mainplug.flags &= 0xFFFFFEFF;
        } else {
            swcForExport = null;
        }
        if (swcCache == null) {
            swcCache = new AuthSwcCache();
        }
        if (mainplug == null || AuthBatchCompiler.mainplug.swcHashKeys == null) {
            hashSwcGroup = null;
        } else {
            int n = AuthBatchCompiler.mainplug.swcHashKeys.length() / 23;
            if (n < 1) {
                hashSwcGroup = null;
            } else {
                object3 = new String[n];
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    object3[i] = AuthBatchCompiler.mainplug.swcHashKeys.substring(n2, n2 + 22);
                    n2 += 23;
                }
                hashSwcGroup = swcCache.getSwcGroupFromHashes((String[])object3, false);
            }
        }
        if (mainplug != null) {
            if (AuthBatchCompiler.mainplug.libPathStr != null) {
                AuthBatchCompiler.mainplug.libPath = AuthBatchCompiler.mainplug.libPathStr.split(";");
            }
            if (AuthBatchCompiler.mainplug.extLibPathStr != null) {
                AuthBatchCompiler.mainplug.extLibPath = AuthBatchCompiler.mainplug.extLibPathStr.split(";");
            }
            if (AuthBatchCompiler.mainplug.rslPathsStr != null) {
                rslClassMap = new HashMap<String, List<RSLClassInfo>>();
                object2 = AuthBatchCompiler.mainplug.rslPathsStr.split("\\|\\|\\|\\|");
                AuthBatchCompiler.mainplug.rslPaths = new RSLInfo[((String[])object2).length];
                for (int i = 0; i < ((String[])object2).length; ++i) {
                    String string;
                    int n;
                    String[] stringArray = object2[i].split("\\|");
                    if (stringArray.length < 4) continue;
                    String[] stringArray2 = stringArray[2].split(";");
                    int n3 = stringArray2.length;
                    if (n3 == 1 && stringArray2[0].length() == 0) {
                        n3 = 0;
                    }
                    int n4 = stringArray.length - 3;
                    n4 = n4 / 2 + n4 % 2;
                    String string2 = stringArray[0];
                    String string3 = FileUtils.canonicalPath((String)string2).toLowerCase();
                    RSLInfo rSLInfo = new RSLInfo(string3, string2, stringArray[1], n4, n3);
                    for (n = 0; n < n3; ++n) {
                        RSLClassInfo rSLClassInfo;
                        String string4 = stringArray2[n];
                        if (string4.length() < 2) {
                            rSLInfo.classes[n] = null;
                            continue;
                        }
                        int n5 = 0;
                        try {
                            n5 = Integer.parseInt(string4.substring(0, 1));
                        }
                        catch (NumberFormatException numberFormatException) {
                            n5 = 0;
                        }
                        string = string4.substring(1);
                        rSLInfo.classes[n] = rSLClassInfo = new RSLClassInfo(string, n5, rSLInfo);
                        List<RSLClassInfo> list = rslClassMap.get(string);
                        if (list == null) {
                            list = new ArrayList<RSLClassInfo>(1);
                            rslClassMap.put(string, list);
                        }
                        list.add(rSLClassInfo);
                    }
                    n = 3;
                    for (int j = 0; j < n4; ++j) {
                        String string5 = stringArray[n++];
                        string = n >= stringArray.length ? "" : stringArray[n++];
                        rSLInfo.urls[j] = new RSLURLInfo(string5, string, rSLInfo);
                    }
                    AuthBatchCompiler.mainplug.rslPaths[i] = rSLInfo;
                }
            }
        }
        rslPreloadingRequired = false;
        generatingRSLPreloaderPlugs = false;
        extLibPathSwcsUsed = new HashMap<String, RSLInfo>();
        contentSWFPlug = null;
        missingLibrariesClasses = new HashSet<String>();
        libPathSwcGroup = mainplug == null || AuthBatchCompiler.mainplug.libPathStr == null ? null : swcCache.getSwcGroup(AuthBatchCompiler.mainplug.libPath);
        extLibPathSwcGroup = mainplug == null || AuthBatchCompiler.mainplug.extLibPathStr == null ? null : swcCache.getSwcGroup(AuthBatchCompiler.mainplug.extLibPath);
        if (null == contextStatics) {
            contextStatics = new ContextStatics();
        } else {
            contextStatics.reuse();
            AuthBatchCompiler.contextStatics.userDefined.clear();
        }
        if (mainplug != null && flexConfiguration == null) {
            object2 = FlexInfo.getSingleton(AuthBatchCompiler.mainplug.flexInfoXMLPath);
            object3 = new File(AuthBatchCompiler.mainplug.flexInfoXMLPath);
            flexConfiguration = new CommandLineConfiguration();
            flexConfiguration.getCompilerConfiguration().setKeepGeneratedActionScript(false);
            ConfigurationBuffer configurationBuffer = new ConfigurationBuffer(flexConfiguration.getClass(), Configuration.getAliases());
            FileConfigurator.load(configurationBuffer, new ByteArrayInputStream(((FlexInfo)object2).getFlexConfigStr().getBytes("UTF-8")), ((File)object3).getName(), ((File)object3).getParent(), "flex-config", true);
            flexConfiguration.setConfigPathResolver(new ConfigurationPathResolver());
            configurationBuffer.commit(flexConfiguration);
            ThreadLocalToolkit.setCompatibilityVersion(Boxing.valueOf((int)flexConfiguration.getCompatibilityVersion()));
        }
        sourcePath = new SourcePath(new String[]{"text/as"}, false);
        if (flexConfiguration != null) {
            symbolTable = new SymbolTable(flexConfiguration, contextStatics);
            typeTable = new TypeTable(symbolTable);
        }
        CompilerAPI.usePathResolver();
        AuthBatchCompiler.contextStatics.handler = mainplug != null && AuthBatchCompiler.mainplug.handlerKey != null && AuthBatchCompiler.mainplug.handlerKey.length() > 0 ? new AuthCompilerHandler(AuthBatchCompiler.mainplug.handlerKey, null) : new CompilerHandler();
        AuthBatchCompiler.contextStatics.use_namespaces.clear();
        ContextStatics.useVerboseErrors = false;
        ContextStatics.useSimpleLogWarnings = true;
        if (mainplug != null) {
            ContextStatics.omitTrace = (AuthBatchCompiler.mainplug.flags & 0x200) != 0;
            AuthBatchCompiler.contextStatics.use_static_semantics = (AuthBatchCompiler.mainplug.flags & 2) != 0;
            AuthBatchCompiler.contextStatics.dialect = (AuthBatchCompiler.mainplug.flags & 0x40) != 0 ? 10 : 9;
            AuthBatchCompiler.contextStatics.languageID = Context.getLanguageID((String)AuthBatchCompiler.mainplug.language);
            int n = 0;
            switch (AuthBatchCompiler.mainplug.swfVersion) {
                case 9: {
                    n = 0;
                    break;
                }
                default: {
                    n = 1;
                }
            }
            contextStatics.setAbcVersion(n);
        }
        if (mainplug != null) {
            AuthBatchCompiler.mainplug.configs = AuthBatchCompiler.parseConfigConstStr(AuthBatchCompiler.mainplug.configConstStr);
        }
        if (plugs != null) {
            flaLibraryLinkageClasses = new HashSet<String>(plugs.size());
            processedDependencies = new GlobalDependencies();
            unprocessedDependencies = new GlobalDependencies();
            INHERITANCE_processedDependCache = processedDependencies.getSetForType("i");
            INHERITANCE_unprocessedDependCache = unprocessedDependencies.getSetForType("i");
            EXPRESSION_processedDependCache = processedDependencies.getSetForType("e");
            EXPRESSION_unprocessedDependCache = unprocessedDependencies.getSetForType("e");
            SIGNATURE_processedDependCache = processedDependencies.getSetForType("s");
            SIGNATURE_unprocessedDependCache = unprocessedDependencies.getSetForType("s");
            NAMESPACE_processedDependCache = processedDependencies.getSetForType("n");
            NAMESPACE_unprocessedDependCache = unprocessedDependencies.getSetForType("n");
            inheritanceGraph = new PlugDependencyGraph();
            dependencyGraph = new PlugDependencyGraph();
            for (Object object3 : plugs) {
                if (((AuthCompilerPlug)object3).linkedToLibrarySymbol && !((AuthCompilerPlug)object3).compiledClipSymbol) {
                    flaLibraryLinkageClasses.add(((AuthCompilerPlug)object3).classname);
                }
                AuthBatchCompiler.initPlug((AuthCompilerPlug)object3);
            }
        }
        TypeValue.init();
        ObjectValue.init();
        authTagEncoder = null;
        authMovieEncoder = null;
        if (mainplug != null) {
            swfTagMap = new HashMap<String, SwfTagBlockInfo>();
            swfTagList = new ArrayList<SwfTagBlockInfo>();
        } else {
            swfTagMap = null;
            swfTagList = null;
        }
        if (mainplug != null && plugs != null) {
            if (AuthBatchCompiler.mainplug.import_filespecs != null) {
                AuthBatchCompiler.initImports(AuthBatchCompiler.mainplug.import_filespecs);
            }
            AuthBatchCompiler.initPlayerGlobalSwcGroup();
        }
        swcPackageNames = new HashSet<String>();
        if (hashSwcGroup != null) {
            AuthBatchCompiler.addPackageNames(hashSwcGroup);
        }
        if (libPathSwcGroup != null) {
            AuthBatchCompiler.addPackageNames(libPathSwcGroup);
        }
        if (extLibPathSwcGroup != null) {
            AuthBatchCompiler.addPackageNames(extLibPathSwcGroup);
        }
        if (playerGlobalSwcGroup != null) {
            AuthBatchCompiler.addPackageNames(playerGlobalSwcGroup);
        }
        if (mainplug != null) {
            ABCEvaluator.resetGlobals();
            if (AuthBatchCompiler.mainplug.swcFileName != null && AuthBatchCompiler.mainplug.swcFileName.equals("dummy_for_GenerateClassXML")) {
                abcToParse = new ArrayList();
            }
        } else {
            abcToParse = null;
        }
        compilerExtensions = new ArrayList();
        mxPackageClassesNotFound = new HashSet<String>();
    }

    private static ObjectList<ConfigVar> parseConfigConstStr(String string) {
        if (string == null || string.length() <= 0) {
            return null;
        }
        ObjectList objectList = new ObjectList();
        int n = 0;
        while (n >= 0) {
            n = AuthBatchCompiler.parseConfigVar((ObjectList<ConfigVar>)objectList, string, n);
        }
        return objectList;
    }

    private static int parseConfigVar(ObjectList<ConfigVar> objectList, String string, int n) {
        int n2 = string.indexOf(61, n);
        if (n2 <= 0) {
            return -1;
        }
        if (string.length() < n2 + 3) {
            return -1;
        }
        if (string.charAt(n2 + 1) != '\"') {
            return -1;
        }
        String string2 = string.substring(n, n2);
        int n3 = string2.indexOf("::");
        int n4 = n3 + 2;
        if (n3 <= 0 || n4 >= string2.length()) {
            return -1;
        }
        String string3 = string2.substring(0, n3);
        String string4 = string2.substring(n4);
        String string5 = null;
        int n5 = n2 + 2;
        int n6 = string.indexOf(34, n5);
        if (n6 < 0) {
            return -1;
        }
        if (n6 > n5) {
            StringBuffer stringBuffer = new StringBuffer();
            ABCEvaluator.appendUnescapedForXML(stringBuffer, string.substring(n5, n6));
            string5 = stringBuffer.toString();
            if (!string5.equals("true") && !string5.equals("false")) {
                int n7;
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                if (string5.contains("\n") || string5.contains("\r")) {
                    bl = true;
                    n7 = stringBuffer.indexOf("\n");
                    while (n7 >= 0) {
                        stringBuffer.replace(n7, n7 + 1, "\\n");
                        n7 = stringBuffer.indexOf("\n", n7 + 2);
                    }
                    int n8 = stringBuffer.indexOf("\r");
                    while (n8 >= 0) {
                        stringBuffer.replace(n8, n8 + 1, "\\r");
                        n8 = stringBuffer.indexOf("\r", n8 + 2);
                    }
                }
                if (string5.contains("\"")) {
                    bl = true;
                    bl2 = stringBuffer.charAt(0) == '\"';
                    n7 = stringBuffer.indexOf("\"", 1);
                    while (n7 >= 0) {
                        if (bl2 && n7 == stringBuffer.length() - 1) {
                            bl3 = true;
                            break;
                        }
                        stringBuffer.replace(n7, n7 + 1, "\\\"");
                        n7 = stringBuffer.indexOf("\"", n7 + 2);
                    }
                    if (bl2 && !bl3) {
                        stringBuffer.replace(0, 1, "\\\"");
                    }
                }
                if (!bl) {
                    Context context = new Context(contextStatics);
                    context.setHandler((CompilerHandler)new ParseConfigVarHandler());
                    context.setEmitter((Emitter)new ActionBlockEmitter(context, "dummy"));
                    context.config_vars.add((Object)new ConfigVar(string3, string4, string5));
                    ProgramNode programNode = new Parser(context, "", "").parseProgram();
                    if (programNode == null || programNode.statements == null || programNode.statements.items == null || programNode.statements.items.size() != 3) {
                        bl = true;
                    } else {
                        programNode.evaluate(context, (Evaluator)new ConfigurationEvaluator());
                        bl = !((ParseConfigVarHandler)context.handler).isOK;
                    }
                    AuthBatchCompiler.contextStatics.errCount = 0;
                }
                if (!(!bl || bl2 && bl3)) {
                    stringBuffer.insert(0, '\"');
                    stringBuffer.append('\"');
                    string5 = stringBuffer.toString();
                }
            }
        } else {
            string5 = "\"\"";
        }
        objectList.add((Object)new ConfigVar(string3, string4, string5));
        int n9 = n6 + 1;
        if (string.length() > n9 + 1 && string.charAt(n9) == ';') {
            ++n9;
        }
        return n9;
    }

    private static void initPlayerGlobalSwcGroup() {
        String[] stringArray;
        SwcScript swcScript = null;
        if (AuthBatchCompiler.mainplug.playerGlobalSwcPath != null && (playerGlobalSwcGroup = swcCache.getSwcGroup(stringArray = new String[]{AuthBatchCompiler.mainplug.playerGlobalSwcPath})) != null && (swcScript = playerGlobalSwcGroup.getScriptMap().get("String")) != null) {
            AuthSwc authSwc = (AuthSwc)swcScript.getLibrary().getSwc();
            Iterator<SwcComponent> iterator = authSwc.getComponentIterator();
            while (iterator.hasNext()) {
                AuthSwcComponent authSwcComponent = (AuthSwcComponent)iterator.next();
                AuthBatchCompiler.searchSwcGroup(authSwcComponent.getClassName(), false, null, null);
            }
        }
        if (swcScript == null) {
            stringArray = mainplug != null && AuthBatchCompiler.mainplug.playerGlobalSwcPath != null ? AuthBatchCompiler.mainplug.playerGlobalSwcPath : "";
            AuthBatchCompiler.mainplug.handler.authError(5004, (String)stringArray, "");
        }
    }

    private static void addPackageNames(SwcGroup swcGroup) {
        for (QName qName : swcGroup.getQNames()) {
            if (qName.getNamespace() == null || qName.getNamespace() == "") continue;
            swcPackageNames.add(qName.getNamespace());
        }
    }

    private static void initImports(ObjectList<String> objectList) throws Throwable {
        for (int i = objectList.size() - 1; i >= 0; --i) {
            AuthCompilerPlug authCompilerPlug = new AuthCompilerPlug();
            authCompilerPlug.filename = (String)objectList.get(i);
            authCompilerPlug.isInternal = true;
            authCompilerPlug.setHandlerKey(authCompilerPlug.filename);
            plugs.add(0, (Object)authCompilerPlug);
            authCompilerPlug.context = new Context(contextStatics);
            authCompilerPlug.emitter = new ActionBlockEmitter(authCompilerPlug.context, authCompilerPlug.scriptname, (PrintWriter)new StringPrintWriter(), (PrintWriter)new StringPrintWriter(), false, false, false, (AuthBatchCompiler.mainplug.flags & 1) != 0);
            inheritanceGraph.addVertexForPlug(authCompilerPlug);
        }
    }

    private static void parse(int n, int n2) throws Throwable, IOException {
        int n3;
        AuthCompilerPlug authCompilerPlug;
        int n4;
        for (n4 = n; n4 < n2; ++n4) {
            ArrayList<Node> arrayList;
            Object object;
            boolean bl;
            authCompilerPlug = (AuthCompilerPlug)plugs.get(n4);
            if (authCompilerPlug.noParse) continue;
            Source source = AuthBatchCompiler.createSource(authCompilerPlug);
            authCompilerPlug.context.setEmitter((Emitter)authCompilerPlug.emitter);
            authCompilerPlug.context.setPath(authCompilerPlug.class_provided ? source.getParent() : authCompilerPlug.filename);
            n3 = source.getName().endsWith(".abc") ? 1 : 0;
            boolean bl2 = source.getName().endsWith(".as") && !authCompilerPlug.make_movieclip;
            boolean bl3 = bl = n3 != 0 || authCompilerPlug.abc != null;
            if ((n3 != 0 || bl2) && authCompilerPlug.abc == null) {
                authCompilerPlug.scriptname = source.getName();
                authCompilerPlug.pathspec = authCompilerPlug.class_provided ? source.getParent() : authCompilerPlug.filename;
                authCompilerPlug.context.setScriptName(authCompilerPlug.scriptname);
                authCompilerPlug.context.setPath(authCompilerPlug.pathspec);
            }
            ProgramNode programNode = null;
            if (authCompilerPlug.abc != null) {
                programNode = new AbcParser(authCompilerPlug.context, authCompilerPlug.abc).parseAbc(true, true);
            } else if (n3 != 0) {
                programNode = new AbcParser(authCompilerPlug.context, source.getName()).parseAbc(true, true);
            } else if (bl2) {
                object = source.isTextBased() ? new Parser(authCompilerPlug.context, source.getInputText(), source.getName()) : new Parser(authCompilerPlug.context, (InputStream)new BufferedInputStream(source.getInputStream()), source.getName());
                programNode = object.parseProgram();
                programNode.evaluate(authCompilerPlug.context, (Evaluator)new ConfigurationEvaluator());
            } else {
                AuthIncludeInfo authIncludeInfo;
                if (authCompilerPlug.isSwcPlug && !showedSwcDefNotFoundError) {
                    showedSwcDefNotFoundError = true;
                    authCompilerPlug.handler.authError(5009, "", "");
                }
                if (authCompilerPlug.in == null) {
                    authCompilerPlug.in = AuthBatchCompiler.getInputStream(null);
                }
                object = null;
                if (AuthBatchCompiler.mainplug.includes != null && AuthBatchCompiler.mainplug.includes.size() > 0 && (authIncludeInfo = (AuthIncludeInfo)AuthBatchCompiler.mainplug.includes.get(0)) != null && authIncludeInfo.scriptBytes != null) {
                    object = new ByteArrayInputStream(authIncludeInfo.scriptBytes);
                }
                authIncludeInfo = new Parser(authCompilerPlug.context, authCompilerPlug.in, authCompilerPlug.filename, authCompilerPlug.file_encoding, false, false);
                programNode = authIncludeInfo.parseProgram();
                programNode.evaluate(authCompilerPlug.context, (Evaluator)new ConfigurationEvaluator());
                if (authCompilerPlug.make_movieclip) {
                    arrayList = new MovieClipMaker(mainplug);
                    ((MovieClipMaker)((Object)arrayList)).setClassname(authCompilerPlug.classname);
                    ((MovieClipMaker)((Object)arrayList)).setBaseClassname(authCompilerPlug.base_classname);
                    ((MovieClipMaker)((Object)arrayList)).setClassProvided(authCompilerPlug.class_provided);
                    ((MovieClipMaker)((Object)arrayList)).setImplicitImportScript((InputStream)object);
                    ((MovieClipMaker)((Object)arrayList)).setCompilerPlug(authCompilerPlug);
                    programNode.evaluate(authCompilerPlug.context, arrayList);
                }
            }
            AuthBatchCompiler.createCompilationUnit(authCompilerPlug);
            authCompilerPlug.unit.setSyntaxTree(programNode);
            object = new SyntaxTreeEvaluator(authCompilerPlug.unit);
            ((EvaluatorAdapter)object).setLocalizationManager(ThreadLocalToolkit.getLocalizationManager());
            programNode.evaluate(authCompilerPlug.context, (Evaluator)object);
            if (!authCompilerPlug.isInternal || swcForExport != null) {
                if (!bl) {
                    int n5 = authCompilerPlug.classname.lastIndexOf(46);
                    arrayList = n5 == -1 ? "" : authCompilerPlug.classname.substring(0, n5);
                    programNode.evaluate(authCompilerPlug.context, (Evaluator)new ABCEvaluator((String)((Object)arrayList), false));
                } else if (abcToParse != null) {
                    abcToParse.add(new ABCToParse(authCompilerPlug.context, programNode));
                }
            }
            if (authCompilerPlug.isSwcPlug) {
                authCompilerPlug.unit.bytes.set(authCompilerPlug.abc, authCompilerPlug.abc.length);
            } else if (!authCompilerPlug.isInternal) {
                int n6 = programNode.statements != null ? programNode.statements.items.size() : 0;
                arrayList = new ArrayList<Node>(authCompilerPlug.isSwcPlug ? n6 : 1);
                boolean bl4 = false;
                for (int i = 0; i < n6; ++i) {
                    Node node = (Node)programNode.statements.items.get(i);
                    if (node instanceof PackageDefinitionNode) {
                        bl4 = !bl4;
                        continue;
                    }
                    if (!node.isDefinition() || !bl4) continue;
                    arrayList.add(node);
                }
                AuthBatchCompiler.transferDefinitions(authCompilerPlug.unit.topLevelDefinitions, arrayList);
                AuthBatchCompiler.checkForFileNameErrors(authCompilerPlug);
            }
            authCompilerPlug.node = programNode;
            authCompilerPlug.context.getNodeFactory().pkg_defs.clear();
            authCompilerPlug.context.getNodeFactory().compound_names.clear();
            if (authCompilerPlug.isSwcPlug) continue;
            AuthBatchCompiler.mainplug.handler.proxyHandler = authCompilerPlug.handler;
            int n7 = compilerExtensions.size();
            for (int i = 0; i < n7; ++i) {
                if (authCompilerPlug.context.errorCount() != 0) continue;
                try {
                    compilerExtensions.get(i).parse1(authCompilerPlug.unit, typeTable);
                    continue;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    throw outOfMemoryError;
                }
                catch (Throwable throwable) {
                    if (flashConfigDir == null) continue;
                    System.err.println(new StringBuffer().append("Exception running parse1() on plug ").append(authCompilerPlug.handlerKey).append("with Extension ").append(compilerExtensions.get(i).toString()).toString());
                    throwable.printStackTrace();
                }
            }
            AuthBatchCompiler.mainplug.handler.proxyHandler = null;
        }
        for (n4 = n; n4 < n2; ++n4) {
            authCompilerPlug = (AuthCompilerPlug)plugs.get(n4);
            if (authCompilerPlug.isSwcPlug) continue;
            AuthBatchCompiler.mainplug.handler.proxyHandler = authCompilerPlug.handler;
            n3 = compilerExtensions.size();
            for (int i = 0; i < n3; ++i) {
                if (authCompilerPlug.context.errorCount() != 0) continue;
                try {
                    compilerExtensions.get(i).parse2(authCompilerPlug.unit, typeTable);
                    continue;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    throw outOfMemoryError;
                }
                catch (Throwable throwable) {
                    if (flashConfigDir == null) continue;
                    System.err.println(new StringBuffer().append("Exception running parse2() on plug ").append(authCompilerPlug.handlerKey).append("with Extension ").append(compilerExtensions.get(i).toString()).toString());
                    throwable.printStackTrace();
                }
            }
            AuthBatchCompiler.mainplug.handler.proxyHandler = null;
        }
    }

    private static boolean isNotPrivate(AttributeListNode attributeListNode) {
        int n;
        int n2 = n = attributeListNode == null ? 0 : attributeListNode.items.size();
        for (int i = 0; i < n; ++i) {
            Node node = (Node)attributeListNode.items.get(i);
            if (node == null || !node.hasAttribute("private")) continue;
            return false;
        }
        return true;
    }

    private static String getPackageDefinition(PackageDefinitionNode packageDefinitionNode) {
        StringBuffer stringBuffer = new StringBuffer();
        if (packageDefinitionNode != null) {
            int n;
            ObjectList objectList = packageDefinitionNode.name.id.list;
            int n2 = n = objectList == null ? 0 : objectList.size();
            for (int i = 0; i < n; ++i) {
                IdentifierNode identifierNode = (IdentifierNode)objectList.get(i);
                stringBuffer.append(identifierNode.name);
                if (i >= n - 1) continue;
                stringBuffer.append(".");
            }
        }
        return stringBuffer.toString();
    }

    private static QName getClassDefinition(ClassDefinitionNode classDefinitionNode) {
        return new QName(AuthBatchCompiler.getPackageDefinition(classDefinitionNode.pkgdef), classDefinitionNode.name.name);
    }

    private static QName getNamespaceDefinition(NamespaceDefinitionNode namespaceDefinitionNode) {
        return new QName(AuthBatchCompiler.getPackageDefinition(namespaceDefinitionNode.pkgdef), namespaceDefinitionNode.name.name);
    }

    private static QName getFunctionDefinition(FunctionDefinitionNode functionDefinitionNode) {
        return new QName(AuthBatchCompiler.getPackageDefinition(functionDefinitionNode.pkgdef), functionDefinitionNode.name.identifier.name);
    }

    private static QName getVariableBinding(PackageDefinitionNode packageDefinitionNode, VariableBindingNode variableBindingNode) {
        return new QName(AuthBatchCompiler.getPackageDefinition(packageDefinitionNode), variableBindingNode.variable.identifier.name);
    }

    private static void transferDefinitions(Collection collection, List list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            int n2;
            ClassDefinitionNode classDefinitionNode;
            Node node = (Node)list.get(i);
            if (node instanceof ClassDefinitionNode) {
                classDefinitionNode = (ClassDefinitionNode)node;
                if (!AuthBatchCompiler.isNotPrivate(classDefinitionNode.attrs)) continue;
                collection.add(AuthBatchCompiler.getClassDefinition(classDefinitionNode));
                continue;
            }
            if (node instanceof NamespaceDefinitionNode) {
                classDefinitionNode = (NamespaceDefinitionNode)node;
                if (!AuthBatchCompiler.isNotPrivate(classDefinitionNode.attrs) || node instanceof ConfigNamespaceDefinitionNode) continue;
                collection.add(AuthBatchCompiler.getNamespaceDefinition((NamespaceDefinitionNode)classDefinitionNode));
                continue;
            }
            if (node instanceof FunctionDefinitionNode) {
                classDefinitionNode = (FunctionDefinitionNode)node;
                if (!AuthBatchCompiler.isNotPrivate(classDefinitionNode.attrs)) continue;
                collection.add(AuthBatchCompiler.getFunctionDefinition((FunctionDefinitionNode)classDefinitionNode));
                continue;
            }
            if (!(node instanceof VariableDefinitionNode)) continue;
            classDefinitionNode = (VariableDefinitionNode)node;
            if (!AuthBatchCompiler.isNotPrivate(classDefinitionNode.attrs)) continue;
            int n3 = n2 = classDefinitionNode.list == null ? 0 : classDefinitionNode.list.size();
            for (int j = 0; j < n2; ++j) {
                VariableBindingNode variableBindingNode = (VariableBindingNode)classDefinitionNode.list.items.get(j);
                collection.add(AuthBatchCompiler.getVariableBinding(classDefinitionNode.pkgdef, variableBindingNode));
            }
        }
    }

    private static void checkForFileNameErrors(AuthCompilerPlug authCompilerPlug) {
        if (authCompilerPlug == null || authCompilerPlug.isInternal || authCompilerPlug.abc != null || authCompilerPlug.numErrors > 0 || !authCompilerPlug.class_provided) {
            return;
        }
        QNameList qNameList = authCompilerPlug.unit.topLevelDefinitions;
        int n = qNameList.size();
        if (n > 1) {
            Iterator iterator = qNameList.iterator();
            String[] stringArray = new String[2];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = Util.colonClassnameToDotClassname(((QName)iterator.next()).toString());
            }
            authCompilerPlug.handler.authError(5006, stringArray[0], stringArray[1]);
        } else if (n < 1) {
            if (AuthBatchCompiler.contextStatics.errCount == 0) {
                authCompilerPlug.handler.authError(5007, "", "");
            }
        } else {
            String string;
            QName qName = (QName)qNameList.iterator().next();
            int n2 = authCompilerPlug.classname.lastIndexOf(46);
            String string2 = n2 >= 0 ? authCompilerPlug.classname.substring(0, n2) : "";
            String string3 = string = n2 >= 0 ? authCompilerPlug.classname.substring(n2 + 1) : authCompilerPlug.classname;
            if (!string2.equals(qName.getNamespace())) {
                authCompilerPlug.handler.authError(5001, qName.getNamespace(), authCompilerPlug.filename);
            }
            if (!string.equals(qName.getLocalPart())) {
                authCompilerPlug.handler.authError(5008, qName.getLocalPart(), authCompilerPlug.filename);
            }
        }
    }

    private static Set<Name> getPlugSetForType(AuthCompilerPlug authCompilerPlug, String string) {
        if (string == "i") {
            return authCompilerPlug.unit.inheritance;
        }
        if (string == "n") {
            return authCompilerPlug.unit.namespaces;
        }
        if (string == "s") {
            return authCompilerPlug.unit.types;
        }
        if (string == "e") {
            return authCompilerPlug.unit.expressions;
        }
        return null;
    }

    private static void addDependency(TempDependencyHolder tempDependencyHolder, Set<GlobalDependencies.Pair> set, Set<GlobalDependencies.Pair> set2) {
        AuthBatchCompiler.addDependency(tempDependencyHolder.depPlug, tempDependencyHolder.defPlug, tempDependencyHolder.depType, tempDependencyHolder.fullname, set, set2);
    }

    private static void addDependency(AuthCompilerPlug authCompilerPlug, AuthCompilerPlug authCompilerPlug2, String string, String string2, Set<GlobalDependencies.Pair> set, Set<GlobalDependencies.Pair> set2) {
        if (authCompilerPlug == authCompilerPlug2) {
            return;
        }
        GlobalDependencies.Pair pair = new GlobalDependencies.Pair(authCompilerPlug, authCompilerPlug2);
        if (!set.contains(pair)) {
            set2.add(pair);
        }
        dependencyGraph.addDependency(pair.depPlug, pair.defPlug, string2);
        if (string == "i") {
            inheritanceGraph.addDependency(pair.depPlug, pair.defPlug, string2);
        }
        if (swcForExport != null && string2.length() > 0) {
            Set<Name> set3 = AuthBatchCompiler.getPlugSetForType(authCompilerPlug, string);
            set3.add(new QName(string2));
        }
    }

    private static void addDeps(AuthCompilerPlug authCompilerPlug, SwcDependencySet swcDependencySet, String string) {
        Set<Name> set = AuthBatchCompiler.getPlugSetForType(authCompilerPlug, string);
        Iterator<String> iterator = swcDependencySet.getDependencyIterator(string);
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            set.add(new QName(iterator.next()));
        }
    }

    private static void resolveDependenciesForSwcPlug(AuthCompilerPlug authCompilerPlug, String string, Set<GlobalDependencies.Pair> set, Set<GlobalDependencies.Pair> set2) throws Throwable {
        if (authCompilerPlug.context.errorCount() > 0) {
            return;
        }
        try {
            if (authCompilerPlug.abcDependenciesResolved.get(string) != null) {
                return;
            }
        }
        catch (NullPointerException nullPointerException) {
            authCompilerPlug.abcDependenciesResolved = new HashMap(4);
        }
        authCompilerPlug.abcDependenciesResolved.put(string, string);
        Set<Name> set3 = AuthBatchCompiler.getPlugSetForType(authCompilerPlug, string);
        ArrayList<TempDependencyHolder> arrayList = new ArrayList<TempDependencyHolder>();
        String string2 = null;
        Iterator<Name> iterator = set3.iterator();
        while (iterator.hasNext()) {
            Object object;
            Name name = iterator.next();
            AuthCompilerPlug authCompilerPlug2 = null;
            if (name instanceof MultiName) {
                int n;
                object = (MultiName)name;
                String[] stringArray = ((MultiName)object).getNamespace();
                String string3 = ((Name)object).getLocalPart();
                int n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    String string4 = string2 = stringArray[n].length() > 0 ? new StringBuffer().append(stringArray[n]).append(":").append(string3).toString() : string3;
                    if (string == "i" || string == "s") {
                        authCompilerPlug2 = AuthBatchCompiler.findClass(string2, authCompilerPlug);
                    } else if (string == "n" || string == "e") {
                        authCompilerPlug2 = AuthBatchCompiler.findDefinition(string2, false, authCompilerPlug);
                    }
                    if (authCompilerPlug2 != null) break;
                }
                if (authCompilerPlug2 == null) {
                    n2 = stringArray.length;
                    for (n = 0; n < n2; ++n) {
                        String string5;
                        String string6 = string5 = stringArray[n].length() > 0 ? new StringBuffer().append(stringArray[n]).append(".").append(string3).toString() : string3;
                        if (rslClassMap != null && rslClassMap.containsKey(string5)) {
                            missingLibrariesClasses.add(string5);
                            continue;
                        }
                        if (!string5.startsWith("mx.")) continue;
                        mxPackageClassesNotFound.add(string5);
                    }
                }
                iterator.remove();
            } else {
                string2 = ((QName)name).toString();
                if (string == "i" || string == "s") {
                    authCompilerPlug2 = AuthBatchCompiler.findClass(string2, authCompilerPlug);
                } else if (string == "n" || string == "e") {
                    authCompilerPlug2 = AuthBatchCompiler.findDefinition(string2, false, authCompilerPlug);
                }
                if (authCompilerPlug2 == null) {
                    object = Util.colonClassnameToDotClassname(string2);
                    if (rslClassMap != null && rslClassMap.containsKey(object)) {
                        missingLibrariesClasses.add((String)object);
                    } else if (((String)object).startsWith("mx.")) {
                        mxPackageClassesNotFound.add((String)object);
                    }
                }
            }
            if (authCompilerPlug2 != null) {
                arrayList.add(new TempDependencyHolder(authCompilerPlug, authCompilerPlug2, string, string2));
                continue;
            }
            if (flashConfigDir == null) continue;
            System.err.println(new StringBuffer().append(string2).append(" in ").append(authCompilerPlug.scriptname).append(" not resolved").toString());
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            AuthBatchCompiler.addDependency((TempDependencyHolder)((Object)iterator.next()), set, set2);
        }
    }

    private static void resolveDependenciesForNode(AuthCompilerPlug authCompilerPlug, Set<ReferenceValue> set, String string, Set<GlobalDependencies.Pair> set2, Set<GlobalDependencies.Pair> set3) throws Throwable {
        HashSet<String> hashSet = new HashSet<String>(set.size());
        for (ReferenceValue referenceValue : set) {
            int n;
            Namespaces namespaces = referenceValue.getImmutableNamespaces();
            AuthCompilerPlug authCompilerPlug2 = null;
            macromedia.asc.semantics.QName qName = null;
            int n2 = namespaces != null ? namespaces.size() : 0;
            for (n = 0; n < n2; ++n) {
                qName = new macromedia.asc.semantics.QName((ObjectValue)namespaces.get(n), referenceValue.name);
                if (string == "i" || string == "s") {
                    authCompilerPlug2 = AuthBatchCompiler.findClass(qName, authCompilerPlug);
                } else if (string == "n" || string == "e") {
                    authCompilerPlug2 = AuthBatchCompiler.findDefinition(qName, false, authCompilerPlug);
                }
                if (authCompilerPlug2 != null) break;
            }
            if (authCompilerPlug2 != null) {
                String string2 = qName.toString();
                if (hashSet.contains(string2)) continue;
                AuthBatchCompiler.addDependency(authCompilerPlug, authCompilerPlug2, string, string2, set2, set3);
                hashSet.add(string2);
                continue;
            }
            for (n = 0; n < n2; ++n) {
                String string3;
                ObjectValue objectValue = (ObjectValue)namespaces.get(n);
                if (!(objectValue instanceof NamespaceValue)) continue;
                String string4 = objectValue.name;
                String string5 = string3 = string4.length() > 0 ? new StringBuffer().append(string4).append(".").append(referenceValue.name).toString() : referenceValue.name;
                if (rslClassMap != null && rslClassMap.containsKey(string3)) {
                    missingLibrariesClasses.add(string3);
                    continue;
                }
                if (!string3.startsWith("mx.")) continue;
                mxPackageClassesNotFound.add(string3);
            }
            if (flashConfigDir == null) continue;
            System.err.println(new StringBuffer().append(referenceValue.toMultiName()).append(" in ").append(authCompilerPlug.scriptname).append(" not resolved").toString());
        }
        set.clear();
    }

    private static void resolveMultiNameDependencies(AuthCompilerPlug authCompilerPlug, String string, Set<GlobalDependencies.Pair> set, Set<GlobalDependencies.Pair> set2) throws Throwable {
        if (authCompilerPlug.context.errorCount() > 0) {
            return;
        }
        ArrayList<TempDependencyHolder> arrayList = new ArrayList<TempDependencyHolder>();
        String string2 = null;
        Iterator<Name> iterator = AuthBatchCompiler.getPlugSetForType(authCompilerPlug, string).iterator();
        while (iterator.hasNext()) {
            Name name = iterator.next();
            if (!(name instanceof MultiName)) continue;
            AuthCompilerPlug authCompilerPlug2 = null;
            MultiName multiName = (MultiName)name;
            String[] stringArray = multiName.getNamespace();
            String string3 = multiName.getLocalPart();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                string2 = stringArray[i].length() > 0 ? new StringBuffer().append(stringArray[i]).append(":").append(string3).toString() : string3;
                if (string == "i" || string == "s") {
                    authCompilerPlug2 = AuthBatchCompiler.findClass(string2, authCompilerPlug);
                } else if (string == "n" || string == "e") {
                    authCompilerPlug2 = AuthBatchCompiler.findDefinition(string2, false, authCompilerPlug);
                }
                if (authCompilerPlug2 != null) break;
            }
            iterator.remove();
            if (authCompilerPlug2 != null) {
                arrayList.add(new TempDependencyHolder(authCompilerPlug, authCompilerPlug2, string, string2));
                continue;
            }
            if (flashConfigDir == null) continue;
            System.err.println(new StringBuffer().append(multiName.toString()).append(" not resolved").toString());
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            AuthBatchCompiler.addDependency((TempDependencyHolder)((Object)iterator.next()), set, set2);
        }
    }

    private static void fa_part1(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            AuthCompilerPlug authCompilerPlug = (AuthCompilerPlug)plugs.get(i);
            if (authCompilerPlug.noParse || authCompilerPlug.context.errorCount() != 0 || authCompilerPlug.node.state != 1) continue;
            authCompilerPlug.context.pushScope(new ObjectValue(authCompilerPlug.context, (Builder)new GlobalBuilder(), null));
            authCompilerPlug.flowAnalyzer = new FlowAnalyzer((Emitter)new FlowGraphEmitter(authCompilerPlug.context, authCompilerPlug.pathspec, false));
            authCompilerPlug.node.evaluate(authCompilerPlug.context, (Evaluator)authCompilerPlug.flowAnalyzer);
            authCompilerPlug.context.popScope();
            authCompilerPlug.unit.typeInfo = authCompilerPlug.node.frame;
            if (authCompilerPlug.isSwcPlug) continue;
            AuthBatchCompiler.mainplug.handler.proxyHandler = authCompilerPlug.handler;
            int n3 = compilerExtensions.size();
            for (int j = 0; j < n3; ++j) {
                if (authCompilerPlug.context.errorCount() != 0) continue;
                try {
                    compilerExtensions.get(j).analyze1(authCompilerPlug.unit, typeTable);
                    continue;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    throw outOfMemoryError;
                }
                catch (Throwable throwable) {
                    if (flashConfigDir == null) continue;
                    System.err.println(new StringBuffer().append("Exception running analyze1() on plug ").append(authCompilerPlug.handlerKey).append("with Extension ").append(compilerExtensions.get(j).toString()).toString());
                    throwable.printStackTrace();
                }
            }
            AuthBatchCompiler.mainplug.handler.proxyHandler = null;
        }
    }

    private static void resolveInheritance(int n, int n2) throws Throwable {
        for (int i = n; i < n2; ++i) {
            AuthCompilerPlug authCompilerPlug = (AuthCompilerPlug)plugs.get(i);
            if (authCompilerPlug.noParse) continue;
            if (authCompilerPlug.abc == null) {
                AuthBatchCompiler.resolveDependenciesForNode(authCompilerPlug, authCompilerPlug.node.fa_unresolved, "i", INHERITANCE_processedDependCache, INHERITANCE_unprocessedDependCache);
                AuthBatchCompiler.resolveDependenciesForNode(authCompilerPlug, authCompilerPlug.node.ns_unresolved, "n", NAMESPACE_processedDependCache, NAMESPACE_unprocessedDependCache);
                AuthBatchCompiler.resolveMultiNameDependencies(authCompilerPlug, "i", INHERITANCE_processedDependCache, INHERITANCE_unprocessedDependCache);
                AuthBatchCompiler.resolveMultiNameDependencies(authCompilerPlug, "n", NAMESPACE_processedDependCache, NAMESPACE_unprocessedDependCache);
                continue;
            }
            AuthBatchCompiler.resolveDependenciesForSwcPlug(authCompilerPlug, "i", INHERITANCE_processedDependCache, INHERITANCE_unprocessedDependCache);
            AuthBatchCompiler.resolveDependenciesForSwcPlug(authCompilerPlug, "n", NAMESPACE_processedDependCache, NAMESPACE_unprocessedDependCache);
        }
    }

    private static void sortInheritance() throws Throwable {
        int n = plugs.size();
        final ObjectList objectList = new ObjectList(n);
        Algorithms.topologicalSort((Graph)inheritanceGraph, (Visitor)new Visitor<AuthCompilerPlug>(){

            public void visit(Vertex<AuthCompilerPlug> vertex) {
                objectList.add(vertex.getWeight());
            }
        });
        int n2 = objectList.size();
        if (n > n2) {
            for (int i = 0; i < n; ++i) {
                int n3;
                AuthCompilerPlug authCompilerPlug = (AuthCompilerPlug)plugs.get(i);
                for (n3 = 0; n3 < n2 && objectList.get(n3) != authCompilerPlug; ++n3) {
                }
                if (n3 != n2) continue;
                ThreadLocalToolkit.log((CompilerMessage)new CompilerAPI.CircularInheritance(), authCompilerPlug.source);
            }
            throw new CircularInheritanceException();
        }
        plugs = objectList;
    }

    private static void addGeneratedSources(int n, int n2) throws Throwable {
        for (int i = n; i < n2; ++i) {
            Object object;
            AuthCompilerPlug authCompilerPlug = (AuthCompilerPlug)plugs.get(i);
            CompilationUnit compilationUnit = authCompilerPlug.unit;
            if (compilationUnit == null) continue;
            Map<QName, Source> map = compilationUnit.getGeneratedSources();
            if (map != null) {
                for (QName qName : map.keySet()) {
                    object = map.get(qName);
                    String string = ((Source)object).getName();
                    AuthCompilerPlug authCompilerPlug2 = new AuthCompilerPlug();
                    authCompilerPlug2.classname = Util.colonClassnameToDotClassname(qName.toString());
                    authCompilerPlug2.scriptname = authCompilerPlug2.filename = string;
                    authCompilerPlug2.lastModified = ((Source)object).getLastModified();
                    authCompilerPlug2.setHandlerKey(authCompilerPlug2.filename);
                    authCompilerPlug2.source = object;
                    authCompilerPlug2.rslPreloaderPlug = generatingRSLPreloaderPlugs && (AuthBatchCompiler.mainplug.flags & 0x2000) != 0;
                    plugs.add((Object)authCompilerPlug2);
                    authCompilerPlug2.context = new Context(contextStatics);
                    authCompilerPlug2.context.setScriptName(authCompilerPlug2.filename);
                    authCompilerPlug2.context.setPath(null);
                    authCompilerPlug2.context.config_vars = AuthBatchCompiler.mainplug.configs;
                    authCompilerPlug2.emitter = new ActionBlockEmitter(authCompilerPlug2.context, authCompilerPlug2.filename, (PrintWriter)new StringPrintWriter(), (PrintWriter)new StringPrintWriter(), false, false, false, (AuthBatchCompiler.mainplug.flags & 1) != 0);
                    inheritanceGraph.addVertexForPlug(authCompilerPlug2);
                    AuthBatchCompiler.addDependency(authCompilerPlug, authCompilerPlug2, "e", qName.toString(), EXPRESSION_processedDependCache, EXPRESSION_unprocessedDependCache);
                }
                compilationUnit.clearGeneratedSources();
            }
            if ((!authCompilerPlug.isSwcPlug || authCompilerPlug.isInternal) && !authCompilerPlug.compiledClipSymbol || authCompilerPlug.swfTagDependencies != null || flaLibraryLinkageClasses.contains(authCompilerPlug.classname)) continue;
            Object object3 = authCompilerPlug.swcScript;
            if (object3 == null && !authCompilerPlug.isSwcPlug) {
                String string = Util.dotClassnameToColonClassname(authCompilerPlug.classname);
                object3 = hashSwcGroup.getScriptMap().get(string);
            }
            if (object3 == null) continue;
            authCompilerPlug.swfTagDependencies = new HashSet<DefineTag>();
            DefineTag defineTag = ((SwcScript)object3).getLibrary().getSymbol(authCompilerPlug.classname);
            if (defineTag == null) continue;
            AuthBatchCompiler.includePlugsForReferencedTags((Tag)defineTag, authCompilerPlug);
            object = new HashMap(1);
            object.put("swfTagDependencies", authCompilerPlug.swfTagDependencies);
            compilationUnit.getAssets().add(authCompilerPlug.classname, new AssetInfo(defineTag, authCompilerPlug.source.getBackingFile(), ((SwcScript)object3).getLastModified(), (Map<String, Object>)object));
        }
    }

    private static void includePlugsForReferencedTags(Tag tag, AuthCompilerPlug authCompilerPlug) throws Throwable {
        Iterator iterator = tag.getReferences();
        while (iterator.hasNext()) {
            AuthCompilerPlug authCompilerPlug2;
            Tag tag2 = (Tag)iterator.next();
            AuthBatchCompiler.includePlugsForReferencedTags(tag2, authCompilerPlug);
            if (!(tag2 instanceof DefineTag)) continue;
            DefineTag defineTag = (DefineTag)tag2;
            if (defineTag.name == null || (authCompilerPlug2 = AuthBatchCompiler.findClass(Util.dotClassnameToColonClassname(defineTag.name), authCompilerPlug)) == null) continue;
            authCompilerPlug.swfTagDependencies.add(defineTag);
        }
    }

    private static void fa_part2() throws Throwable {
        AuthBatchCompiler.inheritSlots("i");
        AuthBatchCompiler.inheritSlots("n");
        int n = plugs.size();
        for (int i = 0; i < n; ++i) {
            AuthCompilerPlug authCompilerPlug = (AuthCompilerPlug)plugs.get(i);
            if (authCompilerPlug.context.errorCount() == 0 && authCompilerPlug.node.state == 2 && authCompilerPlug.flowAnalyzer != null) {
                authCompilerPlug.context.pushScope(authCompilerPlug.node.frame);
                authCompilerPlug.node.evaluate(authCompilerPlug.context, (Evaluator)authCompilerPlug.flowAnalyzer);
                authCompilerPlug.context.popScope();
            }
            if (authCompilerPlug.isSwcPlug) continue;
            AuthBatchCompiler.mainplug.handler.proxyHandler = authCompilerPlug.handler;
            int n2 = compilerExtensions.size();
            for (int j = 0; j < n2; ++j) {
                if (authCompilerPlug.context.errorCount() != 0) continue;
                try {
                    compilerExtensions.get(j).analyze2(authCompilerPlug.unit, typeTable);
                    continue;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    throw outOfMemoryError;
                }
                catch (Throwable throwable) {
                    if (flashConfigDir == null) continue;
                    System.err.println(new StringBuffer().append("Exception running analyze2() on plug ").append(authCompilerPlug.handlerKey).append("with Extension ").append(compilerExtensions.get(j).toString()).toString());
                    throwable.printStackTrace();
                }
            }
            AuthBatchCompiler.mainplug.handler.proxyHandler = null;
        }
    }

    private static void resolveType() throws Throwable {
        AuthCompilerPlug authCompilerPlug;
        int n;
        int n2 = plugs.size();
        for (n = 0; n < n2; ++n) {
            authCompilerPlug = (AuthCompilerPlug)plugs.get(n);
            if (authCompilerPlug.node == null) break;
            if (authCompilerPlug.abc == null) {
                AuthBatchCompiler.resolveDependenciesForNode(authCompilerPlug, authCompilerPlug.node.ce_unresolved, "s", SIGNATURE_processedDependCache, SIGNATURE_unprocessedDependCache);
                continue;
            }
            AuthBatchCompiler.resolveDependenciesForSwcPlug(authCompilerPlug, "s", SIGNATURE_processedDependCache, SIGNATURE_unprocessedDependCache);
        }
        n2 = plugs.size();
        for (n = 0; n < n2; ++n) {
            authCompilerPlug = (AuthCompilerPlug)plugs.get(n);
            if (authCompilerPlug.node == null) break;
            if (authCompilerPlug.abc != null) continue;
            AuthBatchCompiler.resolveDependenciesForNode(authCompilerPlug, authCompilerPlug.node.body_unresolved, "s", SIGNATURE_processedDependCache, SIGNATURE_unprocessedDependCache);
            AuthBatchCompiler.resolveMultiNameDependencies(authCompilerPlug, "s", SIGNATURE_processedDependCache, SIGNATURE_unprocessedDependCache);
        }
        n2 = plugs.size();
        for (n = 0; n < n2; ++n) {
            authCompilerPlug = (AuthCompilerPlug)plugs.get(n);
            if (authCompilerPlug.node == null) break;
            if (authCompilerPlug.abc != null) continue;
            AuthBatchCompiler.resolveDependenciesForNode(authCompilerPlug, authCompilerPlug.node.ns_unresolved, "n", NAMESPACE_processedDependCache, NAMESPACE_unprocessedDependCache);
            AuthBatchCompiler.resolveMultiNameDependencies(authCompilerPlug, "n", NAMESPACE_processedDependCache, NAMESPACE_unprocessedDependCache);
        }
    }

    private static void ce_part1() {
        int n = plugs.size();
        for (int i = 0; i < n; ++i) {
            AuthCompilerPlug authCompilerPlug = (AuthCompilerPlug)plugs.get(i);
            if (authCompilerPlug.constEval != null || authCompilerPlug.context.errorCount() != 0 || authCompilerPlug.emitter == null) continue;
            authCompilerPlug.context.pushScope(authCompilerPlug.node.frame);
            if (!((AuthBatchCompiler.mainplug.flags & 0x400) == 0 && authCompilerPlug.isSwcPlug || authCompilerPlug.isInternal)) {
                MetaDataEvaluator metaDataEvaluator = new MetaDataEvaluator(true);
                authCompilerPlug.node.evaluate(authCompilerPlug.context, (Evaluator)metaDataEvaluator);
            }
            authCompilerPlug.constEval = new ConstantEvaluator(authCompilerPlug.context);
            authCompilerPlug.constEval.PreprocessDefinitionTypeInfo(authCompilerPlug.context, authCompilerPlug.node);
            authCompilerPlug.context.popScope();
            if (authCompilerPlug.isSwcPlug) continue;
            AuthBatchCompiler.mainplug.handler.proxyHandler = authCompilerPlug.handler;
            int n2 = compilerExtensions.size();
            for (int j = 0; j < n2; ++j) {
                if (authCompilerPlug.context.errorCount() != 0) continue;
                try {
                    compilerExtensions.get(j).analyze3(authCompilerPlug.unit, typeTable);
                    continue;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    throw outOfMemoryError;
                }
                catch (Throwable throwable) {
                    if (flashConfigDir == null) continue;
                    System.err.println(new StringBuffer().append("Exception running analyze3() on plug ").append(authCompilerPlug.handlerKey).append("with Extension ").append(compilerExtensions.get(j).toString()).toString());
                    throwable.printStackTrace();
                }
            }
            AuthBatchCompiler.mainplug.handler.proxyHandler = null;
        }
    }

    private static void ce_part2() {
        int n = plugs.size();
        for (int i = 0; i < n; ++i) {
            AuthCompilerPlug authCompilerPlug = (AuthCompilerPlug)plugs.get(i);
            if (authCompilerPlug.node == null) break;
            if (authCompilerPlug.context.errorCount() == 0 && authCompilerPlug.emitter != null) {
                if (authCompilerPlug.constEval == null) continue;
                authCompilerPlug.context.pushScope(authCompilerPlug.node.frame);
                AuthBatchCompiler.processUnresolvedNamespacesForFrames(authCompilerPlug);
                authCompilerPlug.node.evaluate(authCompilerPlug.context, (Evaluator)authCompilerPlug.constEval);
                authCompilerPlug.context.popScope();
            }
            if (authCompilerPlug.context.errorCount() == 0 && symbolTable != null) {
                Map<String, AbcClass> map = typeTable.createClasses(authCompilerPlug.node.clsdefs, authCompilerPlug.unit.topLevelDefinitions);
                for (String string : map.keySet()) {
                    AbcClass abcClass = map.get(string);
                    symbolTable.registerClass(string, abcClass);
                    authCompilerPlug.unit.classTable.put(string, abcClass);
                }
            }
            if (authCompilerPlug.isSwcPlug) continue;
            AuthBatchCompiler.mainplug.handler.proxyHandler = authCompilerPlug.handler;
            int n2 = compilerExtensions.size();
            for (int j = 0; j < n2; ++j) {
                if (authCompilerPlug.context.errorCount() != 0) continue;
                try {
                    compilerExtensions.get(j).analyze4(authCompilerPlug.unit, typeTable);
                    continue;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    throw outOfMemoryError;
                }
                catch (Throwable throwable) {
                    if (flashConfigDir == null) continue;
                    System.err.println(new StringBuffer().append("Exception running analyze4() on plug ").append(authCompilerPlug.handlerKey).append("with Extension ").append(compilerExtensions.get(j).toString()).toString());
                    throwable.printStackTrace();
                }
            }
            AuthBatchCompiler.mainplug.handler.proxyHandler = null;
        }
    }

    private static void processUnresolvedNamespacesForFrames(AuthCompilerPlug authCompilerPlug) {
        if (authCompilerPlug == null || authCompilerPlug.includes == null || authCompilerPlug.includes.size() == 0) {
            return;
        }
        for (AuthIncludeInfo authIncludeInfo : authCompilerPlug.includes) {
            if (authIncludeInfo == null || authIncludeInfo.cx == null) continue;
            authIncludeInfo.cx.processUnresolvedNamespaces();
        }
    }

    private static void lintEvaluate() throws Throwable {
        int n = plugs.size();
        for (int i = 0; i < n; ++i) {
            LintEvaluator lintEvaluator;
            AuthCompilerPlug authCompilerPlug;
            block4: {
                authCompilerPlug = (AuthCompilerPlug)plugs.get(i);
                if (authCompilerPlug.abc != null || authCompilerPlug.isSwcPlug || authCompilerPlug.context.errorCount() != 0 || authCompilerPlug.emitter == null) continue;
                authCompilerPlug.context.pushScope(authCompilerPlug.node.frame);
                lintEvaluator = new LintEvaluator(authCompilerPlug.context, authCompilerPlug.handlerKey, AuthBatchCompiler.mainplug.enabled_file);
                try {
                    authCompilerPlug.node.evaluate(authCompilerPlug.context, (Evaluator)lintEvaluator);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    throw outOfMemoryError;
                }
                catch (Throwable throwable) {
                    if (flashConfigDir == null) break block4;
                    System.err.println(new StringBuffer().append("Exception running lintEvaluate() on plug ").append(authCompilerPlug.handlerKey).toString());
                    throwable.printStackTrace();
                }
            }
            lintEvaluator.setOutputToFile(false);
            lintEvaluator.logWarnings(authCompilerPlug.context);
            lintEvaluator.clear();
            authCompilerPlug.context.popScope();
        }
    }

    private static String uiactionEvaluate(Context context, ProgramNode programNode) throws Throwable {
        UIActionsEvaluator uIActionsEvaluator = new UIActionsEvaluator(context);
        uIActionsEvaluator.evaluate(context, programNode);
        ObjectList objectList = context.getComments();
        UIActionList uIActionList = uIActionsEvaluator.getActionList();
        Object object = objectList.listIterator();
        block11: while (object.hasNext()) {
            Object object2;
            int n;
            int n2;
            CommentNode commentNode = (CommentNode)object.next();
            int n3 = n2 = commentNode.getPosition();
            UIActionComment uIActionComment = new UIActionComment();
            String string = commentNode.toString();
            if (string.length() == 0) {
                switch (commentNode.getType()) {
                    case -130: {
                        string = "/**/";
                        break;
                    }
                    case -131: {
                        string = "//";
                    }
                }
            } else if (n2 > -1) {
                String string2 = context.input.source();
                n = 0;
                switch (commentNode.getType()) {
                    case -130: {
                        n = n2 - 1;
                        if (n > -1 && n < string2.length() - 2 && string2.charAt(n) == '/' && string2.charAt(n + 1) == '*') {
                            n2 = n;
                        }
                        n3 = string2.indexOf("*/", n2) + 2;
                        break;
                    }
                    case -131: {
                        n = n2;
                        if (n > -1 && n < string2.length() - 2) {
                            if (string2.charAt(n) == '/' && string2.charAt(n + 1) == '/') {
                                n2 = n;
                            } else {
                                n = n2 - 1;
                                if (n > -1 && n < string2.length() - 2 && string2.charAt(n) == '/' && string2.charAt(n + 1) == '/') {
                                    n2 = n;
                                }
                            }
                        }
                        n3 = string2.indexOf(13, n2);
                    }
                }
                if (n3 > -1) {
                    object2 = string2.substring(n2, n3);
                    String string3 = "";
                    for (int i = 0; i < object2.length(); ++i) {
                        switch (object2.charAt(i)) {
                            case '\\': {
                                int n4 = i + 1;
                                if (n4 >= object2.length() || object2.charAt(n4) != '0' || ++n4 >= object2.length() || object2.charAt(n4) != '0') break;
                                i = n4;
                                string3 = new StringBuffer().append(string3).append("/x00").toString();
                            }
                        }
                        string3 = new StringBuffer().append(string3).append(object2.charAt(i)).toString();
                    }
                    string = string3;
                }
            }
            uIActionComment.SetComment(string);
            if (uIActionList == null) continue;
            int n5 = -1;
            if (uIActionList.size() > 0) {
                n5 = ((UIAction)((Object)uIActionList.lastElement())).GetNodeStartPosition();
            }
            if (n5 != -1 && n2 > n5) {
                uIActionList.add(uIActionComment);
                continue;
            }
            for (n = 0; n < uIActionList.size(); ++n) {
                object2 = (UIAction)((Object)uIActionList.elementAt(n));
                int n6 = ((UIAction)((Object)object2)).GetNodeStartPosition();
                if (n2 < n6) {
                    uIActionList.insertElementAt(uIActionComment, n);
                    continue block11;
                }
                if (((UIAction)((Object)object2)).GetActionType() == UIAction.kCallFunction && ((UIAction)((Object)object2)).GetNodeEndPosition() > n2) continue block11;
            }
        }
        object = "<?xml version=\"1.0\"?> <UIActionList> ";
        if (uIActionList != null) {
            for (int i = 0; i < uIActionList.size(); ++i) {
                UIAction uIAction = (UIAction)((Object)uIActionList.elementAt(i));
                object = new StringBuffer().append((String)object).append(uIAction.toXML()).toString();
            }
        }
        object = new StringBuffer().append((String)object).append(" </UIActionList>").toString();
        return object;
    }

    private static boolean isSubclass(macromedia.asc.semantics.QName qName, ClassBuilder classBuilder) {
        String string;
        String string2 = Util.colonClassnameToDotClassname(classBuilder.classname.toString());
        if (string2.compareTo(string = Util.colonClassnameToDotClassname(qName.toString())) == 0) {
            return true;
        }
        if (classBuilder.basebui != null && classBuilder.basebui instanceof ClassBuilder) {
            return AuthBatchCompiler.isSubclass(qName, classBuilder.basebui);
        }
        return false;
    }

    private static void checkBaseClasses() {
        int n = plugs.size();
        for (int i = 0; i < n; ++i) {
            boolean bl;
            AuthCompilerPlug authCompilerPlug = (AuthCompilerPlug)plugs.get(i);
            String string = authCompilerPlug.expectedBaseClass;
            boolean bl2 = bl = authCompilerPlug.class_provided && authCompilerPlug.make_movieclip || authCompilerPlug.base_classname != null && !authCompilerPlug.base_classname.equals(authCompilerPlug.expectedBaseClass);
            if (!bl || string == null || string.length() <= 0 || authCompilerPlug.node == null || authCompilerPlug.node.clsdefs == null || authCompilerPlug.node.clsdefs.size() <= 0) continue;
            ClassDefinitionNode classDefinitionNode = (ClassDefinitionNode)authCompilerPlug.node.clsdefs.get(0);
            if (classDefinitionNode.cframe == null || classDefinitionNode.cframe.builder == null) continue;
            boolean bl3 = AuthBatchCompiler.isSubclass(new macromedia.asc.semantics.QName(null, string), (ClassBuilder)classDefinitionNode.cframe.builder);
            if (!bl3 && string.equals("flash.display.MovieClip")) {
                bl3 = AuthBatchCompiler.isSubclass(new macromedia.asc.semantics.QName(null, "flash.display.Sprite"), (ClassBuilder)classDefinitionNode.cframe.builder);
            }
            if (bl3 || authCompilerPlug.handler == null || mainplug != null && AuthBatchCompiler.mainplug.swcFileName != null && AuthBatchCompiler.mainplug.swcFileName.equals("dummy_for_GenerateClassXML")) continue;
            String string2 = authCompilerPlug.class_provided ? authCompilerPlug.classname : authCompilerPlug.base_classname;
            authCompilerPlug.handler.authError(5000, string2, string);
            ++AuthBatchCompiler.contextStatics.errCount;
        }
    }

    private static void markLoaderFramePlugs() throws Throwable {
        if (AuthBatchCompiler.contextStatics.errCount > 0) {
            return;
        }
        if ((AuthBatchCompiler.mainplug.flags & 0x6080) == 0) {
            block0: for (RSLInfo rSLInfo : extLibPathSwcsUsed.values()) {
                if (rSLInfo == null || rSLInfo.classes == null) continue;
                for (int i = 0; i < rSLInfo.classes.length; ++i) {
                    AuthCompilerPlug authCompilerPlug;
                    RSLClassInfo rSLClassInfo = rSLInfo.classes[i];
                    if (rSLClassInfo.flags != 0 || (authCompilerPlug = findDefinitionCache.get(Util.dotClassnameToColonClassname(rSLClassInfo.className))) == null || authCompilerPlug == AuthCompilerPlug.DEF_FOUND_PLUG || authCompilerPlug == AuthCompilerPlug.NO_DEF_FOUND_PLUG) continue;
                    authCompilerPlug.handler.authError(5010, rSLInfo.urls[0].rslURL, "");
                    continue block0;
                }
            }
            return;
        }
        if (AuthBatchCompiler.mainplug.docClassPlug == null || (AuthBatchCompiler.mainplug.flags & 0x80) == 0) {
            return;
        }
        AuthBatchCompiler.mainplug.docClassPlug.inLoaderFrame = false;
        Vertex<AuthCompilerPlug> vertex = dependencyGraph.addVertexForPlug(AuthBatchCompiler.mainplug.docClassPlug);
        AuthBatchCompiler.markLoaderFrameDeps(vertex, null);
        int n = plugs.size();
        for (int i = 0; i < n; ++i) {
            AuthCompilerPlug authCompilerPlug = (AuthCompilerPlug)plugs.get(i);
            if (authCompilerPlug.inLoaderFrame || !authCompilerPlug.onStageBeforeExportFrame) continue;
            AuthBatchCompiler.markLoaderFrameDeps(dependencyGraph.addVertexForPlug(authCompilerPlug), null);
        }
    }

    private static void markLoaderFrameDeps(Vertex<AuthCompilerPlug> vertex, AuthCompilerPlug authCompilerPlug) {
        Object object;
        List<RSLClassInfo> list;
        AuthCompilerPlug authCompilerPlug2 = (AuthCompilerPlug)vertex.getWeight();
        if (authCompilerPlug2.isInternal && (AuthBatchCompiler.mainplug.flags & 0x6000) == 0) {
            RSLInfo rSLInfo = extLibPathSwcsUsed.get(authCompilerPlug2.swcFilePath);
            if (rSLInfo != null) {
                List<RSLClassInfo> list2;
                boolean bl = true;
                if (authCompilerPlug == null) {
                    bl = false;
                } else if (rslClassMap != null && (list2 = rslClassMap.get(authCompilerPlug.classname)) != null) {
                    for (int i = 0; i < list2.size(); ++i) {
                        RSLClassInfo rSLClassInfo = list2.get(i);
                        if (rSLClassInfo.rslInfo != rSLInfo) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl) {
                    authCompilerPlug2.handler.authError(5011, rSLInfo.urls[0].rslURL, authCompilerPlug.classname);
                }
            }
            return;
        }
        if (authCompilerPlug2.inLoaderFrame) {
            return;
        }
        if (rslClassMap != null && (list = rslClassMap.get(authCompilerPlug2.classname)) != null) {
            for (int i = 0; i < list.size(); ++i) {
                object = list.get(i);
                if (((RSLClassInfo)object).flags != 0) continue;
                return;
            }
        }
        authCompilerPlug2.inLoaderFrame = true;
        Set set = vertex.getPredecessors();
        if (set != null) {
            object = set.iterator();
            while (object.hasNext()) {
                AuthBatchCompiler.markLoaderFrameDeps((Vertex<AuthCompilerPlug>)((Vertex)object.next()), authCompilerPlug2);
            }
        }
    }

    private static void codeGenerate() throws Throwable {
        if (AuthBatchCompiler.contextStatics.errCount > 0) {
            return;
        }
        if ((AuthBatchCompiler.mainplug.flags & 0x100) != 0) {
            doABCsToOptimize = new ArrayList(plugs.size());
            doABCsToOptimizeLoaderFrame = new ArrayList(plugs.size());
            if (rslPreloadingRequired && (AuthBatchCompiler.mainplug.flags & 0x2000) != 0 && (AuthBatchCompiler.mainplug.flags & 0x4000) == 0) {
                doABCsToOptimizeRSLLoader = new ArrayList();
            }
        }
        int n = plugs.size();
        for (int i = 0; i < n; ++i) {
            String string;
            AuthCompilerPlug authCompilerPlug = (AuthCompilerPlug)plugs.get(i);
            AuthCompilerHandler authCompilerHandler = authCompilerPlug.handler;
            if (authCompilerPlug.isInternal || authCompilerHandler == null) continue;
            if (authCompilerPlug.abc != null) {
                if ((AuthBatchCompiler.mainplug.flags & 0x100) != 0) {
                    string = new DoABC(null, 1);
                    ((DoABC)string).abc = authCompilerPlug.abc;
                    if (authCompilerPlug.rslPreloaderPlug) {
                        if (authCompilerPlug == contentSWFPlug) {
                            authCompilerHandler.writeBytes("", authCompilerPlug.abc, false, true);
                        } else {
                            doABCsToOptimizeRSLLoader.add((DoABC)string);
                        }
                    } else if (authCompilerPlug.inLoaderFrame) {
                        doABCsToOptimizeLoaderFrame.add((DoABC)string);
                    } else {
                        doABCsToOptimize.add((DoABC)string);
                    }
                } else {
                    string = "";
                    if (swcForExport != null) {
                        string = Util.dotClassnameToSlashClassname(authCompilerPlug.classname);
                    }
                    if (authCompilerPlug.rslPreloaderPlug) {
                        authCompilerHandler.writeBytes(string, authCompilerPlug.abc, authCompilerPlug != contentSWFPlug, true);
                    } else {
                        authCompilerHandler.writeBytes(string, authCompilerPlug.abc, authCompilerPlug.inLoaderFrame, false);
                    }
                }
                AuthBatchCompiler.createSwfTagsForPlug(authCompilerPlug);
            } else if (authCompilerPlug.context.errorCount() == 0 && authCompilerPlug.emitter != null) {
                authCompilerPlug.context.setEmitter((Emitter)authCompilerPlug.emitter);
                authCompilerPlug.context.pushScope(authCompilerPlug.node.frame);
                try {
                    String string2;
                    String string3;
                    string = new CodeGenerator(authCompilerPlug.context.getEmitter());
                    String string4 = "";
                    if ((AuthBatchCompiler.mainplug.flags & 1) != 0) {
                        string4 = authCompilerPlug.context.getErrorOrigin();
                        string3 = AuthBatchCompiler.getErrorOrigin(authCompilerPlug.classname, string4);
                        authCompilerPlug.context.setOrigin(string3);
                    }
                    authCompilerPlug.node.evaluate(authCompilerPlug.context, (Evaluator)string);
                    if ((AuthBatchCompiler.mainplug.flags & 1) != 0) {
                        authCompilerPlug.context.setOrigin(string4);
                    }
                    string3 = new ByteList();
                    authCompilerPlug.context.getEmitter().emit((ByteList)string3);
                    AuthBatchCompiler.mainplug.handler.proxyHandler = authCompilerPlug.handler;
                    int n2 = compilerExtensions.size();
                    for (int j = 0; j < n2; ++j) {
                        if (authCompilerPlug.context.errorCount() != 0) continue;
                        try {
                            compilerExtensions.get(j).generate(authCompilerPlug.unit, typeTable);
                            continue;
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            throw outOfMemoryError;
                        }
                        catch (Throwable throwable) {
                            if (flashConfigDir == null) continue;
                            System.err.println(new StringBuffer().append("Exception running generate() on plug ").append(authCompilerPlug.handlerKey).append("with Extension ").append(compilerExtensions.get(j).toString()).toString());
                            throwable.printStackTrace();
                        }
                    }
                    AuthBatchCompiler.mainplug.handler.proxyHandler = null;
                    authCompilerPlug.emitter = null;
                    if ((AuthBatchCompiler.mainplug.flags & 0x100) != 0) {
                        string2 = new DoABC(null, 1);
                        ((DoABC)string2).abc = string3.toByteArray(false);
                        if (authCompilerPlug.rslPreloaderPlug) {
                            if (authCompilerPlug == contentSWFPlug) {
                                authCompilerHandler.writeBytes("", (ByteList)string3, false, true);
                            } else {
                                doABCsToOptimizeRSLLoader.add((DoABC)string2);
                            }
                        } else if (authCompilerPlug.inLoaderFrame) {
                            doABCsToOptimizeLoaderFrame.add((DoABC)string2);
                        } else {
                            doABCsToOptimize.add((DoABC)string2);
                        }
                    } else {
                        string2 = "";
                        if (swcForExport != null) {
                            string2 = Util.dotClassnameToSlashClassname(authCompilerPlug.classname);
                        }
                        if (authCompilerPlug.rslPreloaderPlug) {
                            authCompilerHandler.writeBytes(string2, (ByteList)string3, authCompilerPlug != contentSWFPlug, true);
                        } else {
                            authCompilerHandler.writeBytes(string2, (ByteList)string3, authCompilerPlug.inLoaderFrame, false);
                        }
                    }
                    if (abcToParse != null) {
                        abcToParse.add(new ABCToParse(authCompilerPlug.context, (ByteList)string3));
                    }
                    AuthBatchCompiler.createSwfTagsForPlug(authCompilerPlug);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    throw outOfMemoryError;
                }
                catch (Throwable throwable) {
                    authCompilerPlug.handler.authError(5003, "", "");
                    throwable.printStackTrace();
                }
                authCompilerPlug.context.popScope();
            }
            if (authCompilerPlug != AuthBatchCompiler.mainplug.docClassPlug || authCompilerPlug.unit == null || authCompilerPlug.unit.swfMetaData == null || authCompilerPlug.context.errorCount() != 0) continue;
            AuthBatchCompiler.handleSwfMetadata(authCompilerPlug.unit.swfMetaData);
        }
    }

    private static void handleSwfMetadata(MetaData metaData) {
        String string;
        String string2;
        String string3;
        if (mainplug == null) {
            return;
        }
        AuthCompilerHandler authCompilerHandler = AuthBatchCompiler.mainplug.handler;
        if (authCompilerHandler == null) {
            return;
        }
        int n = AuthBatchCompiler.parseSwfMetadataInt(metaData, "width");
        int n2 = AuthBatchCompiler.parseSwfMetadataInt(metaData, "height");
        int n3 = AuthBatchCompiler.parseSwfMetadataInt(metaData, "frameRate");
        int n4 = AuthBatchCompiler.parseSwfMetadataInt(metaData, "scriptRecursionLimit");
        int n5 = AuthBatchCompiler.parseSwfMetadataInt(metaData, "scriptTimeLimit");
        int n6 = -1;
        String string4 = metaData.getValue("backgroundColor");
        if (string4 != null) {
            try {
                n6 = Integer.decode(string4);
            }
            catch (NumberFormatException numberFormatException) {
                ThreadLocalToolkit.log(new PreLink.InvalidBackgroundColor(string4));
            }
        }
        if ((string3 = metaData.getValue("widthPercent")) == null) {
            string3 = "";
        }
        if ((string2 = metaData.getValue("heightPercent")) == null) {
            string2 = "";
        }
        if ((string = metaData.getValue("pageTitle")) == null) {
            string = "";
        }
        authCompilerHandler.handleSwfMetadata(n, n2, n3, n6, n4, n5, string3, string2, string);
    }

    private static int parseSwfMetadataInt(MetaData metaData, String string) {
        String string2 = metaData.getValue(string);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                ThreadLocalToolkit.log(new PreLink.CouldNotParseNumber(string2, string));
            }
        }
        return -1;
    }

    public static int exportTagsForFrame(int n, boolean bl) throws IOException {
        if (!AuthBatchCompiler.initExportSwfTags(AuthBatchCompiler.mainplug.swfVersion, n)) {
            return n;
        }
        for (SwfTagBlockInfo swfTagBlockInfo : swfTagList) {
            if (!swfTagBlockInfo.exportInFirstFrame || swfTagBlockInfo.inLoaderFrame != bl) continue;
            AuthBatchCompiler.exportSwfTag(swfTagBlockInfo, false);
        }
        return authTagEncoder.getNextTagId();
    }

    public static int exportTagsForClass(int n, String string) throws IOException {
        if (!AuthBatchCompiler.initExportSwfTags(AuthBatchCompiler.mainplug.swfVersion, n)) {
            return n;
        }
        SwfTagBlockInfo swfTagBlockInfo = swfTagMap.get(string);
        if (swfTagBlockInfo != null) {
            AuthBatchCompiler.exportSwfTag(swfTagBlockInfo, true);
            if (swfTagBlockInfo.swfTagDependencies != null) {
                for (DefineTag defineTag : swfTagBlockInfo.swfTagDependencies) {
                    AuthBatchCompiler.mainplug.handler.writeTags(authTagEncoder.getId(defineTag), defineTag.name, null);
                }
            }
        }
        return authTagEncoder.getNextTagId();
    }

    private static boolean initExportSwfTags(int n, int n2) {
        if (swfTagList == null || swfTagList.isEmpty()) {
            return false;
        }
        if (authTagEncoder == null) {
            authTagEncoder = new AuthTagEncoder(n);
            authMovieEncoder = new AuthMovieEncoder(authTagEncoder, AuthBatchCompiler.mainplug.handler);
        }
        authTagEncoder.setNextTagId(n2);
        return true;
    }

    private static void exportSwfTag(SwfTagBlockInfo swfTagBlockInfo, boolean bl) throws IOException {
        if (!swfTagBlockInfo.tagExported) {
            DefineTag defineTag = swfTagBlockInfo.tag;
            authMovieEncoder.startSizeReportForTag(swfTagBlockInfo.className);
            authMovieEncoder.define((Tag)defineTag);
            int n = authTagEncoder.getPos();
            byte[] byArray = null;
            if (n > 0) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(authTagEncoder.getPos());
                authTagEncoder.writeTo(byteArrayOutputStream);
                byArray = byteArrayOutputStream.toByteArray();
            }
            defineTag.name = swfTagBlockInfo.className;
            AuthBatchCompiler.mainplug.handler.writeTags(authTagEncoder.getId(defineTag), swfTagBlockInfo.className, byArray);
            authTagEncoder.reset();
            swfTagBlockInfo.tagExported = true;
        } else if (bl) {
            AuthBatchCompiler.mainplug.handler.writeTags(authTagEncoder.getId(swfTagBlockInfo.tag), swfTagBlockInfo.className, null);
        }
    }

    private static void createSwfTagsForPlug(AuthCompilerPlug authCompilerPlug) throws IOException {
        if (swfTagList == null) {
            return;
        }
        Iterator<Map.Entry<String, AssetInfo>> iterator = authCompilerPlug.unit.getAssets().iterator();
        while (iterator.hasNext()) {
            DefineTag defineTag;
            Map.Entry<String, AssetInfo> entry = iterator.next();
            String string = entry.getKey();
            AssetInfo assetInfo = entry.getValue();
            if (flaLibraryLinkageClasses.contains(string) || (defineTag = assetInfo.getDefineTag()) == null) continue;
            SwfTagBlockInfo swfTagBlockInfo = swfTagMap.get(string);
            if (swfTagBlockInfo != null) {
                if (authCompilerPlug.inLoaderFrame) {
                    swfTagBlockInfo.inLoaderFrame = true;
                }
                if (!authCompilerPlug.exportInFirstFrame) continue;
                swfTagBlockInfo.exportInFirstFrame = true;
                continue;
            }
            Map<String, Object> map = assetInfo.getArgs();
            Set set = map == null ? null : (Set)map.get("swfTagDependencies");
            swfTagBlockInfo = new SwfTagBlockInfo(string, defineTag, authCompilerPlug, set);
            swfTagMap.put(string, swfTagBlockInfo);
            swfTagList.add(swfTagBlockInfo);
        }
    }

    private static String getErrorOrigin(String string, String string2) {
        if (string.length() == 0) {
            return string2;
        }
        try {
            int n;
            String string3 = "";
            String string4 = string;
            int n2 = string.indexOf(46);
            if (n2 > -1) {
                String string5;
                String string6 = string5 = string.substring(0, n2);
                int n3 = string2.lastIndexOf(new StringBuffer().append(File.separatorChar).append(string5).append(File.separatorChar).toString());
                if (n3 > -1) {
                    int n4 = string.lastIndexOf(46);
                    if (n4 > n2 + 1) {
                        string6 = string.substring(0, n4);
                        string6 = string6.replace('.', File.separatorChar);
                    }
                    if (n4 > -1) {
                        string4 = string.substring(n4 + 1);
                    }
                    string3 = string2.substring(0, n3);
                    string3 = new StringBuffer().append(string3).append(";").toString();
                    string3 = new StringBuffer().append(string3).append(string6).toString();
                    string3 = new StringBuffer().append(string3).append(";").toString();
                }
            }
            if ((n = string2.lastIndexOf(new StringBuffer().append(File.separatorChar).append(string4).append(".").toString())) > -1) {
                if (n2 == -1) {
                    string3 = string2.substring(0, n);
                    string3 = new StringBuffer().append(string3).append(";;").toString();
                }
                string3 = new StringBuffer().append(string3).append(string2.substring(n + 1)).toString();
                return string3;
            }
        }
        finally {
            return string2;
        }
        {
        }
    }

    private static void writeOptimizedABC() throws Throwable {
        if (AuthBatchCompiler.contextStatics.errCount > 0) {
            return;
        }
        try {
            if (doABCsToOptimize != null && !doABCsToOptimize.isEmpty()) {
                Optimizer.merge(doABCsToOptimize, (AuthBatchCompiler.mainplug.flags & 1) != 0, true, "");
            }
            if (doABCsToOptimizeLoaderFrame != null && !doABCsToOptimizeLoaderFrame.isEmpty()) {
                Optimizer.merge(doABCsToOptimizeLoaderFrame, (AuthBatchCompiler.mainplug.flags & 1) != 0, true, "");
            }
            if (doABCsToOptimizeRSLLoader != null && !doABCsToOptimizeRSLLoader.isEmpty()) {
                Optimizer.merge(doABCsToOptimizeRSLLoader, (AuthBatchCompiler.mainplug.flags & 1) != 0, true, "");
            }
            int n = plugs.size();
            for (int i = 0; i < n; ++i) {
                AuthCompilerPlug authCompilerPlug = (AuthCompilerPlug)plugs.get(i);
                AuthCompilerHandler authCompilerHandler = authCompilerPlug.handler;
                if (authCompilerPlug.isInternal || authCompilerHandler == null) continue;
                byte[] byArray = null;
                ArrayList<DoABC> arrayList = null;
                if (authCompilerPlug.rslPreloaderPlug) {
                    if (authCompilerPlug == contentSWFPlug || doABCsToOptimizeRSLLoader == null) continue;
                    arrayList = doABCsToOptimizeRSLLoader;
                    doABCsToOptimizeRSLLoader = null;
                    if (arrayList != null && arrayList.size() > 0) {
                        byArray = ((DoABC)arrayList.get((int)0)).abc;
                    }
                    authCompilerHandler.writeBytes("", byArray, true, true);
                    continue;
                }
                if (authCompilerPlug.inLoaderFrame) {
                    arrayList = doABCsToOptimizeLoaderFrame;
                    doABCsToOptimizeLoaderFrame = null;
                } else {
                    arrayList = doABCsToOptimize;
                    doABCsToOptimize = null;
                }
                if (arrayList != null && arrayList.size() > 0) {
                    byArray = ((DoABC)arrayList.get((int)0)).abc;
                }
                authCompilerHandler.writeBytes("", byArray, authCompilerPlug.inLoaderFrame, false);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw outOfMemoryError;
        }
        catch (Throwable throwable) {
            AuthBatchCompiler.mainplug.handler.authError(5005, "", "");
        }
    }

    public static void addBaseClassInstanceNames(String string, ObjectList<String> objectList, ObjectList<String> objectList2) throws Throwable {
        int n = plugs.size();
        for (int i = 0; i < n; ++i) {
            AuthCompilerPlug authCompilerPlug = (AuthCompilerPlug)plugs.get(i);
            if (!authCompilerPlug.classname.equals(string) || authCompilerPlug.numErrors >= 1) continue;
            if (authCompilerPlug.isSwcPlug) break;
            boolean bl = false;
            if (authCompilerPlug.instanceNameNames == null) {
                authCompilerPlug.instanceNameNames = objectList;
                authCompilerPlug.instanceNameTypes = objectList2;
                bl = true;
            } else {
                ObjectList<String> objectList3 = authCompilerPlug.instanceNameNames;
                ObjectList<String> objectList4 = authCompilerPlug.instanceNameTypes;
                int n2 = objectList3.size();
                int n3 = objectList.size();
                for (int j = 0; j < n3; ++j) {
                    String string2 = (String)objectList.get(j);
                    boolean bl2 = false;
                    for (int k = 0; k < n2; ++k) {
                        if (!string2.equals(objectList3.get(k))) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2) continue;
                    objectList3.add((Object)string2);
                    objectList4.add(objectList2.get(j));
                    bl = true;
                }
            }
            if (plugProcessingEnd <= i || !bl) break;
            authCompilerPlug.node = null;
            authCompilerPlug.source = null;
            authCompilerPlug.unit = null;
            authCompilerPlug.constEval = null;
            AuthBatchCompiler.removeDependencies("s", authCompilerPlug);
            AuthBatchCompiler.removeDependencies("n", authCompilerPlug);
            AuthBatchCompiler.removeDependencies("e", authCompilerPlug);
            AuthBatchCompiler.removeDependencies("i", authCompilerPlug);
            authCompilerPlug.make_movieclip = true;
            AuthBatchCompiler.initPlug(authCompilerPlug);
            plugs.remove(i);
            --plugProcessingEnd;
            plugs.add((Object)authCompilerPlug);
            break;
        }
    }

    private static void removeDependencies(String string, AuthCompilerPlug authCompilerPlug) {
        Set<GlobalDependencies.Pair> set = processedDependencies.getSetForType(string);
        Iterator<GlobalDependencies.Pair> iterator = set.iterator();
        while (iterator.hasNext()) {
            GlobalDependencies.Pair pair = iterator.next();
            if (pair.depPlug != authCompilerPlug) continue;
            iterator.remove();
        }
    }

    private static void resolveExpression() throws Throwable {
        int n = plugs.size();
        for (int i = 0; i < n; ++i) {
            AuthCompilerPlug authCompilerPlug = (AuthCompilerPlug)plugs.get(i);
            if (authCompilerPlug.node == null) break;
            if (authCompilerPlug.abc == null) {
                AuthBatchCompiler.resolveDependenciesForNode(authCompilerPlug, authCompilerPlug.node.rt_unresolved, "e", EXPRESSION_processedDependCache, EXPRESSION_unprocessedDependCache);
                AuthBatchCompiler.resolveMultiNameDependencies(authCompilerPlug, "e", EXPRESSION_processedDependCache, EXPRESSION_unprocessedDependCache);
                continue;
            }
            AuthBatchCompiler.resolveDependenciesForSwcPlug(authCompilerPlug, "e", EXPRESSION_processedDependCache, EXPRESSION_unprocessedDependCache);
        }
    }

    private static void inheritSlots(String string) {
        Set<GlobalDependencies.Pair> set = unprocessedDependencies.getSetForType(string);
        for (GlobalDependencies.Pair pair : set) {
            if (pair.depPlug.flowAnalyzer == null || pair.defPlug.node.frame == null || pair.depPlug.node.frame == null || pair.depPlug.node.frame.builder == null) continue;
            FlowAnalyzer cfr_ignored_0 = pair.depPlug.flowAnalyzer;
            FlowAnalyzer.inheritContextSlots((ObjectValue)pair.defPlug.node.frame, (ObjectValue)pair.depPlug.node.frame, (Builder)pair.depPlug.node.frame.builder, (Context)pair.depPlug.context);
        }
        Set<GlobalDependencies.Pair> set2 = processedDependencies.getSetForType(string);
        set2.addAll(set);
        set.clear();
    }

    private static void resolveImportStatements() throws Throwable {
        int n = plugs.size();
        for (int i = 0; i < n; ++i) {
            AuthCompilerPlug authCompilerPlug = (AuthCompilerPlug)plugs.get(i);
            if (authCompilerPlug.node == null) break;
            for (ReferenceValue referenceValue : authCompilerPlug.node.package_unresolved) {
                ObjectValue objectValue;
                if (!AuthBatchCompiler.hasPackage(referenceValue.name) || (objectValue = authCompilerPlug.context.getNamespace(referenceValue.name)) == null) continue;
                objectValue.setPackage(true);
            }
            for (ReferenceValue referenceValue : authCompilerPlug.node.import_def_unresolved) {
                macromedia.asc.semantics.QName qName;
                NamespaceValue namespaceValue;
                byte by;
                int n2 = 0;
                int n3 = referenceValue.namespaces.size();
                if (n2 >= n3 || (by = (namespaceValue = (NamespaceValue)referenceValue.namespaces.get(n2)).getNamespaceKind()) != 0 && by != 1 || !AuthBatchCompiler.hasDefinition(qName = new macromedia.asc.semantics.QName((ObjectValue)namespaceValue, referenceValue.name))) continue;
                authCompilerPlug.context.addValidImport(qName.toString());
            }
        }
    }

    private static void clear() {
        if (contextStatics != null) {
            contextStatics.clear();
        }
        ObjectValue.clear();
        if (contextStatics != null) {
            AuthBatchCompiler.contextStatics.handler = null;
        }
        TypeValue.clear();
    }

    private static boolean hasPackage(String string) {
        AuthCompilerPlug authCompilerPlug = hasPackageCache.get(string);
        if (authCompilerPlug == AuthCompilerPlug.DEF_FOUND_PLUG) {
            return true;
        }
        if (authCompilerPlug == AuthCompilerPlug.NO_DEF_FOUND_PLUG) {
            return false;
        }
        boolean bl = false;
        bl = swcPackageNames.contains(string) ? true : AuthBatchCompiler.mainplug.handler.hasPackage(string);
        if (bl) {
            hasPackageCache.put(string, AuthCompilerPlug.DEF_FOUND_PLUG);
        } else {
            hasPackageCache.put(string, AuthCompilerPlug.NO_DEF_FOUND_PLUG);
        }
        return bl;
    }

    private static boolean hasDefinition(macromedia.asc.semantics.QName qName) throws Throwable {
        return AuthBatchCompiler.findDefinition(qName, true, null) != null;
    }

    private static boolean hasDefinition(String string) throws Throwable {
        return AuthBatchCompiler.findDefinition(string, true, null) != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static AuthCompilerPlug findDefinition(macromedia.asc.semantics.QName qName, boolean bl, AuthCompilerPlug authCompilerPlug) throws Throwable {
        AuthCompilerPlug authCompilerPlug2;
        String string;
        AuthCompilerPlug authCompilerPlug3;
        block17: {
            authCompilerPlug3 = null;
            string = qName.toString();
            authCompilerPlug3 = findDefinitionCache.get(string);
            if (authCompilerPlug3 != null) {
                if (authCompilerPlug3 == AuthCompilerPlug.NO_DEF_FOUND_PLUG) {
                    return null;
                }
                if (bl) {
                    return authCompilerPlug3;
                }
                if (authCompilerPlug3 != AuthCompilerPlug.DEF_FOUND_PLUG) {
                    if (authCompilerPlug3.isPlayerglobalPlug && authCompilerPlug != null && authCompilerPlug.isSwcPlug && !authCompilerPlug.isPlayerglobalPlug) {
                        authCompilerPlug2 = AuthBatchCompiler.checkForSwcOverride(string, authCompilerPlug);
                        if (authCompilerPlug2 == null) {
                            return authCompilerPlug3;
                        }
                        authCompilerPlug3 = authCompilerPlug2;
                        break block17;
                    } else {
                        if (authCompilerPlug3.rslPreloaderPlug) return authCompilerPlug3;
                        if (!authCompilerPlug.rslPreloaderPlug) return authCompilerPlug3;
                        authCompilerPlug3.rslPreloaderPlug = true;
                        return authCompilerPlug3;
                    }
                }
                authCompilerPlug3 = null;
            }
        }
        authCompilerPlug2 = null;
        int n = plugs.size();
        block2: for (int i = 0; i < n && authCompilerPlug3 == null; ++i) {
            AuthCompilerPlug authCompilerPlug4 = (AuthCompilerPlug)plugs.get(i);
            if (authCompilerPlug4.node == null) break;
            try {
                if (authCompilerPlug4.isSwcPlug && authCompilerPlug2 == null) {
                    if (!authCompilerPlug4.unit.topLevelDefinitions.contains(new QName(string))) continue;
                    if (authCompilerPlug4.linkedToLibrarySymbol) {
                        authCompilerPlug3 = authCompilerPlug4;
                        break;
                    }
                    authCompilerPlug2 = authCompilerPlug4;
                    break;
                }
                Names names = authCompilerPlug4.node.frame.builder.getNames();
                for (int j = 0; j < 4; ++j) {
                    if (!names.containsKey(qName.name, qName.ns, j)) continue;
                    authCompilerPlug3 = authCompilerPlug4;
                    continue block2;
                }
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (authCompilerPlug3 == null) {
            authCompilerPlug3 = AuthBatchCompiler.searchClasspath(string, bl, authCompilerPlug);
        }
        if (authCompilerPlug3 == null && authCompilerPlug2 != null) {
            authCompilerPlug3 = authCompilerPlug2;
        }
        if (authCompilerPlug3 == null) {
            authCompilerPlug3 = AuthBatchCompiler.searchSwcGroup(string, bl, null, authCompilerPlug);
        }
        if (authCompilerPlug3 == null) {
            findDefinitionCache.put(string, AuthCompilerPlug.NO_DEF_FOUND_PLUG);
            return authCompilerPlug3;
        }
        findDefinitionCache.put(string, authCompilerPlug3);
        if (authCompilerPlug3 == AuthCompilerPlug.DEF_FOUND_PLUG) return authCompilerPlug3;
        if (authCompilerPlug == null) return authCompilerPlug3;
        AuthBatchCompiler.setUpNewResultPlug(authCompilerPlug3, authCompilerPlug);
        return authCompilerPlug3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static AuthCompilerPlug findDefinition(String string, boolean bl, AuthCompilerPlug authCompilerPlug) throws Throwable {
        AuthCompilerPlug authCompilerPlug2;
        AuthCompilerPlug authCompilerPlug3;
        block17: {
            authCompilerPlug3 = null;
            authCompilerPlug3 = findDefinitionCache.get(string);
            if (authCompilerPlug3 != null) {
                if (authCompilerPlug3 == AuthCompilerPlug.NO_DEF_FOUND_PLUG) {
                    return null;
                }
                if (bl) {
                    return authCompilerPlug3;
                }
                if (authCompilerPlug3 != AuthCompilerPlug.DEF_FOUND_PLUG) {
                    if (authCompilerPlug3.isPlayerglobalPlug && authCompilerPlug != null && authCompilerPlug.isSwcPlug && !authCompilerPlug.isPlayerglobalPlug) {
                        authCompilerPlug2 = AuthBatchCompiler.checkForSwcOverride(string, authCompilerPlug);
                        if (authCompilerPlug2 == null) {
                            return authCompilerPlug3;
                        }
                        authCompilerPlug3 = authCompilerPlug2;
                        break block17;
                    } else {
                        if (authCompilerPlug3.rslPreloaderPlug) return authCompilerPlug3;
                        if (!authCompilerPlug.rslPreloaderPlug) return authCompilerPlug3;
                        authCompilerPlug3.rslPreloaderPlug = true;
                        return authCompilerPlug3;
                    }
                }
                authCompilerPlug3 = null;
            }
        }
        authCompilerPlug2 = null;
        QName qName = new QName(string);
        String string2 = qName.getLocalPart();
        ObjectValue objectValue = ((AuthCompilerPlug)AuthBatchCompiler.plugs.get((int)0)).context.getNamespace(qName.getNamespace());
        int n = plugs.size();
        block2: for (int i = 0; i < n && authCompilerPlug3 == null; ++i) {
            AuthCompilerPlug authCompilerPlug4 = (AuthCompilerPlug)plugs.get(i);
            if (authCompilerPlug4.node == null) break;
            try {
                if (authCompilerPlug4.isSwcPlug && authCompilerPlug2 == null) {
                    if (!authCompilerPlug4.unit.topLevelDefinitions.contains(qName)) continue;
                    if (authCompilerPlug4.linkedToLibrarySymbol) {
                        authCompilerPlug3 = authCompilerPlug4;
                        break;
                    }
                    authCompilerPlug2 = authCompilerPlug4;
                    break;
                }
                Names names = authCompilerPlug4.node.frame.builder.getNames();
                for (int j = 0; j < 4; ++j) {
                    if (!names.containsKey(string2, objectValue, j)) continue;
                    authCompilerPlug3 = authCompilerPlug4;
                    continue block2;
                }
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (authCompilerPlug3 == null) {
            authCompilerPlug3 = AuthBatchCompiler.searchClasspath(string, bl, authCompilerPlug);
        }
        if (authCompilerPlug3 == null && authCompilerPlug2 != null) {
            authCompilerPlug3 = authCompilerPlug2;
        }
        if (authCompilerPlug3 == null) {
            authCompilerPlug3 = AuthBatchCompiler.searchSwcGroup(string, bl, null, authCompilerPlug);
        }
        if (authCompilerPlug3 == null) {
            findDefinitionCache.put(string, AuthCompilerPlug.NO_DEF_FOUND_PLUG);
            return authCompilerPlug3;
        }
        findDefinitionCache.put(string, authCompilerPlug3);
        if (authCompilerPlug3 == AuthCompilerPlug.DEF_FOUND_PLUG) return authCompilerPlug3;
        if (authCompilerPlug == null) return authCompilerPlug3;
        AuthBatchCompiler.setUpNewResultPlug(authCompilerPlug3, authCompilerPlug);
        return authCompilerPlug3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static AuthCompilerPlug findClass(macromedia.asc.semantics.QName qName, AuthCompilerPlug authCompilerPlug) throws Throwable {
        AuthCompilerPlug authCompilerPlug2;
        String string;
        AuthCompilerPlug authCompilerPlug3;
        block16: {
            authCompilerPlug3 = null;
            string = qName.toString();
            authCompilerPlug3 = findDefinitionCache.get(string);
            if (authCompilerPlug3 != null) {
                if (authCompilerPlug3 == AuthCompilerPlug.NO_DEF_FOUND_PLUG) {
                    return null;
                }
                if (authCompilerPlug3 != AuthCompilerPlug.DEF_FOUND_PLUG) {
                    if (authCompilerPlug3.isPlayerglobalPlug && authCompilerPlug != null && authCompilerPlug.isSwcPlug && !authCompilerPlug.isPlayerglobalPlug) {
                        authCompilerPlug2 = AuthBatchCompiler.checkForSwcOverride(string, authCompilerPlug);
                        if (authCompilerPlug2 == null) {
                            return authCompilerPlug3;
                        }
                        authCompilerPlug3 = authCompilerPlug2;
                        break block16;
                    } else {
                        if (authCompilerPlug3.rslPreloaderPlug) return authCompilerPlug3;
                        if (!authCompilerPlug.rslPreloaderPlug) return authCompilerPlug3;
                        authCompilerPlug3.rslPreloaderPlug = true;
                        return authCompilerPlug3;
                    }
                }
                authCompilerPlug3 = null;
            }
        }
        authCompilerPlug2 = null;
        int n = plugs.size();
        block2: for (int i = 0; i < n && authCompilerPlug3 == null; ++i) {
            int n2;
            AuthCompilerPlug authCompilerPlug4 = (AuthCompilerPlug)plugs.get(i);
            if (authCompilerPlug4.node == null) break;
            if (authCompilerPlug4.isSwcPlug && authCompilerPlug2 == null) {
                if (!authCompilerPlug4.unit.topLevelDefinitions.contains(new QName(string))) continue;
                if (authCompilerPlug4.linkedToLibrarySymbol) {
                    authCompilerPlug3 = authCompilerPlug4;
                    break;
                }
                authCompilerPlug2 = authCompilerPlug4;
                break;
            }
            int n3 = n2 = authCompilerPlug4.node.clsdefs != null ? authCompilerPlug4.node.clsdefs.size() : 0;
            for (int j = 0; j < n2; ++j) {
                ClassDefinitionNode classDefinitionNode = (ClassDefinitionNode)authCompilerPlug4.node.clsdefs.get(j);
                try {
                    if (!classDefinitionNode.cframe.builder.classname.equals((Object)qName)) continue;
                    authCompilerPlug3 = authCompilerPlug4;
                    continue block2;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
        if (authCompilerPlug3 == null) {
            authCompilerPlug3 = AuthBatchCompiler.searchClasspath(string, false, authCompilerPlug);
        }
        if (authCompilerPlug3 == null && authCompilerPlug2 != null) {
            authCompilerPlug3 = authCompilerPlug2;
        }
        if (authCompilerPlug3 == null) {
            authCompilerPlug3 = AuthBatchCompiler.searchSwcGroup(string, false, null, authCompilerPlug);
        }
        if (authCompilerPlug3 == null) {
            findDefinitionCache.put(string, AuthCompilerPlug.NO_DEF_FOUND_PLUG);
            return authCompilerPlug3;
        }
        findDefinitionCache.put(string, authCompilerPlug3);
        if (authCompilerPlug3 == AuthCompilerPlug.DEF_FOUND_PLUG) return authCompilerPlug3;
        if (authCompilerPlug == null) return authCompilerPlug3;
        AuthBatchCompiler.setUpNewResultPlug(authCompilerPlug3, authCompilerPlug);
        return authCompilerPlug3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static AuthCompilerPlug findClass(String string, AuthCompilerPlug authCompilerPlug) throws Throwable {
        AuthCompilerPlug authCompilerPlug2;
        AuthCompilerPlug authCompilerPlug3;
        block16: {
            authCompilerPlug3 = null;
            authCompilerPlug3 = findDefinitionCache.get(string);
            if (authCompilerPlug3 != null) {
                if (authCompilerPlug3 == AuthCompilerPlug.NO_DEF_FOUND_PLUG) {
                    return null;
                }
                if (authCompilerPlug3 != AuthCompilerPlug.DEF_FOUND_PLUG) {
                    if (authCompilerPlug3.isPlayerglobalPlug && authCompilerPlug != null && authCompilerPlug.isSwcPlug && !authCompilerPlug.isPlayerglobalPlug) {
                        authCompilerPlug2 = AuthBatchCompiler.checkForSwcOverride(string, authCompilerPlug);
                        if (authCompilerPlug2 == null) {
                            return authCompilerPlug3;
                        }
                        authCompilerPlug3 = authCompilerPlug2;
                        break block16;
                    } else {
                        if (authCompilerPlug3.rslPreloaderPlug) return authCompilerPlug3;
                        if (!authCompilerPlug.rslPreloaderPlug) return authCompilerPlug3;
                        authCompilerPlug3.rslPreloaderPlug = true;
                        return authCompilerPlug3;
                    }
                }
                authCompilerPlug3 = null;
            }
        }
        authCompilerPlug2 = null;
        int n = plugs.size();
        block2: for (int i = 0; i < n && authCompilerPlug3 == null; ++i) {
            int n2;
            AuthCompilerPlug authCompilerPlug4 = (AuthCompilerPlug)plugs.get(i);
            if (authCompilerPlug4.node == null) break;
            if (authCompilerPlug4.isSwcPlug && authCompilerPlug2 == null) {
                if (!authCompilerPlug4.unit.topLevelDefinitions.contains(new QName(string))) continue;
                if (authCompilerPlug4.linkedToLibrarySymbol) {
                    authCompilerPlug3 = authCompilerPlug4;
                    break;
                }
                authCompilerPlug2 = authCompilerPlug4;
                break;
            }
            int n3 = n2 = authCompilerPlug4.node.clsdefs != null ? authCompilerPlug4.node.clsdefs.size() : 0;
            for (int j = 0; j < n2; ++j) {
                ClassDefinitionNode classDefinitionNode = (ClassDefinitionNode)authCompilerPlug4.node.clsdefs.get(j);
                try {
                    if (!classDefinitionNode.cframe.builder.classname.toString().equals(string)) continue;
                    authCompilerPlug3 = authCompilerPlug4;
                    continue block2;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
        if (authCompilerPlug3 == null) {
            authCompilerPlug3 = AuthBatchCompiler.searchClasspath(string, false, authCompilerPlug);
        }
        if (authCompilerPlug3 == null && authCompilerPlug2 != null) {
            authCompilerPlug3 = authCompilerPlug2;
        }
        if (authCompilerPlug3 == null) {
            authCompilerPlug3 = AuthBatchCompiler.searchSwcGroup(string, false, null, authCompilerPlug);
        }
        if (authCompilerPlug3 == null) {
            findDefinitionCache.put(string, AuthCompilerPlug.NO_DEF_FOUND_PLUG);
            return authCompilerPlug3;
        }
        findDefinitionCache.put(string, authCompilerPlug3);
        if (authCompilerPlug3 == AuthCompilerPlug.DEF_FOUND_PLUG) return authCompilerPlug3;
        if (authCompilerPlug == null) return authCompilerPlug3;
        AuthBatchCompiler.setUpNewResultPlug(authCompilerPlug3, authCompilerPlug);
        return authCompilerPlug3;
    }

    private static void setUpNewResultPlug(AuthCompilerPlug authCompilerPlug, AuthCompilerPlug authCompilerPlug2) {
        if (!authCompilerPlug.exportInFirstFrame && authCompilerPlug2.exportInFirstFrame && (!authCompilerPlug.linkedToLibrarySymbol || authCompilerPlug2.linkedToLibrarySymbol && authCompilerPlug2 != AuthBatchCompiler.mainplug.docClassPlug)) {
            authCompilerPlug.exportInFirstFrame = true;
        }
        if (!authCompilerPlug.rslPreloaderPlug && authCompilerPlug2.rslPreloaderPlug) {
            authCompilerPlug.rslPreloaderPlug = true;
        }
    }

    private static void resolvePlayerglobal() {
        int n;
        ArrayList<AuthCompilerPlug> arrayList = new ArrayList<AuthCompilerPlug>();
        ArrayList<AuthCompilerPlug> arrayList2 = new ArrayList<AuthCompilerPlug>();
        int n2 = plugs.size();
        for (n = 0; n < n2; ++n) {
            AuthCompilerPlug authCompilerPlug = (AuthCompilerPlug)plugs.get(n);
            if (authCompilerPlug.isPlayerglobalPlug) {
                arrayList.add(authCompilerPlug);
                continue;
            }
            if (authCompilerPlug.isSwcPlug) continue;
            arrayList2.add(authCompilerPlug);
        }
        n = arrayList.size();
        n2 = arrayList2.size();
        for (int i = 0; i < n2; ++i) {
            AuthCompilerPlug authCompilerPlug = (AuthCompilerPlug)arrayList2.get(i);
            for (int j = 0; j < n; ++j) {
                AuthBatchCompiler.addDependency(authCompilerPlug, (AuthCompilerPlug)arrayList.get(j), "e", "", EXPRESSION_processedDependCache, EXPRESSION_unprocessedDependCache);
            }
        }
        AuthBatchCompiler.inheritSlots("e");
    }

    private static AuthCompilerPlug checkForSwcOverride(String string, AuthCompilerPlug authCompilerPlug) {
        if (authCompilerPlug.swcScript == null) {
            return null;
        }
        AuthSwcLibrary authSwcLibrary = (AuthSwcLibrary)authCompilerPlug.swcScript.getLibrary();
        if (!authSwcLibrary.hasDefinition(Util.colonClassnameToSlashClassname(string))) {
            return null;
        }
        boolean bl = false;
        AuthSwcScript authSwcScript = null;
        if (hashSwcGroup != null) {
            authSwcScript = (AuthSwcScript)hashSwcGroup.getScriptMap().get(string);
        }
        if (authSwcScript == null && libPathSwcGroup != null) {
            authSwcScript = (AuthSwcScript)libPathSwcGroup.getScriptMap().get(string);
        }
        if (authSwcScript == null && extLibPathSwcGroup != null) {
            bl = true;
            authSwcScript = (AuthSwcScript)extLibPathSwcGroup.getScriptMap().get(string);
        }
        if (authSwcScript == null) {
            return null;
        }
        AuthCompilerPlug authCompilerPlug2 = authSwcScript.getPlug();
        if (authCompilerPlug2 != null) {
            AuthBatchCompiler.createSource(authCompilerPlug2);
            AuthBatchCompiler.createCompilationUnit(authCompilerPlug2);
            authCompilerPlug2.unit.topLevelDefinitions.add(new QName(string));
            return authCompilerPlug2;
        }
        return AuthBatchCompiler.initSwcPlug(null, authSwcScript, string, bl, false);
    }

    private static AuthCompilerPlug searchSwcGroup(String string, boolean bl, AuthCompilerPlug authCompilerPlug, AuthCompilerPlug authCompilerPlug2) {
        AuthCompilerPlug authCompilerPlug3;
        boolean bl2 = false;
        boolean bl3 = false;
        AuthSwcScript authSwcScript = null;
        if (playerGlobalSwcGroup != null && (authSwcScript = (AuthSwcScript)playerGlobalSwcGroup.getScriptMap().get(string)) != null) {
            if (!bl && authCompilerPlug2 != null && authCompilerPlug2.isSwcPlug && !authCompilerPlug2.isPlayerglobalPlug && (authCompilerPlug3 = AuthBatchCompiler.checkForSwcOverride(string, authCompilerPlug2)) != null) {
                return authCompilerPlug3;
            }
            bl3 = true;
            bl2 = true;
        }
        if (authSwcScript == null && hashSwcGroup != null) {
            authSwcScript = (AuthSwcScript)hashSwcGroup.getScriptMap().get(string);
        }
        if (authSwcScript == null && libPathSwcGroup != null) {
            authSwcScript = (AuthSwcScript)libPathSwcGroup.getScriptMap().get(string);
        }
        if (authSwcScript == null && extLibPathSwcGroup != null) {
            bl2 = true;
            authSwcScript = (AuthSwcScript)extLibPathSwcGroup.getScriptMap().get(string);
        }
        if (authSwcScript == null) {
            return null;
        }
        authCompilerPlug3 = authSwcScript.getPlug();
        if (authCompilerPlug3 != null) {
            if (!bl) {
                AuthBatchCompiler.createSource(authCompilerPlug3);
                AuthBatchCompiler.createCompilationUnit(authCompilerPlug3);
                authCompilerPlug3.unit.topLevelDefinitions.add(new QName(string));
                if (null != authCompilerPlug && null == authCompilerPlug.swcScript) {
                    authCompilerPlug.swcScript = authSwcScript;
                    byte[] byArray = authSwcScript.getABC();
                    if (byArray != null) {
                        authCompilerPlug.abc = byArray;
                    }
                }
            }
            return authCompilerPlug3;
        }
        if (bl) {
            return AuthCompilerPlug.DEF_FOUND_PLUG;
        }
        return AuthBatchCompiler.initSwcPlug(authCompilerPlug, authSwcScript, string, bl2, bl3);
    }

    private static AuthCompilerPlug initSwcPlug(AuthCompilerPlug authCompilerPlug, AuthSwcScript authSwcScript, String string, boolean bl, boolean bl2) {
        Object object;
        byte[] byArray = authSwcScript.getABC();
        if (byArray == null) {
            return null;
        }
        AuthCompilerPlug authCompilerPlug2 = authCompilerPlug != null ? authCompilerPlug : new AuthCompilerPlug();
        authCompilerPlug2.abc = byArray;
        authCompilerPlug2.classname = Util.colonClassnameToDotClassname(string);
        authCompilerPlug2.filename = new StringBuffer().append(authSwcScript.getSwcLocation()).append("(").append(authSwcScript.getName()).append(")").toString();
        if ((bl || (AuthBatchCompiler.mainplug.flags & 0x4000) != 0) && (object = ((AuthSwc)authSwcScript.getLibrary().getSwc()).getArchive()) instanceof AuthSwcDynamicArchive) {
            authCompilerPlug2.swcFilePath = ((AuthSwcDynamicArchive)object).getRealPath().toLowerCase();
        }
        authCompilerPlug2.scriptname = authCompilerPlug2.filename;
        authCompilerPlug2.lastModified = authSwcScript.getLastModified();
        authCompilerPlug2.isInternal = bl;
        authCompilerPlug2.isPlayerglobalPlug = bl2;
        authCompilerPlug2.isSwcPlug = true;
        authCompilerPlug2.swcScript = authSwcScript;
        if (!authCompilerPlug2.isInternal) {
            boolean bl3 = authCompilerPlug2.rslPreloaderPlug = generatingRSLPreloaderPlugs && (AuthBatchCompiler.mainplug.flags & 0x2000) != 0;
        }
        if (authCompilerPlug == null) {
            authCompilerPlug2.setHandlerKey(authCompilerPlug2.filename);
            inheritanceGraph.addVertexForPlug(authCompilerPlug2);
        }
        authSwcScript.setPlug(authCompilerPlug2);
        AuthBatchCompiler.createSource(authCompilerPlug2);
        AuthBatchCompiler.createCompilationUnit(authCompilerPlug2);
        object = authSwcScript.getDependencySet();
        AuthBatchCompiler.addDeps(authCompilerPlug2, (SwcDependencySet)object, "i");
        AuthBatchCompiler.addDeps(authCompilerPlug2, (SwcDependencySet)object, "s");
        AuthBatchCompiler.addDeps(authCompilerPlug2, (SwcDependencySet)object, "e");
        AuthBatchCompiler.addDeps(authCompilerPlug2, (SwcDependencySet)object, "n");
        QNameList qNameList = authCompilerPlug2.unit.topLevelDefinitions;
        qNameList.add(new QName(string));
        Iterator<String> iterator = authSwcScript.getDefinitionIterator();
        while (iterator.hasNext()) {
            qNameList.add(new QName(iterator.next()));
        }
        if (AuthBatchCompiler.mainplug.rslPaths != null && authCompilerPlug2.swcFilePath != null && !extLibPathSwcsUsed.containsKey(authCompilerPlug2.swcFilePath)) {
            int n;
            for (n = 0; n < AuthBatchCompiler.mainplug.rslPaths.length; ++n) {
                RSLInfo rSLInfo = AuthBatchCompiler.mainplug.rslPaths[n];
                if (rSLInfo == null || !authCompilerPlug2.swcFilePath.equals(rSLInfo.swcFilePath)) continue;
                rslPreloadingRequired = true;
                extLibPathSwcsUsed.put(authCompilerPlug2.swcFilePath, rSLInfo);
                if ((AuthBatchCompiler.mainplug.flags & 0x2000) == 0 || (AuthBatchCompiler.mainplug.flags & 0x4000) != 0) break;
                AuthBatchCompiler.mainplug.handler.authError(5012, rSLInfo.urls[0].rslURL, "");
                break;
            }
            if (n >= AuthBatchCompiler.mainplug.rslPaths.length) {
                extLibPathSwcsUsed.put(authCompilerPlug2.swcFilePath, null);
            }
        }
        if (authCompilerPlug == null) {
            plugs.add((Object)authCompilerPlug2);
            authCompilerPlug2.context = new Context(contextStatics);
            authCompilerPlug2.context.setScriptName(authCompilerPlug2.filename);
            authCompilerPlug2.context.setPath(null);
            authCompilerPlug2.unit.getContext().setAttribute("cx", authCompilerPlug2.context);
            authCompilerPlug2.emitter = new ActionBlockEmitter(authCompilerPlug2.context, authSwcScript.getName(), (PrintWriter)new StringPrintWriter(), (PrintWriter)new StringPrintWriter(), false, false, false, (AuthBatchCompiler.mainplug.flags & 1) != 0);
        }
        return authCompilerPlug2;
    }

    private static AuthCompilerPlug searchClasspath(String string, boolean bl, AuthCompilerPlug authCompilerPlug) throws Throwable {
        String string2 = Util.colonClassnameToDotClassname(string);
        if (bl) {
            return AuthBatchCompiler.mainplug.handler.hasDefinition(string2) ? AuthCompilerPlug.DEF_FOUND_PLUG : null;
        }
        int n = plugs.size();
        AuthBatchCompiler.mainplug.handler.findDefinition(string2);
        int n2 = plugs.size();
        if (n2 > n) {
            for (int i = n; i < n2 - 1; ++i) {
                AuthBatchCompiler.setUpNewResultPlug((AuthCompilerPlug)plugs.get(i), authCompilerPlug);
            }
            return (AuthCompilerPlug)plugs.get(n2 - 1);
        }
        return null;
    }

    private static CompilationUnit createCompilationUnit(AuthCompilerPlug authCompilerPlug) {
        if (authCompilerPlug.source == null) {
            return null;
        }
        if (authCompilerPlug.unit == null) {
            authCompilerPlug.unit = authCompilerPlug.source.newCompilationUnit(authCompilerPlug.node, new CompilerContext());
        }
        if (authCompilerPlug.context != null) {
            authCompilerPlug.unit.getContext().setAttribute("cx", authCompilerPlug.context);
        }
        return authCompilerPlug.unit;
    }

    private static Source createSource(AuthCompilerPlug authCompilerPlug) {
        if (authCompilerPlug.source != null) {
            return authCompilerPlug.source;
        }
        if (authCompilerPlug.isSwcPlug) {
            SwcScript swcScript = authCompilerPlug.swcScript;
            String string = swcScript.getSwcLocation();
            byte[] byArray = swcScript.getABC();
            if (byArray == null) {
                byArray = new byte[1];
            }
            InMemoryFile inMemoryFile = new InMemoryFile(byArray, new StringBuffer().append(string).append("(").append(swcScript.getName()).append(")").toString(), "application/x-actionscript-bytecode", swcScript.getLastModified());
            authCompilerPlug.source = new Source((VirtualFile)inMemoryFile, "", "", swcScript, authCompilerPlug.isInternal, false, false);
            return authCompilerPlug.source;
        }
        LocalFile localFile = new LocalFile(new File(authCompilerPlug.filename));
        int n = authCompilerPlug.classname.lastIndexOf(46);
        String string = n == -1 ? authCompilerPlug.classname : authCompilerPlug.classname.substring(n + 1);
        String string2 = n == -1 ? "" : authCompilerPlug.classname.substring(0, n);
        string2 = string2.replace('.', '/');
        String string3 = authCompilerPlug.filename;
        if (authCompilerPlug.class_provided) {
            String string4;
            if (!string3.substring(string3.length() - 3).equals(".as")) {
                return null;
            }
            n = (string3 = string3.substring(0, string3.length() - 3)).lastIndexOf(string);
            if (n < 0 || n + string.length() != string3.length()) {
                return null;
            }
            string3 = string3.substring(0, n - 1);
            int n2 = string2.length();
            int n3 = string2.lastIndexOf(47);
            while (n3 >= 0) {
                string4 = string2.substring(n3 + 1, n2);
                n = string3.lastIndexOf(string4);
                if (n < 0 || n + string4.length() != string3.length()) {
                    return null;
                }
                string3 = string3.substring(0, n - 1);
                n2 = n3;
                n3 = string2.lastIndexOf(47, n2 - 1);
            }
            if (n2 > 0) {
                string4 = string2.substring(0, n2);
                n = string3.lastIndexOf(string4);
                if (n < 0 || n + string4.length() != string3.length()) {
                    return null;
                }
                string3 = string3.substring(0, n - 1);
            }
        }
        LocalFile localFile2 = new LocalFile(new File(string3));
        authCompilerPlug.source = new Source((VirtualFile)localFile, localFile2, string2, string, sourcePath, false, false);
        return authCompilerPlug.source;
    }

    private static void generateMissingLibrariesWarningMessages() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<String> iterator = missingLibrariesClasses.iterator();
        while (iterator.hasNext()) {
            boolean bl = false;
            String string = iterator.next();
            List<RSLClassInfo> list = rslClassMap.get(string);
            if (list == null) continue;
            for (RSLClassInfo rSLClassInfo : list) {
                if ((rSLClassInfo.flags & 2) == 0) continue;
                if (!bl) {
                    stringBuffer.append(string);
                    stringBuffer.append(';');
                    bl = true;
                }
                stringBuffer.append(rSLClassInfo.rslInfo.origSWCFilePath);
                stringBuffer.append(';');
            }
            if (!bl) continue;
            stringBuffer.append(';');
        }
        if (stringBuffer.length() > 0) {
            AuthBatchCompiler.mainplug.handler.setMissingLibraries(stringBuffer.toString());
        }
    }

    private static void clearPlugsFromAuthSwcScripts(SwcGroup swcGroup) {
        if (null == swcGroup) {
            return;
        }
        swcGroup.close();
        Collection<SwcScript> collection = swcGroup.getScriptMap().values();
        for (AuthSwcScript authSwcScript : collection) {
            authSwcScript.setPlug(null);
        }
    }

    public static void setupDebugging(String string) throws IOException {
        if (flashConfigDir != null) {
            return;
        }
        File file = new File(string);
        if (!file.exists() || !file.isDirectory()) {
            throw new IOException();
        }
        System.setErr(new PrintStream(new FileOutputStream(new File(file, "JavaStdErr.txt"))));
        System.setOut(new PrintStream(new FileOutputStream(new File(file, "JavaStdOut.txt"))));
        flashConfigDir = file;
    }

    static {
        showedSwcDefNotFoundError = false;
        flexConfiguration = null;
        sCheckedForSWCCaching = false;
        sEnableSWCCaching = true;
        flashConfigDir = null;
    }

    static class CircularInheritanceException
    extends Exception {
    }

    static class ParseConfigVarHandler
    extends AuthCompilerHandler {
        public boolean isOK = true;

        public ParseConfigVarHandler() {
            super(null, null);
        }

        public ParseConfigVarHandler(String string, AuthCompilerPlug authCompilerPlug) {
            super(string, authCompilerPlug);
        }

        public void warning(String string, int n, int n2, String string2, String string3, int n3) {
        }

        public void warning(String string, int n, int n2, String string2, String string3) {
        }

        public void error(String string, int n, int n2, String string2, String string3, int n3) {
            this.isOK = false;
        }

        public void error(String string, int n, int n2, String string2, String string3) {
            this.isOK = false;
        }

        public void authError(int n, String string, String string2) {
            this.isOK = false;
        }

        public boolean writeBytes(String string, ByteList byteList, boolean bl, boolean bl2) {
            return false;
        }

        public boolean writeBytes(String string, byte[] byArray, boolean bl, boolean bl2) {
            return false;
        }
    }

    /*
     * This class specifies class file version 47.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SwfTagBlockInfo {
        public String className;
        public DefineTag tag;
        public boolean inLoaderFrame;
        public boolean exportInFirstFrame;
        public boolean tagExported;
        public Set<DefineTag> swfTagDependencies;

        public SwfTagBlockInfo(String string, DefineTag defineTag, AuthCompilerPlug authCompilerPlug, Set<DefineTag> set) {
            this.className = string;
            this.tag = defineTag;
            this.inLoaderFrame = authCompilerPlug.inLoaderFrame;
            this.exportInFirstFrame = authCompilerPlug.exportInFirstFrame;
            this.tagExported = false;
            this.swfTagDependencies = set;
        }
    }

    static class TempDependencyHolder {
        AuthCompilerPlug depPlug;
        AuthCompilerPlug defPlug;
        String depType;
        String fullname;

        public TempDependencyHolder(AuthCompilerPlug authCompilerPlug, AuthCompilerPlug authCompilerPlug2, String string, String string2) {
            this.depPlug = authCompilerPlug;
            this.defPlug = authCompilerPlug2;
            this.depType = string;
            this.fullname = string2;
        }
    }

    static class ABCToParse {
        public Context context;
        public ByteList bytes;
        public ProgramNode pnode;
        public boolean isSwc;

        public ABCToParse(Context context, ByteList byteList) {
            this.context = context;
            this.bytes = byteList;
            this.isSwc = false;
        }

        public ABCToParse(Context context, ProgramNode programNode) {
            this.context = context;
            this.pnode = programNode;
            this.isSwc = true;
        }
    }
}

