/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc.authoring;

import adobe.abc.authoring.ArgumentInfo;
import adobe.abc.authoring.AttributeInfo;
import adobe.abc.authoring.ClassInfo;
import adobe.abc.authoring.DebugInfo;
import adobe.abc.authoring.DeclarationInfo;
import adobe.abc.authoring.MetadataAttributeInfo;
import adobe.abc.authoring.MetadataInfo;
import adobe.abc.authoring.MethodInfo;
import adobe.abc.authoring.PropertyInfo;
import adobe.abc.authoring.VariableInfo;
import adobe.asc.authoring.AuthCompilerHandler;
import adobe.asc.authoring.MainCompilerPlug;
import adobe.asc.authoring.flexInfo.FlexInfo;
import adobe.asc.authoring.flexInfo.MetadataWarningInfo;
import flash.swf.tools.as3.EvaluatorAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import macromedia.asc.parser.BinaryProgramNode;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.ListNode;
import macromedia.asc.parser.LiteralBooleanNode;
import macromedia.asc.parser.LiteralNullNode;
import macromedia.asc.parser.LiteralNumberNode;
import macromedia.asc.parser.LiteralStringNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.MetaDataEvaluator;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.ParameterNode;
import macromedia.asc.parser.StatementListNode;
import macromedia.asc.parser.TypedIdentifierNode;
import macromedia.asc.parser.UnaryExpressionNode;
import macromedia.asc.parser.VariableBindingNode;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.QName;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.Context;
import macromedia.asc.util.ObjectList;

/*
 * This class specifies class file version 47.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ABCEvaluator
extends EvaluatorAdapter {
    protected String fPackageName;
    private final boolean isFromSWC;
    public static HashMap<String, HashSet<DeclarationInfo>> globalMetadataMap;
    public static HashMap<String, ClassInfo> globalClassInfoMap;
    public static ArrayList<ClassInfo> globalClassInfoList;
    public static ArrayList<MethodInfo> globalMethodInfoList;
    public static ArrayList<VariableInfo> globalVariableInfoList;
    private static HashMap<String, MetadataInfo> metadataMap;
    private static ArrayList<MetadataInfo> metadataList;
    private static HashMap<String, PropertyInfo> propertyMap;
    private static ArrayList<PropertyInfo> propertyList;
    private static HashMap<String, MethodInfo> methodMap;
    private static ArrayList<MethodInfo> methodList;
    private static String[] XML_ENTITIES;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void resetGlobals() {
        if (globalMetadataMap == null) {
            globalMetadataMap = new HashMap();
        } else {
            globalMetadataMap.clear();
        }
        if (globalClassInfoMap == null) {
            globalClassInfoMap = new HashMap();
        } else {
            globalClassInfoMap.clear();
        }
        if (globalClassInfoList == null) {
            globalClassInfoList = new ArrayList();
        } else {
            globalClassInfoList.clear();
        }
        if (globalMethodInfoList == null) {
            globalMethodInfoList = new ArrayList();
        } else {
            globalMethodInfoList.clear();
        }
        if (globalVariableInfoList == null) {
            globalVariableInfoList = new ArrayList();
        } else {
            globalVariableInfoList.clear();
        }
    }

    public ABCEvaluator(boolean bl) {
        this.isFromSWC = bl;
    }

    public ABCEvaluator(String string, boolean bl) {
        this.fPackageName = string;
        this.isFromSWC = bl;
    }

    @Override
    public Value evaluate(Context context, BinaryProgramNode binaryProgramNode) {
        if (binaryProgramNode.toplevelDefinitions.size() > 0) {
            this.fPackageName = "";
            boolean bl = false;
            for (Object object : binaryProgramNode.toplevelDefinitions) {
                if (((QName)object).ns.name.indexOf(36) != -1 || ((QName)object).ns.name.indexOf(58) != -1 || ((QName)object).ns.name.indexOf(92) != -1 || ((QName)object).ns.name.indexOf(47) != -1) continue;
                if (!bl) {
                    this.fPackageName = ((QName)object).ns.name;
                    continue;
                }
                if (((QName)object).ns.name.equals(this.fPackageName) || $assertionsDisabled) continue;
                throw new Error();
            }
            if (binaryProgramNode.clsdefs != null && binaryProgramNode.clsdefs.size() > 0) {
                for (ClassDefinitionNode classDefinitionNode : binaryProgramNode.clsdefs) {
                    ABCEvaluator aBCEvaluator = new ABCEvaluator(this.fPackageName, this.isFromSWC);
                    classDefinitionNode.evaluate(context, (Evaluator)aBCEvaluator);
                }
            }
            if (binaryProgramNode.clsdefs == null || binaryProgramNode.toplevelDefinitions.size() > binaryProgramNode.clsdefs.size()) {
                this.addMembers(context, binaryProgramNode.statements.items, null, false, globalMethodInfoList, null, null, globalVariableInfoList);
            }
        }
        return null;
    }

    private DebugInfo removeOffsetMetadata(ArrayList<MetadataInfo> arrayList) {
        DebugInfo debugInfo = null;
        if (arrayList != null) {
            Iterator<MetadataInfo> iterator = arrayList.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                MetadataInfo metadataInfo = iterator.next();
                if (metadataInfo.name.equals("__go_to_definition_help")) {
                    debugInfo = new DebugInfo();
                    for (MetadataAttributeInfo metadataAttributeInfo : metadataInfo.attrs) {
                        if (metadataAttributeInfo.name.equals("file")) {
                            debugInfo.file = metadataAttributeInfo.value;
                            continue;
                        }
                        if (!metadataAttributeInfo.name.equals("pos")) continue;
                        debugInfo.posStr = metadataAttributeInfo.value;
                        try {
                            debugInfo.pos = Integer.parseInt(debugInfo.posStr);
                        }
                        catch (NumberFormatException numberFormatException) {
                            debugInfo.pos = -1;
                        }
                    }
                    arrayList.remove(n);
                    break;
                }
                ++n;
            }
        }
        return debugInfo;
    }

    @Override
    public Value evaluate(Context context, ClassDefinitionNode classDefinitionNode) {
        ClassInfo classInfo;
        if (classDefinitionNode == null || classDefinitionNode.name == null) {
            return null;
        }
        String string = this.fPackageName;
        if (classDefinitionNode.ref != null && classDefinitionNode.ref.namespaces != null && classDefinitionNode.ref.namespaces.size() == 1) {
            classInfo = (ObjectValue)classDefinitionNode.ref.namespaces.get(0);
            if (((ObjectValue)classInfo).name != null) {
                string = ((ObjectValue)classInfo).name;
            }
        }
        classInfo = new ClassInfo(classDefinitionNode.name.name, string, classDefinitionNode.isInterface());
        if (classDefinitionNode.isInterface()) {
            System.out.println(new StringBuffer().append("interface name = ").append(classDefinitionNode.name.name).toString());
            System.out.println(new StringBuffer().append("packageName = ").append(string).toString());
        } else {
            System.out.println(new StringBuffer().append("class name = ").append(classDefinitionNode.name.name).toString());
            System.out.println(new StringBuffer().append("packageName = ").append(string).toString());
        }
        classInfo.attrs = classDefinitionNode.attrs == null ? null : new AttributeInfo(classDefinitionNode.attrs);
        classInfo.metadata = this.getMetadata(context, classDefinitionNode.metaData, classInfo);
        classInfo.debugInfo = this.removeOffsetMetadata(classInfo.metadata);
        if (classDefinitionNode.isInterface()) {
            classInfo.implementedInterfaceNames = this.addExtendedInterfaces(classDefinitionNode);
        } else {
            classInfo.baseClassName = this.addBaseClass(classDefinitionNode);
            classInfo.implementedInterfaceNames = this.addImplementedInterfaces(classDefinitionNode);
        }
        classInfo.methodList = new ArrayList();
        classInfo.getterList = new ArrayList();
        classInfo.setterList = new ArrayList();
        classInfo.variableList = new ArrayList();
        if (classDefinitionNode.instanceinits != null) {
            this.addMembers(context, classDefinitionNode.instanceinits, classDefinitionNode.name.name, true, classInfo.methodList, classInfo.getterList, classInfo.setterList, classInfo.variableList);
        }
        classInfo.staticMethodList = new ArrayList();
        classInfo.staticGetterList = new ArrayList();
        classInfo.staticSetterList = new ArrayList();
        classInfo.staticVariableList = new ArrayList();
        if (classDefinitionNode.statements != null && classDefinitionNode.statements.items != null) {
            this.addMembers(context, classDefinitionNode.statements.items, null, true, classInfo.staticMethodList, classInfo.staticGetterList, classInfo.staticSetterList, classInfo.staticVariableList);
        }
        globalClassInfoMap.put(classInfo.fullName, classInfo);
        globalClassInfoList.add(classInfo);
        return null;
    }

    public void addMembers(Context context, ObjectList objectList, String string, boolean bl, ArrayList<MethodInfo> arrayList, ArrayList<MethodInfo> arrayList2, ArrayList<MethodInfo> arrayList3, ArrayList<VariableInfo> arrayList4) {
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        if (objectList != null) {
            for (Object e : objectList) {
                if (e instanceof FunctionDefinitionNode) {
                    MethodInfo methodInfo = this.addFunction(context, (FunctionDefinitionNode)e, hashSet2, string);
                    if (methodInfo == null) continue;
                    this.insertDeclInfoIntoSortedList(arrayList, methodInfo, bl);
                    switch (methodInfo.type) {
                        case 1: {
                            if (arrayList2 == null) break;
                            this.insertDeclInfoIntoSortedList(arrayList2, methodInfo, bl);
                            break;
                        }
                        case 2: {
                            if (arrayList3 == null) break;
                            this.insertDeclInfoIntoSortedList(arrayList3, methodInfo, bl);
                        }
                    }
                    continue;
                }
                if (!(e instanceof VariableDefinitionNode)) continue;
                this.addVariable(context, (VariableDefinitionNode)e, hashSet, arrayList4, bl);
            }
        }
    }

    private void insertDeclInfoIntoSortedList(ArrayList arrayList, DeclarationInfo declarationInfo, boolean bl) {
        if (!bl || arrayList.size() == 0 || declarationInfo.debugInfo == null || declarationInfo.debugInfo.pos < 0) {
            arrayList.add(declarationInfo);
            return;
        }
        int n = declarationInfo.debugInfo.pos;
        int n2 = 0;
        for (DeclarationInfo declarationInfo2 : arrayList) {
            if (declarationInfo2.debugInfo == null || declarationInfo2.debugInfo.pos < 0 || declarationInfo2.debugInfo.pos > n) {
                arrayList.add(n2, declarationInfo);
                return;
            }
            ++n2;
        }
        arrayList.add(declarationInfo);
    }

    public void addVariable(Context context, VariableDefinitionNode variableDefinitionNode, HashSet hashSet, ArrayList<VariableInfo> arrayList, boolean bl) {
        System.out.println("addVariable");
        ListNode listNode = variableDefinitionNode.list;
        if (listNode != null && listNode.size() > 0) {
            for (Object e : listNode.items) {
                AttributeInfo attributeInfo;
                if (!(e instanceof VariableBindingNode)) continue;
                VariableBindingNode variableBindingNode = (VariableBindingNode)e;
                TypedIdentifierNode typedIdentifierNode = variableBindingNode.variable;
                if (typedIdentifierNode.identifier == null) continue;
                String string = typedIdentifierNode.identifier.name;
                String string2 = "notypefound";
                AttributeInfo attributeInfo2 = attributeInfo = variableDefinitionNode.attrs == null ? null : new AttributeInfo(variableDefinitionNode.attrs);
                if (typedIdentifierNode.type instanceof MemberExpressionNode) {
                    string2 = this.getType((MemberExpressionNode)typedIdentifierNode.type);
                }
                VariableInfo variableInfo = new VariableInfo(string, string2);
                variableInfo.attrs = attributeInfo;
                variableInfo.metadata = this.getMetadata(context, variableDefinitionNode.metaData, variableInfo);
                variableInfo.debugInfo = this.removeOffsetMetadata(variableInfo.metadata);
                String string3 = new StringBuffer().append("var ").append(string).append(":").append(string2).toString();
                if (!hashSet.contains(string3)) {
                    hashSet.add(string3);
                    this.insertDeclInfoIntoSortedList(arrayList, variableInfo, bl);
                    System.out.println(string3);
                    continue;
                }
                System.out.println(new StringBuffer().append("DUPLICATE DEFINITION: ").append(string3).toString());
            }
        }
    }

    public MethodInfo addFunction(Context context, FunctionDefinitionNode functionDefinitionNode, HashSet hashSet, String string) {
        MethodInfo methodInfo = null;
        System.out.println("addFunction");
        if (functionDefinitionNode.name != null && functionDefinitionNode.name.identifier != null && functionDefinitionNode.name.identifier.name != null) {
            String string2 = "function ";
            boolean bl = false;
            String string3 = functionDefinitionNode.name.identifier.name;
            if (string3.equals("$construct")) {
                bl = true;
                string3 = string;
            }
            if (string3 == null) {
                return null;
            }
            switch (functionDefinitionNode.name.kind) {
                case -79: {
                    string2 = new StringBuffer().append(string2).append("get ").toString();
                    break;
                }
                case -99: {
                    string2 = new StringBuffer().append(string2).append("set ").toString();
                    break;
                }
            }
            string2 = new StringBuffer().append(string2).append(string3).append("(").toString();
            methodInfo = new MethodInfo(string3, bl, functionDefinitionNode.name.kind);
            methodInfo.args = new ArrayList();
            methodInfo.attrs = functionDefinitionNode.attrs == null ? null : new AttributeInfo(functionDefinitionNode.attrs);
            methodInfo.metadata = this.getMetadata(context, functionDefinitionNode.metaData, methodInfo);
            methodInfo.debugInfo = this.removeOffsetMetadata(methodInfo.metadata);
            if (functionDefinitionNode.fexpr != null && functionDefinitionNode.fexpr.signature != null) {
                Object object;
                if (functionDefinitionNode.fexpr.signature.result != null && functionDefinitionNode.fexpr.signature.result instanceof MemberExpressionNode) {
                    object = this.getType((MemberExpressionNode)functionDefinitionNode.fexpr.signature.result);
                    methodInfo.returnType = object;
                    System.out.println(new StringBuffer().append("returnType = ").append((String)object).toString());
                }
                if (functionDefinitionNode.fexpr.signature.parameter != null && (object = functionDefinitionNode.fexpr.signature.parameter.items) != null && object.size() > 0) {
                    for (Object e : object) {
                        if (!(e instanceof ParameterNode)) continue;
                        ParameterNode parameterNode = (ParameterNode)e;
                        ReferenceValue referenceValue = parameterNode.typeref;
                        String string4 = this.getType(referenceValue);
                        String string5 = "";
                        if (parameterNode.identifier != null) {
                            string5 = parameterNode.identifier.name;
                        }
                        ArgumentInfo argumentInfo = new ArgumentInfo(string5, string4);
                        string2 = new StringBuffer().append(string2).append(string5).toString();
                        string2 = new StringBuffer().append(string2).append(":").toString();
                        string2 = new StringBuffer().append(string2).append(string4).toString();
                        string2 = new StringBuffer().append(string2).append(",").toString();
                        if (parameterNode.init != null) {
                            Node node = parameterNode.init;
                            if (parameterNode.init instanceof UnaryExpressionNode) {
                                UnaryExpressionNode unaryExpressionNode = (UnaryExpressionNode)parameterNode.init;
                                node = unaryExpressionNode.expr;
                            }
                            if (node instanceof LiteralNumberNode) {
                                argumentInfo.defaultValue = ((LiteralNumberNode)node).value;
                                System.out.println(new StringBuffer().append(string5).append("has a Number default value = ").append(((LiteralNumberNode)node).value).toString());
                            } else if (node instanceof LiteralStringNode) {
                                argumentInfo.defaultValue = ((LiteralStringNode)node).value;
                                System.out.println(new StringBuffer().append(string5).append("has a String default value = ").append(((LiteralStringNode)node).value).toString());
                            } else if (node instanceof LiteralBooleanNode) {
                                argumentInfo.defaultValue = ((LiteralBooleanNode)node).value ? "true" : "false";
                                System.out.println(new StringBuffer().append(string5).append("has a Boolean default value = ").append(((LiteralBooleanNode)node).value ? "true" : "false").toString());
                            } else if (node instanceof LiteralNullNode) {
                                argumentInfo.defaultValue = "null";
                                System.out.println(new StringBuffer().append(string5).append("has a Object default value = null").toString());
                            }
                        }
                        methodInfo.args.add(argumentInfo);
                    }
                }
            }
            methodInfo.representativeString = string2 = new StringBuffer().append(string2).append(")").toString();
            if (!hashSet.contains(string2)) {
                hashSet.add(string2);
                System.out.println(string2);
            } else {
                methodInfo = null;
                System.out.println(new StringBuffer().append("DUPLICATE DEFINITION: ").append(string2).toString());
            }
        }
        return methodInfo;
    }

    protected ArrayList<MetadataInfo> getMetadata(Context context, StatementListNode statementListNode, DeclarationInfo declarationInfo) {
        ArrayList<MetadataInfo> arrayList = new ArrayList<MetadataInfo>();
        if (statementListNode == null || statementListNode.items == null || statementListNode.items.size() == 0) {
            return arrayList;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (MetaDataNode metaDataNode : statementListNode.items) {
            String string = metaDataNode.getId();
            MetadataInfo metadataInfo = new MetadataInfo(string);
            metadataInfo.attrs = new ArrayList();
            System.out.println(new StringBuffer().append("metadata name = ").append(string).toString());
            Value[] valueArray = metaDataNode.getValues();
            String string2 = new StringBuffer().append(string).append("[").toString();
            if (valueArray != null) {
                for (int i = 0; i < valueArray.length; ++i) {
                    String string3;
                    if (valueArray[i] instanceof MetaDataEvaluator.KeylessValue) {
                        string3 = ((MetaDataEvaluator.KeylessValue)valueArray[i]).obj;
                        metadataInfo.attrs.add(new MetadataAttributeInfo(string3));
                        System.out.println(new StringBuffer().append("Keyless Value: ").append(string3).toString());
                        string2 = new StringBuffer().append(string2).append(string3).append(",").toString();
                        continue;
                    }
                    if (!(valueArray[i] instanceof MetaDataEvaluator.KeyValuePair)) continue;
                    string3 = ((MetaDataEvaluator.KeyValuePair)valueArray[i]).key;
                    String string4 = ((MetaDataEvaluator.KeyValuePair)valueArray[i]).obj;
                    metadataInfo.attrs.add(new MetadataAttributeInfo(string3, string4));
                    System.out.println(new StringBuffer().append("Key Value Pair: ").append(string3).append(" = ").append(string4).toString());
                    string2 = new StringBuffer().append(string2).append(string3).append("=").append(string4).append(",").toString();
                }
            }
            metadataInfo.representativeString = string2 = new StringBuffer().append(string2).append("]").toString();
            if (!hashSet.contains(string2)) {
                hashSet.add(string2);
                arrayList.add(metadataInfo);
            } else {
                System.out.println(new StringBuffer().append("DUPLICATE DEFINITION: ").append(string2).toString());
            }
            if (this.isFromSWC) continue;
            HashSet<DeclarationInfo> hashSet2 = globalMetadataMap.get(string);
            if (hashSet2 == null) {
                hashSet2 = new HashSet();
                globalMetadataMap.put(string, hashSet2);
            }
            hashSet2.add(declarationInfo);
        }
        return arrayList;
    }

    protected String addBaseClass(ClassDefinitionNode classDefinitionNode) {
        String string = null;
        if (classDefinitionNode.baseclass instanceof LiteralStringNode) {
            string = ((LiteralStringNode)classDefinitionNode.baseclass).value;
            if ((string = string.replaceAll(":", ".")) != null) {
                System.out.println(new StringBuffer().append("Base Class: ").append(string).toString());
            }
        }
        return string;
    }

    private static String getFullName(ReferenceValue referenceValue) {
        String string = "";
        if (!referenceValue.namespaces.isEmpty()) {
            string = new StringBuffer().append(referenceValue.namespaces.get(0)).append(".").toString();
        }
        string = new StringBuffer().append(string).append(referenceValue.name).toString();
        return string;
    }

    protected ArrayList<String> addImplementedInterfaces(ClassDefinitionNode classDefinitionNode) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ListNode listNode = classDefinitionNode.interfaces;
        if (listNode != null && listNode.values != null && listNode.values.size() > 0) {
            for (Object e : listNode.values) {
                String string;
                if (!(e instanceof ReferenceValue) || (string = ABCEvaluator.getFullName((ReferenceValue)e)).length() <= 0) continue;
                arrayList.add(string);
                System.out.println(new StringBuffer().append("implements interface ").append(string).toString());
            }
        }
        return arrayList;
    }

    protected ArrayList<String> addExtendedInterfaces(ClassDefinitionNode classDefinitionNode) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ListNode listNode = classDefinitionNode.interfaces;
        if (listNode != null && listNode.values != null && listNode.values.size() > 0) {
            for (Object e : listNode.values) {
                String string;
                if (!(e instanceof ReferenceValue) || (string = ABCEvaluator.getFullName((ReferenceValue)e)).length() <= 0) continue;
                arrayList.add(string);
                System.out.println(new StringBuffer().append("extends interface ").append(string).toString());
            }
        }
        return arrayList;
    }

    protected String getType(MemberExpressionNode memberExpressionNode) {
        if (memberExpressionNode.ref != null) {
            return this.getType(memberExpressionNode.ref);
        }
        if (memberExpressionNode.selector.getIdentifier().ref != null) {
            return this.getType(memberExpressionNode.selector.getIdentifier().ref);
        }
        return "";
    }

    protected String getType(ReferenceValue referenceValue) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = null;
        String string = "Object";
        if (referenceValue != null) {
            for (ObjectValue object : referenceValue.namespaces) {
                if (object.name.equals("") || object.name.equals(this.fPackageName)) continue;
                hashSet.add(object.name);
            }
            string = referenceValue.name;
        }
        System.out.println(new StringBuffer().append("got type name: ").append(string).toString());
        for (String string2 : hashSet) {
            System.out.println(new StringBuffer().append("adding import: ").append(string2).toString());
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateClassXML(String string) {
        StringBuffer stringBuffer;
        try {
            stringBuffer = new StringBuffer(1024);
            stringBuffer.append("<classDefs>\n");
            Iterator<ClassInfo> iterator = globalClassInfoList.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("\t<classDef id=\"");
                ABCEvaluator.appendEscapedForXML(stringBuffer, iterator.next().fullName);
                stringBuffer.append("\"/>\n");
            }
            stringBuffer.append("</classDefs>\n");
            metadataMap = new HashMap();
            metadataList = new ArrayList();
            propertyMap = new HashMap();
            propertyList = new ArrayList();
            methodMap = new HashMap();
            methodList = new ArrayList();
            ClassInfo classInfo = globalClassInfoMap.get(string);
            ABCEvaluator.walkBaseClassAndImplInterfaces(classInfo);
            stringBuffer.append("<class id=\"");
            ABCEvaluator.appendEscapedForXML(stringBuffer, string);
            stringBuffer.append("\" >\n");
            Iterator<MetadataInfo> iterator2 = metadataList.iterator();
            while (iterator2.hasNext()) {
                ABCEvaluator.generateMetadataXML(iterator2.next(), stringBuffer);
            }
            Iterator<PropertyInfo> iterator3 = propertyList.iterator();
            while (iterator3.hasNext()) {
                ABCEvaluator.generatePropertyXML(iterator3.next(), stringBuffer);
            }
            Iterator<MethodInfo> iterator4 = methodList.iterator();
            while (iterator4.hasNext()) {
                ABCEvaluator.generateMethodXML(iterator4.next(), stringBuffer);
            }
            stringBuffer.append("</class>");
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            String string2 = "";
            return string2;
        }
        finally {
            metadataMap = null;
            metadataList = null;
            propertyMap = null;
            propertyList = null;
            methodMap = null;
            methodList = null;
        }
        return stringBuffer.toString();
    }

    private static void walkBaseClassAndImplInterfaces(ClassInfo classInfo) {
        Object object2;
        for (Object object2 : classInfo.metadata) {
            if (metadataMap.get(((MetadataInfo)object2).representativeString) != null) continue;
            metadataMap.put(((MetadataInfo)object2).representativeString, (MetadataInfo)object2);
            metadataList.add((MetadataInfo)object2);
        }
        if (!classInfo.isInterface) {
            ABCEvaluator.fillInProperties(classInfo);
            ABCEvaluator.fillInMethods(classInfo);
            object2 = globalClassInfoMap.get(classInfo.baseClassName);
            if (object2 != null) {
                ABCEvaluator.walkBaseClassAndImplInterfaces((ClassInfo)object2);
            }
        }
        object2 = classInfo.implementedInterfaceNames.iterator();
        while (object2.hasNext()) {
            ClassInfo classInfo2 = globalClassInfoMap.get(object2.next());
            if (classInfo2 == null) continue;
            ABCEvaluator.walkBaseClassAndImplInterfaces(classInfo2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void fillInProperties(ClassInfo classInfo) {
        PropertyInfo propertyInfo;
        String string;
        for (MethodInfo object2 : classInfo.getterList) {
            void var4_8;
            String string2 = new StringBuffer().append(object2.name).append(":").append(object2.returnType).toString();
            PropertyInfo propertyInfo2 = propertyMap.get(string2);
            if (propertyInfo2 == null) {
                PropertyInfo propertyInfo3 = new PropertyInfo(object2.name, object2.returnType, string2);
                propertyMap.put(string2, propertyInfo3);
                propertyList.add(propertyInfo3);
            }
            if (var4_8.getterInfo != null) continue;
            var4_8.getterInfo = object2;
        }
        for (MethodInfo methodInfo : classInfo.setterList) {
            String string3 = methodInfo.args.get((int)0).type;
            string = new StringBuffer().append(methodInfo.name).append(":").append(string3).toString();
            propertyInfo = propertyMap.get(string);
            if (propertyInfo == null) {
                propertyInfo = new PropertyInfo(methodInfo.name, string3, string);
                propertyMap.put(string, propertyInfo);
                propertyList.add(propertyInfo);
            }
            if (propertyInfo.setterInfo != null) continue;
            propertyInfo.setterInfo = methodInfo;
        }
        for (VariableInfo variableInfo : classInfo.variableList) {
            string = new StringBuffer().append(variableInfo.name).append(":").append(variableInfo.type).toString();
            propertyInfo = propertyMap.get(string);
            if (propertyInfo == null) {
                propertyInfo = new PropertyInfo(variableInfo.name, variableInfo.type, string);
                propertyMap.put(string, propertyInfo);
                propertyList.add(propertyInfo);
            }
            if (propertyInfo.varInfo != null) continue;
            propertyInfo.varInfo = variableInfo;
        }
    }

    private static void fillInMethods(ClassInfo classInfo) {
        for (MethodInfo methodInfo : classInfo.methodList) {
            if (methodInfo.type != 0 || methodMap.get(methodInfo.name) != null) continue;
            methodMap.put(methodInfo.name, methodInfo);
            methodList.add(methodInfo);
        }
    }

    private static void generateMetadataXML(MetadataInfo metadataInfo, StringBuffer stringBuffer) {
        stringBuffer.append("\t<");
        stringBuffer.append(metadataInfo.name);
        stringBuffer.append(' ');
        int n = 1;
        for (MetadataAttributeInfo metadataAttributeInfo : metadataInfo.attrs) {
            if (metadataAttributeInfo.name == null) {
                stringBuffer.append("param");
                stringBuffer.append(n++);
            } else {
                stringBuffer.append(metadataAttributeInfo.name);
            }
            stringBuffer.append("=\"");
            ABCEvaluator.appendEscapedForXML(stringBuffer, metadataAttributeInfo.value);
            stringBuffer.append("\" ");
        }
        stringBuffer.append("/>\n");
    }

    private static void generatePropertyXML(PropertyInfo propertyInfo, StringBuffer stringBuffer) {
        Iterator iterator;
        if (propertyInfo.varInfo == null ? !(propertyInfo.getterInfo != null && propertyInfo.getterInfo.attrs != null && propertyInfo.getterInfo.attrs.hasPublic || propertyInfo.setterInfo != null && propertyInfo.setterInfo.attrs != null && propertyInfo.setterInfo.attrs.hasPublic) : propertyInfo.varInfo.attrs == null || !propertyInfo.varInfo.attrs.hasPublic) {
            return;
        }
        stringBuffer.append("\t<method id=\"");
        ABCEvaluator.appendEscapedForXML(stringBuffer, propertyInfo.name);
        stringBuffer.append("\" returnType=\"");
        ABCEvaluator.appendEscapedForXML(stringBuffer, propertyInfo.type);
        stringBuffer.append("\" isProperty=\"true\" permissions=\"");
        if (propertyInfo.varInfo != null || propertyInfo.getterInfo != null && propertyInfo.setterInfo != null) {
            stringBuffer.append("readwrite");
        } else if (propertyInfo.setterInfo == null) {
            stringBuffer.append("readonly");
        } else {
            stringBuffer.append("writeonly");
        }
        stringBuffer.append("\">\n");
        if (propertyInfo.getterInfo != null) {
            iterator = propertyInfo.getterInfo.metadata.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append('\t');
                ABCEvaluator.generateMetadataXML((MetadataInfo)iterator.next(), stringBuffer);
            }
        }
        if (propertyInfo.setterInfo != null) {
            iterator = propertyInfo.setterInfo.metadata.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append('\t');
                ABCEvaluator.generateMetadataXML((MetadataInfo)iterator.next(), stringBuffer);
            }
        }
        if (propertyInfo.varInfo != null) {
            iterator = propertyInfo.varInfo.metadata.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append('\t');
                ABCEvaluator.generateMetadataXML((MetadataInfo)iterator.next(), stringBuffer);
            }
        }
        stringBuffer.append("\t</method>\n");
    }

    private static void generateMethodXML(MethodInfo methodInfo, StringBuffer stringBuffer) {
        if (methodInfo.attrs == null || !methodInfo.attrs.hasPublic) {
            return;
        }
        stringBuffer.append("\t<method id=\"");
        ABCEvaluator.appendEscapedForXML(stringBuffer, methodInfo.name);
        if (methodInfo.isConstructor) {
            stringBuffer.append("\" isConstructor=\"true");
        } else {
            stringBuffer.append("\" returnType=\"");
            ABCEvaluator.appendEscapedForXML(stringBuffer, methodInfo.returnType);
        }
        stringBuffer.append("\" isProperty=\"false\">\n");
        if (methodInfo.metadata != null) {
            Iterator iterator = methodInfo.metadata.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append('\t');
                ABCEvaluator.generateMetadataXML((MetadataInfo)iterator.next(), stringBuffer);
            }
        }
        stringBuffer.append("\t</method>\n");
    }

    public static void appendEscapedForXML(StringBuffer stringBuffer, String string) {
        int n = stringBuffer.length();
        stringBuffer.append(string);
        for (int i = 0; i < XML_ENTITIES.length; i += 2) {
            String string2 = XML_ENTITIES[i];
            String string3 = XML_ENTITIES[i + 1];
            int n2 = stringBuffer.indexOf(string2, n);
            while (n2 >= 0) {
                stringBuffer.replace(n2, n2 + 1, string3);
                n2 = stringBuffer.indexOf(string2, n2 + 1);
            }
        }
    }

    public static void appendUnescapedForXML(StringBuffer stringBuffer, String string) {
        int n = stringBuffer.length();
        stringBuffer.append(string);
        for (int i = XML_ENTITIES.length - 2; i >= 0; i -= 2) {
            String string2 = XML_ENTITIES[i + 1];
            int n2 = string2.length();
            String string3 = XML_ENTITIES[i];
            int n3 = stringBuffer.indexOf(string2, n);
            while (n3 >= 0) {
                stringBuffer.replace(n3, n3 + n2, string3);
                n3 = stringBuffer.indexOf(string2, n3 + 1);
            }
        }
    }

    public static void generateFlexSDKWarningMessages(MainCompilerPlug mainCompilerPlug, Set<String> set) {
        AuthCompilerHandler authCompilerHandler = mainCompilerPlug.handler;
        FlexInfo flexInfo = FlexInfo.getSingleton(mainCompilerPlug.flexInfoXMLPath);
        List<MetadataWarningInfo> list = flexInfo.getWarnMetadataList();
        block0: for (MetadataWarningInfo metadataWarningInfo : list) {
            HashSet<DeclarationInfo> hashSet = globalMetadataMap.get(metadataWarningInfo.name);
            if (hashSet == null) continue;
            if (metadataWarningInfo.allLevels() && ABCEvaluator.checkMetadataWarningInfoForClassMatch(metadataWarningInfo, set)) {
                authCompilerHandler.flexSDKMetadataWarning(metadataWarningInfo.name);
                continue;
            }
            for (DeclarationInfo declarationInfo : hashSet) {
                if (declarationInfo.declType == "class" && metadataWarningInfo.classLevel && ABCEvaluator.checkMetadataWarningInfoForClassMatch(metadataWarningInfo, set)) {
                    authCompilerHandler.flexSDKMetadataWarning(metadataWarningInfo.name);
                    continue block0;
                }
                if (declarationInfo.declType == "method" && metadataWarningInfo.methodLevel && ABCEvaluator.checkMetadataWarningInfoForClassMatch(metadataWarningInfo, set)) {
                    authCompilerHandler.flexSDKMetadataWarning(metadataWarningInfo.name);
                    continue block0;
                }
                if (declarationInfo.declType != "variable" || !metadataWarningInfo.variableLevel || !ABCEvaluator.checkMetadataWarningInfoForClassMatch(metadataWarningInfo, set)) continue;
                authCompilerHandler.flexSDKMetadataWarning(metadataWarningInfo.name);
                continue block0;
            }
        }
    }

    private static boolean checkMetadataWarningInfoForClassMatch(MetadataWarningInfo metadataWarningInfo, Set<String> set) {
        for (String string : metadataWarningInfo.requiredDefinitions) {
            if (!set.contains(string)) continue;
            return true;
        }
        return false;
    }

    static {
        $assertionsDisabled = true;
        XML_ENTITIES = new String[]{"&", "&amp;", "<", "&lt;", ">", "&gt;", "\"", "&quot;", "'", "&apos;"};
    }
}

