/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.inlineformatting;

public final class LigatureLevel {
    private final String name;
    private final int rank;
    public static final LigatureLevel NONE = new LigatureLevel("NONE", 0);
    public static final LigatureLevel MINIMUM = new LigatureLevel("MINIMUM", 1);
    public static final LigatureLevel COMMON = new LigatureLevel("COMMON", 2);
    public static final LigatureLevel UNCOMMON = new LigatureLevel("UNCOMMON", 3);
    public static final LigatureLevel EXOTIC = new LigatureLevel("EXOTIC", 4);
    private static final LigatureLevel[] allValues = new LigatureLevel[]{NONE, MINIMUM, COMMON, UNCOMMON, EXOTIC};

    private LigatureLevel(String string, int n) {
        this.name = string;
        this.rank = n;
    }

    public String toString() {
        return this.name;
    }

    public static boolean lessThanOrEqual(LigatureLevel ligatureLevel, LigatureLevel ligatureLevel2) {
        if (ligatureLevel == null) {
            ligatureLevel = COMMON;
        }
        if (ligatureLevel2 == null) {
            ligatureLevel2 = COMMON;
        }
        return ligatureLevel.rank <= ligatureLevel2.rank;
    }

    public static LigatureLevel parse(String string) {
        for (int i = 0; i < allValues.length; ++i) {
            if (LigatureLevel.allValues[i].name.compareToIgnoreCase(string) != 0) continue;
            return allValues[i];
        }
        return null;
    }
}

