/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.fontmanagement;

import com.adobe.fontengine.FontEngineException;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontException;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.FontInputStream;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.mac.FontFactory;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import com.adobe.fontengine.font.pdffont.PDFSimpleFont;
import com.adobe.fontengine.font.type1.MetricFile;
import com.adobe.fontengine.font.type1.Type1Font;
import com.adobe.fontengine.fontmanagement.DirectoryWalker;
import com.adobe.fontengine.fontmanagement.MemoryFont;
import com.adobe.fontengine.fontmanagement.PDFSimpleFontValuesAccessor;
import com.adobe.fontengine.fontmanagement.ResourceFont;
import com.adobe.fontengine.fontmanagement.StreamFont;
import com.adobe.fontengine.fontmanagement.URLFont;
import com.adobe.fontengine.fontmanagement.fxg.FXGFontResolver;
import com.adobe.fontengine.fontmanagement.fxg.FXGFontResolverImpl;
import com.adobe.fontengine.fontmanagement.platform.PlatformFontResolver;
import com.adobe.fontengine.fontmanagement.platform.PlatformFontResolverImpl;
import com.adobe.fontengine.fontmanagement.postscript.PSNameFontDatabase;
import com.adobe.fontengine.fontmanagement.postscript.PSNameResolver;
import com.adobe.fontengine.inlineformatting.css20.FamilyNameNormalizer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FontLoader {
    private static final int kType1Font = 1;
    private static final int kOpenTypeFont = 2;
    private static final int kCFFFont = 3;
    private static final int kPFM = 4;
    private static final int kAFM = 5;
    private static final int kMacDFont = 6;
    private static final int kMacRsrcFont = 7;
    private static final int maxBytesNeeded;
    private static final int t1BN;
    private static final int otBN;
    private static final int cffBN;
    private static final int afmBN;
    private static final int pfmBN;
    private static final int macBN;
    private HashMap<String, HashMap<String, FontImpl[]>> mGlobalCacheMap = new HashMap();
    private HashMap<String, FontImpl[]> mGlobalFontMap = new HashMap();

    public static PSNameResolver getPSNameResolverInstance() {
        return new PSNameFontDatabase();
    }

    public static PSNameResolver getPSNameResolverInstance(FamilyNameNormalizer familyNameNormalizer) {
        return new PSNameFontDatabase(familyNameNormalizer);
    }

    public static PSNameResolver getPSNameResolverInstance(PSNameResolver pSNameResolver) {
        if (pSNameResolver instanceof PSNameFontDatabase) {
            return new PSNameFontDatabase((PSNameFontDatabase)pSNameResolver);
        }
        return null;
    }

    public static PlatformFontResolver getPlatformFontResolverInstance() {
        return new PlatformFontResolverImpl();
    }

    public static PlatformFontResolver getPlatformFontResolverInstance(PlatformFontResolver platformFontResolver) {
        if (platformFontResolver instanceof PlatformFontResolverImpl) {
            return new PlatformFontResolverImpl((PlatformFontResolverImpl)platformFontResolver);
        }
        return null;
    }

    public static PlatformFontResolver getPlatformFontResolverInstance(FamilyNameNormalizer familyNameNormalizer) {
        return new PlatformFontResolverImpl(familyNameNormalizer);
    }

    public static FXGFontResolver getFXGFontResolverInstance() {
        return new FXGFontResolverImpl();
    }

    public static FXGFontResolver getFXGFontResolverInstance(FXGFontResolver fXGFontResolver) {
        if (fXGFontResolver instanceof FXGFontResolverImpl) {
            return new FXGFontResolverImpl((FXGFontResolverImpl)fXGFontResolver);
        }
        return null;
    }

    private static int determineFileType(FontInputStream fontInputStream, URL uRL) throws IOException {
        int n = -1;
        byte[] byArray = new byte[maxBytesNeeded];
        int n2 = fontInputStream.read(byArray);
        if (n2 >= otBN && com.adobe.fontengine.font.opentype.FontFactory.isOpenType(byArray)) {
            n = 2;
        } else if (n2 >= t1BN && com.adobe.fontengine.font.type1.FontFactory.isType1(byArray)) {
            n = 1;
        } else if (n2 >= pfmBN && com.adobe.fontengine.font.type1.FontFactory.isPFM(byArray)) {
            n = 4;
        } else if (n2 >= afmBN && com.adobe.fontengine.font.type1.FontFactory.isAFM(byArray)) {
            n = 5;
        } else if (n2 >= cffBN && com.adobe.fontengine.font.cff.FontFactory.isCFF(byArray)) {
            n = 3;
        } else if (uRL != null) {
            switch (FontFactory.isResourceFont(byArray, uRL)) {
                case 2: {
                    n = 6;
                    break;
                }
                case 1: {
                    n = 7;
                }
            }
        }
        if (n2 > 0) {
            fontInputStream.unread(byArray, 0, n2);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void loadFont(URL uRL, List list, List list2, List list3, boolean bl) throws IOException, InvalidFontException, UnsupportedFontException, FontLoadingException {
        FontInputStream fontInputStream = null;
        try {
            fontInputStream = new FontInputStream(uRL.openStream());
            switch (FontLoader.determineFileType(fontInputStream, uRL)) {
                case 1: {
                    Type1Font[] type1FontArray = com.adobe.fontengine.font.type1.FontFactory.load(fontInputStream, uRL);
                    if (type1FontArray.length != 1) {
                        return;
                    }
                    URLFont uRLFont = new URLFont(uRL, 0, type1FontArray[0]);
                    list.add(new T1AlignmentHolder(uRLFont, new FontNameAlignmentData(type1FontArray[0].getPostscriptName())));
                    if (bl) {
                        list3.add(type1FontArray[0]);
                        return;
                    }
                    list3.add(uRLFont);
                    return;
                }
                case 2: {
                    OpenTypeFont[] openTypeFontArray = com.adobe.fontengine.font.opentype.FontFactory.load(fontInputStream);
                    int n = 0;
                    while (n < openTypeFontArray.length) {
                        if (bl) {
                            list3.add(openTypeFontArray[n]);
                        } else {
                            list3.add(new URLFont(uRL, n, openTypeFontArray[n]));
                        }
                        ++n;
                    }
                    return;
                }
                case 3: {
                    return;
                }
                case 4: {
                    MetricFile metricFile = com.adobe.fontengine.font.type1.FontFactory.loadPFM(fontInputStream, uRL);
                    if (metricFile == null) return;
                    list2.add(new MetricFileAlignmentHolder(uRL, new FontNameAlignmentData(metricFile.getFontName()), 4, metricFile));
                    return;
                }
                case 5: {
                    MetricFile metricFile = com.adobe.fontengine.font.type1.FontFactory.loadAFM(fontInputStream, uRL);
                    if (metricFile == null) return;
                    list2.add(new MetricFileAlignmentHolder(uRL, new FontNameAlignmentData(metricFile.getFontName()), 5, metricFile));
                    return;
                }
                case 6: {
                    ResourceFont[] resourceFontArray = FontFactory.load(uRL, 2);
                    int n = 0;
                    while (n < resourceFontArray.length) {
                        list3.add(resourceFontArray[n]);
                        ++n;
                    }
                    return;
                }
                case 7: {
                    ResourceFont[] resourceFontArray = FontFactory.load(uRL, 1);
                    int n = 0;
                    while (n < resourceFontArray.length) {
                        list3.add(resourceFontArray[n]);
                        ++n;
                    }
                    return;
                }
            }
            return;
        }
        finally {
            if (fontInputStream != null) {
                fontInputStream.close();
            }
        }
    }

    public Font[] load(URL uRL) throws FontLoadingException, InvalidFontException, UnsupportedFontException {
        try {
            FontInputStream fontInputStream = new FontInputStream(uRL.openStream());
            switch (FontLoader.determineFileType(fontInputStream, uRL)) {
                case 2: {
                    OpenTypeFont[] openTypeFontArray = com.adobe.fontengine.font.opentype.FontFactory.load(fontInputStream);
                    Font[] fontArray = new Font[openTypeFontArray.length];
                    for (int i = 0; i < openTypeFontArray.length; ++i) {
                        fontArray[i] = new URLFont(uRL, i, openTypeFontArray[i]);
                    }
                    return fontArray;
                }
                case 1: {
                    Font[] fontArray = new Font[]{new URLFont(uRL, 0)};
                    return fontArray;
                }
                case 6: {
                    Font[] fontArray = FontFactory.load(uRL, 2);
                    return fontArray;
                }
                case 7: {
                    Font[] fontArray = FontFactory.load(uRL, 1);
                    return fontArray;
                }
            }
            return new Font[0];
        }
        catch (IOException iOException) {
            throw new FontLoadingException(iOException);
        }
    }

    public Font[] load(URL[] uRLArray, List list) {
        ArrayList arrayList;
        block9: {
            arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            ArrayList arrayList3 = new ArrayList();
            for (int i = 0; i < uRLArray.length; ++i) {
                try {
                    FontLoader.loadFont(uRLArray[i], arrayList2, arrayList3, arrayList, false);
                    continue;
                }
                catch (InvalidFontException invalidFontException) {
                    if (list == null) continue;
                    list.add(invalidFontException);
                    continue;
                }
                catch (UnsupportedFontException unsupportedFontException) {
                    if (list == null) continue;
                    list.add(unsupportedFontException);
                    continue;
                }
                catch (IOException iOException) {
                    if (list == null) continue;
                    list.add(new FontLoadingException(iOException));
                    continue;
                }
                catch (FontLoadingException fontLoadingException) {
                    if (list == null) continue;
                    list.add(new FontLoadingException(fontLoadingException));
                }
            }
            try {
                FontLoader.alignMetricFilesWithOutlines(arrayList3, arrayList2);
            }
            catch (FontEngineException fontEngineException) {
                if (list == null) break block9;
                list.add(fontEngineException);
            }
        }
        if (arrayList.isEmpty()) {
            return new Font[0];
        }
        Font[] fontArray = new Font[arrayList.size()];
        arrayList.toArray(fontArray);
        return fontArray;
    }

    public Font[] load(URL[] uRLArray, List list, List list2) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        for (int i = 0; i < uRLArray.length; ++i) {
            try {
                FontLoader.loadFont(uRLArray[i], arrayList2, arrayList3, arrayList, false);
                continue;
            }
            catch (FontException fontException) {
                if (list != null) {
                    list.add(fontException);
                }
                if (list2 == null) continue;
                list2.add(uRLArray[i]);
                continue;
            }
            catch (IOException iOException) {
                if (list != null) {
                    list.add(new FontLoadingException(iOException));
                }
                if (list2 == null) continue;
                list2.add(uRLArray[i]);
            }
        }
        FontLoader.alignMetricFilesWithOutlines(arrayList3, arrayList2, list, list2);
        if (arrayList.isEmpty()) {
            return new Font[0];
        }
        Font[] fontArray = new Font[arrayList.size()];
        arrayList.toArray(fontArray);
        return fontArray;
    }

    public Font load(InputStream inputStream, int n, boolean bl) throws FontLoadingException {
        try {
            FontInputStream fontInputStream = new FontInputStream(inputStream);
            switch (FontLoader.determineFileType(fontInputStream, null)) {
                case 1: 
                case 2: 
                case 3: {
                    return new StreamFont(fontInputStream, n, bl);
                }
            }
            return null;
        }
        catch (IOException iOException) {
            throw new FontLoadingException(iOException);
        }
        catch (InvalidFontException invalidFontException) {
            throw new FontLoadingException(invalidFontException);
        }
        catch (UnsupportedFontException unsupportedFontException) {
            throw new FontLoadingException(unsupportedFontException);
        }
    }

    public Font[] load(File file, boolean bl, List list) {
        Font[] fontArray;
        ArrayList arrayList;
        block7: {
            File file2;
            DirectoryWalker directoryWalker = new DirectoryWalker(file, bl);
            ArrayList arrayList2 = new ArrayList();
            ArrayList arrayList3 = new ArrayList();
            arrayList = new ArrayList();
            while ((file2 = directoryWalker.getNextFile()) != null) {
                try {
                    fontArray = file2.toURI().toURL();
                    FontLoader.loadFont((URL)fontArray, arrayList2, arrayList3, arrayList, false);
                }
                catch (FontEngineException fontEngineException) {
                    if (list == null) continue;
                    list.add(fontEngineException);
                }
                catch (IOException iOException) {
                    if (list == null) continue;
                    list.add(new FontLoadingException(iOException));
                }
            }
            try {
                FontLoader.alignMetricFilesWithOutlines(arrayList3, arrayList2);
            }
            catch (FontEngineException fontEngineException) {
                if (list == null) break block7;
                list.add(fontEngineException);
            }
        }
        if (arrayList.size() == 0) {
            return new URLFont[0];
        }
        fontArray = new Font[arrayList.size()];
        arrayList.toArray(fontArray);
        return fontArray;
    }

    public Font[] load(File file, boolean bl, List list, List list2) {
        Font[] fontArray;
        File file2;
        DirectoryWalker directoryWalker = new DirectoryWalker(file, bl);
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        while ((file2 = directoryWalker.getNextFile()) != null) {
            fontArray = null;
            try {
                fontArray = file2.toURI().toURL();
                FontLoader.loadFont((URL)fontArray, arrayList, arrayList2, arrayList3, false);
            }
            catch (FontEngineException fontEngineException) {
                if (list != null) {
                    list.add(fontEngineException);
                }
                if (list2 == null) continue;
                list2.add(fontArray);
            }
            catch (IOException iOException) {
                if (list != null) {
                    list.add(new FontLoadingException(iOException));
                }
                if (list2 == null) continue;
                list2.add(fontArray);
            }
        }
        FontLoader.alignMetricFilesWithOutlines(arrayList2, arrayList, list, list2);
        if (arrayList3.size() == 0) {
            return new URLFont[0];
        }
        fontArray = new URLFont[arrayList3.size()];
        arrayList3.toArray(fontArray);
        return fontArray;
    }

    static FontData[] fromStream(FontInputStream fontInputStream, int n) throws IOException, InvalidFontException, UnsupportedFontException {
        switch (FontLoader.determineFileType(fontInputStream, null)) {
            case 2: {
                return com.adobe.fontengine.font.opentype.FontFactory.load(fontInputStream);
            }
            case 3: {
                FontByteArray fontByteArray = new FontByteArray(fontInputStream, n);
                return com.adobe.fontengine.font.cff.FontFactory.load(fontByteArray);
            }
            case 1: {
                return com.adobe.fontengine.font.type1.FontFactory.load(fontInputStream, null);
            }
        }
        return new FontData[0];
    }

    private static void alignMetricFilesWithOutlines(List list, List list2) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        for (int i = 0; i < list.size(); ++i) {
            MetricFileAlignmentHolder metricFileAlignmentHolder = (MetricFileAlignmentHolder)list.get(i);
            for (int j = 0; j < list2.size(); ++j) {
                MetricFile metricFile;
                T1AlignmentHolder t1AlignmentHolder;
                block8: {
                    t1AlignmentHolder = (T1AlignmentHolder)list2.get(j);
                    if (!metricFileAlignmentHolder.data.dataAligns(t1AlignmentHolder.data)) continue;
                    try {
                        FontInputStream fontInputStream = new FontInputStream(metricFileAlignmentHolder.metricFileURL.openStream());
                        if (metricFileAlignmentHolder.metricFileType == 4) {
                            metricFile = (MetricFile)metricFileAlignmentHolder.metricFile.get();
                            if (metricFile == null) {
                                metricFile = com.adobe.fontengine.font.type1.FontFactory.loadPFM(fontInputStream, metricFileAlignmentHolder.metricFileURL);
                            }
                            break block8;
                        }
                        if (metricFileAlignmentHolder.metricFileType == 5) {
                            metricFile = (MetricFile)metricFileAlignmentHolder.metricFile.get();
                            if (metricFile == null) {
                                metricFile = com.adobe.fontengine.font.type1.FontFactory.loadAFM(fontInputStream, metricFileAlignmentHolder.metricFileURL);
                            }
                            break block8;
                        }
                        throw new FontLoadingException("unexpected metric file type");
                    }
                    catch (IOException iOException) {
                        throw new FontLoadingException(iOException);
                    }
                }
                t1AlignmentHolder.font.setMetricURL(metricFileAlignmentHolder.metricFileURL, metricFile);
            }
        }
    }

    private static void alignMetricFilesWithOutlines(List list, List list2, List list3, List list4) {
        for (int i = 0; i < list.size(); ++i) {
            MetricFileAlignmentHolder metricFileAlignmentHolder = (MetricFileAlignmentHolder)list.get(i);
            for (int j = 0; j < list2.size(); ++j) {
                T1AlignmentHolder t1AlignmentHolder = (T1AlignmentHolder)list2.get(j);
                if (!metricFileAlignmentHolder.data.dataAligns(t1AlignmentHolder.data)) continue;
                try {
                    MetricFile metricFile;
                    FontInputStream fontInputStream = new FontInputStream(metricFileAlignmentHolder.metricFileURL.openStream());
                    if (metricFileAlignmentHolder.metricFileType == 4) {
                        metricFile = (MetricFile)metricFileAlignmentHolder.metricFile.get();
                        if (metricFile == null) {
                            metricFile = com.adobe.fontengine.font.type1.FontFactory.loadPFM(fontInputStream, metricFileAlignmentHolder.metricFileURL);
                        }
                    } else if (metricFileAlignmentHolder.metricFileType == 5) {
                        metricFile = (MetricFile)metricFileAlignmentHolder.metricFile.get();
                        if (metricFile == null) {
                            metricFile = com.adobe.fontengine.font.type1.FontFactory.loadAFM(fontInputStream, metricFileAlignmentHolder.metricFileURL);
                        }
                    } else {
                        throw new FontLoadingException("unexpected metric file type");
                    }
                    t1AlignmentHolder.font.setMetricURL(metricFileAlignmentHolder.metricFileURL, metricFile);
                    continue;
                }
                catch (IOException iOException) {
                    if (list3 != null) {
                        list3.add(new FontLoadingException(iOException));
                    }
                    if (list4 == null) continue;
                    list4.add(t1AlignmentHolder.font.outlineFileURL);
                    continue;
                }
                catch (FontException fontException) {
                    if (list3 != null) {
                        list3.add(fontException);
                    }
                    if (list4 == null) continue;
                    list4.add(t1AlignmentHolder.font.outlineFileURL);
                }
            }
        }
    }

    static FontData[] fromURL(URL uRL, URL uRL2) throws InvalidFontException, UnsupportedFontException, FontLoadingException, IOException {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        FontLoader.loadFont(uRL, arrayList2, arrayList3, arrayList, true);
        if (uRL2 != null) {
            FontLoader.loadFont(uRL2, arrayList2, arrayList3, arrayList, true);
        }
        FontLoader.alignMetricFilesWithOutlines(arrayList3, arrayList2);
        if (arrayList.isEmpty()) {
            return new FontData[0];
        }
        FontData[] fontDataArray = new FontData[arrayList.size()];
        arrayList.toArray(fontDataArray);
        return fontDataArray;
    }

    public Font load(PDFSimpleFontValuesAccessor pDFSimpleFontValuesAccessor) throws InvalidFontException, UnsupportedFontException {
        return new MemoryFont(new PDFSimpleFont(pDFSimpleFontValuesAccessor));
    }

    static FontData fromResourceURL(URL uRL, int n, int n2, int n3) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        return FontFactory.load(uRL, n, n2, n3);
    }

    public synchronized Font[] load(File file, boolean bl, List list, List list2, File file2) {
        Object object;
        File file3;
        HashMap<String, FontImpl[]> hashMap;
        ArrayList<FontImpl> arrayList;
        ArrayList arrayList2;
        ArrayList arrayList3;
        DirectoryWalker directoryWalker;
        block18: {
            directoryWalker = new DirectoryWalker(file, bl);
            arrayList3 = new ArrayList();
            arrayList2 = new ArrayList();
            arrayList = new ArrayList<FontImpl>();
            hashMap = null;
            try {
                hashMap = this.initializeCacheFile(file2);
            }
            catch (IOException iOException) {
                if (list == null) break block18;
                list.add(iOException);
            }
        }
        while ((file3 = directoryWalker.getNextFile()) != null) {
            object = null;
            try {
                if (hashMap != null) {
                    int n;
                    String string = file3.getCanonicalPath();
                    FontImpl[] fontImplArray = hashMap.get(string);
                    FontImpl[] fontImplArray2 = this.mGlobalFontMap.get(string);
                    if ((fontImplArray2 = this.mergeFileNodes(file3, fontImplArray, fontImplArray2)) == null) {
                        block19: {
                            object = file3.toURI().toURL();
                            n = arrayList.size();
                            try {
                                FontLoader.loadFont((URL)object, arrayList3, arrayList2, arrayList, false);
                            }
                            catch (FontEngineException fontEngineException) {
                                if (list != null) {
                                    list.add(fontEngineException);
                                }
                                if (list2 == null) break block19;
                                list2.add(object);
                            }
                        }
                        fontImplArray2 = new FontImpl[arrayList.size() - n];
                        for (int i = 0; i < arrayList.size() - n; ++i) {
                            FontImpl fontImpl;
                            fontImplArray2[i] = fontImpl = (FontImpl)arrayList.get(n + i);
                        }
                    } else {
                        for (n = 0; n < fontImplArray2.length; ++n) {
                            FontImpl fontImpl = fontImplArray2[n];
                            arrayList.add(fontImpl);
                        }
                    }
                    hashMap.put(string, fontImplArray2);
                    this.mGlobalFontMap.put(string, fontImplArray2);
                    for (HashMap<String, FontImpl[]> hashMap2 : this.mGlobalCacheMap.values()) {
                        if (hashMap2 == hashMap || !hashMap2.containsKey(string)) continue;
                        hashMap2.put(string, fontImplArray2);
                    }
                    continue;
                }
                object = file3.toURI().toURL();
                FontLoader.loadFont((URL)object, arrayList3, arrayList2, arrayList, false);
            }
            catch (FontEngineException fontEngineException) {
                if (list != null) {
                    list.add(fontEngineException);
                }
                if (list2 == null) continue;
                list2.add(object);
            }
            catch (IOException iOException) {
                if (list != null) {
                    list.add(new FontLoadingException(iOException));
                }
                if (list2 == null) continue;
                list2.add(object);
            }
        }
        FontLoader.alignMetricFilesWithOutlines(arrayList2, arrayList3, list, list2);
        if (arrayList.size() == 0) {
            return new URLFont[0];
        }
        object = new Font[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, FontImpl[]> initializeCacheFile(File file) throws IOException {
        HashMap hashMap = null;
        if (file == null) {
            return hashMap;
        }
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException("Cannot create font cache");
        }
        if (!file.canRead()) {
            throw new IOException("Cannot read font cache");
        }
        if (!file.canWrite()) {
            throw new IOException("Cannot write font cache");
        }
        String string = file.getCanonicalPath();
        if (this.mGlobalCacheMap.containsKey(string)) {
            hashMap = this.mGlobalCacheMap.get(string);
        } else {
            if (file.length() != 0L) {
                FileInputStream fileInputStream = null;
                ObjectInputStream objectInputStream = null;
                try {
                    fileInputStream = new FileInputStream(file);
                    objectInputStream = new ObjectInputStream(fileInputStream);
                    hashMap = (HashMap)objectInputStream.readObject();
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (IOException iOException) {
                }
                finally {
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    } else if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
            }
            if (hashMap == null) {
                file.delete();
                file.createNewFile();
                hashMap = new HashMap();
            }
            this.mGlobalCacheMap.put(string, hashMap);
        }
        return hashMap;
    }

    private FontImpl[] mergeFileNodes(File file, FontImpl[] fontImplArray, FontImpl[] fontImplArray2) throws IOException {
        FontImpl fontImpl;
        if (fontImplArray != null && fontImplArray.length > 0 && ((fontImpl = fontImplArray[0]).getLength() != file.length() || fontImpl.getLastModified() != file.lastModified())) {
            fontImplArray = null;
        }
        if (fontImplArray2 == null) {
            return fontImplArray;
        }
        if (fontImplArray != null) {
            if (fontImplArray.length != fontImplArray2.length) {
                return null;
            }
            for (int i = 0; i < fontImplArray.length; ++i) {
                FontImpl fontImpl2 = fontImplArray[i];
                FontImpl fontImpl3 = fontImplArray2[i];
                for (String string : fontImpl2.getCachedFontDescriptionMap().keySet()) {
                    if (fontImpl3.getCachedFontDescription(string) != null) continue;
                    fontImpl3.setCachedFontDescription(string, fontImpl2.getCachedFontDescription(string));
                }
            }
        }
        return fontImplArray2;
    }

    public synchronized void saveAllCaches(boolean bl) throws IOException {
        for (String string : this.mGlobalCacheMap.keySet()) {
            File file = new File(string);
            this.saveCache(file, bl);
        }
    }

    public synchronized boolean saveCache(File file, boolean bl) throws IOException {
        String string = file.getCanonicalPath();
        HashMap<String, FontImpl[]> hashMap = this.mGlobalCacheMap.get(string);
        if (hashMap != null) {
            Object object;
            Object object2;
            if (bl) {
                object2 = hashMap.keySet().iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    if (this.mGlobalFontMap.containsKey(object)) continue;
                    object2.remove();
                }
            }
            file.delete();
            file.createNewFile();
            object2 = new FileOutputStream(file);
            object = new ObjectOutputStream((OutputStream)object2);
            ((ObjectOutputStream)object).writeObject(hashMap);
            ((ObjectOutputStream)object).close();
            return true;
        }
        return false;
    }

    public synchronized boolean decommissionCachedFont(File file) throws IOException {
        boolean bl;
        String string = file.getCanonicalPath();
        boolean bl2 = bl = this.mGlobalFontMap.remove(string) != null;
        if (bl) {
            for (HashMap<String, FontImpl[]> hashMap : this.mGlobalCacheMap.values()) {
                hashMap.remove(string);
            }
        }
        return bl;
    }

    public synchronized void decommissionAllCaches() {
        this.mGlobalCacheMap.clear();
        this.mGlobalFontMap.clear();
    }

    public synchronized boolean decommissionCache(File file) {
        try {
            String string = file.getCanonicalPath();
            HashMap<String, FontImpl[]> hashMap = this.mGlobalCacheMap.remove(string);
            if (hashMap != null) {
                for (String string2 : hashMap.keySet()) {
                    boolean bl = false;
                    for (HashMap<String, FontImpl[]> hashMap2 : this.mGlobalCacheMap.values()) {
                        if (!hashMap2.containsKey(string2)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    this.mGlobalFontMap.remove(string2);
                }
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    static {
        t1BN = com.adobe.fontengine.font.type1.FontFactory.getNumBytesNeededToIdentify();
        otBN = com.adobe.fontengine.font.opentype.FontFactory.getNumBytesNeededToIdentify();
        cffBN = com.adobe.fontengine.font.cff.FontFactory.getNumBytesNeededToIdentify();
        afmBN = com.adobe.fontengine.font.type1.FontFactory.getNumBytesNeededToIdentifyAFM();
        pfmBN = com.adobe.fontengine.font.type1.FontFactory.getNumBytesNeededToIdentifyPFM();
        macBN = FontFactory.getNumBytesNeededToIdentify();
        int n = pfmBN;
        if (n < otBN) {
            n = otBN;
        }
        if (n < cffBN) {
            n = cffBN;
        }
        if (n < t1BN) {
            n = t1BN;
        }
        if (n < afmBN) {
            n = afmBN;
        }
        if (n < macBN) {
            n = macBN;
        }
        maxBytesNeeded = n;
    }

    private static class MetricFileAlignmentHolder {
        final URL metricFileURL;
        final MetricFileAlignmentData data;
        final int metricFileType;
        final SoftReference metricFile;

        MetricFileAlignmentHolder(URL uRL, MetricFileAlignmentData metricFileAlignmentData, int n, MetricFile metricFile) {
            this.metricFileURL = uRL;
            this.data = metricFileAlignmentData;
            this.metricFileType = n;
            this.metricFile = new SoftReference<MetricFile>(metricFile);
        }
    }

    private static class T1AlignmentHolder {
        final URLFont font;
        final MetricFileAlignmentData data;

        T1AlignmentHolder(URLFont uRLFont, MetricFileAlignmentData metricFileAlignmentData) {
            this.font = uRLFont;
            this.data = metricFileAlignmentData;
        }
    }

    private static class FontNameAlignmentData
    implements MetricFileAlignmentData {
        private final String fontName;

        FontNameAlignmentData(String string) {
            this.fontName = string;
        }

        public boolean dataAligns(MetricFileAlignmentData metricFileAlignmentData) {
            return metricFileAlignmentData instanceof FontNameAlignmentData && ((FontNameAlignmentData)metricFileAlignmentData).fontName.equals(this.fontName);
        }
    }

    static interface MetricFileAlignmentData {
        public boolean dataAligns(MetricFileAlignmentData var1);
    }
}

