/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.LayoutTable;
import com.adobe.fontengine.font.opentype.LayoutTableSubsetter;
import com.adobe.fontengine.font.opentype.LookupTableSubsetter;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.SetGenerator;
import java.util.Arrays;
import java.util.Map;

class ChainingGenerator {
    private static final boolean warnAboutDroppedSublookups = false;

    ChainingGenerator() {
    }

    static LookupTableSubsetter.LookupSubtableGenerator newChainingInstance(LayoutTable layoutTable, OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n, int n2, Subset subset, Map map, LookupTableSubsetter.LookupSubset lookupSubset, int n3) throws InvalidFontException {
        int n4 = layoutTable.data.getuint16(n);
        switch (n4) {
            case 1: {
                return ChainingFormat1Generator.newInstance(n, n2, layoutTable, subset, oTByteArrayBuilder, map, lookupSubset);
            }
            case 2: {
                return ChainingFormat2Generator.newInstance(n, n2, layoutTable, subset, oTByteArrayBuilder, lookupSubset, n3);
            }
            case 3: {
                return ChainingFormat3Generator.newInstance(layoutTable, oTByteArrayBuilder, n, n2, lookupSubset);
            }
        }
        throw new InvalidFontException("Invalid chaining contextual lookup format: " + n4);
    }

    static void gatherCoveragesForSubtable(LayoutTable layoutTable, int n, int n2, int n3, Integer n4, Map map, Subset subset) throws InvalidFontException, UnsupportedFontException {
        int n5 = layoutTable.data.getuint16(n);
        switch (n5) {
            case 1: 
            case 2: {
                int n6 = layoutTable.data.getOffset(n, 2);
                LookupTableSubsetter.addToCoveragesMap(layoutTable, n6, map, n3, n4, subset);
                break;
            }
            case 3: {
                int n7;
                int n8;
                int n9;
                int n10 = layoutTable.data.getuint16(n + 2);
                for (n9 = 0; n9 < n10; ++n9) {
                    n8 = layoutTable.data.getOffset(n, 4 + 2 * n9);
                    LookupTableSubsetter.addToCoveragesMap(layoutTable, n8, map, n3, n4, subset);
                }
                n9 = 4 + 2 * n10;
                n10 = layoutTable.data.getuint16(n + n9);
                for (n8 = 0; n8 < n10; ++n8) {
                    n7 = layoutTable.data.getOffset(n, n9 + 2 + 2 * n8);
                    LookupTableSubsetter.addToCoveragesMap(layoutTable, n7, map, n3, n4, subset);
                }
                n9 += 2 + 2 * n10;
                n10 = layoutTable.data.getuint16(n + n9);
                for (n8 = 0; n8 < n10; ++n8) {
                    n7 = layoutTable.data.getOffset(n, n9 + 2 + 2 * n8);
                    LookupTableSubsetter.addToCoveragesMap(layoutTable, n7, map, n3, n4, subset);
                }
                break;
            }
            default: {
                throw new InvalidFontException("Invalid contextual subtable format (" + n5 + ")");
            }
        }
    }

    static void patchSubtableCoverage(LayoutTable layoutTable, OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n, int n2, Map map, int n3) throws InvalidFontException {
        int n4 = layoutTable.data.getuint16(n);
        switch (n4) {
            case 1: 
            case 2: {
                LookupTableSubsetter.patchCoverageAtOffset(layoutTable, oTByteArrayBuilder, n, n2, 2, map);
                break;
            }
            case 3: {
                int n5;
                int n6 = layoutTable.data.getuint16(n + 2);
                int n7 = layoutTable.data.getuint16(n + 4 + 2 * n6);
                int n8 = layoutTable.data.getuint16(n + 6 + 2 * n6 + 2 * n7);
                for (n5 = 0; n5 < n6; ++n5) {
                    LookupTableSubsetter.patchCoverageAtOffset(layoutTable, oTByteArrayBuilder, n, n2, 4 + 2 * n5, map);
                }
                for (n5 = 0; n5 < n7; ++n5) {
                    LookupTableSubsetter.patchCoverageAtOffset(layoutTable, oTByteArrayBuilder, n, n2, 6 + 2 * n6 + 2 * n5, map);
                }
                for (n5 = 0; n5 < n8; ++n5) {
                    LookupTableSubsetter.patchCoverageAtOffset(layoutTable, oTByteArrayBuilder, n, n2, 8 + 2 * n7 + 2 * n6 + 2 * n5, map);
                }
                break;
            }
            default: {
                throw new InvalidFontException("Unrecognized lookup type 6 format: " + n4);
            }
        }
    }

    private static class ChainingFormat3Generator
    implements LookupTableSubsetter.LookupSubtableGenerator {
        private final LayoutTable origTable;
        private final OTByteArray.OTByteArrayBuilder builder;
        private int origSTOffset;
        private int newSTOffset;
        private final LookupTableSubsetter.LookupSubset lookupSubset;

        private ChainingFormat3Generator(LayoutTable layoutTable, OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n, int n2, LookupTableSubsetter.LookupSubset lookupSubset) {
            this.origTable = layoutTable;
            this.builder = oTByteArrayBuilder;
            this.origSTOffset = n;
            this.newSTOffset = n2;
            this.lookupSubset = lookupSubset;
        }

        static ChainingFormat3Generator newInstance(LayoutTable layoutTable, OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n, int n2, LookupTableSubsetter.LookupSubset lookupSubset) {
            return new ChainingFormat3Generator(layoutTable, oTByteArrayBuilder, n, n2, lookupSubset);
        }

        public int writeSubtable() throws InvalidFontException {
            int n = this.origTable.data.getuint16(this.origSTOffset + 2);
            this.origSTOffset += 4 + 2 * n;
            int n2 = this.origTable.data.getuint16(this.origSTOffset);
            this.origSTOffset += 2 + 2 * n2;
            int n3 = this.origTable.data.getuint16(this.origSTOffset);
            this.origSTOffset += 2 + 2 * n3;
            int n4 = this.origTable.data.getuint16(this.origSTOffset);
            this.origSTOffset += 2;
            int n5 = 10 + 2 * n + 2 * n2 + 2 * n3;
            this.builder.ensureCapacity(this.newSTOffset + n5);
            this.builder.setuint16(this.newSTOffset, 3);
            this.builder.setuint16(this.newSTOffset + 2, n);
            this.newSTOffset += 4 + 2 * n;
            this.builder.setuint16(this.newSTOffset, n2);
            this.newSTOffset += 2 + 2 * n2;
            this.builder.setuint16(this.newSTOffset, n3);
            this.newSTOffset += 2 + 2 * n3;
            int n6 = 0;
            for (int i = 0; i < n4; ++i) {
                int n7 = this.lookupSubset.getExistingSubsetGid(this.origTable.data.getuint16(this.origSTOffset + 4 * i + 2));
                if (n7 == -1) continue;
                this.builder.ensureCapacity(this.newSTOffset + (n5 += 4));
                this.builder.setuint16(this.newSTOffset + 2 + 4 * n6, this.origTable.data.getuint16(this.origSTOffset + 4 * i));
                this.builder.setuint16(this.newSTOffset + 2 + 4 * n6 + 2, n7);
                ++n6;
            }
            this.builder.setuint16(this.newSTOffset, n6);
            return n5;
        }
    }

    private static class ChainingFormat2Generator
    extends SetGenerator
    implements LayoutTable.CoverageConsumer {
        private final LookupTableSubsetter.LookupSubset lookupSubset;
        private final LayoutTableSubsetter.ClassCoveredBySubset classCovered;
        private final int numGlyphs;
        private final int classCount;

        private ChainingFormat2Generator(LayoutTable layoutTable, Subset subset, OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n, int n2, int n3, LookupTableSubsetter.LookupSubset lookupSubset, int n4) throws InvalidFontException {
            super(layoutTable, subset, oTByteArrayBuilder, n, n2, n3, 10, true, true);
            this.lookupSubset = lookupSubset;
            this.classCovered = new LayoutTableSubsetter.ClassCoveredBySubset(subset);
            this.numGlyphs = n4;
            this.classCount = n3;
        }

        static ChainingFormat2Generator newInstance(int n, int n2, LayoutTable layoutTable, Subset subset, OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, LookupTableSubsetter.LookupSubset lookupSubset, int n3) throws InvalidFontException {
            int n4 = layoutTable.data.getuint16(n + 10);
            return new ChainingFormat2Generator(layoutTable, subset, oTByteArrayBuilder, n2, n, n4, lookupSubset, n3);
        }

        boolean[] computeMembersToKeep(int n, int n2) throws InvalidFontException, UnsupportedFontException {
            int n3 = this.origTable.data.getuint16(n2);
            boolean[] blArray = new boolean[n3];
            Arrays.fill(blArray, true);
            block0: for (int i = 0; i < n3; ++i) {
                int n4;
                int n5 = this.origTable.data.getOffset(n2, 2 + 2 * i);
                int n6 = 2;
                int n7 = this.origTable.data.getuint16(n5);
                int n8 = this.origTable.data.getOffset(this.origSTOffset, 4);
                for (n4 = 0; n4 < n7; ++n4) {
                    if (this.classCovered.classCoveredBySubset(this.origTable, n8, this.numGlyphs, this.origTable.data.getuint16(n5 + n6 + 2 * n4))) continue;
                    blArray[i] = false;
                    break;
                }
                n6 += 2 * n7;
                n8 = this.origTable.data.getOffset(this.origSTOffset, 6);
                n7 = this.origTable.data.getuint16(n5 + n6);
                n6 += 2;
                for (n4 = 0; n4 < n7 - 1; ++n4) {
                    if (this.classCovered.classCoveredBySubset(this.origTable, n8, this.numGlyphs, this.origTable.data.getuint16(n5 + n6 + 2 * n4))) continue;
                    blArray[i] = false;
                    break;
                }
                n6 += 2 * (n7 - 1);
                n8 = this.origTable.data.getOffset(this.origSTOffset, 8);
                n7 = this.origTable.data.getuint16(n5 + n6);
                n6 += 2;
                for (n4 = 0; n4 < n7; ++n4) {
                    if (this.classCovered.classCoveredBySubset(this.origTable, n8, this.numGlyphs, this.origTable.data.getuint16(n5 + n6 + 2 * n4))) continue;
                    blArray[i] = false;
                    continue block0;
                }
            }
            return blArray;
        }

        int writeMember(int n, int n2) throws InvalidFontException, UnsupportedFontException {
            int n3;
            int n4 = this.origTable.data.getuint16(n2);
            int n5 = this.origTable.data.getuint16(n2 + 2 + 2 * n4);
            int n6 = this.origTable.data.getuint16(n2 + 2 + 2 * n4 + 2 + 2 * (n5 - 1));
            int n7 = this.origTable.data.getuint16(n2 + 2 + 2 * n4 + 2 + 2 * (n5 - 1) + 2 + 2 * n6);
            int n8 = 2 + 2 * n4 + 2 + 2 * (n5 - 1) + 2 + 2 * n6 + 2;
            this.builder.ensureCapacity(n + n8);
            this.builder.setuint16(n, n4);
            int n9 = 2;
            for (n3 = 0; n3 < n4; ++n3) {
                this.builder.setuint16(n + n9, this.origTable.data.getuint16(n2 + n9));
                n9 += 2;
            }
            this.builder.setuint16(n + n9, n5);
            n9 += 2;
            for (n3 = 0; n3 < n5 - 1; ++n3) {
                this.builder.setuint16(n + n9, this.origTable.data.getuint16(n2 + n9));
                n9 += 2;
            }
            this.builder.setuint16(n + n9, n6);
            n9 += 2;
            for (n3 = 0; n3 < n6; ++n3) {
                this.builder.setuint16(n + n9, this.origTable.data.getuint16(n2 + n9));
                n9 += 2;
            }
            n3 = n9;
            int n10 = 0;
            n9 += 2;
            for (int i = 0; i < n7; ++i) {
                int n11 = this.lookupSubset.getExistingSubsetGid(this.origTable.data.getuint16(n2 + n9 + 2));
                if (n11 != -1) {
                    this.builder.ensureCapacity(n + n8 + 4);
                    this.builder.setuint16(n + n8, this.origTable.data.getuint16(n2 + n9));
                    this.builder.setuint16(n + n8 + 2, n11);
                    n8 += 4;
                    ++n10;
                }
                n9 += 4;
            }
            this.builder.setuint16(n + n3, n10);
            return n8;
        }

        void writeClassDef(int n) throws InvalidFontException, UnsupportedFontException {
            LayoutTableSubsetter.ClassDefGenerator classDefGenerator = LayoutTableSubsetter.ClassDefGenerator.newInstance(this.origTable, this.origTable.data.getOffset(this.origSTOffset, n), this.subset, this.numGlyphs);
            this.builder.setuint16(this.newSTOffset + n, this.subtableSize);
            OTByteArray oTByteArray = classDefGenerator.generateClass().toOTByteArray();
            this.subtableSize += this.writeByteArrayAtOffset(this.newSTOffset + this.subtableSize, oTByteArray);
        }

        int whichRuleSetIndexApplies(int n, int n2) throws InvalidFontException {
            return this.origTable.getClassIndex(n, this.origTable.data.getOffset(this.origSTOffset, 6));
        }

        int getOrigRecordSize() {
            return 0;
        }

        public int writeSubtable() throws InvalidFontException, UnsupportedFontException {
            int n = this.origTable.data.getOffset(this.origSTOffset, 2);
            this.builder.ensureCapacity(this.newSTOffset + 12 + 2 * this.classCount);
            this.builder.setuint16(this.newSTOffset, 2);
            this.builder.setuint16(this.newSTOffset + 10, this.classCount);
            this.origTable.iterateCoverage(n, this.subset, this);
            this.writeClassDef(4);
            this.writeClassDef(6);
            this.writeClassDef(8);
            return this.subtableSize;
        }
    }

    private static class ChainingFormat1Generator
    extends SetGenerator
    implements LayoutTable.CoverageConsumer {
        private final LookupTableSubsetter.LookupSubset lookupSubset;
        private final int ruleCount;

        private ChainingFormat1Generator(LayoutTable layoutTable, Subset subset, OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n, int n2, int n3, LookupTableSubsetter.LookupSubset lookupSubset) throws InvalidFontException {
            super(layoutTable, subset, oTByteArrayBuilder, n, n2, n3, 4, false, true);
            this.lookupSubset = lookupSubset;
            this.ruleCount = n3;
        }

        static ChainingFormat1Generator newInstance(int n, int n2, LayoutTable layoutTable, Subset subset, OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, Map map, LookupTableSubsetter.LookupSubset lookupSubset) throws InvalidFontException {
            int n3 = layoutTable.data.getOffset(n, 2);
            LookupTableSubsetter.NewCoverage newCoverage = (LookupTableSubsetter.NewCoverage)map.get(new Integer(n3));
            return new ChainingFormat1Generator(layoutTable, subset, oTByteArrayBuilder, n2, n, newCoverage.glyphCount, lookupSubset);
        }

        boolean[] computeMembersToKeep(int n, int n2) throws InvalidFontException, UnsupportedFontException {
            int n3 = this.origTable.data.getuint16(n2);
            boolean[] blArray = new boolean[n3];
            Arrays.fill(blArray, true);
            block0: for (int i = 0; i < n3; ++i) {
                int n4;
                int n5;
                int n6 = this.origTable.data.getOffset(n2, 2 + 2 * i);
                int n7 = this.origTable.data.getuint16(n6);
                for (n5 = 0; n5 < n7; ++n5) {
                    if (this.subset.getExistingSubsetGid(this.origTable.data.getuint16(n6 + 2 + 2 * n5)) != -1) continue;
                    blArray[i] = false;
                    break;
                }
                if (!blArray[i]) continue;
                n5 = this.origTable.data.getuint16(n6 + 2 + 2 * n7);
                for (n4 = 0; n4 < n5 - 1; ++n4) {
                    if (this.subset.getExistingSubsetGid(this.origTable.data.getuint16(n6 + 4 + 2 * n7 + 2 * n4)) != -1) continue;
                    blArray[i] = false;
                    break;
                }
                if (!blArray[i]) continue;
                n4 = this.origTable.data.getuint16(n6 + 4 + 2 * (n5 - 1) + 2 * n7);
                for (int j = 0; j < n4; ++j) {
                    if (this.subset.getExistingSubsetGid(this.origTable.data.getuint16(n6 + 6 + 2 * (n5 - 1) + 2 * n7 + 2 * j)) != -1) continue;
                    blArray[i] = false;
                    continue block0;
                }
            }
            return blArray;
        }

        int writeMember(int n, int n2) throws InvalidFontException, UnsupportedFontException {
            int n3;
            int n4;
            int n5 = this.origTable.data.getuint16(n2);
            int n6 = this.origTable.data.getuint16(n2 + 2 + 2 * n5);
            int n7 = this.origTable.data.getuint16(n2 + 4 + 2 * n5 + 2 * (n6 - 1));
            int n8 = this.origTable.data.getuint16(n2 + 6 + 2 * n5 + 2 * (n6 - 1) + 2 * n7);
            int n9 = 8 + 2 * n5 + 2 * (n6 - 1) + 2 * n7;
            this.builder.ensureCapacity(n + n9);
            this.builder.setuint16(n, n5);
            for (n4 = 0; n4 < n5; ++n4) {
                n3 = this.subset.getExistingSubsetGid(this.origTable.data.getuint16(n2 + 2 + 2 * n4));
                if (n3 == -1) {
                    throw new RuntimeException("Backtrack gid not in subset? Can't happen!");
                }
                this.builder.setuint16(n + 2 + 2 * n4, n3);
            }
            n2 += 2 + 2 * n5;
            this.builder.setuint16(n += 2 + 2 * n5, n6);
            for (n4 = 0; n4 < n6 - 1; ++n4) {
                n3 = this.subset.getExistingSubsetGid(this.origTable.data.getuint16(n2 + 2 + 2 * n4));
                if (n3 == -1) {
                    throw new RuntimeException("Input gid not in subset? Can't happen!");
                }
                this.builder.setuint16(n + 2 + 2 * n4, n3);
            }
            n2 += 2 + 2 * (n6 - 1);
            this.builder.setuint16(n += 2 + 2 * (n6 - 1), n7);
            for (n4 = 0; n4 < n7; ++n4) {
                n3 = this.subset.getExistingSubsetGid(this.origTable.data.getuint16(n2 + 2 + 2 * n4));
                if (n3 == -1) {
                    throw new RuntimeException("Lookahead gid not in subset? Can't happen!");
                }
                this.builder.setuint16(n + 2 + 2 * n4, n3);
            }
            n += 2 + 2 * n7;
            n2 += 2 + 2 * n7;
            n4 = 0;
            for (n3 = 0; n3 < n8; ++n3) {
                int n10 = this.lookupSubset.getExistingSubsetGid(this.origTable.data.getuint16(n2 + 2 + 4 * n3 + 2));
                if (n10 == -1) continue;
                this.builder.ensureCapacity(n + (n9 += 4));
                this.builder.setuint16(n + 2 + 4 * n4, this.origTable.data.getuint16(n2 + 2 + 4 * n3));
                this.builder.setuint16(n + 2 + 4 * n4 + 2, n10);
                ++n4;
            }
            this.builder.setuint16(n, n4);
            return n9;
        }

        int whichRuleSetIndexApplies(int n, int n2) {
            return n2;
        }

        int getOrigRecordSize() {
            return 0;
        }

        private void writeHeader(int n, int n2) {
            this.builder.ensureCapacity(n + 6 + 2 * n2);
            this.builder.setuint16(n, 1);
            this.builder.setuint16(n + 4, n2);
        }

        public int writeSubtable() throws InvalidFontException, UnsupportedFontException {
            int n = this.origTable.data.getOffset(this.origSTOffset, 2);
            this.writeHeader(this.newSTOffset, this.ruleCount);
            this.origTable.iterateCoverage(n, this.subset, this);
            return super.writeSubtable();
        }
    }
}

