/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pki;

import com.adobe.pki.PKIUtils;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJException;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.Service;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.extensions.CRLDistributionPoints;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.cert.extensions.GeneralNames;
import com.rsa.certj.cert.extensions.X509V3Extension;
import com.rsa.certj.pkcs7.ContentInfo;
import com.rsa.certj.pkcs7.PKCS7Exception;
import com.rsa.certj.pkcs7.SignedData;
import com.rsa.certj.provider.db.MemoryDB;
import com.rsa.certj.provider.path.PKIXCertPath;
import com.rsa.certj.provider.revocation.CRLCertStatus;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.certj.spi.revocation.CertRevocationInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.util.Date;
import java.util.Vector;

public class PKIContext {
    private CertJ m_certJContext;
    private CRLCertStatus m_crlRevChecker;
    private PKIXCertPath m_graphBuilder;
    private MemoryDB m_inMemoryCertStoreProvider;
    private boolean m_isInit = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void Init() throws GeneralSecurityException {
        try {
            this.m_crlRevChecker = new CRLCertStatus("crlRevChecker");
            this.m_graphBuilder = new PKIXCertPath("PKIXGraphBuilder");
            this.m_inMemoryCertStoreProvider = new MemoryDB("inMemoryDB");
            this.m_certJContext = new CertJ();
            this.m_certJContext.addProvider(this.m_crlRevChecker);
            this.m_certJContext.addProvider(this.m_graphBuilder);
            this.m_certJContext.addProvider(this.m_inMemoryCertStoreProvider);
        }
        catch (CertJException e2) {
            throw new GeneralSecurityException(e2.getLocalizedMessage());
        }
        this.m_isInit = true;
    }

    private boolean isCertSelfSigned(X509Certificate x509Certificate) {
        X500Name issuer = x509Certificate.getIssuerName();
        X500Name subject = x509Certificate.getSubjectName();
        return issuer.equals(subject);
    }

    private void harvestCRLsFromChain(Vector inCertPath, Vector outCRLs) throws GeneralSecurityException {
        for (int i2 = 0; i2 < inCertPath.size(); ++i2) {
            X509Certificate currentCert = (X509Certificate)inCertPath.get(i2);
            this.getCRLsFromCert(currentCert, outCRLs);
        }
    }

    public boolean VerifyPathRevocation(Vector inCertPath, Vector inTrustAnchors, Vector inCerts, Vector inCRLs) throws GeneralSecurityException {
        boolean result = false;
        if (!this.m_isInit) {
            return false;
        }
        try {
            Service service = this.m_certJContext.bindService(1, "inMemoryDB");
            DatabaseService dbService = (DatabaseService)service;
            for (int i2 = 0; i2 < inCerts.size(); ++i2) {
                X509Certificate oneCert = new X509Certificate((byte[])inCerts.elementAt(i2), 0, 0);
                dbService.insertCertificate(oneCert);
            }
            Certificate[] trustAnchors = new Certificate[Math.max(inTrustAnchors.size(), 1)];
            for (int i3 = 0; i3 < inTrustAnchors.size(); ++i3) {
                X509Certificate x509TrustAnchor = new X509Certificate((byte[])inTrustAnchors.elementAt(i3), 0, 0);
                trustAnchors[i3] = x509TrustAnchor;
            }
            for (int crlIndex = 0; crlIndex < inCRLs.size(); ++crlIndex) {
                X509CRL oneCRL = new X509CRL((byte[])inCRLs.elementAt(crlIndex), 0, 0);
                dbService.insertCRL(oneCRL);
            }
            Date now = new Date();
            CertPathCtx revCheckPathCtx = new CertPathCtx(0, trustAnchors, null, now, dbService);
            boolean foundRevokedCert = false;
            for (int i4 = 0; i4 < inCertPath.size() && !foundRevokedCert; ++i4) {
                X509Certificate oneCert = new X509Certificate((byte[])inCertPath.elementAt(i4), 0, 0);
                CertRevocationInfo revInfo = this.m_certJContext.checkCertRevocation(revCheckPathCtx, oneCert);
                if (revInfo.getStatus() != 1) continue;
                foundRevokedCert = true;
            }
            result = !foundRevokedCert;
        }
        catch (CertificateException e2) {
            throw new GeneralSecurityException(e2.getLocalizedMessage());
        }
        catch (CertJException e3) {
            throw new GeneralSecurityException(e3.getLocalizedMessage());
        }
        return result;
    }

    public boolean VerifyCertPath(byte[] eeCert, Vector inTrustAnchors, Vector inCerts, Vector outPath, Vector outCRLs, Vector outCRLCerts, boolean ignoreValidationTime) throws GeneralSecurityException {
        boolean result = false;
        if (!this.m_isInit) {
            return false;
        }
        try {
            Vector outX509CRLcerts;
            Vector outX509CRLs;
            Vector outCertPath;
            X509Certificate x509EE;
            CertPathCtx pathCtx;
            Service service = this.m_certJContext.bindService(1, "inMemoryDB");
            DatabaseService dbService = (DatabaseService)service;
            for (int i2 = 0; i2 < inCerts.size(); ++i2) {
                X509Certificate oneCert = new X509Certificate((byte[])inCerts.elementAt(i2), 0, 0);
                dbService.insertCertificate(oneCert);
            }
            Certificate[] trustAnchors = new Certificate[Math.max(inTrustAnchors.size(), 1)];
            for (int i3 = 0; i3 < inTrustAnchors.size(); ++i3) {
                X509Certificate x509TrustAnchor = new X509Certificate((byte[])inTrustAnchors.elementAt(i3), 0, 0);
                trustAnchors[i3] = x509TrustAnchor;
            }
            Date now = new Date();
            int flags = 4;
            if (ignoreValidationTime) {
                flags |= 2;
            }
            if (this.m_certJContext.buildCertPath(pathCtx = new CertPathCtx(flags, trustAnchors, null, now, dbService), x509EE = new X509Certificate(eeCert, 0, 0), outCertPath = new Vector(), outX509CRLs = new Vector(), outX509CRLcerts = new Vector(), null)) {
                this.harvestCRLsFromChain(outCertPath, outCRLs);
                for (int i4 = 0; i4 < outCertPath.size(); ++i4) {
                    X509Certificate oneCert = (X509Certificate)outCertPath.elementAt(i4);
                    byte[] rawCert = new byte[oneCert.getDERLen(0)];
                    oneCert.getDEREncoding(rawCert, 0, oneCert.getDERLen(0));
                    outPath.add(rawCert);
                }
                result = true;
            }
        }
        catch (CertificateException e2) {
            throw new GeneralSecurityException(e2.getLocalizedMessage());
        }
        catch (CertJException e3) {
            throw new GeneralSecurityException(e3.getLocalizedMessage());
        }
        return result;
    }

    private void getCRLsFromCert(X509Certificate cert, Vector outCRLs) throws GeneralSecurityException {
        X509V3Extensions allExtension = cert.getExtensions();
        if (allExtension == null) {
            return;
        }
        try {
            X509V3Extension crldpExt = allExtension.getExtensionByType(31);
            if (crldpExt != null) {
                CRLDistributionPoints distPt = (CRLDistributionPoints)crldpExt;
                int numDPs = distPt.getDistributionPointCount();
                for (int i2 = 0; i2 < numDPs; ++i2) {
                    try {
                        Object name = distPt.getDistributionPointName(i2);
                        if (!(name instanceof GeneralNames)) continue;
                        GeneralNames genName = (GeneralNames)name;
                        for (int j2 = 0; j2 < genName.getNameCount(); ++j2) {
                            String url;
                            Vector crls;
                            GeneralName oneName = genName.getGeneralName(j2);
                            if (oneName.getGeneralNameType() != 7 || (crls = this.getCRLsFromURL(url = (String)oneName.getGeneralName())) == null) continue;
                            outCRLs.addAll(crls);
                        }
                        continue;
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
            }
        }
        catch (CertificateException e2) {
            throw new GeneralSecurityException("Unable to obtain CRLs: " + e2.getLocalizedMessage());
        }
        catch (NameException e3) {
            throw new GeneralSecurityException("Unable to obtain CRLs: " + e3.getLocalizedMessage());
        }
    }

    private Vector getCRLsFromURL(String url) throws GeneralSecurityException, IOException {
        byte[] result = null;
        URL crlURL = new URL(url);
        URLConnection crlConnection = crlURL.openConnection();
        crlConnection.setDoInput(true);
        ByteArrayOutputStream resultStream = new ByteArrayOutputStream();
        byte[] tempArray = new byte[512];
        int bytesRead = 0;
        InputStream is = null;
        try {
            is = crlConnection.getInputStream();
        }
        catch (IllegalArgumentException e2) {
            throw new GeneralSecurityException("Unable to obtain CRLs: " + e2.getLocalizedMessage());
        }
        while ((bytesRead = is.read(tempArray)) > 0) {
            resultStream.write(tempArray, 0, bytesRead);
        }
        result = resultStream.toByteArray();
        if (result != null) {
            Vector outCRLs = null;
            outCRLs = this.lookupPEMCRLs(result);
            if (outCRLs != null) {
                return outCRLs;
            }
            outCRLs = this.lookupPKCS7CRLs(result);
            if (outCRLs != null) {
                return outCRLs;
            }
            try {
                X509CRL crl = new X509CRL(result, 0, 0);
                outCRLs = new Vector();
                byte[] rawCRL = new byte[crl.getDERLen(0)];
                crl.getDEREncoding(rawCRL, 0, crl.getDERLen(0));
                outCRLs.add(rawCRL);
            }
            catch (CertificateException e1) {
                throw new java.security.cert.CertificateException(e1.getLocalizedMessage());
            }
            if (outCRLs != null) {
                return outCRLs;
            }
        }
        return null;
    }

    private Vector lookupPEMCRLs(byte[] data) {
        Vector inBytes = PKIUtils.lookupPEMTokens(data, "X509 CRL");
        if (inBytes == null) {
            return null;
        }
        Vector<byte[]> outCRLs = new Vector<byte[]>();
        for (int i2 = 0; i2 < inBytes.size(); ++i2) {
            try {
                byte[] rawCRL = (byte[])inBytes.elementAt(i2);
                X509CRL crl = new X509CRL(rawCRL, 0, 0);
                outCRLs.add(rawCRL);
                continue;
            }
            catch (CertificateException e2) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                continue;
            }
        }
        if (outCRLs.size() > 0) {
            return outCRLs;
        }
        return null;
    }

    private Vector lookupPKCS7CRLs(byte[] response) {
        Vector<byte[]> retval;
        block8: {
            boolean isPKCS7CRL = false;
            retval = new Vector<byte[]>();
            try {
                if (ContentInfo.getMessageType(response, 0, response.length) == 2) {
                    SignedData signedData = (SignedData)ContentInfo.getInstance(2, this.m_certJContext, null);
                    signedData.readInit(response, 0, response.length);
                    signedData.readFinal();
                    Vector containedCRLs = signedData.getCRLs();
                    if (containedCRLs != null) {
                        for (int i2 = 0; i2 < containedCRLs.size(); ++i2) {
                            X509CRL oneCRL = (X509CRL)containedCRLs.get(i2);
                            byte[] rawCRL = new byte[oneCRL.getDERLen(0)];
                            oneCRL.getDEREncoding(rawCRL, 0, oneCRL.getDERLen(0));
                            retval.add(rawCRL);
                        }
                    }
                    isPKCS7CRL = true;
                }
            }
            catch (PKCS7Exception e2) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            catch (CertificateException e3) {
                if ($assertionsDisabled) break block8;
                throw new AssertionError();
            }
        }
        if (retval.size() > 0) {
            return retval;
        }
        return null;
    }

    static {
        $assertionsDisabled = !PKIContext.class.desiredAssertionStatus();
    }
}

