/*
 * Decompiled with CFR 0.152.
 */
package llvm;

import llvm.BasicBlock;
import llvm.Instruction;
import llvm.LLVMContext;
import llvm.TerminatorInst;
import llvm.Value;
import llvm.llvmJNI;

public class UnwindInst
extends TerminatorInst {
    private long swigCPtr;

    protected UnwindInst(long l, boolean bl) {
        super(llvmJNI.SWIGUnwindInstUpcast(l), bl);
        this.swigCPtr = l;
    }

    protected static long getCPtr(UnwindInst unwindInst) {
        return unwindInst == null ? 0L : unwindInst.swigCPtr;
    }

    protected void dont_finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                llvmJNI.delete_UnwindInst(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public static UnwindInst Create(LLVMContext lLVMContext, Instruction instruction) {
        long l = llvmJNI.UnwindInst_Create__SWIG_0(LLVMContext.getCPtr(lLVMContext), lLVMContext, Instruction.getCPtr(instruction), instruction);
        return l == 0L ? null : new UnwindInst(l, false);
    }

    public static UnwindInst Create(LLVMContext lLVMContext) {
        long l = llvmJNI.UnwindInst_Create__SWIG_1(LLVMContext.getCPtr(lLVMContext), lLVMContext);
        return l == 0L ? null : new UnwindInst(l, false);
    }

    public static UnwindInst Create(LLVMContext lLVMContext, BasicBlock basicBlock) {
        long l = llvmJNI.UnwindInst_Create__SWIG_2(LLVMContext.getCPtr(lLVMContext), lLVMContext, BasicBlock.getCPtr(basicBlock), basicBlock);
        return l == 0L ? null : new UnwindInst(l, false);
    }

    public long getNumSuccessors() {
        return llvmJNI.UnwindInst_getNumSuccessors(this.swigCPtr, this);
    }

    public static boolean classof(UnwindInst unwindInst) {
        return llvmJNI.UnwindInst_classof__SWIG_0(UnwindInst.getCPtr(unwindInst), unwindInst);
    }

    public static boolean classof(Instruction instruction) {
        return llvmJNI.UnwindInst_classof__SWIG_1(Instruction.getCPtr(instruction), instruction);
    }

    public static boolean classof(Value value) {
        return llvmJNI.UnwindInst_classof__SWIG_2(Value.getCPtr(value), value);
    }

    public static UnwindInst dyn_cast(TerminatorInst terminatorInst) {
        long l = llvmJNI.UnwindInst_dyn_cast(TerminatorInst.getCPtr(terminatorInst), terminatorInst);
        return l == 0L ? null : new UnwindInst(l, false);
    }
}

