/*
 * Decompiled with CFR 0.152.
 */
package llvm;

import llvm.SWIGTYPE_p_unsigned_int;
import llvm.StringRef;
import llvm.Twine;
import llvm.llvmJNI;

public class Triple {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected Triple(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(Triple triple) {
        return triple == null ? 0L : triple.swigCPtr;
    }

    protected void dont_finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                llvmJNI.delete_Triple(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public Triple() {
        this(llvmJNI.new_Triple__SWIG_0(), true);
    }

    public Triple(StringRef stringRef) {
        this(llvmJNI.new_Triple__SWIG_1(StringRef.getCPtr(stringRef), stringRef), true);
    }

    public Triple(StringRef stringRef, StringRef stringRef2, StringRef stringRef3) {
        this(llvmJNI.new_Triple__SWIG_2(StringRef.getCPtr(stringRef), stringRef, StringRef.getCPtr(stringRef2), stringRef2, StringRef.getCPtr(stringRef3), stringRef3), true);
    }

    public ArchType getArch() {
        return ArchType.swigToEnum(llvmJNI.Triple_getArch(this.swigCPtr, this));
    }

    public VendorType getVendor() {
        return VendorType.swigToEnum(llvmJNI.Triple_getVendor(this.swigCPtr, this));
    }

    public OSType getOS() {
        return OSType.swigToEnum(llvmJNI.Triple_getOS(this.swigCPtr, this));
    }

    public boolean hasEnvironment() {
        return llvmJNI.Triple_hasEnvironment(this.swigCPtr, this);
    }

    public String str() {
        return llvmJNI.Triple_str(this.swigCPtr, this);
    }

    public String getTriple() {
        return llvmJNI.Triple_getTriple(this.swigCPtr, this);
    }

    public StringRef getArchName() {
        return new StringRef(llvmJNI.Triple_getArchName(this.swigCPtr, this), true);
    }

    public StringRef getVendorName() {
        return new StringRef(llvmJNI.Triple_getVendorName(this.swigCPtr, this), true);
    }

    public StringRef getOSName() {
        return new StringRef(llvmJNI.Triple_getOSName(this.swigCPtr, this), true);
    }

    public StringRef getEnvironmentName() {
        return new StringRef(llvmJNI.Triple_getEnvironmentName(this.swigCPtr, this), true);
    }

    public StringRef getOSAndEnvironmentName() {
        return new StringRef(llvmJNI.Triple_getOSAndEnvironmentName(this.swigCPtr, this), true);
    }

    public void getDarwinNumber(SWIGTYPE_p_unsigned_int sWIGTYPE_p_unsigned_int, SWIGTYPE_p_unsigned_int sWIGTYPE_p_unsigned_int2, SWIGTYPE_p_unsigned_int sWIGTYPE_p_unsigned_int3) {
        llvmJNI.Triple_getDarwinNumber(this.swigCPtr, this, SWIGTYPE_p_unsigned_int.getCPtr(sWIGTYPE_p_unsigned_int), SWIGTYPE_p_unsigned_int.getCPtr(sWIGTYPE_p_unsigned_int2), SWIGTYPE_p_unsigned_int.getCPtr(sWIGTYPE_p_unsigned_int3));
    }

    public long getDarwinMajorNumber() {
        return llvmJNI.Triple_getDarwinMajorNumber(this.swigCPtr, this);
    }

    public void setArch(ArchType archType) {
        llvmJNI.Triple_setArch(this.swigCPtr, this, archType.swigValue());
    }

    public void setVendor(VendorType vendorType) {
        llvmJNI.Triple_setVendor(this.swigCPtr, this, vendorType.swigValue());
    }

    public void setOS(OSType oSType) {
        llvmJNI.Triple_setOS(this.swigCPtr, this, oSType.swigValue());
    }

    public void setTriple(Twine twine) {
        llvmJNI.Triple_setTriple(this.swigCPtr, this, Twine.getCPtr(twine), twine);
    }

    public void setArchName(StringRef stringRef) {
        llvmJNI.Triple_setArchName(this.swigCPtr, this, StringRef.getCPtr(stringRef), stringRef);
    }

    public void setVendorName(StringRef stringRef) {
        llvmJNI.Triple_setVendorName(this.swigCPtr, this, StringRef.getCPtr(stringRef), stringRef);
    }

    public void setOSName(StringRef stringRef) {
        llvmJNI.Triple_setOSName(this.swigCPtr, this, StringRef.getCPtr(stringRef), stringRef);
    }

    public void setEnvironmentName(StringRef stringRef) {
        llvmJNI.Triple_setEnvironmentName(this.swigCPtr, this, StringRef.getCPtr(stringRef), stringRef);
    }

    public void setOSAndEnvironmentName(StringRef stringRef) {
        llvmJNI.Triple_setOSAndEnvironmentName(this.swigCPtr, this, StringRef.getCPtr(stringRef), stringRef);
    }

    public String getArchNameForAssembler() {
        return llvmJNI.Triple_getArchNameForAssembler(this.swigCPtr, this);
    }

    public static String getArchTypeName(ArchType archType) {
        return llvmJNI.Triple_getArchTypeName(archType.swigValue());
    }

    public static String getArchTypePrefix(ArchType archType) {
        return llvmJNI.Triple_getArchTypePrefix(archType.swigValue());
    }

    public static String getVendorTypeName(VendorType vendorType) {
        return llvmJNI.Triple_getVendorTypeName(vendorType.swigValue());
    }

    public static String getOSTypeName(OSType oSType) {
        return llvmJNI.Triple_getOSTypeName(oSType.swigValue());
    }

    public static ArchType getArchTypeForLLVMName(StringRef stringRef) {
        return ArchType.swigToEnum(llvmJNI.Triple_getArchTypeForLLVMName(StringRef.getCPtr(stringRef), stringRef));
    }

    public static ArchType getArchTypeForDarwinArchName(StringRef stringRef) {
        return ArchType.swigToEnum(llvmJNI.Triple_getArchTypeForDarwinArchName(StringRef.getCPtr(stringRef), stringRef));
    }

    public static final class OSType {
        public static final OSType UnknownOS = new OSType("UnknownOS");
        public static final OSType AuroraUX = new OSType("AuroraUX");
        public static final OSType Cygwin = new OSType("Cygwin");
        public static final OSType Darwin = new OSType("Darwin");
        public static final OSType DragonFly = new OSType("DragonFly");
        public static final OSType FreeBSD = new OSType("FreeBSD");
        public static final OSType Linux = new OSType("Linux");
        public static final OSType Lv2 = new OSType("Lv2");
        public static final OSType MinGW32 = new OSType("MinGW32");
        public static final OSType MinGW64 = new OSType("MinGW64");
        public static final OSType NetBSD = new OSType("NetBSD");
        public static final OSType OpenBSD = new OSType("OpenBSD");
        public static final OSType Psp = new OSType("Psp");
        public static final OSType Solaris = new OSType("Solaris");
        public static final OSType Win32 = new OSType("Win32");
        public static final OSType Haiku = new OSType("Haiku");
        private static OSType[] swigValues = new OSType[]{UnknownOS, AuroraUX, Cygwin, Darwin, DragonFly, FreeBSD, Linux, Lv2, MinGW32, MinGW64, NetBSD, OpenBSD, Psp, Solaris, Win32, Haiku};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static OSType swigToEnum(int n) {
            if (n < swigValues.length && n >= 0 && OSType.swigValues[n].swigValue == n) {
                return swigValues[n];
            }
            for (int i = 0; i < swigValues.length; ++i) {
                if (OSType.swigValues[i].swigValue != n) continue;
                return swigValues[i];
            }
            throw new IllegalArgumentException("No enum " + OSType.class + " with value " + n);
        }

        private OSType(String string) {
            this.swigName = string;
            this.swigValue = swigNext++;
        }

        private OSType(String string, int n) {
            this.swigName = string;
            this.swigValue = n;
            swigNext = n + 1;
        }

        private OSType(String string, OSType oSType) {
            this.swigName = string;
            this.swigValue = oSType.swigValue;
            swigNext = this.swigValue + 1;
        }
    }

    public static final class VendorType {
        public static final VendorType UnknownVendor = new VendorType("UnknownVendor");
        public static final VendorType Apple = new VendorType("Apple");
        public static final VendorType PC = new VendorType("PC");
        private static VendorType[] swigValues = new VendorType[]{UnknownVendor, Apple, PC};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static VendorType swigToEnum(int n) {
            if (n < swigValues.length && n >= 0 && VendorType.swigValues[n].swigValue == n) {
                return swigValues[n];
            }
            for (int i = 0; i < swigValues.length; ++i) {
                if (VendorType.swigValues[i].swigValue != n) continue;
                return swigValues[i];
            }
            throw new IllegalArgumentException("No enum " + VendorType.class + " with value " + n);
        }

        private VendorType(String string) {
            this.swigName = string;
            this.swigValue = swigNext++;
        }

        private VendorType(String string, int n) {
            this.swigName = string;
            this.swigValue = n;
            swigNext = n + 1;
        }

        private VendorType(String string, VendorType vendorType) {
            this.swigName = string;
            this.swigValue = vendorType.swigValue;
            swigNext = this.swigValue + 1;
        }
    }

    public static final class ArchType {
        public static final ArchType UnknownArch = new ArchType("UnknownArch");
        public static final ArchType alpha = new ArchType("alpha");
        public static final ArchType arm = new ArchType("arm");
        public static final ArchType bfin = new ArchType("bfin");
        public static final ArchType cellspu = new ArchType("cellspu");
        public static final ArchType mips = new ArchType("mips");
        public static final ArchType mipsel = new ArchType("mipsel");
        public static final ArchType msp430 = new ArchType("msp430");
        public static final ArchType pic16 = new ArchType("pic16");
        public static final ArchType ppc = new ArchType("ppc");
        public static final ArchType ppc64 = new ArchType("ppc64");
        public static final ArchType sparc = new ArchType("sparc");
        public static final ArchType systemz = new ArchType("systemz");
        public static final ArchType tce = new ArchType("tce");
        public static final ArchType thumb = new ArchType("thumb");
        public static final ArchType x86 = new ArchType("x86");
        public static final ArchType x86_64 = new ArchType("x86_64");
        public static final ArchType xcore = new ArchType("xcore");
        public static final ArchType InvalidArch = new ArchType("InvalidArch");
        private static ArchType[] swigValues = new ArchType[]{UnknownArch, alpha, arm, bfin, cellspu, mips, mipsel, msp430, pic16, ppc, ppc64, sparc, systemz, tce, thumb, x86, x86_64, xcore, InvalidArch};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static ArchType swigToEnum(int n) {
            if (n < swigValues.length && n >= 0 && ArchType.swigValues[n].swigValue == n) {
                return swigValues[n];
            }
            for (int i = 0; i < swigValues.length; ++i) {
                if (ArchType.swigValues[i].swigValue != n) continue;
                return swigValues[i];
            }
            throw new IllegalArgumentException("No enum " + ArchType.class + " with value " + n);
        }

        private ArchType(String string) {
            this.swigName = string;
            this.swigValue = swigNext++;
        }

        private ArchType(String string, int n) {
            this.swigName = string;
            this.swigValue = n;
            swigNext = n + 1;
        }

        private ArchType(String string, ArchType archType) {
            this.swigName = string;
            this.swigValue = archType.swigValue;
            swigNext = this.swigValue + 1;
        }
    }
}

