/*
 * Decompiled with CFR 0.152.
 */
package llvm;

import llvm.MemSlab;
import llvm.llvmJNI;

public class SlabAllocator {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected SlabAllocator(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(SlabAllocator slabAllocator) {
        return slabAllocator == null ? 0L : slabAllocator.swigCPtr;
    }

    protected void dont_finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                llvmJNI.delete_SlabAllocator(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public MemSlab Allocate(long l) {
        long l2 = llvmJNI.SlabAllocator_Allocate(this.swigCPtr, this, l);
        return l2 == 0L ? null : new MemSlab(l2, false);
    }

    public void Deallocate(MemSlab memSlab) {
        llvmJNI.SlabAllocator_Deallocate(this.swigCPtr, this, MemSlab.getCPtr(memSlab), memSlab);
    }
}

