/*
 * Decompiled with CFR 0.152.
 */
package llvm;

import llvm.BasicBlock;
import llvm.Instruction;
import llvm.Twine;
import llvm.Use;
import llvm.Value;
import llvm.VectorType;
import llvm.llvmJNI;

public class ShuffleVectorInst
extends Instruction {
    private long swigCPtr;

    protected ShuffleVectorInst(long l, boolean bl) {
        super(llvmJNI.SWIGShuffleVectorInstUpcast(l), bl);
        this.swigCPtr = l;
    }

    protected static long getCPtr(ShuffleVectorInst shuffleVectorInst) {
        return shuffleVectorInst == null ? 0L : shuffleVectorInst.swigCPtr;
    }

    protected void dont_finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                llvmJNI.delete_ShuffleVectorInst(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public ShuffleVectorInst(Value value, Value value2, Value value3, Twine twine, Instruction instruction) {
        this(llvmJNI.new_ShuffleVectorInst__SWIG_0(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Value.getCPtr(value3), value3, Twine.getCPtr(twine), twine, Instruction.getCPtr(instruction), instruction), true);
    }

    public ShuffleVectorInst(Value value, Value value2, Value value3, Twine twine) {
        this(llvmJNI.new_ShuffleVectorInst__SWIG_1(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Value.getCPtr(value3), value3, Twine.getCPtr(twine), twine), true);
    }

    public ShuffleVectorInst(Value value, Value value2, Value value3) {
        this(llvmJNI.new_ShuffleVectorInst__SWIG_2(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Value.getCPtr(value3), value3), true);
    }

    public ShuffleVectorInst(Value value, Value value2, Value value3, Twine twine, BasicBlock basicBlock) {
        this(llvmJNI.new_ShuffleVectorInst__SWIG_3(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Value.getCPtr(value3), value3, Twine.getCPtr(twine), twine, BasicBlock.getCPtr(basicBlock), basicBlock), true);
    }

    public static boolean isValidOperands(Value value, Value value2, Value value3) {
        return llvmJNI.ShuffleVectorInst_isValidOperands(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Value.getCPtr(value3), value3);
    }

    public VectorType getType() {
        long l = llvmJNI.ShuffleVectorInst_getType(this.swigCPtr, this);
        return l == 0L ? null : new VectorType(l, false);
    }

    public Value getOperandValue(long l) {
        long l2 = llvmJNI.ShuffleVectorInst_getOperand(this.swigCPtr, this, l);
        return l2 == 0L ? null : new Value(l2, false);
    }

    public void setOperand(long l, Value value) {
        llvmJNI.ShuffleVectorInst_setOperand(this.swigCPtr, this, l, Value.getCPtr(value), value);
    }

    public Use op_begin() {
        long l = llvmJNI.ShuffleVectorInst_op_begin__SWIG_0(this.swigCPtr, this);
        return l == 0L ? null : new Use(l, false);
    }

    public Use op_end() {
        long l = llvmJNI.ShuffleVectorInst_op_end__SWIG_0(this.swigCPtr, this);
        return l == 0L ? null : new Use(l, false);
    }

    public long getNumOperands() {
        return llvmJNI.ShuffleVectorInst_getNumOperands(this.swigCPtr, this);
    }

    public int getMaskValue(long l) {
        return llvmJNI.ShuffleVectorInst_getMaskValue(this.swigCPtr, this, l);
    }

    public static boolean classof(ShuffleVectorInst shuffleVectorInst) {
        return llvmJNI.ShuffleVectorInst_classof__SWIG_0(ShuffleVectorInst.getCPtr(shuffleVectorInst), shuffleVectorInst);
    }

    public static boolean classof(Instruction instruction) {
        return llvmJNI.ShuffleVectorInst_classof__SWIG_1(Instruction.getCPtr(instruction), instruction);
    }

    public static boolean classof(Value value) {
        return llvmJNI.ShuffleVectorInst_classof__SWIG_2(Value.getCPtr(value), value);
    }

    public static ShuffleVectorInst dyn_cast(Instruction instruction) {
        long l = llvmJNI.ShuffleVectorInst_dyn_cast(Instruction.getCPtr(instruction), instruction);
        return l == 0L ? null : new ShuffleVectorInst(l, false);
    }
}

