/*
 * Decompiled with CFR 0.152.
 */
package llvm;

import llvm.SequentialType;
import llvm.Type;
import llvm.llvmJNI;

public class PointerType
extends SequentialType {
    private long swigCPtr;

    protected PointerType(long l, boolean bl) {
        super(llvmJNI.SWIGPointerTypeUpcast(l), bl);
        this.swigCPtr = l;
    }

    protected static long getCPtr(PointerType pointerType) {
        return pointerType == null ? 0L : pointerType.swigCPtr;
    }

    protected void dont_finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                llvmJNI.delete_PointerType(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public static PointerType get(Type type, long l) {
        long l2 = llvmJNI.PointerType_get(Type.getCPtr(type), type, l);
        return l2 == 0L ? null : new PointerType(l2, false);
    }

    public static PointerType getUnqual(Type type) {
        long l = llvmJNI.PointerType_getUnqual(Type.getCPtr(type), type);
        return l == 0L ? null : new PointerType(l, false);
    }

    public static boolean isValidElementType(Type type) {
        return llvmJNI.PointerType_isValidElementType(Type.getCPtr(type), type);
    }

    public long getAddressSpace() {
        return llvmJNI.PointerType_getAddressSpace(this.swigCPtr, this);
    }

    public static boolean classof(PointerType pointerType) {
        return llvmJNI.PointerType_classof__SWIG_0(PointerType.getCPtr(pointerType), pointerType);
    }

    public static boolean classof(Type type) {
        return llvmJNI.PointerType_classof__SWIG_1(Type.getCPtr(type), type);
    }

    public static PointerType dyn_cast(SequentialType sequentialType) {
        long l = llvmJNI.PointerType_dyn_cast(SequentialType.getCPtr(sequentialType), sequentialType);
        return l == 0L ? null : new PointerType(l, false);
    }
}

