/*
 * Decompiled with CFR 0.152.
 */
package llvm;

import llvm.MemSlab;
import llvm.SlabAllocator;
import llvm.llvmJNI;

public class MallocSlabAllocator
extends SlabAllocator {
    private long swigCPtr;

    protected MallocSlabAllocator(long l, boolean bl) {
        super(llvmJNI.SWIGMallocSlabAllocatorUpcast(l), bl);
        this.swigCPtr = l;
    }

    protected static long getCPtr(MallocSlabAllocator mallocSlabAllocator) {
        return mallocSlabAllocator == null ? 0L : mallocSlabAllocator.swigCPtr;
    }

    protected void dont_finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                llvmJNI.delete_MallocSlabAllocator(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public MallocSlabAllocator() {
        this(llvmJNI.new_MallocSlabAllocator(), true);
    }

    public MemSlab Allocate(long l) {
        long l2 = llvmJNI.MallocSlabAllocator_Allocate(this.swigCPtr, this, l);
        return l2 == 0L ? null : new MemSlab(l2, false);
    }

    public void Deallocate(MemSlab memSlab) {
        llvmJNI.MallocSlabAllocator_Deallocate(this.swigCPtr, this, MemSlab.getCPtr(memSlab), memSlab);
    }
}

