/*
 * Decompiled with CFR 0.152.
 */
package llvm;

import llvm.LLVMContext;
import llvm.MetadataBase;
import llvm.StringRef;
import llvm.Value;
import llvm.llvmJNI;

public class MDString
extends MetadataBase {
    private long swigCPtr;

    protected MDString(long l, boolean bl) {
        super(llvmJNI.SWIGMDStringUpcast(l), bl);
        this.swigCPtr = l;
    }

    protected static long getCPtr(MDString mDString) {
        return mDString == null ? 0L : mDString.swigCPtr;
    }

    protected void dont_finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                llvmJNI.delete_MDString(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public static MDString get(LLVMContext lLVMContext, StringRef stringRef) {
        long l = llvmJNI.MDString_get__SWIG_0(LLVMContext.getCPtr(lLVMContext), lLVMContext, StringRef.getCPtr(stringRef), stringRef);
        return l == 0L ? null : new MDString(l, false);
    }

    public static MDString get(LLVMContext lLVMContext, String string) {
        long l = llvmJNI.MDString_get__SWIG_1(LLVMContext.getCPtr(lLVMContext), lLVMContext, string);
        return l == 0L ? null : new MDString(l, false);
    }

    public StringRef getString() {
        return new StringRef(llvmJNI.MDString_getString(this.swigCPtr, this), true);
    }

    public long getLength() {
        return llvmJNI.MDString_getLength(this.swigCPtr, this);
    }

    public String begin() {
        return llvmJNI.MDString_begin(this.swigCPtr, this);
    }

    public String end() {
        return llvmJNI.MDString_end(this.swigCPtr, this);
    }

    public static boolean classof(MDString mDString) {
        return llvmJNI.MDString_classof__SWIG_0(MDString.getCPtr(mDString), mDString);
    }

    public static boolean classof(Value value) {
        return llvmJNI.MDString_classof__SWIG_1(Value.getCPtr(value), value);
    }

    public static MDString dyn_cast(MetadataBase metadataBase) {
        long l = llvmJNI.MDString_dyn_cast(MetadataBase.getCPtr(metadataBase), metadataBase);
        return l == 0L ? null : new MDString(l, false);
    }
}

