/*
 * Decompiled with CFR 0.152.
 */
package llvm;

import llvm.BasicBlock;
import llvm.Instruction;
import llvm.UnaryInstruction;
import llvm.Value;
import llvm.llvmJNI;

public class LoadInst
extends UnaryInstruction {
    private long swigCPtr;

    protected LoadInst(long l, boolean bl) {
        super(llvmJNI.SWIGLoadInstUpcast(l), bl);
        this.swigCPtr = l;
    }

    protected static long getCPtr(LoadInst loadInst) {
        return loadInst == null ? 0L : loadInst.swigCPtr;
    }

    protected void dont_finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                llvmJNI.delete_LoadInst(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public static LoadInst Create(Value value, String string, Instruction instruction) {
        long l = llvmJNI.LoadInst_Create__SWIG_0(Value.getCPtr(value), value, string, Instruction.getCPtr(instruction), instruction);
        return l == 0L ? null : new LoadInst(l, false);
    }

    public static LoadInst Create(Value value, String string, BasicBlock basicBlock) {
        long l = llvmJNI.LoadInst_Create__SWIG_1(Value.getCPtr(value), value, string, BasicBlock.getCPtr(basicBlock), basicBlock);
        return l == 0L ? null : new LoadInst(l, false);
    }

    public boolean isVolatile() {
        return llvmJNI.LoadInst_isVolatile(this.swigCPtr, this);
    }

    public void setVolatile(boolean bl) {
        llvmJNI.LoadInst_setVolatile(this.swigCPtr, this, bl);
    }

    public long getAlignment() {
        return llvmJNI.LoadInst_getAlignment(this.swigCPtr, this);
    }

    public void setAlignment(long l) {
        llvmJNI.LoadInst_setAlignment(this.swigCPtr, this, l);
    }

    public Value getPointerOperand() {
        long l = llvmJNI.LoadInst_getPointerOperand__SWIG_0(this.swigCPtr, this);
        return l == 0L ? null : new Value(l, false);
    }

    public static long getPointerOperandIndex() {
        return llvmJNI.LoadInst_getPointerOperandIndex();
    }

    public long getPointerAddressSpace() {
        return llvmJNI.LoadInst_getPointerAddressSpace(this.swigCPtr, this);
    }

    public static boolean classof(LoadInst loadInst) {
        return llvmJNI.LoadInst_classof__SWIG_0(LoadInst.getCPtr(loadInst), loadInst);
    }

    public static boolean classof(Instruction instruction) {
        return llvmJNI.LoadInst_classof__SWIG_1(Instruction.getCPtr(instruction), instruction);
    }

    public static boolean classof(Value value) {
        return llvmJNI.LoadInst_classof__SWIG_2(Value.getCPtr(value), value);
    }

    public static LoadInst dyn_cast(UnaryInstruction unaryInstruction) {
        long l = llvmJNI.LoadInst_dyn_cast(UnaryInstruction.getCPtr(unaryInstruction), unaryInstruction);
        return l == 0L ? null : new LoadInst(l, false);
    }
}

