/*
 * Decompiled with CFR 0.152.
 */
package llvm;

import java.math.BigInteger;
import llvm.AllocaInst;
import llvm.BasicBlock;
import llvm.BranchInst;
import llvm.CallInst;
import llvm.CmpInst;
import llvm.ConstantFolder;
import llvm.IndirectBrInst;
import llvm.Instruction;
import llvm.LLVMContext;
import llvm.LoadInst;
import llvm.MDNode;
import llvm.PHINode;
import llvm.ReturnInst;
import llvm.SWIGTYPE_p_llvm__BasicBlock__InstListType__iterator;
import llvm.SWIGTYPE_p_llvm__IRBuilderDefaultInserterT_true_t;
import llvm.SWIGTYPE_p_p_llvm__Value;
import llvm.StoreInst;
import llvm.SwitchInst;
import llvm.Twine;
import llvm.Type;
import llvm.UnreachableInst;
import llvm.UnwindInst;
import llvm.VAArgInst;
import llvm.Value;
import llvm.llvmJNI;

public class JNIIRBuilder {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected JNIIRBuilder(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(JNIIRBuilder jNIIRBuilder) {
        return jNIIRBuilder == null ? 0L : jNIIRBuilder.swigCPtr;
    }

    protected void dont_finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                llvmJNI.delete_JNIIRBuilder(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public JNIIRBuilder(LLVMContext lLVMContext, ConstantFolder constantFolder, SWIGTYPE_p_llvm__IRBuilderDefaultInserterT_true_t sWIGTYPE_p_llvm__IRBuilderDefaultInserterT_true_t) {
        this(llvmJNI.new_JNIIRBuilder__SWIG_0(LLVMContext.getCPtr(lLVMContext), lLVMContext, ConstantFolder.getCPtr(constantFolder), constantFolder, SWIGTYPE_p_llvm__IRBuilderDefaultInserterT_true_t.getCPtr(sWIGTYPE_p_llvm__IRBuilderDefaultInserterT_true_t)), true);
    }

    public JNIIRBuilder(LLVMContext lLVMContext, ConstantFolder constantFolder) {
        this(llvmJNI.new_JNIIRBuilder__SWIG_1(LLVMContext.getCPtr(lLVMContext), lLVMContext, ConstantFolder.getCPtr(constantFolder), constantFolder), true);
    }

    public JNIIRBuilder(LLVMContext lLVMContext) {
        this(llvmJNI.new_JNIIRBuilder__SWIG_2(LLVMContext.getCPtr(lLVMContext), lLVMContext), true);
    }

    public JNIIRBuilder(BasicBlock basicBlock, ConstantFolder constantFolder) {
        this(llvmJNI.new_JNIIRBuilder__SWIG_3(BasicBlock.getCPtr(basicBlock), basicBlock, ConstantFolder.getCPtr(constantFolder), constantFolder), true);
    }

    public JNIIRBuilder(BasicBlock basicBlock) {
        this(llvmJNI.new_JNIIRBuilder__SWIG_4(BasicBlock.getCPtr(basicBlock), basicBlock), true);
    }

    public JNIIRBuilder(BasicBlock basicBlock, SWIGTYPE_p_llvm__BasicBlock__InstListType__iterator sWIGTYPE_p_llvm__BasicBlock__InstListType__iterator, ConstantFolder constantFolder) {
        this(llvmJNI.new_JNIIRBuilder__SWIG_5(BasicBlock.getCPtr(basicBlock), basicBlock, SWIGTYPE_p_llvm__BasicBlock__InstListType__iterator.getCPtr(sWIGTYPE_p_llvm__BasicBlock__InstListType__iterator), ConstantFolder.getCPtr(constantFolder), constantFolder), true);
    }

    public JNIIRBuilder(BasicBlock basicBlock, SWIGTYPE_p_llvm__BasicBlock__InstListType__iterator sWIGTYPE_p_llvm__BasicBlock__InstListType__iterator) {
        this(llvmJNI.new_JNIIRBuilder__SWIG_6(BasicBlock.getCPtr(basicBlock), basicBlock, SWIGTYPE_p_llvm__BasicBlock__InstListType__iterator.getCPtr(sWIGTYPE_p_llvm__BasicBlock__InstListType__iterator)), true);
    }

    public ConstantFolder getFolder() {
        return new ConstantFolder(llvmJNI.JNIIRBuilder_getFolder(this.swigCPtr, this), false);
    }

    public boolean isNamePreserving() {
        return llvmJNI.JNIIRBuilder_isNamePreserving(this.swigCPtr, this);
    }

    public void ClearInsertionPoint() {
        llvmJNI.JNIIRBuilder_ClearInsertionPoint(this.swigCPtr, this);
    }

    public BasicBlock GetInsertBlock() {
        long l = llvmJNI.JNIIRBuilder_GetInsertBlock(this.swigCPtr, this);
        return l == 0L ? null : new BasicBlock(l, false);
    }

    public SWIGTYPE_p_llvm__BasicBlock__InstListType__iterator GetInsertPoint() {
        return new SWIGTYPE_p_llvm__BasicBlock__InstListType__iterator(llvmJNI.JNIIRBuilder_GetInsertPoint(this.swigCPtr, this), true);
    }

    public void SetInsertPoint(BasicBlock basicBlock) {
        llvmJNI.JNIIRBuilder_SetInsertPoint__SWIG_0(this.swigCPtr, this, BasicBlock.getCPtr(basicBlock), basicBlock);
    }

    public void SetInsertPoint(BasicBlock basicBlock, SWIGTYPE_p_llvm__BasicBlock__InstListType__iterator sWIGTYPE_p_llvm__BasicBlock__InstListType__iterator) {
        llvmJNI.JNIIRBuilder_SetInsertPoint__SWIG_1(this.swigCPtr, this, BasicBlock.getCPtr(basicBlock), basicBlock, SWIGTYPE_p_llvm__BasicBlock__InstListType__iterator.getCPtr(sWIGTYPE_p_llvm__BasicBlock__InstListType__iterator));
    }

    public void SetCurrentDebugLocation(MDNode mDNode) {
        llvmJNI.JNIIRBuilder_SetCurrentDebugLocation(this.swigCPtr, this, MDNode.getCPtr(mDNode), mDNode);
    }

    public MDNode getCurrentDebugLocation() {
        long l = llvmJNI.JNIIRBuilder_getCurrentDebugLocation(this.swigCPtr, this);
        return l == 0L ? null : new MDNode(l, false);
    }

    public void SetDebugLocation(Instruction instruction) {
        llvmJNI.JNIIRBuilder_SetDebugLocation__SWIG_0(this.swigCPtr, this, Instruction.getCPtr(instruction), instruction);
    }

    public void SetDebugLocation(Instruction instruction, MDNode mDNode) {
        llvmJNI.JNIIRBuilder_SetDebugLocation__SWIG_1(this.swigCPtr, this, Instruction.getCPtr(instruction), instruction, MDNode.getCPtr(mDNode), mDNode);
    }

    public Type getInt1Ty() {
        long l = llvmJNI.JNIIRBuilder_getInt1Ty(this.swigCPtr, this);
        return l == 0L ? null : new Type(l, false);
    }

    public Type getInt8Ty() {
        long l = llvmJNI.JNIIRBuilder_getInt8Ty(this.swigCPtr, this);
        return l == 0L ? null : new Type(l, false);
    }

    public Type getInt16Ty() {
        long l = llvmJNI.JNIIRBuilder_getInt16Ty(this.swigCPtr, this);
        return l == 0L ? null : new Type(l, false);
    }

    public Type getInt32Ty() {
        long l = llvmJNI.JNIIRBuilder_getInt32Ty(this.swigCPtr, this);
        return l == 0L ? null : new Type(l, false);
    }

    public Type getInt64Ty() {
        long l = llvmJNI.JNIIRBuilder_getInt64Ty(this.swigCPtr, this);
        return l == 0L ? null : new Type(l, false);
    }

    public Type getFloatTy() {
        long l = llvmJNI.JNIIRBuilder_getFloatTy(this.swigCPtr, this);
        return l == 0L ? null : new Type(l, false);
    }

    public Type getDoubleTy() {
        long l = llvmJNI.JNIIRBuilder_getDoubleTy(this.swigCPtr, this);
        return l == 0L ? null : new Type(l, false);
    }

    public Type getVoidTy() {
        long l = llvmJNI.JNIIRBuilder_getVoidTy(this.swigCPtr, this);
        return l == 0L ? null : new Type(l, false);
    }

    public ReturnInst CreateRetVoid() {
        long l = llvmJNI.JNIIRBuilder_CreateRetVoid(this.swigCPtr, this);
        return l == 0L ? null : new ReturnInst(l, false);
    }

    public ReturnInst CreateRet(Value value) {
        long l = llvmJNI.JNIIRBuilder_CreateRet(this.swigCPtr, this, Value.getCPtr(value), value);
        return l == 0L ? null : new ReturnInst(l, false);
    }

    public ReturnInst CreateAggregateRet(SWIGTYPE_p_p_llvm__Value sWIGTYPE_p_p_llvm__Value, long l) {
        long l2 = llvmJNI.JNIIRBuilder_CreateAggregateRet(this.swigCPtr, this, SWIGTYPE_p_p_llvm__Value.getCPtr(sWIGTYPE_p_p_llvm__Value), l);
        return l2 == 0L ? null : new ReturnInst(l2, false);
    }

    public BranchInst CreateBr(BasicBlock basicBlock) {
        long l = llvmJNI.JNIIRBuilder_CreateBr(this.swigCPtr, this, BasicBlock.getCPtr(basicBlock), basicBlock);
        return l == 0L ? null : new BranchInst(l, false);
    }

    public BranchInst CreateCondBr(Value value, BasicBlock basicBlock, BasicBlock basicBlock2) {
        long l = llvmJNI.JNIIRBuilder_CreateCondBr(this.swigCPtr, this, Value.getCPtr(value), value, BasicBlock.getCPtr(basicBlock), basicBlock, BasicBlock.getCPtr(basicBlock2), basicBlock2);
        return l == 0L ? null : new BranchInst(l, false);
    }

    public SwitchInst CreateSwitch(Value value, BasicBlock basicBlock, long l) {
        long l2 = llvmJNI.JNIIRBuilder_CreateSwitch__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, BasicBlock.getCPtr(basicBlock), basicBlock, l);
        return l2 == 0L ? null : new SwitchInst(l2, false);
    }

    public SwitchInst CreateSwitch(Value value, BasicBlock basicBlock) {
        long l = llvmJNI.JNIIRBuilder_CreateSwitch__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, BasicBlock.getCPtr(basicBlock), basicBlock);
        return l == 0L ? null : new SwitchInst(l, false);
    }

    public IndirectBrInst CreateIndirectBr(Value value, long l) {
        long l2 = llvmJNI.JNIIRBuilder_CreateIndirectBr__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, l);
        return l2 == 0L ? null : new IndirectBrInst(l2, false);
    }

    public IndirectBrInst CreateIndirectBr(Value value) {
        long l = llvmJNI.JNIIRBuilder_CreateIndirectBr__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value);
        return l == 0L ? null : new IndirectBrInst(l, false);
    }

    public UnwindInst CreateUnwind() {
        long l = llvmJNI.JNIIRBuilder_CreateUnwind(this.swigCPtr, this);
        return l == 0L ? null : new UnwindInst(l, false);
    }

    public UnreachableInst CreateUnreachable() {
        long l = llvmJNI.JNIIRBuilder_CreateUnreachable(this.swigCPtr, this);
        return l == 0L ? null : new UnreachableInst(l, false);
    }

    public Value CreateAdd(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateAdd__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateAdd(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateAdd__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateNSWAdd(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateNSWAdd__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateNSWAdd(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateNSWAdd__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFAdd(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateFAdd__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFAdd(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateFAdd__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateSub(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateSub__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateSub(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateSub__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateNSWSub(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateNSWSub__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateNSWSub(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateNSWSub__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFSub(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateFSub__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFSub(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateFSub__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateMul(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateMul__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateMul(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateMul__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFMul(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateFMul__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFMul(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateFMul__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateUDiv(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateUDiv__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateUDiv(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateUDiv__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateSDiv(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateSDiv__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateSDiv(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateSDiv__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateExactSDiv(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateExactSDiv__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateExactSDiv(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateExactSDiv__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFDiv(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateFDiv__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFDiv(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateFDiv__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateURem(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateURem__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateURem(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateURem__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateSRem(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateSRem__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateSRem(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateSRem__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFRem(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateFRem__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFRem(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateFRem__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateShl(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateShl__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateShl(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateShl__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateLShr(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateLShr__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateLShr(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateLShr__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateAShr(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateAShr__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateAShr(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateAShr__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateAnd(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateAnd__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateAnd(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateAnd__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateOr(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateOr__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateOr(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateOr__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateXor(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateXor__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateXor(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateXor__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateBinOp(Instruction.BinaryOps binaryOps, Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateBinOp__SWIG_0(this.swigCPtr, this, binaryOps.swigValue(), Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateBinOp(Instruction.BinaryOps binaryOps, Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateBinOp__SWIG_1(this.swigCPtr, this, binaryOps.swigValue(), Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateNeg(Value value, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateNeg__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateNeg(Value value) {
        long l = llvmJNI.JNIIRBuilder_CreateNeg__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFNeg(Value value, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateFNeg__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFNeg(Value value) {
        long l = llvmJNI.JNIIRBuilder_CreateFNeg__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateNot(Value value, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateNot__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateNot(Value value) {
        long l = llvmJNI.JNIIRBuilder_CreateNot__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value);
        return l == 0L ? null : new Value(l, false);
    }

    public AllocaInst CreateAlloca(Type type, Value value, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateAlloca__SWIG_0(this.swigCPtr, this, Type.getCPtr(type), type, Value.getCPtr(value), value, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new AllocaInst(l, false);
    }

    public AllocaInst CreateAlloca(Type type, Value value) {
        long l = llvmJNI.JNIIRBuilder_CreateAlloca__SWIG_1(this.swigCPtr, this, Type.getCPtr(type), type, Value.getCPtr(value), value);
        return l == 0L ? null : new AllocaInst(l, false);
    }

    public AllocaInst CreateAlloca(Type type) {
        long l = llvmJNI.JNIIRBuilder_CreateAlloca__SWIG_2(this.swigCPtr, this, Type.getCPtr(type), type);
        return l == 0L ? null : new AllocaInst(l, false);
    }

    public LoadInst CreateLoad(Value value, String string) {
        long l = llvmJNI.JNIIRBuilder_CreateLoad__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, string);
        return l == 0L ? null : new LoadInst(l, false);
    }

    public LoadInst CreateLoad(Value value, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateLoad__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new LoadInst(l, false);
    }

    public LoadInst CreateLoad(Value value) {
        long l = llvmJNI.JNIIRBuilder_CreateLoad__SWIG_2(this.swigCPtr, this, Value.getCPtr(value), value);
        return l == 0L ? null : new LoadInst(l, false);
    }

    public LoadInst CreateLoad(Value value, boolean bl, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateLoad__SWIG_3(this.swigCPtr, this, Value.getCPtr(value), value, bl, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new LoadInst(l, false);
    }

    public LoadInst CreateLoad(Value value, boolean bl) {
        long l = llvmJNI.JNIIRBuilder_CreateLoad__SWIG_4(this.swigCPtr, this, Value.getCPtr(value), value, bl);
        return l == 0L ? null : new LoadInst(l, false);
    }

    public StoreInst CreateStore(Value value, Value value2, boolean bl) {
        long l = llvmJNI.JNIIRBuilder_CreateStore__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, bl);
        return l == 0L ? null : new StoreInst(l, false);
    }

    public StoreInst CreateStore(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateStore__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new StoreInst(l, false);
    }

    public Value CreateGEP(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateGEP__SWIG_2(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateGEP(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateGEP__SWIG_3(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateInBoundsGEP(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateInBoundsGEP__SWIG_2(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateInBoundsGEP(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateInBoundsGEP__SWIG_3(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateConstGEP1_32(Value value, long l, Twine twine) {
        long l2 = llvmJNI.JNIIRBuilder_CreateConstGEP1_32__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, l, Twine.getCPtr(twine), twine);
        return l2 == 0L ? null : new Value(l2, false);
    }

    public Value CreateConstGEP1_32(Value value, long l) {
        long l2 = llvmJNI.JNIIRBuilder_CreateConstGEP1_32__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, l);
        return l2 == 0L ? null : new Value(l2, false);
    }

    public Value CreateConstInBoundsGEP1_32(Value value, long l, Twine twine) {
        long l2 = llvmJNI.JNIIRBuilder_CreateConstInBoundsGEP1_32__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, l, Twine.getCPtr(twine), twine);
        return l2 == 0L ? null : new Value(l2, false);
    }

    public Value CreateConstInBoundsGEP1_32(Value value, long l) {
        long l2 = llvmJNI.JNIIRBuilder_CreateConstInBoundsGEP1_32__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, l);
        return l2 == 0L ? null : new Value(l2, false);
    }

    public Value CreateConstGEP2_32(Value value, long l, long l2, Twine twine) {
        long l3 = llvmJNI.JNIIRBuilder_CreateConstGEP2_32__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, l, l2, Twine.getCPtr(twine), twine);
        return l3 == 0L ? null : new Value(l3, false);
    }

    public Value CreateConstGEP2_32(Value value, long l, long l2) {
        long l3 = llvmJNI.JNIIRBuilder_CreateConstGEP2_32__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, l, l2);
        return l3 == 0L ? null : new Value(l3, false);
    }

    public Value CreateConstInBoundsGEP2_32(Value value, long l, long l2, Twine twine) {
        long l3 = llvmJNI.JNIIRBuilder_CreateConstInBoundsGEP2_32__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, l, l2, Twine.getCPtr(twine), twine);
        return l3 == 0L ? null : new Value(l3, false);
    }

    public Value CreateConstInBoundsGEP2_32(Value value, long l, long l2) {
        long l3 = llvmJNI.JNIIRBuilder_CreateConstInBoundsGEP2_32__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, l, l2);
        return l3 == 0L ? null : new Value(l3, false);
    }

    public Value CreateConstGEP1_64(Value value, BigInteger bigInteger, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateConstGEP1_64__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, bigInteger, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateConstGEP1_64(Value value, BigInteger bigInteger) {
        long l = llvmJNI.JNIIRBuilder_CreateConstGEP1_64__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, bigInteger);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateConstInBoundsGEP1_64(Value value, BigInteger bigInteger, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateConstInBoundsGEP1_64__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, bigInteger, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateConstInBoundsGEP1_64(Value value, BigInteger bigInteger) {
        long l = llvmJNI.JNIIRBuilder_CreateConstInBoundsGEP1_64__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, bigInteger);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateConstGEP2_64(Value value, BigInteger bigInteger, BigInteger bigInteger2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateConstGEP2_64__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, bigInteger, bigInteger2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateConstGEP2_64(Value value, BigInteger bigInteger, BigInteger bigInteger2) {
        long l = llvmJNI.JNIIRBuilder_CreateConstGEP2_64__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, bigInteger, bigInteger2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateConstInBoundsGEP2_64(Value value, BigInteger bigInteger, BigInteger bigInteger2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateConstInBoundsGEP2_64__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, bigInteger, bigInteger2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateConstInBoundsGEP2_64(Value value, BigInteger bigInteger, BigInteger bigInteger2) {
        long l = llvmJNI.JNIIRBuilder_CreateConstInBoundsGEP2_64__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, bigInteger, bigInteger2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateStructGEP(Value value, long l, Twine twine) {
        long l2 = llvmJNI.JNIIRBuilder_CreateStructGEP__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, l, Twine.getCPtr(twine), twine);
        return l2 == 0L ? null : new Value(l2, false);
    }

    public Value CreateStructGEP(Value value, long l) {
        long l2 = llvmJNI.JNIIRBuilder_CreateStructGEP__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, l);
        return l2 == 0L ? null : new Value(l2, false);
    }

    public Value CreateGlobalString(String string, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateGlobalString__SWIG_0(this.swigCPtr, this, string, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateGlobalString(String string) {
        long l = llvmJNI.JNIIRBuilder_CreateGlobalString__SWIG_1(this.swigCPtr, this, string);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateGlobalString() {
        long l = llvmJNI.JNIIRBuilder_CreateGlobalString__SWIG_2(this.swigCPtr, this);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateGlobalStringPtr(String string, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateGlobalStringPtr__SWIG_0(this.swigCPtr, this, string, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateGlobalStringPtr(String string) {
        long l = llvmJNI.JNIIRBuilder_CreateGlobalStringPtr__SWIG_1(this.swigCPtr, this, string);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateGlobalStringPtr() {
        long l = llvmJNI.JNIIRBuilder_CreateGlobalStringPtr__SWIG_2(this.swigCPtr, this);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateTrunc(Value value, Type type, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateTrunc__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Type.getCPtr(type), type, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateTrunc(Value value, Type type) {
        long l = llvmJNI.JNIIRBuilder_CreateTrunc__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Type.getCPtr(type), type);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateZExt(Value value, Type type, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateZExt__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Type.getCPtr(type), type, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateZExt(Value value, Type type) {
        long l = llvmJNI.JNIIRBuilder_CreateZExt__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Type.getCPtr(type), type);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateSExt(Value value, Type type, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateSExt__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Type.getCPtr(type), type, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateSExt(Value value, Type type) {
        long l = llvmJNI.JNIIRBuilder_CreateSExt__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Type.getCPtr(type), type);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFPToUI(Value value, Type type, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateFPToUI__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Type.getCPtr(type), type, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFPToUI(Value value, Type type) {
        long l = llvmJNI.JNIIRBuilder_CreateFPToUI__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Type.getCPtr(type), type);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFPToSI(Value value, Type type, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateFPToSI__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Type.getCPtr(type), type, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFPToSI(Value value, Type type) {
        long l = llvmJNI.JNIIRBuilder_CreateFPToSI__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Type.getCPtr(type), type);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateUIToFP(Value value, Type type, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateUIToFP__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Type.getCPtr(type), type, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateUIToFP(Value value, Type type) {
        long l = llvmJNI.JNIIRBuilder_CreateUIToFP__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Type.getCPtr(type), type);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateSIToFP(Value value, Type type, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateSIToFP__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Type.getCPtr(type), type, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateSIToFP(Value value, Type type) {
        long l = llvmJNI.JNIIRBuilder_CreateSIToFP__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Type.getCPtr(type), type);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFPTrunc(Value value, Type type, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateFPTrunc__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Type.getCPtr(type), type, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFPTrunc(Value value, Type type) {
        long l = llvmJNI.JNIIRBuilder_CreateFPTrunc__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Type.getCPtr(type), type);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFPExt(Value value, Type type, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateFPExt__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Type.getCPtr(type), type, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFPExt(Value value, Type type) {
        long l = llvmJNI.JNIIRBuilder_CreateFPExt__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Type.getCPtr(type), type);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreatePtrToInt(Value value, Type type, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreatePtrToInt__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Type.getCPtr(type), type, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreatePtrToInt(Value value, Type type) {
        long l = llvmJNI.JNIIRBuilder_CreatePtrToInt__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Type.getCPtr(type), type);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateIntToPtr(Value value, Type type, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateIntToPtr__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Type.getCPtr(type), type, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateIntToPtr(Value value, Type type) {
        long l = llvmJNI.JNIIRBuilder_CreateIntToPtr__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Type.getCPtr(type), type);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateBitCast(Value value, Type type, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateBitCast__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Type.getCPtr(type), type, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateBitCast(Value value, Type type) {
        long l = llvmJNI.JNIIRBuilder_CreateBitCast__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Type.getCPtr(type), type);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateZExtOrBitCast(Value value, Type type, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateZExtOrBitCast__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Type.getCPtr(type), type, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateZExtOrBitCast(Value value, Type type) {
        long l = llvmJNI.JNIIRBuilder_CreateZExtOrBitCast__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Type.getCPtr(type), type);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateSExtOrBitCast(Value value, Type type, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateSExtOrBitCast__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Type.getCPtr(type), type, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateSExtOrBitCast(Value value, Type type) {
        long l = llvmJNI.JNIIRBuilder_CreateSExtOrBitCast__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Type.getCPtr(type), type);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateTruncOrBitCast(Value value, Type type, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateTruncOrBitCast__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Type.getCPtr(type), type, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateTruncOrBitCast(Value value, Type type) {
        long l = llvmJNI.JNIIRBuilder_CreateTruncOrBitCast__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Type.getCPtr(type), type);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateCast(Instruction.CastOps castOps, Value value, Type type, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateCast__SWIG_0(this.swigCPtr, this, castOps.swigValue(), Value.getCPtr(value), value, Type.getCPtr(type), type, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateCast(Instruction.CastOps castOps, Value value, Type type) {
        long l = llvmJNI.JNIIRBuilder_CreateCast__SWIG_1(this.swigCPtr, this, castOps.swigValue(), Value.getCPtr(value), value, Type.getCPtr(type), type);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreatePointerCast(Value value, Type type, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreatePointerCast__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Type.getCPtr(type), type, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreatePointerCast(Value value, Type type) {
        long l = llvmJNI.JNIIRBuilder_CreatePointerCast__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Type.getCPtr(type), type);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateIntCast(Value value, Type type, boolean bl, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateIntCast__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Type.getCPtr(type), type, bl, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateIntCast(Value value, Type type, boolean bl) {
        long l = llvmJNI.JNIIRBuilder_CreateIntCast__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Type.getCPtr(type), type, bl);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFPCast(Value value, Type type, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateFPCast__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Type.getCPtr(type), type, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFPCast(Value value, Type type) {
        long l = llvmJNI.JNIIRBuilder_CreateFPCast__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Type.getCPtr(type), type);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateICmpEQ(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateICmpEQ__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateICmpEQ(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateICmpEQ__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateICmpNE(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateICmpNE__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateICmpNE(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateICmpNE__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateICmpUGT(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateICmpUGT__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateICmpUGT(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateICmpUGT__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateICmpUGE(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateICmpUGE__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateICmpUGE(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateICmpUGE__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateICmpULT(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateICmpULT__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateICmpULT(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateICmpULT__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateICmpULE(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateICmpULE__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateICmpULE(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateICmpULE__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateICmpSGT(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateICmpSGT__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateICmpSGT(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateICmpSGT__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateICmpSGE(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateICmpSGE__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateICmpSGE(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateICmpSGE__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateICmpSLT(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateICmpSLT__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateICmpSLT(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateICmpSLT__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateICmpSLE(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateICmpSLE__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateICmpSLE(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateICmpSLE__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFCmpOEQ(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateFCmpOEQ__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFCmpOEQ(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateFCmpOEQ__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFCmpOGT(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateFCmpOGT__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFCmpOGT(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateFCmpOGT__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFCmpOGE(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateFCmpOGE__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFCmpOGE(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateFCmpOGE__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFCmpOLT(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateFCmpOLT__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFCmpOLT(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateFCmpOLT__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFCmpOLE(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateFCmpOLE__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFCmpOLE(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateFCmpOLE__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFCmpONE(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateFCmpONE__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFCmpONE(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateFCmpONE__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFCmpORD(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateFCmpORD__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFCmpORD(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateFCmpORD__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFCmpUNO(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateFCmpUNO__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFCmpUNO(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateFCmpUNO__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFCmpUEQ(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateFCmpUEQ__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFCmpUEQ(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateFCmpUEQ__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFCmpUGT(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateFCmpUGT__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFCmpUGT(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateFCmpUGT__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFCmpUGE(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateFCmpUGE__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFCmpUGE(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateFCmpUGE__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFCmpULT(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateFCmpULT__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFCmpULT(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateFCmpULT__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFCmpULE(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateFCmpULE__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFCmpULE(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateFCmpULE__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFCmpUNE(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateFCmpUNE__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFCmpUNE(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateFCmpUNE__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateICmp(CmpInst.Predicate predicate, Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateICmp__SWIG_0(this.swigCPtr, this, predicate.swigValue(), Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateICmp(CmpInst.Predicate predicate, Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateICmp__SWIG_1(this.swigCPtr, this, predicate.swigValue(), Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFCmp(CmpInst.Predicate predicate, Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateFCmp__SWIG_0(this.swigCPtr, this, predicate.swigValue(), Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateFCmp(CmpInst.Predicate predicate, Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateFCmp__SWIG_1(this.swigCPtr, this, predicate.swigValue(), Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public PHINode CreatePHI(Type type, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreatePHI__SWIG_0(this.swigCPtr, this, Type.getCPtr(type), type, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new PHINode(l, false);
    }

    public PHINode CreatePHI(Type type) {
        long l = llvmJNI.JNIIRBuilder_CreatePHI__SWIG_1(this.swigCPtr, this, Type.getCPtr(type), type);
        return l == 0L ? null : new PHINode(l, false);
    }

    public CallInst CreateCall(Value value, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateCall__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new CallInst(l, false);
    }

    public CallInst CreateCall(Value value) {
        long l = llvmJNI.JNIIRBuilder_CreateCall__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value);
        return l == 0L ? null : new CallInst(l, false);
    }

    public CallInst CreateCall(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateCall__SWIG_2(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new CallInst(l, false);
    }

    public CallInst CreateCall(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateCall__SWIG_3(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new CallInst(l, false);
    }

    public CallInst CreateCall2(Value value, Value value2, Value value3, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateCall2__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Value.getCPtr(value3), value3, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new CallInst(l, false);
    }

    public CallInst CreateCall2(Value value, Value value2, Value value3) {
        long l = llvmJNI.JNIIRBuilder_CreateCall2__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Value.getCPtr(value3), value3);
        return l == 0L ? null : new CallInst(l, false);
    }

    public CallInst CreateCall3(Value value, Value value2, Value value3, Value value4, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateCall3__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Value.getCPtr(value3), value3, Value.getCPtr(value4), value4, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new CallInst(l, false);
    }

    public CallInst CreateCall3(Value value, Value value2, Value value3, Value value4) {
        long l = llvmJNI.JNIIRBuilder_CreateCall3__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Value.getCPtr(value3), value3, Value.getCPtr(value4), value4);
        return l == 0L ? null : new CallInst(l, false);
    }

    public CallInst CreateCall4(Value value, Value value2, Value value3, Value value4, Value value5, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateCall4__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Value.getCPtr(value3), value3, Value.getCPtr(value4), value4, Value.getCPtr(value5), value5, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new CallInst(l, false);
    }

    public CallInst CreateCall4(Value value, Value value2, Value value3, Value value4, Value value5) {
        long l = llvmJNI.JNIIRBuilder_CreateCall4__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Value.getCPtr(value3), value3, Value.getCPtr(value4), value4, Value.getCPtr(value5), value5);
        return l == 0L ? null : new CallInst(l, false);
    }

    public Value CreateSelect(Value value, Value value2, Value value3, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateSelect__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Value.getCPtr(value3), value3, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateSelect(Value value, Value value2, Value value3) {
        long l = llvmJNI.JNIIRBuilder_CreateSelect__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Value.getCPtr(value3), value3);
        return l == 0L ? null : new Value(l, false);
    }

    public VAArgInst CreateVAArg(Value value, Type type, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateVAArg__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Type.getCPtr(type), type, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new VAArgInst(l, false);
    }

    public VAArgInst CreateVAArg(Value value, Type type) {
        long l = llvmJNI.JNIIRBuilder_CreateVAArg__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Type.getCPtr(type), type);
        return l == 0L ? null : new VAArgInst(l, false);
    }

    public Value CreateExtractElement(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateExtractElement__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateExtractElement(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreateExtractElement__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateInsertElement(Value value, Value value2, Value value3, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateInsertElement__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Value.getCPtr(value3), value3, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateInsertElement(Value value, Value value2, Value value3) {
        long l = llvmJNI.JNIIRBuilder_CreateInsertElement__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Value.getCPtr(value3), value3);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateShuffleVector(Value value, Value value2, Value value3, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateShuffleVector__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Value.getCPtr(value3), value3, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateShuffleVector(Value value, Value value2, Value value3) {
        long l = llvmJNI.JNIIRBuilder_CreateShuffleVector__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Value.getCPtr(value3), value3);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateExtractValue(Value value, long l, Twine twine) {
        long l2 = llvmJNI.JNIIRBuilder_CreateExtractValue__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, l, Twine.getCPtr(twine), twine);
        return l2 == 0L ? null : new Value(l2, false);
    }

    public Value CreateExtractValue(Value value, long l) {
        long l2 = llvmJNI.JNIIRBuilder_CreateExtractValue__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, l);
        return l2 == 0L ? null : new Value(l2, false);
    }

    public Value CreateInsertValue(Value value, Value value2, long l, Twine twine) {
        long l2 = llvmJNI.JNIIRBuilder_CreateInsertValue__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, l, Twine.getCPtr(twine), twine);
        return l2 == 0L ? null : new Value(l2, false);
    }

    public Value CreateInsertValue(Value value, Value value2, long l) {
        long l2 = llvmJNI.JNIIRBuilder_CreateInsertValue__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, l);
        return l2 == 0L ? null : new Value(l2, false);
    }

    public Value CreateIsNull(Value value, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateIsNull__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateIsNull(Value value) {
        long l = llvmJNI.JNIIRBuilder_CreateIsNull__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateIsNotNull(Value value, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreateIsNotNull__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreateIsNotNull(Value value) {
        long l = llvmJNI.JNIIRBuilder_CreateIsNotNull__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreatePtrDiff(Value value, Value value2, Twine twine) {
        long l = llvmJNI.JNIIRBuilder_CreatePtrDiff__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new Value(l, false);
    }

    public Value CreatePtrDiff(Value value, Value value2) {
        long l = llvmJNI.JNIIRBuilder_CreatePtrDiff__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Value(l, false);
    }
}

