/*
 * Decompiled with CFR 0.152.
 */
package llvm;

import java.math.BigInteger;
import llvm.APInt;
import llvm.DerivedType;
import llvm.LLVMContext;
import llvm.Type;
import llvm.llvmJNI;

public class IntegerType
extends DerivedType {
    private long swigCPtr;
    public static final int MIN_INT_BITS = llvmJNI.IntegerType_MIN_INT_BITS_get();
    public static final int MAX_INT_BITS = llvmJNI.IntegerType_MAX_INT_BITS_get();

    protected IntegerType(long l, boolean bl) {
        super(llvmJNI.SWIGIntegerTypeUpcast(l), bl);
        this.swigCPtr = l;
    }

    protected static long getCPtr(IntegerType integerType) {
        return integerType == null ? 0L : integerType.swigCPtr;
    }

    protected void dont_finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                llvmJNI.delete_IntegerType(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public static IntegerType get(LLVMContext lLVMContext, long l) {
        long l2 = llvmJNI.IntegerType_get(LLVMContext.getCPtr(lLVMContext), lLVMContext, l);
        return l2 == 0L ? null : new IntegerType(l2, false);
    }

    public long getBitWidth() {
        return llvmJNI.IntegerType_getBitWidth(this.swigCPtr, this);
    }

    public BigInteger getBitMask() {
        return llvmJNI.IntegerType_getBitMask(this.swigCPtr, this);
    }

    public BigInteger getSignBit() {
        return llvmJNI.IntegerType_getSignBit(this.swigCPtr, this);
    }

    public APInt getMask() {
        return new APInt(llvmJNI.IntegerType_getMask(this.swigCPtr, this), true);
    }

    public boolean isPowerOf2ByteWidth() {
        return llvmJNI.IntegerType_isPowerOf2ByteWidth(this.swigCPtr, this);
    }

    public static boolean classof(IntegerType integerType) {
        return llvmJNI.IntegerType_classof__SWIG_0(IntegerType.getCPtr(integerType), integerType);
    }

    public static boolean classof(Type type) {
        return llvmJNI.IntegerType_classof__SWIG_1(Type.getCPtr(type), type);
    }

    public static IntegerType dyn_cast(DerivedType derivedType) {
        long l = llvmJNI.IntegerType_dyn_cast(DerivedType.getCPtr(derivedType), derivedType);
        return l == 0L ? null : new IntegerType(l, false);
    }
}

