/*
 * Decompiled with CFR 0.152.
 */
package llvm;

import llvm.Constant;
import llvm.Module;
import llvm.PointerType;
import llvm.StringRef;
import llvm.Value;
import llvm.llvmJNI;

public class GlobalValue
extends Constant {
    private long swigCPtr;

    protected GlobalValue(long l, boolean bl) {
        super(llvmJNI.SWIGGlobalValueUpcast(l), bl);
        this.swigCPtr = l;
    }

    protected static long getCPtr(GlobalValue globalValue) {
        return globalValue == null ? 0L : globalValue.swigCPtr;
    }

    protected void dont_finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                llvmJNI.delete_GlobalValue(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public long getAlignment() {
        return llvmJNI.GlobalValue_getAlignment(this.swigCPtr, this);
    }

    public void setAlignment(long l) {
        llvmJNI.GlobalValue_setAlignment(this.swigCPtr, this, l);
    }

    public VisibilityTypes getVisibility() {
        return VisibilityTypes.swigToEnum(llvmJNI.GlobalValue_getVisibility(this.swigCPtr, this));
    }

    public boolean hasDefaultVisibility() {
        return llvmJNI.GlobalValue_hasDefaultVisibility(this.swigCPtr, this);
    }

    public boolean hasHiddenVisibility() {
        return llvmJNI.GlobalValue_hasHiddenVisibility(this.swigCPtr, this);
    }

    public boolean hasProtectedVisibility() {
        return llvmJNI.GlobalValue_hasProtectedVisibility(this.swigCPtr, this);
    }

    public void setVisibility(VisibilityTypes visibilityTypes) {
        llvmJNI.GlobalValue_setVisibility(this.swigCPtr, this, visibilityTypes.swigValue());
    }

    public boolean hasSection() {
        return llvmJNI.GlobalValue_hasSection(this.swigCPtr, this);
    }

    public String getSection() {
        return llvmJNI.GlobalValue_getSection(this.swigCPtr, this);
    }

    public void setSection(StringRef stringRef) {
        llvmJNI.GlobalValue_setSection(this.swigCPtr, this, StringRef.getCPtr(stringRef), stringRef);
    }

    public PointerType getType() {
        long l = llvmJNI.GlobalValue_getType(this.swigCPtr, this);
        return l == 0L ? null : new PointerType(l, false);
    }

    public static LinkageTypes getLinkOnceLinkage(boolean bl) {
        return LinkageTypes.swigToEnum(llvmJNI.GlobalValue_getLinkOnceLinkage(bl));
    }

    public static LinkageTypes getWeakLinkage(boolean bl) {
        return LinkageTypes.swigToEnum(llvmJNI.GlobalValue_getWeakLinkage(bl));
    }

    public boolean hasExternalLinkage() {
        return llvmJNI.GlobalValue_hasExternalLinkage(this.swigCPtr, this);
    }

    public boolean hasAvailableExternallyLinkage() {
        return llvmJNI.GlobalValue_hasAvailableExternallyLinkage(this.swigCPtr, this);
    }

    public boolean hasLinkOnceLinkage() {
        return llvmJNI.GlobalValue_hasLinkOnceLinkage(this.swigCPtr, this);
    }

    public boolean hasWeakLinkage() {
        return llvmJNI.GlobalValue_hasWeakLinkage(this.swigCPtr, this);
    }

    public boolean hasAppendingLinkage() {
        return llvmJNI.GlobalValue_hasAppendingLinkage(this.swigCPtr, this);
    }

    public boolean hasInternalLinkage() {
        return llvmJNI.GlobalValue_hasInternalLinkage(this.swigCPtr, this);
    }

    public boolean hasPrivateLinkage() {
        return llvmJNI.GlobalValue_hasPrivateLinkage(this.swigCPtr, this);
    }

    public boolean hasLinkerPrivateLinkage() {
        return llvmJNI.GlobalValue_hasLinkerPrivateLinkage(this.swigCPtr, this);
    }

    public boolean hasLocalLinkage() {
        return llvmJNI.GlobalValue_hasLocalLinkage(this.swigCPtr, this);
    }

    public boolean hasDLLImportLinkage() {
        return llvmJNI.GlobalValue_hasDLLImportLinkage(this.swigCPtr, this);
    }

    public boolean hasDLLExportLinkage() {
        return llvmJNI.GlobalValue_hasDLLExportLinkage(this.swigCPtr, this);
    }

    public boolean hasExternalWeakLinkage() {
        return llvmJNI.GlobalValue_hasExternalWeakLinkage(this.swigCPtr, this);
    }

    public boolean hasGhostLinkage() {
        return llvmJNI.GlobalValue_hasGhostLinkage(this.swigCPtr, this);
    }

    public boolean hasCommonLinkage() {
        return llvmJNI.GlobalValue_hasCommonLinkage(this.swigCPtr, this);
    }

    public void setLinkage(LinkageTypes linkageTypes) {
        llvmJNI.GlobalValue_setLinkage(this.swigCPtr, this, linkageTypes.swigValue());
    }

    public LinkageTypes getLinkage() {
        return LinkageTypes.swigToEnum(llvmJNI.GlobalValue_getLinkage(this.swigCPtr, this));
    }

    public boolean mayBeOverridden() {
        return llvmJNI.GlobalValue_mayBeOverridden(this.swigCPtr, this);
    }

    public boolean isWeakForLinker() {
        return llvmJNI.GlobalValue_isWeakForLinker(this.swigCPtr, this);
    }

    public void copyAttributesFrom(GlobalValue globalValue) {
        llvmJNI.GlobalValue_copyAttributesFrom(this.swigCPtr, this, GlobalValue.getCPtr(globalValue), globalValue);
    }

    public boolean hasNotBeenReadFromBitcode() {
        return llvmJNI.GlobalValue_hasNotBeenReadFromBitcode(this.swigCPtr, this);
    }

    public boolean isNullValue() {
        return llvmJNI.GlobalValue_isNullValue(this.swigCPtr, this);
    }

    public void destroyConstant() {
        llvmJNI.GlobalValue_destroyConstant(this.swigCPtr, this);
    }

    public boolean isDeclaration() {
        return llvmJNI.GlobalValue_isDeclaration(this.swigCPtr, this);
    }

    public void removeFromParent() {
        llvmJNI.GlobalValue_removeFromParent(this.swigCPtr, this);
    }

    public void eraseFromParent() {
        llvmJNI.GlobalValue_eraseFromParent(this.swigCPtr, this);
    }

    public Module getParent() {
        long l = llvmJNI.GlobalValue_getParent__SWIG_0(this.swigCPtr, this);
        return l == 0L ? null : new Module(l, false);
    }

    public void removeDeadConstantUsers() {
        llvmJNI.GlobalValue_removeDeadConstantUsers(this.swigCPtr, this);
    }

    public static boolean classof(GlobalValue globalValue) {
        return llvmJNI.GlobalValue_classof__SWIG_0(GlobalValue.getCPtr(globalValue), globalValue);
    }

    public static boolean classof(Value value) {
        return llvmJNI.GlobalValue_classof__SWIG_1(Value.getCPtr(value), value);
    }

    public static GlobalValue dyn_cast(Constant constant) {
        long l = llvmJNI.GlobalValue_dyn_cast(Constant.getCPtr(constant), constant);
        return l == 0L ? null : new GlobalValue(l, false);
    }

    public static final class VisibilityTypes {
        public static final VisibilityTypes DefaultVisibility = new VisibilityTypes("DefaultVisibility", llvmJNI.GlobalValue_DefaultVisibility_get());
        public static final VisibilityTypes HiddenVisibility = new VisibilityTypes("HiddenVisibility");
        public static final VisibilityTypes ProtectedVisibility = new VisibilityTypes("ProtectedVisibility");
        private static VisibilityTypes[] swigValues = new VisibilityTypes[]{DefaultVisibility, HiddenVisibility, ProtectedVisibility};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static VisibilityTypes swigToEnum(int n) {
            if (n < swigValues.length && n >= 0 && VisibilityTypes.swigValues[n].swigValue == n) {
                return swigValues[n];
            }
            for (int i = 0; i < swigValues.length; ++i) {
                if (VisibilityTypes.swigValues[i].swigValue != n) continue;
                return swigValues[i];
            }
            throw new IllegalArgumentException("No enum " + VisibilityTypes.class + " with value " + n);
        }

        private VisibilityTypes(String string) {
            this.swigName = string;
            this.swigValue = swigNext++;
        }

        private VisibilityTypes(String string, int n) {
            this.swigName = string;
            this.swigValue = n;
            swigNext = n + 1;
        }

        private VisibilityTypes(String string, VisibilityTypes visibilityTypes) {
            this.swigName = string;
            this.swigValue = visibilityTypes.swigValue;
            swigNext = this.swigValue + 1;
        }
    }

    public static final class LinkageTypes {
        public static final LinkageTypes ExternalLinkage = new LinkageTypes("ExternalLinkage", llvmJNI.GlobalValue_ExternalLinkage_get());
        public static final LinkageTypes AvailableExternallyLinkage = new LinkageTypes("AvailableExternallyLinkage");
        public static final LinkageTypes LinkOnceAnyLinkage = new LinkageTypes("LinkOnceAnyLinkage");
        public static final LinkageTypes LinkOnceODRLinkage = new LinkageTypes("LinkOnceODRLinkage");
        public static final LinkageTypes WeakAnyLinkage = new LinkageTypes("WeakAnyLinkage");
        public static final LinkageTypes WeakODRLinkage = new LinkageTypes("WeakODRLinkage");
        public static final LinkageTypes AppendingLinkage = new LinkageTypes("AppendingLinkage");
        public static final LinkageTypes InternalLinkage = new LinkageTypes("InternalLinkage");
        public static final LinkageTypes PrivateLinkage = new LinkageTypes("PrivateLinkage");
        public static final LinkageTypes LinkerPrivateLinkage = new LinkageTypes("LinkerPrivateLinkage");
        public static final LinkageTypes DLLImportLinkage = new LinkageTypes("DLLImportLinkage");
        public static final LinkageTypes DLLExportLinkage = new LinkageTypes("DLLExportLinkage");
        public static final LinkageTypes ExternalWeakLinkage = new LinkageTypes("ExternalWeakLinkage");
        public static final LinkageTypes GhostLinkage = new LinkageTypes("GhostLinkage");
        public static final LinkageTypes CommonLinkage = new LinkageTypes("CommonLinkage");
        private static LinkageTypes[] swigValues = new LinkageTypes[]{ExternalLinkage, AvailableExternallyLinkage, LinkOnceAnyLinkage, LinkOnceODRLinkage, WeakAnyLinkage, WeakODRLinkage, AppendingLinkage, InternalLinkage, PrivateLinkage, LinkerPrivateLinkage, DLLImportLinkage, DLLExportLinkage, ExternalWeakLinkage, GhostLinkage, CommonLinkage};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static LinkageTypes swigToEnum(int n) {
            if (n < swigValues.length && n >= 0 && LinkageTypes.swigValues[n].swigValue == n) {
                return swigValues[n];
            }
            for (int i = 0; i < swigValues.length; ++i) {
                if (LinkageTypes.swigValues[i].swigValue != n) continue;
                return swigValues[i];
            }
            throw new IllegalArgumentException("No enum " + LinkageTypes.class + " with value " + n);
        }

        private LinkageTypes(String string) {
            this.swigName = string;
            this.swigValue = swigNext++;
        }

        private LinkageTypes(String string, int n) {
            this.swigName = string;
            this.swigValue = n;
            swigNext = n + 1;
        }

        private LinkageTypes(String string, LinkageTypes linkageTypes) {
            this.swigName = string;
            this.swigValue = linkageTypes.swigValue;
            swigNext = this.swigValue + 1;
        }
    }
}

