/*
 * Decompiled with CFR 0.152.
 */
package llvm;

import llvm.Constant;
import llvm.GlobalValue;
import llvm.Module;
import llvm.Twine;
import llvm.Type;
import llvm.Use;
import llvm.Value;
import llvm.llvmJNI;

public class GlobalAlias
extends GlobalValue {
    private long swigCPtr;

    protected GlobalAlias(long l, boolean bl) {
        super(llvmJNI.SWIGGlobalAliasUpcast(l), bl);
        this.swigCPtr = l;
    }

    protected static long getCPtr(GlobalAlias globalAlias) {
        return globalAlias == null ? 0L : globalAlias.swigCPtr;
    }

    protected void dont_finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                llvmJNI.delete_GlobalAlias(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public GlobalAlias(Type type, GlobalValue.LinkageTypes linkageTypes, Twine twine, Constant constant, Module module) {
        this(llvmJNI.new_GlobalAlias__SWIG_0(Type.getCPtr(type), type, linkageTypes.swigValue(), Twine.getCPtr(twine), twine, Constant.getCPtr(constant), constant, Module.getCPtr(module), module), true);
    }

    public GlobalAlias(Type type, GlobalValue.LinkageTypes linkageTypes, Twine twine, Constant constant) {
        this(llvmJNI.new_GlobalAlias__SWIG_1(Type.getCPtr(type), type, linkageTypes.swigValue(), Twine.getCPtr(twine), twine, Constant.getCPtr(constant), constant), true);
    }

    public GlobalAlias(Type type, GlobalValue.LinkageTypes linkageTypes, Twine twine) {
        this(llvmJNI.new_GlobalAlias__SWIG_2(Type.getCPtr(type), type, linkageTypes.swigValue(), Twine.getCPtr(twine), twine), true);
    }

    public GlobalAlias(Type type, GlobalValue.LinkageTypes linkageTypes) {
        this(llvmJNI.new_GlobalAlias__SWIG_3(Type.getCPtr(type), type, linkageTypes.swigValue()), true);
    }

    public Value getOperandValue(long l) {
        long l2 = llvmJNI.GlobalAlias_getOperand(this.swigCPtr, this, l);
        return l2 == 0L ? null : new Value(l2, false);
    }

    public void setOperand(long l, Value value) {
        llvmJNI.GlobalAlias_setOperand(this.swigCPtr, this, l, Value.getCPtr(value), value);
    }

    public Use op_begin() {
        long l = llvmJNI.GlobalAlias_op_begin__SWIG_0(this.swigCPtr, this);
        return l == 0L ? null : new Use(l, false);
    }

    public Use op_end() {
        long l = llvmJNI.GlobalAlias_op_end__SWIG_0(this.swigCPtr, this);
        return l == 0L ? null : new Use(l, false);
    }

    public long getNumOperands() {
        return llvmJNI.GlobalAlias_getNumOperands(this.swigCPtr, this);
    }

    public boolean isDeclaration() {
        return llvmJNI.GlobalAlias_isDeclaration(this.swigCPtr, this);
    }

    public void removeFromParent() {
        llvmJNI.GlobalAlias_removeFromParent(this.swigCPtr, this);
    }

    public void eraseFromParent() {
        llvmJNI.GlobalAlias_eraseFromParent(this.swigCPtr, this);
    }

    public void setAliasee(Constant constant) {
        llvmJNI.GlobalAlias_setAliasee(this.swigCPtr, this, Constant.getCPtr(constant), constant);
    }

    public Constant getAliasee() {
        long l = llvmJNI.GlobalAlias_getAliasee__SWIG_0(this.swigCPtr, this);
        return l == 0L ? null : new Constant(l, false);
    }

    public GlobalValue getAliasedGlobal() {
        long l = llvmJNI.GlobalAlias_getAliasedGlobal(this.swigCPtr, this);
        return l == 0L ? null : new GlobalValue(l, false);
    }

    public GlobalValue resolveAliasedGlobal(boolean bl) {
        long l = llvmJNI.GlobalAlias_resolveAliasedGlobal__SWIG_0(this.swigCPtr, this, bl);
        return l == 0L ? null : new GlobalValue(l, false);
    }

    public GlobalValue resolveAliasedGlobal() {
        long l = llvmJNI.GlobalAlias_resolveAliasedGlobal__SWIG_1(this.swigCPtr, this);
        return l == 0L ? null : new GlobalValue(l, false);
    }

    public static boolean classof(GlobalAlias globalAlias) {
        return llvmJNI.GlobalAlias_classof__SWIG_0(GlobalAlias.getCPtr(globalAlias), globalAlias);
    }

    public static boolean classof(Value value) {
        return llvmJNI.GlobalAlias_classof__SWIG_1(Value.getCPtr(value), value);
    }

    public static GlobalAlias dyn_cast(GlobalValue globalValue) {
        long l = llvmJNI.GlobalAlias_dyn_cast(GlobalValue.getCPtr(globalValue), globalValue);
        return l == 0L ? null : new GlobalAlias(l, false);
    }
}

