/*
 * Decompiled with CFR 0.152.
 */
package llvm;

import llvm.APFloat;
import llvm.Constant;
import llvm.LLVMContext;
import llvm.StringRef;
import llvm.Type;
import llvm.Value;
import llvm.llvmJNI;

public class ConstantFP
extends Constant {
    private long swigCPtr;

    protected ConstantFP(long l, boolean bl) {
        super(llvmJNI.SWIGConstantFPUpcast(l), bl);
        this.swigCPtr = l;
    }

    protected static long getCPtr(ConstantFP constantFP) {
        return constantFP == null ? 0L : constantFP.swigCPtr;
    }

    protected void dont_finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                llvmJNI.delete_ConstantFP(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public static Constant getZeroValueForNegation(Type type) {
        long l = llvmJNI.ConstantFP_getZeroValueForNegation(Type.getCPtr(type), type);
        return l == 0L ? null : new Constant(l, false);
    }

    public static Constant get(Type type, double d) {
        long l = llvmJNI.ConstantFP_get__SWIG_0(Type.getCPtr(type), type, d);
        return l == 0L ? null : new Constant(l, false);
    }

    public static Constant get(Type type, StringRef stringRef) {
        long l = llvmJNI.ConstantFP_get__SWIG_1(Type.getCPtr(type), type, StringRef.getCPtr(stringRef), stringRef);
        return l == 0L ? null : new Constant(l, false);
    }

    public static ConstantFP get(LLVMContext lLVMContext, APFloat aPFloat) {
        long l = llvmJNI.ConstantFP_get__SWIG_2(LLVMContext.getCPtr(lLVMContext), lLVMContext, APFloat.getCPtr(aPFloat), aPFloat);
        return l == 0L ? null : new ConstantFP(l, false);
    }

    public static ConstantFP getNegativeZero(Type type) {
        long l = llvmJNI.ConstantFP_getNegativeZero(Type.getCPtr(type), type);
        return l == 0L ? null : new ConstantFP(l, false);
    }

    public static ConstantFP getInfinity(Type type, boolean bl) {
        long l = llvmJNI.ConstantFP_getInfinity__SWIG_0(Type.getCPtr(type), type, bl);
        return l == 0L ? null : new ConstantFP(l, false);
    }

    public static ConstantFP getInfinity(Type type) {
        long l = llvmJNI.ConstantFP_getInfinity__SWIG_1(Type.getCPtr(type), type);
        return l == 0L ? null : new ConstantFP(l, false);
    }

    public static boolean isValueValidForType(Type type, APFloat aPFloat) {
        return llvmJNI.ConstantFP_isValueValidForType(Type.getCPtr(type), type, APFloat.getCPtr(aPFloat), aPFloat);
    }

    public APFloat getValueAPF() {
        return new APFloat(llvmJNI.ConstantFP_getValueAPF(this.swigCPtr, this), false);
    }

    public boolean isNullValue() {
        return llvmJNI.ConstantFP_isNullValue(this.swigCPtr, this);
    }

    public boolean isNegativeZeroValue() {
        return llvmJNI.ConstantFP_isNegativeZeroValue(this.swigCPtr, this);
    }

    public boolean isExactlyValue(APFloat aPFloat) {
        return llvmJNI.ConstantFP_isExactlyValue__SWIG_0(this.swigCPtr, this, APFloat.getCPtr(aPFloat), aPFloat);
    }

    public boolean isExactlyValue(double d) {
        return llvmJNI.ConstantFP_isExactlyValue__SWIG_1(this.swigCPtr, this, d);
    }

    public static boolean classof(ConstantFP constantFP) {
        return llvmJNI.ConstantFP_classof__SWIG_0(ConstantFP.getCPtr(constantFP), constantFP);
    }

    public static boolean classof(Value value) {
        return llvmJNI.ConstantFP_classof__SWIG_1(Value.getCPtr(value), value);
    }

    public static ConstantFP dyn_cast(Constant constant) {
        long l = llvmJNI.ConstantFP_dyn_cast(Constant.getCPtr(constant), constant);
        return l == 0L ? null : new ConstantFP(l, false);
    }
}

