/*
 * Decompiled with CFR 0.152.
 */
package llvm;

import llvm.APInt;
import llvm.GlobalValue;
import llvm.LLVMContext;
import llvm.SWIGTYPE_p_llvm__SmallVectorImplT_llvm__Constant_p_t;
import llvm.Type;
import llvm.Use;
import llvm.User;
import llvm.Value;
import llvm.llvmJNI;

public class Constant
extends User {
    private long swigCPtr;

    protected Constant(long l, boolean bl) {
        super(llvmJNI.SWIGConstantUpcast(l), bl);
        this.swigCPtr = l;
    }

    protected static long getCPtr(Constant constant) {
        return constant == null ? 0L : constant.swigCPtr;
    }

    protected void dont_finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                llvmJNI.delete_Constant(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public boolean isNullValue() {
        return llvmJNI.Constant_isNullValue(this.swigCPtr, this);
    }

    public boolean isNegativeZeroValue() {
        return llvmJNI.Constant_isNegativeZeroValue(this.swigCPtr, this);
    }

    public boolean canTrap() {
        return llvmJNI.Constant_canTrap(this.swigCPtr, this);
    }

    public boolean isConstantUsed() {
        return llvmJNI.Constant_isConstantUsed(this.swigCPtr, this);
    }

    public PossibleRelocationsTy getRelocationInfo() {
        return PossibleRelocationsTy.swigToEnum(llvmJNI.Constant_getRelocationInfo(this.swigCPtr, this));
    }

    public User getOperand(long l) {
        long l2 = llvmJNI.Constant_getOperand__SWIG_0(this.swigCPtr, this, l);
        return l2 == 0L ? null : new User(l2, false);
    }

    public void getVectorElements(LLVMContext lLVMContext, SWIGTYPE_p_llvm__SmallVectorImplT_llvm__Constant_p_t sWIGTYPE_p_llvm__SmallVectorImplT_llvm__Constant_p_t) {
        llvmJNI.Constant_getVectorElements(this.swigCPtr, this, LLVMContext.getCPtr(lLVMContext), lLVMContext, SWIGTYPE_p_llvm__SmallVectorImplT_llvm__Constant_p_t.getCPtr(sWIGTYPE_p_llvm__SmallVectorImplT_llvm__Constant_p_t));
    }

    public void destroyConstant() {
        llvmJNI.Constant_destroyConstant(this.swigCPtr, this);
    }

    public static boolean classof(Constant constant) {
        return llvmJNI.Constant_classof__SWIG_0(Constant.getCPtr(constant), constant);
    }

    public static boolean classof(GlobalValue globalValue) {
        return llvmJNI.Constant_classof__SWIG_1(GlobalValue.getCPtr(globalValue), globalValue);
    }

    public static boolean classof(Value value) {
        return llvmJNI.Constant_classof__SWIG_2(Value.getCPtr(value), value);
    }

    public void replaceUsesOfWithOnConstant(Value value, Value value2, Use use) {
        llvmJNI.Constant_replaceUsesOfWithOnConstant(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Use.getCPtr(use), use);
    }

    public static Constant getNullValue(Type type) {
        long l = llvmJNI.Constant_getNullValue(Type.getCPtr(type), type);
        return l == 0L ? null : new Constant(l, false);
    }

    public static Constant getAllOnesValue(Type type) {
        long l = llvmJNI.Constant_getAllOnesValue(Type.getCPtr(type), type);
        return l == 0L ? null : new Constant(l, false);
    }

    public static Constant getIntegerValue(Type type, APInt aPInt) {
        long l = llvmJNI.Constant_getIntegerValue(Type.getCPtr(type), type, APInt.getCPtr(aPInt), aPInt);
        return l == 0L ? null : new Constant(l, false);
    }

    public static Constant dyn_cast(User user) {
        long l = llvmJNI.Constant_dyn_cast(User.getCPtr(user), user);
        return l == 0L ? null : new Constant(l, false);
    }

    public static final class PossibleRelocationsTy {
        public static final PossibleRelocationsTy NoRelocation = new PossibleRelocationsTy("NoRelocation", llvmJNI.Constant_NoRelocation_get());
        public static final PossibleRelocationsTy LocalRelocation = new PossibleRelocationsTy("LocalRelocation", llvmJNI.Constant_LocalRelocation_get());
        public static final PossibleRelocationsTy GlobalRelocations = new PossibleRelocationsTy("GlobalRelocations", llvmJNI.Constant_GlobalRelocations_get());
        private static PossibleRelocationsTy[] swigValues = new PossibleRelocationsTy[]{NoRelocation, LocalRelocation, GlobalRelocations};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static PossibleRelocationsTy swigToEnum(int n) {
            if (n < swigValues.length && n >= 0 && PossibleRelocationsTy.swigValues[n].swigValue == n) {
                return swigValues[n];
            }
            for (int i = 0; i < swigValues.length; ++i) {
                if (PossibleRelocationsTy.swigValues[i].swigValue != n) continue;
                return swigValues[i];
            }
            throw new IllegalArgumentException("No enum " + PossibleRelocationsTy.class + " with value " + n);
        }

        private PossibleRelocationsTy(String string) {
            this.swigName = string;
            this.swigValue = swigNext++;
        }

        private PossibleRelocationsTy(String string, int n) {
            this.swigName = string;
            this.swigValue = n;
            swigNext = n + 1;
        }

        private PossibleRelocationsTy(String string, PossibleRelocationsTy possibleRelocationsTy) {
            this.swigName = string;
            this.swigValue = possibleRelocationsTy.swigValue;
            swigNext = this.swigValue + 1;
        }
    }
}

