/*
 * Decompiled with CFR 0.152.
 */
package llvm;

import llvm.BasicBlock;
import llvm.Instruction;
import llvm.Twine;
import llvm.Use;
import llvm.Value;
import llvm.llvmJNI;

public class BinaryOperator
extends Instruction {
    private long swigCPtr;

    protected BinaryOperator(long l, boolean bl) {
        super(llvmJNI.SWIGBinaryOperatorUpcast(l), bl);
        this.swigCPtr = l;
    }

    protected static long getCPtr(BinaryOperator binaryOperator) {
        return binaryOperator == null ? 0L : binaryOperator.swigCPtr;
    }

    protected void dont_finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                llvmJNI.delete_BinaryOperator(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public Value getOperandValue(long l) {
        long l2 = llvmJNI.BinaryOperator_getOperand(this.swigCPtr, this, l);
        return l2 == 0L ? null : new Value(l2, false);
    }

    public void setOperand(long l, Value value) {
        llvmJNI.BinaryOperator_setOperand(this.swigCPtr, this, l, Value.getCPtr(value), value);
    }

    public Use op_begin() {
        long l = llvmJNI.BinaryOperator_op_begin__SWIG_0(this.swigCPtr, this);
        return l == 0L ? null : new Use(l, false);
    }

    public Use op_end() {
        long l = llvmJNI.BinaryOperator_op_end__SWIG_0(this.swigCPtr, this);
        return l == 0L ? null : new Use(l, false);
    }

    public long getNumOperands() {
        return llvmJNI.BinaryOperator_getNumOperands(this.swigCPtr, this);
    }

    public static BinaryOperator Create(Instruction.BinaryOps binaryOps, Value value, Value value2, Twine twine, Instruction instruction) {
        long l = llvmJNI.BinaryOperator_Create__SWIG_0(binaryOps.swigValue(), Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, Instruction.getCPtr(instruction), instruction);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator Create(Instruction.BinaryOps binaryOps, Value value, Value value2, Twine twine) {
        long l = llvmJNI.BinaryOperator_Create__SWIG_1(binaryOps.swigValue(), Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator Create(Instruction.BinaryOps binaryOps, Value value, Value value2) {
        long l = llvmJNI.BinaryOperator_Create__SWIG_2(binaryOps.swigValue(), Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator Create(Instruction.BinaryOps binaryOps, Value value, Value value2, Twine twine, BasicBlock basicBlock) {
        long l = llvmJNI.BinaryOperator_Create__SWIG_3(binaryOps.swigValue(), Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, BasicBlock.getCPtr(basicBlock), basicBlock);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateAdd(Value value, Value value2, Twine twine) {
        long l = llvmJNI.BinaryOperator_CreateAdd__SWIG_0(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateAdd(Value value, Value value2) {
        long l = llvmJNI.BinaryOperator_CreateAdd__SWIG_1(Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateFAdd(Value value, Value value2, Twine twine) {
        long l = llvmJNI.BinaryOperator_CreateFAdd__SWIG_0(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateFAdd(Value value, Value value2) {
        long l = llvmJNI.BinaryOperator_CreateFAdd__SWIG_1(Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateSub(Value value, Value value2, Twine twine) {
        long l = llvmJNI.BinaryOperator_CreateSub__SWIG_0(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateSub(Value value, Value value2) {
        long l = llvmJNI.BinaryOperator_CreateSub__SWIG_1(Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateFSub(Value value, Value value2, Twine twine) {
        long l = llvmJNI.BinaryOperator_CreateFSub__SWIG_0(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateFSub(Value value, Value value2) {
        long l = llvmJNI.BinaryOperator_CreateFSub__SWIG_1(Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateMul(Value value, Value value2, Twine twine) {
        long l = llvmJNI.BinaryOperator_CreateMul__SWIG_0(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateMul(Value value, Value value2) {
        long l = llvmJNI.BinaryOperator_CreateMul__SWIG_1(Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateFMul(Value value, Value value2, Twine twine) {
        long l = llvmJNI.BinaryOperator_CreateFMul__SWIG_0(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateFMul(Value value, Value value2) {
        long l = llvmJNI.BinaryOperator_CreateFMul__SWIG_1(Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateUDiv(Value value, Value value2, Twine twine) {
        long l = llvmJNI.BinaryOperator_CreateUDiv__SWIG_0(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateUDiv(Value value, Value value2) {
        long l = llvmJNI.BinaryOperator_CreateUDiv__SWIG_1(Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateSDiv(Value value, Value value2, Twine twine) {
        long l = llvmJNI.BinaryOperator_CreateSDiv__SWIG_0(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateSDiv(Value value, Value value2) {
        long l = llvmJNI.BinaryOperator_CreateSDiv__SWIG_1(Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateFDiv(Value value, Value value2, Twine twine) {
        long l = llvmJNI.BinaryOperator_CreateFDiv__SWIG_0(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateFDiv(Value value, Value value2) {
        long l = llvmJNI.BinaryOperator_CreateFDiv__SWIG_1(Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateURem(Value value, Value value2, Twine twine) {
        long l = llvmJNI.BinaryOperator_CreateURem__SWIG_0(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateURem(Value value, Value value2) {
        long l = llvmJNI.BinaryOperator_CreateURem__SWIG_1(Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateSRem(Value value, Value value2, Twine twine) {
        long l = llvmJNI.BinaryOperator_CreateSRem__SWIG_0(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateSRem(Value value, Value value2) {
        long l = llvmJNI.BinaryOperator_CreateSRem__SWIG_1(Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateFRem(Value value, Value value2, Twine twine) {
        long l = llvmJNI.BinaryOperator_CreateFRem__SWIG_0(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateFRem(Value value, Value value2) {
        long l = llvmJNI.BinaryOperator_CreateFRem__SWIG_1(Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateShl(Value value, Value value2, Twine twine) {
        long l = llvmJNI.BinaryOperator_CreateShl__SWIG_0(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateShl(Value value, Value value2) {
        long l = llvmJNI.BinaryOperator_CreateShl__SWIG_1(Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateLShr(Value value, Value value2, Twine twine) {
        long l = llvmJNI.BinaryOperator_CreateLShr__SWIG_0(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateLShr(Value value, Value value2) {
        long l = llvmJNI.BinaryOperator_CreateLShr__SWIG_1(Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateAShr(Value value, Value value2, Twine twine) {
        long l = llvmJNI.BinaryOperator_CreateAShr__SWIG_0(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateAShr(Value value, Value value2) {
        long l = llvmJNI.BinaryOperator_CreateAShr__SWIG_1(Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateAnd(Value value, Value value2, Twine twine) {
        long l = llvmJNI.BinaryOperator_CreateAnd__SWIG_0(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateAnd(Value value, Value value2) {
        long l = llvmJNI.BinaryOperator_CreateAnd__SWIG_1(Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateOr(Value value, Value value2, Twine twine) {
        long l = llvmJNI.BinaryOperator_CreateOr__SWIG_0(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateOr(Value value, Value value2) {
        long l = llvmJNI.BinaryOperator_CreateOr__SWIG_1(Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateXor(Value value, Value value2, Twine twine) {
        long l = llvmJNI.BinaryOperator_CreateXor__SWIG_0(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateXor(Value value, Value value2) {
        long l = llvmJNI.BinaryOperator_CreateXor__SWIG_1(Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateAdd(Value value, Value value2, Twine twine, BasicBlock basicBlock) {
        long l = llvmJNI.BinaryOperator_CreateAdd__SWIG_2(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, BasicBlock.getCPtr(basicBlock), basicBlock);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateFAdd(Value value, Value value2, Twine twine, BasicBlock basicBlock) {
        long l = llvmJNI.BinaryOperator_CreateFAdd__SWIG_2(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, BasicBlock.getCPtr(basicBlock), basicBlock);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateSub(Value value, Value value2, Twine twine, BasicBlock basicBlock) {
        long l = llvmJNI.BinaryOperator_CreateSub__SWIG_2(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, BasicBlock.getCPtr(basicBlock), basicBlock);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateFSub(Value value, Value value2, Twine twine, BasicBlock basicBlock) {
        long l = llvmJNI.BinaryOperator_CreateFSub__SWIG_2(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, BasicBlock.getCPtr(basicBlock), basicBlock);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateMul(Value value, Value value2, Twine twine, BasicBlock basicBlock) {
        long l = llvmJNI.BinaryOperator_CreateMul__SWIG_2(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, BasicBlock.getCPtr(basicBlock), basicBlock);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateFMul(Value value, Value value2, Twine twine, BasicBlock basicBlock) {
        long l = llvmJNI.BinaryOperator_CreateFMul__SWIG_2(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, BasicBlock.getCPtr(basicBlock), basicBlock);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateUDiv(Value value, Value value2, Twine twine, BasicBlock basicBlock) {
        long l = llvmJNI.BinaryOperator_CreateUDiv__SWIG_2(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, BasicBlock.getCPtr(basicBlock), basicBlock);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateSDiv(Value value, Value value2, Twine twine, BasicBlock basicBlock) {
        long l = llvmJNI.BinaryOperator_CreateSDiv__SWIG_2(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, BasicBlock.getCPtr(basicBlock), basicBlock);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateFDiv(Value value, Value value2, Twine twine, BasicBlock basicBlock) {
        long l = llvmJNI.BinaryOperator_CreateFDiv__SWIG_2(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, BasicBlock.getCPtr(basicBlock), basicBlock);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateURem(Value value, Value value2, Twine twine, BasicBlock basicBlock) {
        long l = llvmJNI.BinaryOperator_CreateURem__SWIG_2(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, BasicBlock.getCPtr(basicBlock), basicBlock);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateSRem(Value value, Value value2, Twine twine, BasicBlock basicBlock) {
        long l = llvmJNI.BinaryOperator_CreateSRem__SWIG_2(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, BasicBlock.getCPtr(basicBlock), basicBlock);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateFRem(Value value, Value value2, Twine twine, BasicBlock basicBlock) {
        long l = llvmJNI.BinaryOperator_CreateFRem__SWIG_2(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, BasicBlock.getCPtr(basicBlock), basicBlock);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateShl(Value value, Value value2, Twine twine, BasicBlock basicBlock) {
        long l = llvmJNI.BinaryOperator_CreateShl__SWIG_2(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, BasicBlock.getCPtr(basicBlock), basicBlock);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateLShr(Value value, Value value2, Twine twine, BasicBlock basicBlock) {
        long l = llvmJNI.BinaryOperator_CreateLShr__SWIG_2(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, BasicBlock.getCPtr(basicBlock), basicBlock);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateAShr(Value value, Value value2, Twine twine, BasicBlock basicBlock) {
        long l = llvmJNI.BinaryOperator_CreateAShr__SWIG_2(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, BasicBlock.getCPtr(basicBlock), basicBlock);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateAnd(Value value, Value value2, Twine twine, BasicBlock basicBlock) {
        long l = llvmJNI.BinaryOperator_CreateAnd__SWIG_2(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, BasicBlock.getCPtr(basicBlock), basicBlock);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateOr(Value value, Value value2, Twine twine, BasicBlock basicBlock) {
        long l = llvmJNI.BinaryOperator_CreateOr__SWIG_2(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, BasicBlock.getCPtr(basicBlock), basicBlock);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateXor(Value value, Value value2, Twine twine, BasicBlock basicBlock) {
        long l = llvmJNI.BinaryOperator_CreateXor__SWIG_2(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, BasicBlock.getCPtr(basicBlock), basicBlock);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateAdd(Value value, Value value2, Twine twine, Instruction instruction) {
        long l = llvmJNI.BinaryOperator_CreateAdd__SWIG_3(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, Instruction.getCPtr(instruction), instruction);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateFAdd(Value value, Value value2, Twine twine, Instruction instruction) {
        long l = llvmJNI.BinaryOperator_CreateFAdd__SWIG_3(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, Instruction.getCPtr(instruction), instruction);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateSub(Value value, Value value2, Twine twine, Instruction instruction) {
        long l = llvmJNI.BinaryOperator_CreateSub__SWIG_3(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, Instruction.getCPtr(instruction), instruction);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateFSub(Value value, Value value2, Twine twine, Instruction instruction) {
        long l = llvmJNI.BinaryOperator_CreateFSub__SWIG_3(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, Instruction.getCPtr(instruction), instruction);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateMul(Value value, Value value2, Twine twine, Instruction instruction) {
        long l = llvmJNI.BinaryOperator_CreateMul__SWIG_3(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, Instruction.getCPtr(instruction), instruction);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateFMul(Value value, Value value2, Twine twine, Instruction instruction) {
        long l = llvmJNI.BinaryOperator_CreateFMul__SWIG_3(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, Instruction.getCPtr(instruction), instruction);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateUDiv(Value value, Value value2, Twine twine, Instruction instruction) {
        long l = llvmJNI.BinaryOperator_CreateUDiv__SWIG_3(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, Instruction.getCPtr(instruction), instruction);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateSDiv(Value value, Value value2, Twine twine, Instruction instruction) {
        long l = llvmJNI.BinaryOperator_CreateSDiv__SWIG_3(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, Instruction.getCPtr(instruction), instruction);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateFDiv(Value value, Value value2, Twine twine, Instruction instruction) {
        long l = llvmJNI.BinaryOperator_CreateFDiv__SWIG_3(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, Instruction.getCPtr(instruction), instruction);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateURem(Value value, Value value2, Twine twine, Instruction instruction) {
        long l = llvmJNI.BinaryOperator_CreateURem__SWIG_3(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, Instruction.getCPtr(instruction), instruction);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateSRem(Value value, Value value2, Twine twine, Instruction instruction) {
        long l = llvmJNI.BinaryOperator_CreateSRem__SWIG_3(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, Instruction.getCPtr(instruction), instruction);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateFRem(Value value, Value value2, Twine twine, Instruction instruction) {
        long l = llvmJNI.BinaryOperator_CreateFRem__SWIG_3(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, Instruction.getCPtr(instruction), instruction);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateShl(Value value, Value value2, Twine twine, Instruction instruction) {
        long l = llvmJNI.BinaryOperator_CreateShl__SWIG_3(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, Instruction.getCPtr(instruction), instruction);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateLShr(Value value, Value value2, Twine twine, Instruction instruction) {
        long l = llvmJNI.BinaryOperator_CreateLShr__SWIG_3(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, Instruction.getCPtr(instruction), instruction);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateAShr(Value value, Value value2, Twine twine, Instruction instruction) {
        long l = llvmJNI.BinaryOperator_CreateAShr__SWIG_3(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, Instruction.getCPtr(instruction), instruction);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateAnd(Value value, Value value2, Twine twine, Instruction instruction) {
        long l = llvmJNI.BinaryOperator_CreateAnd__SWIG_3(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, Instruction.getCPtr(instruction), instruction);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateOr(Value value, Value value2, Twine twine, Instruction instruction) {
        long l = llvmJNI.BinaryOperator_CreateOr__SWIG_3(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, Instruction.getCPtr(instruction), instruction);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateXor(Value value, Value value2, Twine twine, Instruction instruction) {
        long l = llvmJNI.BinaryOperator_CreateXor__SWIG_3(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, Instruction.getCPtr(instruction), instruction);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateNSWAdd(Value value, Value value2, Twine twine) {
        long l = llvmJNI.BinaryOperator_CreateNSWAdd__SWIG_0(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateNSWAdd(Value value, Value value2) {
        long l = llvmJNI.BinaryOperator_CreateNSWAdd__SWIG_1(Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateNSWAdd(Value value, Value value2, Twine twine, BasicBlock basicBlock) {
        long l = llvmJNI.BinaryOperator_CreateNSWAdd__SWIG_2(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, BasicBlock.getCPtr(basicBlock), basicBlock);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateNSWAdd(Value value, Value value2, Twine twine, Instruction instruction) {
        long l = llvmJNI.BinaryOperator_CreateNSWAdd__SWIG_3(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, Instruction.getCPtr(instruction), instruction);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateNUWAdd(Value value, Value value2, Twine twine) {
        long l = llvmJNI.BinaryOperator_CreateNUWAdd__SWIG_0(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateNUWAdd(Value value, Value value2) {
        long l = llvmJNI.BinaryOperator_CreateNUWAdd__SWIG_1(Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateNUWAdd(Value value, Value value2, Twine twine, BasicBlock basicBlock) {
        long l = llvmJNI.BinaryOperator_CreateNUWAdd__SWIG_2(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, BasicBlock.getCPtr(basicBlock), basicBlock);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateNUWAdd(Value value, Value value2, Twine twine, Instruction instruction) {
        long l = llvmJNI.BinaryOperator_CreateNUWAdd__SWIG_3(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, Instruction.getCPtr(instruction), instruction);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateNSWSub(Value value, Value value2, Twine twine) {
        long l = llvmJNI.BinaryOperator_CreateNSWSub__SWIG_0(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateNSWSub(Value value, Value value2) {
        long l = llvmJNI.BinaryOperator_CreateNSWSub__SWIG_1(Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateNSWSub(Value value, Value value2, Twine twine, BasicBlock basicBlock) {
        long l = llvmJNI.BinaryOperator_CreateNSWSub__SWIG_2(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, BasicBlock.getCPtr(basicBlock), basicBlock);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateNSWSub(Value value, Value value2, Twine twine, Instruction instruction) {
        long l = llvmJNI.BinaryOperator_CreateNSWSub__SWIG_3(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, Instruction.getCPtr(instruction), instruction);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateNUWSub(Value value, Value value2, Twine twine) {
        long l = llvmJNI.BinaryOperator_CreateNUWSub__SWIG_0(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateNUWSub(Value value, Value value2) {
        long l = llvmJNI.BinaryOperator_CreateNUWSub__SWIG_1(Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateNUWSub(Value value, Value value2, Twine twine, BasicBlock basicBlock) {
        long l = llvmJNI.BinaryOperator_CreateNUWSub__SWIG_2(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, BasicBlock.getCPtr(basicBlock), basicBlock);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateNUWSub(Value value, Value value2, Twine twine, Instruction instruction) {
        long l = llvmJNI.BinaryOperator_CreateNUWSub__SWIG_3(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, Instruction.getCPtr(instruction), instruction);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateExactSDiv(Value value, Value value2, Twine twine) {
        long l = llvmJNI.BinaryOperator_CreateExactSDiv__SWIG_0(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateExactSDiv(Value value, Value value2) {
        long l = llvmJNI.BinaryOperator_CreateExactSDiv__SWIG_1(Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateExactSDiv(Value value, Value value2, Twine twine, BasicBlock basicBlock) {
        long l = llvmJNI.BinaryOperator_CreateExactSDiv__SWIG_2(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, BasicBlock.getCPtr(basicBlock), basicBlock);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateExactSDiv(Value value, Value value2, Twine twine, Instruction instruction) {
        long l = llvmJNI.BinaryOperator_CreateExactSDiv__SWIG_3(Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, Instruction.getCPtr(instruction), instruction);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateNeg(Value value, Twine twine, Instruction instruction) {
        long l = llvmJNI.BinaryOperator_CreateNeg__SWIG_0(Value.getCPtr(value), value, Twine.getCPtr(twine), twine, Instruction.getCPtr(instruction), instruction);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateNeg(Value value, Twine twine) {
        long l = llvmJNI.BinaryOperator_CreateNeg__SWIG_1(Value.getCPtr(value), value, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateNeg(Value value) {
        long l = llvmJNI.BinaryOperator_CreateNeg__SWIG_2(Value.getCPtr(value), value);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateNeg(Value value, Twine twine, BasicBlock basicBlock) {
        long l = llvmJNI.BinaryOperator_CreateNeg__SWIG_3(Value.getCPtr(value), value, Twine.getCPtr(twine), twine, BasicBlock.getCPtr(basicBlock), basicBlock);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateFNeg(Value value, Twine twine, Instruction instruction) {
        long l = llvmJNI.BinaryOperator_CreateFNeg__SWIG_0(Value.getCPtr(value), value, Twine.getCPtr(twine), twine, Instruction.getCPtr(instruction), instruction);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateFNeg(Value value, Twine twine) {
        long l = llvmJNI.BinaryOperator_CreateFNeg__SWIG_1(Value.getCPtr(value), value, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateFNeg(Value value) {
        long l = llvmJNI.BinaryOperator_CreateFNeg__SWIG_2(Value.getCPtr(value), value);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateFNeg(Value value, Twine twine, BasicBlock basicBlock) {
        long l = llvmJNI.BinaryOperator_CreateFNeg__SWIG_3(Value.getCPtr(value), value, Twine.getCPtr(twine), twine, BasicBlock.getCPtr(basicBlock), basicBlock);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateNot(Value value, Twine twine, Instruction instruction) {
        long l = llvmJNI.BinaryOperator_CreateNot__SWIG_0(Value.getCPtr(value), value, Twine.getCPtr(twine), twine, Instruction.getCPtr(instruction), instruction);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateNot(Value value, Twine twine) {
        long l = llvmJNI.BinaryOperator_CreateNot__SWIG_1(Value.getCPtr(value), value, Twine.getCPtr(twine), twine);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateNot(Value value) {
        long l = llvmJNI.BinaryOperator_CreateNot__SWIG_2(Value.getCPtr(value), value);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static BinaryOperator CreateNot(Value value, Twine twine, BasicBlock basicBlock) {
        long l = llvmJNI.BinaryOperator_CreateNot__SWIG_3(Value.getCPtr(value), value, Twine.getCPtr(twine), twine, BasicBlock.getCPtr(basicBlock), basicBlock);
        return l == 0L ? null : new BinaryOperator(l, false);
    }

    public static boolean isNeg(Value value) {
        return llvmJNI.BinaryOperator_isNeg(Value.getCPtr(value), value);
    }

    public static boolean isFNeg(Value value) {
        return llvmJNI.BinaryOperator_isFNeg(Value.getCPtr(value), value);
    }

    public static boolean isNot(Value value) {
        return llvmJNI.BinaryOperator_isNot(Value.getCPtr(value), value);
    }

    public static Value getNegArgument(Value value) {
        long l = llvmJNI.BinaryOperator_getNegArgument__SWIG_0(Value.getCPtr(value), value);
        return l == 0L ? null : new Value(l, false);
    }

    public static Value getFNegArgument(Value value) {
        long l = llvmJNI.BinaryOperator_getFNegArgument__SWIG_0(Value.getCPtr(value), value);
        return l == 0L ? null : new Value(l, false);
    }

    public static Value getNotArgument(Value value) {
        long l = llvmJNI.BinaryOperator_getNotArgument__SWIG_0(Value.getCPtr(value), value);
        return l == 0L ? null : new Value(l, false);
    }

    public Instruction.BinaryOps getOpcodeEnum() {
        return Instruction.BinaryOps.swigToEnum(llvmJNI.BinaryOperator_getOpcode(this.swigCPtr, this));
    }

    public boolean swapOperands() {
        return llvmJNI.BinaryOperator_swapOperands(this.swigCPtr, this);
    }

    public void setHasNoUnsignedWrap(boolean bl) {
        llvmJNI.BinaryOperator_setHasNoUnsignedWrap__SWIG_0(this.swigCPtr, this, bl);
    }

    public void setHasNoUnsignedWrap() {
        llvmJNI.BinaryOperator_setHasNoUnsignedWrap__SWIG_1(this.swigCPtr, this);
    }

    public void setHasNoSignedWrap(boolean bl) {
        llvmJNI.BinaryOperator_setHasNoSignedWrap__SWIG_0(this.swigCPtr, this, bl);
    }

    public void setHasNoSignedWrap() {
        llvmJNI.BinaryOperator_setHasNoSignedWrap__SWIG_1(this.swigCPtr, this);
    }

    public void setIsExact(boolean bl) {
        llvmJNI.BinaryOperator_setIsExact__SWIG_0(this.swigCPtr, this, bl);
    }

    public void setIsExact() {
        llvmJNI.BinaryOperator_setIsExact__SWIG_1(this.swigCPtr, this);
    }

    public boolean hasNoUnsignedWrap() {
        return llvmJNI.BinaryOperator_hasNoUnsignedWrap(this.swigCPtr, this);
    }

    public boolean hasNoSignedWrap() {
        return llvmJNI.BinaryOperator_hasNoSignedWrap(this.swigCPtr, this);
    }

    public boolean isExact() {
        return llvmJNI.BinaryOperator_isExact(this.swigCPtr, this);
    }

    public static boolean classof(BinaryOperator binaryOperator) {
        return llvmJNI.BinaryOperator_classof__SWIG_0(BinaryOperator.getCPtr(binaryOperator), binaryOperator);
    }

    public static boolean classof(Instruction instruction) {
        return llvmJNI.BinaryOperator_classof__SWIG_1(Instruction.getCPtr(instruction), instruction);
    }

    public static boolean classof(Value value) {
        return llvmJNI.BinaryOperator_classof__SWIG_2(Value.getCPtr(value), value);
    }

    public static BinaryOperator dyn_cast(Instruction instruction) {
        long l = llvmJNI.BinaryOperator_dyn_cast(Instruction.getCPtr(instruction), instruction);
        return l == 0L ? null : new BinaryOperator(l, false);
    }
}

