/*
 * Decompiled with CFR 0.152.
 */
package llvm;

import java.math.BigInteger;
import llvm.APInt;
import llvm.FoldingSetNodeID;
import llvm.SWIGTYPE_p_bool;
import llvm.SWIGTYPE_p_llvm__Deserializer;
import llvm.SWIGTYPE_p_llvm__Serializer;
import llvm.SWIGTYPE_p_llvm__fltSemantics;
import llvm.SWIGTYPE_p_unsigned_long_long;
import llvm.StringRef;
import llvm.llvmJNI;

public class APFloat {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected APFloat(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(APFloat aPFloat) {
        return aPFloat == null ? 0L : aPFloat.swigCPtr;
    }

    protected void dont_finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                llvmJNI.delete_APFloat(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public static SWIGTYPE_p_llvm__fltSemantics getIEEEhalf() {
        long l = llvmJNI.APFloat_IEEEhalf_get();
        return l == 0L ? null : new SWIGTYPE_p_llvm__fltSemantics(l, false);
    }

    public static SWIGTYPE_p_llvm__fltSemantics getIEEEsingle() {
        long l = llvmJNI.APFloat_IEEEsingle_get();
        return l == 0L ? null : new SWIGTYPE_p_llvm__fltSemantics(l, false);
    }

    public static SWIGTYPE_p_llvm__fltSemantics getIEEEdouble() {
        long l = llvmJNI.APFloat_IEEEdouble_get();
        return l == 0L ? null : new SWIGTYPE_p_llvm__fltSemantics(l, false);
    }

    public static SWIGTYPE_p_llvm__fltSemantics getIEEEquad() {
        long l = llvmJNI.APFloat_IEEEquad_get();
        return l == 0L ? null : new SWIGTYPE_p_llvm__fltSemantics(l, false);
    }

    public static SWIGTYPE_p_llvm__fltSemantics getPPCDoubleDouble() {
        long l = llvmJNI.APFloat_PPCDoubleDouble_get();
        return l == 0L ? null : new SWIGTYPE_p_llvm__fltSemantics(l, false);
    }

    public static SWIGTYPE_p_llvm__fltSemantics getX87DoubleExtended() {
        long l = llvmJNI.APFloat_x87DoubleExtended_get();
        return l == 0L ? null : new SWIGTYPE_p_llvm__fltSemantics(l, false);
    }

    public static SWIGTYPE_p_llvm__fltSemantics getBogus() {
        long l = llvmJNI.APFloat_Bogus_get();
        return l == 0L ? null : new SWIGTYPE_p_llvm__fltSemantics(l, false);
    }

    public static long semanticsPrecision(SWIGTYPE_p_llvm__fltSemantics sWIGTYPE_p_llvm__fltSemantics) {
        return llvmJNI.APFloat_semanticsPrecision(SWIGTYPE_p_llvm__fltSemantics.getCPtr(sWIGTYPE_p_llvm__fltSemantics));
    }

    public APFloat(SWIGTYPE_p_llvm__fltSemantics sWIGTYPE_p_llvm__fltSemantics) {
        this(llvmJNI.new_APFloat__SWIG_0(SWIGTYPE_p_llvm__fltSemantics.getCPtr(sWIGTYPE_p_llvm__fltSemantics)), true);
    }

    public APFloat(SWIGTYPE_p_llvm__fltSemantics sWIGTYPE_p_llvm__fltSemantics, StringRef stringRef) {
        this(llvmJNI.new_APFloat__SWIG_1(SWIGTYPE_p_llvm__fltSemantics.getCPtr(sWIGTYPE_p_llvm__fltSemantics), StringRef.getCPtr(stringRef), stringRef), true);
    }

    public APFloat(SWIGTYPE_p_llvm__fltSemantics sWIGTYPE_p_llvm__fltSemantics, BigInteger bigInteger) {
        this(llvmJNI.new_APFloat__SWIG_2(SWIGTYPE_p_llvm__fltSemantics.getCPtr(sWIGTYPE_p_llvm__fltSemantics), bigInteger), true);
    }

    public APFloat(SWIGTYPE_p_llvm__fltSemantics sWIGTYPE_p_llvm__fltSemantics, fltCategory fltCategory2, boolean bl, long l) {
        this(llvmJNI.new_APFloat__SWIG_3(SWIGTYPE_p_llvm__fltSemantics.getCPtr(sWIGTYPE_p_llvm__fltSemantics), fltCategory2.swigValue(), bl, l), true);
    }

    public APFloat(SWIGTYPE_p_llvm__fltSemantics sWIGTYPE_p_llvm__fltSemantics, fltCategory fltCategory2, boolean bl) {
        this(llvmJNI.new_APFloat__SWIG_4(SWIGTYPE_p_llvm__fltSemantics.getCPtr(sWIGTYPE_p_llvm__fltSemantics), fltCategory2.swigValue(), bl), true);
    }

    public APFloat(double d) {
        this(llvmJNI.new_APFloat__SWIG_5(d), true);
    }

    public APFloat(float f) {
        this(llvmJNI.new_APFloat__SWIG_6(f), true);
    }

    public APFloat(APInt aPInt, boolean bl) {
        this(llvmJNI.new_APFloat__SWIG_7(APInt.getCPtr(aPInt), aPInt, bl), true);
    }

    public APFloat(APInt aPInt) {
        this(llvmJNI.new_APFloat__SWIG_8(APInt.getCPtr(aPInt), aPInt), true);
    }

    public APFloat(APFloat aPFloat) {
        this(llvmJNI.new_APFloat__SWIG_9(APFloat.getCPtr(aPFloat), aPFloat), true);
    }

    public static APFloat getZero(SWIGTYPE_p_llvm__fltSemantics sWIGTYPE_p_llvm__fltSemantics, boolean bl) {
        return new APFloat(llvmJNI.APFloat_getZero__SWIG_0(SWIGTYPE_p_llvm__fltSemantics.getCPtr(sWIGTYPE_p_llvm__fltSemantics), bl), true);
    }

    public static APFloat getZero(SWIGTYPE_p_llvm__fltSemantics sWIGTYPE_p_llvm__fltSemantics) {
        return new APFloat(llvmJNI.APFloat_getZero__SWIG_1(SWIGTYPE_p_llvm__fltSemantics.getCPtr(sWIGTYPE_p_llvm__fltSemantics)), true);
    }

    public static APFloat getInf(SWIGTYPE_p_llvm__fltSemantics sWIGTYPE_p_llvm__fltSemantics, boolean bl) {
        return new APFloat(llvmJNI.APFloat_getInf__SWIG_0(SWIGTYPE_p_llvm__fltSemantics.getCPtr(sWIGTYPE_p_llvm__fltSemantics), bl), true);
    }

    public static APFloat getInf(SWIGTYPE_p_llvm__fltSemantics sWIGTYPE_p_llvm__fltSemantics) {
        return new APFloat(llvmJNI.APFloat_getInf__SWIG_1(SWIGTYPE_p_llvm__fltSemantics.getCPtr(sWIGTYPE_p_llvm__fltSemantics)), true);
    }

    public static APFloat getNaN(SWIGTYPE_p_llvm__fltSemantics sWIGTYPE_p_llvm__fltSemantics, boolean bl, long l) {
        return new APFloat(llvmJNI.APFloat_getNaN__SWIG_0(SWIGTYPE_p_llvm__fltSemantics.getCPtr(sWIGTYPE_p_llvm__fltSemantics), bl, l), true);
    }

    public static APFloat getNaN(SWIGTYPE_p_llvm__fltSemantics sWIGTYPE_p_llvm__fltSemantics, boolean bl) {
        return new APFloat(llvmJNI.APFloat_getNaN__SWIG_1(SWIGTYPE_p_llvm__fltSemantics.getCPtr(sWIGTYPE_p_llvm__fltSemantics), bl), true);
    }

    public static APFloat getNaN(SWIGTYPE_p_llvm__fltSemantics sWIGTYPE_p_llvm__fltSemantics) {
        return new APFloat(llvmJNI.APFloat_getNaN__SWIG_2(SWIGTYPE_p_llvm__fltSemantics.getCPtr(sWIGTYPE_p_llvm__fltSemantics)), true);
    }

    public void Profile(FoldingSetNodeID foldingSetNodeID) {
        llvmJNI.APFloat_Profile(this.swigCPtr, this, FoldingSetNodeID.getCPtr(foldingSetNodeID), foldingSetNodeID);
    }

    public void Emit(SWIGTYPE_p_llvm__Serializer sWIGTYPE_p_llvm__Serializer) {
        llvmJNI.APFloat_Emit(this.swigCPtr, this, SWIGTYPE_p_llvm__Serializer.getCPtr(sWIGTYPE_p_llvm__Serializer));
    }

    public static APFloat ReadVal(SWIGTYPE_p_llvm__Deserializer sWIGTYPE_p_llvm__Deserializer) {
        return new APFloat(llvmJNI.APFloat_ReadVal(SWIGTYPE_p_llvm__Deserializer.getCPtr(sWIGTYPE_p_llvm__Deserializer)), true);
    }

    public opStatus add(APFloat aPFloat, roundingMode roundingMode2) {
        return opStatus.swigToEnum(llvmJNI.APFloat_add(this.swigCPtr, this, APFloat.getCPtr(aPFloat), aPFloat, roundingMode2.swigValue()));
    }

    public opStatus subtract(APFloat aPFloat, roundingMode roundingMode2) {
        return opStatus.swigToEnum(llvmJNI.APFloat_subtract(this.swigCPtr, this, APFloat.getCPtr(aPFloat), aPFloat, roundingMode2.swigValue()));
    }

    public opStatus multiply(APFloat aPFloat, roundingMode roundingMode2) {
        return opStatus.swigToEnum(llvmJNI.APFloat_multiply(this.swigCPtr, this, APFloat.getCPtr(aPFloat), aPFloat, roundingMode2.swigValue()));
    }

    public opStatus divide(APFloat aPFloat, roundingMode roundingMode2) {
        return opStatus.swigToEnum(llvmJNI.APFloat_divide(this.swigCPtr, this, APFloat.getCPtr(aPFloat), aPFloat, roundingMode2.swigValue()));
    }

    public opStatus remainder(APFloat aPFloat) {
        return opStatus.swigToEnum(llvmJNI.APFloat_remainder(this.swigCPtr, this, APFloat.getCPtr(aPFloat), aPFloat));
    }

    public opStatus mod(APFloat aPFloat, roundingMode roundingMode2) {
        return opStatus.swigToEnum(llvmJNI.APFloat_mod(this.swigCPtr, this, APFloat.getCPtr(aPFloat), aPFloat, roundingMode2.swigValue()));
    }

    public opStatus fusedMultiplyAdd(APFloat aPFloat, APFloat aPFloat2, roundingMode roundingMode2) {
        return opStatus.swigToEnum(llvmJNI.APFloat_fusedMultiplyAdd(this.swigCPtr, this, APFloat.getCPtr(aPFloat), aPFloat, APFloat.getCPtr(aPFloat2), aPFloat2, roundingMode2.swigValue()));
    }

    public void changeSign() {
        llvmJNI.APFloat_changeSign(this.swigCPtr, this);
    }

    public void clearSign() {
        llvmJNI.APFloat_clearSign(this.swigCPtr, this);
    }

    public void copySign(APFloat aPFloat) {
        llvmJNI.APFloat_copySign(this.swigCPtr, this, APFloat.getCPtr(aPFloat), aPFloat);
    }

    public opStatus convert(SWIGTYPE_p_llvm__fltSemantics sWIGTYPE_p_llvm__fltSemantics, roundingMode roundingMode2, SWIGTYPE_p_bool sWIGTYPE_p_bool) {
        return opStatus.swigToEnum(llvmJNI.APFloat_convert(this.swigCPtr, this, SWIGTYPE_p_llvm__fltSemantics.getCPtr(sWIGTYPE_p_llvm__fltSemantics), roundingMode2.swigValue(), SWIGTYPE_p_bool.getCPtr(sWIGTYPE_p_bool)));
    }

    public opStatus convertToInteger(SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long, long l, boolean bl, roundingMode roundingMode2, SWIGTYPE_p_bool sWIGTYPE_p_bool) {
        return opStatus.swigToEnum(llvmJNI.APFloat_convertToInteger(this.swigCPtr, this, SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long), l, bl, roundingMode2.swigValue(), SWIGTYPE_p_bool.getCPtr(sWIGTYPE_p_bool)));
    }

    public opStatus convertFromAPInt(APInt aPInt, boolean bl, roundingMode roundingMode2) {
        return opStatus.swigToEnum(llvmJNI.APFloat_convertFromAPInt(this.swigCPtr, this, APInt.getCPtr(aPInt), aPInt, bl, roundingMode2.swigValue()));
    }

    public opStatus convertFromSignExtendedInteger(SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long, long l, boolean bl, roundingMode roundingMode2) {
        return opStatus.swigToEnum(llvmJNI.APFloat_convertFromSignExtendedInteger(this.swigCPtr, this, SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long), l, bl, roundingMode2.swigValue()));
    }

    public opStatus convertFromZeroExtendedInteger(SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long, long l, boolean bl, roundingMode roundingMode2) {
        return opStatus.swigToEnum(llvmJNI.APFloat_convertFromZeroExtendedInteger(this.swigCPtr, this, SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long), l, bl, roundingMode2.swigValue()));
    }

    public opStatus convertFromString(StringRef stringRef, roundingMode roundingMode2) {
        return opStatus.swigToEnum(llvmJNI.APFloat_convertFromString(this.swigCPtr, this, StringRef.getCPtr(stringRef), stringRef, roundingMode2.swigValue()));
    }

    public APInt bitcastToAPInt() {
        return new APInt(llvmJNI.APFloat_bitcastToAPInt(this.swigCPtr, this), true);
    }

    public double convertToDouble() {
        return llvmJNI.APFloat_convertToDouble(this.swigCPtr, this);
    }

    public float convertToFloat() {
        return llvmJNI.APFloat_convertToFloat(this.swigCPtr, this);
    }

    public cmpResult compare(APFloat aPFloat) {
        return cmpResult.swigToEnum(llvmJNI.APFloat_compare(this.swigCPtr, this, APFloat.getCPtr(aPFloat), aPFloat));
    }

    public boolean bitwiseIsEqual(APFloat aPFloat) {
        return llvmJNI.APFloat_bitwiseIsEqual(this.swigCPtr, this, APFloat.getCPtr(aPFloat), aPFloat);
    }

    public long convertToHexString(String string, long l, boolean bl, roundingMode roundingMode2) {
        return llvmJNI.APFloat_convertToHexString(this.swigCPtr, this, string, l, bl, roundingMode2.swigValue());
    }

    public fltCategory getCategory() {
        return fltCategory.swigToEnum(llvmJNI.APFloat_getCategory(this.swigCPtr, this));
    }

    public SWIGTYPE_p_llvm__fltSemantics getSemantics() {
        return new SWIGTYPE_p_llvm__fltSemantics(llvmJNI.APFloat_getSemantics(this.swigCPtr, this), false);
    }

    public boolean isZero() {
        return llvmJNI.APFloat_isZero(this.swigCPtr, this);
    }

    public boolean isNonZero() {
        return llvmJNI.APFloat_isNonZero(this.swigCPtr, this);
    }

    public boolean isNaN() {
        return llvmJNI.APFloat_isNaN(this.swigCPtr, this);
    }

    public boolean isInfinity() {
        return llvmJNI.APFloat_isInfinity(this.swigCPtr, this);
    }

    public boolean isNegative() {
        return llvmJNI.APFloat_isNegative(this.swigCPtr, this);
    }

    public boolean isPosZero() {
        return llvmJNI.APFloat_isPosZero(this.swigCPtr, this);
    }

    public boolean isNegZero() {
        return llvmJNI.APFloat_isNegZero(this.swigCPtr, this);
    }

    public long getHashValue() {
        return llvmJNI.APFloat_getHashValue(this.swigCPtr, this);
    }

    public static final class fltCategory {
        public static final fltCategory fcInfinity = new fltCategory("fcInfinity");
        public static final fltCategory fcNaN = new fltCategory("fcNaN");
        public static final fltCategory fcNormal = new fltCategory("fcNormal");
        public static final fltCategory fcZero = new fltCategory("fcZero");
        private static fltCategory[] swigValues = new fltCategory[]{fcInfinity, fcNaN, fcNormal, fcZero};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static fltCategory swigToEnum(int n) {
            if (n < swigValues.length && n >= 0 && fltCategory.swigValues[n].swigValue == n) {
                return swigValues[n];
            }
            for (int i = 0; i < swigValues.length; ++i) {
                if (fltCategory.swigValues[i].swigValue != n) continue;
                return swigValues[i];
            }
            throw new IllegalArgumentException("No enum " + fltCategory.class + " with value " + n);
        }

        private fltCategory(String string) {
            this.swigName = string;
            this.swigValue = swigNext++;
        }

        private fltCategory(String string, int n) {
            this.swigName = string;
            this.swigValue = n;
            swigNext = n + 1;
        }

        private fltCategory(String string, fltCategory fltCategory2) {
            this.swigName = string;
            this.swigValue = fltCategory2.swigValue;
            swigNext = this.swigValue + 1;
        }
    }

    public static final class opStatus {
        public static final opStatus opOK = new opStatus("opOK", llvmJNI.APFloat_opOK_get());
        public static final opStatus opInvalidOp = new opStatus("opInvalidOp", llvmJNI.APFloat_opInvalidOp_get());
        public static final opStatus opDivByZero = new opStatus("opDivByZero", llvmJNI.APFloat_opDivByZero_get());
        public static final opStatus opOverflow = new opStatus("opOverflow", llvmJNI.APFloat_opOverflow_get());
        public static final opStatus opUnderflow = new opStatus("opUnderflow", llvmJNI.APFloat_opUnderflow_get());
        public static final opStatus opInexact = new opStatus("opInexact", llvmJNI.APFloat_opInexact_get());
        private static opStatus[] swigValues = new opStatus[]{opOK, opInvalidOp, opDivByZero, opOverflow, opUnderflow, opInexact};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static opStatus swigToEnum(int n) {
            if (n < swigValues.length && n >= 0 && opStatus.swigValues[n].swigValue == n) {
                return swigValues[n];
            }
            for (int i = 0; i < swigValues.length; ++i) {
                if (opStatus.swigValues[i].swigValue != n) continue;
                return swigValues[i];
            }
            throw new IllegalArgumentException("No enum " + opStatus.class + " with value " + n);
        }

        private opStatus(String string) {
            this.swigName = string;
            this.swigValue = swigNext++;
        }

        private opStatus(String string, int n) {
            this.swigName = string;
            this.swigValue = n;
            swigNext = n + 1;
        }

        private opStatus(String string, opStatus opStatus2) {
            this.swigName = string;
            this.swigValue = opStatus2.swigValue;
            swigNext = this.swigValue + 1;
        }
    }

    public static final class roundingMode {
        public static final roundingMode rmNearestTiesToEven = new roundingMode("rmNearestTiesToEven");
        public static final roundingMode rmTowardPositive = new roundingMode("rmTowardPositive");
        public static final roundingMode rmTowardNegative = new roundingMode("rmTowardNegative");
        public static final roundingMode rmTowardZero = new roundingMode("rmTowardZero");
        public static final roundingMode rmNearestTiesToAway = new roundingMode("rmNearestTiesToAway");
        private static roundingMode[] swigValues = new roundingMode[]{rmNearestTiesToEven, rmTowardPositive, rmTowardNegative, rmTowardZero, rmNearestTiesToAway};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static roundingMode swigToEnum(int n) {
            if (n < swigValues.length && n >= 0 && roundingMode.swigValues[n].swigValue == n) {
                return swigValues[n];
            }
            for (int i = 0; i < swigValues.length; ++i) {
                if (roundingMode.swigValues[i].swigValue != n) continue;
                return swigValues[i];
            }
            throw new IllegalArgumentException("No enum " + roundingMode.class + " with value " + n);
        }

        private roundingMode(String string) {
            this.swigName = string;
            this.swigValue = swigNext++;
        }

        private roundingMode(String string, int n) {
            this.swigName = string;
            this.swigValue = n;
            swigNext = n + 1;
        }

        private roundingMode(String string, roundingMode roundingMode2) {
            this.swigName = string;
            this.swigValue = roundingMode2.swigValue;
            swigNext = this.swigValue + 1;
        }
    }

    public static final class cmpResult {
        public static final cmpResult cmpLessThan = new cmpResult("cmpLessThan");
        public static final cmpResult cmpEqual = new cmpResult("cmpEqual");
        public static final cmpResult cmpGreaterThan = new cmpResult("cmpGreaterThan");
        public static final cmpResult cmpUnordered = new cmpResult("cmpUnordered");
        private static cmpResult[] swigValues = new cmpResult[]{cmpLessThan, cmpEqual, cmpGreaterThan, cmpUnordered};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static cmpResult swigToEnum(int n) {
            if (n < swigValues.length && n >= 0 && cmpResult.swigValues[n].swigValue == n) {
                return swigValues[n];
            }
            for (int i = 0; i < swigValues.length; ++i) {
                if (cmpResult.swigValues[i].swigValue != n) continue;
                return swigValues[i];
            }
            throw new IllegalArgumentException("No enum " + cmpResult.class + " with value " + n);
        }

        private cmpResult(String string) {
            this.swigName = string;
            this.swigValue = swigNext++;
        }

        private cmpResult(String string, int n) {
            this.swigName = string;
            this.swigValue = n;
            swigNext = n + 1;
        }

        private cmpResult(String string, cmpResult cmpResult2) {
            this.swigName = string;
            this.swigValue = cmpResult2.swigValue;
            swigNext = this.swigValue + 1;
        }
    }
}

