/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.BuiltinDomain;
import adobe.abc.Expr;
import adobe.abc.Namespace;
import adobe.abc.OptimizerConstants;
import adobe.abc.Type;
import adobe.abc.Typeref;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeAnalysis {
    private static boolean isPointer(Type t) {
        return !t.isAtom() && !t.numeric;
    }

    public static Object eval_convert_i(Object v0) {
        return v0 instanceof Number ? Integer.valueOf(TypeAnalysis.intValue(v0)) : (v0 == Boolean.TRUE ? Integer.valueOf(1) : (v0 == Boolean.FALSE ? Integer.valueOf(0) : OptimizerConstants.BOTTOM));
    }

    public static Object eval_convert_u(Object v0) {
        return v0 instanceof Number ? Long.valueOf(TypeAnalysis.uintValue(v0)) : (v0 == Boolean.TRUE ? Integer.valueOf(1) : (v0 == Boolean.FALSE ? Integer.valueOf(0) : OptimizerConstants.BOTTOM));
    }

    public static Object eval_convert_d(Object v0) {
        return v0 instanceof Number ? Double.valueOf(TypeAnalysis.doubleValue(v0)) : (v0 == Boolean.TRUE ? Integer.valueOf(1) : (v0 == Boolean.FALSE ? Integer.valueOf(0) : OptimizerConstants.BOTTOM));
    }

    public static Object eval_convert_b(Object v0) {
        return v0 == OptimizerConstants.BOTTOM ? OptimizerConstants.BOTTOM : (TypeAnalysis.booleanValue(v0) ? Boolean.TRUE : Boolean.FALSE);
    }

    public static Object eval_convert_s(Object v0) {
        if (v0 == BuiltinDomain.instance().NULL) {
            return "null";
        }
        return v0 != OptimizerConstants.BOTTOM ? TypeAnalysis.stringValue(v0) : OptimizerConstants.BOTTOM;
    }

    public static Typeref eval_coerce_s(Typeref t0) {
        if (t0.nullable) {
            return t0.t == BuiltinDomain.instance().VOID || t0.t == BuiltinDomain.instance().NULL ? BuiltinDomain.instance().NULL.ref : BuiltinDomain.instance().STRING.ref;
        }
        return BuiltinDomain.instance().STRING.ref.exactnonnull();
    }

    public static Object eval_coerce_s(Object v0) {
        return v0 == OptimizerConstants.UNDEFINED || v0 == BuiltinDomain.instance().NULL ? BuiltinDomain.instance().NULL : (v0 != OptimizerConstants.BOTTOM ? TypeAnalysis.stringValue(v0) : OptimizerConstants.BOTTOM);
    }

    public static Typeref eval_coerce_o(Typeref t0) {
        if (t0.nullable) {
            return t0.t.extendsOrIsBase(BuiltinDomain.instance().OBJECT) ? t0 : (t0.t == BuiltinDomain.instance().VOID || t0.t == BuiltinDomain.instance().NULL ? BuiltinDomain.instance().NULL.ref : BuiltinDomain.instance().OBJECT.ref);
        }
        return t0.t.extendsOrIsBase(BuiltinDomain.instance().OBJECT) ? t0 : BuiltinDomain.instance().OBJECT.ref.nonnull();
    }

    public static Object eval_coerce_o(Object v0, Type t0) {
        return t0.extendsOrIsBase(BuiltinDomain.instance().OBJECT) ? v0 : (t0 == BuiltinDomain.instance().VOID || t0 == BuiltinDomain.instance().NULL ? BuiltinDomain.instance().NULL : OptimizerConstants.BOTTOM);
    }

    public static boolean lessthan(Object v0, Object v1) {
        if (v0 instanceof String && v1 instanceof String) {
            return ((String)v0).compareTo((String)v1) < 0;
        }
        return TypeAnalysis.doubleValue(v0) < TypeAnalysis.doubleValue(v1);
    }

    public static Type type(Map<Expr, Typeref> types, Expr e) {
        assert (types.containsKey(e));
        return types.get((Object)e).t;
    }

    public static int intValue(Object o) {
        return ((Number)o).intValue();
    }

    public static long uintValue(Object o) {
        return ((Number)o).longValue() & 0xFFFFFFFFL;
    }

    public static double doubleValue(Object o) {
        if (o instanceof Boolean) {
            return o == Boolean.TRUE ? 1.0 : 0.0;
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        return Double.NaN;
    }

    public static boolean booleanValue(Object o) {
        if (o instanceof Boolean) {
            return o == Boolean.TRUE;
        }
        if (o instanceof Namespace) {
            return true;
        }
        if (o instanceof String) {
            return ((String)o).length() > 0;
        }
        if (o == BuiltinDomain.instance().NULL || o == OptimizerConstants.UNDEFINED) {
            return false;
        }
        return TypeAnalysis.doubleValue(o) != 0.0;
    }

    public static String stringValue(Object v0) {
        if (v0 instanceof Number) {
            System.err.println("ERROR: formatting double using non-ecmascript rules.");
        }
        return String.valueOf(v0);
    }

    public static Typeref mdb(Typeref a, Typeref b) {
        assert (a != b && a != null && b != null);
        if (a.t == BuiltinDomain.instance().NULL && TypeAnalysis.isPointer(b.t)) {
            return b;
        }
        if (b.t == BuiltinDomain.instance().NULL && TypeAnalysis.isPointer(a.t)) {
            return a;
        }
        HashSet<Type> bases = new HashSet<Type>();
        Type t = a.t;
        while (t != null) {
            bases.add(t);
            t = t.base;
        }
        t = b.t;
        while (t != null) {
            if (bases.contains(t)) {
                return new Typeref(t, a.nullable | b.nullable);
            }
            t = t.base;
        }
        return new Typeref(BuiltinDomain.instance().ANY, a.nullable | b.nullable);
    }
}

