/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.Binding;
import adobe.abc.BuiltinDomain;
import adobe.abc.GlobalOptimizer;
import adobe.abc.Method;
import adobe.abc.Name;
import adobe.abc.Namespace;
import adobe.abc.OptimizerConstants;
import adobe.abc.Symtab;
import adobe.abc.Typeref;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Type {
    Name name;
    public Type base;
    Type[] interfaces = OptimizerConstants.notypes;
    Symtab<Binding> defs;
    Method init;
    Type itype;
    int flags;
    Namespace protectedNs;
    Typeref[] scopes = OptimizerConstants.notyperefs;
    boolean[] withScopes = OptimizerConstants.nowithscopes;
    boolean numeric;
    boolean primitive;
    boolean atom;
    Object defaultValue;
    public Typeref ref;
    private boolean m_resolved;
    int slotCount;
    private final Type[] m_params;

    private Type(Type[] paramTypes) {
        this.m_params = paramTypes;
        this.ref = new Typeref(this, true);
        this.defaultValue = BuiltinDomain.instance().NULL;
        this.m_resolved = false;
    }

    Type(Name name, Type base, Type[] paramTypes) {
        this(paramTypes);
        this.name = name;
        this.base = base;
        this.defs = new Symtab();
    }

    private Type() {
        this(null);
    }

    Type(Name name, Type base) {
        this(name, base, null);
    }

    public static Type newActivationType() {
        return new Type();
    }

    boolean emitAsAny() {
        return this.base == null && this != BuiltinDomain.instance().VOID && this.defs.size() == 0 && !BuiltinDomain.instance().builtinTypes.contains(this) && !BuiltinDomain.instance().baseTypes.contains(this);
    }

    public boolean isFinal() {
        return (this.flags & 2) != 0;
    }

    public boolean isInterface() {
        return (this.flags & 4) != 0;
    }

    void setFinal() {
        this.flags |= 2;
    }

    Binding find(Name n) {
        Type t = this;
        while (t != null) {
            Binding b = t.defs.get(n);
            if (b != null) {
                return b;
            }
            t = t.base;
        }
        return null;
    }

    Binding findGet(Name n) {
        Binding first = this.find(n);
        if (first != null && GlobalOptimizer.isSetter(first)) {
            Binding second;
            if (first.peer != null) {
                return first.peer;
            }
            if (this.base != null && GlobalOptimizer.isGetter(second = this.base.findGet(n))) {
                return second;
            }
        }
        return first;
    }

    public Typeref getSlotType(int slot) {
        Binding b = this.findSlot(slot);
        if (b != null) {
            return b.type;
        }
        return BuiltinDomain.instance().ANY().ref.nullable();
    }

    public Binding findSlot(int slot) {
        if (slot > this.slotCount) {
            throw new Error("Type " + this.getName().format() + " does not have slot id " + String.valueOf(slot) + ".");
        }
        Type t = this;
        while (t.base != null && t.base.slotCount >= slot) {
            t = t.base;
        }
        for (Binding b : t.defs.values()) {
            if (!GlobalOptimizer.isSlot(b) || b.slot != slot) continue;
            return b;
        }
        return null;
    }

    public Collection<Binding> getLocalSlots() {
        ArrayList<Binding> result = new ArrayList<Binding>();
        for (Binding b : this.defs.values()) {
            if (!GlobalOptimizer.isSlot(b)) continue;
            result.add(b);
        }
        return result;
    }

    public boolean isLocalBinding(Name n) {
        Binding b = this.defs.get(n);
        return b != null;
    }

    public boolean hasProtectedNs() {
        return (this.flags & 8) != 0;
    }

    boolean isMachineCompatible(Type t) {
        boolean result = this.equals(t);
        result |= this.equals(BuiltinDomain.instance().NULL) && !t.isMachineType();
        result |= t.equals(BuiltinDomain.instance().NULL) && !this.isMachineType();
        return result |= !this.isMachineType() && !t.isMachineType() && !this.equals(BuiltinDomain.instance().ANY) && !t.equals(BuiltinDomain.instance().ANY);
    }

    private boolean isMachineType() {
        return this.equals(BuiltinDomain.instance().OBJECT) || this.equals(BuiltinDomain.instance().VOID) || this.equals(BuiltinDomain.instance().INT) || this.equals(BuiltinDomain.instance().UINT) || this.equals(BuiltinDomain.instance().BOOLEAN) || this.equals(BuiltinDomain.instance().ARRAY) || this.equals(BuiltinDomain.instance().NUMBER);
    }

    public boolean isAtom() {
        return this.atom;
    }

    public Name getName() {
        return this.name;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public boolean extendsOrIsBase(Type c) {
        return this == c || this.extendsBase(c);
    }

    public boolean extendsBase(Type c) {
        Type t = this.base;
        while (t != null) {
            if (t == c) {
                return true;
            }
            t = t.base;
        }
        return false;
    }

    public boolean implementsInterface(Type i) {
        for (Type x : this.interfaces) {
            if (x != i) continue;
            return true;
        }
        return false;
    }

    public boolean isDerivedFrom(Type x) {
        return this.extendsBase(x) || this.implementsInterface(x);
    }

    public boolean isParameterizedTypeInstance() {
        return this.m_params != null;
    }

    public Type parameterizedType() {
        assert (this.isParameterizedTypeInstance());
        return this.base;
    }

    public Type[] typeParameters() {
        assert (this.isParameterizedTypeInstance());
        return this.m_params;
    }

    public boolean resolved() {
        return this.m_resolved;
    }

    public void markResolved() {
        this.m_resolved = true;
    }

    public String toString() {
        return this.name.format();
    }

    public static class StringValueIsName
    extends Type {
        StringValueIsName(Name name, Type base) {
            super(name, base);
        }

        public String toString() {
            return this.name.toString();
        }
    }
}

