/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.Name;
import adobe.abc.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Symtab<E> {
    private HashMap<String, ArrayList<Pair<Name, E>>> m_nameValueMap = new HashMap();
    private ArrayList<E> m_valueList = new ArrayList();

    private Pair<Name, E> getEntry(Name n) {
        List namelist = this.m_nameValueMap.get(n.name);
        if (namelist != null) {
            for (Pair p : namelist) {
                if (!n.match((Name)p.fst)) continue;
                return p;
            }
        }
        return null;
    }

    E get(Name n) {
        Pair<Name, E> entry = this.getEntry(n);
        return entry != null ? (E)entry.snd : null;
    }

    Name getName(Name n) {
        Pair<Name, E> entry = this.getEntry(n);
        return entry != null ? (Name)entry.fst : null;
    }

    boolean contains(Name n) {
        return n != null && this.get(n) != null;
    }

    void put(Name n, E e) {
        n = n.stripVersion();
        assert (n.nsset.length == 1);
        ArrayList<Pair<Name, Pair<Name, Object>>> namelist = this.m_nameValueMap.get(n.name);
        if (namelist == null) {
            namelist = new ArrayList();
            this.m_nameValueMap.put(n.name, namelist);
        }
        namelist.add(new Pair<Name, E>(n, e));
        this.m_valueList.add(e);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('[');
        for (Map.Entry<String, ArrayList<Pair<Name, E>>> namelist : this.m_nameValueMap.entrySet()) {
            if (namelist.getValue() == null) continue;
            for (Pair<Name, E> p : namelist.getValue()) {
                b.append(p.fst).append('=').append(p.snd);
                b.append(", ");
            }
        }
        b.append(']');
        return b.toString();
    }

    public Collection<E> values() {
        return this.m_valueList;
    }

    int size() {
        return this.m_valueList.size();
    }
}

