/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.GlobalOptimizer;
import adobe.abc.Namespace;
import adobe.abc.Nsset;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Name
implements Comparable<Name> {
    public static final Namespace PUBLIC = new Namespace("");
    public static final Namespace PKG_PUBLIC = new Namespace(22, "");
    public static final Namespace AS3 = new Namespace("http://adobe.com/AS3/2006/builtin");
    public static final Name ANY = new Name(ANY_helper.inst);
    final int kind;
    final Nsset nsset;
    final String name;
    private final Name type_param;
    private final Name parameterized_type;

    Name(int kind) {
        this(kind, GlobalOptimizer.uniqueNs(), GlobalOptimizer.unique());
        assert (kind != Integer.MAX_VALUE);
    }

    Name(Namespace ns, String name) {
        this(7, ns, name);
    }

    public Name(int kind, Namespace ns, String name) {
        this(kind, name, new Nsset(new Namespace[]{ns}), null, null);
        assert (kind != Integer.MAX_VALUE);
    }

    Name(int kind, String name, Nsset nsset) {
        this(kind, name, nsset, null, null);
        assert (kind != Integer.MAX_VALUE);
    }

    Name(Name parameterized_type_name, Name type_param_name) {
        this(29, parameterized_type_name.name, parameterized_type_name.nsset, parameterized_type_name, type_param_name);
    }

    private Name(int kind, String name, Nsset nsset, Name parameterized_type_name, Name type_param_name) {
        assert (nsset != null);
        this.kind = kind;
        this.nsset = nsset;
        this.name = name;
        this.type_param = type_param_name;
        this.parameterized_type = parameterized_type_name;
    }

    public Name(String name) {
        this(7, PUBLIC, name);
    }

    private Name(ANY_helper any) {
        this(Integer.MAX_VALUE, "*", new Nsset(new Namespace[]{PUBLIC}), null, null);
    }

    public Namespace nsset(int i) {
        return this.nsset.nsset[i];
    }

    public String toString() {
        return this.name != null ? this.name : "*";
    }

    public String format() {
        if (this.nsset.length == 1) {
            String typeParamStr = this.type_param != null ? ".<" + this.type_param.format() + ">" : "";
            String nStr = this.name != null ? this.name : "*";
            return this.nsset(0) + "::" + nStr + typeParamStr;
        }
        ArrayList<Namespace> list = new ArrayList<Namespace>();
        for (Namespace n : this.nsset) {
            list.add(n);
        }
        String typeParamStr = this.type_param != null ? ".<" + this.type_param.format() + ">" : "";
        String nStr = this.name != null ? this.name : "*";
        return list + "::" + nStr + typeParamStr;
    }

    public Name append(String s) {
        String newName = this.name != null ? this.name + s : s;
        return new Name(this.kind, newName, this.nsset, this.parameterized_type, this.type_param);
    }

    private int hc(Object o) {
        return o != null ? o.hashCode() : 0;
    }

    public int hashCode() {
        return this.kind ^ this.hc(this.nsset) ^ this.hc(this.name) ^ this.hc(this.type_param);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Name)) {
            return false;
        }
        Name o = (Name)other;
        return this.kind == o.kind && this.name != null == (o.name != null) && (this.name == o.name || this.name.equals(o.name)) && this.nsset.equals(o.nsset) && this.equals(this.type_param, o.type_param);
    }

    private boolean equals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    @Override
    public int compareTo(Name other) {
        int d = this.kind - other.kind;
        if (d != 0) {
            return d;
        }
        if (this.name != null && other.name != null) {
            d = this.name.compareTo(other.name);
        } else if (this.name != null) {
            d = 1;
        } else if (other.name != null) {
            d = -1;
        }
        if (d != 0) {
            return d;
        }
        d = Nsset.compareTo(this.nsset, other.nsset);
        if (d != 0) {
            return d;
        }
        d = this.type_param != null && other.type_param != null ? this.type_param.compareTo(other.type_param) : (this.type_param != null ? 1 : (other.type_param != null ? -1 : 0));
        return d;
    }

    public boolean isAttr() {
        return this.kind == 14 || this.kind == 13 || this.kind == 16 || this.kind == 18 || this.kind == 28;
    }

    private int attr() {
        return this.isAttr() ? 1 : 0;
    }

    public boolean isQname() {
        return this.kind == 7 || this.kind == 13 || this.kind == 15 || this.kind == 16 || this.kind == 17 || this.kind == 18;
    }

    public boolean isParameterizedTypeName() {
        assert (this.type_param != null == (this.kind == 29));
        return this.type_param != null;
    }

    public Name getParameterizedTypeName() {
        assert (this.isParameterizedTypeName());
        return this.parameterized_type;
    }

    public Name getTypeParamName() {
        assert (this.isParameterizedTypeName());
        return this.type_param;
    }

    public boolean runtimeName() {
        return this.kind == 17 || this.kind == 18 || this.kind == 27 || this.kind == 28;
    }

    public boolean runtimeNamespace() {
        return this.kind == 15 || this.kind == 16 || this.kind == 17 || this.kind == 18;
    }

    private boolean isStaticName() {
        return this.kind == 7 || this.kind == 9 || this.kind == 13 || this.kind == 14 || this.isParameterizedTypeName() && (this.type_param.isStaticName() || this.type_param == ANY) && this.parameterized_type.isStaticName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean match(Name b) {
        assert (b.isStaticName());
        assert (b.nsset.length == 1);
        if (this == b) {
            return true;
        }
        if (!this.isStaticName()) {
            return false;
        }
        if (this.attr() - b.attr() != 0) {
            return false;
        }
        if (this.name != null && b.name != null) {
            if (this.name.compareTo(b.name) != 0) {
                return false;
            }
        } else {
            if (this.name != null) {
                return false;
            }
            if (b.name != null) {
                return false;
            }
        }
        if (this.type_param != null) {
            if (b.type_param == null) return false;
            if (this.type_param.compareTo(b.type_param) == 0) return this.nsset.contains(b.nsset(0));
            return false;
        }
        if (b.type_param == null) return this.nsset.contains(b.nsset(0));
        return false;
    }

    public boolean containsPublic() {
        return this.nsset.containsPublic();
    }

    public Name stripVersion() {
        if (!this.isVersioned()) {
            return this;
        }
        Namespace ns = this.nsset(0);
        String uri = ns.uri;
        ns = new Namespace(ns.kind, uri.substring(0, uri.length() - 1));
        return new Name(ns, this.name);
    }

    public boolean isVersioned() {
        Namespace ns = this.nsset(0);
        String uri = ns.uri;
        if (uri.length() < 1) {
            return false;
        }
        char lastc = uri.charAt(uri.length() - 1);
        return lastc >= '\ue000' && lastc <= '\uf8ff';
    }

    private static final class ANY_helper {
        public static final int flags = Integer.MAX_VALUE;
        public static final ANY_helper inst = new ANY_helper();

        private ANY_helper() {
        }
    }
}

