/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.Algorithms;
import adobe.abc.Binding;
import adobe.abc.Block;
import adobe.abc.BuiltinDomain;
import adobe.abc.Domain;
import adobe.abc.Edge;
import adobe.abc.Expr;
import adobe.abc.GlobalOptimizer;
import adobe.abc.Handler;
import adobe.abc.LLVMStubFunctions;
import adobe.abc.LLVMStubTypes;
import adobe.abc.LLVMTamarinSlotLayout;
import adobe.abc.LLVMTamarinSlotLayoutCache;
import adobe.abc.LLVMTypeExtractor;
import adobe.abc.Method;
import adobe.abc.Name;
import adobe.abc.Namespace;
import adobe.abc.OptimizerConstants;
import adobe.abc.Pair;
import adobe.abc.TamarinSlotLayout;
import adobe.abc.Type;
import adobe.abc.Typeref;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import llvm.APFloat;
import llvm.APInt;
import llvm.AllocaInst;
import llvm.Argument;
import llvm.Argument_vector;
import llvm.ArrayType;
import llvm.BitCastInst;
import llvm.BranchInst;
import llvm.CallInst;
import llvm.CmpInst;
import llvm.CompositeType;
import llvm.Constant;
import llvm.ConstantArray;
import llvm.ConstantExpr;
import llvm.ConstantFP;
import llvm.ConstantInt;
import llvm.ConstantPointerNull;
import llvm.ConstantStruct;
import llvm.Constant_vector;
import llvm.DerivedType;
import llvm.FunctionType;
import llvm.Function_vector;
import llvm.GetElementPtrInst;
import llvm.GlobalValue;
import llvm.GlobalVariable;
import llvm.GlobalVariable_vector;
import llvm.ICmpInst;
import llvm.Instruction;
import llvm.InvokeInst;
import llvm.JNIIRBuilder;
import llvm.JNIStringRef;
import llvm.LLVM;
import llvm.LLVMContext;
import llvm.LoadInst;
import llvm.MemoryBuffer;
import llvm.Module;
import llvm.PHINode;
import llvm.PointerType;
import llvm.PtrToIntInst;
import llvm.ReturnInst;
import llvm.SequentialType;
import llvm.StoreInst;
import llvm.StringRef;
import llvm.StructType;
import llvm.SwitchInst;
import llvm.TerminatorInst;
import llvm.TruncInst;
import llvm.Twine;
import llvm.Type_vector;
import llvm.UndefValue;
import llvm.UnreachableInst;
import llvm.UnwindInst;
import llvm.User;
import llvm.Value;
import llvm.Value_vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LLVMEmitter {
    private static final boolean useJNILLVM = true;
    private boolean runtimeDebugging = false;
    private boolean debugMessages = false;
    private boolean debugBuiltins = false;
    private LLVMContext m_ctx = new LLVMContext();
    private boolean useARMCallingConvention = false;
    private static final boolean verifyBitcode = false;
    private final Map<GlobalOptimizer.InputAbc, Map<Method, Map<Expr, Typeref>>> m_methodTypeInfo = new HashMap<GlobalOptimizer.InputAbc, Map<Method, Map<Expr, Typeref>>>();
    private final Map<GlobalOptimizer.InputAbc, Map<Method, Algorithms.EdgeMap<Expr>>> m_methodUseInfo = new HashMap<GlobalOptimizer.InputAbc, Map<Method, Algorithms.EdgeMap<Expr>>>();
    private final Map<Type, Constant> m_TypeIds = new HashMap<Type, Constant>();
    private final Set<Type> m_visitedTypes = new HashSet<Type>();
    private final Map<Expr, Integer> m_scopeDepths = new HashMap<Expr, Integer>();
    private final Map<Method, Function> m_abcMethodToLLVMFunction = new HashMap<Method, Function>();
    private LLVMTamarinSlotLayoutCache m_slotLayoutCache;
    private final Map<String, Pair<PointerType, llvm.Type>> m_glueClassNameToLLVMTypes;
    private Module m_module;
    private File m_out;
    private final Set<String> m_directCalls;
    private final Map<Method, String> m_referencedMethods = new HashMap<Method, String>();
    private boolean m_debugger = false;

    private static void usage() {
        System.err.println("usage: LLVMEmitter [-verbose] [-quiet] runtimeBitCode builtin.abc [imports] -- appRootABC [appChildAbc ...]");
        System.exit(-1);
    }

    public static void main(String[] args) throws IOException {
        GlobalOptimizer go = new GlobalOptimizer();
        go.legacy_verifier = true;
        File output = null;
        go.m_llvmEmitter = new LLVMEmitter();
        ArrayList<GlobalOptimizer.InputAbc> builtInABCs = new ArrayList<GlobalOptimizer.InputAbc>();
        ArrayList<GlobalOptimizer.InputAbc> appABCs = new ArrayList<GlobalOptimizer.InputAbc>();
        Domain d = BuiltinDomain.instance();
        BuiltinDomain.instance().enabledFailedLookupExceptions();
        ArrayList<Integer> lengths = new ArrayList<Integer>();
        String filename = null;
        File runtimeBitCode = null;
        ArrayList<GlobalOptimizer.InputAbc> a = builtInABCs;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-verbose")) {
                go.verbose_mode = true;
                continue;
            }
            if (args[i].equals("-arm")) {
                go.m_llvmEmitter.useARMCallingConvention = true;
                continue;
            }
            if (args[i].equals("-debugger")) {
                go.m_llvmEmitter.m_debugger = true;
                continue;
            }
            if (args[i].equals("-debug")) {
                go.m_llvmEmitter.debugMessages = true;
                continue;
            }
            if (args[i].equals("-debugruntime")) {
                go.m_llvmEmitter.runtimeDebugging = true;
                continue;
            }
            if (args[i].equals("-debugbuiltins")) {
                go.m_llvmEmitter.debugBuiltins = true;
                continue;
            }
            if (args[i].equals("-quiet")) {
                go.verbose_mode = false;
                continue;
            }
            if (args[i].equals("-output")) {
                output = new File(args[++i]);
                continue;
            }
            if (runtimeBitCode == null) {
                runtimeBitCode = new File(args[i]);
                continue;
            }
            if (args[i].equals("--")) {
                a = appABCs;
                d = new Domain(d, true);
                continue;
            }
            filename = args[i];
            GlobalOptimizer globalOptimizer = go;
            globalOptimizer.getClass();
            GlobalOptimizer.InputAbc ia = globalOptimizer.new GlobalOptimizer.InputAbc(d);
            lengths.add(ia.readAbc(filename));
            a.add(ia);
            ia.src_filename = filename;
        }
        if (builtInABCs.size() < 1) {
            System.err.println("No builtin abcs specified");
            LLVMEmitter.usage();
        }
        if (appABCs.size() < 1) {
            System.err.println("No application abcs specified");
            LLVMEmitter.usage();
        }
        if (runtimeBitCode == null || !runtimeBitCode.canRead()) {
            System.err.println("Can't access runtime bitcode");
            LLVMEmitter.usage();
        }
        for (GlobalOptimizer.InputAbc iabc : builtInABCs) {
            iabc.resolveTypes();
        }
        for (GlobalOptimizer.InputAbc iabc : appABCs) {
            iabc.resolveTypes();
        }
        File llvmFile = new File(((GlobalOptimizer.InputAbc)appABCs.get(0)).scriptName() + ".bc");
        go.m_llvmEmitter.setBitcodeFiles(runtimeBitCode, llvmFile);
        HashMap<GlobalOptimizer.InputAbc, Pair<GlobalOptimizer.Abc, byte[]>> iabcToAbc = new HashMap<GlobalOptimizer.InputAbc, Pair<GlobalOptimizer.Abc, byte[]>>();
        LLVMEmitter.optimizeABCs(go, builtInABCs, iabcToAbc, true);
        LLVMEmitter.optimizeABCs(go, appABCs, iabcToAbc, false);
        go.m_llvmEmitter.processABCs(builtInABCs, appABCs, iabcToAbc, d, output);
        go.m_llvmEmitter = null;
    }

    public void processABCs(List<GlobalOptimizer.InputAbc> builtInABCs, List<GlobalOptimizer.InputAbc> appABCs, Map<GlobalOptimizer.InputAbc, Pair<GlobalOptimizer.Abc, byte[]>> iabcToAbc, Domain d, File output) throws IOException {
        boolean cacheddebugMessages = this.debugMessages;
        if (!this.debugBuiltins) {
            this.debugMessages = false;
        }
        this.makeTypeIdsForParameterizedTypesInstances(BuiltinDomain.instance().parameterizedTypesInstances());
        for (GlobalOptimizer.InputAbc builtinABC : builtInABCs) {
            Pair<GlobalOptimizer.Abc, byte[]> abc = iabcToAbc.get(builtinABC);
            String builtinScriptName = builtinABC.scriptBaseName();
            String builtinABCInfoGlobalName = builtinScriptName.toLowerCase() + "_aotInfo";
            String glueClassTypesGlobal = "aotABCTypes_" + builtinScriptName.toLowerCase();
            this.m_glueClassNameToLLVMTypes.putAll(LLVMTypeExtractor.extractToMap(this.m_module, glueClassTypesGlobal));
            Constant abcInfoConstant = this.emit(builtinABC, (GlobalOptimizer.Abc)abc.fst, (byte[])abc.snd, builtinScriptName);
            this.m_module.setGlobal(true, abcInfoConstant, builtinABCInfoGlobalName, false);
        }
        if (!this.debugBuiltins) {
            this.debugMessages = cacheddebugMessages;
        }
        ArrayList<Constant> abcInfos = new ArrayList<Constant>();
        for (GlobalOptimizer.InputAbc appABC : appABCs) {
            Pair<GlobalOptimizer.Abc, byte[]> abc = iabcToAbc.get(appABC);
            Constant abcInfoConstant = this.emit(appABC, (GlobalOptimizer.Abc)abc.fst, (byte[])abc.snd, appABC.scriptBaseName());
            abcInfos.add(abcInfoConstant);
        }
        Constant abcInfosConstant = this.m_module.getConstantArray(abcInfos);
        this.m_module.setGlobal(true, abcInfosConstant, "aotInfos", true);
        this.m_module.setGlobal(true, this.constantInt(32L, abcInfos.size()), "nAOTInfos", false);
        this.printMsg("Writing: " + this.m_out.getAbsolutePath());
        this.m_module.write(output == null ? this.m_out : output);
        this.printMsg("Done Writing: " + this.m_out.getAbsolutePath());
    }

    private void printMsg(String s) {
        if (this.debugMessages) {
            System.out.println(s);
        }
    }

    private void printErr(String s) {
        if (this.debugMessages) {
            System.err.println(s);
        }
    }

    private static Comparator<Type> makeTypeComparator(Type[] items) {
        final HashMap<Type, Integer> result = new HashMap<Type, Integer>();
        int id = 0;
        for (Type t : items) {
            result.put(t, id);
            ++id;
        }
        return new Comparator<Type>(){

            @Override
            public int compare(Type t0, Type t1) {
                return (Integer)result.get(t0) - (Integer)result.get(t1);
            }
        };
    }

    private static <T> Comparator<T> makePreservingComparator(T[] arr) {
        final HashMap<T, Integer> idMap = new HashMap<T, Integer>();
        for (int i = 1; i < arr.length; ++i) {
            idMap.put(arr[i], i);
        }
        return new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                Integer idA = (Integer)idMap.get(a);
                if (idA == null) {
                    return 1;
                }
                Integer idB = (Integer)idMap.get(b);
                if (idB == null) {
                    return -1;
                }
                return idA - idB;
            }
        };
    }

    private static void optimizeABCs(GlobalOptimizer go, Iterable<GlobalOptimizer.InputAbc> abcs, Map<GlobalOptimizer.InputAbc, Pair<GlobalOptimizer.Abc, byte[]>> iabcToAbc, boolean preserveIds) throws IOException {
        for (GlobalOptimizer.InputAbc iabc : abcs) {
            GlobalOptimizer.Abc abc = null;
            if (preserveIds) {
                int i;
                Comparator<String> stringPoolComparator = LLVMEmitter.makePreservingComparator(iabc.strings);
                Comparator<Name> namePoolComparator = LLVMEmitter.makePreservingComparator(iabc.names);
                Comparator<Method> compareMethods = new Comparator<Method>(){

                    @Override
                    public int compare(Method m0, Method m1) {
                        return m0.id - m1.id;
                    }
                };
                Comparator<Type> compareScripts = LLVMEmitter.makeTypeComparator(iabc.scripts);
                Comparator<Type> compareClasses = LLVMEmitter.makeTypeComparator(iabc.classes);
                GlobalOptimizer globalOptimizer = go;
                globalOptimizer.getClass();
                abc = globalOptimizer.new GlobalOptimizer.Abc(stringPoolComparator, namePoolComparator, compareMethods, compareScripts, compareClasses);
                for (i = 1; i < iabc.strings.length; ++i) {
                    if (iabc.strings[i] == null) continue;
                    abc.stringPool.add(iabc.strings[i]);
                }
                for (i = 1; i < iabc.names.length; ++i) {
                    if (iabc.names[i] == null) continue;
                    abc.addName(iabc.names[i]);
                }
            } else {
                abc = go.new GlobalOptimizer.Abc();
            }
            go.optimize(iabc, true);
            byte[] abcBytes = go.emit(abc, iabc, null, true);
            iabcToAbc.put(iabc, new Pair<GlobalOptimizer.Abc, byte[]>(abc, abcBytes));
        }
    }

    private static String jniMapOSName(String name) {
        if (name.equals("Mac OS X")) {
            return "Darwin";
        }
        return "win32";
    }

    private static void loadJNI() {
        block6: {
            URL urlToClass = LLVMEmitter.class.getProtectionDomain().getCodeSource().getLocation();
            try {
                File dirToSearch;
                File classLocation = new File(urlToClass.toURI());
                String osName = LLVMEmitter.jniMapOSName(System.getProperty("os.name"));
                File parentDir = classLocation.getParentFile();
                File[] dirsToSearch = new File[]{new File(classLocation, osName), new File(parentDir, osName), classLocation, parentDir};
                String errorStr = "Unable to find llvm JNI lib in:\n";
                File shLibFile = null;
                String libBase = "llvm";
                String libraryName = System.mapLibraryName(libBase);
                File[] arr$ = dirsToSearch;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && !(shLibFile = new File(dirToSearch = arr$[i$], libraryName)).exists(); ++i$) {
                    errorStr = errorStr + dirToSearch.getAbsolutePath() + "\n";
                    shLibFile = null;
                }
                if (shLibFile == null) {
                    try {
                        System.loadLibrary(libBase);
                        break block6;
                    }
                    catch (UnsatisfiedLinkError e) {
                        throw new Error(errorStr);
                    }
                }
                System.load(shLibFile.getAbsolutePath());
            }
            catch (URISyntaxException e) {
                throw new Error("Unable to get URI:" + urlToClass.toString());
            }
        }
    }

    private static <T> T[] arr(T ... t) {
        return t;
    }

    private static <T> T[] concat(T[] ... arrays) {
        ArrayList<T> resultList = new ArrayList<T>();
        T[][] arr$ = arrays;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            T[] a;
            for (T t : a = arr$[i$]) {
                resultList.add(t);
            }
        }
        Object[] emptyArray = (Object[])Array.newInstance(arrays[0].getClass().getComponentType(), 0);
        return resultList.toArray(emptyArray);
    }

    private FunctionType getMethodFunctionType(Method m) {
        ArrayList<llvm.Type> paramLLVMTypes = new ArrayList<llvm.Type>();
        paramLLVMTypes.add(this.m_module.types.MethodEnvPtrTy);
        for (Typeref p : m.params) {
            paramLLVMTypes.add(this.m_module.llvmType(p.getType()));
        }
        if (m.needsRest() || m.needsArguments()) {
            paramLLVMTypes.add(this.m_module.types.ArrayObjectPtrTy);
        }
        llvm.Type resultType = this.m_module.llvmType(m.getReturnType().getType());
        llvm.Type[] paramTypes = paramLLVMTypes.toArray(new llvm.Type[0]);
        return Module.getFunctionType(resultType, paramTypes, false);
    }

    private void setTypeId(Type t, Constant typeId) {
        assert (this.m_TypeIds.get(t) == null);
        this.m_TypeIds.put(t, typeId);
    }

    private Constant getTypeId(Type t) {
        Constant result;
        Constant existingId = this.m_TypeIds.get(t);
        if (existingId != null) {
            llvm.Type existingIdType = existingId.getType();
            assert (LLVMStubTypes.compareTypes(existingIdType, this.m_module.types.TraitsIdTy));
            return existingId;
        }
        if (t != BuiltinDomain.instance().ANY()) {
            String traitsGlobalVarName = t.name == null ? "" : "abcTraits_" + t.name;
            result = this.m_module.createGlobal(traitsGlobalVarName, false, ConstantPointerNull.get(this.m_module.types.TraitsPtrTy));
        } else {
            result = ConstantPointerNull.get(this.m_module.types.TraitsIdTy);
        }
        this.setTypeId(t, result);
        llvm.Type resultType = ((Value)result).getType();
        assert (LLVMStubTypes.compareTypes(resultType, this.m_module.types.TraitsIdTy));
        return result;
    }

    private void referenceMethods(Type t) {
        for (Binding b : t.defs.values()) {
            if (!b.isGetter() && !b.isSetter() && !b.isMethod()) continue;
            this.referenceMethod(b.method, t.name.toString());
        }
    }

    private void referenceMethod(Method m, String reference) {
        if (this.m_referencedMethods.get(m) != null) {
            String errorStr = "Method " + String.valueOf(m.id) + " is referenced more than once.";
            throw new Error(errorStr);
        }
        this.m_referencedMethods.put(m, reference);
    }

    final void recordScopeDepth(Expr e, int depth) {
        assert (e.op == 48 || e.op == 28 || e.op == 29);
        this.m_scopeDepths.put(e, depth);
    }

    private final int getScopeDepth(Expr e) {
        this.printErr("getScopeDepth: " + e.toString());
        assert (e.op == 48 || e.op == 28 || e.op == 29);
        assert (this.m_scopeDepths.containsKey(e));
        return this.m_scopeDepths.get(e);
    }

    private final Method createEmptyInitMethod(GlobalOptimizer.InputAbc abc, Type thisType) {
        Method initMethod = new Method(-1, abc);
        initMethod.hasExceptions = false;
        initMethod.params = new Typeref[]{thisType.ref.nonnull()};
        initMethod.values = new Object[]{null};
        initMethod.optional_count = 0;
        initMethod.returns = BuiltinDomain.instance().VOID.ref;
        initMethod.debugName = thisType.name.toString() + "_generated_init";
        initMethod.name = new Name(initMethod.debugName);
        initMethod.paramNames = null;
        initMethod.flags = 0;
        initMethod.cx = thisType;
        initMethod.kind = "generated init";
        initMethod.max_stack = 2;
        initMethod.max_scope = 1;
        initMethod.local_count = 1;
        initMethod.code_len = 0;
        initMethod.entry = new Edge(initMethod, null, 0);
        initMethod.entry.to = new Block(initMethod);
        Expr returnExpr = new Expr(initMethod, 71);
        returnExpr.succ = OptimizerConstants.noedges;
        initMethod.entry.to.add(returnExpr);
        return initMethod;
    }

    final void recordType(GlobalOptimizer.InputAbc abc, Type t) {
        assert (!this.m_visitedTypes.contains(t));
        this.m_visitedTypes.add(t);
        this.genInitMethod(abc, t);
    }

    final void recordMethod(Method m) {
        if (m.needActivation()) {
            assert (m.activation.getType().init == null);
            this.genInitMethod(m.abc, m.activation.getType());
        }
    }

    private void genInitMethod(GlobalOptimizer.InputAbc abc, Type t) {
        Method init;
        Method method = init = t.init != null ? t.init : this.createEmptyInitMethod(abc, t);
        assert (init != null);
        if (t.isInterface()) {
            assert (t.getLocalSlots().size() == 0);
            return;
        }
        assert (init.entry != null);
        assert (init.entry.to != null);
        Block oldInitEntryBlock = init.entry.to;
        assert (oldInitEntryBlock != null);
        Block newInitEntryBlock = new Block(init);
        Expr thisArg = new Expr(init, 256, -1, 0);
        newInitEntryBlock.add(thisArg);
        Collection<Binding> slots = t.getLocalSlots();
        for (Binding s : slots) {
            Object defaultValue = s.value();
            int opCode = 0;
            if (defaultValue instanceof Integer) {
                opCode = 45;
                Integer defValueInt = (Integer)defaultValue;
                if (defValueInt == 0 && s.type.getType() == BuiltinDomain.instance().INT) {
                    defaultValue = null;
                    opCode = 0;
                }
            } else if (defaultValue instanceof Long) {
                opCode = 46;
                Long defValueLong = (Long)defaultValue;
                if (defValueLong == 0L && s.type.getType() == BuiltinDomain.instance().UINT) {
                    defaultValue = null;
                    opCode = 0;
                }
            } else if (defaultValue instanceof Double) {
                opCode = 47;
                Double defValueDouble = (Double)defaultValue;
                if (Double.doubleToLongBits(defValueDouble) == 0L && s.type.getType() == BuiltinDomain.instance().NUMBER) {
                    defaultValue = null;
                    opCode = 0;
                }
            } else if (defaultValue instanceof String) {
                opCode = 44;
            } else if (defaultValue instanceof Namespace) {
                opCode = 49;
            } else if (defaultValue == Boolean.TRUE) {
                opCode = 38;
            } else if (defaultValue == Boolean.FALSE) {
                opCode = 39;
                Boolean defValueBoolean = (Boolean)defaultValue;
                if (!defValueBoolean.booleanValue() && s.type.getType() == BuiltinDomain.instance().BOOLEAN) {
                    defaultValue = null;
                    opCode = 0;
                }
            } else if (defaultValue == OptimizerConstants.UNDEFINED) {
                opCode = 33;
                defaultValue = null;
            } else if (defaultValue == BuiltinDomain.instance().NULL && s.type.getType().isAtom()) {
                opCode = 32;
            }
            if (opCode == 0) continue;
            Expr defaultValueExpr = new Expr(init, opCode);
            defaultValueExpr.value = defaultValue;
            newInitEntryBlock.add(defaultValueExpr);
            assert (s.slot > 0);
            Expr setSlotExpr = new Expr(init, 109, -1, s.slot);
            setSlotExpr.args = new Expr[]{thisArg, defaultValueExpr};
            newInitEntryBlock.add(setSlotExpr);
            s.setValue(s.type.t.defaultValue);
            assert (!s.defaultValueChanged());
            init.entry.to = newInitEntryBlock;
        }
        if (init.entry.to == newInitEntryBlock) {
            for (Expr e : oldInitEntryBlock) {
                newInitEntryBlock.add(e);
            }
            for (Edge e : oldInitEntryBlock.succ()) {
                assert (e.from == oldInitEntryBlock);
                e.from = newInitEntryBlock;
            }
            for (Edge e : oldInitEntryBlock.xsucc) {
                assert (e.from == oldInitEntryBlock);
                e.from = newInitEntryBlock;
            }
            t.init = init;
        }
    }

    final void recordMethodTypes(Method m, Map<Expr, Typeref> types) {
        assert (!this.m_methodTypeInfo.containsKey(m.abc) || !this.m_methodTypeInfo.get(m.abc).containsKey(m));
        Map<Method, Map<Expr, Typeref>> typesForAbc = this.m_methodTypeInfo.get(m.abc);
        if (typesForAbc == null) {
            typesForAbc = new HashMap<Method, Map<Expr, Typeref>>();
            this.m_methodTypeInfo.put(m.abc, typesForAbc);
        }
        typesForAbc.put(m, types);
    }

    final void recordMethodUses(Method m, Algorithms.EdgeMap<Expr> uses) {
        assert (!this.m_methodUseInfo.containsKey(m.abc) || !this.m_methodUseInfo.get(m.abc).containsKey(m));
        Map<Method, Algorithms.EdgeMap<Expr>> usesForAbc = this.m_methodUseInfo.get(m.abc);
        if (usesForAbc == null) {
            usesForAbc = new HashMap<Method, Algorithms.EdgeMap<Expr>>();
            this.m_methodUseInfo.put(m.abc, usesForAbc);
        }
        usesForAbc.put(m, uses);
    }

    static Map<String, Field> publicFieldsMap(Class<?> c) {
        HashMap<String, Field> fields = new HashMap<String, Field>();
        for (Field f : LLVMStubTypes.class.getDeclaredFields()) {
            if (!Modifier.isPublic(f.getModifiers())) continue;
            fields.put(f.getName(), f);
        }
        return fields;
    }

    private LLVMEmitter() {
        this.m_glueClassNameToLLVMTypes = new HashMap<String, Pair<PointerType, llvm.Type>>();
        this.m_directCalls = new HashSet<String>();
        this.addMathFunction(this.m_directCalls);
        this.addStringFunction(this.m_directCalls);
    }

    private void addMathFunction(Set<String> functions) {
        String domain = "Math_";
        functions.add("Math_random");
        functions.add("Math_abs");
        functions.add("Math_acos");
        functions.add("Math_asin");
        functions.add("Math_atan");
        functions.add("Math_ceil");
        functions.add("Math_cos");
        functions.add("Math_exp");
        functions.add("Math_floor");
        functions.add("Math_log");
        functions.add("Math_round");
        functions.add("Math_sin");
        functions.add("Math_sqrt");
        functions.add("Math_tan");
        functions.add("Math_pow");
        functions.add("Math_atan2");
    }

    private void addStringFunction(Set<String> functions) {
        String domain = "String_";
        functions.add("String_toLowerCase");
        functions.add("String_toUpperCase");
        functions.add("String_toLocaleLowerCase");
        functions.add("String_toLocaleUpperCase");
        functions.add("String_charAt");
        functions.add("String_charCodeAt");
        functions.add("String_match");
        functions.add("String_search");
        functions.add("String_indexOf");
        functions.add("String_lastIndexOf");
        functions.add("String_replace");
        functions.add("String_slice");
        functions.add("String_split");
        functions.add("String_substring");
        functions.add("String_substr");
        functions.add("String_concat");
        functions.add("String_fromCharCode");
        functions.add("String_localeCompare");
    }

    private void setBitcodeFiles(File runtimeBCFile, File bcFileToEmit) throws IOException {
        this.m_out = bcFileToEmit;
        this.m_module = Module.load(this.m_ctx, runtimeBCFile, this.useARMCallingConvention);
        this.m_slotLayoutCache = new LLVMTamarinSlotLayoutCache(this.m_module.types);
    }

    private final Type[] sortedScripts(final GlobalOptimizer.Abc abc) {
        Type[] sortedScripts = new Type[abc.scripts.size()];
        sortedScripts = abc.scripts.toArray(sortedScripts);
        Arrays.sort(sortedScripts, new Comparator<Type>(){

            @Override
            public int compare(Type t0, Type t1) {
                return abc.scriptId(t0) - abc.scriptId(t1);
            }
        });
        return sortedScripts;
    }

    private final Constant emit(GlobalOptimizer.InputAbc iabc, final GlobalOptimizer.Abc abc, byte[] abcBytes, String abcScriptName) {
        Constant methodDebugInfoArrayPtr;
        Constant abcBytesConstant = this.m_module.getConstantByteArray(abcBytes);
        GlobalVariable abcBytesGlobal = this.m_module.createGlobal("abcBytes_" + abcScriptName, true, abcBytesConstant);
        abcBytesGlobal.setSection(new JNIStringRef("__DATA, __abc"));
        Constant abcBytesPtr = ConstantExpr.getCast(Instruction.CastOps.BitCast.swigValue(), this.m_module.getGetElementPtrConstantExpression((Constant)abcBytesGlobal, 0, 0), this.m_module.types.charPtrTy);
        ConstantInt abcBytesLengthConstant = this.constantInt(32L, abcBytes.length);
        ScriptArrays scriptArrays = new ScriptArrays(abc, abcScriptName);
        assert (abc.nativeMethodPool.size() == abc.nativeMethodPool.countFrom || abc.nativeMethodPool == abc.nonNativeMethodPool);
        List<Method> methods = abc.nonNativeMethodPool.values();
        TreeSet<Method> sortedMethods = new TreeSet<Method>(new Comparator<Method>(){

            @Override
            public int compare(Method m0, Method m1) {
                return abc.methodId(m0) - abc.methodId(m1);
            }
        });
        ArrayList<Method> initsForActivationTraits = new ArrayList<Method>();
        initsForActivationTraits.ensureCapacity(methods.size());
        for (Method m : methods) {
            sortedMethods.add(m);
            if (!m.needActivation()) continue;
            assert (m.activation != null);
            if (m.activation.getType().init == null) continue;
            initsForActivationTraits.add(m.activation.getType().init);
        }
        MethodArrays methodArrays = new MethodArrays(abc, abcScriptName, sortedMethods);
        this.emitMethods(abc, abcScriptName, sortedMethods);
        this.emitMethods(abc, abcScriptName, initsForActivationTraits);
        ArrayList<Constant> methodValues = new ArrayList<Constant>(methods.size());
        for (Method m : sortedMethods) {
            Constant castedFunction;
            if (!m.isNative() && m.entry != null) {
                Function f = this.m_abcMethodToLLVMFunction.get(m);
                assert (f != null);
                castedFunction = this.m_module.functionToCompiledHandler(f);
            } else {
                castedFunction = Constant.getNullValue(this.m_module.types.CompiledHandlerPtrTy);
            }
            methodValues.add(castedFunction);
        }
        Constant abcMethodsConstant = this.m_module.getConstantArray(methodValues);
        GlobalVariable abcMethodsGlobal = this.m_module.createGlobal("", true, abcMethodsConstant);
        Constant abcMethodsArrayPtr = this.m_module.getGetElementPtrConstantExpression((Constant)abcMethodsGlobal, 0, 0);
        if (this.m_debugger) {
            ArrayList<Constant> methodDebugInfoValues = new ArrayList<Constant>(methods.size());
            for (Method m1 : sortedMethods) {
                Constant linesArrayPtr;
                Constant local_namesArrayPtr;
                int file_name = 0;
                int num_local_names = m1.local_count + m1.max_scope;
                ArrayList<Constant> local_names = new ArrayList<Constant>(num_local_names);
                for (int i = 0; i < num_local_names; ++i) {
                    local_names.add(this.constantInt(32L, 0L));
                }
                ArrayList<Constant> lines = new ArrayList<Constant>();
                if (m1.entry != null) {
                    Algorithms.Deque<Block> blocks = m1.depthFirstCfg();
                    for (Block b : blocks) {
                        for (Expr e : b.exprs) {
                            switch (e.op) {
                                case 241: {
                                    file_name = abc.stringPool.id((String)e.value);
                                    break;
                                }
                                case 240: {
                                    lines.add(this.constantInt(32L, e.imm[0]));
                                    break;
                                }
                                case 239: {
                                    if (e.imm[0] != 1) break;
                                    int n = e.imm[2];
                                    while (local_names.size() <= n) {
                                        local_names.add(this.constantInt(32L, 0L));
                                    }
                                    local_names.set(n, this.constantInt(32L, abc.stringPool.id((String)e.value)));
                                }
                            }
                        }
                    }
                }
                if (local_names.size() != 0) {
                    Constant local_namesConstant = this.m_module.getConstantArray(local_names);
                    GlobalVariable local_namesGlobal = this.m_module.createGlobal("", true, local_namesConstant);
                    local_namesArrayPtr = this.m_module.getGetElementPtrConstantExpression((Constant)local_namesGlobal, 0, 0);
                } else {
                    local_namesArrayPtr = Constant.getNullValue(this.m_module.types.intPtrTy);
                }
                if (lines.size() != 0) {
                    Constant linesConstant = this.m_module.getConstantArray(lines);
                    GlobalVariable linesGlobal = this.m_module.createGlobal("", true, linesConstant);
                    linesArrayPtr = this.m_module.getGetElementPtrConstantExpression((Constant)linesGlobal, 0, 0);
                } else {
                    linesArrayPtr = Constant.getNullValue(this.m_module.types.intPtrTy);
                }
                methodDebugInfoValues.add(Module.getConstantStruct(this.m_module.types.MethodDebugInfoTy, this.constantInt(32L, m1.local_count), this.constantInt(32L, m1.max_scope), this.constantInt(32L, file_name), local_namesArrayPtr, this.constantInt(32L, lines.size()), linesArrayPtr));
            }
            Constant methodDebugInfoConstant = this.m_module.getConstantArray(methodDebugInfoValues);
            GlobalVariable methodDebugInfoGlobal = this.m_module.createGlobal("", true, methodDebugInfoConstant);
            methodDebugInfoArrayPtr = this.m_module.getGetElementPtrConstantExpression((Constant)methodDebugInfoGlobal, 0, 0);
        } else {
            methodDebugInfoArrayPtr = Constant.getNullValue(PointerType.get(this.m_module.types.MethodDebugInfoTy, 0L));
        }
        assert (iabc.sha1.length == 20);
        ArrayList<Constant> sha1Values = new ArrayList<Constant>(20);
        for (byte b : iabc.sha1) {
            sha1Values.add(this.constantInt(8L, b));
        }
        Constant origABCSHA1 = this.m_module.getConstantArray(sha1Values);
        Constant abcInfoStruct = Module.getConstantStruct(this.m_module.types.AOTInfoTy, origABCSHA1, abcBytesPtr, abcBytesLengthConstant, methodDebugInfoArrayPtr, abcMethodsArrayPtr, this.constantInt(32L, sortedMethods.size()), scriptArrays.scriptTraitsArrayPtr, methodArrays.activationTraitsArrayPtr, methodArrays.scriptActivationTraitsInitFunctonsArrayPtr, this.constantInt(32L, methodArrays.nActivationraits));
        return abcInfoStruct;
    }

    private void emitMethods(GlobalOptimizer.Abc abc, String abcScriptName, Collection<Method> sortedMethods) {
        for (Method m : sortedMethods) {
            if (m.isNative() || m.entry == null) continue;
            this.printMsg("emitting method dname:\"" + m.debugName + "\" name:\"" + m.name.toString() + "\"");
            MethodEmitter emitter = new MethodEmitter(abc, m, this.m_methodTypeInfo.get(m.abc).get(m), this.m_methodUseInfo.get(m.abc).get(m), this.m_debugger);
            Function f = emitter.emit();
            assert (this.m_abcMethodToLLVMFunction.get(m) == f);
        }
    }

    final boolean outputMethodBody(Method m) {
        boolean result;
        Map<Method, Map<Expr, Typeref>> methodTypeInfoForAbc = this.m_methodTypeInfo.get(m.abc);
        boolean bl = result = methodTypeInfoForAbc == null || !methodTypeInfoForAbc.containsKey(m);
        assert (!result);
        if (m.needActivation()) {
            return true;
        }
        return result;
    }

    private ConstantInt constantInt(long numBits, long val) {
        return LLVMEmitter.constantInt(this.m_ctx, numBits, val);
    }

    private static ConstantInt constantInt(LLVMContext ctx, long numBits, long val) {
        String sv = String.valueOf(val);
        APInt i = new APInt(numBits, new JNIStringRef(sv), 10);
        ConstantInt result = ConstantInt.get(ctx, i);
        i.delete();
        return result;
    }

    private void makeTypeIdsForParameterizedTypesInstances(Map<Type, Set<Type>> parameterizedTypesInstances) {
        Type[] instancesArray;
        GlobalVariable globalForParameterizedType;
        ArrayList<Pair<GlobalVariable, Type[]>> globalsForParameterizedTypes = new ArrayList<Pair<GlobalVariable, Type[]>>();
        HashMap<GlobalVariable, StructType> globalToStructType = new HashMap<GlobalVariable, StructType>();
        for (Map.Entry<Type, Set<Type>> entry : parameterizedTypesInstances.entrySet()) {
            Type parameterizedType = entry.getKey();
            Set<Type> parameterizedTypeInstances = entry.getValue();
            assert (!parameterizedType.isParameterizedTypeInstance());
            String parameterizedTypeName = parameterizedType.getName().toString();
            String globalArrayNameForParameterizedType = "abc" + parameterizedTypeName + "Instances";
            GlobalVariable globalArrayForParameterizedType = this.m_module.getGlobal(globalArrayNameForParameterizedType, true);
            if (globalArrayForParameterizedType == null) {
                throw new Error("Unable to find global " + globalArrayNameForParameterizedType + ".");
            }
            PointerType globalType = PointerType.dyn_cast(SequentialType.dyn_cast(CompositeType.dyn_cast(DerivedType.dyn_cast(((Value)globalArrayForParameterizedType).getType()))));
            ArrayType globalArrayType = ArrayType.dyn_cast(SequentialType.dyn_cast(CompositeType.dyn_cast(DerivedType.dyn_cast(globalType.getElementType()))));
            StructType parameterizedStructType = StructType.dyn_cast(CompositeType.dyn_cast(DerivedType.dyn_cast(globalArrayType.getElementType())));
            ArrayType newGlobalArrayType = ArrayType.get(parameterizedStructType, BigInteger.valueOf(parameterizedTypeInstances.size()));
            GlobalVariable newGlobalArray = this.m_module.setGlobalType(newGlobalArrayType, false, globalArrayNameForParameterizedType);
            Type[] instancesArray2 = parameterizedTypeInstances.toArray(new Type[0]);
            globalsForParameterizedTypes.add(new Pair<GlobalVariable, Type[]>(newGlobalArray, instancesArray2));
            globalToStructType.put(newGlobalArray, parameterizedStructType);
            String globalArrayLengthNameForParameterizedType = "abcN" + parameterizedTypeName + "Instances";
            this.m_module.setGlobal(true, this.constantInt(32L, instancesArray2.length), globalArrayLengthNameForParameterizedType, false);
        }
        for (Pair pair : globalsForParameterizedTypes) {
            globalForParameterizedType = (GlobalVariable)pair.fst;
            instancesArray = (Type[])pair.snd;
            for (int i = 0; i < instancesArray.length; ++i) {
                Constant traitsId = this.m_module.getGetElementPtrConstantExpression((Constant)globalForParameterizedType, 0, i, 0);
                this.setTypeId(instancesArray[i], traitsId);
                assert (LLVMStubTypes.compareTypes(this.getTypeId(instancesArray[i]).getType(), this.m_module.types.TraitsIdTy));
            }
        }
        for (Pair pair : globalsForParameterizedTypes) {
            globalForParameterizedType = (GlobalVariable)pair.fst;
            instancesArray = (Type[])pair.snd;
            StructType structTypeForParameterizedTypeInstance = (StructType)globalToStructType.get(globalForParameterizedType);
            int nStructMembers = (int)structTypeForParameterizedTypeInstance.getNumElements();
            ArrayList<Constant> structsForParameterizedTypeInstances = new ArrayList<Constant>();
            for (int i = 0; i < instancesArray.length; ++i) {
                Type parameterizedTypeInstance = instancesArray[i];
                if (parameterizedTypeInstance.typeParameters().length != nStructMembers - 1) {
                    throw new Error("Incorrect number of struct members for parameterized type instance!!");
                }
                ArrayList<Constant> valuesForParameterizedTypeInstance = new ArrayList<Constant>();
                valuesForParameterizedTypeInstance.add(Constant.getNullValue(this.m_module.types.TraitsPtrTy));
                for (Type paramType : parameterizedTypeInstance.typeParameters()) {
                    valuesForParameterizedTypeInstance.add(this.getTypeId(paramType));
                }
                assert (valuesForParameterizedTypeInstance.size() == nStructMembers);
                Constant structValueForParameterizedTypeInstance = Module.getConstantStruct(structTypeForParameterizedTypeInstance, valuesForParameterizedTypeInstance);
                structsForParameterizedTypeInstances.add(structValueForParameterizedTypeInstance);
            }
            Constant initialValuesForParameterizedType = this.m_module.getConstantArray(structsForParameterizedTypeInstances);
            globalForParameterizedType.setInitializer(initialValuesForParameterizedType);
        }
        for (Pair pair : globalsForParameterizedTypes) {
            Type[] instancesArray3 = (Type[])pair.snd;
            for (int i = 0; i < instancesArray3.length; ++i) {
                assert (LLVMStubTypes.compareTypes(this.getTypeId(instancesArray3[i]).getType(), this.m_module.types.TraitsIdTy));
            }
        }
    }

    private final Function getOrCreateFunctionForMethod(Method m) {
        return this.getOrCreateFunctionForMethod(m, null);
    }

    private final Function getOrCreateFunctionForMethod(Method m, String symbolName) {
        Function result = this.m_abcMethodToLLVMFunction.get(m);
        if (result == null) {
            FunctionType functionTy = this.getMethodFunctionType(m);
            String tempSymbolName = symbolName != null ? symbolName : "abcMethod_TempName" + String.valueOf(this.m_abcMethodToLLVMFunction.size());
            result = this.m_module.createInternalFunction(tempSymbolName, functionTy, this.useARMCallingConvention);
            this.m_abcMethodToLLVMFunction.put(m, result);
        } else if (symbolName != null) {
            result.function().setName(new Twine(new JNIStringRef(symbolName)));
        }
        return result;
    }

    static {
        LLVMEmitter.loadJNI();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MethodArrays {
        final Constant activationTraitsArrayPtr;
        final Constant scriptActivationTraitsInitFunctonsArrayPtr;
        final int nActivationraits;

        MethodArrays(GlobalOptimizer.Abc abc, String abcScriptName, SortedSet<Method> methods) {
            Constant activationTraitsNullValues = LLVMEmitter.this.m_module.getConstantArrayOfZeros(((LLVMEmitter)LLVMEmitter.this).m_module.types.TraitsPtrTy, methods.size());
            GlobalVariable activationTraitsArray = LLVMEmitter.this.m_module.createGlobal("abcActivationTraits_" + abcScriptName, false, activationTraitsNullValues);
            this.activationTraitsArrayPtr = LLVMEmitter.this.m_module.getGetElementPtrConstantExpression((Constant)activationTraitsArray, 0, 0);
            ArrayList<Constant> activationTraitsInitsArrayInitializerList = new ArrayList<Constant>();
            activationTraitsInitsArrayInitializerList.ensureCapacity(methods.size());
            ConstantPointerNull nullInitFunction = ConstantPointerNull.get(((LLVMEmitter)LLVMEmitter.this).m_module.types.CompiledHandlerPtrTy);
            int methodIndex = 0;
            for (Method m : methods) {
                assert (abc.methodId(m) == methodIndex);
                Constant initFunction = nullInitFunction;
                if (m.needActivation()) {
                    assert (m.activation != null);
                    Constant activationTraitsId = LLVMEmitter.this.m_module.getGetElementPtrConstantExpression((Constant)activationTraitsArray, 0, methodIndex);
                    LLVMEmitter.this.setTypeId(m.activation.getType(), activationTraitsId);
                    if (m.activation.getType().init != null) {
                        Function f = LLVMEmitter.this.getOrCreateFunctionForMethod(m.activation.getType().init);
                        initFunction = LLVMEmitter.this.m_module.functionToCompiledHandler(f);
                    }
                }
                assert (activationTraitsInitsArrayInitializerList.size() == methodIndex);
                activationTraitsInitsArrayInitializerList.add(initFunction);
                ++methodIndex;
            }
            Constant activationTraitsInitsArrayInitializer = LLVMEmitter.this.m_module.getConstantArray(activationTraitsInitsArrayInitializerList);
            GlobalVariable scriptActivationTraitsInitFunctonsArray = LLVMEmitter.this.m_module.createGlobal("abcActivationTraits_" + abcScriptName + "_initMethods", true, activationTraitsInitsArrayInitializer);
            this.scriptActivationTraitsInitFunctonsArrayPtr = LLVMEmitter.this.m_module.getGetElementPtrConstantExpression((Constant)scriptActivationTraitsInitFunctonsArray, 0, 0);
            this.nActivationraits = methodIndex;
        }
    }

    private final class ScriptArrays {
        final Constant scriptTraitsArrayPtr;

        ScriptArrays(GlobalOptimizer.Abc abc, String abcScriptName) {
            Type[] sortedScripts = LLVMEmitter.this.sortedScripts(abc);
            Constant scriptTraitsNullValues = LLVMEmitter.this.m_module.getConstantArrayOfZeros(((LLVMEmitter)LLVMEmitter.this).m_module.types.TraitsPtrTy, sortedScripts.length);
            GlobalVariable scriptTraitsArray = LLVMEmitter.this.m_module.createGlobal("abcScriptTraits_" + abcScriptName, false, scriptTraitsNullValues);
            for (int scriptIndex = 0; scriptIndex < sortedScripts.length; ++scriptIndex) {
                Type script = sortedScripts[scriptIndex];
                assert (script.init.cx == script);
                Constant scriptTraitsId = LLVMEmitter.this.m_module.getGetElementPtrConstantExpression((Constant)scriptTraitsArray, 0, scriptIndex);
                LLVMEmitter.this.setTypeId(script, scriptTraitsId);
            }
            this.scriptTraitsArrayPtr = LLVMEmitter.this.m_module.getGetElementPtrConstantExpression((Constant)scriptTraitsArray, 0, 0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MethodEmitter {
        private final GlobalOptimizer.Abc m_abc;
        private final Method m_method;
        private final Map<Expr, Typeref> m_exprTypes;
        private final Algorithms.EdgeMap<Expr> m_exprUses;
        private final Function m_function;
        private final Map<Expr, Value> m_exprToLLVMValue;
        private Map<Expr, Value> m_exprToDebugValue;
        private final Map<Block, BasicBlock> m_abcBlockToBasicBlock;
        private final boolean m_debugger;
        private final Value m_exceptFilterVar;
        private final int m_debugVarCount;
        private final Value m_debugVars;
        private final Value m_exceptionFrame;
        private final BasicBlock m_handleByRethrowBlock;
        private final BasicBlock m_rethrowBlock;
        private final BasicBlock m_throwAbortBlock;
        private final Map<BasicBlock, Edge[]> m_bbToXsuccs;
        private final Map<Edge[], BasicBlock> m_xsuccsToXbb;
        private final Map<Edge[], Constant> m_xsuccsToExceptFilter;
        private final Value m_methodFrame;
        private final Value m_methodEnvPtrValue;
        private final Value m_scopesValue;
        private final BasicBlock m_returnBlock;
        private final PHINode m_returnBlockPhi;
        private final LLVMTamarinSlotLayoutCache.ITypeProvider m_builtinClassesTypeProvider;
        private int kVOID = 0;
        private int kOBJECT = 1;
        private int kCLASS = 2;
        private int kFUNCTION = 3;
        private int kARRAY = 4;
        private int kSTRING = 5;
        private int kNUMBER = 6;
        private int kINT = 7;
        private int kUINT = 8;
        private int kBOOLEAN = 9;
        private int kANY = 10;
        private int kNAMESPACE = 11;
        private int kVECTORINT = 12;
        private int kVECTORUINT = 13;
        private int kVECTOROBJ = 15;
        private Map<Edge, BasicBlock> m_exceptEdges = new TreeMap<Edge, BasicBlock>();

        private LLVMTamarinSlotLayoutCache.ITypeProvider makeBuiltinClassesTypeProvider() {
            return new LLVMTamarinSlotLayoutCache.ITypeProvider(){
                private static final String s_ScriptObject = "ScriptObject";
                private static final String s_ClassClosure = "ClassClosure";

                private String getGlueClassName(Type t) {
                    boolean isInstance = t.itype == null;
                    Name className = isInstance ? t.getName() : t.itype.getName();
                    GlobalOptimizer.Metadata[] metaDatas = MethodEmitter.this.m_method.domain().getClassMetadata(className);
                    if (metaDatas != null) {
                        for (GlobalOptimizer.Metadata md : metaDatas) {
                            String result;
                            if (!md.name.equals("native")) continue;
                            String classGlueClass = null;
                            String instanceGlueClass = null;
                            for (GlobalOptimizer.Attr a : md.attrs) {
                                if (a.name().equals("cls")) {
                                    classGlueClass = a.value();
                                    continue;
                                }
                                if (!a.name().equals("instance")) continue;
                                instanceGlueClass = a.value();
                            }
                            if (classGlueClass != null || instanceGlueClass != null) {
                                if (classGlueClass == null) {
                                    classGlueClass = s_ClassClosure;
                                }
                                if (instanceGlueClass == null) {
                                    instanceGlueClass = s_ScriptObject;
                                }
                            }
                            String string = result = isInstance ? instanceGlueClass : classGlueClass;
                            if (t.slotCount > 0) {
                                Type rootAS3Class;
                                String rootNativeClass = isInstance ? s_ScriptObject : s_ClassClosure;
                                Type type = rootAS3Class = isInstance ? BuiltinDomain.instance().OBJECT : BuiltinDomain.instance().CLASS;
                                if (instanceGlueClass.equals(rootNativeClass)) {
                                    if (t.base == null || t.base.extendsBase(rootAS3Class)) {
                                        String errorStr = "Native metadata for " + className.format() + " specifies " + rootNativeClass + " as the native class, but does not subclass " + rootAS3Class.getName().format() + ".";
                                        throw new Error(errorStr);
                                    }
                                    result = null;
                                }
                            }
                            return result;
                        }
                    }
                    return null;
                }

                private Pair<PointerType, llvm.Type> getGlueClassTypes(Type t) {
                    String glueClassName = this.getGlueClassName(t);
                    if (glueClassName == null) {
                        return null;
                    }
                    return (Pair)LLVMEmitter.this.m_glueClassNameToLLVMTypes.get(glueClassName);
                }

                @Override
                public Pair<StructType, PointerType> builtinTypeStructType(Type t) {
                    if (t == BuiltinDomain.instance().ANY()) {
                        return this.builtinTypeStructType(BuiltinDomain.instance().OBJECT);
                    }
                    Pair<PointerType, llvm.Type> glueClassTypes = this.getGlueClassTypes(t);
                    if (glueClassTypes == null) {
                        return null;
                    }
                    StructType structType = StructType.dyn_cast(CompositeType.dyn_cast(DerivedType.dyn_cast((llvm.Type)glueClassTypes.snd)));
                    if (structType == null) {
                        throw new Error("Unable to cast " + this.getGlueClassName(t) + " to a StructType");
                    }
                    Pair<StructType, PointerType> result = new Pair<StructType, PointerType>(structType, (PointerType)glueClassTypes.fst);
                    return result;
                }
            };
        }

        public MethodEmitter(GlobalOptimizer.Abc abc, Method m, Map<Expr, Typeref> types, Algorithms.EdgeMap<Expr> uses, boolean debugger) {
            assert (!m.isNative());
            this.m_abc = abc;
            this.m_method = m;
            this.m_exprTypes = types;
            this.m_exprUses = uses;
            this.m_debugger = debugger;
            LLVMEmitter.this.printMsg("METHODEMITTER: '" + m.debugName + "' '" + this.symbolName(m).toString() + "'");
            this.m_function = LLVMEmitter.this.getOrCreateFunctionForMethod(m, this.symbolName(m));
            this.m_exprToLLVMValue = new HashMap<Expr, Value>();
            this.m_exprToDebugValue = new HashMap<Expr, Value>();
            this.m_abcBlockToBasicBlock = new HashMap<Block, BasicBlock>();
            BasicBlock entryBlock = this.m_function.addBlock("entry");
            ConstantInt nScopes = LLVMEmitter.this.constantInt(32L, m.max_scope > 0 ? (long)m.max_scope : 1L);
            this.m_methodEnvPtrValue = this.m_function.arg(0);
            this.m_methodFrame = entryBlock.addInstruction(AllocaInst.class, ((LLVMEmitter)LLVMEmitter.this).m_module.types.AOTMethodFrameTy, LLVMEmitter.this.constantInt(32L, 1L));
            this.callFunction("enterMethodFrame", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(this.m_methodFrame)}), entryBlock);
            this.m_scopesValue = entryBlock.addInstruction(AllocaInst.class, ((LLVMEmitter)LLVMEmitter.this).m_module.types.AtomTy, nScopes);
            this.m_returnBlock = this.m_function.addBlock("unifiedReturn");
            this.m_returnBlockPhi = this.m_returnBlock.addInstruction(PHINode.class, LLVMEmitter.this.m_module.llvmType(this.m_method.returns.getType()));
            this.m_builtinClassesTypeProvider = this.makeBuiltinClassesTypeProvider();
            this.runtimeMessage("executing method '" + m.debugName + "' symbolname '" + this.symbolName(m).toString() + "'\n", entryBlock);
            this.runtimeMessage("returning from method '" + m.debugName + "' symbolname '" + this.symbolName(m).toString() + "'\n", this.m_returnBlock);
            if (this.m_debugger) {
                this.m_debugVarCount = this.m_method.local_count + this.m_method.max_scope;
                int argCount = this.m_method.params.length + (this.m_method.needsRest() || this.m_method.needsArguments() ? 1 : 0);
                AllocaInst callStackNode = entryBlock.addInstruction(AllocaInst.class, ((LLVMEmitter)LLVMEmitter.this).m_module.types.CallStackNodeTy, LLVMEmitter.this.constantInt(32L, 1L));
                this.m_exceptFilterVar = entryBlock.addInstruction(AllocaInst.class, ((LLVMEmitter)LLVMEmitter.this).m_module.types.intTy, LLVMEmitter.this.constantInt(32L, 1L));
                this.m_debugVars = entryBlock.addInstruction(AllocaInst.class, ((LLVMEmitter)LLVMEmitter.this).m_module.types.AtomTy, LLVMEmitter.this.constantInt(32L, this.m_debugVarCount));
                Value undef = this.callFunction("loadundefined", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.AtomTy).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue)}), entryBlock);
                for (int i = 0; i < this.m_debugVarCount; ++i) {
                    GetElementPtrInst gep = entryBlock.addGetElementPtr(this.m_debugVars, (Value[])LLVMEmitter.arr(new ConstantInt[]{LLVMEmitter.this.constantInt(32L, i)}));
                    if (i < argCount) {
                        entryBlock.addVolatileStore(this.emitValueBoxing(entryBlock, this.getVWT(this.m_function.arg(i + 1))), gep);
                        continue;
                    }
                    entryBlock.addVolatileStore(undef, gep);
                }
                this.callFunction("debugEnter", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWTNull(((LLVMEmitter)LLVMEmitter.this).m_module.types.TraitsIdTy), this.getVWT(callStackNode), this.getVWT(this.m_debugVars), this.getVWT(this.m_exceptFilterVar)}), entryBlock);
                this.callFunction("debugExit", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(callStackNode)}), this.m_returnBlock);
            } else {
                this.m_exceptFilterVar = null;
                this.m_debugVarCount = 0;
                this.m_debugVars = null;
            }
            if (m.hasExceptions) {
                AllocaInst exceptionFrame = entryBlock.addInstruction(AllocaInst.class, ((LLVMEmitter)LLVMEmitter.this).m_module.types.ExceptionFrameTy, LLVMEmitter.this.constantInt(32L, 1L));
                this.callFunction("beginTry", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(exceptionFrame)}), entryBlock);
                this.callFunction("endTry", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(exceptionFrame)}), this.m_returnBlock);
                this.m_throwAbortBlock = this.m_function.addBlock("throwAbort");
                this.abort("throw failed", this.m_throwAbortBlock, LLVMEmitter.this.m_module.m_module.getContext());
                BasicBlock handleByRethrowBlock = this.m_function.addBlock("handleByRethrow");
                ValueWithTyperef[] beginCatchArgs = (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(exceptionFrame)});
                handleByRethrowBlock.addInvoke(LLVMEmitter.this.m_module.m_module.getContext(), this.getFunction("beginCatch", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), beginCatchArgs, handleByRethrowBlock), this.m_throwAbortBlock, ValueWithTyperef.getValueArray(beginCatchArgs), LLVMEmitter.this.useARMCallingConvention);
                BasicBlock rethrowBlock = this.m_function.addBlock("rethrow");
                this.callFunction("rethrow", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(exceptionFrame)}), rethrowBlock);
                rethrowBlock.addInstruction(UnreachableInst.class, LLVMEmitter.this.m_module.m_module.getContext());
                handleByRethrowBlock.addBranch(rethrowBlock);
                this.m_handleByRethrowBlock = handleByRethrowBlock;
                this.m_rethrowBlock = rethrowBlock;
                this.m_exceptionFrame = exceptionFrame;
                this.m_bbToXsuccs = new HashMap<BasicBlock, Edge[]>();
                this.m_xsuccsToXbb = new HashMap<Edge[], BasicBlock>();
                this.m_xsuccsToExceptFilter = this.m_exceptFilterVar != null ? new HashMap<Edge[], Constant>() : null;
            } else {
                this.m_throwAbortBlock = null;
                this.m_handleByRethrowBlock = null;
                this.m_rethrowBlock = null;
                this.m_exceptionFrame = null;
                this.m_bbToXsuccs = null;
                this.m_xsuccsToXbb = null;
                this.m_xsuccsToExceptFilter = null;
            }
            this.callFunction("exitMethodFrame", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(this.m_methodFrame)}), this.m_returnBlock);
            this.m_returnBlock.addInstruction(ReturnInst.class, LLVMEmitter.this.m_module.m_module.getContext(), this.m_returnBlockPhi);
        }

        private BasicBlock basicBlock(Block b) {
            BasicBlock result = this.m_abcBlockToBasicBlock.get(b);
            if (result == null) {
                result = this.m_function.addBlock();
                this.m_abcBlockToBasicBlock.put(b, result);
            }
            return result;
        }

        private Value value(Expr e) {
            Value result = null;
            if (this.m_debugger && null != this.m_exprToDebugValue && null != (result = this.m_exprToDebugValue.get(e))) {
                return result;
            }
            result = this.m_exprToLLVMValue.get(e);
            return result;
        }

        private Typeref typeref(Expr e) {
            Typeref result = this.m_exprTypes.get(e);
            return result;
        }

        private llvm.Type llvmType(Expr e) {
            Typeref tr = this.typeref(e);
            if (tr == null) {
                LLVMEmitter.this.printErr("Should typeref be null?...");
                return ((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy;
            }
            return LLVMEmitter.this.m_module.llvmType(tr.t);
        }

        public Function emit() {
            DebugState debugState = new DebugState();
            debugState.locals = new LinkedList<Pair<Expr, Expr>>();
            debugState.restore = new LinkedList<Pair<Expr, Expr>>();
            Block firstBlock = this.m_method.entry.to;
            BasicBlock entryBlock = this.m_function.entryBlock();
            BasicBlock firstBasicBlock = this.basicBlock(firstBlock);
            entryBlock.addBranch(firstBasicBlock);
            Algorithms.Deque<Block> blocks = this.m_method.depthFirstCfg();
            block21: for (Block b : blocks) {
                this.m_exprToDebugValue.clear();
                this.emitBlock(b, debugState);
                Expr last = b.last();
                BasicBlock bb = this.basicBlock(b);
                this.runtimeMessage("--- " + last.opName() + " " + last.toString() + "\n", bb);
                switch (last.op) {
                    case 72: {
                        assert (this.typeref(last.args[0]).getType() == this.m_method.returns.getType());
                        this.m_exprToLLVMValue.put(last, this.value(last.args[0]));
                        bb.addBranch(this.m_returnBlock);
                        continue block21;
                    }
                    case 71: {
                        assert (false);
                        continue block21;
                    }
                    case 3: {
                        this.callFunction("throw", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(this.emitValueBoxing(bb, last.args[0])).setTempl()}), bb);
                        bb.addInstruction(UnreachableInst.class, LLVMEmitter.this.m_module.m_module.getContext());
                        continue block21;
                    }
                    case 17: {
                        this.emitBranch(bb, this.emitTest(bb, "true", last.args[0]), last.succ[1], last.succ[0]);
                        continue block21;
                    }
                    case 18: {
                        this.emitBranch(bb, this.emitTest(bb, "true", last.args[0]), last.succ[0], last.succ[1]);
                        continue block21;
                    }
                    case 12: {
                        this.emitBranch(bb, this.emitCond(bb, "lessthan", last.args[0], last.args[1]), last.succ[0], last.succ[1]);
                        continue block21;
                    }
                    case 13: {
                        this.emitBranch(bb, this.emitCond(bb, "lessequals", last.args[0], last.args[1]), last.succ[0], last.succ[1]);
                        continue block21;
                    }
                    case 14: {
                        this.emitBranch(bb, this.emitCond(bb, "greaterthan", last.args[0], last.args[1]), last.succ[0], last.succ[1]);
                        continue block21;
                    }
                    case 15: {
                        this.emitBranch(bb, this.emitCond(bb, "greaterequals", last.args[0], last.args[1]), last.succ[0], last.succ[1]);
                        continue block21;
                    }
                    case 21: {
                        this.emitBranch(bb, this.emitCond(bb, "lessthan", last.args[0], last.args[1]), last.succ[1], last.succ[0]);
                        continue block21;
                    }
                    case 22: {
                        this.emitBranch(bb, this.emitCond(bb, "lessequals", last.args[0], last.args[1]), last.succ[1], last.succ[0]);
                        continue block21;
                    }
                    case 23: {
                        this.emitBranch(bb, this.emitCond(bb, "greaterthan", last.args[0], last.args[1]), last.succ[1], last.succ[0]);
                        continue block21;
                    }
                    case 24: {
                        this.emitBranch(bb, this.emitCond(bb, "greaterequals", last.args[0], last.args[1]), last.succ[1], last.succ[0]);
                        continue block21;
                    }
                    case 19: {
                        this.emitBranch(bb, this.emitCond(bb, "equals", last.args[0], last.args[1]), last.succ[1], last.succ[0]);
                        continue block21;
                    }
                    case 20: {
                        this.emitBranch(bb, this.emitCond(bb, "equals", last.args[0], last.args[1]), last.succ[0], last.succ[1]);
                        continue block21;
                    }
                    case 25: {
                        this.emitBranch(bb, this.emitCond(bb, "strictequals", last.args[0], last.args[1]), last.succ[1], last.succ[0]);
                        continue block21;
                    }
                    case 26: {
                        this.emitBranch(bb, this.emitCond(bb, "strictequals", last.args[0], last.args[1]), last.succ[0], last.succ[1]);
                        continue block21;
                    }
                    case 16: {
                        this.emitBranch(bb, last.succ[0]);
                        continue block21;
                    }
                    case 27: {
                        int nCases = last.succ.length - 1;
                        BasicBlock defaultTarget = this.basicBlock(last.succ[nCases].to);
                        BasicBlock[] dests = new BasicBlock[nCases];
                        for (int i = 0; i < nCases; ++i) {
                            dests[i] = this.basicBlock(last.succ[i].to);
                        }
                        Expr e = last.args[0];
                        Value value = this.value(e);
                        if (this.llvmType(e) == ((LLVMEmitter)LLVMEmitter.this).m_module.types.NumberTy) {
                            value = bb.addInstruction(TruncInst.class, value);
                        }
                        bb.addDenseSwitch(LLVMEmitter.this.m_ctx, value, defaultTarget, dests);
                        continue block21;
                    }
                }
                assert (false);
            }
            this.m_exprToDebugValue.clear();
            int blockCount = 0;
            for (Block b : blocks) {
                int phiCount = 0;
                for (Expr e : b.exprs) {
                    if (e.op != 257) break;
                    PHINode llvmPHI = PHINode.dyn_cast(Instruction.dyn_cast(User.dyn_cast(this.value(e))));
                    assert (llvmPHI != null);
                    assert (e.pred.length == e.args.length);
                    String phitype = this.getMangleableType(this.getVWT(e)).mangle();
                    LLVMEmitter.this.printErr("Fixing phi with " + e.args.length + " incoming nodes and type " + phitype);
                    for (int i = 0; i < e.pred.length; ++i) {
                        BasicBlock fromBB;
                        Edge pred = e.pred[i];
                        assert (pred.to == b);
                        if (pred.handler != null) {
                            fromBB = this.m_exceptEdges.get(pred);
                            assert (fromBB != null);
                        } else {
                            fromBB = this.basicBlock(pred.from);
                        }
                        Value fromValue = this.value(e.args[i]);
                        if (LLVMEmitter.this.debugMessages) {
                            if (fromValue == null) {
                                LLVMEmitter.this.printErr("-- null incoming value...");
                            } else if (phitype.compareTo(this.getMangleableType(this.getVWT(e.args[i])).mangle()) != 0) {
                                LLVMEmitter.this.printErr("-- incoming type: " + this.getMangleableType(this.getVWT(e.args[i])).mangle() + " does not match phi type: " + phitype);
                                LLVMEmitter.this.printErr("-- incoming expr was: ");
                                this.value(e.args[i]).dump();
                                this.m_function.m_function.dump();
                            } else {
                                LLVMEmitter.this.printErr("-- incoming type: " + this.getMangleableType(this.getVWT(e.args[i])).mangle());
                            }
                        }
                        fromBB.setPHIIncoming(llvmPHI, fromValue);
                    }
                    ++phiCount;
                }
                Expr lastExpr = b.last();
                if (lastExpr.op == 72) {
                    BasicBlock bb = this.basicBlock(b);
                    Value returnValue = this.value(lastExpr);
                    LLVMEmitter.this.printErr("return phi: " + blockCount + " returnValueId" + returnValue.getValueID());
                    bb.setPHIIncoming(this.m_returnBlockPhi, returnValue);
                }
                ++blockCount;
            }
            if (this.m_returnBlockPhi.getNumIncomingValues() == 0L) {
                assert (this.m_returnBlock.hasNUses(0L));
                this.m_returnBlock.eraseFromParent();
            }
            return this.m_function;
        }

        private void emitBranch(BasicBlock bb, Value condition, Edge e1, Edge e2) {
            BasicBlock target1 = this.basicBlock(e1.to);
            BasicBlock target2 = this.basicBlock(e2.to);
            bb.addBranch(condition, target1, target2);
        }

        private void emitBranch(BasicBlock bb, Edge e) {
            bb.addBranch(this.basicBlock(e.to));
        }

        private Value emitCond(BasicBlock bb, String cond, Expr arg1, Expr arg2) {
            Value conditionResultAsBool = this.callFunction(cond, this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.BooleanTy).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(arg1).setTempl(), this.getVWT(arg2).setTempl()}), bb);
            Value conditionResultAsInt = this.callFunction("true", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.intTy).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(conditionResultAsBool).setTempl()}), bb);
            return bb.addInstruction(ICmpInst.class, CmpInst.Predicate.ICMP_NE, conditionResultAsInt, LLVMEmitter.this.constantInt(32L, 0L));
        }

        private Value emitTest(BasicBlock bb, String test, Expr arg) {
            Value testResultAsInt = this.callFunction(test, this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.intTy).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(arg).setTempl()}), bb);
            return bb.addInstruction(ICmpInst.class, CmpInst.Predicate.ICMP_NE, testResultAsInt, LLVMEmitter.this.constantInt(32L, 0L));
        }

        private LLVMStubFunctions.Gcc3mang.Mangleable getMangleableType(Typeref tr) {
            BuiltinDomain tc = BuiltinDomain.instance();
            if (tr.t.atom || tr.t == tc.ANY) {
                return LLVMStubFunctions.AtomTy;
            }
            if (tr.t == tc.ARRAY) {
                return LLVMStubFunctions.ArrayObjectPtrTy;
            }
            if (tr.t == tc.BOOLEAN) {
                return LLVMStubFunctions.BoolTy;
            }
            if (tr.t == tc.CLASS) {
                return LLVMStubFunctions.ScriptObjectPtrTy;
            }
            if (tr.t == tc.FUNCTION) {
                return LLVMStubFunctions.ScriptObjectPtrTy;
            }
            if (tr.t == tc.INT) {
                return LLVMStubFunctions.Gcc3mang.SimpleType.intTy;
            }
            if (tr.t == tc.NAMESPACE) {
                return LLVMStubFunctions.NamespacePtrTy;
            }
            if (tr.t == tc.NUMBER) {
                return LLVMStubFunctions.Gcc3mang.SimpleType.doubleTy;
            }
            if (tr.t == tc.OBJECT) {
                return LLVMStubFunctions.ScriptObjectPtrTy;
            }
            if (tr.t == tc.QNAME) {
                return LLVMStubFunctions.QNameObjectPtrTy;
            }
            if (tr.t == tc.STRING) {
                return LLVMStubFunctions.StringPtrTy;
            }
            if (tr.t == tc.UINT) {
                return LLVMStubFunctions.Gcc3mang.SimpleType.unsignedTy;
            }
            if (tr.t == tc.VOID) {
                return LLVMStubFunctions.Gcc3mang.SimpleType.voidTy;
            }
            if (tr.t == tc.XML) {
                return LLVMStubFunctions.ScriptObjectPtrTy;
            }
            if (tr.t == tc.XMLLIST) {
                return LLVMStubFunctions.ScriptObjectPtrTy;
            }
            if (tr.t.isDerivedFrom(tc.OBJECT)) {
                return LLVMStubFunctions.ScriptObjectPtrTy;
            }
            LLVMEmitter.this.printErr("Warning: failed to match typeref.t: " + tr.t.toString());
            return LLVMStubFunctions.ScriptObjectPtrTy;
        }

        private LLVMStubFunctions.Gcc3mang.Mangleable getMangleableType(llvm.Type t) {
            LLVMStubFunctions.Gcc3mang.Mangleable m = null;
            assert (t != null);
            if (LLVMStubTypes.compareTypes(t, ((LLVMEmitter)LLVMEmitter.this).m_module.types.AtomTy)) {
                m = LLVMStubFunctions.AtomTy;
            } else if (LLVMStubTypes.compareTypes(t, ((LLVMEmitter)LLVMEmitter.this).m_module.types.BooleanTy)) {
                m = LLVMStubFunctions.BoolTy;
            } else if (LLVMStubTypes.compareTypes(t, ((LLVMEmitter)LLVMEmitter.this).m_module.types.intTy)) {
                m = LLVMStubFunctions.Gcc3mang.SimpleType.intTy;
            } else if (LLVMStubTypes.compareTypes(t, ((LLVMEmitter)LLVMEmitter.this).m_module.types.NumberTy)) {
                m = LLVMStubFunctions.Gcc3mang.SimpleType.doubleTy;
            } else if (LLVMStubTypes.compareTypes(t, ((LLVMEmitter)LLVMEmitter.this).m_module.types.ExceptionFramePtrTy)) {
                m = LLVMStubFunctions.ExceptionFramePtrTy;
            } else if (LLVMStubTypes.compareTypes(t, ((LLVMEmitter)LLVMEmitter.this).m_module.types.CallStackNodePtrTy)) {
                m = LLVMStubFunctions.CallStackNodePtrTy;
            } else if (LLVMStubTypes.compareTypes(t, ((LLVMEmitter)LLVMEmitter.this).m_module.types.MethodEnvPtrTy)) {
                m = LLVMStubFunctions.MethodEnvPtrTy;
            } else if (LLVMStubTypes.compareTypes(t, ((LLVMEmitter)LLVMEmitter.this).m_module.types.QNameObjectPtrTy)) {
                m = LLVMStubFunctions.QNameObjectPtrTy;
            } else if (LLVMStubTypes.compareTypes(t, ((LLVMEmitter)LLVMEmitter.this).m_module.types.NamespacePtrTy)) {
                m = LLVMStubFunctions.NamespacePtrTy;
            } else if (LLVMStubTypes.compareTypes(t, ((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy)) {
                m = LLVMStubFunctions.Gcc3mang.SimpleType.voidTy;
            } else if (LLVMStubTypes.compareTypes(t, ((LLVMEmitter)LLVMEmitter.this).m_module.types.StringPtrTy)) {
                m = LLVMStubFunctions.StringPtrTy;
            } else if (LLVMStubTypes.compareTypes(t, ((LLVMEmitter)LLVMEmitter.this).m_module.types.ScriptObjectPtrTy)) {
                m = LLVMStubFunctions.ScriptObjectPtrTy;
            } else if (LLVMStubTypes.compareTypes(t, ((LLVMEmitter)LLVMEmitter.this).m_module.types.ArrayObjectPtrTy)) {
                m = LLVMStubFunctions.ArrayObjectPtrTy;
            } else if (LLVMStubTypes.compareTypes(t, ((LLVMEmitter)LLVMEmitter.this).m_module.types.AOTMethodFramePtrTy)) {
                m = LLVMStubFunctions.AOTMethodFramePtrTy;
            } else if (LLVMStubTypes.compareTypes(t, ((LLVMEmitter)LLVMEmitter.this).m_module.types.NamespaceIdTy)) {
                m = new LLVMStubFunctions.Gcc3mang.Pointer(LLVMStubFunctions.NamespacePtrTy);
            } else if (LLVMStubTypes.compareTypes(t, ((LLVMEmitter)LLVMEmitter.this).m_module.types.intPtrTy)) {
                m = new LLVMStubFunctions.Gcc3mang.Pointer(LLVMStubFunctions.Gcc3mang.SimpleType.intTy);
            } else if (LLVMStubTypes.compareTypes(t, ((LLVMEmitter)LLVMEmitter.this).m_module.types.AtomPtrTy)) {
                m = new LLVMStubFunctions.Gcc3mang.Pointer(LLVMStubFunctions.AtomTy);
            } else if (LLVMStubTypes.compareTypes(t, ((LLVMEmitter)LLVMEmitter.this).m_module.types.charPtrTy)) {
                m = new LLVMStubFunctions.Gcc3mang.Pointer(LLVMStubFunctions.Gcc3mang.SimpleType.charTy);
            } else if (LLVMStubTypes.compareTypes(t, ((LLVMEmitter)LLVMEmitter.this).m_module.types.TraitsIdTy)) {
                m = LLVMStubFunctions.TraitsPtrPtrTy;
            } else if (LLVMStubTypes.compareTypes(t, ((LLVMEmitter)LLVMEmitter.this).m_module.types.TraitsIdPtrTy)) {
                m = new LLVMStubFunctions.Gcc3mang.Pointer(LLVMStubFunctions.TraitsPtrPtrTy);
            } else if (LLVMStubTypes.compareTypes(t, ((LLVMEmitter)LLVMEmitter.this).m_module.types.UnsedParamTy)) {
                m = LLVMStubFunctions.UnsedParamTy;
            } else if (LLVMStubTypes.compareTypes(t, ((LLVMEmitter)LLVMEmitter.this).m_module.types.MultinameIndexTy)) {
                m = LLVMStubFunctions.MultiNameIndexTy;
            } else if (LLVMStubTypes.compareTypes(t, ((LLVMEmitter)LLVMEmitter.this).m_module.types.MultinameIndexMaybeUIntTy)) {
                m = LLVMStubFunctions.MultinameIndexMaybeUIntTy;
            } else {
                LLVMEmitter.this.printErr("ERROR: Failed to mangle llvm.Type: " + LLVMEmitter.this.m_module.getTypeName(t));
                throw new Error("ERROR: Failed to mangle llvm.Type: " + LLVMEmitter.this.m_module.getTypeName(t));
            }
            return m;
        }

        private LLVMStubFunctions.Gcc3mang.Mangleable getMangleableType(ValueWithTyperef vwt) {
            llvm.Type t = vwt.getType();
            Typeref tr = vwt.getTyperef();
            LLVMStubFunctions.Gcc3mang.Mangleable m = null;
            if (tr != null) {
                m = this.getMangleableType(tr);
            }
            if (m == null && (m = this.getMangleableType(t)) == null) {
                m = this.getMangleableType(vwt.getValue().getType());
            }
            assert (m != null);
            if (vwt.isTempl()) {
                return new LLVMStubFunctions.Gcc3mang.TemplateParam(m);
            }
            return m;
        }

        private Function getFunctionMaybeVA(int numBaseArgs, String base, ValueWithTyperef retType, ValueWithTyperef[] args, BasicBlock bb) {
            int actualArgs;
            Function f;
            int typedArgs;
            String fname = "abcOP_" + base;
            String argtypedesc = "";
            String templatetypedesc = "";
            LLVMStubFunctions.Gcc3mang.Mangleable retTypeM = this.getMangleableType(retType);
            LLVMStubFunctions.Gcc3mang.Mangleable[] argTypes = null;
            int n = typedArgs = numBaseArgs >= 0 ? numBaseArgs : args.length;
            if (args != null) {
                argTypes = new LLVMStubFunctions.Gcc3mang.Mangleable[typedArgs];
                for (int i = 0; i < typedArgs; ++i) {
                    argTypes[i] = this.getMangleableType(args[i]);
                    argtypedesc = argtypedesc + argTypes[i].mangle() + ", ";
                }
            }
            ArrayList<LLVMStubFunctions.Gcc3mang.TemplateParam> templateTypeList = new ArrayList<LLVMStubFunctions.Gcc3mang.TemplateParam>();
            if (retType.isTempl()) {
                templateTypeList.add((LLVMStubFunctions.Gcc3mang.TemplateParam)retTypeM);
                templatetypedesc = templatetypedesc + retTypeM.mangle() + ", ";
            }
            if (args != null) {
                for (int i = 0; i < typedArgs; ++i) {
                    if (!args[i].isTempl()) continue;
                    templateTypeList.add((LLVMStubFunctions.Gcc3mang.TemplateParam)argTypes[i]);
                    templatetypedesc = templatetypedesc + argTypes[i].mangle() + ", ";
                }
            }
            LLVMStubFunctions.Gcc3mang.TemplateParam[] templateTypes = null;
            if (templateTypeList.size() > 0) {
                templateTypes = new LLVMStubFunctions.Gcc3mang.TemplateParam[templateTypeList.size()];
                for (int i = 0; i < templateTypeList.size(); ++i) {
                    templateTypes[i] = (LLVMStubFunctions.Gcc3mang.TemplateParam)templateTypeList.get(i);
                }
            }
            String mname = new LLVMStubFunctions.Gcc3mang.Function(templateTypes, retTypeM, new LLVMStubFunctions.Gcc3mang.Name(fname), argTypes, numBaseArgs >= 0).mangle();
            if (bb != null && base != "printf") {
                this.runtimeMessage("getFunction: " + mname + "\n", bb);
            }
            if ((f = ((LLVMEmitter)LLVMEmitter.this).m_module.functions.getFunction(mname)) != null) {
                return f;
            }
            int n2 = actualArgs = numBaseArgs >= 0 ? numBaseArgs : args.length;
            assert (actualArgs <= args.length);
            llvm.Type[] argts = new llvm.Type[actualArgs];
            for (int i = 0; i < actualArgs; ++i) {
                argts[i] = args[i].getEffectiveLLVMType(LLVMEmitter.this.m_module);
                assert (argts[i] != null);
            }
            FunctionType ft = Module.getFunctionType(retType.getEffectiveLLVMType(LLVMEmitter.this.m_module), argts, numBaseArgs >= 0);
            f = LLVMEmitter.this.m_module.getOrCreateFunction(mname, ft, LLVMEmitter.this.useARMCallingConvention);
            return f;
        }

        private Function getFunctionVA(int numBaseArgs, String base, ValueWithTyperef retType, ValueWithTyperef[] args, BasicBlock bb) {
            assert (numBaseArgs >= 0);
            return this.getFunctionMaybeVA(numBaseArgs, base, retType, args, bb);
        }

        private Function getFunction(String base, ValueWithTyperef retType, ValueWithTyperef[] args, BasicBlock bb) {
            return this.getFunctionMaybeVA(-1, base, retType, args, bb);
        }

        private void runtimeMessage(String msg, BasicBlock bb) {
            LLVMEmitter.this.printMsg(msg);
            if (LLVMEmitter.this.runtimeDebugging) {
                this.callFunction("printf", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWTString(msg)}), bb);
            }
        }

        private void abort(String msg, BasicBlock bb, LLVMContext ctx) {
            this.callFunction("abort", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWTString(msg)}), bb);
            bb.addInstruction(UnreachableInst.class, ctx);
        }

        private BasicBlock getExceptBlock(BasicBlock bb) {
            Edge[] xsuccs;
            if (this.m_bbToXsuccs != null && this.m_bbToXsuccs.containsKey(bb) && this.m_xsuccsToXbb.containsKey(xsuccs = this.m_bbToXsuccs.get(bb))) {
                return this.m_xsuccsToXbb.get(xsuccs);
            }
            return this.m_handleByRethrowBlock;
        }

        private Constant getExceptFilter(BasicBlock bb) {
            Edge[] xsuccs;
            if (this.m_bbToXsuccs != null && this.m_bbToXsuccs.containsKey(bb) && this.m_xsuccsToExceptFilter.containsKey(xsuccs = this.m_bbToXsuccs.get(bb))) {
                return this.m_xsuccsToExceptFilter.get(xsuccs);
            }
            return LLVMEmitter.this.constantInt(32L, 0L);
        }

        private Value callOrInvokeFunction(Function f, BasicBlock bb, Value[] args, boolean unwinds) {
            BasicBlock exceptBlock = this.getExceptBlock(bb);
            Instruction i = unwinds && exceptBlock != null ? bb.addInvoke(LLVMEmitter.this.m_module.m_module.getContext(), f, exceptBlock, args, LLVMEmitter.this.useARMCallingConvention) : f.call(bb, args, LLVMEmitter.this.useARMCallingConvention);
            return i;
        }

        private void setCallAttrs(Value v, boolean doesNotThrow, boolean onlyReadsMemory, boolean doesNotAccessMemory) {
            assert (!onlyReadsMemory || !doesNotAccessMemory);
            CallInst ci = CallInst.dyn_cast(Instruction.dyn_cast(User.dyn_cast(v)));
            if (ci != null) {
                ci.setDoesNotThrow(doesNotThrow);
                if (doesNotThrow) {
                    ci.setOnlyReadsMemory(onlyReadsMemory);
                    ci.setDoesNotAccessMemory(doesNotAccessMemory);
                }
                return;
            }
            InvokeInst ii = InvokeInst.dyn_cast(TerminatorInst.dyn_cast(Instruction.dyn_cast(User.dyn_cast(v))));
            if (ii != null) {
                ii.setDoesNotThrow(doesNotThrow);
                if (doesNotThrow) {
                    ii.setOnlyReadsMemory(onlyReadsMemory);
                    ii.setDoesNotAccessMemory(doesNotAccessMemory);
                }
                return;
            }
        }

        private void applyExprAttrs(Value v, Expr e) {
            if (e.hasEffect()) {
                this.setCallAttrs(v, !e.isPx(), false, false);
            } else {
                this.setCallAttrs(v, !e.isPx(), false, e.isOper());
            }
        }

        private void callFunction(String base, ValueWithTyperef retType, ValueWithTyperef[] args, BasicBlock bb, Expr e) {
            Value i = this.callOrInvokeFunction(this.getFunction(base, retType, args, bb), bb, ValueWithTyperef.getValueArray(args), e.isPx());
            this.applyExprAttrs(i, e);
            this.m_exprToLLVMValue.put(e, i);
        }

        private void callFunctionVA(int baseArgCount, String base, ValueWithTyperef retType, ValueWithTyperef[] args, BasicBlock bb, Expr e) {
            Value i = this.callOrInvokeFunction(this.getFunctionVA(baseArgCount, base, retType, args, bb), bb, ValueWithTyperef.getValueArray(args), e.isPx());
            this.applyExprAttrs(i, e);
            this.m_exprToLLVMValue.put(e, i);
        }

        private Value callFunction(String base, ValueWithTyperef retType, ValueWithTyperef[] args, BasicBlock bb) {
            return this.callOrInvokeFunction(this.getFunction(base, retType, args, bb), bb, ValueWithTyperef.getValueArray(args), true);
        }

        private Value emitStaticLoad(BasicBlock bb, Expr e, String name) {
            String base = name.replace("push", "load");
            Value result = this.callFunction(base, this.getVWT(e).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue)}), bb);
            this.applyExprAttrs(result, e);
            this.m_exprToLLVMValue.put(e, result);
            return result;
        }

        private Value getSlotAddress(BasicBlock bb, Typeref baseType, int slotId, Value baseValue) {
            if (baseType.getType().slotCount < slotId) {
                String errorStr = "In function " + this.m_method.debugName + ", type " + baseType.getType().getName().format() + " does not have slot id " + String.valueOf(slotId);
                throw new Error(errorStr);
            }
            LLVMTamarinSlotLayout slotLayout = LLVMEmitter.this.m_slotLayoutCache.slotLayout(LLVMEmitter.this.m_module.m_module.getContext(), baseType.getType(), this.m_builtinClassesTypeProvider);
            Pair<List<Value>, TamarinSlotLayout.SlotStorageType> indexesAndSST = slotLayout.getGEPIndexes(LLVMEmitter.this.m_module.m_module.getContext(), slotId);
            assert (!baseType.getType().isAtom());
            BitCastInst castedBaseValue = bb.addInstruction(BitCastInst.class, baseValue, slotLayout.structPointerType());
            GetElementPtrInst slotAddr = bb.addGetElementPtr((Value)castedBaseValue, (List)indexesAndSST.fst);
            BitCastInst castedSlotAddr = bb.addInstruction(BitCastInst.class, slotAddr, ((LLVMEmitter)LLVMEmitter.this).m_module.types.charPtrTy);
            return castedSlotAddr;
        }

        private void emitGetSlot(BasicBlock bb, Expr e) {
            Expr base = e.args[0];
            Typeref baseType = this.typeref(base);
            int slotId = e.imm[0];
            Value slotAddr = this.getSlotAddress(bb, baseType, slotId, this.value(base));
            if (!baseType.nullable) {
                e.clearPx();
            }
            String stubSuffix = e.isPx() ? "" : "_nothrow";
            this.callFunction(e.opName() + stubSuffix, this.getVWT(e).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(slotAddr), this.getVWT(base).setTempl()}), bb, e);
        }

        private void emitSetSlot(BasicBlock bb, Expr e) {
            String stubSuffix;
            Expr base = e.args[0];
            Typeref baseType = this.typeref(base);
            int slotId = e.imm[0];
            Value slotAddr = this.getSlotAddress(bb, baseType, slotId, this.value(base));
            if (!baseType.nullable) {
                e.clearPx();
            }
            String string = stubSuffix = e.isPx() ? "" : "_nothrow";
            assert (baseType.getType().getSlotType(slotId).getType() == this.typeref(e.args[1]).getType());
            this.callFunction(e.opName() + stubSuffix, this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(slotAddr), this.getVWT(base).setTempl(), this.getVWT(e.args[1]).setTempl()}), bb, e);
        }

        private ValueWithTyperef[] getVWTs(Expr[] e, boolean isTempl) {
            ValueWithTyperef[] vwts = new ValueWithTyperef[e.length];
            for (int i = 0; i < e.length; ++i) {
                vwts[i] = isTempl ? this.getVWT(e[i]).setTempl() : this.getVWT(e[i]);
            }
            return vwts;
        }

        private ValueWithTyperef getVWT(Expr e) {
            return new ValueWithTyperef(this.value(e), this.llvmType(e), this.typeref(e));
        }

        private ValueWithTyperef getVWT(llvm.Type t) {
            return new ValueWithTyperef(t);
        }

        private ValueWithTyperef getVWT(Value v) {
            return new ValueWithTyperef(v);
        }

        private ValueWithTyperef getVWTInt(int v) {
            return new ValueWithTyperef(LLVMEmitter.this.constantInt(32L, v), new Typeref(BuiltinDomain.instance().INT, false));
        }

        private ValueWithTyperef getVWTNull(llvm.Type t) {
            Constant val = Constant.getNullValue(t);
            return this.getVWT(val);
        }

        private ValueWithTyperef getVWTString(byte[] bytes, boolean nullTerm) {
            ArrayList<Constant> constantBytes = new ArrayList<Constant>(bytes.length);
            for (byte b : bytes) {
                ConstantInt byteConstant = LLVMEmitter.this.constantInt(8L, b);
                constantBytes.add(byteConstant);
            }
            if (nullTerm) {
                constantBytes.add(LLVMEmitter.this.constantInt(8L, 0L));
            }
            Constant byteArray = LLVMEmitter.this.m_module.getConstantArray(constantBytes);
            GlobalVariable gvar = LLVMEmitter.this.m_module.createGlobal(".str", true, byteArray);
            Constant pchar = ConstantExpr.getCast(Instruction.CastOps.BitCast.swigValue(), gvar, ((LLVMEmitter)LLVMEmitter.this).m_module.types.charPtrTy);
            return new ValueWithTyperef(pchar);
        }

        private ValueWithTyperef getVWTString(String s) {
            byte[] bytes;
            try {
                bytes = s.getBytes("UTF8");
            }
            catch (UnsupportedEncodingException e) {
                bytes = s.getBytes();
            }
            return this.getVWTString(bytes, true);
        }

        private ValueWithTyperef getVWT(Typeref tr) {
            return new ValueWithTyperef(null, null, tr);
        }

        private ValueWithTyperef getVWTUint(long v) {
            return new ValueWithTyperef(LLVMEmitter.this.constantInt(32L, v), new Typeref(BuiltinDomain.instance().UINT, false));
        }

        private ValueWithTyperef getVWTName(Name n, boolean maybeUInt) {
            llvm.Type t = maybeUInt ? ((LLVMEmitter)LLVMEmitter.this).m_module.types.MultinameIndexMaybeUIntTy : ((LLVMEmitter)LLVMEmitter.this).m_module.types.MultinameIndexTy;
            return this.getVWT(Module.castIntToPointer(LLVMEmitter.this.constantInt(32L, this.nameId(n)), t)).setTempl();
        }

        private int cdeclType(Typeref tr) {
            if (this.boxed(tr)) {
                return this.kANY;
            }
            BuiltinDomain abcTypes = BuiltinDomain.instance();
            if (tr.t == abcTypes.ARRAY) {
                return this.kARRAY;
            }
            if (tr.t == abcTypes.BOOLEAN) {
                return this.kBOOLEAN;
            }
            if (tr.t == abcTypes.CLASS) {
                return this.kCLASS;
            }
            if (tr.t == abcTypes.FUNCTION) {
                return this.kFUNCTION;
            }
            if (tr.t == abcTypes.INT) {
                return this.kINT;
            }
            if (tr.t == abcTypes.NAMESPACE) {
                return this.kNAMESPACE;
            }
            if (tr.t == abcTypes.NUMBER) {
                return this.kNUMBER;
            }
            if (tr.t == abcTypes.STRING) {
                return this.kSTRING;
            }
            if (tr.t == abcTypes.UINT) {
                return this.kUINT;
            }
            return this.kOBJECT;
        }

        private ValueWithTyperef cdeclTypesArg(int[] types) {
            if (types.length <= 8) {
                long l = 0L;
                for (int type : types) {
                    l = l << 4 | (long)type;
                }
                return this.getVWTUint(l <<= 4 * (8 - types.length));
            }
            LinkedList<Byte> byteList = new LinkedList<Byte>();
            byte curByte = 0;
            for (int i = 0; i < types.length; ++i) {
                if ((i & 1) == 1) {
                    curByte = (byte)(curByte | types[i]);
                    byteList.add(curByte);
                    continue;
                }
                curByte = (byte)(types[i] << 4);
                if (i != types.length - 1) continue;
                byteList.add(curByte);
            }
            byte[] bytes = new byte[byteList.size()];
            int i = 0;
            Iterator i$ = byteList.iterator();
            while (i$.hasNext()) {
                byte b = (Byte)i$.next();
                bytes[i++] = b;
            }
            return this.getVWTString(bytes, (types.length & 1) == 0);
        }

        private ValueWithTyperef[] cdeclArgs(Expr[] e, boolean nullFirstArg) {
            int i;
            ValueWithTyperef[] result = new ValueWithTyperef[e.length + 1];
            int[] types = new int[e.length];
            for (i = 0; i < e.length; ++i) {
                types[i] = this.cdeclType(this.typeref(e[i]));
            }
            result[0] = this.cdeclTypesArg(types).setTempl();
            int n = i = nullFirstArg ? 1 : 0;
            while (i < e.length) {
                result[i + 1] = this.getVWT(e[i]);
                ++i;
            }
            if (nullFirstArg) {
                types[0] = this.kOBJECT;
                result[1] = this.getVWTNull(((LLVMEmitter)LLVMEmitter.this).m_module.types.ScriptObjectPtrTy);
            }
            return result;
        }

        private int nsId(Namespace ns) {
            int id = this.m_abc.nsPool.id(ns);
            if (id < 0) {
                throw new Error("Unable to get index for Namespace.");
            }
            return id;
        }

        private int nameId(Name n) {
            int id = this.m_abc.namePool.id(n);
            if (id < 0) {
                throw new Error("Unable to get index for Name.");
            }
            return id;
        }

        private int stringId(String s) {
            int id = this.m_abc.stringPool.id(s);
            if (id < 0) {
                throw new Error("Unable to get index for String.");
            }
            return id;
        }

        private void maybeBuildExceptBlock(Edge[] xsucc) {
            if (!this.m_xsuccsToXbb.containsKey(xsucc) && xsucc.length > 0) {
                BasicBlock origXbb;
                BasicBlock xbb = origXbb = this.m_function.addBlock("catch");
                ValueWithTyperef[] args = (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(this.m_exceptionFrame)});
                xbb.addInvoke(LLVMEmitter.this.m_module.m_module.getContext(), this.getFunction("beginCatch", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), args, xbb), this.m_throwAbortBlock, ValueWithTyperef.getValueArray(args), LLVMEmitter.this.useARMCallingConvention);
                InvokeInst xarg = xbb.addInvoke(LLVMEmitter.this.m_module.m_module.getContext(), this.getFunction("xarg", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.AtomTy).setTempl(), args, xbb), this.m_throwAbortBlock, ValueWithTyperef.getValueArray(args), LLVMEmitter.this.useARMCallingConvention);
                boolean catchAny = false;
                LinkedList<Constant> catchTypeIds = new LinkedList<Constant>();
                for (Edge e : xsucc) {
                    for (Handler h : this.m_method.handlers) {
                        User isType;
                        if (e.to != h.entry) continue;
                        LLVMEmitter.this.printErr("except: " + h.type.t.name.toString());
                        if (h.type.t == BuiltinDomain.instance().ANY) {
                            isType = LLVMEmitter.this.constantInt(32L, 1L);
                            catchAny = true;
                        } else {
                            Constant typeId = LLVMEmitter.this.getTypeId(h.type.t);
                            catchTypeIds.add(typeId);
                            ValueWithTyperef[] isTypeArgs = (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(typeId), this.getVWT(xarg).setTempl()});
                            isType = xbb.addInvoke(LLVMEmitter.this.m_module.m_module.getContext(), this.getFunction("istype", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.BooleanTy).setTempl(), isTypeArgs, xbb), this.m_throwAbortBlock, ValueWithTyperef.getValueArray(isTypeArgs), LLVMEmitter.this.useARMCallingConvention);
                            isType = xbb.addInstruction(PtrToIntInst.class, isType, ((LLVMEmitter)LLVMEmitter.this).m_module.types.intTy);
                        }
                        ICmpInst cond = xbb.addInstruction(ICmpInst.class, CmpInst.Predicate.ICMP_NE, isType, LLVMEmitter.this.constantInt(32L, 0L));
                        BasicBlock newBb = this.m_function.addBlock("not_" + h.type.t);
                        BasicBlock handlerBlock = this.m_function.addBlock("handler_" + h.type.t);
                        assert (!this.m_exceptEdges.containsKey(e));
                        this.m_exceptEdges.put(e, handlerBlock);
                        handlerBlock.addInvoke(LLVMEmitter.this.m_module.m_module.getContext(), this.getFunction("beginTry", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), args, xbb), this.m_throwAbortBlock, ValueWithTyperef.getValueArray(args), LLVMEmitter.this.useARMCallingConvention);
                        handlerBlock.addBranch(this.basicBlock(e.to));
                        xbb.addBranch(cond, handlerBlock, newBb);
                        xbb = newBb;
                    }
                }
                xbb.addBranch(this.m_rethrowBlock);
                this.m_xsuccsToXbb.put(xsucc, origXbb);
                if (this.m_xsuccsToExceptFilter != null) {
                    Constant exceptFilt;
                    if (catchAny) {
                        exceptFilt = LLVMEmitter.this.constantInt(32L, -1L);
                    } else if (catchTypeIds.size() == 0) {
                        exceptFilt = LLVMEmitter.this.constantInt(32L, 0L);
                    } else {
                        Constant nullTypeId = Constant.getNullValue(((LLVMEmitter)LLVMEmitter.this).m_module.types.TraitsIdTy);
                        catchTypeIds.add(nullTypeId);
                        Constant at = LLVMEmitter.this.m_module.getConstantArray(catchTypeIds);
                        GlobalVariable gt = LLVMEmitter.this.m_module.createGlobal(".exfilt", true, at);
                        exceptFilt = ConstantExpr.getPtrToInt(gt, ((LLVMEmitter)LLVMEmitter.this).m_module.types.intTy);
                    }
                    this.m_xsuccsToExceptFilter.put(xsucc, exceptFilt);
                }
            }
        }

        private boolean directCall(Expr e, BasicBlock bb) {
            Typeref tr;
            boolean found = false;
            if (e.args.length > 1 && e.ref != null && (tr = this.typeref(e.args[0])) != null) {
                String publicPrefix = "public::";
                String type = tr.toString();
                if (type.length() > 0 && type.startsWith("public::")) {
                    char lastChar = type.charAt(type.length() - 1);
                    boolean isClass = lastChar == '$';
                    type = lastChar == '$' || lastChar == '?' ? type.substring("public::".length(), type.length() - 1) : type.substring("public::".length());
                    String opName = type + "_" + e.ref.toString();
                    if (LLVMEmitter.this.m_directCalls.contains(opName)) {
                        if (this.getVWT(e).setTempl().getType().equals(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy)) {
                            return false;
                        }
                        found = true;
                        if (opName.equals("String_fromCharCode")) {
                            Expr[] fromCharCodeArgs = new Expr[e.args.length - 1];
                            System.arraycopy(e.args, 1, fromCharCodeArgs, 0, e.args.length - 1);
                            this.callFunctionVA(2, opName, this.getVWT(e).setTempl(), (ValueWithTyperef[])LLVMEmitter.concat(new ValueWithTyperef[][]{(ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue)}), this.cdeclArgs(fromCharCodeArgs, false)}), bb, e);
                        } else if (opName.equals("String_concat")) {
                            Expr[] concatArgs = new Expr[e.args.length - 1];
                            System.arraycopy(e.args, 1, concatArgs, 0, e.args.length - 1);
                            this.callFunctionVA(3, opName, this.getVWT(e).setTempl(), (ValueWithTyperef[])LLVMEmitter.concat(new ValueWithTyperef[][]{(ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(e.args[0]).setTempl()}), this.cdeclArgs(concatArgs, false)}), bb, e);
                        } else if (opName.equals("String_localeCompare")) {
                            Expr[] localeCompareArgs = new Expr[e.args.length - 2];
                            System.arraycopy(e.args, 2, localeCompareArgs, 0, e.args.length - 2);
                            this.callFunctionVA(4, opName, this.getVWT(e).setTempl(), (ValueWithTyperef[])LLVMEmitter.concat(new ValueWithTyperef[][]{(ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(e.args[0]).setTempl(), this.getVWT(e.args[1]).setTempl()}), this.cdeclArgs(localeCompareArgs, false)}), bb, e);
                        } else {
                            Integer extraParameter = isClass || type.equals("Math") ? 0 : 1;
                            this.runtimeMessage(type + "." + opName + " : " + " (arg count: " + e.args.length + ") <<<<\n", bb);
                            ValueWithTyperef[] argsArray = new ValueWithTyperef[e.args.length + extraParameter];
                            argsArray[0] = this.getVWT(this.m_methodEnvPtrValue);
                            Integer i = 1 - extraParameter;
                            while (i < e.args.length) {
                                argsArray[i.intValue() + extraParameter.intValue()] = this.getVWT(e.args[i]).setTempl();
                                i = i + 1;
                            }
                            this.callFunction(opName, this.getVWT(e).setTempl(), argsArray, bb, e);
                            this.runtimeMessage(e.toString() + " >>>>\n", bb);
                        }
                    }
                }
            }
            return found;
        }

        /*
         * Could not resolve type clashes
         */
        private void emitBlock(Block b, DebugState debugState) {
            boolean dielater = false;
            HashMap<Expr, Pair<AllocaInst, AllocaInst>> hasnext2AllocaMap = new HashMap<Expr, Pair<AllocaInst, AllocaInst>>();
            BasicBlock bb = this.basicBlock(b);
            if (this.m_bbToXsuccs != null) {
                this.maybeBuildExceptBlock(b.xsucc);
                this.m_bbToXsuccs.put(bb, b.xsucc);
            }
            boolean needToStoreExceptFilter = this.m_exceptFilterVar != null;
            for (Expr e : b) {
                Value val;
                if (e.op != 257 && needToStoreExceptFilter) {
                    needToStoreExceptFilter = false;
                    bb.addVolatileStore(this.getExceptFilter(bb), this.m_exceptFilterVar);
                }
                if (e.succ != null) break;
                if (LLVMEmitter.this.debugMessages) {
                    Typeref tr = this.typeref(e);
                    String msg = "opcode: " + e.opName() + " (" + e.op + ") " + (tr != null ? tr.toString() : "");
                    if (e.imm != null && e.imm.length > 0) {
                        msg = msg + ", imm: ";
                        for (int imm : e.imm) {
                            msg = msg + String.valueOf(imm) + ", ";
                        }
                    }
                    if (e.args.length > 0) {
                        msg = msg + ", args: ";
                        for (int a : (int[])e.args) {
                            tr = this.typeref((Expr)a);
                            msg = msg + a.opName() + " " + (tr != null ? tr.toString() : "") + ", ";
                        }
                    }
                    if (e.ref != null) {
                        msg = msg + ", ref: " + e.ref.toString();
                    }
                    LLVMEmitter.this.printMsg(msg);
                }
                if (e.op != 257 && e.op != 256) {
                    this.runtimeMessage("--- " + e.opName() + " " + e.toString() + "\n", bb);
                }
                switch (e.op) {
                    case 257: {
                        Typeref resultType = this.typeref(e);
                        llvm.Type resultLLVMType = LLVMEmitter.this.m_module.llvmType(resultType.t);
                        assert (e.pred.length == e.args.length);
                        PHINode phi = bb.addInstruction(PHINode.class, resultLLVMType);
                        this.m_exprToLLVMValue.put(e, phi);
                        break;
                    }
                    case 256: {
                        Value arg = this.m_function.arg(e.imm[0] + 1);
                        if (arg == null) {
                            arg = this.callFunction("loadundefined", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.AtomTy).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue)}), bb);
                        }
                        this.m_exprToLLVMValue.put(e, arg);
                        break;
                    }
                    case 134: {
                        this.callFunction(e.opName(), this.getVWT(e).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWTName(e.ref, false), this.getVWT(e.args[0]).setTempl()}), bb, e);
                        break;
                    }
                    case 83: {
                        Expr[] typeArgs = new Expr[e.args.length - 1];
                        System.arraycopy(e.args, 1, typeArgs, 0, typeArgs.length);
                        this.callFunctionVA(3, e.opName(), this.getVWT(e).setTempl(), (ValueWithTyperef[])LLVMEmitter.concat(new ValueWithTyperef[][]{(ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(e.args[0]).setTempl()}), this.cdeclArgs(typeArgs, false)}), bb, e);
                        break;
                    }
                    case 65: {
                        this.runtimeMessage(e.opName() + "<<<<\n", bb);
                        Expr[] callArgs = new Expr[e.args.length - 1];
                        System.arraycopy(e.args, 1, callArgs, 0, e.args.length - 1);
                        this.callFunctionVA(3, e.opName(), this.getVWT(e).setTempl(), (ValueWithTyperef[])LLVMEmitter.concat(new ValueWithTyperef[][]{(ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(e.args[0]).setTempl()}), this.cdeclArgs(callArgs, false)}), bb, e);
                        this.runtimeMessage(e.toString() + " >>>>\n", bb);
                        break;
                    }
                    case 70: 
                    case 76: 
                    case 79: {
                        if (this.directCall(e, bb)) break;
                        this.runtimeMessage(e.opName() + " : " + e.ref.toString() + " (arg count: " + e.args.length + ") <<<<\n", bb);
                        Pair<Expr[], ValueWithTyperef[]> argsPair = this.extractRuntimeNameArgs(bb, e, 1, false);
                        this.callFunctionVA(6, "callproperty", e.op == 79 ? this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy).setTempl() : this.getVWT(e).setTempl(), (ValueWithTyperef[])LLVMEmitter.concat(new ValueWithTyperef[][]{(ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue)}), (ValueWithTyperef[])argsPair.snd, (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(((Expr[])argsPair.fst)[0]).setTempl()}), this.cdeclArgs((Expr[])argsPair.fst, e.op == 76)}), bb, e);
                        this.runtimeMessage(e.toString() + " >>>>\n", bb);
                        break;
                    }
                    case 67: {
                        if (this.directCall(e, bb)) break;
                        this.runtimeMessage(e.opName() + "<<<<\n", bb);
                        this.callFunctionVA(4, e.opName(), this.getVWT(e).setTempl(), (ValueWithTyperef[])LLVMEmitter.concat(new ValueWithTyperef[][]{(ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(e.args[0]).setTempl(), this.getVWTInt(e.imm[0])}), this.cdeclArgs(e.args, false)}), bb, e);
                        this.runtimeMessage(e.toString() + " >>>>\n", bb);
                        break;
                    }
                    case 68: {
                        this.runtimeMessage(e.opName() + " : " + e.m.toString() + "<<<<\n", bb);
                        if (e.m.isNative()) {
                            if (!this.directCall(e, bb)) {
                                this.callFunctionVA(3, e.opName(), this.getVWT(e).setTempl(), (ValueWithTyperef[])LLVMEmitter.concat(new ValueWithTyperef[][]{(ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWTInt(this.m_abc.methodId(e.m))}), this.cdeclArgs(e.args, false)}), bb, e);
                            }
                        } else {
                            Function function = LLVMEmitter.this.getOrCreateFunctionForMethod(e.m);
                            Value env = this.callFunction("methodEnvFromIndex", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.MethodEnvPtrTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWTInt(this.m_abc.methodId(e.m))}), bb);
                            this.setCallAttrs(env, true, true, false);
                            Value[] args = new Value[e.args.length + 1];
                            args[0] = env;
                            for (int i = 0; i < e.args.length; ++i) {
                                args[i + 1] = this.value(e.args[i]);
                            }
                            Value result = this.callOrInvokeFunction(function, bb, args, e.isPx());
                            this.m_exprToLLVMValue.put(e, result);
                        }
                        this.runtimeMessage(e.toString() + " >>>>\n", bb);
                        break;
                    }
                    case 69: 
                    case 78: {
                        Pair<Expr[], ValueWithTyperef[]> argsPair = this.extractRuntimeNameArgs(bb, e, 1, false);
                        this.callFunctionVA(5, "callsuper", e.op == 78 ? this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy).setTempl() : this.getVWT(e).setTempl(), (ValueWithTyperef[])LLVMEmitter.concat(new ValueWithTyperef[][]{(ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue)}), (ValueWithTyperef[])argsPair.snd, this.cdeclArgs((Expr[])argsPair.fst, false)}), bb, e);
                        break;
                    }
                    case 128: {
                        this.m_exprToLLVMValue.put(e, this.emitCoerceIfNecessary(this.typeref(e), e.args[0], bb));
                        break;
                    }
                    case 130: 
                    case 137: {
                        this.callFunction(e.opName(), this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.AtomTy).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(e.args[0]).setTempl()}), bb, e);
                        break;
                    }
                    case 261: {
                        assert (e.castType.getType() == this.typeref(e).getType());
                        assert (e.isLegalUpCast(this.typeref(e.args[0])));
                        if (e.castType.getType() == this.typeref(e.args[0]).getType()) {
                            this.m_exprToLLVMValue.put(e, this.value(e.args[0]));
                            break;
                        }
                        this.callFunction(e.opName(), this.getVWT(e.castType).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(e.args[0]).setTempl()}), bb, e);
                        break;
                    }
                    case 178: {
                        this.callFunction(e.opName(), this.getVWT(e).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(LLVMEmitter.this.getTypeId(this.m_method.abc.domain().getNamedType(e.ref, true))), this.getVWT(e.args[0]).setTempl()}), bb, e);
                        break;
                    }
                    case 8: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 133: 
                    case 144: 
                    case 145: 
                    case 147: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 192: 
                    case 193: 
                    case 196: {
                        this.callFunction(e.opName(), this.getVWT(e).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(e.args[0]).setTempl()}), bb, e);
                        break;
                    }
                    case 74: {
                        Pair<Expr[], ValueWithTyperef[]> argsPair = this.extractRuntimeNameArgs(bb, e, 1, false);
                        this.callFunctionVA(5, e.opName(), this.getVWT(e).setTempl(), (ValueWithTyperef[])LLVMEmitter.concat(new ValueWithTyperef[][]{(ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue)}), (ValueWithTyperef[])argsPair.snd, this.cdeclArgs((Expr[])argsPair.fst, false)}), bb, e);
                        break;
                    }
                    case 66: {
                        Expr[] typeArgs = new Expr[e.args.length];
                        System.arraycopy(e.args, 0, typeArgs, 0, typeArgs.length);
                        this.callFunctionVA(3, e.opName(), this.getVWT(e).setTempl(), (ValueWithTyperef[])LLVMEmitter.concat(new ValueWithTyperef[][]{(ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(e.args[0]).setTempl()}), this.cdeclArgs(typeArgs, true)}), bb, e);
                        break;
                    }
                    case 73: {
                        Pair<Value, Value> atomArgs = this.emitAtomArgsArray(bb, e.args, false);
                        this.callFunction(e.opName(), this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT((Value)atomArgs.fst), this.getVWT((Value)atomArgs.snd)}), bb, e);
                        break;
                    }
                    case 239: {
                        if (!this.m_debugger) break;
                        debugState.locals.clear();
                        debugState.restore.clear();
                        if (e.imm[0] == 1) {
                            this.callFunction(e.opName(), this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWTUint(e.imm[0]), this.getVWTUint(this.stringId((String)e.value)), this.getVWTUint(e.imm[2]), this.getVWTUint(e.imm[3])}), bb);
                            break;
                        }
                        assert (false);
                        this.callFunction(e.opName(), this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWTUint(e.imm[0]), this.getVWTUint(e.imm[1]), this.getVWTUint(e.imm[2]), this.getVWTUint(e.imm[3])}), bb);
                        break;
                    }
                    case 241: {
                        String str;
                        debugState.fileName = str = (String)e.value;
                        if (!this.m_debugger) break;
                        this.callFunction(e.opName(), this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWTUint(this.stringId(str))}), bb);
                        break;
                    }
                    case 240: {
                        int lineNo;
                        debugState.lineNo = lineNo = e.imm[0];
                        if (this.m_debugger) {
                            Value called = this.callFunction(e.opName(), this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWTUint(lineNo)}), bb);
                            called.setName(new Twine(new JNIStringRef(this.getDebugName(debugState, "_______________________"))));
                            this.emitRestoreDebugInfo(bb, debugState);
                        }
                        this.runtimeMessage(debugState.fileName + " : " + String.valueOf(lineNo) + "\n", bb);
                        break;
                    }
                    case 6: {
                        assert (this.m_methodFrame != null);
                        this.callFunction(e.opName(), this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(this.m_methodFrame), this.getVWTUint(this.stringId((String)e.value))}), bb, e);
                        break;
                    }
                    case 7: {
                        assert (this.m_methodFrame != null);
                        this.callFunction(e.opName(), this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(this.m_methodFrame), this.getVWT(e.args[0]).setTempl()}), bb, e);
                        break;
                    }
                    case 95: {
                        this.callFunction(e.opName(), this.getVWT(e).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWTName(e.ref, false)}), bb, e);
                        break;
                    }
                    case 93: 
                    case 94: {
                        int withDepth = this.countWithScopes(e.scopes);
                        Pair<Expr[], ValueWithTyperef[]> argsPair = this.extractRuntimeNameArgs(bb, e, 0, false);
                        this.callFunction(e.opName(), this.getVWT(e).setTempl(), (ValueWithTyperef[])LLVMEmitter.concat(new ValueWithTyperef[][]{(ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue)}), (ValueWithTyperef[])argsPair.snd, (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_scopesValue), this.getVWTInt(e.scopes.length), this.getVWTInt(withDepth)})}), bb, e);
                        break;
                    }
                    case 89: {
                        Pair<Expr[], ValueWithTyperef[]> argsPair = this.extractRuntimeNameArgs(bb, e, 1, false);
                        this.callFunction(e.opName(), this.getVWT(e).setTempl(), (ValueWithTyperef[])LLVMEmitter.concat(new ValueWithTyperef[][]{(ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue)}), (ValueWithTyperef[])argsPair.snd, (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(e.args[0]).setTempl()})}), bb, e);
                        break;
                    }
                    case 100: {
                        this.callFunction(e.opName(), this.getVWT(e).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue)}), bb, e);
                        break;
                    }
                    case 103: {
                        this.callFunction(e.opName(), this.getVWT(e).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWTUint(e.imm[0])}), bb, e);
                        break;
                    }
                    case 108: {
                        this.emitGetSlot(bb, e);
                        break;
                    }
                    case 50: {
                        AllocaInst indexAlloca = bb.addInstruction(AllocaInst.class, ((LLVMEmitter)LLVMEmitter.this).m_module.types.intTy, LLVMEmitter.this.constantInt(32L, 1L));
                        AllocaInst objectAlloca = bb.addInstruction(AllocaInst.class, ((LLVMEmitter)LLVMEmitter.this).m_module.types.AtomTy, LLVMEmitter.this.constantInt(32L, 1L));
                        hasnext2AllocaMap.put(e, new Pair<AllocaInst, AllocaInst>(indexAlloca, objectAlloca));
                        Typeref objType = this.typeref(e.locals[0]);
                        if (LLVMEmitter.this.debugMessages) {
                            this.value(e.locals[0]).dump();
                            LLVMEmitter.this.printMsg(objType.getType().toString());
                        }
                        this.callFunction(e.opName(), this.getVWT(e).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(e.locals[0]).setTempl(), this.getVWT(e.locals[1]).setTempl(), this.getVWT(indexAlloca), this.getVWT(objectAlloca)}), bb, e);
                        break;
                    }
                    case 259: {
                        AllocaInst indexAlloca = (AllocaInst)((Pair)hasnext2AllocaMap.get((Object)e.args[0])).fst;
                        LoadInst indexValue = bb.addLoad(indexAlloca);
                        this.m_exprToLLVMValue.put(e, indexValue);
                        break;
                    }
                    case 260: {
                        assert (this.typeref((Expr)e).t.atom);
                        AllocaInst objectAlloca = (AllocaInst)((Pair)hasnext2AllocaMap.get((Object)e.args[0])).snd;
                        LoadInst objectValue = bb.addLoad(objectAlloca);
                        this.m_exprToLLVMValue.put(e, objectValue);
                        break;
                    }
                    case 87: {
                        this.callFunction(e.opName(), this.getVWT(e).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue)}), bb, e);
                        break;
                    }
                    case 90: {
                        Handler handler = this.m_method.handlers[e.imm[0]];
                        Name name = handler.name;
                        int name_id = name == null ? 0 : this.nameId(name);
                        int type_id = this.m_abc.typeRef(handler.type);
                        GlobalVariable u30TypeName = LLVMEmitter.this.m_module.createGlobal("newcatch_typeu30", false, this.u30ConstantArray(type_id));
                        Constant ptn = LLVMEmitter.this.m_module.getGetElementPtrConstantExpression((Constant)u30TypeName, 0, 0);
                        this.callFunction(e.opName(), this.getVWT(e).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWTInt(name_id), this.getVWT(ptn)}), bb, e);
                        break;
                    }
                    case 88: {
                        LLVMEmitter.this.referenceMethods(e.c);
                        LLVMEmitter.this.referenceMethods(e.c.itype);
                        int withScopes = this.countWithScopes(e.scopes);
                        Constant cTraitsId = LLVMEmitter.this.getTypeId(e.c);
                        Constant iTraitsId = LLVMEmitter.this.getTypeId(e.c.itype);
                        Constant scopeTraitsValue = this.getTypeIdsConstantArrayFromExpr(Arrays.asList(e.scopes));
                        GlobalVariable scopeTraitsGlobalValue = LLVMEmitter.this.m_module.createGlobal("abcClass_" + String.valueOf(this.m_abc.classId(e.c)) + "_scopeTraits", true, scopeTraitsValue);
                        Constant castedScopeTraitsGlobalValue = LLVMEmitter.this.m_module.getGetElementPtrConstantExpression((Constant)scopeTraitsGlobalValue, 0, 0);
                        assert (LLVMStubTypes.compareTypes(castedScopeTraitsGlobalValue.getType(), ((LLVMEmitter)LLVMEmitter.this).m_module.types.TraitsIdPtrTy));
                        this.callFunction(e.opName(), this.getVWT(e).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(cTraitsId), this.getVWT(iTraitsId), this.getVWT(castedScopeTraitsGlobalValue), this.getVWTUint(e.scopes.length), this.getVWTUint(withScopes), this.getVWT(this.m_scopesValue), this.getVWT(e.args[0]), this.getVWTUint(this.m_abc.classId(e.c))}), bb, e);
                        break;
                    }
                    case 64: {
                        assert (e.m.cx != null);
                        LLVMEmitter.this.referenceMethod(e.m, this.m_method.debugName);
                        int withScopes = this.countWithScopes(e.scopes);
                        Constant idForDeclaringTraits = LLVMEmitter.this.getTypeId(e.m.cx);
                        Constant castedScopeTraitsGlobalValue = null;
                        if (e.scopes.length > 0) {
                            Constant scopeTraitsValue = this.getTypeIdsConstantArrayFromExpr(Arrays.asList(e.scopes));
                            GlobalVariable scopeTraitsGlobalValue = LLVMEmitter.this.m_module.createGlobal("abcMethod_" + String.valueOf(this.m_abc.methodId(e.m)) + "_scopeTraits", true, scopeTraitsValue);
                            castedScopeTraitsGlobalValue = LLVMEmitter.this.m_module.getGetElementPtrConstantExpression((Constant)scopeTraitsGlobalValue, 0, 0);
                        } else {
                            castedScopeTraitsGlobalValue = Constant.getNullValue(((LLVMEmitter)LLVMEmitter.this).m_module.types.TraitsIdPtrTy);
                        }
                        assert (LLVMStubTypes.compareTypes(castedScopeTraitsGlobalValue.getType(), ((LLVMEmitter)LLVMEmitter.this).m_module.types.TraitsIdPtrTy));
                        this.callFunction("newfunction", this.getVWT(e).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(idForDeclaringTraits), this.getVWT(castedScopeTraitsGlobalValue), this.getVWTUint(e.scopes.length), this.getVWTUint(withScopes), this.getVWT(this.m_scopesValue), this.getVWTUint(this.m_abc.methodId(e.m))}), bb, e);
                        break;
                    }
                    case 85: 
                    case 86: {
                        this.callFunctionVA(2, e.opName(), this.getVWT(e).setTempl(), (ValueWithTyperef[])LLVMEmitter.concat(new ValueWithTyperef[][]{(ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue)}), this.cdeclArgs(e.args, false)}), bb, e);
                        break;
                    }
                    case 32: 
                    case 33: 
                    case 38: 
                    case 39: 
                    case 40: {
                        this.emitStaticLoad(bb, e, e.opName());
                        break;
                    }
                    case 258: {
                        this.callFunction(e.opName(), this.getVWT(e).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(this.m_exceptionFrame)}), bb, e);
                        break;
                    }
                    case 46: {
                        this.m_exprToLLVMValue.put(e, LLVMEmitter.this.constantInt(32L, (Long)e.value));
                        break;
                    }
                    case 36: 
                    case 37: 
                    case 45: {
                        LLVMEmitter.this.printErr("Loading integer: " + (Integer)e.value);
                        this.m_exprToLLVMValue.put(e, LLVMEmitter.this.constantInt(32L, ((Integer)e.value).intValue()));
                        break;
                    }
                    case 47: {
                        LLVMEmitter.this.printErr("Loading double: " + (Double)e.value);
                        assert (this.typeref(e).getType() == BuiltinDomain.instance().NUMBER);
                        this.m_exprToLLVMValue.put(e, bb.constantDouble(LLVMEmitter.this.m_module.m_module.getContext(), (Double)e.value));
                        break;
                    }
                    case 49: {
                        this.callFunction("loadnamespace", this.getVWT(e).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWTUint(this.nsId((Namespace)e.value))}), bb, e);
                        break;
                    }
                    case 28: 
                    case 48: {
                        this.callFunction(e.opName(), this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(e.args[0]).setTempl()}), bb, e);
                        Value scopeBoxedValue = this.emitValueBoxing(bb, e.args[0]);
                        int depth = LLVMEmitter.this.getScopeDepth(e) - 1;
                        Value[] indexes = new Value[]{LLVMEmitter.this.constantInt(32L, depth)};
                        GetElementPtrInst scopesStackTopValue = bb.addGetElementPtr(this.m_scopesValue, indexes);
                        bb.addStore(scopeBoxedValue, scopesStackTopValue);
                        this.m_exprToLLVMValue.put(e, this.value(e.args[0]));
                        if (this.m_debugVars == null) break;
                        GetElementPtrInst gep = bb.addGetElementPtr(this.m_debugVars, (Value[])LLVMEmitter.arr(new ConstantInt[]{LLVMEmitter.this.constantInt(32L, this.m_method.local_count + depth)}));
                        bb.addVolatileStore(scopeBoxedValue, gep);
                        break;
                    }
                    case 29: {
                        if (this.m_debugVars == null) break;
                        int depth = LLVMEmitter.this.getScopeDepth(e);
                        Value undef = this.callFunction("loadundefined", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.AtomTy).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue)}), bb);
                        GetElementPtrInst gep = bb.addGetElementPtr(this.m_debugVars, (Value[])LLVMEmitter.arr(new ConstantInt[]{LLVMEmitter.this.constantInt(32L, this.m_method.local_count + depth)}));
                        bb.addVolatileStore(undef, gep);
                        break;
                    }
                    case 44: {
                        LLVMEmitter.this.printErr("pushing string: " + (String)e.value + "\n");
                        this.callFunction("loadstring", this.getVWT(e).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWTUint(this.stringId((String)e.value))}), bb, e);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 97: 
                    case 102: 
                    case 104: 
                    case 106: {
                        boolean maybeUInt = e.op == 102 || e.op == 97 || e.op == 106;
                        Pair<Expr[], ValueWithTyperef[]> argsPair = this.extractRuntimeNameArgs(bb, e, 1, maybeUInt);
                        boolean isSetOrInit = e.op == 97 || e.op == 104 || e.op == 5;
                        this.callFunction(e.opName(), isSetOrInit ? this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy) : this.getVWT(e).setTempl(e.op != 106), (ValueWithTyperef[])LLVMEmitter.concat(new ValueWithTyperef[][]{(ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue)}), (ValueWithTyperef[])argsPair.snd, this.getVWTs((Expr[])argsPair.fst, true)}), bb, e);
                        break;
                    }
                    case 262: {
                        this.callFunction(e.opName(), this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(e.args[0]).setTempl(), this.getVWT(e.args[1]).setTempl()}), bb, e);
                        break;
                    }
                    case 109: {
                        this.emitSetSlot(bb, e);
                        break;
                    }
                    case 30: 
                    case 31: 
                    case 35: 
                    case 135: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: 
                    case 165: 
                    case 166: 
                    case 167: 
                    case 168: 
                    case 169: 
                    case 170: 
                    case 171: 
                    case 172: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 177: 
                    case 179: 
                    case 180: 
                    case 197: 
                    case 198: 
                    case 199: {
                        this.callFunction(e.opName(), this.getVWT(e).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(e.args[0]).setTempl(), this.getVWT(e.args[1]).setTempl()}), bb, e);
                        break;
                    }
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: {
                        this.callFunction(e.opName(), this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.voidTy), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(e.args[0]).setTempl(), this.getVWT(e.args[1]).setTempl()}), bb, e);
                        break;
                    }
                    case 42: {
                        this.m_exprToLLVMValue.put(e, this.value(e.locals[0]));
                        break;
                    }
                    default: {
                        LLVMEmitter.this.printErr("Failed to handle op: " + e.opName());
                        dielater = true;
                    }
                }
                if (this.m_debugVars != null && e.op != 257) {
                    Set<Expr> uses = this.m_exprUses.get(e);
                    for (Expr use : uses) {
                        if (use.op != 239 || use.imm[0] != 1) continue;
                        debugState.locals.add(new Pair<Expr, Expr>(use, e));
                    }
                    this.emitStoreDebugInfo(bb, debugState);
                }
                if ((val = this.m_exprToLLVMValue.get(e)) != null) {
                    val.setName(new Twine(new JNIStringRef(e.toString())));
                }
                if (val != null || e.op == 240) continue;
                LLVMEmitter.this.printErr("No value stored for expr...");
            }
            if (debugState.locals.size() > 0) {
                this.emitStoreDebugInfo(bb, debugState);
            }
            assert (!dielater);
        }

        private String getDebugName(DebugState debugState, String identifier) {
            String[] parts;
            String name = "dbg_";
            if (null != debugState.fileName && (parts = debugState.fileName.split("[;,/,\\\\]")).length > 0) {
                name = name + parts[parts.length - 1].replace('.', '_');
                name = name + "_";
                name = name + debugState.lineNo;
                name = name + "_";
            }
            name = name + identifier;
            return name;
        }

        private void emitStoreDebugInfo(BasicBlock bb, DebugState debugState) {
            Map<Expr, Value> oldExprToDebugValue = this.m_exprToDebugValue;
            this.m_exprToDebugValue = null;
            for (Pair<Expr, Expr> p : debugState.locals) {
                int n = this.m_method.params.length + ((Expr)p.fst).imm[2];
                if (n >= this.m_debugVarCount) continue;
                Expr e = (Expr)p.snd;
                Value v = this.emitValueBoxing(bb, e);
                v.setName(new Twine(new JNIStringRef(this.getDebugName(debugState, e.toString()))));
                GetElementPtrInst gep = bb.addGetElementPtr(this.m_debugVars, (Value[])LLVMEmitter.arr(new ConstantInt[]{LLVMEmitter.this.constantInt(32L, n)}));
                gep.setName(new Twine(new JNIStringRef(this.getDebugName(debugState, "stored_" + e.toString()))));
                bb.addVolatileStore(v, gep);
            }
            debugState.restore.clear();
            debugState.restore.addAll(debugState.locals);
            debugState.locals.clear();
            this.m_exprToDebugValue = oldExprToDebugValue;
        }

        private void emitRestoreDebugInfo(BasicBlock bb, DebugState debugState) {
            Map<Expr, Value> oldExprToDebugValue = this.m_exprToDebugValue;
            this.m_exprToDebugValue = null;
            for (Pair<Expr, Expr> p : debugState.restore) {
                int n = this.m_method.params.length + ((Expr)p.fst).imm[2];
                if (n >= this.m_debugVarCount) continue;
                Expr e = (Expr)p.snd;
                GetElementPtrInst gep = bb.addGetElementPtr(this.m_debugVars, (Value[])LLVMEmitter.arr(new ConstantInt[]{LLVMEmitter.this.constantInt(32L, n)}));
                gep.setName(new Twine(new JNIStringRef(this.getDebugName(debugState, "stored_" + e.toString()))));
                LoadInst loadInst = bb.addLoad(gep);
                loadInst.setVolatile(true);
                loadInst.setName(new Twine(new JNIStringRef(this.getDebugName(debugState, e.toString()))));
                ValueWithTyperef vwt = new ValueWithTyperef(loadInst, ((LLVMEmitter)LLVMEmitter.this).m_module.types.AtomTy, null);
                Value v = this.emitValueUnboxing(bb, e, vwt);
                v.setName(new Twine(new JNIStringRef(e.toString())));
                oldExprToDebugValue.put(e, v);
            }
            this.m_exprToDebugValue = oldExprToDebugValue;
            debugState.restore.clear();
        }

        private Constant u30ConstantArray(int v) {
            byte[] b = this.u30Bytes(v);
            ArrayList<Constant> l = new ArrayList<Constant>(b.length);
            for (int i = 0; i < b.length; ++i) {
                l.add(LLVMEmitter.this.constantInt(8L, b[i]));
            }
            return LLVMEmitter.this.m_module.getConstantArray(l);
        }

        private byte[] u30Bytes(int v) {
            ArrayList<Byte> l = new ArrayList<Byte>();
            if (v < 128 && v >= 0) {
                l.add((byte)v);
            } else if (v < 16384 && v >= 0) {
                l.add((byte)(v & 0x7F | 0x80));
                l.add((byte)(v >> 7));
            } else if (v < 0x200000 && v >= 0) {
                l.add((byte)(v & 0x7F | 0x80));
                l.add((byte)(v >> 7 | 0x80));
                l.add((byte)(v >> 14));
            } else if (v < 0x10000000 && v >= 0) {
                l.add((byte)(v & 0x7F | 0x80));
                l.add((byte)(v >> 7 | 0x80));
                l.add((byte)(v >> 14 | 0x80));
                l.add((byte)(v >> 21));
            } else {
                l.add((byte)(v & 0x7F | 0x80));
                l.add((byte)(v >> 7 | 0x80));
                l.add((byte)(v >> 14 | 0x80));
                l.add((byte)(v >> 21 | 0x80));
                l.add((byte)(v >> 28));
            }
            byte[] result = new byte[l.size()];
            int i = 0;
            for (Byte b : l) {
                result[i++] = b;
            }
            return result;
        }

        private Value emitCoerceIfNecessary(Typeref toType, Expr e, BasicBlock bb) {
            Typeref valType = this.typeref(e);
            LLVMEmitter.this.printErr("emitCoerceIfNecessary: " + valType.t.name + " -> " + toType.getType().name);
            Constant traitsId = LLVMEmitter.this.getTypeId(toType.t);
            assert (LLVMStubTypes.compareTypes(traitsId.getType(), ((LLVMEmitter)LLVMEmitter.this).m_module.types.TraitsIdTy));
            if (valType.t.isDerivedFrom(toType.t) && valType.t.isAtom() == toType.t.isAtom()) {
                return this.value(e);
            }
            return this.callFunction("coerce", this.getVWT(toType).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), this.getVWT(traitsId), this.getVWT(e).setTempl()}), bb);
        }

        private Pair<Expr[], ValueWithTyperef[]> extractRuntimeNameArgs(BasicBlock bb, Expr e, int offset, boolean maybeUInt) throws Error {
            int num = (e.ref.runtimeName() ? 1 : 0) + (e.ref.runtimeNamespace() ? 1 : 0);
            boolean runtimeName = e.ref.runtimeName();
            boolean runtimeNS = e.ref.runtimeNamespace();
            Expr nsExpr = runtimeNS ? e.args[offset] : null;
            Expr nameExpr = runtimeName ? e.args[offset + num - 1] : null;
            boolean bl = maybeUInt = maybeUInt && runtimeName;
            if (maybeUInt) {
                maybeUInt = false;
                assert (offset > 0);
                Expr objExpr = e.args[0];
                Type nameType = this.typeref(nameExpr).getType();
                llvm.Type objLLVMType = this.llvmType(objExpr);
                if (e.ref.runtimeName() && !e.ref.runtimeNamespace() && !e.ref.isAttr() && (nameType.numeric || nameType.atom) && nameType != BuiltinDomain.instance().BOOLEAN && e.ref.containsPublic() && (LLVMStubTypes.compareTypes(objLLVMType, ((LLVMEmitter)LLVMEmitter.this).m_module.types.ArrayObjectPtrTy) || LLVMStubTypes.compareTypes(objLLVMType, ((LLVMEmitter)LLVMEmitter.this).m_module.types.ScriptObjectPtrTy) || LLVMStubTypes.compareTypes(objLLVMType, ((LLVMEmitter)LLVMEmitter.this).m_module.types.AtomTy))) {
                    maybeUInt = true;
                }
            }
            ValueWithTyperef nameVWT = this.getVWTName(e.ref, maybeUInt);
            ValueWithTyperef unusedParam = this.getVWT(UndefValue.get(((LLVMEmitter)LLVMEmitter.this).m_module.types.UnsedParamTy)).setTempl();
            ValueWithTyperef[] vwts = new ValueWithTyperef[]{nameVWT, runtimeName ? this.getVWT(nameExpr).setTempl() : unusedParam, runtimeNS ? this.getVWT(nsExpr).setTempl() : unusedParam};
            Expr[] xs = new Expr[e.args.length - num];
            int x = 0;
            for (int i = 0; i < e.args.length; ++i) {
                if (i >= offset && i < offset + num) continue;
                xs[x++] = e.args[i];
            }
            return new Pair<Expr[], ValueWithTyperef[]>(xs, vwts);
        }

        private Pair<Value, Value> emitAtomArgsArray(BasicBlock bb, Expr[] args, boolean nullFirstArg) throws Error {
            ConstantInt nArgsValue = LLVMEmitter.this.constantInt(32L, args.length);
            AllocaInst argsAllocA = bb.addInstruction(AllocaInst.class, ((LLVMEmitter)LLVMEmitter.this).m_module.types.AtomTy, nArgsValue);
            for (int i = 0; i < args.length; ++i) {
                GetElementPtrInst gep = bb.addGetElementPtr((Value)argsAllocA, (Value[])LLVMEmitter.arr(new ConstantInt[]{LLVMEmitter.this.constantInt(32L, i)}));
                Value v = null;
                v = i == 0 && nullFirstArg ? this.emitValueBoxing(bb, this.getVWTNull(((LLVMEmitter)LLVMEmitter.this).m_module.types.ScriptObjectPtrTy)) : this.emitValueBoxing(bb, args[i]);
                bb.addStore(v, gep);
            }
            return new Pair<Value, Value>(argsAllocA, nArgsValue);
        }

        private final Value emitValueUnboxing(BasicBlock bb, Expr e, ValueWithTyperef vwt) {
            if (this.boxed(this.typeref(e)) || LLVMStubTypes.compareTypes(((LLVMEmitter)LLVMEmitter.this).m_module.types.AtomTy, this.llvmType(e))) {
                return vwt.getValue();
            }
            return this.callFunction("unbox", this.getVWT(e).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), ((ValueWithTyperef)vwt.clone()).setTempl()}), bb);
        }

        private final Value emitValueBoxing(BasicBlock bb, ValueWithTyperef vwt) {
            if (LLVMStubTypes.compareTypes(((LLVMEmitter)LLVMEmitter.this).m_module.types.AtomTy, vwt.getType())) {
                return vwt.getValue();
            }
            return this.callFunction("box", this.getVWT(((LLVMEmitter)LLVMEmitter.this).m_module.types.AtomTy).setTempl(), (ValueWithTyperef[])LLVMEmitter.arr(new ValueWithTyperef[]{this.getVWT(this.m_methodEnvPtrValue), ((ValueWithTyperef)vwt.clone()).setTempl()}), bb);
        }

        private final Value emitValueBoxing(BasicBlock bb, Expr e) {
            if (this.boxed(this.typeref(e))) {
                return this.value(e);
            }
            return this.emitValueBoxing(bb, this.getVWT(e));
        }

        private final boolean boxed(Typeref t) {
            if (t.exact && t.t == BuiltinDomain.instance().OBJECT) {
                return false;
            }
            return t.t.isAtom();
        }

        private Constant getTypeIdsConstantArrayFromExpr(Collection<Expr> exprs) {
            ArrayList<Constant> scopeTraits = new ArrayList<Constant>();
            for (Expr e : exprs) {
                scopeTraits.add(LLVMEmitter.this.getTypeId(this.typeref((Expr)e).t));
            }
            return LLVMEmitter.this.m_module.getConstantArray(scopeTraits);
        }

        private final int uniqueOp(Expr e) {
            if (e.op != 257) {
                return e.op;
            }
            int op = -1;
            HashSet<Expr> seen = new HashSet<Expr>();
            LinkedList<Expr> work = new LinkedList<Expr>();
            work.add(e);
            while (work.size() > 0) {
                Expr ec = (Expr)work.removeLast();
                if (seen.contains(ec)) continue;
                seen.add(ec);
                if (ec.op == 257) {
                    work.addAll(Arrays.asList(ec.args));
                    continue;
                }
                if (op == -1) {
                    op = ec.op;
                    continue;
                }
                if (op == ec.op) continue;
                return -1;
            }
            return op;
        }

        private final int countWithScopes(Expr[] scopes) {
            int i;
            int scopeDepth = scopes.length;
            for (i = 0; i < scopeDepth && this.uniqueOp(scopes[i]) == 48; ++i) {
            }
            assert (i == scopeDepth || this.uniqueOp(scopes[i]) == 28);
            return scopeDepth - i;
        }

        private String symbolName(Method m) {
            String idsString = m.id != -1 ? String.valueOf(this.m_abc.methodId(m)) + "_" + m.id + "_" : "";
            return "abcMethod_" + m.abc.scriptBaseName() + "_" + idsString + m.toString();
        }

        private class DebugState {
            public String fileName;
            public int lineNo;
            public List<Pair<Expr, Expr>> locals;
            public List<Pair<Expr, Expr>> restore;

            private DebugState() {
            }
        }
    }

    private static final class ValueWithTyperef
    implements Cloneable {
        private final Value _val;
        private final llvm.Type _t;
        private final Typeref _tref;
        private boolean _isTemplateParam;

        public ValueWithTyperef(Value v) {
            this._val = v;
            this._tref = null;
            this._t = v.getType();
            this._isTemplateParam = false;
        }

        public ValueWithTyperef(llvm.Type t) {
            this._val = null;
            this._tref = null;
            this._t = t;
            this._isTemplateParam = false;
        }

        public ValueWithTyperef(Value v, Typeref tr) {
            this._val = v;
            this._tref = tr;
            this._t = null;
            this._isTemplateParam = false;
        }

        public ValueWithTyperef(Value v, llvm.Type t, Typeref tr) {
            this._val = v;
            this._tref = tr;
            this._t = t;
            this._isTemplateParam = false;
        }

        public Object clone() {
            ValueWithTyperef vwt = new ValueWithTyperef(this._val, this._t, this._tref);
            vwt._isTemplateParam = this._isTemplateParam;
            return vwt;
        }

        public ValueWithTyperef setTempl() {
            return this.setTempl(true);
        }

        public ValueWithTyperef setTempl(boolean v) {
            this._isTemplateParam = v;
            return this;
        }

        public boolean isTempl() {
            return this._isTemplateParam;
        }

        public Value getValue() {
            return this._val;
        }

        public Typeref getTyperef() {
            return this._tref;
        }

        public llvm.Type getType() {
            return this._t;
        }

        public llvm.Type getEffectiveLLVMType(Module m) {
            if (this._t != null) {
                return this._t;
            }
            return m.llvmType(this.getTyperef().getType());
        }

        public static Value[] getValueArray(ValueWithTyperef[] xs) {
            Value[] result = new Value[xs.length];
            for (int i = 0; i < xs.length; ++i) {
                result[i] = xs[i].getValue();
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Module {
        private final llvm.Module m_module;
        private final boolean m_useARMCallingConvention;
        public final LLVMStubFunctions functions;
        public final LLVMStubTypes types;
        private Map<Type, llvm.Type> m_abcTypeToLLVMType;

        public Module(LLVMContext ctx, boolean useARMCallingConvention) {
            this(new llvm.Module(new JNIStringRef("empty module"), ctx), useARMCallingConvention);
        }

        private Module(llvm.Module m, boolean useARMCallingConvention) {
            this.m_useARMCallingConvention = useARMCallingConvention;
            this.m_module = m;
            this.functions = new LLVMStubFunctions(this);
            this.types = LLVMStubTypes.extract(this);
            assert (this.types != null);
            LLVMStubTypes.removeFromModule(this);
            this.m_abcTypeToLLVMType = null;
            this.createUnwindStub();
        }

        private void createUnwindStub() {
            FunctionType ft = Module.getFunctionType(this.types.voidTy, new llvm.Type[0], false);
            Function f = this.getOrCreateFunction("llvm_unwind", ft, this.m_useARMCallingConvention);
            BasicBlock bb = f.addBlock("entry");
            bb.addInstruction(UnwindInst.class, this.m_module.getContext());
        }

        Function getOrCreateFunction(String functionName, FunctionType functionType, boolean useARMCallingConvention) {
            return Function.getOrInsertFunction(this.m_module, functionName, functionType, useARMCallingConvention);
        }

        Function createInternalFunction(String functionName, FunctionType functionType, boolean useARMCallingConvention) {
            return Function.getOrInsertFunction(this.m_module, functionName, functionType, useARMCallingConvention);
        }

        Function getFunction(String functionName) {
            llvm.Function f = this.m_module.getFunction(new JNIStringRef(functionName));
            return f != null ? new Function(f) : null;
        }

        String getTypeName(llvm.Type t) {
            return this.m_module.getTypeName(t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static FunctionType getFunctionType(llvm.Type resultType, llvm.Type[] paramTypes, boolean varArg) {
            Type_vector tv = new Type_vector();
            try {
                for (llvm.Type t : paramTypes) {
                    tv.add(t);
                }
                FunctionType functionType = FunctionType.get(resultType, tv, varArg);
                return functionType;
            }
            finally {
                tv.delete();
            }
        }

        public Constant getGetElementPtrConstantExpression(Constant base, Integer ... indexes) {
            Constant[] indexConstants = new Constant[indexes.length];
            for (int i = 0; i < indexes.length; ++i) {
                indexConstants[i] = LLVMEmitter.constantInt(this.m_module.getContext(), 32L, indexes[i].intValue());
            }
            return this.getGetElementPtrConstantExpression(base, indexConstants);
        }

        private Constant getGetElementPtrConstantExpression(Constant base, Constant ... indexes) {
            return this.getGetElementPtrConstantExpression(base, Arrays.asList(indexes));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Constant getGetElementPtrConstantExpression(Constant base, Iterable<Constant> indexes) {
            Constant_vector indexesVector = new Constant_vector();
            try {
                for (Constant index : indexes) {
                    indexesVector.add(index);
                }
                Constant constant = ConstantExpr.getGetElementPtr(base, indexesVector);
                return constant;
            }
            finally {
                indexesVector.delete();
            }
        }

        public static Constant castIntToPointer(ConstantInt constInt, llvm.Type pointerType) {
            return ConstantExpr.getCast(Instruction.CastOps.IntToPtr.swigValue(), constInt, pointerType);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Module load(LLVMContext ctx, File f, boolean useARMCallingConvention) throws IOException {
            MemoryBuffer buff = null;
            try {
                buff = MemoryBuffer.getFile(new JNIStringRef(f.getCanonicalPath()));
                assert (buff != null);
                Module module = new Module(LLVM.ParseBitcodeFile(buff, ctx), useARMCallingConvention);
                return module;
            }
            finally {
                buff.delete();
            }
        }

        public void write(File f) throws IOException {
            LLVM.WriteModuleToFile(f.getCanonicalPath(), this.m_module);
        }

        public llvm.Function getLLVMFunction(String name) {
            return this.m_module.getFunction(new JNIStringRef(name));
        }

        public GlobalVariable getGlobal(String name, boolean allowInternal) {
            return this.m_module.getGlobalVariable(new JNIStringRef(name), allowInternal);
        }

        public GlobalVariable createGlobal(String name, boolean isConstant, llvm.Type t) {
            return GlobalVariable.Create(this.m_module, t, isConstant, GlobalValue.LinkageTypes.ExternalLinkage, null, name, null);
        }

        public GlobalVariable createGlobal(String name, boolean isConstant, Constant initializer) {
            return GlobalVariable.Create(this.m_module, initializer.getType(), isConstant, GlobalValue.LinkageTypes.ExternalLinkage, initializer, name, null);
        }

        public GlobalVariable setGlobal(boolean isConstant, Constant initializer, String name, boolean addBitCast) {
            GlobalVariable newGlobal;
            GlobalVariable existingGlobal = this.getGlobal(name, true);
            if (existingGlobal == null) {
                throw new Error("Unable to find global:" + name);
            }
            llvm.Type type = initializer.getType();
            Constant newGlobalAsConstant = newGlobal = GlobalVariable.Create(this.m_module, type, isConstant, GlobalValue.LinkageTypes.ExternalLinkage, initializer, "", null);
            if (addBitCast) {
                newGlobalAsConstant = ConstantExpr.getCast(Instruction.CastOps.BitCast.swigValue(), newGlobal, existingGlobal.getType());
            }
            existingGlobal.replaceAllUsesWith(newGlobalAsConstant);
            existingGlobal.eraseFromParent();
            newGlobal.setName(new Twine(new JNIStringRef(name)));
            return newGlobal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GlobalVariable setGlobalType(llvm.Type t, boolean isConstant, String name) {
            GlobalVariable existingGlobal = this.getGlobal(name, true);
            if (existingGlobal == null) {
                throw new Error("Unable to find global:" + name);
            }
            GlobalVariable newGlobal = GlobalVariable.Create(this.m_module, t, isConstant, GlobalValue.LinkageTypes.ExternalLinkage, null, "", null);
            Constant newGlobalAsConstant = ConstantExpr.getCast(Instruction.CastOps.BitCast.swigValue(), newGlobal, existingGlobal.getType());
            existingGlobal.replaceAllUsesWith(newGlobalAsConstant);
            existingGlobal.removeFromParent();
            try {
                newGlobal.setName(new Twine(existingGlobal.getName()));
                GlobalVariable globalVariable = newGlobal;
                return globalVariable;
            }
            finally {
                existingGlobal.delete();
            }
        }

        public Constant getConstantArrayOfZeros(llvm.Type t, int length) {
            Constant zero = Constant.getNullValue(t);
            ArrayList<Constant> zeroes = new ArrayList<Constant>();
            for (int i = 0; i < length; ++i) {
                zeroes.add(zero);
            }
            return this.getConstantArray(zeroes);
        }

        private static int swap(int value) {
            int b1 = value >> 0 & 0xFF;
            int b2 = value >> 8 & 0xFF;
            int b3 = value >> 16 & 0xFF;
            int b4 = value >> 24 & 0xFF;
            return b1 << 24 | b2 << 16 | b3 << 8 | b4 << 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Constant getConstantByteArray(byte[] bytes) {
            boolean bigEndian;
            boolean bl = bigEndian = this.m_module.getEndianness() == Module.Endianness.BigEndian;
            assert (bigEndian || this.m_module.getEndianness() == Module.Endianness.LittleEndian);
            int nInts = (bytes.length + 3) / 4;
            assert (nInts * 4 >= bytes.length);
            int[] ints = new int[nInts];
            if (bytes.length % 4 != 0) {
                byte[] newBytes = new byte[nInts * 4];
                System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
                bytes = newBytes;
            }
            int accumulator = 0;
            int accumulatorCount = 0;
            for (byte b : bytes) {
                accumulator <<= 8;
                accumulator |= b & 0xFF;
                if (++accumulatorCount % 4 != 0) continue;
                ints[accumulatorCount / 4 - 1] = bigEndian ? accumulator : Module.swap(accumulator);
                accumulator = 0;
            }
            assert (accumulatorCount % 4 == 0);
            Constant_vector valuesVector = new Constant_vector();
            try {
                for (int i : ints) {
                    valuesVector.add(LLVMEmitter.constantInt(this.m_module.getContext(), 32L, i));
                }
                ArrayType arrType = ArrayType.get(llvm.Type.getInt32Ty(this.m_module.getContext()), BigInteger.valueOf(nInts));
                Constant constant = ConstantArray.get(arrType, valuesVector);
                return constant;
            }
            finally {
                valuesVector.delete();
            }
        }

        public Constant getConstantArray(Collection<Constant> values) {
            ArrayType arrType = ArrayType.get(values.isEmpty() ? llvm.Type.getInt8Ty(this.m_module.getContext()) : values.iterator().next().getType(), BigInteger.valueOf(values.size()));
            return Module.getConstantArray(arrType, values);
        }

        private static Constant_vector makeConstantVector(Iterable<Constant> values) {
            Constant_vector valuesVector = new Constant_vector();
            try {
                for (Constant c : values) {
                    valuesVector.add(c);
                }
            }
            catch (Error e) {
                valuesVector.delete();
                throw e;
            }
            return valuesVector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Constant getConstantArray(ArrayType type, Collection<Constant> values) {
            Constant_vector valuesVector = Module.makeConstantVector(values);
            try {
                Constant constant = ConstantArray.get(type, valuesVector);
                return constant;
            }
            finally {
                valuesVector.delete();
            }
        }

        public static Constant getConstantStruct(StructType t, Constant ... memberValues) {
            return Module.getConstantStruct(t, Arrays.asList(memberValues));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Constant getConstantStruct(StructType t, Collection<Constant> memberValues) {
            Constant_vector valuesVector = Module.makeConstantVector(memberValues);
            try {
                Constant constant = ConstantStruct.get(t, valuesVector);
                return constant;
            }
            finally {
                valuesVector.delete();
            }
        }

        public llvm.Type llvmType(Type t) {
            llvm.Type result;
            if (t.isAtom()) {
                return this.types.AtomTy;
            }
            if (this.m_abcTypeToLLVMType == null) {
                this.m_abcTypeToLLVMType = new HashMap<Type, llvm.Type>();
                BuiltinDomain abcTypes = BuiltinDomain.instance();
                this.m_abcTypeToLLVMType.put(abcTypes.ARRAY, this.types.ArrayObjectPtrTy);
                this.m_abcTypeToLLVMType.put(abcTypes.BOOLEAN, this.types.BooleanTy);
                this.m_abcTypeToLLVMType.put(abcTypes.CLASS, this.types.ScriptObjectPtrTy);
                this.m_abcTypeToLLVMType.put(abcTypes.FUNCTION, this.types.ScriptObjectPtrTy);
                this.m_abcTypeToLLVMType.put(abcTypes.INT, this.types.intTy);
                this.m_abcTypeToLLVMType.put(abcTypes.NAMESPACE, this.types.NamespacePtrTy);
                this.m_abcTypeToLLVMType.put(abcTypes.NUMBER, this.types.NumberTy);
                this.m_abcTypeToLLVMType.put(abcTypes.QNAME, this.types.QNameObjectPtrTy);
                this.m_abcTypeToLLVMType.put(abcTypes.STRING, this.types.StringPtrTy);
                this.m_abcTypeToLLVMType.put(abcTypes.UINT, this.types.uintTy);
                this.m_abcTypeToLLVMType.put(abcTypes.XML, this.types.ScriptObjectPtrTy);
                this.m_abcTypeToLLVMType.put(abcTypes.XMLLIST, this.types.ScriptObjectPtrTy);
            }
            if ((result = this.m_abcTypeToLLVMType.get(t)) == null) {
                result = this.types.ScriptObjectPtrTy;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StructType structType(LLVMContext ctx, Iterable<llvm.Type> memberTypes, boolean isPacked) {
            Type_vector memberTypeVector = new Type_vector();
            try {
                for (llvm.Type memberType : memberTypes) {
                    memberTypeVector.add(memberType);
                }
                StructType structType = StructType.get(ctx, memberTypeVector, isPacked);
                return structType;
            }
            finally {
                memberTypeVector.delete();
            }
        }

        public llvm.Function[] getFunctions() {
            Function_vector fv = LLVM.toVector(this.m_module.getFunctionList());
            int size = (int)fv.size();
            llvm.Function[] a = new llvm.Function[size];
            for (int i = 0; i < size; ++i) {
                a[i] = fv.get(i);
            }
            fv.delete();
            return a;
        }

        public GlobalVariable[] getGlobals() {
            GlobalVariable_vector gv = LLVM.toVector(this.m_module.getGlobalList());
            int size = (int)gv.size();
            GlobalVariable[] g = new GlobalVariable[size];
            for (int i = 0; i < size; ++i) {
                g[i] = gv.get(i);
            }
            gv.delete();
            return g;
        }

        public Constant functionToCompiledHandler(Function f) {
            return ConstantExpr.getCast(Instruction.CastOps.BitCast.swigValue(), f.function(), this.types.CompiledHandlerPtrTy);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Function {
        private final llvm.Function m_function;

        public static Function getOrInsertFunction(llvm.Module module, String functionName, FunctionType functionType, boolean useARMCallingConvention) {
            llvm.Function f = llvm.Function.dyn_cast(GlobalValue.dyn_cast(module.getOrInsertFunction((StringRef)new JNIStringRef(functionName), functionType)));
            if (useARMCallingConvention) {
                LLVM.set_calling_convention_arm(f);
            }
            return new Function(f);
        }

        public static Function createInternalFunction(llvm.Module module, String functionName, FunctionType functionType, boolean useARMCallingConvention) {
            llvm.Function f = llvm.Function.Create(functionType, GlobalValue.LinkageTypes.InternalLinkage, new Twine(new JNIStringRef(functionName)));
            if (useARMCallingConvention) {
                LLVM.set_calling_convention_arm(f);
            }
            return new Function(f);
        }

        public static Function getFunction(Module m, String name) {
            return new Function(m.getLLVMFunction(name));
        }

        private Function(llvm.Function f) {
            this.m_function = f;
        }

        public BasicBlock addBlock() {
            return new BasicBlock(this.m_function, "");
        }

        public BasicBlock addBlock(String name) {
            return new BasicBlock(this.m_function, name);
        }

        public BasicBlock entryBlock() {
            return new BasicBlock(this.m_function.getEntryBlock());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Argument arg(int n) {
            Argument_vector args = LLVM.toVector(this.m_function.getArgumentList());
            try {
                if ((long)n < args.size()) {
                    Argument argument = args.get(n);
                    return argument;
                }
                Argument argument = null;
                return argument;
            }
            finally {
                args.delete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CallInst call(BasicBlock b, Iterable<Value> args, boolean useARMCallingConvention) {
            Value_vector argsVector = new Value_vector();
            try {
                for (Value arg : args) {
                    argsVector.add(arg);
                }
                CallInst ci = b.addInstruction(CallInst.class, this.m_function, argsVector);
                ci.setCallingConv(this.m_function.getCallingConv());
                CallInst callInst = ci;
                return callInst;
            }
            finally {
                argsVector.delete();
            }
        }

        public CallInst call(BasicBlock b, Value[] args, boolean useARMCallingConvention) {
            return this.call(b, Arrays.asList(args), useARMCallingConvention);
        }

        public llvm.Function function() {
            return this.m_function;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BasicBlock {
        private llvm.BasicBlock m_origBlock;
        private llvm.BasicBlock m_block;
        private JNIIRBuilder m_builder;

        public BasicBlock(llvm.Function function, String name) {
            this(llvm.BasicBlock.Create(function.getContext(), new Twine(new JNIStringRef(name)), function));
        }

        public BasicBlock(llvm.BasicBlock b) {
            this.m_builder = new JNIIRBuilder(b);
            this.m_origBlock = this.m_block = b;
        }

        private static java.lang.reflect.Method findJavaMethod(java.lang.reflect.Method[] methods, String name, Class<?> resultClass, Class<?>[] args) {
            for (java.lang.reflect.Method m : methods) {
                Class<?>[] methodArgs;
                if (!name.equals(m.getName()) || (methodArgs = m.getParameterTypes()).length != args.length) continue;
                boolean allMatch = true;
                for (int i = 0; allMatch && i < args.length; ++i) {
                    Class<?> methodArg = methodArgs[i];
                    Class<?> arg = args[i];
                    allMatch = methodArg.isAssignableFrom(arg);
                }
                if (!allMatch) continue;
                return m;
            }
            return null;
        }

        private static <T extends Instruction> Constructor<T> findConstructor(Constructor<T>[] constructors, Class<?>[] args) {
            for (Constructor<T> c : constructors) {
                Class<?>[] constructorArgs = c.getParameterTypes();
                if (constructorArgs.length != args.length) continue;
                boolean allMatch = true;
                for (int i = 0; allMatch && i < args.length; ++i) {
                    Class<?> constructorArg = constructorArgs[i];
                    Class<?> arg = args[i];
                    allMatch = constructorArg.isAssignableFrom(arg);
                }
                if (!allMatch) continue;
                return c;
            }
            return null;
        }

        public <T extends Instruction> T addInstruction(Class<T> theClass, Object ... args) {
            try {
                Instruction newInstruction;
                Class[] argTypes = new Class[args.length];
                for (int i = 0; i < args.length; ++i) {
                    argTypes[i] = args[i].getClass();
                }
                java.lang.reflect.Method createMethod = BasicBlock.findJavaMethod(theClass.getDeclaredMethods(), "Create", theClass, argTypes);
                if (createMethod != null) {
                    newInstruction = (Instruction)createMethod.invoke(null, args);
                } else {
                    Constructor<?> constructor = BasicBlock.findConstructor(theClass.getConstructors(), argTypes);
                    newInstruction = (Instruction)constructor.newInstance(args);
                }
                this.m_block.insert(newInstruction);
                return (T)newInstruction;
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GetElementPtrInst addGetElementPtr(Value aggValue, List<Value> indexes) {
            Value_vector indexesVector = new Value_vector();
            try {
                for (Value v : indexes) {
                    indexesVector.add(v);
                }
                GetElementPtrInst getElementPtrInst = this.addInstruction(GetElementPtrInst.class, aggValue, indexesVector, "");
                return getElementPtrInst;
            }
            finally {
                indexesVector.delete();
            }
        }

        public GetElementPtrInst addGetElementPtr(Value aggValue, Value[] indexes) {
            return this.addGetElementPtr(aggValue, Arrays.asList(indexes));
        }

        public LoadInst addLoad(Value ptr) {
            return LoadInst.Create(ptr, "", this.m_block);
        }

        public StoreInst addStore(Value val, Value ptr) {
            return StoreInst.Create(val, ptr, this.m_block);
        }

        public StoreInst addVolatileStore(Value val, Value ptr) {
            StoreInst result = this.addStore(val, ptr);
            result.setVolatile(true);
            return result;
        }

        public void addBranch(Value condition, BasicBlock target1, BasicBlock target2) {
            BranchInst.Create(target1.m_origBlock, target2.m_origBlock, condition, this.m_block);
        }

        public void addBranch(BasicBlock target) {
            BranchInst br = BranchInst.Create(target.m_origBlock);
            this.m_block.insert(br);
        }

        public void addDenseSwitch(LLVMContext ctx, Value val, BasicBlock defaultTarget, BasicBlock[] targets) {
            SwitchInst sw = SwitchInst.Create(val, defaultTarget.m_origBlock, (long)(targets.length + 1), this.m_block);
            for (int i = 0; i < targets.length; ++i) {
                sw.addCase(LLVMEmitter.constantInt(ctx, 32L, i), targets[i].m_origBlock);
            }
        }

        public ConstantFP constantDouble(LLVMContext ctx, double val) {
            return ConstantFP.get(ctx, new APFloat(val));
        }

        public void setPHIIncoming(PHINode phi, Value v) {
            phi.addIncoming(v, this.m_block);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InvokeInst addInvoke(LLVMContext ctx, Function f, BasicBlock except, Iterable<Value> args, boolean useARMCallingConvention) {
            Value_vector argsVector = new Value_vector();
            try {
                for (Value arg : args) {
                    argsVector.add(arg);
                }
                llvm.BasicBlock normal = llvm.BasicBlock.Create(ctx, new Twine(new JNIStringRef("invoke_norm")), this.m_block.getParent());
                InvokeInst i = this.addInstruction(InvokeInst.class, f.function(), normal, except.m_origBlock, argsVector);
                i.setCallingConv(f.m_function.getCallingConv());
                this.m_block = normal;
                InvokeInst invokeInst = i;
                return invokeInst;
            }
            finally {
                argsVector.delete();
            }
        }

        public InvokeInst addInvoke(LLVMContext ctx, Function f, BasicBlock except, Value[] args, boolean useARMCallingConvention) {
            return this.addInvoke(ctx, f, except, Arrays.asList(args), useARMCallingConvention);
        }

        public boolean hasNUses(long n) {
            return this.m_origBlock.hasNUses(n);
        }

        public void eraseFromParent() {
            this.m_origBlock.eraseFromParent();
            this.m_origBlock = null;
        }
    }
}

