/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.Binding;
import adobe.abc.BuiltinDomain;
import adobe.abc.GlobalOptimizer;
import adobe.abc.Name;
import adobe.abc.Namespace;
import adobe.abc.Pair;
import adobe.abc.Symtab;
import adobe.abc.Type;
import adobe.abc.Typeref;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Domain {
    private final Domain m_base;
    private final Symtab<Type> m_namedTypes;
    private final Symtab<Typeref> m_namedScripts;
    protected boolean m_throwOnFailedLookup;
    private final Map<Type, Set<Type>> m_parameterizedTypesInstances;
    private final Map<Type, Type> m_parameterizedITypeToCType;

    public Domain() {
        this(false);
    }

    public Domain(boolean throwOnFailedLookup) {
        this(null, throwOnFailedLookup, new HashMap<Type, Set<Type>>());
    }

    public Domain(Domain base, boolean throwOnFailedLookup) {
        this(base, throwOnFailedLookup, base.m_parameterizedTypesInstances);
    }

    private Domain(Domain base, boolean throwOnFailedLookup, Map<Type, Set<Type>> parameterizedTypeInstances) {
        this.m_base = base;
        this.m_namedTypes = new Symtab();
        this.m_namedScripts = new Symtab();
        this.m_throwOnFailedLookup = throwOnFailedLookup;
        this.m_parameterizedTypesInstances = parameterizedTypeInstances;
        this.m_parameterizedITypeToCType = new HashMap<Type, Type>();
    }

    public Type getNamedType(Name n, boolean recursive) {
        Type result = null;
        if (this.m_base != null && recursive) {
            result = this.m_base.getNamedType(n, true);
        }
        if (result == null) {
            result = this.m_namedTypes.get(n);
            assert (result == null || n.match(result.getName()));
        }
        return result;
    }

    public Typeref getNamedScript(Name n) {
        Typeref result = null;
        if (this.m_base != null) {
            result = this.m_base.getNamedScript(n);
        }
        if (result == null) {
            result = this.m_namedScripts.get(n);
        }
        return result;
    }

    public Name getDefinitionName(Name n) {
        return this.m_namedScripts.getName(n);
    }

    public boolean isNamedScript(Name n) {
        return this.m_base != null && this.m_base.isNamedScript(n) || this.m_namedScripts.contains(n);
    }

    public void addNamedType(Type t) {
        this.m_namedTypes.put(t.getName(), t);
    }

    public void addNamedScript(Name n, Typeref t) {
        assert (t.exact && !t.nullable);
        this.m_namedScripts.put(n, t);
    }

    private Type resolveParameterizedType(Name n) {
        Type parameterType;
        assert (n.isParameterizedTypeName());
        Type parameterizedType = this.resolveTypeName(n.getParameterizedTypeName(), null, true);
        assert (parameterizedType != null);
        Type type = n.getTypeParamName() == Name.ANY ? BuiltinDomain.instance().ANY : (parameterType = this.resolveTypeName(n.getTypeParamName(), this.m_throwOnFailedLookup ? null : BuiltinDomain.instance().OBJECT));
        assert (parameterType != null);
        Type result = new Type(n, parameterizedType, new Type[]{parameterType});
        Type resultCType = new Type(n.append("$"), BuiltinDomain.instance().CLASS);
        resultCType.itype = result;
        assert (this.getNamedType(result.name, true) == null);
        this.addNamedType(result);
        assert (this.getCType(result.name) == null);
        this.m_parameterizedITypeToCType.put(result, resultCType);
        assert (this.getNamedType(n, false) == result);
        assert (this.getCType(result.name) == resultCType);
        Set<Type> instances = this.m_parameterizedTypesInstances.get(parameterizedType);
        if (instances == null) {
            instances = new HashSet<Type>();
            this.m_parameterizedTypesInstances.put(parameterizedType, instances);
        }
        instances.add(result);
        return result;
    }

    public Type resolveTypeName(Name n, Type base) {
        return this.resolveTypeName(n, base, false);
    }

    private Pair<Type, Binding> getClassBinding(Type iType) {
        Name exactName = iType.getName();
        Typeref scriptTypeRef = this.getNamedScript(exactName);
        if (scriptTypeRef == null) {
            return null;
        }
        assert (!iType.isParameterizedTypeInstance());
        Type scriptType = scriptTypeRef.t;
        Binding classBinding = scriptType.find(exactName);
        assert (classBinding.isClass());
        assert (classBinding.type != null);
        return new Pair<Type, Binding>(scriptType, classBinding);
    }

    public GlobalOptimizer.Metadata[] getClassMetadata(Name n) {
        Type iType = this.getNamedType(n, true);
        if (iType == null) {
            return null;
        }
        Pair<Type, Binding> scriptAndBinding = this.getClassBinding(iType);
        if (scriptAndBinding == null) {
            assert (iType.isParameterizedTypeInstance());
            return null;
        }
        return ((Binding)scriptAndBinding.snd).md;
    }

    private Type getCType(Name n) {
        Type result;
        Type iType = this.getNamedType(n, true);
        if (iType == null) {
            return null;
        }
        Pair<Type, Binding> scriptAndBinding = this.getClassBinding(iType);
        if (scriptAndBinding != null) {
            result = ((Binding)scriptAndBinding.snd).type.t;
        } else {
            assert (iType.isParameterizedTypeInstance());
            Domain d = this;
            result = null;
            while (d != null && result == null) {
                result = d.m_parameterizedITypeToCType.get(iType);
                d = d.m_base;
            }
        }
        assert (result == null || result.itype == iType);
        return result;
    }

    public Type resolveCType(Name n) {
        Type result = this.getCType(n);
        if (result == null) {
            this.resolveTypeName(n, null, true);
            result = this.getCType(n);
            assert (result != null);
        }
        return result;
    }

    private Type resolveTypeName(Name n, Type base, boolean forceThrowOnFailedLookup) {
        Type t = this.getNamedType(n, true);
        if (t == null) {
            if (n.isParameterizedTypeName()) {
                t = this.resolveParameterizedType(n);
                assert (t != null);
                return t;
            }
            if (this.m_throwOnFailedLookup || forceThrowOnFailedLookup) {
                throw new Error("Unable to find named traits: " + n.format());
            }
            Name n2 = new Name(7, new Namespace(22, ""), n.name);
            t = this.getNamedType(n2, true);
            if (t == null) {
                t = new Type(n2, base);
                this.addNamedType(t);
            }
        }
        return t;
    }

    public boolean containsNamedType(Type at) {
        return this.containsNamedType(at.getName());
    }

    public boolean containsNamedType(Name n) {
        return this.m_namedTypes.contains(n);
    }

    public Map<Type, Set<Type>> parameterizedTypesInstances() {
        return this.m_parameterizedTypesInstances;
    }
}

