/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.Domain;
import adobe.abc.Name;
import adobe.abc.OptimizerConstants;
import adobe.abc.Type;
import java.util.HashSet;
import java.util.Set;

public class BuiltinDomain
extends Domain {
    public Type OBJECT;
    public Type FUNCTION;
    public Type CLASS;
    public Type ARRAY;
    public Type INT;
    public Type UINT;
    public Type NUMBER;
    public Type BOOLEAN;
    public Type STRING;
    public Type NAMESPACE;
    public Type XML;
    public Type XMLLIST;
    public Type QNAME;
    public Type NULL;
    public Type VOID;
    public Type ANY;
    public Set<Type> builtinTypes = new HashSet<Type>();
    public Set<Type> baseTypes = new HashSet<Type>();
    private static final BuiltinDomain the_instance = new BuiltinDomain();

    public static BuiltinDomain instance() {
        return the_instance;
    }

    public Type ANY() {
        if (null == this.ANY) {
            this.ANY = new Type(Name.ANY, null);
        }
        return this.ANY;
    }

    private Type resolveTypeName(String name, Type base) {
        return this.resolveTypeName(new Name(Name.PKG_PUBLIC, name), base);
    }

    private Type resolveTypeName(String name) {
        return this.resolveTypeName(name, this.OBJECT);
    }

    void setupBuiltins() {
        assert (null == this.OBJECT);
        this.OBJECT = this.getNamedType(new Name(Name.PKG_PUBLIC, "Object"), false);
        assert (null != this.OBJECT);
        Name nameForNULL = new Name(Name.PKG_PUBLIC, "null");
        this.NULL = new Type.StringValueIsName(nameForNULL, this.OBJECT);
        this.addNamedType(this.NULL);
        assert (this.resolveTypeName("null") == this.NULL);
        this.CLASS = this.resolveTypeName("Class");
        this.FUNCTION = this.resolveTypeName("Function");
        this.ARRAY = this.resolveTypeName("Array");
        this.INT = this.resolveTypeName("int");
        this.UINT = this.resolveTypeName("uint");
        this.NUMBER = this.resolveTypeName("Number");
        this.BOOLEAN = this.resolveTypeName("Boolean");
        this.STRING = this.resolveTypeName("String");
        this.NAMESPACE = this.resolveTypeName("Namespace");
        this.XML = this.resolveTypeName("XML");
        this.XMLLIST = this.resolveTypeName("XMLList");
        this.QNAME = this.resolveTypeName("QName");
        Name nameForVOID = new Name(Name.PKG_PUBLIC, "void");
        this.VOID = new Type(nameForVOID, null);
        this.addNamedType(this.VOID);
        assert (this.resolveTypeName("void") == this.VOID);
        this.BOOLEAN.numeric = true;
        this.UINT.numeric = true;
        this.NUMBER.numeric = true;
        this.INT.numeric = true;
        this.BOOLEAN.primitive = true;
        this.STRING.primitive = true;
        this.UINT.primitive = true;
        this.NUMBER.primitive = true;
        this.INT.primitive = true;
        this.NULL.primitive = true;
        this.VOID.primitive = true;
        this.VOID.atom = true;
        this.OBJECT.atom = true;
        this.ANY.atom = true;
        this.INT.ref = this.INT.ref.nonnull();
        this.NUMBER.ref = this.NUMBER.ref.nonnull();
        this.UINT.ref = this.UINT.ref.nonnull();
        this.BOOLEAN.ref = this.BOOLEAN.ref.nonnull();
        this.OBJECT.defaultValue = this.NULL;
        this.NULL.defaultValue = this.NULL;
        this.ANY.defaultValue = OptimizerConstants.UNDEFINED;
        this.VOID.defaultValue = OptimizerConstants.UNDEFINED;
        this.BOOLEAN.defaultValue = Boolean.FALSE;
        this.STRING.defaultValue = this.NULL;
        this.NAMESPACE.defaultValue = this.NULL;
        this.NUMBER.defaultValue = OptimizerConstants.NAN;
        this.INT.defaultValue = 0;
        this.UINT.defaultValue = 0;
        this.builtinTypes.add(this.CLASS);
        this.builtinTypes.add(this.FUNCTION);
        this.builtinTypes.add(this.ARRAY);
        this.builtinTypes.add(this.INT);
        this.builtinTypes.add(this.UINT);
        this.builtinTypes.add(this.NUMBER);
        this.builtinTypes.add(this.BOOLEAN);
        this.builtinTypes.add(this.STRING);
        this.builtinTypes.add(this.NAMESPACE);
        this.builtinTypes.add(this.XML);
        this.builtinTypes.add(this.XMLLIST);
        this.builtinTypes.add(this.QNAME);
        this.builtinTypes.add(this.VOID);
    }

    public void enabledFailedLookupExceptions() {
        this.m_throwOnFailedLookup = true;
    }

    public boolean isXmlBase(Type t) {
        return t.extendsOrIsBase(this.XML) || t.extendsOrIsBase(this.XMLLIST) || t == this.ANY || t == this.OBJECT;
    }
}

