/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.Algorithms;
import adobe.abc.Edge;
import adobe.abc.Expr;
import adobe.abc.Method;
import adobe.abc.OptimizerConstants;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Block
implements Iterable<Expr>,
Comparable<Block> {
    public Algorithms.Deque<Expr> exprs = new Algorithms.ArrayDeque<Expr>();
    private Set<Expr> live_out = new HashSet<Expr>();
    public int id;
    public int postorder;
    public Edge[] xsucc = OptimizerConstants.noedges;
    boolean must_isolate_block = false;
    boolean is_backwards_branch_target = false;

    public Block(Method m) {
        this.id = m.getNextBlockId();
    }

    public void appendExpr(Expr e) {
        if (this.exprs.peekLast().succ != null) {
            Expr last = this.exprs.removeLast();
            this.exprs.add(e);
            this.exprs.add(last);
        } else {
            this.exprs.add(e);
        }
    }

    public void insertExprs(Expr before, Iterable<Expr> i) {
        if (this.exprs.peekLast() == before) {
            for (Expr e : i) {
                this.appendExpr(e);
            }
        } else {
            Algorithms.ArrayDeque<Expr> newExprs = new Algorithms.ArrayDeque<Expr>();
            for (Expr te : this.exprs) {
                if (te == before) {
                    assert (i != null);
                    for (Expr e : i) {
                        newExprs.add(e);
                    }
                    i = null;
                }
                newExprs.add(te);
            }
            assert (i == null);
            this.exprs = newExprs;
        }
    }

    public void insertExpr(Expr before, Expr e) {
        if (this.exprs.peekLast() == before) {
            this.appendExpr(e);
        } else {
            Algorithms.ArrayDeque<Expr> newExprs = new Algorithms.ArrayDeque<Expr>();
            for (Expr te : this.exprs) {
                if (te == before) {
                    assert (e != null);
                    newExprs.add(e);
                    e = null;
                }
                newExprs.add(te);
            }
            assert (e == null);
            this.exprs = newExprs;
        }
    }

    public void insertExprAfter(Expr after, Expr e) {
        Algorithms.ArrayDeque<Expr> newExprs = new Algorithms.ArrayDeque<Expr>();
        int lastOp = 257;
        assert (e != null);
        for (Expr te : this.exprs) {
            if (te.op == 257 && lastOp != 257) {
                Expr last = (Expr)newExprs.removeLast();
                newExprs.add(te);
                newExprs.add(last);
            } else {
                newExprs.add(te);
                lastOp = te.op;
            }
            if (te != after) continue;
            assert (e != null);
            newExprs.add(e);
            lastOp = e.op;
            e = null;
        }
        assert (e == null);
        this.exprs = newExprs;
    }

    public void killRegister(Method m, int regnum) {
        this.appendExpr(new Expr(m, 8, -1, regnum));
    }

    public String toString() {
        return 'B' + String.valueOf(this.id);
    }

    public Expr first() {
        return this.exprs.peekFirst();
    }

    public Expr firstNonPhi() {
        for (Expr e : this) {
            if (e.op == 257) continue;
            return e;
        }
        return null;
    }

    public Expr last() {
        return this.exprs.peekLast();
    }

    public Edge[] succ() {
        if (this.last().succ != null) {
            return this.last().succ;
        }
        return OptimizerConstants.noedges;
    }

    @Override
    public Iterator<Expr> iterator() {
        return this.exprs.iterator();
    }

    public void add(Expr e) {
        this.exprs.add(e);
    }

    void addAll(Block b) {
        this.exprs.addAll(b.exprs);
    }

    public boolean isEmpty() {
        return this.exprs.isEmpty();
    }

    public int size() {
        return this.exprs.size();
    }

    public void remove(Expr e) {
        this.exprs.remove(e);
    }

    @Override
    public int compareTo(Block b) {
        return this.id - b.id;
    }

    public void addLiveOut(Expr e) {
        assert (this.exprs.contains(e));
        this.live_out.add(e);
    }

    public Set<Expr> getLiveOut() {
        return this.live_out;
    }
}

