/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.Block;
import adobe.abc.Edge;
import adobe.abc.Expr;
import adobe.abc.Method;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Algorithms {
    public static Set<Integer> foreach(BitSet x) {
        TreeSet<Integer> result = new TreeSet<Integer>();
        for (int i = 0; i < x.length(); ++i) {
            if (!x.get(i)) continue;
            result.add(i);
        }
        return result;
    }

    public static Map<Block, Block> idoms(Deque<Block> all, SetMap<Block, Edge> pred) {
        boolean changed;
        Block entry = all.peekFirst();
        Block[] doms = new Block[entry.postorder + 1];
        doms[entry.postorder] = entry;
        do {
            changed = false;
            for (Block b : all) {
                Block p;
                if (b == entry) continue;
                Block new_idom = null;
                for (Edge e : pred.get(b)) {
                    p = e.from;
                    if (doms[p.postorder] == null) continue;
                    new_idom = p;
                    break;
                }
                for (Edge e : pred.get(b)) {
                    p = e.from;
                    if (p == new_idom || doms[p.postorder] == null) continue;
                    new_idom = Algorithms.intersect(p, new_idom, doms);
                }
                if (doms[b.postorder] == new_idom) continue;
                doms[b.postorder] = new_idom;
                changed = true;
            }
        } while (changed);
        TreeMap<Block, Block> map = new TreeMap<Block, Block>();
        for (Block b : all) {
            if (b == entry) continue;
            map.put(b, doms[b.postorder]);
        }
        return map;
    }

    public static Block intersect(Block b1, Block b2, Block[] doms) {
        while (b1 != b2) {
            while (b1.postorder < b2.postorder) {
                b1 = doms[b1.postorder];
            }
            while (b2.postorder < b1.postorder) {
                b2 = doms[b2.postorder];
            }
        }
        return b1;
    }

    public static boolean dominates(Block p, Block s, Map<Block, Block> idom) {
        Block b = s;
        while (b != null) {
            if (b == p) {
                return true;
            }
            b = idom.get(b);
        }
        return false;
    }

    public static SetMap<Block, Edge> preds(Deque<Block> code) {
        SetMap<Block, Edge> pred = new SetMap<Block, Edge>();
        for (Block b : code) {
            for (Edge s : b.succ()) {
                pred.get(s.to).add(s);
            }
        }
        return pred;
    }

    static void checkPredecessors(SetMap<Block, Edge> pred, Deque<Block> code) {
        block0: for (Block b : code) {
            for (Expr e : b) {
                if (e.op != 257) continue block0;
                TreeSet<Edge> phi_in = new TreeSet<Edge>();
                for (Edge p : e.pred) {
                    phi_in.add(p);
                }
                Set<Edge> blk_in = pred.get(b);
                assert (((Object)phi_in).equals(blk_in));
            }
        }
    }

    static SetMap<Block, Edge> allpreds(Deque<Block> code) {
        SetMap<Block, Edge> pred = new SetMap<Block, Edge>();
        for (Block b : code) {
            for (Edge s : b.succ()) {
                pred.get(s.to).add(s);
            }
            for (Edge x : b.xsucc) {
                pred.get(x.to).add(x);
            }
        }
        return pred;
    }

    public static EdgeMap<Expr> findUses(Deque<Block> code) {
        EdgeMap<Expr> uses = new EdgeMap<Expr>();
        for (Block b : code) {
            for (Expr e : b) {
                for (Expr a : e.args) {
                    uses.get(a).add(e);
                }
                for (Expr a : e.locals) {
                    uses.get(a).add(e);
                }
                for (Expr a : e.scopes) {
                    uses.get(a).add(e);
                }
            }
        }
        return uses;
    }

    private static void dfs_visit_el(Edge[] el, BitSet visited, Deque<Block> list) {
        for (int i = el.length - 1; i >= 0; --i) {
            Algorithms.dfs_visit(el[i].to, visited, list);
        }
    }

    private static Deque<Block> dfs_visit(Block b, BitSet visited, Deque<Block> list) {
        if (!visited.get(b.id)) {
            visited.set(b.id);
            Algorithms.dfs_visit_el(b.xsucc, visited, list);
            Algorithms.dfs_visit_el(b.succ(), visited, list);
            b.postorder = list.size();
            list.addFirst(b);
        }
        return list;
    }

    public static Deque<Block> dfs(Block entry) {
        return Algorithms.dfs_visit(entry, new BitSet(), new LinkedDeque<Block>());
    }

    public static Block getBlock(Set<Block> work) {
        Iterator<Block> i = work.iterator();
        Block b = i.next();
        i.remove();
        return b;
    }

    public static Expr getExpr(ExprWorkQueue work) {
        return work.remove();
    }

    public static Edge getEdge(Set<Edge> work) {
        Iterator<Edge> i = work.iterator();
        Edge e = i.next();
        i.remove();
        return e;
    }

    public static Method getMethod(List<Method> list) {
        return list.remove(list.size() - 1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TopologicalSort<T> {
        public List<T> toplogicalSort(List<T> unsorted, DependencyChecker<T> checker) {
            HashMap dep = new HashMap(unsorted.size());
            for (T x : unsorted) {
                HashSet<T> parents = new HashSet<T>();
                dep.put(x, parents);
                for (T y : unsorted) {
                    if (x == y || !checker.depends(x, y)) continue;
                    if (checker.depends(y, x)) {
                        throw new IllegalArgumentException("Cyclical graphs can't be topologically sorted.");
                    }
                    parents.add(y);
                }
            }
            ArrayList sorted = new ArrayList(unsorted.size());
            while (dep.size() > 0) {
                boolean found_sorted_element = false;
                for (Object x : dep.keySet()) {
                    if (0 != ((Set)dep.get(x)).size()) continue;
                    sorted.add(x);
                    found_sorted_element = true;
                    for (T y : unsorted) {
                        if (!dep.containsKey(y)) continue;
                        ((Set)dep.get(y)).remove(x);
                    }
                    dep.remove(x);
                    break;
                }
                if (found_sorted_element) continue;
                throw new IllegalArgumentException("Cyclical graphs can't be topologically sorted.");
            }
            return sorted;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface DependencyChecker<T> {
            public boolean depends(T var1, T var2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExprWorkQueue {
        private Map<Expr, Link> m_links = new HashMap<Expr, Link>();
        private Link m_head = new Link(null);
        private Link m_tail = new Link(null);
        private EdgeMap<Expr> m_uses;

        public ExprWorkQueue(EdgeMap<Expr> uses) {
            this.m_uses = uses;
            this.m_head.m_next = this.m_tail;
            this.m_tail.m_prev = this.m_head;
        }

        public void add(Expr e) {
            if (!this.m_links.containsKey(e)) {
                Link newLink = new Link(e);
                HashSet<Expr> uses = new HashSet<Expr>();
                for (Expr a : this.m_uses.get(e)) {
                    if (!this.m_links.containsKey(a)) continue;
                    uses.add(a);
                }
                this.m_links.put(e, newLink);
                if (uses.size() == 1) {
                    Link user = this.m_links.get(uses.iterator().next());
                    newLink.insert(user);
                } else {
                    Link l = this.m_tail;
                    while (!uses.isEmpty()) {
                        l = l.m_prev;
                        uses.remove(l.m_e);
                    }
                    assert (l != this.m_head);
                    newLink.insert(l);
                }
            }
        }

        public void addAll(Collection<Expr> c) {
            for (Expr e : c) {
                this.add(e);
            }
        }

        public Expr remove() {
            Link l = this.m_head.m_next;
            assert (l != this.m_tail);
            assert (l.m_e != null);
            l.remove();
            this.m_links.remove(l.m_e);
            return l.m_e;
        }

        public boolean isEmpty() {
            return this.m_links.size() == 0;
        }

        static class Link {
            public Expr m_e;
            public Link m_next;
            public Link m_prev;

            public Link(Expr e) {
                this.m_e = e;
            }

            public void insert(Link before) {
                this.m_next = before;
                this.m_prev = before.m_prev;
                before.m_prev.m_next = this;
                before.m_prev = this;
            }

            public void remove() {
                this.m_prev.m_next = this.m_next;
                this.m_next.m_prev = this.m_prev;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Pool<T extends Comparable<?>> {
        private final Map<T, Integer> refs = new HashMap<T, Integer>();
        private ArrayList<T> m_values;
        int countFrom;
        private final Policy<T> m_policy;
        private final Comparator<T> m_comparator;

        private Comparator<T> defaultComparator() {
            return new Comparator<T>(){

                @Override
                public int compare(T a, T b) {
                    return (Integer)Pool.this.refs.get(a) - (Integer)Pool.this.refs.get(b);
                }
            };
        }

        public static <T extends Comparable<?>> Policy<T> defaultPolicy(Class<T> unused) {
            return new Policy<T>(){

                @Override
                public boolean isValueForId0(T value) {
                    return value == null;
                }
            };
        }

        Pool(int countFrom, Comparator<T> comparator, Policy<T> policy) {
            this.countFrom = countFrom;
            this.m_comparator = comparator;
            this.m_policy = policy;
        }

        Pool(int countFrom) {
            this.countFrom = countFrom;
            this.m_comparator = this.defaultComparator();
            this.m_policy = Pool.defaultPolicy(null);
        }

        Pool(int countFrom, Comparator<T> comparator) {
            this.countFrom = countFrom;
            this.m_comparator = comparator;
            this.m_policy = Pool.defaultPolicy(null);
        }

        Pool(int countFrom, Policy<T> policy) {
            this(countFrom, null, policy);
        }

        int add(T e) {
            if (this.m_policy.isValueForId0(e)) {
                return 0;
            }
            int n = !this.refs.containsKey(e) ? 1 : this.refs.get(e) + 1;
            this.refs.put(e, n);
            return n;
        }

        void sort() {
            this.m_values = new ArrayList();
            if (!this.refs.isEmpty()) {
                Set<Comparable> keySet = this.refs.keySet();
                Object[] keySetArray = keySet.toArray();
                Comparable[] emptyArray = (Comparable[])Array.newInstance(keySetArray[0].getClass(), 0);
                Comparable[] valuesArray = keySet.toArray(emptyArray);
                Arrays.sort(valuesArray, this.m_comparator);
                int i = this.countFrom;
                for (Comparable item : valuesArray) {
                    this.m_values.add(item);
                    this.refs.put(item, i++);
                }
            }
        }

        int id(T e) {
            if (this.m_policy.isValueForId0(e)) {
                return 0;
            }
            assert (this.refs.containsKey(e));
            assert (this.refs.get(e) < this.size());
            return this.refs.get(e);
        }

        public String toString() {
            return String.valueOf(this.refs);
        }

        int size() {
            return this.countFrom + this.refs.size();
        }

        List<T> values() {
            return Collections.unmodifiableList(this.m_values);
        }

        String refsString() {
            return this.refs.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class Ranker<T>
        implements Comparable<Ranker<T>> {
            T value;
            int rank;

            Ranker(T value, int rank) {
                this.value = value;
                this.rank = rank;
            }

            @Override
            public int compareTo(Ranker<T> o) {
                return o.rank - this.rank;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Policy<T extends Comparable<?>> {
            public boolean isValueForId0(T var1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LinkedDeque<E>
    extends LinkedList<E>
    implements Deque<E> {
        public static final long serialVersionUID = 0L;

        @Override
        public E peekFirst() {
            return this.isEmpty() ? null : (E)this.getFirst();
        }

        @Override
        public E peekLast() {
            return this.isEmpty() ? null : (E)this.getLast();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ArrayDeque<E>
    extends ArrayList<E>
    implements Deque<E> {
        public static final long serialVersionUID = 0L;

        public ArrayDeque() {
        }

        public ArrayDeque(Collection<E> c) {
            this.addAll(c);
        }

        @Override
        public void addFirst(E e) {
            this.add(0, e);
        }

        @Override
        public E removeFirst() {
            return this.remove(0);
        }

        @Override
        public E peekFirst() {
            return this.isEmpty() ? null : (E)this.get(0);
        }

        @Override
        public E removeLast() {
            return this.remove(this.size() - 1);
        }

        @Override
        public E peekLast() {
            return this.isEmpty() ? null : (E)this.get(this.size() - 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Deque<E>
    extends List<E> {
        @Override
        public E removeFirst();

        public E peekFirst();

        @Override
        public E removeLast();

        public E peekLast();

        @Override
        public void addFirst(E var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EdgeMap<E>
    extends SetMap<E, E> {
        static final long serialVersionUID = 0L;

        @Override
        public Set<E> get(E e) {
            return super.get(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetMap<K, V>
    extends TreeMap<K, Set<V>> {
        static final long serialVersionUID = 0L;

        @Override
        public Set<V> get(K e) {
            TreeSet s = (TreeSet)super.get(e);
            if (s == null) {
                s = new TreeSet();
                this.put(e, s);
            }
            return s;
        }
    }
}

