/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.io;

import com.ctc.wstx.util.StringUtil;
import java.io.OutputStreamWriter;
import java.io.Writer;

/*
 * Exception performing whole class analysis ignored.
 */
public final class CharsetNames {
    public static final String CS_US_ASCII = "US-ASCII";
    public static final String CS_UTF8 = "UTF-8";
    public static final String CS_UTF16 = "UTF-16";
    public static final String CS_UTF16BE = "UTF-16BE";
    public static final String CS_UTF16LE = "UTF-16LE";
    public static final String CS_UTF32 = "UTF-32";
    public static final String CS_UTF32BE = "UTF-32BE";
    public static final String CS_UTF32LE = "UTF-32LE";
    public static final String CS_ISO_LATIN1 = "ISO-8859-1";
    public static final String CS_SHIFT_JIS = "Shift_JIS";
    public static final String CS_EBCDIC_SUBSET = "IBM037";

    /*
     * Enabled aggressive block sorting
     */
    public static String normalize(String csName) {
        char d;
        if (csName == null) return csName;
        if (csName.length() < 3) {
            return csName;
        }
        boolean gotCsPrefix = false;
        char c = csName.charAt(0);
        if (!(c != 'c' && c != 'C' || (d = csName.charAt(1)) != 's' && d != 'S')) {
            csName = csName.substring(2);
            c = csName.charAt(0);
            gotCsPrefix = true;
        }
        switch (c) {
            case 'A': 
            case 'a': {
                if (!StringUtil.equalEncodings((String)csName, (String)"ASCII")) return csName;
                return "US-ASCII";
            }
            case 'C': 
            case 'c': {
                if (StringUtil.encodingStartsWith((String)csName, (String)"cp")) {
                    return "IBM" + StringUtil.trimEncoding((String)csName, (boolean)true).substring(2);
                }
                if (!StringUtil.encodingStartsWith((String)csName, (String)"cs")) return csName;
                if (!StringUtil.encodingStartsWith((String)csName, (String)"csIBM")) return csName;
                return StringUtil.trimEncoding((String)csName, (boolean)true).substring(2);
            }
            case 'E': 
            case 'e': {
                String type;
                if (!csName.startsWith("EBCDIC-CP-")) {
                    if (!csName.startsWith("ebcdic-cp-")) return csName;
                }
                if ((type = StringUtil.trimEncoding((String)csName, (boolean)true).substring(8)).equals("US")) return "IBM037";
                if (type.equals("CA")) return "IBM037";
                if (type.equals("WT")) return "IBM037";
                if (type.equals("NL")) {
                    return "IBM037";
                }
                if (type.equals("DK")) return "IBM277";
                if (type.equals("NO")) {
                    return "IBM277";
                }
                if (type.equals("FI")) return "IBM278";
                if (type.equals("SE")) {
                    return "IBM278";
                }
                if (type.equals("ROECE")) return "IBM870";
                if (type.equals("YU")) {
                    return "IBM870";
                }
                if (type.equals("IT")) {
                    return "IBM280";
                }
                if (type.equals("ES")) {
                    return "IBM284";
                }
                if (type.equals("GB")) {
                    return "IBM285";
                }
                if (type.equals("FR")) {
                    return "IBM297";
                }
                if (type.equals("AR1")) {
                    return "IBM420";
                }
                if (type.equals("AR2")) {
                    return "IBM918";
                }
                if (type.equals("HE")) {
                    return "IBM424";
                }
                if (type.equals("CH")) {
                    return "IBM500";
                }
                if (!type.equals("IS")) return "IBM037";
                return "IBM871";
            }
            case 'I': 
            case 'i': {
                if (StringUtil.equalEncodings((String)csName, (String)"ISO-8859-1")) return "ISO-8859-1";
                if (StringUtil.equalEncodings((String)csName, (String)"ISO-Latin1")) {
                    return "ISO-8859-1";
                }
                if (!StringUtil.encodingStartsWith((String)csName, (String)"ISO-10646")) {
                    if (!StringUtil.encodingStartsWith((String)csName, (String)"IBM")) return csName;
                    return csName;
                }
                int ix = csName.indexOf("10646");
                String suffix = csName.substring(ix + 5);
                if (StringUtil.equalEncodings((String)suffix, (String)"UCS-Basic")) {
                    return "US-ASCII";
                }
                if (StringUtil.equalEncodings((String)suffix, (String)"Unicode-Latin1")) {
                    return "ISO-8859-1";
                }
                if (StringUtil.equalEncodings((String)suffix, (String)"UCS-2")) {
                    return "UTF-16";
                }
                if (StringUtil.equalEncodings((String)suffix, (String)"UCS-4")) {
                    return "UTF-32";
                }
                if (StringUtil.equalEncodings((String)suffix, (String)"UTF-1")) {
                    return "US-ASCII";
                }
                if (StringUtil.equalEncodings((String)suffix, (String)"J-1")) {
                    return "US-ASCII";
                }
                if (!StringUtil.equalEncodings((String)suffix, (String)"US-ASCII")) return csName;
                return "US-ASCII";
            }
            case 'J': 
            case 'j': {
                if (!StringUtil.equalEncodings((String)csName, (String)"JIS_Encoding")) return csName;
                return "Shift_JIS";
            }
            case 'S': 
            case 's': {
                if (!StringUtil.equalEncodings((String)csName, (String)"Shift_JIS")) return csName;
                return "Shift_JIS";
            }
            case 'U': 
            case 'u': {
                if (csName.length() < 2) {
                    return csName;
                }
                switch (csName.charAt(1)) {
                    case 'C': 
                    case 'c': {
                        if (StringUtil.equalEncodings((String)csName, (String)"UCS-2")) {
                            return "UTF-16";
                        }
                        if (!StringUtil.equalEncodings((String)csName, (String)"UCS-4")) return csName;
                        return "UTF-32";
                    }
                    case 'N': 
                    case 'n': {
                        if (!gotCsPrefix) return csName;
                        if (StringUtil.equalEncodings((String)csName, (String)"Unicode")) {
                            return "UTF-16";
                        }
                        if (StringUtil.equalEncodings((String)csName, (String)"UnicodeAscii")) {
                            return "ISO-8859-1";
                        }
                        if (!StringUtil.equalEncodings((String)csName, (String)"UnicodeAscii")) return csName;
                        return "US-ASCII";
                    }
                    case 'S': 
                    case 's': {
                        if (!StringUtil.equalEncodings((String)csName, (String)"US-ASCII")) return csName;
                        return "US-ASCII";
                    }
                    case 'T': 
                    case 't': {
                        if (StringUtil.equalEncodings((String)csName, (String)"UTF-8")) {
                            return "UTF-8";
                        }
                        if (StringUtil.equalEncodings((String)csName, (String)"UTF-16BE")) {
                            return "UTF-16BE";
                        }
                        if (StringUtil.equalEncodings((String)csName, (String)"UTF-16LE")) {
                            return "UTF-16LE";
                        }
                        if (StringUtil.equalEncodings((String)csName, (String)"UTF-16")) {
                            return "UTF-16";
                        }
                        if (StringUtil.equalEncodings((String)csName, (String)"UTF-32BE")) {
                            return "UTF-32BE";
                        }
                        if (StringUtil.equalEncodings((String)csName, (String)"UTF-32LE")) {
                            return "UTF-32LE";
                        }
                        if (StringUtil.equalEncodings((String)csName, (String)"UTF-32")) {
                            return "UTF-32";
                        }
                        if (!StringUtil.equalEncodings((String)csName, (String)"UTF")) return csName;
                        return "UTF-16";
                    }
                }
                return csName;
            }
        }
        return csName;
    }

    public static String findEncodingFor(Writer w) {
        if (w instanceof OutputStreamWriter) {
            String enc = ((OutputStreamWriter)w).getEncoding();
            return CharsetNames.normalize((String)enc);
        }
        return null;
    }
}

