/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io.stream;

import com.adobe.internal.io.ByteReader;
import com.adobe.internal.io.ByteWriter;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class StreamDatabase {
    private Map inputStreamData = new HashMap();
    private Map outputStreamData = new HashMap();
    private ByteReader masterByteReader;
    private long maxOBS;
    private boolean lenientMasterByteReader = false;
    private boolean ignoreRemoveOnNonexistentReader = false;
    private boolean ignoreRemoveOnNonexistentWriter = false;

    StreamDatabase(ByteReader byteReader, boolean bl, boolean bl2, boolean bl3) {
        this.lenientMasterByteReader = bl;
        this.ignoreRemoveOnNonexistentReader = bl2;
        this.ignoreRemoveOnNonexistentWriter = bl3;
        this.initMasterByteReader(byteReader);
    }

    ByteReader resetMasterByteReader(ByteReader byteReader) throws IOException {
        ByteReader byteReader2 = this.masterByteReader;
        StreamData streamData = (StreamData)this.inputStreamData.get(this.masterByteReader);
        if (streamData != null && streamData.getReferences() != 0L && !this.lenientMasterByteReader) {
            throw new RuntimeException("Closing master ByteReader with open streams.");
        }
        if (byteReader2 != null) {
            this.inputStreamData.remove(byteReader2);
            try {
                byteReader2.close();
            }
            catch (IOException iOException) {
                IOException iOException2 = new IOException("Unable to close master ByteReader: " + byteReader2);
                iOException2.initCause(iOException);
                throw iOException2;
            }
        }
        this.initMasterByteReader(byteReader);
        return byteReader2;
    }

    private void initMasterByteReader(ByteReader byteReader) {
        this.masterByteReader = byteReader;
        if (this.masterByteReader != null) {
            StreamData streamData = new StreamData();
            this.inputStreamData.put(this.masterByteReader, streamData);
        }
    }

    boolean addIBS(InputByteStream inputByteStream, ByteReader byteReader) {
        boolean bl = false;
        StreamData streamData = (StreamData)this.inputStreamData.get(byteReader);
        if (streamData == null) {
            streamData = new StreamData();
            this.inputStreamData.put(byteReader, streamData);
            bl = true;
        }
        streamData.addReference();
        return bl;
    }

    boolean removeIBS(InputByteStream inputByteStream, ByteReader byteReader) {
        boolean bl = true;
        StreamData streamData = (StreamData)this.inputStreamData.get(byteReader);
        if (streamData == null) {
            if (!this.ignoreRemoveOnNonexistentReader) {
                throw new RuntimeException("Closing an InputByteStream that isn't in the stream database.");
            }
        } else {
            bl = streamData.removeReference();
            if (bl) {
                this.inputStreamData.remove(byteReader);
            }
        }
        return bl;
    }

    boolean addOBS(OutputByteStream outputByteStream, ByteWriter byteWriter) {
        boolean bl = false;
        StreamData streamData = (StreamData)this.outputStreamData.get(byteWriter);
        if (streamData == null) {
            streamData = new StreamData();
            this.outputStreamData.put(byteWriter, streamData);
            bl = true;
            ++this.maxOBS;
        }
        streamData.addReference();
        return bl;
    }

    boolean removeOBS(OutputByteStream outputByteStream, ByteWriter byteWriter) {
        boolean bl = true;
        StreamData streamData = (StreamData)this.outputStreamData.get(byteWriter);
        if (streamData == null) {
            if (!this.ignoreRemoveOnNonexistentWriter) {
                throw new RuntimeException("Closing an OutputByteStream that isn't in the stream database.");
            }
        } else {
            bl = streamData.removeReference();
            if (bl) {
                this.outputStreamData.remove(byteWriter);
            }
        }
        return bl & !this.inputStreamData.containsKey(byteWriter);
    }

    boolean isOutputEmpty() {
        return this.outputStreamData.isEmpty();
    }

    boolean isInputEmpty() {
        return this.inputStreamData.isEmpty();
    }

    boolean isEmpty() {
        return this.isInputEmpty() && this.isOutputEmpty();
    }

    int getOutputCount() {
        return this.outputStreamData.size();
    }

    int getInputCount() {
        return this.inputStreamData.size();
    }

    int getCount() {
        return this.getOutputCount() + this.getInputCount();
    }

    public String toString() {
        StreamData streamData;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Open ByteReader = " + this.getInputCount() + "\n");
        stringBuffer.append("Open ByteWriter = " + this.getOutputCount() + "\n");
        stringBuffer.append("======== ByteReaders\n");
        for (Object k : this.inputStreamData.keySet()) {
            stringBuffer.append("ByteReader = " + k.toString() + "\n");
            streamData = (StreamData)this.inputStreamData.get(k);
            stringBuffer.append(streamData.toString());
        }
        stringBuffer.append("======== ByteWriters\n");
        for (Object k : this.outputStreamData.keySet()) {
            stringBuffer.append("ByteWriter = " + k.toString() + "\n");
            streamData = (StreamData)this.outputStreamData.get(k);
            stringBuffer.append(streamData.toString());
        }
        return stringBuffer.toString();
    }

    int closeAllOpen(boolean bl) throws IOException {
        int n = this.closeAllOpenReaders(bl);
        return n += this.closeAllOpenWriters(bl);
    }

    private int closeAllOpenReaders(boolean bl) throws IOException {
        int n = 0;
        Set set = this.inputStreamData.keySet();
        n += set.size();
        for (ByteReader byteReader : set) {
            if (bl && byteReader == this.masterByteReader) continue;
            try {
                byteReader.close();
            }
            catch (IOException iOException) {
                IOException iOException2 = new IOException("Unable to close ByteReader: " + byteReader);
                iOException2.initCause(iOException);
                throw iOException2;
            }
        }
        this.inputStreamData.clear();
        return n;
    }

    private int closeAllOpenWriters(boolean bl) throws IOException {
        int n = 0;
        Set set = this.outputStreamData.keySet();
        n += set.size();
        for (ByteWriter byteWriter : set) {
            if (bl && byteWriter == this.masterByteReader) continue;
            try {
                byteWriter.close();
            }
            catch (IOException iOException) {
                IOException iOException2 = new IOException("Unable to close  ByteWriter: " + byteWriter);
                iOException2.initCause(iOException);
                throw iOException2;
            }
        }
        this.outputStreamData.clear();
        return n;
    }

    private static class StreamData {
        private long references;
        private long maxReferences;
        private String stackTrace;

        public long getReferences() {
            return this.references;
        }

        public long getMaxReferences() {
            return this.maxReferences;
        }

        public void addReference() {
            ++this.references;
            ++this.maxReferences;
        }

        public boolean removeReference() {
            --this.references;
            if (this.references < 0L) {
                throw new RuntimeException("Stream closed and not removed from stream database.");
            }
            return this.references == 0L;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Number of open references = " + this.getReferences() + "\n");
            stringBuffer.append("Number of max references = " + this.getMaxReferences() + "\n");
            stringBuffer.append("Originally created = \n" + this.stackTrace + "\n");
            return stringBuffer.toString();
        }
    }
}

