/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.semantics;

import macromedia.asc.embedding.ErrorConstants;
import macromedia.asc.embedding.avmplus.ClassBuilder;
import macromedia.asc.embedding.avmplus.InstanceBuilder;
import macromedia.asc.semantics.FlowAnalyzer;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.ParameterizedName;
import macromedia.asc.semantics.Slot;
import macromedia.asc.semantics.TypeInfo;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.BitSet;
import macromedia.asc.util.Context;
import macromedia.asc.util.Namespaces;
import macromedia.asc.util.ObjectList;

public final class ReferenceValue
extends Value
implements ErrorConstants {
    private ObjectValue base;
    private int get_slot_index;
    private int set_method_slot_index;
    private BitSet ud_bits;
    private TypeInfo type;
    private int src_position;
    public Slot slot;
    public String name;
    public Namespaces namespaces;
    public ObjectList<ReferenceValue> type_params;
    public boolean is_nullable = true;
    public boolean has_nullable_anno = false;

    public void setPosition(int pos) {
        this.src_position = pos;
    }

    public int getPosition() {
        return this.src_position;
    }

    public ReferenceValue(Context cx, ObjectValue base, String name, ObjectValue qualifier) {
        this(cx, base, name, qualifier, -79);
    }

    public ReferenceValue(Context cx, ObjectValue base, String name, ObjectValue qualifier, int kind) {
        this.setKind(kind);
        this.base = base;
        assert (name.intern() == name);
        this.name = name;
        this.setQualified(qualifier != null);
        this.setGetSlotIndex(-1);
        this.setSetSlotIndex(-1);
        this.setScopeIndex(-1);
        this.namespaces = cx.statics.internNamespaces.intern(qualifier);
    }

    public ReferenceValue(Context cx, ObjectValue base, String name, Namespaces namespaces) {
        this(cx, base, name, namespaces, -79);
    }

    public ReferenceValue(Context cx, ObjectValue base, String name, Namespaces namespaces, int kind) {
        this.setKind(kind);
        this.base = base;
        assert (name.intern() == name);
        this.name = name;
        this.namespaces = cx.statics.internNamespaces.intern(namespaces);
        this.slot = null;
        this.setGetSlotIndex(-1);
        this.setSetSlotIndex(-1);
        this.setScopeIndex(-1);
        this.ud_bits = null;
        this.type = null;
    }

    public void setIsAttributeIdentifier(boolean is_attrid) {
        this.flags = is_attrid ? this.flags | 0x10 : this.flags & 0xFFFFFFEF;
    }

    public boolean isAttributeIdentifier() {
        return (this.flags & 0x10) != 0;
    }

    public Value getValue(Context cx) {
        Slot s = this.getSlot(cx, this.getKind());
        if (s != null && s.getMethodID() < 0) {
            return s.getValue();
        }
        return null;
    }

    public TypeInfo getType(Context cx) {
        return this.getType(cx, this.getKind());
    }

    public TypeInfo getType(Context cx, int kind) {
        if (this.type == null) {
            TypeValue tv;
            TypeInfo slottype = null;
            TypeInfo deftype = cx.getDefType(this.ud_bits);
            Slot s = this.getSlot(cx, kind);
            if (s != null) {
                slottype = s.getType();
            }
            if (slottype == null) {
                slottype = cx.noType().getDefaultTypeInfo();
            }
            this.type = slottype.getTypeValue().includes(cx, deftype != null ? deftype.getTypeValue() : null) ? ((tv = slottype.getTypeValue()).isNumeric(cx) || tv == cx.noType() ? slottype : deftype) : slottype;
            if (this.type == null) {
                this.type = cx.noType().getDefaultTypeInfo();
            }
        }
        return this.type;
    }

    public Slot getSlot(Context cx) {
        return this.getSlot(cx, -79);
    }

    public Slot getSlot(Context cx, int kind) {
        if (this.slot == null) {
            if (this.isAttributeIdentifier()) {
                return null;
            }
            this.setKind(kind == -99 ? -99 : -79);
            if (this.lookup(cx, this.flags)) {
                if (kind == this.getKind()) {
                    return this.slot;
                }
            } else if (kind != -79) {
                return null;
            }
        }
        Slot slot = this.slot;
        if (this.getKind() != kind) {
            ObjectValue base;
            if (this.base != null) {
                base = this.base;
            } else if (this.getScopeIndex() >= 0) {
                base = (ObjectValue)cx.getScopes().get(this.getScopeIndex());
            } else {
                return null;
            }
            switch (kind) {
                case -99: {
                    this.slot = slot = base.getSlot(cx, this.getSetSlotIndex());
                    this.setKind(-99);
                    break;
                }
                case -79: {
                    this.slot = slot = base.getSlot(cx, this.getGetSlotIndex());
                    this.setKind(-79);
                    break;
                }
                default: {
                    this.slot = slot = base.getSlot(cx, this.getGetSlotIndex());
                    this.setKind(-79);
                    if (slot == null) break;
                    int index = slot.implies(cx, kind);
                    slot = base.getSlot(cx, index);
                }
            }
            if (slot != null && cx.checkVersion() && slot.getVersion() > cx.version()) {
                cx.error(this.src_position, 1214, this.name, String.valueOf(slot.getVersion()), String.valueOf(cx.version()));
            }
        }
        return slot;
    }

    public boolean lookup(Context cx, int flags) {
        boolean is_found = false;
        if (this.base == null) {
            ObjectList<ObjectValue> scopes = cx.getScopes();
            int lowestScope = this.isTypeAnnotation() ? 0 : cx.statics.withDepth + 1;
            for (int i = scopes.size() - 1; i >= lowestScope; --i) {
                this.base = scopes.at(i);
                is_found = this.lookupWithBase(cx, flags);
                if (!is_found) continue;
                this.setScopeIndex(i);
                break;
            }
            this.base = null;
        } else {
            is_found = this.lookupWithBase(cx, flags);
        }
        return is_found;
    }

    public boolean lookupWithBase(Context cx, int flags) {
        if (!this.isQualified()) {
            return this.findUnqualified(cx, flags);
        }
        return this.findQualified(cx, flags);
    }

    public boolean findQualified(Context cx, int flags) {
        int size = this.namespaces.size();
        for (int i = 0; i < size; ++i) {
            ObjectValue qualifier = (ObjectValue)this.namespaces.get(i);
            for (ObjectValue obj = this.base; obj != null; obj = obj.proto()) {
                if (!obj.hasName(cx, this.getKind(), this.name, qualifier)) continue;
                if (this.type_params != null) {
                    int index = obj.getSlotIndex(cx, this.getKind(), this.name, qualifier);
                    Slot slot = obj.getSlot(cx, index);
                    this.bindToTypeParamSlot(cx, obj, qualifier, slot);
                } else {
                    this.bindToSlot(cx, obj, qualifier);
                }
                return true;
            }
        }
        return false;
    }

    public boolean findUnqualified(Context cx, int flags) {
        Namespaces hasNamespaces = null;
        for (ObjectValue obj = this.base; obj != null; obj = obj.proto()) {
            int i;
            int opposite_kind;
            Namespaces hasNamespaces2;
            hasNamespaces = obj.hasNames(cx, this.getKind(), this.name, this.namespaces);
            if (hasNamespaces == null) continue;
            ObjectValue localQualifier = null;
            boolean error_reported = false;
            if ((this.getKind() == -99 || this.getKind() == -79) && (hasNamespaces2 = obj.hasNames(cx, opposite_kind = this.getKind() == -99 ? -79 : -99, this.name, this.namespaces)) != null) {
                for (i = 0; i < hasNamespaces2.size(); ++i) {
                    localQualifier = (ObjectValue)hasNamespaces2.at(i);
                    if (error_reported || hasNamespaces.contains(localQualifier)) continue;
                    cx.error(this.src_position, 1000, this.name);
                    error_reported = true;
                    break;
                }
            }
            int last_index = 0;
            Slot slot = null;
            for (i = 0; i < hasNamespaces.size(); ++i) {
                localQualifier = (ObjectValue)hasNamespaces.at(i);
                int index = obj.getSlotIndex(cx, this.getKind(), this.name, localQualifier);
                slot = obj.getSlot(cx, index);
                if (slot == null || slot.getBaseNode() != null) continue;
                if (last_index != 0 && index != last_index && !error_reported) {
                    cx.error(this.src_position, 1000, this.name);
                    error_reported = true;
                }
                last_index = index;
            }
            if (this.type_params != null) {
                this.bindToTypeParamSlot(cx, obj, localQualifier, slot);
            } else {
                this.bindToSlot(cx, obj, localQualifier);
            }
            hasNamespaces.clear();
            return true;
        }
        return false;
    }

    private void bindToTypeParamSlot(Context cx, ObjectValue obj, ObjectValue qualifier, Slot s) {
        if (s.getValue() instanceof TypeValue) {
            TypeValue factory = (TypeValue)s.getValue();
            ObjectList<TypeValue> types = new ObjectList<TypeValue>(this.type_params.size());
            int limit = this.type_params.size();
            for (int i = 0; i < limit; ++i) {
                ReferenceValue r = this.type_params.at(i);
                Slot type_slot = r.getSlot(cx);
                if (type_slot != null) {
                    Value v = type_slot.getValue();
                    if (v instanceof TypeValue) {
                        types.add((TypeValue)v);
                    }
                } else if ("*".equals(r.name) && r.namespaces.contains(cx.publicNamespace())) {
                    types.add(cx.noType());
                }
                if (types.size() == i + 1) continue;
                this.slot = null;
                return;
            }
            if (factory.is_parameterized) {
                ParameterizedName fullname = new ParameterizedName(qualifier, this.name, types);
                String name = fullname.getNamePart();
                if (!obj.hasName(cx, -79, name, qualifier)) {
                    int slot_id = obj.builder.ImplicitVar(cx, obj, name, qualifier, cx.typeType(), -1, -1, -1);
                    TypeValue cframe = null;
                    if (factory.types != null && factory.types.containsKey(name)) {
                        Slot instaniated = factory.types.get(name);
                        cframe = (TypeValue)instaniated.getValue();
                    } else {
                        ObjectValue iframe;
                        ObjectValue prot_ns = cx.getNamespace(fullname.toString(), (byte)3);
                        ObjectValue static_prot_ns = cx.getNamespace(fullname.toString(), (byte)5);
                        cframe = new TypeValue(cx, new ClassBuilder(fullname, prot_ns, static_prot_ns), fullname, 8192);
                        cframe.type = cx.typeType().getDefaultTypeInfo();
                        cframe.prototype = iframe = new ObjectValue(cx, new InstanceBuilder(fullname), cframe);
                        FlowAnalyzer.inheritClassSlotsStatic(cframe, iframe, cx.vectorObjType(), cx);
                    }
                    Slot slot = obj.getSlot(cx, slot_id);
                    slot.setValue(cframe);
                    slot.setConst(true);
                    slot.declaredBy = null;
                    obj.builder.ImplicitCall(cx, obj, slot_id, cframe, 16, -1, -1);
                    obj.builder.ImplicitConstruct(cx, obj, slot_id, cframe, 16, -1, -1);
                    factory.addParameterizedTypeSlot(cx, name, slot);
                    if (factory == cx.vectorType()) {
                        cframe.indexed_type = types.at(0);
                    }
                } else {
                    int slot_id = obj.getSlotIndex(cx, -79, name, qualifier);
                    Slot slot = obj.getSlot(cx, slot_id);
                }
                this.bindToSlot(cx, name, obj, fullname.ns);
            } else {
                cx.internalError("type parameters with a non-parameterized type");
            }
        }
    }

    private void bindToSlot(Context cx, ObjectValue obj, ObjectValue qualifier) {
        this.bindToSlot(cx, this.name, obj, qualifier);
    }

    private void bindToSlot(Context cx, String name, ObjectValue obj, ObjectValue qualifier) {
        boolean isXMLProperty;
        int set_slot_index = obj.getSlotIndex(cx, -99, name, qualifier);
        int get_slot_index = obj.getSlotIndex(cx, -79, name, qualifier);
        int method_slot_index = obj.getSlotIndex(cx, -133, name, qualifier);
        this.setGetSlotIndex(get_slot_index);
        if (method_slot_index != -1) {
            this.setMethodSlotIndex(method_slot_index);
        } else {
            this.setSetSlotIndex(set_slot_index);
        }
        this.slot = obj.getSlot(cx, obj.getSlotIndex(cx, this.getKind(), name, qualifier));
        if (cx.checkVersion() && this.slot.getVersion() > cx.version()) {
            cx.error(this.src_position, 1214, this.name, String.valueOf(this.slot.getVersion()), String.valueOf(cx.version()));
        }
        boolean bl = isXMLProperty = this.slot != null && this.slot.declaredBy != null && this.slot.declaredBy.type != null && (this.slot.declaredBy.type.getTypeValue() == cx.xmlType() || this.slot.declaredBy.type.getTypeValue() == cx.xmlListType());
        if (cx.useStaticSemantics() && !isXMLProperty && this.type_params == null) {
            this.setQualifier(cx, qualifier);
        }
    }

    public void calcUseDefinitions(Context cx, BitSet rch_bits) {
        Slot slot;
        this.getSlot(cx, -79);
        if (this.getGetSlotIndex() < 0) {
            return;
        }
        if (this.base != null && this.base.getType(cx).getTypeValue() == cx.noType() && this.getGetSlotIndex() >= 0) {
            slot = this.base.getSlot(cx, this.getGetSlotIndex());
        } else if (this.getScopeIndex() == 0 && this.getGetSlotIndex() >= 0) {
            slot = cx.globalScope().getSlot(cx, this.getGetSlotIndex());
        } else if (this.getScopeIndex() == cx.getScopes().size() - 1) {
            slot = cx.scope().getSlot(cx, this.getGetSlotIndex());
        } else {
            return;
        }
        if (slot != null) {
            this.ud_bits = BitSet.and(rch_bits, slot.getDefBits());
        }
    }

    public boolean usedBeforeInitialized() {
        return BitSet.isEmpty(this.ud_bits);
    }

    public int getSlotIndex(int kind) {
        if (kind == -79) {
            return this.getGetSlotIndex();
        }
        if (kind == -99) {
            return this.getSetSlotIndex();
        }
        if (kind == -133) {
            return this.getMethodSlotIndex();
        }
        assert (false);
        return -1;
    }

    public int getScopeIndex(int kind) {
        return this.getScopeIndex();
    }

    public ReferenceValue setBase(ObjectValue base) {
        this.base = base;
        return this;
    }

    public ObjectValue getBase() {
        return this.base;
    }

    public boolean isReference() {
        return true;
    }

    public void setQualifier(Context cx, ObjectValue qual) {
        this.setQualified(qual != null);
        this.namespaces = cx.statics.internNamespaces.intern(qual);
    }

    public String toMultiName() {
        return this.namespaces.toString() + "::" + this.name;
    }

    public boolean isQualified() {
        return (this.flags & 4) != 0;
    }

    private void setQualified(boolean qualified) {
        this.flags = qualified ? this.flags | 4 : this.flags & 0xFFFFFFFB;
    }

    public String toString() {
        return super.toString();
    }

    public void setImmutableNamespaces(Namespaces namespaces) {
        this.namespaces = namespaces;
    }

    public Namespaces getImmutableNamespaces() {
        return this.namespaces;
    }

    public void setScopeIndex(int scope_index) {
        this.flags &= 0xFFFF;
        this.flags |= scope_index << 16 & 0xFFFF0000;
    }

    public int getScopeIndex() {
        short i = (short)((this.flags & 0xFFFF0000) >> 16);
        return i;
    }

    public void setKind(int kind) {
        this.flags &= 0xFFFF00FF;
        this.flags |= kind << 8 & 0xFF00;
    }

    public int getKind() {
        byte b = (byte)((this.flags & 0xFF00) >> 8);
        return b;
    }

    private void setGetSlotIndex(int get_slot_index) {
        this.get_slot_index = get_slot_index;
    }

    private int getGetSlotIndex() {
        return this.get_slot_index;
    }

    private void setMethodSlotIndex(int method_slot_index) {
        this.flags |= 2;
        this.set_method_slot_index = method_slot_index;
    }

    private int getMethodSlotIndex() {
        return (this.flags & 2) != 0 ? this.set_method_slot_index : -1;
    }

    private void setSetSlotIndex(int set_slot_index) {
        this.flags &= 0xFFFFFFFD;
        this.set_method_slot_index = set_slot_index;
    }

    private int getSetSlotIndex() {
        return (this.flags & 2) != 0 ? -1 : this.set_method_slot_index;
    }

    public void setTypeAnnotation(boolean isTypeAnnotation) {
        this.flags = isTypeAnnotation ? this.flags | 0x20 : this.flags & 0xFFFFFFDF;
    }

    public boolean isTypeAnnotation() {
        return (this.flags & 0x20) != 0;
    }

    public void setNullableAnnotation(boolean is_explicit, boolean is_nullable) {
        this.has_nullable_anno = is_explicit;
        this.is_nullable = is_nullable;
    }

    public boolean isConfigRef() {
        return this.getImmutableNamespaces() != null && this.getImmutableNamespaces().size() == 1 && ((ObjectValue)this.getImmutableNamespaces().at(0)).isConfigNS();
    }

    public void addTypeParam(ReferenceValue type) {
        if (this.type_params == null) {
            this.type_params = new ObjectList(1);
        }
        this.type_params.add(type);
    }

    public String getDiagnosticTypeName() {
        if (null == this.type_params || this.type_params.size() == 0) {
            return this.name;
        }
        return this.type_params.at(0).getDiagnosticTypeName();
    }
}

