/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.crmf;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.asn1.UTF8StringContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.crmf.CRMFException;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Vector;

public class RegInfo
implements Cloneable,
Serializable {
    public static final byte[] REG_INFO_OID = new byte[]{43, 6, 1, 5, 5, 7, 5, 2, 1};
    private String a = null;
    private Vector b = new Vector();
    protected int special;
    protected ASN1Template asn1Template = null;

    public RegInfo() {
    }

    public RegInfo(String string, String string2) throws CRMFException {
        this.addNameValuePair(string, string2, false);
    }

    public RegInfo(byte[] byArray, int n2, int n3) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("RegInfo Encoding is null.");
        }
        this.special = n3;
        try {
            OfContainer ofContainer = new OfContainer(n3, 12288, new EncodedContainer(12288));
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
            int n4 = ofContainer.getContainerCount();
            for (int i2 = 0; i2 < n4; ++i2) {
                ASN1Container aSN1Container = ofContainer.containerAt(i2);
                SequenceContainer sequenceContainer = new SequenceContainer(0);
                EndContainer endContainer = new EndContainer();
                OIDContainer oIDContainer = new OIDContainer(0x1000000);
                UTF8StringContainer uTF8StringContainer = new UTF8StringContainer(0);
                ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{sequenceContainer, oIDContainer, uTF8StringContainer, endContainer};
                ASN1.berDecode(aSN1Container.data, aSN1Container.dataOffset, aSN1ContainerArray2);
                byte[] byArray2 = new byte[oIDContainer.dataLen];
                System.arraycopy(oIDContainer.data, oIDContainer.dataOffset, byArray2, 0, oIDContainer.dataLen);
                if (!CertJUtils.byteArraysEqual(byArray2, REG_INFO_OID)) {
                    throw new CRMFException("Wrong OID");
                }
                if (uTF8StringContainer.data == null) continue;
                this.a = new String(uTF8StringContainer.data, uTF8StringContainer.dataOffset, uTF8StringContainer.dataLen);
                this.b.addElement(this.a);
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Cannot read the BER of the regInfo." + aSN_Exception.getMessage());
        }
    }

    public void addNameValuePair(String string, String string2, boolean bl2) throws CRMFException {
        if (string == null || string2 == null) {
            throw new CRMFException("Passed in RegInfo values are null.");
        }
        this.a = new String(URLEncoder.encode(string));
        this.a = this.a.concat("?");
        this.a = this.a.concat(URLEncoder.encode(string2));
        this.a = this.a.concat("%");
        if (!bl2 && this.b.size() != 0) {
            String string3 = (String)this.b.lastElement();
            this.b.removeElement(string3);
            this.a = string3 = string3.concat(this.a);
        }
        this.b.addElement(this.a);
        this.a = null;
    }

    public String getAttribute(int n2) throws CRMFException {
        if (this.getRegInfoCount() > n2) {
            return (String)this.b.elementAt(n2);
        }
        throw new CRMFException("The specified RegInfo index is invalid.");
    }

    public int getRegInfoCount() {
        return this.b.size();
    }

    public static int getNextBEROffset(byte[] byArray, int n2) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("RegInfo Encoding is null.");
        }
        if (byArray[n2] == 0 && byArray[n2 + 1] == 0) {
            return n2 + 2;
        }
        try {
            return n2 + 1 + ASN1Lengths.determineLengthLen(byArray, n2 + 1) + ASN1Lengths.determineLength(byArray, n2 + 1);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Unable to determine length of the RegInfo BER" + aSN_Exception.getMessage());
        }
    }

    public int getDERLen(int n2) throws CRMFException {
        return this.a(n2);
    }

    public int getDEREncoding(byte[] byArray, int n2, int n3) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("Specified RegInfo array is null.");
        }
        int n4 = 0;
        try {
            if (this.asn1Template == null || this.special != n3) {
                this.getDERLen(n3);
            }
            n4 = this.asn1Template.derEncode(byArray, n2);
            this.asn1Template = null;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            throw new CRMFException("Unable to encode RegInfo." + aSN_Exception.getMessage());
        }
        return n4;
    }

    private int a(int n2) throws CRMFException {
        this.special = n2;
        Vector<OfContainer> vector = new Vector<OfContainer>();
        try {
            OfContainer ofContainer = new OfContainer(n2, true, 0, 12288, new EncodedContainer(12288));
            vector.addElement(ofContainer);
            int n3 = 0;
            if (this.b != null) {
                n3 = this.b.size();
            }
            for (int i2 = 0; i2 < n3; ++i2) {
                this.a = (String)this.b.elementAt(i2);
                byte[] byArray = this.a.getBytes();
                SequenceContainer sequenceContainer = new SequenceContainer(n2, true, 0);
                EndContainer endContainer = new EndContainer();
                OIDContainer oIDContainer = new OIDContainer(0x1000000, true, 0, REG_INFO_OID, 0, REG_INFO_OID.length);
                UTF8StringContainer uTF8StringContainer = new UTF8StringContainer(0, true, 0, byArray, 0, byArray.length);
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, uTF8StringContainer, endContainer};
                this.asn1Template = new ASN1Template(aSN1ContainerArray);
                int n4 = this.asn1Template.derEncodeInit();
                byte[] byArray2 = new byte[n4];
                n4 = this.asn1Template.derEncode(byArray2, 0);
                EncodedContainer encodedContainer = new EncodedContainer(0, true, 0, byArray2, 0, n4);
                ofContainer.addContainer(encodedContainer);
            }
            Object[] objectArray = new ASN1Container[vector.size()];
            vector.copyInto(objectArray);
            this.asn1Template = new ASN1Template((ASN1Container[])objectArray);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException(aSN_Exception.getMessage());
        }
    }

    public boolean equals(Object object) {
        int n2;
        if (object == null || !(object instanceof RegInfo)) {
            return false;
        }
        RegInfo regInfo = (RegInfo)object;
        int n3 = this.b.size();
        if (n3 != (n2 = regInfo.b.size())) {
            return false;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            if (this.b.elementAt(i2).equals(regInfo.b.elementAt(i2))) continue;
            return false;
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        RegInfo regInfo = new RegInfo();
        regInfo.b = (Vector)this.b.clone();
        try {
            if (this.asn1Template != null) {
                regInfo.a(this.special);
            }
        }
        catch (CRMFException cRMFException) {
            throw new CloneNotSupportedException(cRMFException.getMessage());
        }
        return regInfo;
    }
}

