/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.ipa;

import com.adobe.air.InvalidInputException;
import com.adobe.air.Listener;
import com.adobe.air.SDKDamagedException;
import com.adobe.air.Utils;
import com.adobe.air.ipa.ProcessError;
import com.adobe.air.ipa.SWFUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AOTCompiler {
    public static final String MAC_X86_LIB_PATH = "/Developer/SDKs/MacOSX10.5.sdk";
    private static final byte[] m_emptyABC = new byte[]{16, 0, 46, 0, 0, 0, 0, 2, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 1, 1, 1, 2, 3, -48, 48, 71, 0, 0};
    private InputStream m_swfStream = null;
    private File m_strippedSWFFile = null;
    private Vector<File> m_abcFiles = new Vector();
    private File m_bitcodeFile = null;
    private File m_finalBCFile = null;
    private File m_optBCFile = null;
    private File m_asmFile = null;
    private File m_macOFile = null;
    private File m_macExe = null;
    private String m_baseName = "AOT";
    private String m_targetArch = "arm";
    private boolean m_verbose = false;
    private boolean m_debugger = false;
    private File m_tempFolder = null;
    private File m_outputFolder = null;
    private String m_captiveSdkRoot = null;
    private String m_optLevel = null;
    private int m_currStep;
    private int m_totalSteps;
    private static final Map<String, List<String>> m_archToLLCOptions = AOTCompiler.getArchToLLCOptions();
    private static final Map<String, List<String>> m_archToASMOptions = AOTCompiler.getArchToASMOptions();
    private boolean m_compressSWF = false;
    private HashMap<String, String> m_tools = new HashMap();
    private Listener m_listener;

    private static Map<String, List<String>> getArchToLLCOptions() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        result.put("arm", new ArrayList());
        return result;
    }

    private static Map<String, List<String>> getArchToASMOptions() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        result.put("arm", Arrays.asList("-arch", "armv6"));
        return result;
    }

    public void setListener(Listener listener) {
        this.m_listener = listener;
    }

    public AOTCompiler(String targetArc, InputStream swfFile, String AOTSdkDir, String outputPath, String optLevel, boolean verbose, boolean compressSWF, boolean debugger) throws IOException {
        this.m_swfStream = swfFile;
        this.m_targetArch = targetArc;
        this.m_verbose = verbose;
        this.m_debugger = debugger;
        this.m_outputFolder = new File(outputPath);
        this.m_captiveSdkRoot = AOTSdkDir;
        this.m_optLevel = optLevel;
        this.m_tempFolder = File.createTempFile("aot", null, this.m_outputFolder);
        this.m_tempFolder.delete();
        this.m_tempFolder.mkdirs();
        this.m_compressSWF = compressSWF;
        String osName = System.getProperty("os.name");
        if (osName.indexOf("Mac") != -1) {
            this.m_tools.put("strip", AOTSdkDir + "/bin/strip/strip");
            this.m_tools.put("as", AOTSdkDir + "/bin/as/arm-apple-darwin9-as");
            this.m_tools.put("ld64", AOTSdkDir + "/bin/ld64/i686-apple-darwin9-ld64");
            this.m_tools.put("llvm-link", AOTSdkDir + "/bin/llvm-link");
            this.m_tools.put("llvm-ld", AOTSdkDir + "/bin/llvm-ld");
            this.m_tools.put("llc", AOTSdkDir + "/bin/llc");
            this.m_tools.put("opt", AOTSdkDir + "/bin/opt");
            this.m_tools.put("java", "/usr/bin/java");
        } else if (osName.indexOf("Windows") != -1) {
            this.m_tools.put("strip", AOTSdkDir + "/bin/strip/strip.exe");
            this.m_tools.put("as", AOTSdkDir + "/bin/as/arm-apple-darwin9-as.exe");
            this.m_tools.put("ld64", AOTSdkDir + "/bin/ld64/i686-apple-darwin9-ld64.exe");
            this.m_tools.put("llvm-link", AOTSdkDir + "/bin/llvm-link.exe");
            this.m_tools.put("llvm-ld", AOTSdkDir + "/bin/llvm-ld.exe");
            this.m_tools.put("llc", AOTSdkDir + "/bin/llc.exe");
            this.m_tools.put("opt", AOTSdkDir + "/bin/opt.exe");
            this.m_tools.put("java", "java.exe");
        } else {
            throw new UnsupportedOperationException("Functionality not supported on : " + osName);
        }
        this.m_tools.put("go", AOTSdkDir + "/lib/go.jar");
        this.m_tools.put("asc", AOTSdkDir + "/lib/asc.jar");
        this.m_tools.put("builtin", AOTSdkDir + "/lib/builtin.abc");
        this.m_tools.put("avmglue", AOTSdkDir + "/lib/avmglue.abc");
        this.m_tools.put("bitcode.api", AOTSdkDir + "/lib/bitcode.api.txt");
        this.m_tools.put("aotcompiler", AOTSdkDir + "/lib/AOTCompiler." + this.m_targetArch + "-air.bc");
        this.m_tools.put("libaot", AOTSdkDir + "/lib/libAOTCompiler." + this.m_targetArch + "-air.bc.a");
        this.m_tools.put("libavmplus", AOTSdkDir + "/lib/libavmplus." + this.m_targetArch + "-air.bc.a");
        this.m_tools.put("libmmgc", AOTSdkDir + "/lib/libMMgc." + this.m_targetArch + "-air.bc.a");
        this.m_tools.put("libruntimeaot", AOTSdkDir + "/lib/libRuntimeAOT." + this.m_targetArch + "-air.a");
        this.m_tools.put("libdebugger", AOTSdkDir + "/lib/libDebugger." + this.m_targetArch + "-air.a");
        this.m_tools.put("libnodebugger", AOTSdkDir + "/lib/libNoDebugger." + this.m_targetArch + "-air.a");
    }

    public int launchProcess(List<String> cmdLine) throws IOException {
        int retCode = 1;
        try {
            if (this.m_verbose) {
                System.out.println("Launching process with cmd: ");
                System.out.println(cmdLine.toString());
            }
            ProcessBuilder builder = Utils.safeProcessBuilder(cmdLine);
            if (System.getProperty("os.name").indexOf("Windows") != -1) {
                builder.directory(this.m_tempFolder);
            }
            Process rProcess = builder.start();
            Utils.OutputEater consumeInput = new Utils.OutputEater(rProcess.getInputStream(), false, false);
            Utils.OutputEater consumeErr = new Utils.OutputEater(rProcess.getErrorStream(), this.m_verbose, false);
            consumeInput.start();
            consumeErr.start();
            retCode = rProcess.waitFor();
            consumeInput.join();
            consumeErr.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return retCode;
    }

    public File getNewTempFile(String path) throws IOException {
        File rFile = new File(this.m_tempFolder, path);
        if (rFile.exists()) {
            rFile.delete();
        }
        rFile.createNewFile();
        return rFile;
    }

    public int executeJarFile(String jarFileName, List<String> args, boolean verbose, String className) throws IOException {
        ArrayList<String> javaArgs = new ArrayList<String>();
        javaArgs.add(this.m_tools.get("java"));
        String dataModel = System.getProperty("sun.arch.data.model");
        if (dataModel.indexOf("64") != -1) {
            String osName = System.getProperty("os.name");
            if (osName.indexOf("Windows") != -1) {
                throw new IOException("Only x32 JVM supported");
            }
            javaArgs.add("-d32");
        }
        javaArgs.add("-Xms256m");
        javaArgs.add("-Xmx1024m");
        javaArgs.add("-ea");
        if (className == null) {
            javaArgs.add("-jar");
            javaArgs.add(jarFileName);
        } else {
            javaArgs.add("-classpath");
            javaArgs.add(jarFileName);
            javaArgs.add(className);
        }
        javaArgs.addAll(args);
        return this.launchProcess(javaArgs);
    }

    protected void convertSwfToAbc() throws InvalidInputException {
        try {
            FileOutputStream fop;
            File temp;
            SWFUtils util = new SWFUtils(this.m_swfStream, this.m_compressSWF);
            int index = 0;
            ListIterator<byte[]> iter = util.getABCs().listIterator();
            while (iter.hasNext()) {
                temp = this.getNewTempFile(this.m_baseName + "-" + index++ + ".abc");
                this.m_abcFiles.add(temp);
                fop = new FileOutputStream(temp);
                fop.write(iter.next());
                fop.flush();
                fop.close();
            }
            if (index == 0) {
                temp = this.getNewTempFile(this.m_baseName + "-" + index++ + ".abc");
                this.m_abcFiles.add(temp);
                fop = new FileOutputStream(temp);
                fop.write(m_emptyABC);
                fop.flush();
                fop.close();
            }
            this.m_strippedSWFFile = this.getNewTempFile(this.m_baseName + "-stripped.swf");
            util.exportToFile(this.m_strippedSWFFile);
        }
        catch (Exception e2) {
            throw new InvalidInputException("Invalid input. Not a valid swf file");
        }
    }

    protected void convertAbcToLlvmBitcode() throws IOException, ProcessError {
        this.m_bitcodeFile = this.getNewTempFile(this.m_baseName + ".bc");
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.m_tools.get("aotcompiler"));
        args.add(this.m_tools.get("builtin"));
        if (this.m_targetArch.equals("x86")) {
            args.add(this.m_tools.get("shell_toplevel"));
        } else {
            args.add(this.m_tools.get("avmglue"));
            args.add("-arm");
        }
        if (this.m_debugger) {
            args.add("-debugger");
        }
        args.add("-output");
        args.add(this.getPlatformPath(this.m_bitcodeFile));
        args.add("--");
        ListIterator<File> iter = this.m_abcFiles.listIterator();
        while (iter.hasNext()) {
            args.add(iter.next().getAbsolutePath());
        }
        int retCode = this.executeJarFile(this.m_tools.get("go"), args, false, "adobe.abc.LLVMEmitter");
        if (retCode != 0) {
            throw new ProcessError(this.m_tools.get("go"), "Unable to convert abc to llvm bit code", retCode);
        }
    }

    protected void linkBitcodeFiles() throws IOException, ProcessError {
        this.m_finalBCFile = this.getNewTempFile(this.m_baseName + "-01-linked.bc");
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.m_tools.get("llvm-ld"));
        args.add("-v");
        args.add("-o=" + this.getPlatformPath(this.m_finalBCFile));
        args.add("-link-as-library");
        args.add("-disable-opt");
        args.add(this.getPlatformPath(this.m_bitcodeFile));
        args.add(this.m_tools.get("libaot"));
        args.add(this.m_tools.get("libavmplus"));
        args.add(this.m_tools.get("libmmgc"));
        int retCode = this.launchProcess(args);
        if (retCode != 0) {
            throw new ProcessError(this.m_tools.get("llvm-ld"), "Unable to link runtime libraries with app bc", retCode);
        }
    }

    protected void optimizeBitcode() throws IOException, ProcessError {
        int retCode;
        File bitcode = this.m_finalBCFile;
        File newBitCode = null;
        ArrayList<String> args = new ArrayList<String>();
        if (this.m_optLevel != null) {
            newBitCode = this.getNewTempFile(this.m_baseName + "-03-opt-O" + this.m_optLevel + ".bc");
            args.add(this.m_tools.get("opt"));
            args.add("-O" + this.m_optLevel);
            args.add("-f");
            args.add("-o");
            args.add(this.getPlatformPath(newBitCode));
            args.add(this.getPlatformPath(bitcode));
            retCode = this.launchProcess(args);
            if (retCode != 0) {
                throw new ProcessError(this.m_tools.get("opt"), "Optimization step failed", retCode);
            }
            bitcode = newBitCode;
            args.clear();
        }
        newBitCode = this.getNewTempFile(this.m_baseName + "-02-opt-dce.bc");
        args.add(this.m_tools.get("opt"));
        args.add("-internalize-public-api-file=" + this.m_tools.get("bitcode.api"));
        args.add("-internalize");
        args.add("-globaldce");
        args.add("-adce");
        args.add("-f");
        args.add("-o");
        args.add(this.getPlatformPath(newBitCode));
        args.add(this.getPlatformPath(bitcode));
        bitcode = newBitCode;
        retCode = this.launchProcess(args);
        if (retCode != 0) {
            throw new ProcessError(this.m_tools.get("opt"), "Optimization step failed", retCode);
        }
        args.clear();
        newBitCode = this.getNewTempFile(this.m_baseName + "-04-eh.bc");
        args.add(this.m_tools.get("opt"));
        args.add("-enable-correct-eh-support");
        args.add("-lowerinvoke");
        args.add("-f");
        args.add("-o");
        args.add(this.getPlatformPath(newBitCode));
        args.add(this.getPlatformPath(bitcode));
        retCode = this.launchProcess(args);
        if (retCode != 0) {
            throw new ProcessError(this.m_tools.get("opt"), "Optimization step failed", retCode);
        }
        this.m_optBCFile = newBitCode;
    }

    protected void compileBitcode() throws IOException, ProcessError {
        int retCode;
        this.m_asmFile = this.getNewTempFile(this.m_baseName + ".asm");
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.m_tools.get("llc"));
        args.add("-disable-fp-elim");
        args.add("-march");
        args.add(this.m_targetArch);
        args.addAll((Collection)m_archToLLCOptions.get(this.m_targetArch));
        args.add("-f");
        args.add("-o");
        args.add(this.getPlatformPath(this.m_asmFile));
        args.add(this.getPlatformPath(this.m_optBCFile));
        if (this.m_optLevel == null) {
            args.add("-fast-isel");
        }
        if ((retCode = this.launchProcess(args)) == 0) {
            args.clear();
            this.m_macOFile = this.getNewTempFile(this.m_baseName + ".o");
            args.add(this.m_tools.get("as"));
            args.addAll((Collection<String>)m_archToASMOptions.get(this.m_targetArch));
            args.add("-o");
            args.add(this.getPlatformPath(this.m_macOFile));
            args.add(this.getPlatformPath(this.m_asmFile));
            retCode = this.launchProcess(args);
        }
        if (retCode != 0) {
            throw new ProcessError(this.m_tools.get("llc"), "Compilation to MachO failed", retCode);
        }
    }

    protected void linkMachO() throws IOException, ProcessError {
        this.m_macExe = File.createTempFile("aot", null, this.m_outputFolder);
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.m_tools.get("ld64"));
        args.add("-Z");
        args.add("-F" + this.m_captiveSdkRoot + "/stub");
        args.add("-L" + this.m_captiveSdkRoot + "/lib");
        args.add("-L" + this.m_captiveSdkRoot + "/lib/gcc");
        args.add("-L" + this.m_captiveSdkRoot + "/stub");
        args.add("-o");
        args.add(this.getPlatformPath(this.m_macExe));
        args.add("-arch");
        args.add(this.m_targetArch);
        args.add(this.getPlatformPath(this.m_macOFile));
        args.add("-ObjC");
        args.add("-exported_symbol");
        args.add("_main");
        args.add("-dead_strip");
        if (this.m_debugger) {
            args.add(this.m_tools.get("libdebugger"));
        } else {
            args.add(this.m_tools.get("libnodebugger"));
        }
        if (this.m_targetArch.equals("arm")) {
            args.add("-sectcreate");
            args.add("__TEXT");
            args.add("__ic");
            args.add(this.getPlatformPath(this.m_strippedSWFFile));
            args.add("-lstdc++.6");
            args.add("-lcrt1.o");
            args.add("-lgcc_s.1");
            args.add("-lgcc");
            args.add("-lSystem.B");
            args.add("-lz");
            args.add("-framework");
            args.add("CoreFoundation");
            args.add("-framework");
            args.add("UIKit");
            args.add("-framework");
            args.add("CoreGraphics");
            args.add("-framework");
            args.add("Foundation");
            args.add("-lobjc");
            args.add("-framework");
            args.add("SystemConfiguration");
            args.add("-framework");
            args.add("AudioToolbox");
            args.add("-framework");
            args.add("CFNetwork");
            args.add("-framework");
            args.add("QuartzCore");
            args.add("-framework");
            args.add("OpenGLES");
            args.add("-framework");
            args.add("CoreLocation");
            args.add(this.m_tools.get("libruntimeaot"));
        } else {
            args.add("-macosx_version_min");
            args.add("10.5.6");
            args.add("-lstdc++");
            args.add("-lcrt3.o");
            args.add("-lcrt1.10.5.o");
            args.add("-lgcc_s.10.5");
            args.add("-lgcc");
            args.add("-lSystem.B_debug");
            args.add("-lz");
            args.add("-framework");
            args.add("CoreServices");
        }
        int retCode = this.launchProcess(args);
        if (retCode != 0) {
            throw new ProcessError(this.m_tools.get("ld64"), "Unable to generate executable", retCode);
        }
    }

    protected void stripExeSymbols() throws IOException, ProcessError {
        if (this.m_verbose) {
            System.out.println("Stripping symbols.");
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.m_tools.get("strip"));
        args.add("-x");
        args.add("-r");
        args.add(this.getPlatformPath(this.m_macExe));
        int retCode = this.launchProcess(args);
        if (retCode != 0) {
            throw new ProcessError(this.m_tools.get("strip"), "Unable to strip symbols from executable", retCode);
        }
    }

    public void ValidateAOTSDK() throws SDKDamagedException {
        for (String filePath : this.m_tools.values()) {
            File tmpFile;
            if (filePath.indexOf(this.m_captiveSdkRoot) < 0 || (tmpFile = new File(filePath)).exists()) continue;
            throw new SDKDamagedException(filePath);
        }
    }

    public void GenerateMacBinary(boolean withSymbols) throws IOException, InvalidInputException, SDKDamagedException {
        try {
            this.m_totalSteps = withSymbols ? 6 : 7;
            this.m_currStep = 0;
            this.ValidateAOTSDK();
            this.convertSwfToAbc();
            this.reportProgress();
            this.convertAbcToLlvmBitcode();
            this.reportProgress();
            this.linkBitcodeFiles();
            this.reportProgress();
            this.optimizeBitcode();
            this.reportProgress();
            this.compileBitcode();
            this.reportProgress();
            this.linkMachO();
            this.reportProgress();
            if (!withSymbols) {
                this.stripExeSymbols();
                this.reportProgress();
            }
            if (this.m_verbose) {
                System.out.println("Successfully created IPA");
            }
        }
        catch (ProcessError e2) {
            if (this.m_verbose) {
                e2.printStackTrace();
            }
            throw new InvalidInputException("Invalid input swf. Error executing : " + e2.getProcessName());
        }
        finally {
            if (!this.m_verbose) {
                Utils.deleteAll(this.m_tempFolder);
            }
        }
    }

    private String getPlatformPath(File file) {
        if (System.getProperty("os.name").indexOf("Windows") != -1) {
            if (file.getPath().indexOf(this.m_tempFolder.getPath()) != -1) {
                return file.getName();
            }
            if (file.getPath().indexOf(this.m_outputFolder.getPath()) != -1) {
                return "../" + file.getName();
            }
            throw new IllegalArgumentException("Could not relativize path");
        }
        return file.getPath();
    }

    private void reportProgress() {
        int percentDone = (int)((float)(++this.m_currStep) / ((float)this.m_totalSteps + 1.0f) * 100.0f);
        if (this.m_listener != null) {
            this.m_listener.progress(percentDone, 100);
        }
    }

    public File getExecutable() {
        return this.m_macExe;
    }
}

