/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import com.adobe.air.Listener;
import com.adobe.air.Message;
import com.adobe.air.validator.ApplicationDescriptorValidationException;
import com.adobe.air.validator.ApplicationDescriptorValidator;
import com.adobe.air.validator.ApplicationDescriptorValidator10;
import com.adobe.air.validator.ApplicationDescriptorValidator20;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Descriptor {
    private static final String NAMESPACE_1_0 = "http://ns.adobe.com/air/application/1.0";
    private static final String NAMESPACE_1_1 = "http://ns.adobe.com/air/application/1.1";
    private static final String NAMESPACE_1_5 = "http://ns.adobe.com/air/application/1.5";
    private static final String NAMESPACE_1_5_1 = "http://ns.adobe.com/air/application/1.5.1";
    private static final String NAMESPACE_1_5_2 = "http://ns.adobe.com/air/application/1.5.2";
    private static final String NAMESPACE_1_5_3 = "http://ns.adobe.com/air/application/1.5.3";
    private static final String NAMESPACE_2_0 = "http://ns.adobe.com/air/application/2.0";
    private static final Map<String, String> NAMESPACES;
    private ApplicationDescriptorValidationException _failureException = null;
    ApplicationDescriptorValidator _validator = null;
    private Document _document;
    private byte[] _descriptorBytes;
    private String _descriptorFileName = "Descriptor";

    public Descriptor(File descriptorFile) throws ApplicationDescriptorValidationException {
        this(descriptorFile, true);
    }

    public Descriptor(InputStream in) throws ApplicationDescriptorValidationException {
        this(in, true);
    }

    public Descriptor(File descriptorFile, boolean validate) throws ApplicationDescriptorValidationException {
        this.setInput(descriptorFile);
        if (validate) {
            this.validateXML();
        }
    }

    public Descriptor(InputStream in, boolean validate) throws ApplicationDescriptorValidationException {
        this.setInput(in);
        if (validate) {
            this.validateXML();
        }
    }

    private void setInput(File descriptorFile) throws ApplicationDescriptorValidationException {
        if (descriptorFile == null) {
            throw new IllegalArgumentException("set null descriptor");
        }
        this._descriptorFileName = descriptorFile.getPath();
        try {
            FileInputStream in = new FileInputStream(descriptorFile);
            this.setInput(in);
            ((InputStream)in).close();
        }
        catch (IOException e2) {
            this.dispatchError(301);
        }
    }

    private void setInput(InputStream in) throws ApplicationDescriptorValidationException {
        try {
            byte[] bytes = new byte[in.available()];
            in.read(bytes);
            this.setInput(bytes);
        }
        catch (IOException e2) {
            this.dispatchError(301);
        }
    }

    private void setInput(byte[] descriptorFileBytes) throws ApplicationDescriptorValidationException {
        this._descriptorBytes = descriptorFileBytes;
    }

    private void validateXML() throws ApplicationDescriptorValidationException {
        String validatorClassName;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        this._document = null;
        documentBuilderFactory.setNamespaceAware(true);
        try {
            builder = documentBuilderFactory.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException exception) throws SAXException {
                    throw exception;
                }

                public void fatalError(SAXParseException exception) throws SAXException {
                    throw exception;
                }

                public void warning(SAXParseException exception) throws SAXException {
                    throw exception;
                }
            });
            this._document = builder.parse(new ByteArrayInputStream(this._descriptorBytes));
        }
        catch (IOException e2) {
            this.dispatchError(301);
        }
        catch (SAXException e3) {
            this.dispatchError(100);
        }
        catch (ParserConfigurationException e4) {
            this.dispatchError(100);
        }
        String namespaceUri = this._document.getDocumentElement().getNamespaceURI();
        if (namespaceUri == null) {
            this.dispatchError(101, -1, -1, null);
        }
        if ((validatorClassName = NAMESPACES.get(namespaceUri)) == null) {
            this.dispatchError(102, -1, -1, new String[]{namespaceUri});
        }
        Class<?> validatorClass = null;
        try {
            validatorClass = Class.forName(validatorClassName);
            this._validator = (ApplicationDescriptorValidator)validatorClass.newInstance();
            this._validator.setDescriptorName(this._descriptorFileName);
            this._validator.setListener(new Listener(){

                public void message(Message message) {
                    if (Descriptor.this._failureException == null) {
                        Descriptor.this._failureException = new ApplicationDescriptorValidationException(message);
                    } else {
                        Descriptor.this._failureException.appendErrorMessage(message);
                    }
                }

                public void progress(int soFar, int total) {
                }
            });
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setNamespaceAware(true);
            SAXParser parser = null;
            parser = saxParserFactory.newSAXParser();
            parser.parse((InputStream)new ByteArrayInputStream(this._descriptorBytes), (DefaultHandler)this._validator);
            this.failIfError();
        }
        catch (ClassNotFoundException e5) {
            throw new RuntimeException("cannot load appropriate validator:'" + e5.getMessage() + "'");
        }
        catch (ApplicationDescriptorValidationException e6) {
            throw e6;
        }
        catch (IOException e7) {
            e7.printStackTrace();
            throw new RuntimeException(e7.getMessage());
        }
        catch (SAXException e8) {
            throw new RuntimeException(e8.getMessage());
        }
        catch (ParserConfigurationException e9) {
            throw new RuntimeException(e9.getMessage());
        }
        catch (InstantiationException e10) {
            throw new RuntimeException(e10.getMessage());
        }
        catch (IllegalAccessException e11) {
            throw new RuntimeException(e11.getMessage());
        }
    }

    private void failIfError() throws ApplicationDescriptorValidationException {
        if (this._failureException != null) {
            throw this._failureException;
        }
    }

    public void validateForAIRIPackaging(SortedMap<String, File> sources) throws ApplicationDescriptorValidationException {
        this.validateFiles(sources, true, true);
    }

    public void validateForAIRPackaging() throws ApplicationDescriptorValidationException {
        if (!(this.hasProfile("desktop") || this.hasProfile("mobileDevice") || this.hasProfile("extendedMobileDevice"))) {
            String profileList = "desktop, mobileDevice, or extendedMobileDevice";
            this.dispatchError(306, -1, -1, new String[]{profileList});
        }
    }

    public void validateForAIRPackaging(SortedMap<String, File> sources) throws ApplicationDescriptorValidationException {
        this.validateForAIRPackaging();
        this.validateFiles(sources, true, false);
    }

    public void validateForNativePackaging() throws ApplicationDescriptorValidationException {
        if (!(this._validator instanceof ApplicationDescriptorValidator20)) {
            this.dispatchError(307, -1, -1, new String[]{this.getVersionFromNamespace(NAMESPACE_2_0)});
        }
        if (!this.hasProfile("extendedDesktop")) {
            this.dispatchError(306, -1, -1, new String[]{"extendedDesktop"});
        }
    }

    public void validateForNativePackaging(SortedMap<String, File> sources) throws ApplicationDescriptorValidationException {
        this.validateForNativePackaging();
        this.validateFiles(sources, true, false);
    }

    public void validateForIPAPackaging() throws ApplicationDescriptorValidationException {
        if (!(this._validator instanceof ApplicationDescriptorValidator20)) {
            this.dispatchError(307, -1, -1, new String[]{this.getVersionFromNamespace(NAMESPACE_2_0)});
        }
        if (!this.hasProfile("mobileDevice")) {
            this.dispatchError(306, -1, -1, new String[]{"mobileDevice"});
        }
    }

    public void validateForIPAPackaging(SortedMap<String, File> sources) throws ApplicationDescriptorValidationException {
        this.validateForIPAPackaging();
        this.validateFiles(sources, false, true);
    }

    private void validateFiles(SortedMap<String, File> sources, boolean allowHTML, boolean allowCrushedPNG) throws ApplicationDescriptorValidationException {
        if (this._validator == null) {
            throw new IllegalStateException("Tried to validate a descriptor's files before its xml");
        }
        this.failIfError();
        TreeMap<String, File> validatorSources = new TreeMap<String, File>();
        validatorSources.putAll(sources);
        this._validator.validateRootContentFile(validatorSources, allowHTML);
        this.failIfError();
        this._validator.validateImageFiles(validatorSources, allowCrushedPNG);
        this.failIfError();
    }

    private boolean hasProfile(String profile) throws ApplicationDescriptorValidationException {
        if (this._validator instanceof ApplicationDescriptorValidator20) {
            return ((ApplicationDescriptorValidator20)this._validator).supportedProfiles().contains(profile);
        }
        return profile == "desktop";
    }

    public void validateIcon(InputStream is, String name, boolean allowCrushedPNG) throws ApplicationDescriptorValidationException {
        this._validator.validateImage(is, name, allowCrushedPNG);
        this.failIfError();
    }

    public void validateInitialContent(InputStream is, boolean allowHTML) throws ApplicationDescriptorValidationException {
        this._validator.validateRootContentFile(is, allowHTML);
        this.failIfError();
    }

    private void dispatchError(int code) throws ApplicationDescriptorValidationException {
        this.dispatchError(code, -1, -1, null);
    }

    private void dispatchError(int code, int line, int column, String[] identifiers) throws ApplicationDescriptorValidationException {
        throw new ApplicationDescriptorValidationException(new Message(code, "ERROR", this._descriptorFileName, line, column, identifiers));
    }

    public String filename() {
        return ((ApplicationDescriptorValidator10)this._validator).filename();
    }

    public String initialWindowTitle() {
        String value = ((ApplicationDescriptorValidator10)this._validator).initialWindowTitle();
        return value == null || value.length() == 0 ? this.name() : value;
    }

    public String name() {
        String value = ((ApplicationDescriptorValidator10)this._validator).name();
        return value == null || value.length() == 0 ? this.filename() : value;
    }

    public String id() {
        return ((ApplicationDescriptorValidator10)this._validator).id();
    }

    public String version() {
        return ((ApplicationDescriptorValidator10)this._validator).version();
    }

    public String copyright() {
        return ((ApplicationDescriptorValidator10)this._validator).copyright();
    }

    public Boolean visible() {
        return ((ApplicationDescriptorValidator10)this._validator).visible();
    }

    public String aspectRatio() {
        if (this._validator instanceof ApplicationDescriptorValidator20) {
            return ((ApplicationDescriptorValidator20)this._validator).aspectRatio();
        }
        return null;
    }

    public String renderMode() {
        if (this._validator instanceof ApplicationDescriptorValidator20) {
            return ((ApplicationDescriptorValidator20)this._validator).renderMode();
        }
        return null;
    }

    public Boolean autoOrients() {
        if (this._validator instanceof ApplicationDescriptorValidator20) {
            return ((ApplicationDescriptorValidator20)this._validator).autoOrients();
        }
        return null;
    }

    public Boolean fullscreen() {
        if (this._validator instanceof ApplicationDescriptorValidator20) {
            return ((ApplicationDescriptorValidator20)this._validator).fullScreen();
        }
        return null;
    }

    public String getIcon(int size) {
        return ((ApplicationDescriptorValidator10)this._validator).appIcons().get(size);
    }

    public Collection<String> appIcons() {
        return ((ApplicationDescriptorValidator10)this._validator).appIcons().values();
    }

    public Collection<String> icons() {
        return this._validator.getIcons();
    }

    public String initialContent() {
        return ((ApplicationDescriptorValidator10)this._validator).initialContent();
    }

    public String infoAdditions() {
        if (this._validator instanceof ApplicationDescriptorValidator20) {
            return ((ApplicationDescriptorValidator20)this._validator).infoAdditions();
        }
        return null;
    }

    public boolean migrationGracePeriodInEffect() {
        return this._validator.migrationGracePeriodInEffect();
    }

    public boolean usePackageSignatureForTimestamps() {
        boolean result = true;
        if (this._validator != null) {
            result = this._validator.usePackageSignatureForTimestamps();
        }
        return result;
    }

    public byte[] getBytes() {
        return this._descriptorBytes;
    }

    private String getVersionFromNamespace(String namespace) {
        return namespace.substring(namespace.lastIndexOf(47) + 1);
    }

    static {
        HashMap<String, String> tempMap = new HashMap<String, String>();
        tempMap.put(NAMESPACE_1_0, "com.adobe.air.validator.ApplicationDescriptorValidator10");
        tempMap.put(NAMESPACE_1_1, "com.adobe.air.validator.ApplicationDescriptorValidator11");
        tempMap.put(NAMESPACE_1_5, "com.adobe.air.validator.ApplicationDescriptorValidator15");
        tempMap.put(NAMESPACE_1_5_1, "com.adobe.air.validator.ApplicationDescriptorValidator151");
        tempMap.put(NAMESPACE_1_5_2, "com.adobe.air.validator.ApplicationDescriptorValidator152");
        tempMap.put(NAMESPACE_1_5_3, "com.adobe.air.validator.ApplicationDescriptorValidator153");
        tempMap.put(NAMESPACE_2_0, "com.adobe.air.validator.ApplicationDescriptorValidator20");
        NAMESPACES = Collections.unmodifiableMap(tempMap);
    }
}

